/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.attributes;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.Attribute;
import org.sonar.plugins.html.node.Node;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="IllegalAttributeCheck")
public class IllegalAttributeCheck
extends AbstractPageCheck {
    private static final String DEFAULT_ATTRIBUTES = "";
    @RuleProperty(key="attributes", description="Comma-separated list of tag.attributes that are not allowed. E.G. a.name forbids a \"name\" attribute in an \"a\" tag.", defaultValue="")
    public String attributes = "";
    private AbstractPageCheck.QualifiedAttribute[] attributesArray;

    @Override
    public void startDocument(List<Node> nodes) {
        this.attributesArray = this.parseAttributes(this.attributes);
    }

    @Override
    public void startElement(TagNode element) {
        for (Attribute a : this.getMatchingAttributes(element, this.attributesArray)) {
            this.createViolation(element.getStartLinePosition(), "Remove the \"" + a.getName() + "\" attribute from the \"" + element.getNodeName() + "\" tag");
        }
    }
}

