/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.dependencies;

import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.Attribute;
import org.sonar.plugins.html.node.DirectiveNode;
import org.sonar.plugins.html.node.Node;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="IllegalTagLibsCheck")
public class IllegalTagLibsCheck
extends AbstractPageCheck {
    private static final String DEFAULT_TAG_LIBS = "http://java.sun.com/jstl/sql";
    @RuleProperty(key="tagLibs", description="Comma-separated list of URIs of disallowed taglibs", defaultValue="http://java.sun.com/jstl/sql")
    public String tagLibs = "http://java.sun.com/jstl/sql";
    private String[] tagLibsArray;

    @Override
    public void startDocument(List<Node> nodes) {
        this.tagLibsArray = this.trimSplitCommaSeparatedList(this.tagLibs);
    }

    @Override
    public void startElement(TagNode node) {
        if ("jsp:directive.taglib".equalsIgnoreCase(node.getNodeName())) {
            this.checkIt(node, node.getAttribute("uri"));
        }
    }

    private void checkIt(Node node, @Nullable String uri) {
        if (uri == null || uri.isEmpty()) {
            return;
        }
        for (String tagLib : this.tagLibsArray) {
            if (!tagLib.equalsIgnoreCase(uri)) continue;
            this.createViolation(node.getStartLinePosition(), "Remove the use of \"" + tagLib + "\".");
        }
    }

    @Override
    public void directive(DirectiveNode node) {
        if ("taglib".equalsIgnoreCase(node.getNodeName())) {
            for (Attribute a : node.getAttributes()) {
                this.checkIt(node, a.getValue());
            }
        }
    }
}

