/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.header;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.Node;

@Rule(key="HeaderCheck")
public class HeaderCheck
extends AbstractPageCheck {
    private static final String DEFAULT_HEADER_FORMAT = "";
    private static final String MESSAGE = "Add or update the header of this file.";
    @RuleProperty(key="headerFormat", description="Expected copyright and license header (plain text)", defaultValue="", type="TEXT")
    public String headerFormat = "";
    @RuleProperty(key="isRegularExpression", description="Whether the headerFormat is a regular expression", defaultValue="false")
    public boolean isRegularExpression = false;
    private String[] expectedLines;
    private Pattern searchPattern = null;

    @Override
    public void init() {
        if (this.isRegularExpression) {
            try {
                this.searchPattern = Pattern.compile(this.headerFormat, 32);
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("[" + this.getClass().getSimpleName() + "] Unable to compile the regular expression: " + this.headerFormat, e);
            }
        } else {
            this.expectedLines = this.headerFormat.split("(?:\r)?\n|\r");
        }
    }

    @Override
    public void startDocument(List<Node> nodes) {
        String fileContent;
        try {
            fileContent = this.getHtmlSourceCode().inputFile().contents();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (this.isRegularExpression) {
            this.checkRegularExpression(fileContent);
        } else {
            HeaderLinesProcessor processor = new HeaderLinesProcessor(this.expectedLines);
            try (BufferedReader br = new BufferedReader(new StringReader(fileContent));){
                String line;
                List lines = br.lines().collect(Collectors.toList());
                Iterator iterator = lines.iterator();
                while (iterator.hasNext() && processor.processLine(line = (String)iterator.next())) {
                }
                if (!processor.getResult()) {
                    this.createViolation(0, MESSAGE);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private void checkRegularExpression(String fileContent) {
        Matcher matcher = this.searchPattern.matcher(fileContent);
        if (!matcher.find() || matcher.start() != 0) {
            this.createViolation(0, MESSAGE);
        }
    }

    private static class HeaderLinesProcessor {
        private boolean result = false;
        private int lineNumber = 0;
        private String[] expectedLines;

        HeaderLinesProcessor(String[] expectedLines) {
            this.expectedLines = expectedLines;
        }

        boolean processLine(String line) {
            ++this.lineNumber;
            if (this.lineNumber == 1) {
                this.result = true;
            }
            if (this.lineNumber > this.expectedLines.length) {
                return false;
            }
            if (line.equals(this.expectedLines[this.lineNumber - 1])) {
                return true;
            }
            this.result = false;
            return false;
        }

        boolean getResult() {
            return this.result && this.lineNumber >= this.expectedLines.length;
        }
    }
}

