/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanMultiTermQueryWrapper;
import org.apache.lucene.search.spans.SpanQuery;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.DocValueFetcher;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.RuntimeField;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.lookup.SearchLookup;

abstract class AbstractScriptFieldType<LeafFactory>
extends MappedFieldType
implements RuntimeField {
    protected final Script script;
    private final Function<SearchLookup, LeafFactory> factory;
    private final ToXContent toXContent;
    private static final Script DEFAULT_SCRIPT = new Script("");

    AbstractScriptFieldType(String name, Function<SearchLookup, LeafFactory> factory, Script script, Map<String, String> meta, ToXContent toXContent) {
        super(name, false, false, false, TextSearchInfo.SIMPLE_MATCH_WITHOUT_TERMS, meta);
        this.factory = factory;
        this.script = script;
        this.toXContent = toXContent;
    }

    @Override
    public final MappedFieldType asMappedFieldType() {
        return this;
    }

    @Override
    public final void doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.toXContent.toXContent(builder, params);
    }

    @Override
    public final boolean isSearchable() {
        return true;
    }

    @Override
    public final boolean isAggregatable() {
        return true;
    }

    @Override
    public final Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ShapeRelation relation, ZoneId timeZone, DateMathParser parser, SearchExecutionContext context) {
        if (relation == ShapeRelation.DISJOINT) {
            String message = "Runtime field [%s] of type [%s] does not support DISJOINT ranges";
            throw new IllegalArgumentException(String.format(Locale.ROOT, message, this.name(), this.typeName()));
        }
        return this.rangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, timeZone, parser, context);
    }

    protected abstract Query rangeQuery(Object var1, Object var2, boolean var3, boolean var4, ZoneId var5, DateMathParser var6, SearchExecutionContext var7);

    @Override
    public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions, SearchExecutionContext context) {
        throw new IllegalArgumentException(this.unsupported("fuzzy", "keyword and text"));
    }

    @Override
    public Query prefixQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, SearchExecutionContext context) {
        throw new IllegalArgumentException(this.unsupported("prefix", "keyword, text and wildcard"));
    }

    @Override
    public Query wildcardQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, SearchExecutionContext context) {
        throw new IllegalArgumentException(this.unsupported("wildcard", "keyword, text and wildcard"));
    }

    @Override
    public Query regexpQuery(String value, int syntaxFlags, int matchFlags, int maxDeterminizedStates, MultiTermQuery.RewriteMethod method, SearchExecutionContext context) {
        throw new IllegalArgumentException(this.unsupported("regexp", "keyword and text"));
    }

    @Override
    public Query phraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements) {
        throw new IllegalArgumentException(this.unsupported("phrase", "text"));
    }

    @Override
    public Query multiPhraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements) {
        throw new IllegalArgumentException(this.unsupported("phrase", "text"));
    }

    @Override
    public Query phrasePrefixQuery(TokenStream stream, int slop, int maxExpansions) {
        throw new IllegalArgumentException(this.unsupported("phrase prefix", "text"));
    }

    @Override
    public SpanQuery spanPrefixQuery(String value, SpanMultiTermQueryWrapper.SpanRewriteMethod method, SearchExecutionContext context) {
        throw new IllegalArgumentException(this.unsupported("span prefix", "text"));
    }

    private String unsupported(String query, String supported) {
        return String.format(Locale.ROOT, "Can only use %s queries on %s fields - not on [%s] which is a runtime field of type [%s]", query, supported, this.name(), this.typeName());
    }

    protected final void checkAllowExpensiveQueries(SearchExecutionContext context) {
        if (!context.allowExpensiveQueries()) {
            throw new ElasticsearchException("queries cannot be executed against runtime fields while [" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "] is set to [false].", new Object[0]);
        }
    }

    @Override
    public final ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
        return new DocValueFetcher(this.docValueFormat(format, null), (IndexFieldData<?>)context.getForField(this));
    }

    protected final LeafFactory leafFactory(SearchLookup searchLookup) {
        return this.factory.apply(searchLookup);
    }

    protected final LeafFactory leafFactory(SearchExecutionContext context) {
        return this.leafFactory(context.lookup().forkAndTrackFieldReferences(this.name()));
    }

    static <T> Function<FieldMapper, T> initializerNotSupported() {
        return mapper -> {
            throw new UnsupportedOperationException();
        };
    }

    static abstract class Builder<Factory>
    extends RuntimeField.Builder {
        private final ScriptContext<Factory> scriptContext;
        private final Factory parseFromSourceFactory;
        final FieldMapper.Parameter<Script> script = new FieldMapper.Parameter<Script>("script", true, () -> null, Builder::parseScript, AbstractScriptFieldType.initializerNotSupported()).setSerializerCheck((id, ic, v) -> ic);

        Builder(String name, ScriptContext<Factory> scriptContext, Factory parseFromSourceFactory) {
            super(name);
            this.scriptContext = scriptContext;
            this.parseFromSourceFactory = parseFromSourceFactory;
        }

        abstract RuntimeField newRuntimeField(Factory var1);

        @Override
        protected final RuntimeField createRuntimeField(Mapper.TypeParser.ParserContext parserContext) {
            if (this.script.get() == null) {
                return this.newRuntimeField(this.parseFromSourceFactory);
            }
            Factory factory = parserContext.scriptCompiler().compile(this.script.getValue(), this.scriptContext);
            return this.newRuntimeField(factory);
        }

        @Override
        protected List<FieldMapper.Parameter<?>> getParameters() {
            ArrayList parameters = new ArrayList(super.getParameters());
            parameters.add(this.script);
            return Collections.unmodifiableList(parameters);
        }

        protected final Script getScript() {
            if (this.script.get() == null) {
                return DEFAULT_SCRIPT;
            }
            return this.script.get();
        }

        private static Script parseScript(String name, Mapper.TypeParser.ParserContext parserContext, Object scriptObject) {
            Script script = Script.parse(scriptObject);
            if (script.getType() == ScriptType.STORED) {
                throw new IllegalArgumentException("stored scripts are not supported for runtime field [" + name + "]");
            }
            return script;
        }
    }
}

