/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.mapper.DynamicKeyFieldMapper;
import org.elasticsearch.index.mapper.DynamicKeyFieldTypeLookup;
import org.elasticsearch.index.mapper.FieldAliasMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.RuntimeField;
import org.elasticsearch.index.mapper.TypeFieldMapper;

final class FieldTypeLookup {
    private final Map<String, MappedFieldType> fullNameToFieldType = new HashMap<String, MappedFieldType>();
    private final Map<String, Set<String>> fieldToCopiedFields = new HashMap<String, Set<String>>();
    private final String type;
    private final DynamicKeyFieldTypeLookup dynamicKeyLookup;

    FieldTypeLookup(String type, Collection<FieldMapper> fieldMappers, Collection<FieldAliasMapper> fieldAliasMappers, Collection<RuntimeField> runtimeFields) {
        this.type = type;
        HashMap<String, DynamicKeyFieldMapper> dynamicKeyMappers = new HashMap<String, DynamicKeyFieldMapper>();
        for (FieldMapper fieldMapper : fieldMappers) {
            String fieldName = fieldMapper.name();
            MappedFieldType fieldType = fieldMapper.fieldType();
            this.fullNameToFieldType.put(fieldType.name(), fieldType);
            if (fieldMapper instanceof DynamicKeyFieldMapper) {
                dynamicKeyMappers.put(fieldName, (DynamicKeyFieldMapper)fieldMapper);
            }
            for (String targetField : fieldMapper.copyTo().copyToFields()) {
                Set<String> sourcePath = this.fieldToCopiedFields.get(targetField);
                if (sourcePath == null) {
                    HashSet<String> copiedFields = new HashSet<String>();
                    copiedFields.add(targetField);
                    this.fieldToCopiedFields.put(targetField, copiedFields);
                }
                this.fieldToCopiedFields.get(targetField).add(fieldName);
            }
        }
        HashMap<String, String> aliasToConcreteName = new HashMap<String, String>();
        for (FieldAliasMapper fieldAliasMapper : fieldAliasMappers) {
            String aliasName = fieldAliasMapper.name();
            String path = fieldAliasMapper.path();
            aliasToConcreteName.put(aliasName, path);
            this.fullNameToFieldType.put(aliasName, this.fullNameToFieldType.get(path));
        }
        for (RuntimeField runtimeField : runtimeFields) {
            MappedFieldType runtimeFieldType = runtimeField.asMappedFieldType();
            this.fullNameToFieldType.put(runtimeFieldType.name(), runtimeFieldType);
        }
        this.dynamicKeyLookup = new DynamicKeyFieldTypeLookup(dynamicKeyMappers, aliasToConcreteName);
    }

    MappedFieldType get(String field) {
        if (field.equals("_type")) {
            return new TypeFieldMapper.TypeFieldType(this.type);
        }
        MappedFieldType fieldType = this.fullNameToFieldType.get(field);
        if (fieldType != null) {
            return fieldType;
        }
        return this.dynamicKeyLookup.get(field);
    }

    Collection<MappedFieldType> get() {
        return this.fullNameToFieldType.values();
    }

    Set<String> simpleMatchToFullName(String pattern) {
        if (!Regex.isSimpleMatchPattern(pattern)) {
            return Collections.singleton(pattern);
        }
        HashSet<String> fields = new HashSet<String>();
        for (String field : this.fullNameToFieldType.keySet()) {
            if (!Regex.simpleMatch(pattern, field)) continue;
            fields.add(field);
        }
        return fields;
    }

    Set<String> sourcePaths(String field) {
        String parentField;
        if (this.fullNameToFieldType.isEmpty()) {
            return org.elasticsearch.common.collect.Set.of();
        }
        if (this.dynamicKeyLookup.get(field) != null) {
            return Collections.singleton(field);
        }
        String resolvedField = field;
        int lastDotIndex = field.lastIndexOf(46);
        if (lastDotIndex > 0 && this.fullNameToFieldType.containsKey(parentField = field.substring(0, lastDotIndex))) {
            resolvedField = parentField;
        }
        return this.fieldToCopiedFields.containsKey(resolvedField) ? this.fieldToCopiedFields.get(resolvedField) : org.elasticsearch.common.collect.Set.of((Object)resolvedField);
    }
}

