/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.tree.AssertStatement;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.Separators;
import org.sonar.python.tree.SimpleStatement;

public class AssertStatementImpl
extends SimpleStatement
implements AssertStatement {
    private final Token assertKeyword;
    private final Expression condition;
    @Nullable
    private final Expression message;
    private final Separators separators;

    public AssertStatementImpl(Token assertKeyword, Expression condition, @Nullable Expression message, Separators separators) {
        this.assertKeyword = assertKeyword;
        this.condition = condition;
        this.message = message;
        this.separators = separators;
    }

    @Override
    public Token assertKeyword() {
        return this.assertKeyword;
    }

    @Override
    public Expression condition() {
        return this.condition;
    }

    @Override
    @Nullable
    public Expression message() {
        return this.message;
    }

    @Override
    @Nullable
    public Token separator() {
        return this.separators.last();
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.ASSERT_STMT;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitAssertStatement(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(Arrays.asList(this.assertKeyword, this.condition, this.message), this.separators.elements()).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

