// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml and gl_angle_ext.xml.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// entry_points_gles_ext_autogen.cpp:
//   Defines the GLES extension entry points.

#include "libGLESv2/entry_points_gles_ext_autogen.h"

#include "common/entry_points_enum_autogen.h"
#include "libANGLE/Context.h"
#include "libANGLE/Context.inl.h"
#include "libANGLE/capture/capture_gles_ext_autogen.h"
#include "libANGLE/capture/gl_enum_utils.h"
#include "libANGLE/entry_points_utils.h"
#include "libANGLE/validationESEXT.h"
#include "libGLESv2/global_state.h"

using namespace gl;

#include "libANGLE/capture/capture_gles_1_0_autogen.h"
#include "libANGLE/capture/capture_gles_2_0_autogen.h"
#include "libANGLE/capture/capture_gles_3_0_autogen.h"
#include "libANGLE/capture/capture_gles_3_1_autogen.h"
#include "libANGLE/capture/capture_gles_3_2_autogen.h"
#include "libANGLE/validationES1.h"
#include "libANGLE/validationES2.h"
#include "libANGLE/validationES3.h"
#include "libANGLE/validationES31.h"
#include "libANGLE/validationES32.h"

using namespace gl;

extern "C" {

// GL_ANGLE_base_vertex_base_instance
void GL_APIENTRY GL_DrawArraysInstancedBaseInstanceANGLE(GLenum mode,
                                                         GLint first,
                                                         GLsizei count,
                                                         GLsizei instanceCount,
                                                         GLuint baseInstance)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawArraysInstancedBaseInstanceANGLE,
          "context = %d, mode = %s, first = %d, count = %d, instanceCount = %d, baseInstance = %u",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), first, count,
          instanceCount, baseInstance);

    if (context)
    {
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDrawArraysInstancedBaseInstanceANGLE(
                                context, modePacked, first, count, instanceCount, baseInstance));
        if (isCallValid)
        {
            context->drawArraysInstancedBaseInstance(modePacked, first, count, instanceCount,
                                                     baseInstance);
        }
        ANGLE_CAPTURE(DrawArraysInstancedBaseInstanceANGLE, isCallValid, context, modePacked, first,
                      count, instanceCount, baseInstance);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DrawElementsInstancedBaseVertexBaseInstanceANGLE(GLenum mode,
                                                                     GLsizei count,
                                                                     GLenum type,
                                                                     const GLvoid *indices,
                                                                     GLsizei instanceCounts,
                                                                     GLint baseVertex,
                                                                     GLuint baseInstance)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawElementsInstancedBaseVertexBaseInstanceANGLE,
          "context = %d, mode = %s, count = %d, type = %s, indices = 0x%016" PRIxPTR
          ", instanceCounts = %d, baseVertex = %d, baseInstance = %u",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, instanceCounts,
          baseVertex, baseInstance);

    if (context)
    {
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked                           = PackParam<DrawElementsType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDrawElementsInstancedBaseVertexBaseInstanceANGLE(
                                              context, modePacked, count, typePacked, indices,
                                              instanceCounts, baseVertex, baseInstance));
        if (isCallValid)
        {
            context->drawElementsInstancedBaseVertexBaseInstance(
                modePacked, count, typePacked, indices, instanceCounts, baseVertex, baseInstance);
        }
        ANGLE_CAPTURE(DrawElementsInstancedBaseVertexBaseInstanceANGLE, isCallValid, context,
                      modePacked, count, typePacked, indices, instanceCounts, baseVertex,
                      baseInstance);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultiDrawArraysInstancedBaseInstanceANGLE(GLenum mode,
                                                              const GLint *firsts,
                                                              const GLsizei *counts,
                                                              const GLsizei *instanceCounts,
                                                              const GLuint *baseInstances,
                                                              GLsizei drawcount)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiDrawArraysInstancedBaseInstanceANGLE,
          "context = %d, mode = %s, firsts = 0x%016" PRIxPTR ", counts = 0x%016" PRIxPTR
          ", instanceCounts = 0x%016" PRIxPTR ", baseInstances = 0x%016" PRIxPTR ", drawcount = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), (uintptr_t)firsts,
          (uintptr_t)counts, (uintptr_t)instanceCounts, (uintptr_t)baseInstances, drawcount);

    if (context)
    {
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMultiDrawArraysInstancedBaseInstanceANGLE(
                 context, modePacked, firsts, counts, instanceCounts, baseInstances, drawcount));
        if (isCallValid)
        {
            context->multiDrawArraysInstancedBaseInstance(modePacked, firsts, counts,
                                                          instanceCounts, baseInstances, drawcount);
        }
        ANGLE_CAPTURE(MultiDrawArraysInstancedBaseInstanceANGLE, isCallValid, context, modePacked,
                      firsts, counts, instanceCounts, baseInstances, drawcount);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY
GL_MultiDrawElementsInstancedBaseVertexBaseInstanceANGLE(GLenum mode,
                                                         const GLsizei *counts,
                                                         GLenum type,
                                                         const GLvoid *const *indices,
                                                         const GLsizei *instanceCounts,
                                                         const GLint *baseVertices,
                                                         const GLuint *baseInstances,
                                                         GLsizei drawcount)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiDrawElementsInstancedBaseVertexBaseInstanceANGLE,
          "context = %d, mode = %s, counts = 0x%016" PRIxPTR ", type = %s, indices = 0x%016" PRIxPTR
          ", instanceCounts = 0x%016" PRIxPTR ", baseVertices = 0x%016" PRIxPTR
          ", baseInstances = 0x%016" PRIxPTR ", drawcount = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), (uintptr_t)counts,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices,
          (uintptr_t)instanceCounts, (uintptr_t)baseVertices, (uintptr_t)baseInstances, drawcount);

    if (context)
    {
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked                           = PackParam<DrawElementsType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateMultiDrawElementsInstancedBaseVertexBaseInstanceANGLE(
                                context, modePacked, counts, typePacked, indices, instanceCounts,
                                baseVertices, baseInstances, drawcount));
        if (isCallValid)
        {
            context->multiDrawElementsInstancedBaseVertexBaseInstance(
                modePacked, counts, typePacked, indices, instanceCounts, baseVertices,
                baseInstances, drawcount);
        }
        ANGLE_CAPTURE(MultiDrawElementsInstancedBaseVertexBaseInstanceANGLE, isCallValid, context,
                      modePacked, counts, typePacked, indices, instanceCounts, baseVertices,
                      baseInstances, drawcount);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_ANGLE_copy_texture_3d
void GL_APIENTRY GL_CopyTexture3DANGLE(GLuint sourceId,
                                       GLint sourceLevel,
                                       GLenum destTarget,
                                       GLuint destId,
                                       GLint destLevel,
                                       GLint internalFormat,
                                       GLenum destType,
                                       GLboolean unpackFlipY,
                                       GLboolean unpackPremultiplyAlpha,
                                       GLboolean unpackUnmultiplyAlpha)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCopyTexture3DANGLE,
          "context = %d, sourceId = %u, sourceLevel = %d, destTarget = %s, destId = %u, destLevel "
          "= %d, internalFormat = %d, destType = %s, unpackFlipY = %s, unpackPremultiplyAlpha = "
          "%s, unpackUnmultiplyAlpha = %s",
          CID(context), sourceId, sourceLevel,
          GLenumToString(GLenumGroup::DefaultGroup, destTarget), destId, destLevel, internalFormat,
          GLenumToString(GLenumGroup::DefaultGroup, destType), GLbooleanToString(unpackFlipY),
          GLbooleanToString(unpackPremultiplyAlpha), GLbooleanToString(unpackUnmultiplyAlpha));

    if (context)
    {
        TextureID sourceIdPacked       = PackParam<TextureID>(sourceId);
        TextureTarget destTargetPacked = PackParam<TextureTarget>(destTarget);
        TextureID destIdPacked         = PackParam<TextureID>(destId);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateCopyTexture3DANGLE(
                                context, sourceIdPacked, sourceLevel, destTargetPacked,
                                destIdPacked, destLevel, internalFormat, destType, unpackFlipY,
                                unpackPremultiplyAlpha, unpackUnmultiplyAlpha));
        if (isCallValid)
        {
            context->copyTexture3D(sourceIdPacked, sourceLevel, destTargetPacked, destIdPacked,
                                   destLevel, internalFormat, destType, unpackFlipY,
                                   unpackPremultiplyAlpha, unpackUnmultiplyAlpha);
        }
        ANGLE_CAPTURE(CopyTexture3DANGLE, isCallValid, context, sourceIdPacked, sourceLevel,
                      destTargetPacked, destIdPacked, destLevel, internalFormat, destType,
                      unpackFlipY, unpackPremultiplyAlpha, unpackUnmultiplyAlpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_CopySubTexture3DANGLE(GLuint sourceId,
                                          GLint sourceLevel,
                                          GLenum destTarget,
                                          GLuint destId,
                                          GLint destLevel,
                                          GLint xoffset,
                                          GLint yoffset,
                                          GLint zoffset,
                                          GLint x,
                                          GLint y,
                                          GLint z,
                                          GLint width,
                                          GLint height,
                                          GLint depth,
                                          GLboolean unpackFlipY,
                                          GLboolean unpackPremultiplyAlpha,
                                          GLboolean unpackUnmultiplyAlpha)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCopySubTexture3DANGLE,
          "context = %d, sourceId = %u, sourceLevel = %d, destTarget = %s, destId = %u, destLevel "
          "= %d, xoffset = %d, yoffset = %d, zoffset = %d, x = %d, y = %d, z = %d, width = %d, "
          "height = %d, depth = %d, unpackFlipY = %s, unpackPremultiplyAlpha = %s, "
          "unpackUnmultiplyAlpha = %s",
          CID(context), sourceId, sourceLevel,
          GLenumToString(GLenumGroup::DefaultGroup, destTarget), destId, destLevel, xoffset,
          yoffset, zoffset, x, y, z, width, height, depth, GLbooleanToString(unpackFlipY),
          GLbooleanToString(unpackPremultiplyAlpha), GLbooleanToString(unpackUnmultiplyAlpha));

    if (context)
    {
        TextureID sourceIdPacked       = PackParam<TextureID>(sourceId);
        TextureTarget destTargetPacked = PackParam<TextureTarget>(destTarget);
        TextureID destIdPacked         = PackParam<TextureID>(destId);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateCopySubTexture3DANGLE(context, sourceIdPacked, sourceLevel, destTargetPacked,
                                           destIdPacked, destLevel, xoffset, yoffset, zoffset, x, y,
                                           z, width, height, depth, unpackFlipY,
                                           unpackPremultiplyAlpha, unpackUnmultiplyAlpha));
        if (isCallValid)
        {
            context->copySubTexture3D(sourceIdPacked, sourceLevel, destTargetPacked, destIdPacked,
                                      destLevel, xoffset, yoffset, zoffset, x, y, z, width, height,
                                      depth, unpackFlipY, unpackPremultiplyAlpha,
                                      unpackUnmultiplyAlpha);
        }
        ANGLE_CAPTURE(CopySubTexture3DANGLE, isCallValid, context, sourceIdPacked, sourceLevel,
                      destTargetPacked, destIdPacked, destLevel, xoffset, yoffset, zoffset, x, y, z,
                      width, height, depth, unpackFlipY, unpackPremultiplyAlpha,
                      unpackUnmultiplyAlpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_ANGLE_framebuffer_blit
void GL_APIENTRY GL_BlitFramebufferANGLE(GLint srcX0,
                                         GLint srcY0,
                                         GLint srcX1,
                                         GLint srcY1,
                                         GLint dstX0,
                                         GLint dstY0,
                                         GLint dstX1,
                                         GLint dstY1,
                                         GLbitfield mask,
                                         GLenum filter)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBlitFramebufferANGLE,
          "context = %d, srcX0 = %d, srcY0 = %d, srcX1 = %d, srcY1 = %d, dstX0 = %d, dstY0 = %d, "
          "dstX1 = %d, dstY1 = %d, mask = %s, filter = %s",
          CID(context), srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1,
          GLbitfieldToString(GLenumGroup::ClearBufferMask, mask).c_str(),
          GLenumToString(GLenumGroup::BlitFramebufferFilter, filter));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBlitFramebufferANGLE(context, srcX0, srcY0, srcX1, srcY1, dstX0,
                                                         dstY0, dstX1, dstY1, mask, filter));
        if (isCallValid)
        {
            context->blitFramebuffer(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask,
                                     filter);
        }
        ANGLE_CAPTURE(BlitFramebufferANGLE, isCallValid, context, srcX0, srcY0, srcX1, srcY1, dstX0,
                      dstY0, dstX1, dstY1, mask, filter);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_ANGLE_framebuffer_multisample
void GL_APIENTRY GL_RenderbufferStorageMultisampleANGLE(GLenum target,
                                                        GLsizei samples,
                                                        GLenum internalformat,
                                                        GLsizei width,
                                                        GLsizei height)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRenderbufferStorageMultisampleANGLE,
          "context = %d, target = %s, samples = %d, internalformat = %s, width = %d, height = %d",
          CID(context), GLenumToString(GLenumGroup::RenderbufferTarget, target), samples,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateRenderbufferStorageMultisampleANGLE(
                                context, target, samples, internalformat, width, height));
        if (isCallValid)
        {
            context->renderbufferStorageMultisample(target, samples, internalformat, width, height);
        }
        ANGLE_CAPTURE(RenderbufferStorageMultisampleANGLE, isCallValid, context, target, samples,
                      internalformat, width, height);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_ANGLE_get_image
void GL_APIENTRY
GL_GetTexImageANGLE(GLenum target, GLint level, GLenum format, GLenum type, void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexImageANGLE,
          "context = %d, target = %s, level = %d, format = %s, type = %s, pixels = 0x%016" PRIxPTR
          "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level,
          GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), (uintptr_t)pixels);

    if (context)
    {
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetTexImageANGLE(context, targetPacked, level, format, type, pixels));
        if (isCallValid)
        {
            context->getTexImage(targetPacked, level, format, type, pixels);
        }
        ANGLE_CAPTURE(GetTexImageANGLE, isCallValid, context, targetPacked, level, format, type,
                      pixels);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetRenderbufferImageANGLE(GLenum target,
                                              GLenum format,
                                              GLenum type,
                                              void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetRenderbufferImageANGLE,
          "context = %d, target = %s, format = %s, type = %s, pixels = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::RenderbufferTarget, target),
          GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), (uintptr_t)pixels);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetRenderbufferImageANGLE(context, target, format, type, pixels));
        if (isCallValid)
        {
            context->getRenderbufferImage(target, format, type, pixels);
        }
        ANGLE_CAPTURE(GetRenderbufferImageANGLE, isCallValid, context, target, format, type,
                      pixels);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_ANGLE_get_tex_level_parameter
void GL_APIENTRY GL_GetTexLevelParameterivANGLE(GLenum target,
                                                GLint level,
                                                GLenum pname,
                                                GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexLevelParameterivANGLE,
          "context = %d, target = %s, level = %d, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level,
          GLenumToString(GLenumGroup::GetTextureParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetTexLevelParameterivANGLE(context, targetPacked, level, pname, params));
        if (isCallValid)
        {
            context->getTexLevelParameteriv(targetPacked, level, pname, params);
        }
        ANGLE_CAPTURE(GetTexLevelParameterivANGLE, isCallValid, context, targetPacked, level, pname,
                      params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetTexLevelParameterfvANGLE(GLenum target,
                                                GLint level,
                                                GLenum pname,
                                                GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexLevelParameterfvANGLE,
          "context = %d, target = %s, level = %d, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target), level,
          GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)params);

    if (context)
    {
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetTexLevelParameterfvANGLE(context, targetPacked, level, pname, params));
        if (isCallValid)
        {
            context->getTexLevelParameterfv(targetPacked, level, pname, params);
        }
        ANGLE_CAPTURE(GetTexLevelParameterfvANGLE, isCallValid, context, targetPacked, level, pname,
                      params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_ANGLE_instanced_arrays
void GL_APIENTRY GL_DrawArraysInstancedANGLE(GLenum mode,
                                             GLint first,
                                             GLsizei count,
                                             GLsizei primcount)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawArraysInstancedANGLE,
          "context = %d, mode = %s, first = %d, count = %d, primcount = %d", CID(context),
          GLenumToString(GLenumGroup::PrimitiveType, mode), first, count, primcount);

    if (context)
    {
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateDrawArraysInstancedANGLE(context, modePacked, first, count, primcount));
        if (isCallValid)
        {
            context->drawArraysInstanced(modePacked, first, count, primcount);
        }
        ANGLE_CAPTURE(DrawArraysInstancedANGLE, isCallValid, context, modePacked, first, count,
                      primcount);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DrawElementsInstancedANGLE(GLenum mode,
                                               GLsizei count,
                                               GLenum type,
                                               const void *indices,
                                               GLsizei primcount)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawElementsInstancedANGLE,
          "context = %d, mode = %s, count = %d, type = %s, indices = 0x%016" PRIxPTR
          ", primcount = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), count,
          GLenumToString(GLenumGroup::PrimitiveType, type), (uintptr_t)indices, primcount);

    if (context)
    {
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked                           = PackParam<DrawElementsType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDrawElementsInstancedANGLE(context, modePacked, count,
                                                               typePacked, indices, primcount));
        if (isCallValid)
        {
            context->drawElementsInstanced(modePacked, count, typePacked, indices, primcount);
        }
        ANGLE_CAPTURE(DrawElementsInstancedANGLE, isCallValid, context, modePacked, count,
                      typePacked, indices, primcount);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttribDivisorANGLE(GLuint index, GLuint divisor)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttribDivisorANGLE, "context = %d, index = %u, divisor = %u",
          CID(context), index, divisor);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertexAttribDivisorANGLE(context, index, divisor));
        if (isCallValid)
        {
            context->vertexAttribDivisor(index, divisor);
        }
        ANGLE_CAPTURE(VertexAttribDivisorANGLE, isCallValid, context, index, divisor);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_ANGLE_memory_object_flags
void GL_APIENTRY GL_TexStorageMemFlags2DANGLE(GLenum target,
                                              GLsizei levels,
                                              GLenum internalFormat,
                                              GLsizei width,
                                              GLsizei height,
                                              GLuint memory,
                                              GLuint64 offset,
                                              GLbitfield createFlags,
                                              GLbitfield usageFlags)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexStorageMemFlags2DANGLE,
          "context = %d, target = %s, levels = %d, internalFormat = %s, width = %d, height = %d, "
          "memory = %u, offset = %llu, createFlags = %s, usageFlags = %s",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), levels,
          GLenumToString(GLenumGroup::DefaultGroup, internalFormat), width, height, memory,
          static_cast<unsigned long long>(offset),
          GLbitfieldToString(GLenumGroup::DefaultGroup, createFlags).c_str(),
          GLbitfieldToString(GLenumGroup::DefaultGroup, usageFlags).c_str());

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        MemoryObjectID memoryPacked                           = PackParam<MemoryObjectID>(memory);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexStorageMemFlags2DANGLE(
                                context, targetPacked, levels, internalFormat, width, height,
                                memoryPacked, offset, createFlags, usageFlags));
        if (isCallValid)
        {
            context->texStorageMemFlags2D(targetPacked, levels, internalFormat, width, height,
                                          memoryPacked, offset, createFlags, usageFlags);
        }
        ANGLE_CAPTURE(TexStorageMemFlags2DANGLE, isCallValid, context, targetPacked, levels,
                      internalFormat, width, height, memoryPacked, offset, createFlags, usageFlags);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexStorageMemFlags2DMultisampleANGLE(GLenum target,
                                                         GLsizei samples,
                                                         GLenum internalFormat,
                                                         GLsizei width,
                                                         GLsizei height,
                                                         GLboolean fixedSampleLocations,
                                                         GLuint memory,
                                                         GLuint64 offset,
                                                         GLbitfield createFlags,
                                                         GLbitfield usageFlags)
{
    Context *context = GetValidGlobalContext();
    EVENT(
        context, GLTexStorageMemFlags2DMultisampleANGLE,
        "context = %d, target = %s, samples = %d, internalFormat = %s, width = %d, height = %d, "
        "fixedSampleLocations = %s, memory = %u, offset = %llu, createFlags = %s, usageFlags = %s",
        CID(context), GLenumToString(GLenumGroup::TextureTarget, target), samples,
        GLenumToString(GLenumGroup::DefaultGroup, internalFormat), width, height,
        GLbooleanToString(fixedSampleLocations), memory, static_cast<unsigned long long>(offset),
        GLbitfieldToString(GLenumGroup::DefaultGroup, createFlags).c_str(),
        GLbitfieldToString(GLenumGroup::DefaultGroup, usageFlags).c_str());

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        MemoryObjectID memoryPacked                           = PackParam<MemoryObjectID>(memory);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexStorageMemFlags2DMultisampleANGLE(
                 context, targetPacked, samples, internalFormat, width, height,
                 fixedSampleLocations, memoryPacked, offset, createFlags, usageFlags));
        if (isCallValid)
        {
            context->texStorageMemFlags2DMultisample(targetPacked, samples, internalFormat, width,
                                                     height, fixedSampleLocations, memoryPacked,
                                                     offset, createFlags, usageFlags);
        }
        ANGLE_CAPTURE(TexStorageMemFlags2DMultisampleANGLE, isCallValid, context, targetPacked,
                      samples, internalFormat, width, height, fixedSampleLocations, memoryPacked,
                      offset, createFlags, usageFlags);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexStorageMemFlags3DANGLE(GLenum target,
                                              GLsizei levels,
                                              GLenum internalFormat,
                                              GLsizei width,
                                              GLsizei height,
                                              GLsizei depth,
                                              GLuint memory,
                                              GLuint64 offset,
                                              GLbitfield createFlags,
                                              GLbitfield usageFlags)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexStorageMemFlags3DANGLE,
          "context = %d, target = %s, levels = %d, internalFormat = %s, width = %d, height = %d, "
          "depth = %d, memory = %u, offset = %llu, createFlags = %s, usageFlags = %s",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), levels,
          GLenumToString(GLenumGroup::DefaultGroup, internalFormat), width, height, depth, memory,
          static_cast<unsigned long long>(offset),
          GLbitfieldToString(GLenumGroup::DefaultGroup, createFlags).c_str(),
          GLbitfieldToString(GLenumGroup::DefaultGroup, usageFlags).c_str());

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        MemoryObjectID memoryPacked                           = PackParam<MemoryObjectID>(memory);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexStorageMemFlags3DANGLE(
                                context, targetPacked, levels, internalFormat, width, height, depth,
                                memoryPacked, offset, createFlags, usageFlags));
        if (isCallValid)
        {
            context->texStorageMemFlags3D(targetPacked, levels, internalFormat, width, height,
                                          depth, memoryPacked, offset, createFlags, usageFlags);
        }
        ANGLE_CAPTURE(TexStorageMemFlags3DANGLE, isCallValid, context, targetPacked, levels,
                      internalFormat, width, height, depth, memoryPacked, offset, createFlags,
                      usageFlags);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexStorageMemFlags3DMultisampleANGLE(GLenum target,
                                                         GLsizei samples,
                                                         GLenum internalFormat,
                                                         GLsizei width,
                                                         GLsizei height,
                                                         GLsizei depth,
                                                         GLboolean fixedSampleLocations,
                                                         GLuint memory,
                                                         GLuint64 offset,
                                                         GLbitfield createFlags,
                                                         GLbitfield usageFlags)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexStorageMemFlags3DMultisampleANGLE,
          "context = %d, target = %s, samples = %d, internalFormat = %s, width = %d, height = %d, "
          "depth = %d, fixedSampleLocations = %s, memory = %u, offset = %llu, createFlags = %s, "
          "usageFlags = %s",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), samples,
          GLenumToString(GLenumGroup::DefaultGroup, internalFormat), width, height, depth,
          GLbooleanToString(fixedSampleLocations), memory, static_cast<unsigned long long>(offset),
          GLbitfieldToString(GLenumGroup::DefaultGroup, createFlags).c_str(),
          GLbitfieldToString(GLenumGroup::DefaultGroup, usageFlags).c_str());

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        MemoryObjectID memoryPacked                           = PackParam<MemoryObjectID>(memory);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexStorageMemFlags3DMultisampleANGLE(
                 context, targetPacked, samples, internalFormat, width, height, depth,
                 fixedSampleLocations, memoryPacked, offset, createFlags, usageFlags));
        if (isCallValid)
        {
            context->texStorageMemFlags3DMultisample(targetPacked, samples, internalFormat, width,
                                                     height, depth, fixedSampleLocations,
                                                     memoryPacked, offset, createFlags, usageFlags);
        }
        ANGLE_CAPTURE(TexStorageMemFlags3DMultisampleANGLE, isCallValid, context, targetPacked,
                      samples, internalFormat, width, height, depth, fixedSampleLocations,
                      memoryPacked, offset, createFlags, usageFlags);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_ANGLE_memory_object_fuchsia
void GL_APIENTRY GL_ImportMemoryZirconHandleANGLE(GLuint memory,
                                                  GLuint64 size,
                                                  GLenum handleType,
                                                  GLuint handle)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLImportMemoryZirconHandleANGLE,
          "context = %d, memory = %u, size = %llu, handleType = %s, handle = %u", CID(context),
          memory, static_cast<unsigned long long>(size),
          GLenumToString(GLenumGroup::ExternalHandleType, handleType), handle);

    if (context)
    {
        MemoryObjectID memoryPacked                           = PackParam<MemoryObjectID>(memory);
        HandleType handleTypePacked                           = PackParam<HandleType>(handleType);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateImportMemoryZirconHandleANGLE(context, memoryPacked, size,
                                                                  handleTypePacked, handle));
        if (isCallValid)
        {
            context->importMemoryZirconHandle(memoryPacked, size, handleTypePacked, handle);
        }
        ANGLE_CAPTURE(ImportMemoryZirconHandleANGLE, isCallValid, context, memoryPacked, size,
                      handleTypePacked, handle);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_ANGLE_multi_draw
void GL_APIENTRY GL_MultiDrawArraysANGLE(GLenum mode,
                                         const GLint *firsts,
                                         const GLsizei *counts,
                                         GLsizei drawcount)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiDrawArraysANGLE,
          "context = %d, mode = %s, firsts = 0x%016" PRIxPTR ", counts = 0x%016" PRIxPTR
          ", drawcount = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), (uintptr_t)firsts,
          (uintptr_t)counts, drawcount);

    if (context)
    {
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMultiDrawArraysANGLE(context, modePacked, firsts, counts, drawcount));
        if (isCallValid)
        {
            context->multiDrawArrays(modePacked, firsts, counts, drawcount);
        }
        ANGLE_CAPTURE(MultiDrawArraysANGLE, isCallValid, context, modePacked, firsts, counts,
                      drawcount);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultiDrawArraysInstancedANGLE(GLenum mode,
                                                  const GLint *firsts,
                                                  const GLsizei *counts,
                                                  const GLsizei *instanceCounts,
                                                  GLsizei drawcount)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiDrawArraysInstancedANGLE,
          "context = %d, mode = %s, firsts = 0x%016" PRIxPTR ", counts = 0x%016" PRIxPTR
          ", instanceCounts = 0x%016" PRIxPTR ", drawcount = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), (uintptr_t)firsts,
          (uintptr_t)counts, (uintptr_t)instanceCounts, drawcount);

    if (context)
    {
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateMultiDrawArraysInstancedANGLE(
                                context, modePacked, firsts, counts, instanceCounts, drawcount));
        if (isCallValid)
        {
            context->multiDrawArraysInstanced(modePacked, firsts, counts, instanceCounts,
                                              drawcount);
        }
        ANGLE_CAPTURE(MultiDrawArraysInstancedANGLE, isCallValid, context, modePacked, firsts,
                      counts, instanceCounts, drawcount);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultiDrawElementsANGLE(GLenum mode,
                                           const GLsizei *counts,
                                           GLenum type,
                                           const GLvoid *const *indices,
                                           GLsizei drawcount)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiDrawElementsANGLE,
          "context = %d, mode = %s, counts = 0x%016" PRIxPTR ", type = %s, indices = 0x%016" PRIxPTR
          ", drawcount = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), (uintptr_t)counts,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, drawcount);

    if (context)
    {
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked                           = PackParam<DrawElementsType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateMultiDrawElementsANGLE(context, modePacked, counts, typePacked,
                                                           indices, drawcount));
        if (isCallValid)
        {
            context->multiDrawElements(modePacked, counts, typePacked, indices, drawcount);
        }
        ANGLE_CAPTURE(MultiDrawElementsANGLE, isCallValid, context, modePacked, counts, typePacked,
                      indices, drawcount);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultiDrawElementsInstancedANGLE(GLenum mode,
                                                    const GLsizei *counts,
                                                    GLenum type,
                                                    const GLvoid *const *indices,
                                                    const GLsizei *instanceCounts,
                                                    GLsizei drawcount)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiDrawElementsInstancedANGLE,
          "context = %d, mode = %s, counts = 0x%016" PRIxPTR ", type = %s, indices = 0x%016" PRIxPTR
          ", instanceCounts = 0x%016" PRIxPTR ", drawcount = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), (uintptr_t)counts,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices,
          (uintptr_t)instanceCounts, drawcount);

    if (context)
    {
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked                           = PackParam<DrawElementsType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMultiDrawElementsInstancedANGLE(context, modePacked, counts, typePacked,
                                                     indices, instanceCounts, drawcount));
        if (isCallValid)
        {
            context->multiDrawElementsInstanced(modePacked, counts, typePacked, indices,
                                                instanceCounts, drawcount);
        }
        ANGLE_CAPTURE(MultiDrawElementsInstancedANGLE, isCallValid, context, modePacked, counts,
                      typePacked, indices, instanceCounts, drawcount);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_ANGLE_program_binary

// GL_ANGLE_provoking_vertex
void GL_APIENTRY GL_ProvokingVertexANGLE(GLenum mode)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProvokingVertexANGLE, "context = %d, mode = %s", CID(context),
          GLenumToString(GLenumGroup::VertexProvokingMode, mode));

    if (context)
    {
        ProvokingVertexConvention modePacked = PackParam<ProvokingVertexConvention>(mode);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateProvokingVertexANGLE(context, modePacked));
        if (isCallValid)
        {
            context->provokingVertex(modePacked);
        }
        ANGLE_CAPTURE(ProvokingVertexANGLE, isCallValid, context, modePacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_ANGLE_request_extension
void GL_APIENTRY GL_RequestExtensionANGLE(const GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRequestExtensionANGLE, "context = %d, name = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)name);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateRequestExtensionANGLE(context, name));
        if (isCallValid)
        {
            context->requestExtension(name);
        }
        ANGLE_CAPTURE(RequestExtensionANGLE, isCallValid, context, name);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DisableExtensionANGLE(const GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDisableExtensionANGLE, "context = %d, name = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)name);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDisableExtensionANGLE(context, name));
        if (isCallValid)
        {
            context->disableExtension(name);
        }
        ANGLE_CAPTURE(DisableExtensionANGLE, isCallValid, context, name);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_ANGLE_robust_client_memory
void GL_APIENTRY GL_GetBooleanvRobustANGLE(GLenum pname,
                                           GLsizei bufSize,
                                           GLsizei *length,
                                           GLboolean *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetBooleanvRobustANGLE,
          "context = %d, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetBooleanvRobustANGLE(context, pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getBooleanvRobust(pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetBooleanvRobustANGLE, isCallValid, context, pname, bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetBufferParameterivRobustANGLE(GLenum target,
                                                    GLenum pname,
                                                    GLsizei bufSize,
                                                    GLsizei *length,
                                                    GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetBufferParameterivRobustANGLE,
          "context = %d, target = %s, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target),
          GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize, (uintptr_t)length,
          (uintptr_t)params);

    if (context)
    {
        BufferBinding targetPacked                            = PackParam<BufferBinding>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetBufferParameterivRobustANGLE(context, targetPacked, pname,
                                                                    bufSize, length, params));
        if (isCallValid)
        {
            context->getBufferParameterivRobust(targetPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetBufferParameterivRobustANGLE, isCallValid, context, targetPacked, pname,
                      bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetFloatvRobustANGLE(GLenum pname,
                                         GLsizei bufSize,
                                         GLsizei *length,
                                         GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetFloatvRobustANGLE,
          "context = %d, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetFloatvRobustANGLE(context, pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getFloatvRobust(pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetFloatvRobustANGLE, isCallValid, context, pname, bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetFramebufferAttachmentParameterivRobustANGLE(GLenum target,
                                                                   GLenum attachment,
                                                                   GLenum pname,
                                                                   GLsizei bufSize,
                                                                   GLsizei *length,
                                                                   GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetFramebufferAttachmentParameterivRobustANGLE,
          "context = %d, target = %s, attachment = %s, pname = %s, bufSize = %d, length = "
          "0x%016" PRIxPTR ", params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target),
          GLenumToString(GLenumGroup::DefaultGroup, attachment),
          GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize, (uintptr_t)length,
          (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetFramebufferAttachmentParameterivRobustANGLE(
                                context, target, attachment, pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getFramebufferAttachmentParameterivRobust(target, attachment, pname, bufSize,
                                                               length, params);
        }
        ANGLE_CAPTURE(GetFramebufferAttachmentParameterivRobustANGLE, isCallValid, context, target,
                      attachment, pname, bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetIntegervRobustANGLE(GLenum pname,
                                           GLsizei bufSize,
                                           GLsizei *length,
                                           GLint *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetIntegervRobustANGLE,
          "context = %d, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)length, (uintptr_t)data);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetIntegervRobustANGLE(context, pname, bufSize, length, data));
        if (isCallValid)
        {
            context->getIntegervRobust(pname, bufSize, length, data);
        }
        ANGLE_CAPTURE(GetIntegervRobustANGLE, isCallValid, context, pname, bufSize, length, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetProgramivRobustANGLE(GLuint program,
                                            GLenum pname,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLint *params)
{
    Context *context = GetGlobalContext();
    EVENT(context, GLGetProgramivRobustANGLE,
          "context = %d, program = %u, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), program, GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetProgramivRobustANGLE(context, programPacked, pname, bufSize,
                                                            length, params));
        if (isCallValid)
        {
            context->getProgramivRobust(programPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetProgramivRobustANGLE, isCallValid, context, programPacked, pname, bufSize,
                      length, params);
    }
    else
    {}
}

void GL_APIENTRY GL_GetRenderbufferParameterivRobustANGLE(GLenum target,
                                                          GLenum pname,
                                                          GLsizei bufSize,
                                                          GLsizei *length,
                                                          GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetRenderbufferParameterivRobustANGLE,
          "context = %d, target = %s, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target),
          GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize, (uintptr_t)length,
          (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetRenderbufferParameterivRobustANGLE(
                                              context, target, pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getRenderbufferParameterivRobust(target, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetRenderbufferParameterivRobustANGLE, isCallValid, context, target, pname,
                      bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetShaderivRobustANGLE(GLuint shader,
                                           GLenum pname,
                                           GLsizei bufSize,
                                           GLsizei *length,
                                           GLint *params)
{
    Context *context = GetGlobalContext();
    EVENT(context, GLGetShaderivRobustANGLE,
          "context = %d, shader = %u, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), shader, GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        ShaderProgramID shaderPacked                          = PackParam<ShaderProgramID>(shader);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetShaderivRobustANGLE(context, shaderPacked, pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getShaderivRobust(shaderPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetShaderivRobustANGLE, isCallValid, context, shaderPacked, pname, bufSize,
                      length, params);
    }
    else
    {}
}

void GL_APIENTRY GL_GetTexParameterfvRobustANGLE(GLenum target,
                                                 GLenum pname,
                                                 GLsizei bufSize,
                                                 GLsizei *length,
                                                 GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexParameterfvRobustANGLE,
          "context = %d, target = %s, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target),
          GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize, (uintptr_t)length,
          (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetTexParameterfvRobustANGLE(context, targetPacked, pname,
                                                                 bufSize, length, params));
        if (isCallValid)
        {
            context->getTexParameterfvRobust(targetPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetTexParameterfvRobustANGLE, isCallValid, context, targetPacked, pname,
                      bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetTexParameterivRobustANGLE(GLenum target,
                                                 GLenum pname,
                                                 GLsizei bufSize,
                                                 GLsizei *length,
                                                 GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexParameterivRobustANGLE,
          "context = %d, target = %s, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target),
          GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize, (uintptr_t)length,
          (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetTexParameterivRobustANGLE(context, targetPacked, pname,
                                                                 bufSize, length, params));
        if (isCallValid)
        {
            context->getTexParameterivRobust(targetPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetTexParameterivRobustANGLE, isCallValid, context, targetPacked, pname,
                      bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetUniformfvRobustANGLE(GLuint program,
                                            GLint location,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetUniformfvRobustANGLE,
          "context = %d, program = %u, location = %d, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetUniformfvRobustANGLE(context, programPacked, locationPacked,
                                                            bufSize, length, params));
        if (isCallValid)
        {
            context->getUniformfvRobust(programPacked, locationPacked, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetUniformfvRobustANGLE, isCallValid, context, programPacked, locationPacked,
                      bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetUniformivRobustANGLE(GLuint program,
                                            GLint location,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetUniformivRobustANGLE,
          "context = %d, program = %u, location = %d, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetUniformivRobustANGLE(context, programPacked, locationPacked,
                                                            bufSize, length, params));
        if (isCallValid)
        {
            context->getUniformivRobust(programPacked, locationPacked, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetUniformivRobustANGLE, isCallValid, context, programPacked, locationPacked,
                      bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetVertexAttribfvRobustANGLE(GLuint index,
                                                 GLenum pname,
                                                 GLsizei bufSize,
                                                 GLsizei *length,
                                                 GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetVertexAttribfvRobustANGLE,
          "context = %d, index = %u, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), index, GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetVertexAttribfvRobustANGLE(context, index, pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getVertexAttribfvRobust(index, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetVertexAttribfvRobustANGLE, isCallValid, context, index, pname, bufSize,
                      length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetVertexAttribivRobustANGLE(GLuint index,
                                                 GLenum pname,
                                                 GLsizei bufSize,
                                                 GLsizei *length,
                                                 GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetVertexAttribivRobustANGLE,
          "context = %d, index = %u, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), index, GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetVertexAttribivRobustANGLE(context, index, pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getVertexAttribivRobust(index, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetVertexAttribivRobustANGLE, isCallValid, context, index, pname, bufSize,
                      length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetVertexAttribPointervRobustANGLE(GLuint index,
                                                       GLenum pname,
                                                       GLsizei bufSize,
                                                       GLsizei *length,
                                                       void **pointer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetVertexAttribPointervRobustANGLE,
          "context = %d, index = %u, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", pointer = 0x%016" PRIxPTR "",
          CID(context), index, GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)length, (uintptr_t)pointer);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetVertexAttribPointervRobustANGLE(
                                              context, index, pname, bufSize, length, pointer));
        if (isCallValid)
        {
            context->getVertexAttribPointervRobust(index, pname, bufSize, length, pointer);
        }
        ANGLE_CAPTURE(GetVertexAttribPointervRobustANGLE, isCallValid, context, index, pname,
                      bufSize, length, pointer);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ReadPixelsRobustANGLE(GLint x,
                                          GLint y,
                                          GLsizei width,
                                          GLsizei height,
                                          GLenum format,
                                          GLenum type,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLsizei *columns,
                                          GLsizei *rows,
                                          void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLReadPixelsRobustANGLE,
          "context = %d, x = %d, y = %d, width = %d, height = %d, format = %s, type = %s, bufSize "
          "= %d, length = 0x%016" PRIxPTR ", columns = 0x%016" PRIxPTR ", rows = 0x%016" PRIxPTR
          ", pixels = 0x%016" PRIxPTR "",
          CID(context), x, y, width, height, GLenumToString(GLenumGroup::DefaultGroup, format),
          GLenumToString(GLenumGroup::DefaultGroup, type), bufSize, (uintptr_t)length,
          (uintptr_t)columns, (uintptr_t)rows, (uintptr_t)pixels);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateReadPixelsRobustANGLE(context, x, y, width, height, format, type, bufSize,
                                           length, columns, rows, pixels));
        if (isCallValid)
        {
            context->readPixelsRobust(x, y, width, height, format, type, bufSize, length, columns,
                                      rows, pixels);
        }
        ANGLE_CAPTURE(ReadPixelsRobustANGLE, isCallValid, context, x, y, width, height, format,
                      type, bufSize, length, columns, rows, pixels);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexImage2DRobustANGLE(GLenum target,
                                          GLint level,
                                          GLint internalformat,
                                          GLsizei width,
                                          GLsizei height,
                                          GLint border,
                                          GLenum format,
                                          GLenum type,
                                          GLsizei bufSize,
                                          const void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexImage2DRobustANGLE,
          "context = %d, target = %s, level = %d, internalformat = %d, width = %d, height = %d, "
          "border = %d, format = %s, type = %s, bufSize = %d, pixels = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target), level, internalformat,
          width, height, border, GLenumToString(GLenumGroup::DefaultGroup, format),
          GLenumToString(GLenumGroup::DefaultGroup, type), bufSize, (uintptr_t)pixels);

    if (context)
    {
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexImage2DRobustANGLE(context, targetPacked, level, internalformat, width,
                                           height, border, format, type, bufSize, pixels));
        if (isCallValid)
        {
            context->texImage2DRobust(targetPacked, level, internalformat, width, height, border,
                                      format, type, bufSize, pixels);
        }
        ANGLE_CAPTURE(TexImage2DRobustANGLE, isCallValid, context, targetPacked, level,
                      internalformat, width, height, border, format, type, bufSize, pixels);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexParameterfvRobustANGLE(GLenum target,
                                              GLenum pname,
                                              GLsizei bufSize,
                                              const GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexParameterfvRobustANGLE,
          "context = %d, target = %s, pname = %s, bufSize = %d, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target),
          GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize, (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexParameterfvRobustANGLE(context, targetPacked, pname, bufSize, params));
        if (isCallValid)
        {
            context->texParameterfvRobust(targetPacked, pname, bufSize, params);
        }
        ANGLE_CAPTURE(TexParameterfvRobustANGLE, isCallValid, context, targetPacked, pname, bufSize,
                      params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexParameterivRobustANGLE(GLenum target,
                                              GLenum pname,
                                              GLsizei bufSize,
                                              const GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexParameterivRobustANGLE,
          "context = %d, target = %s, pname = %s, bufSize = %d, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target),
          GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize, (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexParameterivRobustANGLE(context, targetPacked, pname, bufSize, params));
        if (isCallValid)
        {
            context->texParameterivRobust(targetPacked, pname, bufSize, params);
        }
        ANGLE_CAPTURE(TexParameterivRobustANGLE, isCallValid, context, targetPacked, pname, bufSize,
                      params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexSubImage2DRobustANGLE(GLenum target,
                                             GLint level,
                                             GLint xoffset,
                                             GLint yoffset,
                                             GLsizei width,
                                             GLsizei height,
                                             GLenum format,
                                             GLenum type,
                                             GLsizei bufSize,
                                             const void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexSubImage2DRobustANGLE,
          "context = %d, target = %s, level = %d, xoffset = %d, yoffset = %d, width = %d, height = "
          "%d, format = %s, type = %s, bufSize = %d, pixels = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target), level, xoffset, yoffset,
          width, height, GLenumToString(GLenumGroup::DefaultGroup, format),
          GLenumToString(GLenumGroup::DefaultGroup, type), bufSize, (uintptr_t)pixels);

    if (context)
    {
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexSubImage2DRobustANGLE(context, targetPacked, level, xoffset, yoffset, width,
                                              height, format, type, bufSize, pixels));
        if (isCallValid)
        {
            context->texSubImage2DRobust(targetPacked, level, xoffset, yoffset, width, height,
                                         format, type, bufSize, pixels);
        }
        ANGLE_CAPTURE(TexSubImage2DRobustANGLE, isCallValid, context, targetPacked, level, xoffset,
                      yoffset, width, height, format, type, bufSize, pixels);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexImage3DRobustANGLE(GLenum target,
                                          GLint level,
                                          GLint internalformat,
                                          GLsizei width,
                                          GLsizei height,
                                          GLsizei depth,
                                          GLint border,
                                          GLenum format,
                                          GLenum type,
                                          GLsizei bufSize,
                                          const void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexImage3DRobustANGLE,
          "context = %d, target = %s, level = %d, internalformat = %d, width = %d, height = %d, "
          "depth = %d, border = %d, format = %s, type = %s, bufSize = %d, pixels = 0x%016" PRIxPTR
          "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target), level, internalformat,
          width, height, depth, border, GLenumToString(GLenumGroup::DefaultGroup, format),
          GLenumToString(GLenumGroup::DefaultGroup, type), bufSize, (uintptr_t)pixels);

    if (context)
    {
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexImage3DRobustANGLE(context, targetPacked, level, internalformat, width,
                                           height, depth, border, format, type, bufSize, pixels));
        if (isCallValid)
        {
            context->texImage3DRobust(targetPacked, level, internalformat, width, height, depth,
                                      border, format, type, bufSize, pixels);
        }
        ANGLE_CAPTURE(TexImage3DRobustANGLE, isCallValid, context, targetPacked, level,
                      internalformat, width, height, depth, border, format, type, bufSize, pixels);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexSubImage3DRobustANGLE(GLenum target,
                                             GLint level,
                                             GLint xoffset,
                                             GLint yoffset,
                                             GLint zoffset,
                                             GLsizei width,
                                             GLsizei height,
                                             GLsizei depth,
                                             GLenum format,
                                             GLenum type,
                                             GLsizei bufSize,
                                             const void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT(
        context, GLTexSubImage3DRobustANGLE,
        "context = %d, target = %s, level = %d, xoffset = %d, yoffset = %d, zoffset = %d, width = "
        "%d, height = %d, depth = %d, format = %s, type = %s, bufSize = %d, pixels = 0x%016" PRIxPTR
        "",
        CID(context), GLenumToString(GLenumGroup::DefaultGroup, target), level, xoffset, yoffset,
        zoffset, width, height, depth, GLenumToString(GLenumGroup::DefaultGroup, format),
        GLenumToString(GLenumGroup::DefaultGroup, type), bufSize, (uintptr_t)pixels);

    if (context)
    {
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexSubImage3DRobustANGLE(context, targetPacked, level, xoffset,
                                                             yoffset, zoffset, width, height, depth,
                                                             format, type, bufSize, pixels));
        if (isCallValid)
        {
            context->texSubImage3DRobust(targetPacked, level, xoffset, yoffset, zoffset, width,
                                         height, depth, format, type, bufSize, pixels);
        }
        ANGLE_CAPTURE(TexSubImage3DRobustANGLE, isCallValid, context, targetPacked, level, xoffset,
                      yoffset, zoffset, width, height, depth, format, type, bufSize, pixels);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_CompressedTexImage2DRobustANGLE(GLenum target,
                                                    GLint level,
                                                    GLenum internalformat,
                                                    GLsizei width,
                                                    GLsizei height,
                                                    GLint border,
                                                    GLsizei imageSize,
                                                    GLsizei dataSize,
                                                    const GLvoid *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCompressedTexImage2DRobustANGLE,
          "context = %d, target = %s, level = %d, internalformat = %s, width = %d, height = %d, "
          "border = %d, imageSize = %d, dataSize = %d, data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target), level,
          GLenumToString(GLenumGroup::DefaultGroup, internalformat), width, height, border,
          imageSize, dataSize, (uintptr_t)data);

    if (context)
    {
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateCompressedTexImage2DRobustANGLE(
                                              context, targetPacked, level, internalformat, width,
                                              height, border, imageSize, dataSize, data));
        if (isCallValid)
        {
            context->compressedTexImage2DRobust(targetPacked, level, internalformat, width, height,
                                                border, imageSize, dataSize, data);
        }
        ANGLE_CAPTURE(CompressedTexImage2DRobustANGLE, isCallValid, context, targetPacked, level,
                      internalformat, width, height, border, imageSize, dataSize, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_CompressedTexSubImage2DRobustANGLE(GLenum target,
                                                       GLint level,
                                                       GLsizei xoffset,
                                                       GLsizei yoffset,
                                                       GLsizei width,
                                                       GLsizei height,
                                                       GLenum format,
                                                       GLsizei imageSize,
                                                       GLsizei dataSize,
                                                       const GLvoid *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCompressedTexSubImage2DRobustANGLE,
          "context = %d, target = %s, level = %d, xoffset = %d, yoffset = %d, width = %d, height = "
          "%d, format = %s, imageSize = %d, dataSize = %d, data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target), level, xoffset, yoffset,
          width, height, GLenumToString(GLenumGroup::DefaultGroup, format), imageSize, dataSize,
          (uintptr_t)data);

    if (context)
    {
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateCompressedTexSubImage2DRobustANGLE(
                                              context, targetPacked, level, xoffset, yoffset, width,
                                              height, format, imageSize, dataSize, data));
        if (isCallValid)
        {
            context->compressedTexSubImage2DRobust(targetPacked, level, xoffset, yoffset, width,
                                                   height, format, imageSize, dataSize, data);
        }
        ANGLE_CAPTURE(CompressedTexSubImage2DRobustANGLE, isCallValid, context, targetPacked, level,
                      xoffset, yoffset, width, height, format, imageSize, dataSize, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_CompressedTexImage3DRobustANGLE(GLenum target,
                                                    GLint level,
                                                    GLenum internalformat,
                                                    GLsizei width,
                                                    GLsizei height,
                                                    GLsizei depth,
                                                    GLint border,
                                                    GLsizei imageSize,
                                                    GLsizei dataSize,
                                                    const GLvoid *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCompressedTexImage3DRobustANGLE,
          "context = %d, target = %s, level = %d, internalformat = %s, width = %d, height = %d, "
          "depth = %d, border = %d, imageSize = %d, dataSize = %d, data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target), level,
          GLenumToString(GLenumGroup::DefaultGroup, internalformat), width, height, depth, border,
          imageSize, dataSize, (uintptr_t)data);

    if (context)
    {
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateCompressedTexImage3DRobustANGLE(
                                              context, targetPacked, level, internalformat, width,
                                              height, depth, border, imageSize, dataSize, data));
        if (isCallValid)
        {
            context->compressedTexImage3DRobust(targetPacked, level, internalformat, width, height,
                                                depth, border, imageSize, dataSize, data);
        }
        ANGLE_CAPTURE(CompressedTexImage3DRobustANGLE, isCallValid, context, targetPacked, level,
                      internalformat, width, height, depth, border, imageSize, dataSize, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_CompressedTexSubImage3DRobustANGLE(GLenum target,
                                                       GLint level,
                                                       GLint xoffset,
                                                       GLint yoffset,
                                                       GLint zoffset,
                                                       GLsizei width,
                                                       GLsizei height,
                                                       GLsizei depth,
                                                       GLenum format,
                                                       GLsizei imageSize,
                                                       GLsizei dataSize,
                                                       const GLvoid *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCompressedTexSubImage3DRobustANGLE,
          "context = %d, target = %s, level = %d, xoffset = %d, yoffset = %d, zoffset = %d, width "
          "= %d, height = %d, depth = %d, format = %s, imageSize = %d, dataSize = %d, data = "
          "0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target), level, xoffset, yoffset,
          zoffset, width, height, depth, GLenumToString(GLenumGroup::DefaultGroup, format),
          imageSize, dataSize, (uintptr_t)data);

    if (context)
    {
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateCompressedTexSubImage3DRobustANGLE(
                                context, targetPacked, level, xoffset, yoffset, zoffset, width,
                                height, depth, format, imageSize, dataSize, data));
        if (isCallValid)
        {
            context->compressedTexSubImage3DRobust(targetPacked, level, xoffset, yoffset, zoffset,
                                                   width, height, depth, format, imageSize,
                                                   dataSize, data);
        }
        ANGLE_CAPTURE(CompressedTexSubImage3DRobustANGLE, isCallValid, context, targetPacked, level,
                      xoffset, yoffset, zoffset, width, height, depth, format, imageSize, dataSize,
                      data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetQueryivRobustANGLE(GLenum target,
                                          GLenum pname,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetQueryivRobustANGLE,
          "context = %d, target = %s, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target),
          GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize, (uintptr_t)length,
          (uintptr_t)params);

    if (context)
    {
        QueryType targetPacked                                = PackParam<QueryType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetQueryivRobustANGLE(context, targetPacked, pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getQueryivRobust(targetPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetQueryivRobustANGLE, isCallValid, context, targetPacked, pname, bufSize,
                      length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetQueryObjectuivRobustANGLE(GLuint id,
                                                 GLenum pname,
                                                 GLsizei bufSize,
                                                 GLsizei *length,
                                                 GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetQueryObjectuivRobustANGLE,
          "context = %d, id = %u, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), id, GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        QueryID idPacked                                      = PackParam<QueryID>(id);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetQueryObjectuivRobustANGLE(
                                              context, idPacked, pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getQueryObjectuivRobust(idPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetQueryObjectuivRobustANGLE, isCallValid, context, idPacked, pname, bufSize,
                      length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetBufferPointervRobustANGLE(GLenum target,
                                                 GLenum pname,
                                                 GLsizei bufSize,
                                                 GLsizei *length,
                                                 void **params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetBufferPointervRobustANGLE,
          "context = %d, target = %s, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target),
          GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize, (uintptr_t)length,
          (uintptr_t)params);

    if (context)
    {
        BufferBinding targetPacked                            = PackParam<BufferBinding>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetBufferPointervRobustANGLE(context, targetPacked, pname,
                                                                 bufSize, length, params));
        if (isCallValid)
        {
            context->getBufferPointervRobust(targetPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetBufferPointervRobustANGLE, isCallValid, context, targetPacked, pname,
                      bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetIntegeri_vRobustANGLE(GLenum target,
                                             GLuint index,
                                             GLsizei bufSize,
                                             GLsizei *length,
                                             GLint *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetIntegeri_vRobustANGLE,
          "context = %d, target = %s, index = %u, bufSize = %d, length = 0x%016" PRIxPTR
          ", data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target), index, bufSize,
          (uintptr_t)length, (uintptr_t)data);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetIntegeri_vRobustANGLE(context, target, index, bufSize, length, data));
        if (isCallValid)
        {
            context->getIntegeri_vRobust(target, index, bufSize, length, data);
        }
        ANGLE_CAPTURE(GetIntegeri_vRobustANGLE, isCallValid, context, target, index, bufSize,
                      length, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetInternalformativRobustANGLE(GLenum target,
                                                   GLenum internalformat,
                                                   GLenum pname,
                                                   GLsizei bufSize,
                                                   GLsizei *length,
                                                   GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetInternalformativRobustANGLE,
          "context = %d, target = %s, internalformat = %s, pname = %s, bufSize = %d, length = "
          "0x%016" PRIxPTR ", params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target),
          GLenumToString(GLenumGroup::DefaultGroup, internalformat),
          GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize, (uintptr_t)length,
          (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetInternalformativRobustANGLE(context, target, internalformat,
                                                                   pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getInternalformativRobust(target, internalformat, pname, bufSize, length,
                                               params);
        }
        ANGLE_CAPTURE(GetInternalformativRobustANGLE, isCallValid, context, target, internalformat,
                      pname, bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetVertexAttribIivRobustANGLE(GLuint index,
                                                  GLenum pname,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetVertexAttribIivRobustANGLE,
          "context = %d, index = %u, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), index, GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetVertexAttribIivRobustANGLE(context, index, pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getVertexAttribIivRobust(index, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetVertexAttribIivRobustANGLE, isCallValid, context, index, pname, bufSize,
                      length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetVertexAttribIuivRobustANGLE(GLuint index,
                                                   GLenum pname,
                                                   GLsizei bufSize,
                                                   GLsizei *length,
                                                   GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetVertexAttribIuivRobustANGLE,
          "context = %d, index = %u, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), index, GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetVertexAttribIuivRobustANGLE(
                                              context, index, pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getVertexAttribIuivRobust(index, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetVertexAttribIuivRobustANGLE, isCallValid, context, index, pname, bufSize,
                      length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetUniformuivRobustANGLE(GLuint program,
                                             GLint location,
                                             GLsizei bufSize,
                                             GLsizei *length,
                                             GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetUniformuivRobustANGLE,
          "context = %d, program = %u, location = %d, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetUniformuivRobustANGLE(context, programPacked, locationPacked,
                                                             bufSize, length, params));
        if (isCallValid)
        {
            context->getUniformuivRobust(programPacked, locationPacked, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetUniformuivRobustANGLE, isCallValid, context, programPacked, locationPacked,
                      bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetActiveUniformBlockivRobustANGLE(GLuint program,
                                                       GLuint uniformBlockIndex,
                                                       GLenum pname,
                                                       GLsizei bufSize,
                                                       GLsizei *length,
                                                       GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetActiveUniformBlockivRobustANGLE,
          "context = %d, program = %u, uniformBlockIndex = %u, pname = %s, bufSize = %d, length = "
          "0x%016" PRIxPTR ", params = 0x%016" PRIxPTR "",
          CID(context), program, uniformBlockIndex,
          GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize, (uintptr_t)length,
          (uintptr_t)params);

    if (context)
    {
        ShaderProgramID programPacked             = PackParam<ShaderProgramID>(program);
        UniformBlockIndex uniformBlockIndexPacked = PackParam<UniformBlockIndex>(uniformBlockIndex);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetActiveUniformBlockivRobustANGLE(
                 context, programPacked, uniformBlockIndexPacked, pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getActiveUniformBlockivRobust(programPacked, uniformBlockIndexPacked, pname,
                                                   bufSize, length, params);
        }
        ANGLE_CAPTURE(GetActiveUniformBlockivRobustANGLE, isCallValid, context, programPacked,
                      uniformBlockIndexPacked, pname, bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetInteger64vRobustANGLE(GLenum pname,
                                             GLsizei bufSize,
                                             GLsizei *length,
                                             GLint64 *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetInteger64vRobustANGLE,
          "context = %d, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)length, (uintptr_t)data);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetInteger64vRobustANGLE(context, pname, bufSize, length, data));
        if (isCallValid)
        {
            context->getInteger64vRobust(pname, bufSize, length, data);
        }
        ANGLE_CAPTURE(GetInteger64vRobustANGLE, isCallValid, context, pname, bufSize, length, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetInteger64i_vRobustANGLE(GLenum target,
                                               GLuint index,
                                               GLsizei bufSize,
                                               GLsizei *length,
                                               GLint64 *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetInteger64i_vRobustANGLE,
          "context = %d, target = %s, index = %u, bufSize = %d, length = 0x%016" PRIxPTR
          ", data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target), index, bufSize,
          (uintptr_t)length, (uintptr_t)data);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetInteger64i_vRobustANGLE(context, target, index, bufSize, length, data));
        if (isCallValid)
        {
            context->getInteger64i_vRobust(target, index, bufSize, length, data);
        }
        ANGLE_CAPTURE(GetInteger64i_vRobustANGLE, isCallValid, context, target, index, bufSize,
                      length, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetBufferParameteri64vRobustANGLE(GLenum target,
                                                      GLenum pname,
                                                      GLsizei bufSize,
                                                      GLsizei *length,
                                                      GLint64 *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetBufferParameteri64vRobustANGLE,
          "context = %d, target = %s, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target),
          GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize, (uintptr_t)length,
          (uintptr_t)params);

    if (context)
    {
        BufferBinding targetPacked                            = PackParam<BufferBinding>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetBufferParameteri64vRobustANGLE(context, targetPacked, pname,
                                                                      bufSize, length, params));
        if (isCallValid)
        {
            context->getBufferParameteri64vRobust(targetPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetBufferParameteri64vRobustANGLE, isCallValid, context, targetPacked, pname,
                      bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_SamplerParameterivRobustANGLE(GLuint sampler,
                                                  GLuint pname,
                                                  GLsizei bufSize,
                                                  const GLint *param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSamplerParameterivRobustANGLE,
          "context = %d, sampler = %u, pname = %u, bufSize = %d, param = 0x%016" PRIxPTR "",
          CID(context), sampler, pname, bufSize, (uintptr_t)param);

    if (context)
    {
        SamplerID samplerPacked                               = PackParam<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateSamplerParameterivRobustANGLE(context, samplerPacked, pname, bufSize, param));
        if (isCallValid)
        {
            context->samplerParameterivRobust(samplerPacked, pname, bufSize, param);
        }
        ANGLE_CAPTURE(SamplerParameterivRobustANGLE, isCallValid, context, samplerPacked, pname,
                      bufSize, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_SamplerParameterfvRobustANGLE(GLuint sampler,
                                                  GLenum pname,
                                                  GLsizei bufSize,
                                                  const GLfloat *param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSamplerParameterfvRobustANGLE,
          "context = %d, sampler = %u, pname = %s, bufSize = %d, param = 0x%016" PRIxPTR "",
          CID(context), sampler, GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)param);

    if (context)
    {
        SamplerID samplerPacked                               = PackParam<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateSamplerParameterfvRobustANGLE(context, samplerPacked, pname, bufSize, param));
        if (isCallValid)
        {
            context->samplerParameterfvRobust(samplerPacked, pname, bufSize, param);
        }
        ANGLE_CAPTURE(SamplerParameterfvRobustANGLE, isCallValid, context, samplerPacked, pname,
                      bufSize, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetSamplerParameterivRobustANGLE(GLuint sampler,
                                                     GLenum pname,
                                                     GLsizei bufSize,
                                                     GLsizei *length,
                                                     GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetSamplerParameterivRobustANGLE,
          "context = %d, sampler = %u, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), sampler, GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        SamplerID samplerPacked                               = PackParam<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetSamplerParameterivRobustANGLE(context, samplerPacked, pname,
                                                                     bufSize, length, params));
        if (isCallValid)
        {
            context->getSamplerParameterivRobust(samplerPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetSamplerParameterivRobustANGLE, isCallValid, context, samplerPacked, pname,
                      bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetSamplerParameterfvRobustANGLE(GLuint sampler,
                                                     GLenum pname,
                                                     GLsizei bufSize,
                                                     GLsizei *length,
                                                     GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetSamplerParameterfvRobustANGLE,
          "context = %d, sampler = %u, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), sampler, GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        SamplerID samplerPacked                               = PackParam<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetSamplerParameterfvRobustANGLE(context, samplerPacked, pname,
                                                                     bufSize, length, params));
        if (isCallValid)
        {
            context->getSamplerParameterfvRobust(samplerPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetSamplerParameterfvRobustANGLE, isCallValid, context, samplerPacked, pname,
                      bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetFramebufferParameterivRobustANGLE(GLenum target,
                                                         GLenum pname,
                                                         GLsizei bufSize,
                                                         GLsizei *length,
                                                         GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetFramebufferParameterivRobustANGLE,
          "context = %d, target = %s, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target),
          GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize, (uintptr_t)length,
          (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetFramebufferParameterivRobustANGLE(
                                              context, target, pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getFramebufferParameterivRobust(target, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetFramebufferParameterivRobustANGLE, isCallValid, context, target, pname,
                      bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetProgramInterfaceivRobustANGLE(GLuint program,
                                                     GLenum programInterface,
                                                     GLenum pname,
                                                     GLsizei bufSize,
                                                     GLsizei *length,
                                                     GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetProgramInterfaceivRobustANGLE,
          "context = %d, program = %u, programInterface = %s, pname = %s, bufSize = %d, length = "
          "0x%016" PRIxPTR ", params = 0x%016" PRIxPTR "",
          CID(context), program, GLenumToString(GLenumGroup::DefaultGroup, programInterface),
          GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize, (uintptr_t)length,
          (uintptr_t)params);

    if (context)
    {
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetProgramInterfaceivRobustANGLE(context, programPacked, programInterface,
                                                      pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getProgramInterfaceivRobust(programPacked, programInterface, pname, bufSize,
                                                 length, params);
        }
        ANGLE_CAPTURE(GetProgramInterfaceivRobustANGLE, isCallValid, context, programPacked,
                      programInterface, pname, bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetBooleani_vRobustANGLE(GLenum target,
                                             GLuint index,
                                             GLsizei bufSize,
                                             GLsizei *length,
                                             GLboolean *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetBooleani_vRobustANGLE,
          "context = %d, target = %s, index = %u, bufSize = %d, length = 0x%016" PRIxPTR
          ", data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target), index, bufSize,
          (uintptr_t)length, (uintptr_t)data);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetBooleani_vRobustANGLE(context, target, index, bufSize, length, data));
        if (isCallValid)
        {
            context->getBooleani_vRobust(target, index, bufSize, length, data);
        }
        ANGLE_CAPTURE(GetBooleani_vRobustANGLE, isCallValid, context, target, index, bufSize,
                      length, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetMultisamplefvRobustANGLE(GLenum pname,
                                                GLuint index,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLfloat *val)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetMultisamplefvRobustANGLE,
          "context = %d, pname = %s, index = %u, bufSize = %d, length = 0x%016" PRIxPTR
          ", val = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, pname), index, bufSize,
          (uintptr_t)length, (uintptr_t)val);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetMultisamplefvRobustANGLE(context, pname, index, bufSize, length, val));
        if (isCallValid)
        {
            context->getMultisamplefvRobust(pname, index, bufSize, length, val);
        }
        ANGLE_CAPTURE(GetMultisamplefvRobustANGLE, isCallValid, context, pname, index, bufSize,
                      length, val);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetTexLevelParameterivRobustANGLE(GLenum target,
                                                      GLint level,
                                                      GLenum pname,
                                                      GLsizei bufSize,
                                                      GLsizei *length,
                                                      GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexLevelParameterivRobustANGLE,
          "context = %d, target = %s, level = %d, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target), level,
          GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize, (uintptr_t)length,
          (uintptr_t)params);

    if (context)
    {
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetTexLevelParameterivRobustANGLE(
                                context, targetPacked, level, pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getTexLevelParameterivRobust(targetPacked, level, pname, bufSize, length,
                                                  params);
        }
        ANGLE_CAPTURE(GetTexLevelParameterivRobustANGLE, isCallValid, context, targetPacked, level,
                      pname, bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetTexLevelParameterfvRobustANGLE(GLenum target,
                                                      GLint level,
                                                      GLenum pname,
                                                      GLsizei bufSize,
                                                      GLsizei *length,
                                                      GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexLevelParameterfvRobustANGLE,
          "context = %d, target = %s, level = %d, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target), level,
          GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize, (uintptr_t)length,
          (uintptr_t)params);

    if (context)
    {
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetTexLevelParameterfvRobustANGLE(
                                context, targetPacked, level, pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getTexLevelParameterfvRobust(targetPacked, level, pname, bufSize, length,
                                                  params);
        }
        ANGLE_CAPTURE(GetTexLevelParameterfvRobustANGLE, isCallValid, context, targetPacked, level,
                      pname, bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetPointervRobustANGLERobustANGLE(GLenum pname,
                                                      GLsizei bufSize,
                                                      GLsizei *length,
                                                      void **params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetPointervRobustANGLERobustANGLE,
          "context = %d, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetPointervRobustANGLERobustANGLE(context, pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getPointervRobustANGLERobust(pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetPointervRobustANGLERobustANGLE, isCallValid, context, pname, bufSize,
                      length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ReadnPixelsRobustANGLE(GLint x,
                                           GLint y,
                                           GLsizei width,
                                           GLsizei height,
                                           GLenum format,
                                           GLenum type,
                                           GLsizei bufSize,
                                           GLsizei *length,
                                           GLsizei *columns,
                                           GLsizei *rows,
                                           void *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLReadnPixelsRobustANGLE,
          "context = %d, x = %d, y = %d, width = %d, height = %d, format = %s, type = %s, bufSize "
          "= %d, length = 0x%016" PRIxPTR ", columns = 0x%016" PRIxPTR ", rows = 0x%016" PRIxPTR
          ", data = 0x%016" PRIxPTR "",
          CID(context), x, y, width, height, GLenumToString(GLenumGroup::DefaultGroup, format),
          GLenumToString(GLenumGroup::DefaultGroup, type), bufSize, (uintptr_t)length,
          (uintptr_t)columns, (uintptr_t)rows, (uintptr_t)data);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateReadnPixelsRobustANGLE(context, x, y, width, height, format, type, bufSize,
                                            length, columns, rows, data));
        if (isCallValid)
        {
            context->readnPixelsRobust(x, y, width, height, format, type, bufSize, length, columns,
                                       rows, data);
        }
        ANGLE_CAPTURE(ReadnPixelsRobustANGLE, isCallValid, context, x, y, width, height, format,
                      type, bufSize, length, columns, rows, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetnUniformfvRobustANGLE(GLuint program,
                                             GLint location,
                                             GLsizei bufSize,
                                             GLsizei *length,
                                             GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetnUniformfvRobustANGLE,
          "context = %d, program = %u, location = %d, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetnUniformfvRobustANGLE(context, programPacked, locationPacked,
                                                             bufSize, length, params));
        if (isCallValid)
        {
            context->getnUniformfvRobust(programPacked, locationPacked, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetnUniformfvRobustANGLE, isCallValid, context, programPacked, locationPacked,
                      bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetnUniformivRobustANGLE(GLuint program,
                                             GLint location,
                                             GLsizei bufSize,
                                             GLsizei *length,
                                             GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetnUniformivRobustANGLE,
          "context = %d, program = %u, location = %d, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetnUniformivRobustANGLE(context, programPacked, locationPacked,
                                                             bufSize, length, params));
        if (isCallValid)
        {
            context->getnUniformivRobust(programPacked, locationPacked, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetnUniformivRobustANGLE, isCallValid, context, programPacked, locationPacked,
                      bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetnUniformuivRobustANGLE(GLuint program,
                                              GLint location,
                                              GLsizei bufSize,
                                              GLsizei *length,
                                              GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetnUniformuivRobustANGLE,
          "context = %d, program = %u, location = %d, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetnUniformuivRobustANGLE(
                                context, programPacked, locationPacked, bufSize, length, params));
        if (isCallValid)
        {
            context->getnUniformuivRobust(programPacked, locationPacked, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetnUniformuivRobustANGLE, isCallValid, context, programPacked,
                      locationPacked, bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexParameterIivRobustANGLE(GLenum target,
                                               GLenum pname,
                                               GLsizei bufSize,
                                               const GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexParameterIivRobustANGLE,
          "context = %d, target = %s, pname = %s, bufSize = %d, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target),
          GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize, (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexParameterIivRobustANGLE(context, targetPacked, pname, bufSize, params));
        if (isCallValid)
        {
            context->texParameterIivRobust(targetPacked, pname, bufSize, params);
        }
        ANGLE_CAPTURE(TexParameterIivRobustANGLE, isCallValid, context, targetPacked, pname,
                      bufSize, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexParameterIuivRobustANGLE(GLenum target,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                const GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexParameterIuivRobustANGLE,
          "context = %d, target = %s, pname = %s, bufSize = %d, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target),
          GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize, (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexParameterIuivRobustANGLE(context, targetPacked, pname, bufSize, params));
        if (isCallValid)
        {
            context->texParameterIuivRobust(targetPacked, pname, bufSize, params);
        }
        ANGLE_CAPTURE(TexParameterIuivRobustANGLE, isCallValid, context, targetPacked, pname,
                      bufSize, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetTexParameterIivRobustANGLE(GLenum target,
                                                  GLenum pname,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexParameterIivRobustANGLE,
          "context = %d, target = %s, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target),
          GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize, (uintptr_t)length,
          (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetTexParameterIivRobustANGLE(context, targetPacked, pname,
                                                                  bufSize, length, params));
        if (isCallValid)
        {
            context->getTexParameterIivRobust(targetPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetTexParameterIivRobustANGLE, isCallValid, context, targetPacked, pname,
                      bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetTexParameterIuivRobustANGLE(GLenum target,
                                                   GLenum pname,
                                                   GLsizei bufSize,
                                                   GLsizei *length,
                                                   GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexParameterIuivRobustANGLE,
          "context = %d, target = %s, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target),
          GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize, (uintptr_t)length,
          (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetTexParameterIuivRobustANGLE(context, targetPacked, pname,
                                                                   bufSize, length, params));
        if (isCallValid)
        {
            context->getTexParameterIuivRobust(targetPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetTexParameterIuivRobustANGLE, isCallValid, context, targetPacked, pname,
                      bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_SamplerParameterIivRobustANGLE(GLuint sampler,
                                                   GLenum pname,
                                                   GLsizei bufSize,
                                                   const GLint *param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSamplerParameterIivRobustANGLE,
          "context = %d, sampler = %u, pname = %s, bufSize = %d, param = 0x%016" PRIxPTR "",
          CID(context), sampler, GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)param);

    if (context)
    {
        SamplerID samplerPacked                               = PackParam<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateSamplerParameterIivRobustANGLE(context, samplerPacked, pname, bufSize, param));
        if (isCallValid)
        {
            context->samplerParameterIivRobust(samplerPacked, pname, bufSize, param);
        }
        ANGLE_CAPTURE(SamplerParameterIivRobustANGLE, isCallValid, context, samplerPacked, pname,
                      bufSize, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_SamplerParameterIuivRobustANGLE(GLuint sampler,
                                                    GLenum pname,
                                                    GLsizei bufSize,
                                                    const GLuint *param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSamplerParameterIuivRobustANGLE,
          "context = %d, sampler = %u, pname = %s, bufSize = %d, param = 0x%016" PRIxPTR "",
          CID(context), sampler, GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)param);

    if (context)
    {
        SamplerID samplerPacked                               = PackParam<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateSamplerParameterIuivRobustANGLE(
                                              context, samplerPacked, pname, bufSize, param));
        if (isCallValid)
        {
            context->samplerParameterIuivRobust(samplerPacked, pname, bufSize, param);
        }
        ANGLE_CAPTURE(SamplerParameterIuivRobustANGLE, isCallValid, context, samplerPacked, pname,
                      bufSize, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetSamplerParameterIivRobustANGLE(GLuint sampler,
                                                      GLenum pname,
                                                      GLsizei bufSize,
                                                      GLsizei *length,
                                                      GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetSamplerParameterIivRobustANGLE,
          "context = %d, sampler = %u, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), sampler, GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        SamplerID samplerPacked                               = PackParam<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetSamplerParameterIivRobustANGLE(context, samplerPacked, pname,
                                                                      bufSize, length, params));
        if (isCallValid)
        {
            context->getSamplerParameterIivRobust(samplerPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetSamplerParameterIivRobustANGLE, isCallValid, context, samplerPacked, pname,
                      bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetSamplerParameterIuivRobustANGLE(GLuint sampler,
                                                       GLenum pname,
                                                       GLsizei bufSize,
                                                       GLsizei *length,
                                                       GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetSamplerParameterIuivRobustANGLE,
          "context = %d, sampler = %u, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), sampler, GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        SamplerID samplerPacked                               = PackParam<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetSamplerParameterIuivRobustANGLE(
                                context, samplerPacked, pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getSamplerParameterIuivRobust(samplerPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetSamplerParameterIuivRobustANGLE, isCallValid, context, samplerPacked,
                      pname, bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetQueryObjectivRobustANGLE(GLuint id,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLint *params)
{
    Context *context = GetGlobalContext();
    EVENT(context, GLGetQueryObjectivRobustANGLE,
          "context = %d, id = %u, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), id, GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        QueryID idPacked                                      = PackParam<QueryID>(id);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetQueryObjectivRobustANGLE(
                                              context, idPacked, pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getQueryObjectivRobust(idPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetQueryObjectivRobustANGLE, isCallValid, context, idPacked, pname, bufSize,
                      length, params);
    }
    else
    {}
}

void GL_APIENTRY GL_GetQueryObjecti64vRobustANGLE(GLuint id,
                                                  GLenum pname,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLint64 *params)
{
    Context *context = GetGlobalContext();
    EVENT(context, GLGetQueryObjecti64vRobustANGLE,
          "context = %d, id = %u, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), id, GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        QueryID idPacked                                      = PackParam<QueryID>(id);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetQueryObjecti64vRobustANGLE(
                                              context, idPacked, pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getQueryObjecti64vRobust(idPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetQueryObjecti64vRobustANGLE, isCallValid, context, idPacked, pname, bufSize,
                      length, params);
    }
    else
    {}
}

void GL_APIENTRY GL_GetQueryObjectui64vRobustANGLE(GLuint id,
                                                   GLenum pname,
                                                   GLsizei bufSize,
                                                   GLsizei *length,
                                                   GLuint64 *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetQueryObjectui64vRobustANGLE,
          "context = %d, id = %u, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), id, GLenumToString(GLenumGroup::DefaultGroup, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (context)
    {
        QueryID idPacked                                      = PackParam<QueryID>(id);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetQueryObjectui64vRobustANGLE(
                                              context, idPacked, pname, bufSize, length, params));
        if (isCallValid)
        {
            context->getQueryObjectui64vRobust(idPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE(GetQueryObjectui64vRobustANGLE, isCallValid, context, idPacked, pname,
                      bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_ANGLE_semaphore_fuchsia
void GL_APIENTRY GL_ImportSemaphoreZirconHandleANGLE(GLuint semaphore,
                                                     GLenum handleType,
                                                     GLuint handle)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLImportSemaphoreZirconHandleANGLE,
          "context = %d, semaphore = %u, handleType = %s, handle = %u", CID(context), semaphore,
          GLenumToString(GLenumGroup::ExternalHandleType, handleType), handle);

    if (context)
    {
        SemaphoreID semaphorePacked                           = PackParam<SemaphoreID>(semaphore);
        HandleType handleTypePacked                           = PackParam<HandleType>(handleType);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateImportSemaphoreZirconHandleANGLE(
                                              context, semaphorePacked, handleTypePacked, handle));
        if (isCallValid)
        {
            context->importSemaphoreZirconHandle(semaphorePacked, handleTypePacked, handle);
        }
        ANGLE_CAPTURE(ImportSemaphoreZirconHandleANGLE, isCallValid, context, semaphorePacked,
                      handleTypePacked, handle);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_ANGLE_texture_external_update
void GL_APIENTRY GL_TexImage2DExternalANGLE(GLenum target,
                                            GLint level,
                                            GLint internalformat,
                                            GLsizei width,
                                            GLsizei height,
                                            GLint border,
                                            GLenum format,
                                            GLenum type)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexImage2DExternalANGLE,
          "context = %d, target = %s, level = %d, internalformat = %d, width = %d, height = %d, "
          "border = %d, format = %s, type = %s",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level, internalformat,
          width, height, border, GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type));

    if (context)
    {
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexImage2DExternalANGLE(context, targetPacked, level, internalformat, width,
                                             height, border, format, type));
        if (isCallValid)
        {
            context->texImage2DExternal(targetPacked, level, internalformat, width, height, border,
                                        format, type);
        }
        ANGLE_CAPTURE(TexImage2DExternalANGLE, isCallValid, context, targetPacked, level,
                      internalformat, width, height, border, format, type);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_InvalidateTextureANGLE(GLenum target)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLInvalidateTextureANGLE, "context = %d, target = %s", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target));

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateInvalidateTextureANGLE(context, targetPacked));
        if (isCallValid)
        {
            context->invalidateTexture(targetPacked);
        }
        ANGLE_CAPTURE(InvalidateTextureANGLE, isCallValid, context, targetPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_ANGLE_texture_multisample
void GL_APIENTRY GL_TexStorage2DMultisampleANGLE(GLenum target,
                                                 GLsizei samples,
                                                 GLenum internalformat,
                                                 GLsizei width,
                                                 GLsizei height,
                                                 GLboolean fixedsamplelocations)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexStorage2DMultisampleANGLE,
          "context = %d, target = %s, samples = %d, internalformat = %s, width = %d, height = %d, "
          "fixedsamplelocations = %s",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target), samples,
          GLenumToString(GLenumGroup::DefaultGroup, internalformat), width, height,
          GLbooleanToString(fixedsamplelocations));

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexStorage2DMultisampleANGLE(context, targetPacked, samples, internalformat,
                                                  width, height, fixedsamplelocations));
        if (isCallValid)
        {
            context->texStorage2DMultisample(targetPacked, samples, internalformat, width, height,
                                             fixedsamplelocations);
        }
        ANGLE_CAPTURE(TexStorage2DMultisampleANGLE, isCallValid, context, targetPacked, samples,
                      internalformat, width, height, fixedsamplelocations);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetMultisamplefvANGLE(GLenum pname, GLuint index, GLfloat *val)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetMultisamplefvANGLE,
          "context = %d, pname = %s, index = %u, val = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::DefaultGroup, pname), index, (uintptr_t)val);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetMultisamplefvANGLE(context, pname, index, val));
        if (isCallValid)
        {
            context->getMultisamplefv(pname, index, val);
        }
        ANGLE_CAPTURE(GetMultisamplefvANGLE, isCallValid, context, pname, index, val);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_SampleMaskiANGLE(GLuint maskNumber, GLbitfield mask)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSampleMaskiANGLE, "context = %d, maskNumber = %u, mask = %s", CID(context),
          maskNumber, GLbitfieldToString(GLenumGroup::DefaultGroup, mask).c_str());

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateSampleMaskiANGLE(context, maskNumber, mask));
        if (isCallValid)
        {
            context->sampleMaski(maskNumber, mask);
        }
        ANGLE_CAPTURE(SampleMaskiANGLE, isCallValid, context, maskNumber, mask);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GetTexLevelParameterfvANGLE is already defined.

// GetTexLevelParameterivANGLE is already defined.

// GL_ANGLE_translated_shader_source
void GL_APIENTRY GL_GetTranslatedShaderSourceANGLE(GLuint shader,
                                                   GLsizei bufsize,
                                                   GLsizei *length,
                                                   GLchar *source)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTranslatedShaderSourceANGLE,
          "context = %d, shader = %u, bufsize = %d, length = 0x%016" PRIxPTR
          ", source = 0x%016" PRIxPTR "",
          CID(context), shader, bufsize, (uintptr_t)length, (uintptr_t)source);

    if (context)
    {
        ShaderProgramID shaderPacked                          = PackParam<ShaderProgramID>(shader);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetTranslatedShaderSourceANGLE(
                                              context, shaderPacked, bufsize, length, source));
        if (isCallValid)
        {
            context->getTranslatedShaderSource(shaderPacked, bufsize, length, source);
        }
        ANGLE_CAPTURE(GetTranslatedShaderSourceANGLE, isCallValid, context, shaderPacked, bufsize,
                      length, source);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_CHROMIUM_bind_uniform_location
void GL_APIENTRY GL_BindUniformLocationCHROMIUM(GLuint program, GLint location, const GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBindUniformLocationCHROMIUM,
          "context = %d, program = %u, location = %d, name = 0x%016" PRIxPTR "", CID(context),
          program, location, (uintptr_t)name);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateBindUniformLocationCHROMIUM(context, programPacked, locationPacked, name));
        if (isCallValid)
        {
            context->bindUniformLocation(programPacked, locationPacked, name);
        }
        ANGLE_CAPTURE(BindUniformLocationCHROMIUM, isCallValid, context, programPacked,
                      locationPacked, name);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_CHROMIUM_copy_compressed_texture
void GL_APIENTRY GL_CompressedCopyTextureCHROMIUM(GLuint sourceId, GLuint destId)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCompressedCopyTextureCHROMIUM, "context = %d, sourceId = %u, destId = %u",
          CID(context), sourceId, destId);

    if (context)
    {
        TextureID sourceIdPacked                              = PackParam<TextureID>(sourceId);
        TextureID destIdPacked                                = PackParam<TextureID>(destId);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateCompressedCopyTextureCHROMIUM(context, sourceIdPacked, destIdPacked));
        if (isCallValid)
        {
            context->compressedCopyTexture(sourceIdPacked, destIdPacked);
        }
        ANGLE_CAPTURE(CompressedCopyTextureCHROMIUM, isCallValid, context, sourceIdPacked,
                      destIdPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_CHROMIUM_copy_texture
void GL_APIENTRY GL_CopyTextureCHROMIUM(GLuint sourceId,
                                        GLint sourceLevel,
                                        GLenum destTarget,
                                        GLuint destId,
                                        GLint destLevel,
                                        GLint internalFormat,
                                        GLenum destType,
                                        GLboolean unpackFlipY,
                                        GLboolean unpackPremultiplyAlpha,
                                        GLboolean unpackUnmultiplyAlpha)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCopyTextureCHROMIUM,
          "context = %d, sourceId = %u, sourceLevel = %d, destTarget = %s, destId = %u, destLevel "
          "= %d, internalFormat = %d, destType = %s, unpackFlipY = %s, unpackPremultiplyAlpha = "
          "%s, unpackUnmultiplyAlpha = %s",
          CID(context), sourceId, sourceLevel,
          GLenumToString(GLenumGroup::DefaultGroup, destTarget), destId, destLevel, internalFormat,
          GLenumToString(GLenumGroup::DefaultGroup, destType), GLbooleanToString(unpackFlipY),
          GLbooleanToString(unpackPremultiplyAlpha), GLbooleanToString(unpackUnmultiplyAlpha));

    if (context)
    {
        TextureID sourceIdPacked       = PackParam<TextureID>(sourceId);
        TextureTarget destTargetPacked = PackParam<TextureTarget>(destTarget);
        TextureID destIdPacked         = PackParam<TextureID>(destId);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateCopyTextureCHROMIUM(
                                context, sourceIdPacked, sourceLevel, destTargetPacked,
                                destIdPacked, destLevel, internalFormat, destType, unpackFlipY,
                                unpackPremultiplyAlpha, unpackUnmultiplyAlpha));
        if (isCallValid)
        {
            context->copyTexture(sourceIdPacked, sourceLevel, destTargetPacked, destIdPacked,
                                 destLevel, internalFormat, destType, unpackFlipY,
                                 unpackPremultiplyAlpha, unpackUnmultiplyAlpha);
        }
        ANGLE_CAPTURE(CopyTextureCHROMIUM, isCallValid, context, sourceIdPacked, sourceLevel,
                      destTargetPacked, destIdPacked, destLevel, internalFormat, destType,
                      unpackFlipY, unpackPremultiplyAlpha, unpackUnmultiplyAlpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_CopySubTextureCHROMIUM(GLuint sourceId,
                                           GLint sourceLevel,
                                           GLenum destTarget,
                                           GLuint destId,
                                           GLint destLevel,
                                           GLint xoffset,
                                           GLint yoffset,
                                           GLint x,
                                           GLint y,
                                           GLint width,
                                           GLint height,
                                           GLboolean unpackFlipY,
                                           GLboolean unpackPremultiplyAlpha,
                                           GLboolean unpackUnmultiplyAlpha)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCopySubTextureCHROMIUM,
          "context = %d, sourceId = %u, sourceLevel = %d, destTarget = %s, destId = %u, destLevel "
          "= %d, xoffset = %d, yoffset = %d, x = %d, y = %d, width = %d, height = %d, unpackFlipY "
          "= %s, unpackPremultiplyAlpha = %s, unpackUnmultiplyAlpha = %s",
          CID(context), sourceId, sourceLevel,
          GLenumToString(GLenumGroup::DefaultGroup, destTarget), destId, destLevel, xoffset,
          yoffset, x, y, width, height, GLbooleanToString(unpackFlipY),
          GLbooleanToString(unpackPremultiplyAlpha), GLbooleanToString(unpackUnmultiplyAlpha));

    if (context)
    {
        TextureID sourceIdPacked       = PackParam<TextureID>(sourceId);
        TextureTarget destTargetPacked = PackParam<TextureTarget>(destTarget);
        TextureID destIdPacked         = PackParam<TextureID>(destId);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateCopySubTextureCHROMIUM(
                                context, sourceIdPacked, sourceLevel, destTargetPacked,
                                destIdPacked, destLevel, xoffset, yoffset, x, y, width, height,
                                unpackFlipY, unpackPremultiplyAlpha, unpackUnmultiplyAlpha));
        if (isCallValid)
        {
            context->copySubTexture(sourceIdPacked, sourceLevel, destTargetPacked, destIdPacked,
                                    destLevel, xoffset, yoffset, x, y, width, height, unpackFlipY,
                                    unpackPremultiplyAlpha, unpackUnmultiplyAlpha);
        }
        ANGLE_CAPTURE(CopySubTextureCHROMIUM, isCallValid, context, sourceIdPacked, sourceLevel,
                      destTargetPacked, destIdPacked, destLevel, xoffset, yoffset, x, y, width,
                      height, unpackFlipY, unpackPremultiplyAlpha, unpackUnmultiplyAlpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_CHROMIUM_framebuffer_mixed_samples
void GL_APIENTRY GL_CoverageModulationCHROMIUM(GLenum components)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCoverageModulationCHROMIUM, "context = %d, components = %s", CID(context),
          GLenumToString(GLenumGroup::DefaultGroup, components));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateCoverageModulationCHROMIUM(context, components));
        if (isCallValid)
        {
            context->coverageModulation(components);
        }
        ANGLE_CAPTURE(CoverageModulationCHROMIUM, isCallValid, context, components);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_CHROMIUM_lose_context
void GL_APIENTRY GL_LoseContextCHROMIUM(GLenum current, GLenum other)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLoseContextCHROMIUM, "context = %d, current = %s, other = %s", CID(context),
          GLenumToString(GLenumGroup::GraphicsResetStatus, current),
          GLenumToString(GLenumGroup::GraphicsResetStatus, other));

    if (context)
    {
        GraphicsResetStatus currentPacked = PackParam<GraphicsResetStatus>(current);
        GraphicsResetStatus otherPacked   = PackParam<GraphicsResetStatus>(other);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateLoseContextCHROMIUM(context, currentPacked, otherPacked));
        if (isCallValid)
        {
            context->loseContext(currentPacked, otherPacked);
        }
        ANGLE_CAPTURE(LoseContextCHROMIUM, isCallValid, context, currentPacked, otherPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_EXT_EGL_image_array

// GL_EXT_YUV_target

// GL_EXT_blend_func_extended
void GL_APIENTRY GL_BindFragDataLocationEXT(GLuint program, GLuint color, const GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBindFragDataLocationEXT,
          "context = %d, program = %u, color = %u, name = 0x%016" PRIxPTR "", CID(context), program,
          color, (uintptr_t)name);

    if (context)
    {
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBindFragDataLocationEXT(context, programPacked, color, name));
        if (isCallValid)
        {
            context->bindFragDataLocation(programPacked, color, name);
        }
        ANGLE_CAPTURE(BindFragDataLocationEXT, isCallValid, context, programPacked, color, name);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_BindFragDataLocationIndexedEXT(GLuint program,
                                                   GLuint colorNumber,
                                                   GLuint index,
                                                   const GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBindFragDataLocationIndexedEXT,
          "context = %d, program = %u, colorNumber = %u, index = %u, name = 0x%016" PRIxPTR "",
          CID(context), program, colorNumber, index, (uintptr_t)name);

    if (context)
    {
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBindFragDataLocationIndexedEXT(
                                              context, programPacked, colorNumber, index, name));
        if (isCallValid)
        {
            context->bindFragDataLocationIndexed(programPacked, colorNumber, index, name);
        }
        ANGLE_CAPTURE(BindFragDataLocationIndexedEXT, isCallValid, context, programPacked,
                      colorNumber, index, name);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

GLint GL_APIENTRY GL_GetFragDataIndexEXT(GLuint program, const GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetFragDataIndexEXT, "context = %d, program = %u, name = 0x%016" PRIxPTR "",
          CID(context), program, (uintptr_t)name);

    GLint returnValue;
    if (context)
    {
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetFragDataIndexEXT(context, programPacked, name));
        if (isCallValid)
        {
            returnValue = context->getFragDataIndex(programPacked, name);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetFragDataIndexEXT, GLint>();
        }
        ANGLE_CAPTURE(GetFragDataIndexEXT, isCallValid, context, programPacked, name, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetFragDataIndexEXT, GLint>();
    }
    return returnValue;
}

GLint GL_APIENTRY GL_GetProgramResourceLocationIndexEXT(GLuint program,
                                                        GLenum programInterface,
                                                        const GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetProgramResourceLocationIndexEXT,
          "context = %d, program = %u, programInterface = %s, name = 0x%016" PRIxPTR "",
          CID(context), program, GLenumToString(GLenumGroup::ProgramInterface, programInterface),
          (uintptr_t)name);

    GLint returnValue;
    if (context)
    {
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetProgramResourceLocationIndexEXT(
                                              context, programPacked, programInterface, name));
        if (isCallValid)
        {
            returnValue =
                context->getProgramResourceLocationIndex(programPacked, programInterface, name);
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLGetProgramResourceLocationIndexEXT,
                                      GLint>();
        }
        ANGLE_CAPTURE(GetProgramResourceLocationIndexEXT, isCallValid, context, programPacked,
                      programInterface, name, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue =
            GetDefaultReturnValue<angle::EntryPoint::GLGetProgramResourceLocationIndexEXT, GLint>();
    }
    return returnValue;
}

// GL_EXT_buffer_storage
void GL_APIENTRY GL_BufferStorageEXT(GLenum target,
                                     GLsizeiptr size,
                                     const void *data,
                                     GLbitfield flags)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBufferStorageEXT,
          "context = %d, target = %s, size = %llu, data = 0x%016" PRIxPTR ", flags = %s",
          CID(context), GLenumToString(GLenumGroup::BufferStorageTarget, target),
          static_cast<unsigned long long>(size), (uintptr_t)data,
          GLbitfieldToString(GLenumGroup::MapBufferUsageMask, flags).c_str());

    if (context)
    {
        BufferBinding targetPacked                            = PackParam<BufferBinding>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBufferStorageEXT(context, targetPacked, size, data, flags));
        if (isCallValid)
        {
            context->bufferStorage(targetPacked, size, data, flags);
        }
        ANGLE_CAPTURE(BufferStorageEXT, isCallValid, context, targetPacked, size, data, flags);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_EXT_clip_control
void GL_APIENTRY GL_ClipControlEXT(GLenum origin, GLenum depth)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLClipControlEXT, "context = %d, origin = %s, depth = %s", CID(context),
          GLenumToString(GLenumGroup::DefaultGroup, origin),
          GLenumToString(GLenumGroup::DefaultGroup, depth));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateClipControlEXT(context, origin, depth));
        if (isCallValid)
        {
            context->clipControl(origin, depth);
        }
        ANGLE_CAPTURE(ClipControlEXT, isCallValid, context, origin, depth);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_EXT_copy_image
void GL_APIENTRY GL_CopyImageSubDataEXT(GLuint srcName,
                                        GLenum srcTarget,
                                        GLint srcLevel,
                                        GLint srcX,
                                        GLint srcY,
                                        GLint srcZ,
                                        GLuint dstName,
                                        GLenum dstTarget,
                                        GLint dstLevel,
                                        GLint dstX,
                                        GLint dstY,
                                        GLint dstZ,
                                        GLsizei srcWidth,
                                        GLsizei srcHeight,
                                        GLsizei srcDepth)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCopyImageSubDataEXT,
          "context = %d, srcName = %u, srcTarget = %s, srcLevel = %d, srcX = %d, srcY = %d, srcZ = "
          "%d, dstName = %u, dstTarget = %s, dstLevel = %d, dstX = %d, dstY = %d, dstZ = %d, "
          "srcWidth = %d, srcHeight = %d, srcDepth = %d",
          CID(context), srcName, GLenumToString(GLenumGroup::CopyBufferSubDataTarget, srcTarget),
          srcLevel, srcX, srcY, srcZ, dstName,
          GLenumToString(GLenumGroup::CopyBufferSubDataTarget, dstTarget), dstLevel, dstX, dstY,
          dstZ, srcWidth, srcHeight, srcDepth);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateCopyImageSubDataEXT(context, srcName, srcTarget, srcLevel, srcX, srcY, srcZ,
                                         dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth,
                                         srcHeight, srcDepth));
        if (isCallValid)
        {
            context->copyImageSubData(srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName,
                                      dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth, srcHeight,
                                      srcDepth);
        }
        ANGLE_CAPTURE(CopyImageSubDataEXT, isCallValid, context, srcName, srcTarget, srcLevel, srcX,
                      srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth,
                      srcHeight, srcDepth);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_EXT_debug_label
void GL_APIENTRY
GL_GetObjectLabelEXT(GLenum type, GLuint object, GLsizei bufSize, GLsizei *length, GLchar *label)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetObjectLabelEXT,
          "context = %d, type = %s, object = %u, bufSize = %d, length = 0x%016" PRIxPTR
          ", label = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, type), object, bufSize,
          (uintptr_t)length, (uintptr_t)label);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetObjectLabelEXT(context, type, object, bufSize, length, label));
        if (isCallValid)
        {
            context->getObjectLabel(type, object, bufSize, length, label);
        }
        ANGLE_CAPTURE(GetObjectLabelEXT, isCallValid, context, type, object, bufSize, length,
                      label);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_LabelObjectEXT(GLenum type, GLuint object, GLsizei length, const GLchar *label)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLabelObjectEXT,
          "context = %d, type = %s, object = %u, length = %d, label = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, type), object, length,
          (uintptr_t)label);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateLabelObjectEXT(context, type, object, length, label));
        if (isCallValid)
        {
            context->labelObject(type, object, length, label);
        }
        ANGLE_CAPTURE(LabelObjectEXT, isCallValid, context, type, object, length, label);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_EXT_debug_marker
void GL_APIENTRY GL_InsertEventMarkerEXT(GLsizei length, const GLchar *marker)
{
    Context *context = GetValidGlobalContext();
    // Don't run the EVENT() macro on the EXT_debug_marker entry points.
    // It can interfere with the debug events being set by the caller.
    // EVENT(context, GLInsertEventMarkerEXT, "context = %d, length = %d, marker = 0x%016" PRIxPTR
    // "", CID(context), length, (uintptr_t)marker);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateInsertEventMarkerEXT(context, length, marker));
        if (isCallValid)
        {
            context->insertEventMarker(length, marker);
        }
        ANGLE_CAPTURE(InsertEventMarkerEXT, isCallValid, context, length, marker);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_PopGroupMarkerEXT()
{
    Context *context = GetValidGlobalContext();
    // Don't run the EVENT() macro on the EXT_debug_marker entry points.
    // It can interfere with the debug events being set by the caller.
    // EVENT(context, GLPopGroupMarkerEXT, "context = %d", CID(context));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidatePopGroupMarkerEXT(context));
        if (isCallValid)
        {
            context->popGroupMarker();
        }
        ANGLE_CAPTURE(PopGroupMarkerEXT, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_PushGroupMarkerEXT(GLsizei length, const GLchar *marker)
{
    Context *context = GetValidGlobalContext();
    // Don't run the EVENT() macro on the EXT_debug_marker entry points.
    // It can interfere with the debug events being set by the caller.
    // EVENT(context, GLPushGroupMarkerEXT, "context = %d, length = %d, marker = 0x%016" PRIxPTR "",
    // CID(context), length, (uintptr_t)marker);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidatePushGroupMarkerEXT(context, length, marker));
        if (isCallValid)
        {
            context->pushGroupMarker(length, marker);
        }
        ANGLE_CAPTURE(PushGroupMarkerEXT, isCallValid, context, length, marker);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_EXT_discard_framebuffer
void GL_APIENTRY GL_DiscardFramebufferEXT(GLenum target,
                                          GLsizei numAttachments,
                                          const GLenum *attachments)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDiscardFramebufferEXT,
          "context = %d, target = %s, numAttachments = %d, attachments = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target), numAttachments,
          (uintptr_t)attachments);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateDiscardFramebufferEXT(context, target, numAttachments, attachments));
        if (isCallValid)
        {
            context->discardFramebuffer(target, numAttachments, attachments);
        }
        ANGLE_CAPTURE(DiscardFramebufferEXT, isCallValid, context, target, numAttachments,
                      attachments);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_EXT_disjoint_timer_query
void GL_APIENTRY GL_BeginQueryEXT(GLenum target, GLuint id)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBeginQueryEXT, "context = %d, target = %s, id = %u", CID(context),
          GLenumToString(GLenumGroup::QueryTarget, target), id);

    if (context)
    {
        QueryType targetPacked                                = PackParam<QueryType>(target);
        QueryID idPacked                                      = PackParam<QueryID>(id);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBeginQueryEXT(context, targetPacked, idPacked));
        if (isCallValid)
        {
            context->beginQuery(targetPacked, idPacked);
        }
        ANGLE_CAPTURE(BeginQueryEXT, isCallValid, context, targetPacked, idPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DeleteQueriesEXT(GLsizei n, const GLuint *ids)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDeleteQueriesEXT, "context = %d, n = %d, ids = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)ids);

    if (context)
    {
        const QueryID *idsPacked                              = PackParam<const QueryID *>(ids);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDeleteQueriesEXT(context, n, idsPacked));
        if (isCallValid)
        {
            context->deleteQueries(n, idsPacked);
        }
        ANGLE_CAPTURE(DeleteQueriesEXT, isCallValid, context, n, idsPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_EndQueryEXT(GLenum target)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLEndQueryEXT, "context = %d, target = %s", CID(context),
          GLenumToString(GLenumGroup::QueryTarget, target));

    if (context)
    {
        QueryType targetPacked                                = PackParam<QueryType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateEndQueryEXT(context, targetPacked));
        if (isCallValid)
        {
            context->endQuery(targetPacked);
        }
        ANGLE_CAPTURE(EndQueryEXT, isCallValid, context, targetPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GenQueriesEXT(GLsizei n, GLuint *ids)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGenQueriesEXT, "context = %d, n = %d, ids = 0x%016" PRIxPTR "", CID(context),
          n, (uintptr_t)ids);

    if (context)
    {
        QueryID *idsPacked                                    = PackParam<QueryID *>(ids);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenQueriesEXT(context, n, idsPacked));
        if (isCallValid)
        {
            context->genQueries(n, idsPacked);
        }
        ANGLE_CAPTURE(GenQueriesEXT, isCallValid, context, n, idsPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetInteger64vEXT(GLenum pname, GLint64 *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetInteger64vEXT, "context = %d, pname = %s, data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::GetPName, pname), (uintptr_t)data);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetInteger64vEXT(context, pname, data));
        if (isCallValid)
        {
            context->getInteger64v(pname, data);
        }
        ANGLE_CAPTURE(GetInteger64vEXT, isCallValid, context, pname, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetQueryObjecti64vEXT(GLuint id, GLenum pname, GLint64 *params)
{
    Context *context = GetGlobalContext();
    EVENT(context, GLGetQueryObjecti64vEXT,
          "context = %d, id = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context), id,
          GLenumToString(GLenumGroup::QueryObjectParameterName, pname), (uintptr_t)params);

    if (context)
    {
        QueryID idPacked                                      = PackParam<QueryID>(id);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetQueryObjecti64vEXT(context, idPacked, pname, params));
        if (isCallValid)
        {
            context->getQueryObjecti64v(idPacked, pname, params);
        }
        ANGLE_CAPTURE(GetQueryObjecti64vEXT, isCallValid, context, idPacked, pname, params);
    }
    else
    {}
}

void GL_APIENTRY GL_GetQueryObjectivEXT(GLuint id, GLenum pname, GLint *params)
{
    Context *context = GetGlobalContext();
    EVENT(context, GLGetQueryObjectivEXT,
          "context = %d, id = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context), id,
          GLenumToString(GLenumGroup::QueryObjectParameterName, pname), (uintptr_t)params);

    if (context)
    {
        QueryID idPacked                                      = PackParam<QueryID>(id);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetQueryObjectivEXT(context, idPacked, pname, params));
        if (isCallValid)
        {
            context->getQueryObjectiv(idPacked, pname, params);
        }
        ANGLE_CAPTURE(GetQueryObjectivEXT, isCallValid, context, idPacked, pname, params);
    }
    else
    {}
}

void GL_APIENTRY GL_GetQueryObjectui64vEXT(GLuint id, GLenum pname, GLuint64 *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetQueryObjectui64vEXT,
          "context = %d, id = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context), id,
          GLenumToString(GLenumGroup::QueryObjectParameterName, pname), (uintptr_t)params);

    if (context)
    {
        QueryID idPacked                                      = PackParam<QueryID>(id);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetQueryObjectui64vEXT(context, idPacked, pname, params));
        if (isCallValid)
        {
            context->getQueryObjectui64v(idPacked, pname, params);
        }
        ANGLE_CAPTURE(GetQueryObjectui64vEXT, isCallValid, context, idPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetQueryObjectuivEXT(GLuint id, GLenum pname, GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetQueryObjectuivEXT,
          "context = %d, id = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context), id,
          GLenumToString(GLenumGroup::QueryObjectParameterName, pname), (uintptr_t)params);

    if (context)
    {
        QueryID idPacked                                      = PackParam<QueryID>(id);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetQueryObjectuivEXT(context, idPacked, pname, params));
        if (isCallValid)
        {
            context->getQueryObjectuiv(idPacked, pname, params);
        }
        ANGLE_CAPTURE(GetQueryObjectuivEXT, isCallValid, context, idPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetQueryivEXT(GLenum target, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetQueryivEXT,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::QueryTarget, target),
          GLenumToString(GLenumGroup::QueryParameterName, pname), (uintptr_t)params);

    if (context)
    {
        QueryType targetPacked                                = PackParam<QueryType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetQueryivEXT(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getQueryiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetQueryivEXT, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

GLboolean GL_APIENTRY GL_IsQueryEXT(GLuint id)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLIsQueryEXT, "context = %d, id = %u", CID(context), id);

    GLboolean returnValue;
    if (context)
    {
        QueryID idPacked                                      = PackParam<QueryID>(id);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateIsQueryEXT(context, idPacked));
        if (isCallValid)
        {
            returnValue = context->isQuery(idPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsQueryEXT, GLboolean>();
        }
        ANGLE_CAPTURE(IsQueryEXT, isCallValid, context, idPacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsQueryEXT, GLboolean>();
    }
    return returnValue;
}

void GL_APIENTRY GL_QueryCounterEXT(GLuint id, GLenum target)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLQueryCounterEXT, "context = %d, id = %u, target = %s", CID(context), id,
          GLenumToString(GLenumGroup::QueryTarget, target));

    if (context)
    {
        QueryID idPacked                                      = PackParam<QueryID>(id);
        QueryType targetPacked                                = PackParam<QueryType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateQueryCounterEXT(context, idPacked, targetPacked));
        if (isCallValid)
        {
            context->queryCounter(idPacked, targetPacked);
        }
        ANGLE_CAPTURE(QueryCounterEXT, isCallValid, context, idPacked, targetPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_EXT_draw_buffers
void GL_APIENTRY GL_DrawBuffersEXT(GLsizei n, const GLenum *bufs)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawBuffersEXT, "context = %d, n = %d, bufs = 0x%016" PRIxPTR "", CID(context),
          n, (uintptr_t)bufs);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawBuffersEXT(context, n, bufs));
        if (isCallValid)
        {
            context->drawBuffers(n, bufs);
        }
        ANGLE_CAPTURE(DrawBuffersEXT, isCallValid, context, n, bufs);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_EXT_draw_buffers_indexed
void GL_APIENTRY GL_BlendEquationSeparateiEXT(GLuint buf, GLenum modeRGB, GLenum modeAlpha)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBlendEquationSeparateiEXT,
          "context = %d, buf = %u, modeRGB = %s, modeAlpha = %s", CID(context), buf,
          GLenumToString(GLenumGroup::BlendEquationModeEXT, modeRGB),
          GLenumToString(GLenumGroup::BlendEquationModeEXT, modeAlpha));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBlendEquationSeparateiEXT(context, buf, modeRGB, modeAlpha));
        if (isCallValid)
        {
            context->blendEquationSeparatei(buf, modeRGB, modeAlpha);
        }
        ANGLE_CAPTURE(BlendEquationSeparateiEXT, isCallValid, context, buf, modeRGB, modeAlpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_BlendEquationiEXT(GLuint buf, GLenum mode)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBlendEquationiEXT, "context = %d, buf = %u, mode = %s", CID(context), buf,
          GLenumToString(GLenumGroup::BlendEquationModeEXT, mode));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBlendEquationiEXT(context, buf, mode));
        if (isCallValid)
        {
            context->blendEquationi(buf, mode);
        }
        ANGLE_CAPTURE(BlendEquationiEXT, isCallValid, context, buf, mode);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY
GL_BlendFuncSeparateiEXT(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBlendFuncSeparateiEXT,
          "context = %d, buf = %u, srcRGB = %s, dstRGB = %s, srcAlpha = %s, dstAlpha = %s",
          CID(context), buf, GLenumToString(GLenumGroup::BlendingFactor, srcRGB),
          GLenumToString(GLenumGroup::BlendingFactor, dstRGB),
          GLenumToString(GLenumGroup::BlendingFactor, srcAlpha),
          GLenumToString(GLenumGroup::BlendingFactor, dstAlpha));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateBlendFuncSeparateiEXT(context, buf, srcRGB, dstRGB, srcAlpha, dstAlpha));
        if (isCallValid)
        {
            context->blendFuncSeparatei(buf, srcRGB, dstRGB, srcAlpha, dstAlpha);
        }
        ANGLE_CAPTURE(BlendFuncSeparateiEXT, isCallValid, context, buf, srcRGB, dstRGB, srcAlpha,
                      dstAlpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_BlendFunciEXT(GLuint buf, GLenum src, GLenum dst)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBlendFunciEXT, "context = %d, buf = %u, src = %s, dst = %s", CID(context), buf,
          GLenumToString(GLenumGroup::BlendingFactor, src),
          GLenumToString(GLenumGroup::BlendingFactor, dst));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBlendFunciEXT(context, buf, src, dst));
        if (isCallValid)
        {
            context->blendFunci(buf, src, dst);
        }
        ANGLE_CAPTURE(BlendFunciEXT, isCallValid, context, buf, src, dst);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ColorMaskiEXT(GLuint index, GLboolean r, GLboolean g, GLboolean b, GLboolean a)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColorMaskiEXT, "context = %d, index = %u, r = %s, g = %s, b = %s, a = %s",
          CID(context), index, GLbooleanToString(r), GLbooleanToString(g), GLbooleanToString(b),
          GLbooleanToString(a));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateColorMaskiEXT(context, index, r, g, b, a));
        if (isCallValid)
        {
            context->colorMaski(index, r, g, b, a);
        }
        ANGLE_CAPTURE(ColorMaskiEXT, isCallValid, context, index, r, g, b, a);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DisableiEXT(GLenum target, GLuint index)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDisableiEXT, "context = %d, target = %s, index = %u", CID(context),
          GLenumToString(GLenumGroup::EnableCap, target), index);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDisableiEXT(context, target, index));
        if (isCallValid)
        {
            context->disablei(target, index);
        }
        ANGLE_CAPTURE(DisableiEXT, isCallValid, context, target, index);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_EnableiEXT(GLenum target, GLuint index)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLEnableiEXT, "context = %d, target = %s, index = %u", CID(context),
          GLenumToString(GLenumGroup::EnableCap, target), index);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateEnableiEXT(context, target, index));
        if (isCallValid)
        {
            context->enablei(target, index);
        }
        ANGLE_CAPTURE(EnableiEXT, isCallValid, context, target, index);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

GLboolean GL_APIENTRY GL_IsEnablediEXT(GLenum target, GLuint index)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLIsEnablediEXT, "context = %d, target = %s, index = %u", CID(context),
          GLenumToString(GLenumGroup::EnableCap, target), index);

    GLboolean returnValue;
    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsEnablediEXT(context, target, index));
        if (isCallValid)
        {
            returnValue = context->isEnabledi(target, index);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsEnablediEXT, GLboolean>();
        }
        ANGLE_CAPTURE(IsEnablediEXT, isCallValid, context, target, index, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsEnablediEXT, GLboolean>();
    }
    return returnValue;
}

// GL_EXT_draw_elements_base_vertex
void GL_APIENTRY GL_DrawElementsBaseVertexEXT(GLenum mode,
                                              GLsizei count,
                                              GLenum type,
                                              const void *indices,
                                              GLint basevertex)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawElementsBaseVertexEXT,
          "context = %d, mode = %s, count = %d, type = %s, indices = 0x%016" PRIxPTR
          ", basevertex = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, basevertex);

    if (context)
    {
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked                           = PackParam<DrawElementsType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDrawElementsBaseVertexEXT(context, modePacked, count,
                                                              typePacked, indices, basevertex));
        if (isCallValid)
        {
            context->drawElementsBaseVertex(modePacked, count, typePacked, indices, basevertex);
        }
        ANGLE_CAPTURE(DrawElementsBaseVertexEXT, isCallValid, context, modePacked, count,
                      typePacked, indices, basevertex);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DrawElementsInstancedBaseVertexEXT(GLenum mode,
                                                       GLsizei count,
                                                       GLenum type,
                                                       const void *indices,
                                                       GLsizei instancecount,
                                                       GLint basevertex)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawElementsInstancedBaseVertexEXT,
          "context = %d, mode = %s, count = %d, type = %s, indices = 0x%016" PRIxPTR
          ", instancecount = %d, basevertex = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, instancecount,
          basevertex);

    if (context)
    {
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked                           = PackParam<DrawElementsType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawElementsInstancedBaseVertexEXT(
                                                             context, modePacked, count, typePacked,
                                                             indices, instancecount, basevertex));
        if (isCallValid)
        {
            context->drawElementsInstancedBaseVertex(modePacked, count, typePacked, indices,
                                                     instancecount, basevertex);
        }
        ANGLE_CAPTURE(DrawElementsInstancedBaseVertexEXT, isCallValid, context, modePacked, count,
                      typePacked, indices, instancecount, basevertex);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DrawRangeElementsBaseVertexEXT(GLenum mode,
                                                   GLuint start,
                                                   GLuint end,
                                                   GLsizei count,
                                                   GLenum type,
                                                   const void *indices,
                                                   GLint basevertex)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawRangeElementsBaseVertexEXT,
          "context = %d, mode = %s, start = %u, end = %u, count = %d, type = %s, indices = "
          "0x%016" PRIxPTR ", basevertex = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), start, end, count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, basevertex);

    if (context)
    {
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked                           = PackParam<DrawElementsType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawRangeElementsBaseVertexEXT(
                                                             context, modePacked, start, end, count,
                                                             typePacked, indices, basevertex));
        if (isCallValid)
        {
            context->drawRangeElementsBaseVertex(modePacked, start, end, count, typePacked, indices,
                                                 basevertex);
        }
        ANGLE_CAPTURE(DrawRangeElementsBaseVertexEXT, isCallValid, context, modePacked, start, end,
                      count, typePacked, indices, basevertex);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultiDrawElementsBaseVertexEXT(GLenum mode,
                                                   const GLsizei *count,
                                                   GLenum type,
                                                   const void *const *indices,
                                                   GLsizei primcount,
                                                   const GLint *basevertex)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiDrawElementsBaseVertexEXT,
          "context = %d, mode = %s, count = 0x%016" PRIxPTR ", type = %s, indices = 0x%016" PRIxPTR
          ", primcount = %d, basevertex = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), (uintptr_t)count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, primcount,
          (uintptr_t)basevertex);

    if (context)
    {
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked                           = PackParam<DrawElementsType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateMultiDrawElementsBaseVertexEXT(
                                                             context, modePacked, count, typePacked,
                                                             indices, primcount, basevertex));
        if (isCallValid)
        {
            context->multiDrawElementsBaseVertex(modePacked, count, typePacked, indices, primcount,
                                                 basevertex);
        }
        ANGLE_CAPTURE(MultiDrawElementsBaseVertexEXT, isCallValid, context, modePacked, count,
                      typePacked, indices, primcount, basevertex);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_EXT_external_buffer
void GL_APIENTRY GL_BufferStorageExternalEXT(GLenum target,
                                             GLintptr offset,
                                             GLsizeiptr size,
                                             GLeglClientBufferEXT clientBuffer,
                                             GLbitfield flags)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBufferStorageExternalEXT,
          "context = %d, target = %s, offset = %llu, size = %llu, clientBuffer = 0x%016" PRIxPTR
          ", flags = %s",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target),
          static_cast<unsigned long long>(offset), static_cast<unsigned long long>(size),
          (uintptr_t)clientBuffer,
          GLbitfieldToString(GLenumGroup::MapBufferUsageMask, flags).c_str());

    if (context)
    {
        BufferBinding targetPacked                            = PackParam<BufferBinding>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBufferStorageExternalEXT(context, targetPacked, offset, size,
                                                             clientBuffer, flags));
        if (isCallValid)
        {
            context->bufferStorageExternal(targetPacked, offset, size, clientBuffer, flags);
        }
        ANGLE_CAPTURE(BufferStorageExternalEXT, isCallValid, context, targetPacked, offset, size,
                      clientBuffer, flags);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_NamedBufferStorageExternalEXT(GLuint buffer,
                                                  GLintptr offset,
                                                  GLsizeiptr size,
                                                  GLeglClientBufferEXT clientBuffer,
                                                  GLbitfield flags)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLNamedBufferStorageExternalEXT,
          "context = %d, buffer = %u, offset = %llu, size = %llu, clientBuffer = 0x%016" PRIxPTR
          ", flags = %s",
          CID(context), buffer, static_cast<unsigned long long>(offset),
          static_cast<unsigned long long>(size), (uintptr_t)clientBuffer,
          GLbitfieldToString(GLenumGroup::MapBufferUsageMask, flags).c_str());

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateNamedBufferStorageExternalEXT(
                                              context, buffer, offset, size, clientBuffer, flags));
        if (isCallValid)
        {
            context->namedBufferStorageExternal(buffer, offset, size, clientBuffer, flags);
        }
        ANGLE_CAPTURE(NamedBufferStorageExternalEXT, isCallValid, context, buffer, offset, size,
                      clientBuffer, flags);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_EXT_geometry_shader
void GL_APIENTRY GL_FramebufferTextureEXT(GLenum target,
                                          GLenum attachment,
                                          GLuint texture,
                                          GLint level)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFramebufferTextureEXT,
          "context = %d, target = %s, attachment = %s, texture = %u, level = %d", CID(context),
          GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment), texture, level);

    if (context)
    {
        TextureID texturePacked                               = PackParam<TextureID>(texture);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateFramebufferTextureEXT(context, target, attachment, texturePacked, level));
        if (isCallValid)
        {
            context->framebufferTexture(target, attachment, texturePacked, level);
        }
        ANGLE_CAPTURE(FramebufferTextureEXT, isCallValid, context, target, attachment,
                      texturePacked, level);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_EXT_instanced_arrays
void GL_APIENTRY GL_DrawArraysInstancedEXT(GLenum mode,
                                           GLint start,
                                           GLsizei count,
                                           GLsizei primcount)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawArraysInstancedEXT,
          "context = %d, mode = %s, start = %d, count = %d, primcount = %d", CID(context),
          GLenumToString(GLenumGroup::PrimitiveType, mode), start, count, primcount);

    if (context)
    {
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateDrawArraysInstancedEXT(context, modePacked, start, count, primcount));
        if (isCallValid)
        {
            context->drawArraysInstanced(modePacked, start, count, primcount);
        }
        ANGLE_CAPTURE(DrawArraysInstancedEXT, isCallValid, context, modePacked, start, count,
                      primcount);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DrawElementsInstancedEXT(GLenum mode,
                                             GLsizei count,
                                             GLenum type,
                                             const void *indices,
                                             GLsizei primcount)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawElementsInstancedEXT,
          "context = %d, mode = %s, count = %d, type = %s, indices = 0x%016" PRIxPTR
          ", primcount = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, primcount);

    if (context)
    {
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked                           = PackParam<DrawElementsType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDrawElementsInstancedEXT(context, modePacked, count, typePacked,
                                                             indices, primcount));
        if (isCallValid)
        {
            context->drawElementsInstanced(modePacked, count, typePacked, indices, primcount);
        }
        ANGLE_CAPTURE(DrawElementsInstancedEXT, isCallValid, context, modePacked, count, typePacked,
                      indices, primcount);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttribDivisorEXT(GLuint index, GLuint divisor)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttribDivisorEXT, "context = %d, index = %u, divisor = %u", CID(context),
          index, divisor);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttribDivisorEXT(context, index, divisor));
        if (isCallValid)
        {
            context->vertexAttribDivisor(index, divisor);
        }
        ANGLE_CAPTURE(VertexAttribDivisorEXT, isCallValid, context, index, divisor);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_EXT_map_buffer_range
void GL_APIENTRY GL_FlushMappedBufferRangeEXT(GLenum target, GLintptr offset, GLsizeiptr length)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFlushMappedBufferRangeEXT,
          "context = %d, target = %s, offset = %llu, length = %llu", CID(context),
          GLenumToString(GLenumGroup::BufferTargetARB, target),
          static_cast<unsigned long long>(offset), static_cast<unsigned long long>(length));

    if (context)
    {
        BufferBinding targetPacked                            = PackParam<BufferBinding>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateFlushMappedBufferRangeEXT(context, targetPacked, offset, length));
        if (isCallValid)
        {
            context->flushMappedBufferRange(targetPacked, offset, length);
        }
        ANGLE_CAPTURE(FlushMappedBufferRangeEXT, isCallValid, context, targetPacked, offset,
                      length);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void *GL_APIENTRY GL_MapBufferRangeEXT(GLenum target,
                                       GLintptr offset,
                                       GLsizeiptr length,
                                       GLbitfield access)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMapBufferRangeEXT,
          "context = %d, target = %s, offset = %llu, length = %llu, access = %s", CID(context),
          GLenumToString(GLenumGroup::BufferTargetARB, target),
          static_cast<unsigned long long>(offset), static_cast<unsigned long long>(length),
          GLbitfieldToString(GLenumGroup::BufferAccessMask, access).c_str());

    void *returnValue;
    if (context)
    {
        BufferBinding targetPacked                            = PackParam<BufferBinding>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMapBufferRangeEXT(context, targetPacked, offset, length, access));
        if (isCallValid)
        {
            returnValue = context->mapBufferRange(targetPacked, offset, length, access);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLMapBufferRangeEXT, void *>();
        }
        ANGLE_CAPTURE(MapBufferRangeEXT, isCallValid, context, targetPacked, offset, length, access,
                      returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLMapBufferRangeEXT, void *>();
    }
    return returnValue;
}

// GL_EXT_memory_object
void GL_APIENTRY GL_BufferStorageMemEXT(GLenum target,
                                        GLsizeiptr size,
                                        GLuint memory,
                                        GLuint64 offset)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBufferStorageMemEXT,
          "context = %d, target = %s, size = %llu, memory = %u, offset = %llu", CID(context),
          GLenumToString(GLenumGroup::BufferTargetARB, target),
          static_cast<unsigned long long>(size), memory, static_cast<unsigned long long>(offset));

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        MemoryObjectID memoryPacked                           = PackParam<MemoryObjectID>(memory);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateBufferStorageMemEXT(context, targetPacked, size, memoryPacked, offset));
        if (isCallValid)
        {
            context->bufferStorageMem(targetPacked, size, memoryPacked, offset);
        }
        ANGLE_CAPTURE(BufferStorageMemEXT, isCallValid, context, targetPacked, size, memoryPacked,
                      offset);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_CreateMemoryObjectsEXT(GLsizei n, GLuint *memoryObjects)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCreateMemoryObjectsEXT,
          "context = %d, n = %d, memoryObjects = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)memoryObjects);

    if (context)
    {
        MemoryObjectID *memoryObjectsPacked = PackParam<MemoryObjectID *>(memoryObjects);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateCreateMemoryObjectsEXT(context, n, memoryObjectsPacked));
        if (isCallValid)
        {
            context->createMemoryObjects(n, memoryObjectsPacked);
        }
        ANGLE_CAPTURE(CreateMemoryObjectsEXT, isCallValid, context, n, memoryObjectsPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DeleteMemoryObjectsEXT(GLsizei n, const GLuint *memoryObjects)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDeleteMemoryObjectsEXT,
          "context = %d, n = %d, memoryObjects = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)memoryObjects);

    if (context)
    {
        const MemoryObjectID *memoryObjectsPacked =
            PackParam<const MemoryObjectID *>(memoryObjects);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDeleteMemoryObjectsEXT(context, n, memoryObjectsPacked));
        if (isCallValid)
        {
            context->deleteMemoryObjects(n, memoryObjectsPacked);
        }
        ANGLE_CAPTURE(DeleteMemoryObjectsEXT, isCallValid, context, n, memoryObjectsPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetMemoryObjectParameterivEXT(GLuint memoryObject, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetMemoryObjectParameterivEXT,
          "context = %d, memoryObject = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          memoryObject, GLenumToString(GLenumGroup::MemoryObjectParameterName, pname),
          (uintptr_t)params);

    if (context)
    {
        MemoryObjectID memoryObjectPacked = PackParam<MemoryObjectID>(memoryObject);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetMemoryObjectParameterivEXT(context, memoryObjectPacked, pname, params));
        if (isCallValid)
        {
            context->getMemoryObjectParameteriv(memoryObjectPacked, pname, params);
        }
        ANGLE_CAPTURE(GetMemoryObjectParameterivEXT, isCallValid, context, memoryObjectPacked,
                      pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetUnsignedBytevEXT(GLenum pname, GLubyte *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetUnsignedBytevEXT, "context = %d, pname = %s, data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::GetPName, pname), (uintptr_t)data);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetUnsignedBytevEXT(context, pname, data));
        if (isCallValid)
        {
            context->getUnsignedBytev(pname, data);
        }
        ANGLE_CAPTURE(GetUnsignedBytevEXT, isCallValid, context, pname, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetUnsignedBytei_vEXT(GLenum target, GLuint index, GLubyte *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetUnsignedBytei_vEXT,
          "context = %d, target = %s, index = %u, data = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::DefaultGroup, target), index, (uintptr_t)data);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetUnsignedBytei_vEXT(context, target, index, data));
        if (isCallValid)
        {
            context->getUnsignedBytei_v(target, index, data);
        }
        ANGLE_CAPTURE(GetUnsignedBytei_vEXT, isCallValid, context, target, index, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

GLboolean GL_APIENTRY GL_IsMemoryObjectEXT(GLuint memoryObject)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLIsMemoryObjectEXT, "context = %d, memoryObject = %u", CID(context),
          memoryObject);

    GLboolean returnValue;
    if (context)
    {
        MemoryObjectID memoryObjectPacked = PackParam<MemoryObjectID>(memoryObject);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsMemoryObjectEXT(context, memoryObjectPacked));
        if (isCallValid)
        {
            returnValue = context->isMemoryObject(memoryObjectPacked);
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLIsMemoryObjectEXT, GLboolean>();
        }
        ANGLE_CAPTURE(IsMemoryObjectEXT, isCallValid, context, memoryObjectPacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsMemoryObjectEXT, GLboolean>();
    }
    return returnValue;
}

void GL_APIENTRY GL_MemoryObjectParameterivEXT(GLuint memoryObject,
                                               GLenum pname,
                                               const GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMemoryObjectParameterivEXT,
          "context = %d, memoryObject = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          memoryObject, GLenumToString(GLenumGroup::MemoryObjectParameterName, pname),
          (uintptr_t)params);

    if (context)
    {
        MemoryObjectID memoryObjectPacked = PackParam<MemoryObjectID>(memoryObject);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMemoryObjectParameterivEXT(context, memoryObjectPacked, pname, params));
        if (isCallValid)
        {
            context->memoryObjectParameteriv(memoryObjectPacked, pname, params);
        }
        ANGLE_CAPTURE(MemoryObjectParameterivEXT, isCallValid, context, memoryObjectPacked, pname,
                      params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexStorageMem2DEXT(GLenum target,
                                       GLsizei levels,
                                       GLenum internalFormat,
                                       GLsizei width,
                                       GLsizei height,
                                       GLuint memory,
                                       GLuint64 offset)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexStorageMem2DEXT,
          "context = %d, target = %s, levels = %d, internalFormat = %s, width = %d, height = %d, "
          "memory = %u, offset = %llu",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), levels,
          GLenumToString(GLenumGroup::DefaultGroup, internalFormat), width, height, memory,
          static_cast<unsigned long long>(offset));

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        MemoryObjectID memoryPacked                           = PackParam<MemoryObjectID>(memory);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexStorageMem2DEXT(context, targetPacked, levels, internalFormat, width,
                                        height, memoryPacked, offset));
        if (isCallValid)
        {
            context->texStorageMem2D(targetPacked, levels, internalFormat, width, height,
                                     memoryPacked, offset);
        }
        ANGLE_CAPTURE(TexStorageMem2DEXT, isCallValid, context, targetPacked, levels,
                      internalFormat, width, height, memoryPacked, offset);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexStorageMem2DMultisampleEXT(GLenum target,
                                                  GLsizei samples,
                                                  GLenum internalFormat,
                                                  GLsizei width,
                                                  GLsizei height,
                                                  GLboolean fixedSampleLocations,
                                                  GLuint memory,
                                                  GLuint64 offset)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexStorageMem2DMultisampleEXT,
          "context = %d, target = %s, samples = %d, internalFormat = %s, width = %d, height = %d, "
          "fixedSampleLocations = %s, memory = %u, offset = %llu",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), samples,
          GLenumToString(GLenumGroup::DefaultGroup, internalFormat), width, height,
          GLbooleanToString(fixedSampleLocations), memory, static_cast<unsigned long long>(offset));

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        MemoryObjectID memoryPacked                           = PackParam<MemoryObjectID>(memory);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTexStorageMem2DMultisampleEXT(
                                              context, targetPacked, samples, internalFormat, width,
                                              height, fixedSampleLocations, memoryPacked, offset));
        if (isCallValid)
        {
            context->texStorageMem2DMultisample(targetPacked, samples, internalFormat, width,
                                                height, fixedSampleLocations, memoryPacked, offset);
        }
        ANGLE_CAPTURE(TexStorageMem2DMultisampleEXT, isCallValid, context, targetPacked, samples,
                      internalFormat, width, height, fixedSampleLocations, memoryPacked, offset);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexStorageMem3DEXT(GLenum target,
                                       GLsizei levels,
                                       GLenum internalFormat,
                                       GLsizei width,
                                       GLsizei height,
                                       GLsizei depth,
                                       GLuint memory,
                                       GLuint64 offset)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexStorageMem3DEXT,
          "context = %d, target = %s, levels = %d, internalFormat = %s, width = %d, height = %d, "
          "depth = %d, memory = %u, offset = %llu",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), levels,
          GLenumToString(GLenumGroup::DefaultGroup, internalFormat), width, height, depth, memory,
          static_cast<unsigned long long>(offset));

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        MemoryObjectID memoryPacked                           = PackParam<MemoryObjectID>(memory);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexStorageMem3DEXT(context, targetPacked, levels, internalFormat, width,
                                        height, depth, memoryPacked, offset));
        if (isCallValid)
        {
            context->texStorageMem3D(targetPacked, levels, internalFormat, width, height, depth,
                                     memoryPacked, offset);
        }
        ANGLE_CAPTURE(TexStorageMem3DEXT, isCallValid, context, targetPacked, levels,
                      internalFormat, width, height, depth, memoryPacked, offset);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexStorageMem3DMultisampleEXT(GLenum target,
                                                  GLsizei samples,
                                                  GLenum internalFormat,
                                                  GLsizei width,
                                                  GLsizei height,
                                                  GLsizei depth,
                                                  GLboolean fixedSampleLocations,
                                                  GLuint memory,
                                                  GLuint64 offset)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexStorageMem3DMultisampleEXT,
          "context = %d, target = %s, samples = %d, internalFormat = %s, width = %d, height = %d, "
          "depth = %d, fixedSampleLocations = %s, memory = %u, offset = %llu",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), samples,
          GLenumToString(GLenumGroup::DefaultGroup, internalFormat), width, height, depth,
          GLbooleanToString(fixedSampleLocations), memory, static_cast<unsigned long long>(offset));

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        MemoryObjectID memoryPacked                           = PackParam<MemoryObjectID>(memory);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexStorageMem3DMultisampleEXT(
                                context, targetPacked, samples, internalFormat, width, height,
                                depth, fixedSampleLocations, memoryPacked, offset));
        if (isCallValid)
        {
            context->texStorageMem3DMultisample(targetPacked, samples, internalFormat, width,
                                                height, depth, fixedSampleLocations, memoryPacked,
                                                offset);
        }
        ANGLE_CAPTURE(TexStorageMem3DMultisampleEXT, isCallValid, context, targetPacked, samples,
                      internalFormat, width, height, depth, fixedSampleLocations, memoryPacked,
                      offset);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_EXT_memory_object_fd
void GL_APIENTRY GL_ImportMemoryFdEXT(GLuint memory, GLuint64 size, GLenum handleType, GLint fd)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLImportMemoryFdEXT,
          "context = %d, memory = %u, size = %llu, handleType = %s, fd = %d", CID(context), memory,
          static_cast<unsigned long long>(size),
          GLenumToString(GLenumGroup::ExternalHandleType, handleType), fd);

    if (context)
    {
        MemoryObjectID memoryPacked                           = PackParam<MemoryObjectID>(memory);
        HandleType handleTypePacked                           = PackParam<HandleType>(handleType);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateImportMemoryFdEXT(context, memoryPacked, size, handleTypePacked, fd));
        if (isCallValid)
        {
            context->importMemoryFd(memoryPacked, size, handleTypePacked, fd);
        }
        ANGLE_CAPTURE(ImportMemoryFdEXT, isCallValid, context, memoryPacked, size, handleTypePacked,
                      fd);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_EXT_multisampled_render_to_texture
void GL_APIENTRY GL_FramebufferTexture2DMultisampleEXT(GLenum target,
                                                       GLenum attachment,
                                                       GLenum textarget,
                                                       GLuint texture,
                                                       GLint level,
                                                       GLsizei samples)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFramebufferTexture2DMultisampleEXT,
          "context = %d, target = %s, attachment = %s, textarget = %s, texture = %u, level = %d, "
          "samples = %d",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment),
          GLenumToString(GLenumGroup::TextureTarget, textarget), texture, level, samples);

    if (context)
    {
        TextureTarget textargetPacked                         = PackParam<TextureTarget>(textarget);
        TextureID texturePacked                               = PackParam<TextureID>(texture);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateFramebufferTexture2DMultisampleEXT(
                 context, target, attachment, textargetPacked, texturePacked, level, samples));
        if (isCallValid)
        {
            context->framebufferTexture2DMultisample(target, attachment, textargetPacked,
                                                     texturePacked, level, samples);
        }
        ANGLE_CAPTURE(FramebufferTexture2DMultisampleEXT, isCallValid, context, target, attachment,
                      textargetPacked, texturePacked, level, samples);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_RenderbufferStorageMultisampleEXT(GLenum target,
                                                      GLsizei samples,
                                                      GLenum internalformat,
                                                      GLsizei width,
                                                      GLsizei height)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRenderbufferStorageMultisampleEXT,
          "context = %d, target = %s, samples = %d, internalformat = %s, width = %d, height = %d",
          CID(context), GLenumToString(GLenumGroup::RenderbufferTarget, target), samples,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateRenderbufferStorageMultisampleEXT(
                                context, target, samples, internalformat, width, height));
        if (isCallValid)
        {
            context->renderbufferStorageMultisampleEXT(target, samples, internalformat, width,
                                                       height);
        }
        ANGLE_CAPTURE(RenderbufferStorageMultisampleEXT, isCallValid, context, target, samples,
                      internalformat, width, height);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_EXT_occlusion_query_boolean
// BeginQueryEXT is already defined.

// DeleteQueriesEXT is already defined.

// EndQueryEXT is already defined.

// GenQueriesEXT is already defined.

// GetQueryObjectuivEXT is already defined.

// GetQueryivEXT is already defined.

// IsQueryEXT is already defined.

// GL_EXT_primitive_bounding_box
void GL_APIENTRY GL_PrimitiveBoundingBoxEXT(GLfloat minX,
                                            GLfloat minY,
                                            GLfloat minZ,
                                            GLfloat minW,
                                            GLfloat maxX,
                                            GLfloat maxY,
                                            GLfloat maxZ,
                                            GLfloat maxW)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPrimitiveBoundingBoxEXT,
          "context = %d, minX = %f, minY = %f, minZ = %f, minW = %f, maxX = %f, maxY = %f, maxZ = "
          "%f, maxW = %f",
          CID(context), minX, minY, minZ, minW, maxX, maxY, maxZ, maxW);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidatePrimitiveBoundingBoxEXT(context, minX, minY, minZ, minW, maxX,
                                                            maxY, maxZ, maxW));
        if (isCallValid)
        {
            context->primitiveBoundingBox(minX, minY, minZ, minW, maxX, maxY, maxZ, maxW);
        }
        ANGLE_CAPTURE(PrimitiveBoundingBoxEXT, isCallValid, context, minX, minY, minZ, minW, maxX,
                      maxY, maxZ, maxW);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_EXT_read_format_bgra

// GL_EXT_robustness
GLenum GL_APIENTRY GL_GetGraphicsResetStatusEXT()
{
    Context *context = GetGlobalContext();
    EVENT(context, GLGetGraphicsResetStatusEXT, "context = %d", CID(context));

    GLenum returnValue;
    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetGraphicsResetStatusEXT(context));
        if (isCallValid)
        {
            returnValue = context->getGraphicsResetStatus();
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLGetGraphicsResetStatusEXT, GLenum>();
        }
        ANGLE_CAPTURE(GetGraphicsResetStatusEXT, isCallValid, context, returnValue);
    }
    else
    {

        returnValue =
            GetDefaultReturnValue<angle::EntryPoint::GLGetGraphicsResetStatusEXT, GLenum>();
    }
    return returnValue;
}

void GL_APIENTRY GL_GetnUniformfvEXT(GLuint program,
                                     GLint location,
                                     GLsizei bufSize,
                                     GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetnUniformfvEXT,
          "context = %d, program = %u, location = %d, bufSize = %d, params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)params);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetnUniformfvEXT(context, programPacked, locationPacked, bufSize, params));
        if (isCallValid)
        {
            context->getnUniformfv(programPacked, locationPacked, bufSize, params);
        }
        ANGLE_CAPTURE(GetnUniformfvEXT, isCallValid, context, programPacked, locationPacked,
                      bufSize, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetnUniformivEXT(GLuint program, GLint location, GLsizei bufSize, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetnUniformivEXT,
          "context = %d, program = %u, location = %d, bufSize = %d, params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)params);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetnUniformivEXT(context, programPacked, locationPacked, bufSize, params));
        if (isCallValid)
        {
            context->getnUniformiv(programPacked, locationPacked, bufSize, params);
        }
        ANGLE_CAPTURE(GetnUniformivEXT, isCallValid, context, programPacked, locationPacked,
                      bufSize, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ReadnPixelsEXT(GLint x,
                                   GLint y,
                                   GLsizei width,
                                   GLsizei height,
                                   GLenum format,
                                   GLenum type,
                                   GLsizei bufSize,
                                   void *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLReadnPixelsEXT,
          "context = %d, x = %d, y = %d, width = %d, height = %d, format = %s, type = %s, bufSize "
          "= %d, data = 0x%016" PRIxPTR "",
          CID(context), x, y, width, height, GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), bufSize, (uintptr_t)data);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateReadnPixelsEXT(context, x, y, width, height, format, type, bufSize, data));
        if (isCallValid)
        {
            context->readnPixels(x, y, width, height, format, type, bufSize, data);
        }
        ANGLE_CAPTURE(ReadnPixelsEXT, isCallValid, context, x, y, width, height, format, type,
                      bufSize, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_EXT_sRGB

// GL_EXT_semaphore
void GL_APIENTRY GL_DeleteSemaphoresEXT(GLsizei n, const GLuint *semaphores)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDeleteSemaphoresEXT, "context = %d, n = %d, semaphores = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)semaphores);

    if (context)
    {
        const SemaphoreID *semaphoresPacked = PackParam<const SemaphoreID *>(semaphores);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDeleteSemaphoresEXT(context, n, semaphoresPacked));
        if (isCallValid)
        {
            context->deleteSemaphores(n, semaphoresPacked);
        }
        ANGLE_CAPTURE(DeleteSemaphoresEXT, isCallValid, context, n, semaphoresPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GenSemaphoresEXT(GLsizei n, GLuint *semaphores)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGenSemaphoresEXT, "context = %d, n = %d, semaphores = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)semaphores);

    if (context)
    {
        SemaphoreID *semaphoresPacked = PackParam<SemaphoreID *>(semaphores);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenSemaphoresEXT(context, n, semaphoresPacked));
        if (isCallValid)
        {
            context->genSemaphores(n, semaphoresPacked);
        }
        ANGLE_CAPTURE(GenSemaphoresEXT, isCallValid, context, n, semaphoresPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetSemaphoreParameterui64vEXT(GLuint semaphore, GLenum pname, GLuint64 *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetSemaphoreParameterui64vEXT,
          "context = %d, semaphore = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          semaphore, GLenumToString(GLenumGroup::SemaphoreParameterName, pname), (uintptr_t)params);

    if (context)
    {
        SemaphoreID semaphorePacked                           = PackParam<SemaphoreID>(semaphore);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetSemaphoreParameterui64vEXT(context, semaphorePacked, pname, params));
        if (isCallValid)
        {
            context->getSemaphoreParameterui64v(semaphorePacked, pname, params);
        }
        ANGLE_CAPTURE(GetSemaphoreParameterui64vEXT, isCallValid, context, semaphorePacked, pname,
                      params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

GLboolean GL_APIENTRY GL_IsSemaphoreEXT(GLuint semaphore)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLIsSemaphoreEXT, "context = %d, semaphore = %u", CID(context), semaphore);

    GLboolean returnValue;
    if (context)
    {
        SemaphoreID semaphorePacked                           = PackParam<SemaphoreID>(semaphore);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsSemaphoreEXT(context, semaphorePacked));
        if (isCallValid)
        {
            returnValue = context->isSemaphore(semaphorePacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsSemaphoreEXT, GLboolean>();
        }
        ANGLE_CAPTURE(IsSemaphoreEXT, isCallValid, context, semaphorePacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsSemaphoreEXT, GLboolean>();
    }
    return returnValue;
}

void GL_APIENTRY GL_SemaphoreParameterui64vEXT(GLuint semaphore,
                                               GLenum pname,
                                               const GLuint64 *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSemaphoreParameterui64vEXT,
          "context = %d, semaphore = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          semaphore, GLenumToString(GLenumGroup::SemaphoreParameterName, pname), (uintptr_t)params);

    if (context)
    {
        SemaphoreID semaphorePacked                           = PackParam<SemaphoreID>(semaphore);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateSemaphoreParameterui64vEXT(context, semaphorePacked, pname, params));
        if (isCallValid)
        {
            context->semaphoreParameterui64v(semaphorePacked, pname, params);
        }
        ANGLE_CAPTURE(SemaphoreParameterui64vEXT, isCallValid, context, semaphorePacked, pname,
                      params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_SignalSemaphoreEXT(GLuint semaphore,
                                       GLuint numBufferBarriers,
                                       const GLuint *buffers,
                                       GLuint numTextureBarriers,
                                       const GLuint *textures,
                                       const GLenum *dstLayouts)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSignalSemaphoreEXT,
          "context = %d, semaphore = %u, numBufferBarriers = %u, buffers = 0x%016" PRIxPTR
          ", numTextureBarriers = %u, textures = 0x%016" PRIxPTR ", dstLayouts = 0x%016" PRIxPTR "",
          CID(context), semaphore, numBufferBarriers, (uintptr_t)buffers, numTextureBarriers,
          (uintptr_t)textures, (uintptr_t)dstLayouts);

    if (context)
    {
        SemaphoreID semaphorePacked     = PackParam<SemaphoreID>(semaphore);
        const BufferID *buffersPacked   = PackParam<const BufferID *>(buffers);
        const TextureID *texturesPacked = PackParam<const TextureID *>(textures);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateSignalSemaphoreEXT(context, semaphorePacked, numBufferBarriers, buffersPacked,
                                        numTextureBarriers, texturesPacked, dstLayouts));
        if (isCallValid)
        {
            context->signalSemaphore(semaphorePacked, numBufferBarriers, buffersPacked,
                                     numTextureBarriers, texturesPacked, dstLayouts);
        }
        ANGLE_CAPTURE(SignalSemaphoreEXT, isCallValid, context, semaphorePacked, numBufferBarriers,
                      buffersPacked, numTextureBarriers, texturesPacked, dstLayouts);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_WaitSemaphoreEXT(GLuint semaphore,
                                     GLuint numBufferBarriers,
                                     const GLuint *buffers,
                                     GLuint numTextureBarriers,
                                     const GLuint *textures,
                                     const GLenum *srcLayouts)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLWaitSemaphoreEXT,
          "context = %d, semaphore = %u, numBufferBarriers = %u, buffers = 0x%016" PRIxPTR
          ", numTextureBarriers = %u, textures = 0x%016" PRIxPTR ", srcLayouts = 0x%016" PRIxPTR "",
          CID(context), semaphore, numBufferBarriers, (uintptr_t)buffers, numTextureBarriers,
          (uintptr_t)textures, (uintptr_t)srcLayouts);

    if (context)
    {
        SemaphoreID semaphorePacked     = PackParam<SemaphoreID>(semaphore);
        const BufferID *buffersPacked   = PackParam<const BufferID *>(buffers);
        const TextureID *texturesPacked = PackParam<const TextureID *>(textures);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateWaitSemaphoreEXT(context, semaphorePacked, numBufferBarriers, buffersPacked,
                                      numTextureBarriers, texturesPacked, srcLayouts));
        if (isCallValid)
        {
            context->waitSemaphore(semaphorePacked, numBufferBarriers, buffersPacked,
                                   numTextureBarriers, texturesPacked, srcLayouts);
        }
        ANGLE_CAPTURE(WaitSemaphoreEXT, isCallValid, context, semaphorePacked, numBufferBarriers,
                      buffersPacked, numTextureBarriers, texturesPacked, srcLayouts);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GetUnsignedBytei_vEXT is already defined.

// GetUnsignedBytevEXT is already defined.

// GL_EXT_semaphore_fd
void GL_APIENTRY GL_ImportSemaphoreFdEXT(GLuint semaphore, GLenum handleType, GLint fd)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLImportSemaphoreFdEXT, "context = %d, semaphore = %u, handleType = %s, fd = %d",
          CID(context), semaphore, GLenumToString(GLenumGroup::ExternalHandleType, handleType), fd);

    if (context)
    {
        SemaphoreID semaphorePacked                           = PackParam<SemaphoreID>(semaphore);
        HandleType handleTypePacked                           = PackParam<HandleType>(handleType);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateImportSemaphoreFdEXT(context, semaphorePacked, handleTypePacked, fd));
        if (isCallValid)
        {
            context->importSemaphoreFd(semaphorePacked, handleTypePacked, fd);
        }
        ANGLE_CAPTURE(ImportSemaphoreFdEXT, isCallValid, context, semaphorePacked, handleTypePacked,
                      fd);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_EXT_separate_shader_objects
void GL_APIENTRY GL_ActiveShaderProgramEXT(GLuint pipeline, GLuint program)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLActiveShaderProgramEXT, "context = %d, pipeline = %u, program = %u",
          CID(context), pipeline, program);

    if (context)
    {
        ProgramPipelineID pipelinePacked = PackParam<ProgramPipelineID>(pipeline);
        ShaderProgramID programPacked    = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateActiveShaderProgramEXT(context, pipelinePacked, programPacked));
        if (isCallValid)
        {
            context->activeShaderProgram(pipelinePacked, programPacked);
        }
        ANGLE_CAPTURE(ActiveShaderProgramEXT, isCallValid, context, pipelinePacked, programPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_BindProgramPipelineEXT(GLuint pipeline)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBindProgramPipelineEXT, "context = %d, pipeline = %u", CID(context), pipeline);

    if (context)
    {
        ProgramPipelineID pipelinePacked = PackParam<ProgramPipelineID>(pipeline);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBindProgramPipelineEXT(context, pipelinePacked));
        if (isCallValid)
        {
            context->bindProgramPipeline(pipelinePacked);
        }
        ANGLE_CAPTURE(BindProgramPipelineEXT, isCallValid, context, pipelinePacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

GLuint GL_APIENTRY GL_CreateShaderProgramvEXT(GLenum type, GLsizei count, const GLchar **strings)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCreateShaderProgramvEXT,
          "context = %d, type = %s, count = %d, strings = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::ShaderType, type), count, (uintptr_t)strings);

    GLuint returnValue;
    if (context)
    {
        ShaderType typePacked                                 = PackParam<ShaderType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateCreateShaderProgramvEXT(context, typePacked, count, strings));
        if (isCallValid)
        {
            returnValue = context->createShaderProgramv(typePacked, count, strings);
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLCreateShaderProgramvEXT, GLuint>();
        }
        ANGLE_CAPTURE(CreateShaderProgramvEXT, isCallValid, context, typePacked, count, strings,
                      returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLCreateShaderProgramvEXT, GLuint>();
    }
    return returnValue;
}

void GL_APIENTRY GL_DeleteProgramPipelinesEXT(GLsizei n, const GLuint *pipelines)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDeleteProgramPipelinesEXT,
          "context = %d, n = %d, pipelines = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)pipelines);

    if (context)
    {
        const ProgramPipelineID *pipelinesPacked = PackParam<const ProgramPipelineID *>(pipelines);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDeleteProgramPipelinesEXT(context, n, pipelinesPacked));
        if (isCallValid)
        {
            context->deleteProgramPipelines(n, pipelinesPacked);
        }
        ANGLE_CAPTURE(DeleteProgramPipelinesEXT, isCallValid, context, n, pipelinesPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GenProgramPipelinesEXT(GLsizei n, GLuint *pipelines)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGenProgramPipelinesEXT, "context = %d, n = %d, pipelines = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)pipelines);

    if (context)
    {
        ProgramPipelineID *pipelinesPacked = PackParam<ProgramPipelineID *>(pipelines);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGenProgramPipelinesEXT(context, n, pipelinesPacked));
        if (isCallValid)
        {
            context->genProgramPipelines(n, pipelinesPacked);
        }
        ANGLE_CAPTURE(GenProgramPipelinesEXT, isCallValid, context, n, pipelinesPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetProgramPipelineInfoLogEXT(GLuint pipeline,
                                                 GLsizei bufSize,
                                                 GLsizei *length,
                                                 GLchar *infoLog)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetProgramPipelineInfoLogEXT,
          "context = %d, pipeline = %u, bufSize = %d, length = 0x%016" PRIxPTR
          ", infoLog = 0x%016" PRIxPTR "",
          CID(context), pipeline, bufSize, (uintptr_t)length, (uintptr_t)infoLog);

    if (context)
    {
        ProgramPipelineID pipelinePacked = PackParam<ProgramPipelineID>(pipeline);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetProgramPipelineInfoLogEXT(
                                              context, pipelinePacked, bufSize, length, infoLog));
        if (isCallValid)
        {
            context->getProgramPipelineInfoLog(pipelinePacked, bufSize, length, infoLog);
        }
        ANGLE_CAPTURE(GetProgramPipelineInfoLogEXT, isCallValid, context, pipelinePacked, bufSize,
                      length, infoLog);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetProgramPipelineivEXT(GLuint pipeline, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetProgramPipelineivEXT,
          "context = %d, pipeline = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          pipeline, GLenumToString(GLenumGroup::PipelineParameterName, pname), (uintptr_t)params);

    if (context)
    {
        ProgramPipelineID pipelinePacked = PackParam<ProgramPipelineID>(pipeline);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetProgramPipelineivEXT(context, pipelinePacked, pname, params));
        if (isCallValid)
        {
            context->getProgramPipelineiv(pipelinePacked, pname, params);
        }
        ANGLE_CAPTURE(GetProgramPipelineivEXT, isCallValid, context, pipelinePacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

GLboolean GL_APIENTRY GL_IsProgramPipelineEXT(GLuint pipeline)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLIsProgramPipelineEXT, "context = %d, pipeline = %u", CID(context), pipeline);

    GLboolean returnValue;
    if (context)
    {
        ProgramPipelineID pipelinePacked = PackParam<ProgramPipelineID>(pipeline);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsProgramPipelineEXT(context, pipelinePacked));
        if (isCallValid)
        {
            returnValue = context->isProgramPipeline(pipelinePacked);
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLIsProgramPipelineEXT, GLboolean>();
        }
        ANGLE_CAPTURE(IsProgramPipelineEXT, isCallValid, context, pipelinePacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsProgramPipelineEXT, GLboolean>();
    }
    return returnValue;
}

void GL_APIENTRY GL_ProgramParameteriEXT(GLuint program, GLenum pname, GLint value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramParameteriEXT, "context = %d, program = %u, pname = %s, value = %d",
          CID(context), program, GLenumToString(GLenumGroup::ProgramParameterPName, pname), value);

    if (context)
    {
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateProgramParameteriEXT(context, programPacked, pname, value));
        if (isCallValid)
        {
            context->programParameteri(programPacked, pname, value);
        }
        ANGLE_CAPTURE(ProgramParameteriEXT, isCallValid, context, programPacked, pname, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniform1fEXT(GLuint program, GLint location, GLfloat v0)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform1fEXT, "context = %d, program = %u, location = %d, v0 = %f",
          CID(context), program, location, v0);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform1fEXT(context, programPacked, locationPacked, v0));
        if (isCallValid)
        {
            context->programUniform1f(programPacked, locationPacked, v0);
        }
        ANGLE_CAPTURE(ProgramUniform1fEXT, isCallValid, context, programPacked, locationPacked, v0);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniform1fvEXT(GLuint program,
                                         GLint location,
                                         GLsizei count,
                                         const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform1fvEXT,
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform1fvEXT(context, programPacked, locationPacked, count, value));
        if (isCallValid)
        {
            context->programUniform1fv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE(ProgramUniform1fvEXT, isCallValid, context, programPacked, locationPacked,
                      count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniform1iEXT(GLuint program, GLint location, GLint v0)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform1iEXT, "context = %d, program = %u, location = %d, v0 = %d",
          CID(context), program, location, v0);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform1iEXT(context, programPacked, locationPacked, v0));
        if (isCallValid)
        {
            context->programUniform1i(programPacked, locationPacked, v0);
        }
        ANGLE_CAPTURE(ProgramUniform1iEXT, isCallValid, context, programPacked, locationPacked, v0);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniform1ivEXT(GLuint program,
                                         GLint location,
                                         GLsizei count,
                                         const GLint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform1ivEXT,
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform1ivEXT(context, programPacked, locationPacked, count, value));
        if (isCallValid)
        {
            context->programUniform1iv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE(ProgramUniform1ivEXT, isCallValid, context, programPacked, locationPacked,
                      count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniform1uiEXT(GLuint program, GLint location, GLuint v0)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform1uiEXT, "context = %d, program = %u, location = %d, v0 = %u",
          CID(context), program, location, v0);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform1uiEXT(context, programPacked, locationPacked, v0));
        if (isCallValid)
        {
            context->programUniform1ui(programPacked, locationPacked, v0);
        }
        ANGLE_CAPTURE(ProgramUniform1uiEXT, isCallValid, context, programPacked, locationPacked,
                      v0);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniform1uivEXT(GLuint program,
                                          GLint location,
                                          GLsizei count,
                                          const GLuint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform1uivEXT,
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform1uivEXT(context, programPacked, locationPacked, count, value));
        if (isCallValid)
        {
            context->programUniform1uiv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE(ProgramUniform1uivEXT, isCallValid, context, programPacked, locationPacked,
                      count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniform2fEXT(GLuint program, GLint location, GLfloat v0, GLfloat v1)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform2fEXT,
          "context = %d, program = %u, location = %d, v0 = %f, v1 = %f", CID(context), program,
          location, v0, v1);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform2fEXT(context, programPacked, locationPacked, v0, v1));
        if (isCallValid)
        {
            context->programUniform2f(programPacked, locationPacked, v0, v1);
        }
        ANGLE_CAPTURE(ProgramUniform2fEXT, isCallValid, context, programPacked, locationPacked, v0,
                      v1);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniform2fvEXT(GLuint program,
                                         GLint location,
                                         GLsizei count,
                                         const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform2fvEXT,
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform2fvEXT(context, programPacked, locationPacked, count, value));
        if (isCallValid)
        {
            context->programUniform2fv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE(ProgramUniform2fvEXT, isCallValid, context, programPacked, locationPacked,
                      count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniform2iEXT(GLuint program, GLint location, GLint v0, GLint v1)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform2iEXT,
          "context = %d, program = %u, location = %d, v0 = %d, v1 = %d", CID(context), program,
          location, v0, v1);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform2iEXT(context, programPacked, locationPacked, v0, v1));
        if (isCallValid)
        {
            context->programUniform2i(programPacked, locationPacked, v0, v1);
        }
        ANGLE_CAPTURE(ProgramUniform2iEXT, isCallValid, context, programPacked, locationPacked, v0,
                      v1);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniform2ivEXT(GLuint program,
                                         GLint location,
                                         GLsizei count,
                                         const GLint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform2ivEXT,
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform2ivEXT(context, programPacked, locationPacked, count, value));
        if (isCallValid)
        {
            context->programUniform2iv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE(ProgramUniform2ivEXT, isCallValid, context, programPacked, locationPacked,
                      count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniform2uiEXT(GLuint program, GLint location, GLuint v0, GLuint v1)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform2uiEXT,
          "context = %d, program = %u, location = %d, v0 = %u, v1 = %u", CID(context), program,
          location, v0, v1);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform2uiEXT(context, programPacked, locationPacked, v0, v1));
        if (isCallValid)
        {
            context->programUniform2ui(programPacked, locationPacked, v0, v1);
        }
        ANGLE_CAPTURE(ProgramUniform2uiEXT, isCallValid, context, programPacked, locationPacked, v0,
                      v1);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniform2uivEXT(GLuint program,
                                          GLint location,
                                          GLsizei count,
                                          const GLuint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform2uivEXT,
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform2uivEXT(context, programPacked, locationPacked, count, value));
        if (isCallValid)
        {
            context->programUniform2uiv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE(ProgramUniform2uivEXT, isCallValid, context, programPacked, locationPacked,
                      count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY
GL_ProgramUniform3fEXT(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform3fEXT,
          "context = %d, program = %u, location = %d, v0 = %f, v1 = %f, v2 = %f", CID(context),
          program, location, v0, v1, v2);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform3fEXT(context, programPacked, locationPacked, v0, v1, v2));
        if (isCallValid)
        {
            context->programUniform3f(programPacked, locationPacked, v0, v1, v2);
        }
        ANGLE_CAPTURE(ProgramUniform3fEXT, isCallValid, context, programPacked, locationPacked, v0,
                      v1, v2);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniform3fvEXT(GLuint program,
                                         GLint location,
                                         GLsizei count,
                                         const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform3fvEXT,
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform3fvEXT(context, programPacked, locationPacked, count, value));
        if (isCallValid)
        {
            context->programUniform3fv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE(ProgramUniform3fvEXT, isCallValid, context, programPacked, locationPacked,
                      count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY
GL_ProgramUniform3iEXT(GLuint program, GLint location, GLint v0, GLint v1, GLint v2)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform3iEXT,
          "context = %d, program = %u, location = %d, v0 = %d, v1 = %d, v2 = %d", CID(context),
          program, location, v0, v1, v2);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform3iEXT(context, programPacked, locationPacked, v0, v1, v2));
        if (isCallValid)
        {
            context->programUniform3i(programPacked, locationPacked, v0, v1, v2);
        }
        ANGLE_CAPTURE(ProgramUniform3iEXT, isCallValid, context, programPacked, locationPacked, v0,
                      v1, v2);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniform3ivEXT(GLuint program,
                                         GLint location,
                                         GLsizei count,
                                         const GLint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform3ivEXT,
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform3ivEXT(context, programPacked, locationPacked, count, value));
        if (isCallValid)
        {
            context->programUniform3iv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE(ProgramUniform3ivEXT, isCallValid, context, programPacked, locationPacked,
                      count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY
GL_ProgramUniform3uiEXT(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform3uiEXT,
          "context = %d, program = %u, location = %d, v0 = %u, v1 = %u, v2 = %u", CID(context),
          program, location, v0, v1, v2);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform3uiEXT(context, programPacked, locationPacked, v0, v1, v2));
        if (isCallValid)
        {
            context->programUniform3ui(programPacked, locationPacked, v0, v1, v2);
        }
        ANGLE_CAPTURE(ProgramUniform3uiEXT, isCallValid, context, programPacked, locationPacked, v0,
                      v1, v2);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniform3uivEXT(GLuint program,
                                          GLint location,
                                          GLsizei count,
                                          const GLuint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform3uivEXT,
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform3uivEXT(context, programPacked, locationPacked, count, value));
        if (isCallValid)
        {
            context->programUniform3uiv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE(ProgramUniform3uivEXT, isCallValid, context, programPacked, locationPacked,
                      count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniform4fEXT(GLuint program,
                                        GLint location,
                                        GLfloat v0,
                                        GLfloat v1,
                                        GLfloat v2,
                                        GLfloat v3)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform4fEXT,
          "context = %d, program = %u, location = %d, v0 = %f, v1 = %f, v2 = %f, v3 = %f",
          CID(context), program, location, v0, v1, v2, v3);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform4fEXT(context, programPacked, locationPacked, v0, v1, v2, v3));
        if (isCallValid)
        {
            context->programUniform4f(programPacked, locationPacked, v0, v1, v2, v3);
        }
        ANGLE_CAPTURE(ProgramUniform4fEXT, isCallValid, context, programPacked, locationPacked, v0,
                      v1, v2, v3);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniform4fvEXT(GLuint program,
                                         GLint location,
                                         GLsizei count,
                                         const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform4fvEXT,
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform4fvEXT(context, programPacked, locationPacked, count, value));
        if (isCallValid)
        {
            context->programUniform4fv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE(ProgramUniform4fvEXT, isCallValid, context, programPacked, locationPacked,
                      count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY
GL_ProgramUniform4iEXT(GLuint program, GLint location, GLint v0, GLint v1, GLint v2, GLint v3)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform4iEXT,
          "context = %d, program = %u, location = %d, v0 = %d, v1 = %d, v2 = %d, v3 = %d",
          CID(context), program, location, v0, v1, v2, v3);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform4iEXT(context, programPacked, locationPacked, v0, v1, v2, v3));
        if (isCallValid)
        {
            context->programUniform4i(programPacked, locationPacked, v0, v1, v2, v3);
        }
        ANGLE_CAPTURE(ProgramUniform4iEXT, isCallValid, context, programPacked, locationPacked, v0,
                      v1, v2, v3);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniform4ivEXT(GLuint program,
                                         GLint location,
                                         GLsizei count,
                                         const GLint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform4ivEXT,
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform4ivEXT(context, programPacked, locationPacked, count, value));
        if (isCallValid)
        {
            context->programUniform4iv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE(ProgramUniform4ivEXT, isCallValid, context, programPacked, locationPacked,
                      count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY
GL_ProgramUniform4uiEXT(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform4uiEXT,
          "context = %d, program = %u, location = %d, v0 = %u, v1 = %u, v2 = %u, v3 = %u",
          CID(context), program, location, v0, v1, v2, v3);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform4uiEXT(context, programPacked, locationPacked, v0, v1, v2, v3));
        if (isCallValid)
        {
            context->programUniform4ui(programPacked, locationPacked, v0, v1, v2, v3);
        }
        ANGLE_CAPTURE(ProgramUniform4uiEXT, isCallValid, context, programPacked, locationPacked, v0,
                      v1, v2, v3);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniform4uivEXT(GLuint program,
                                          GLint location,
                                          GLsizei count,
                                          const GLuint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform4uivEXT,
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform4uivEXT(context, programPacked, locationPacked, count, value));
        if (isCallValid)
        {
            context->programUniform4uiv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE(ProgramUniform4uivEXT, isCallValid, context, programPacked, locationPacked,
                      count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniformMatrix2fvEXT(GLuint program,
                                               GLint location,
                                               GLsizei count,
                                               GLboolean transpose,
                                               const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniformMatrix2fvEXT,
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateProgramUniformMatrix2fvEXT(
                                context, programPacked, locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->programUniformMatrix2fv(programPacked, locationPacked, count, transpose,
                                             value);
        }
        ANGLE_CAPTURE(ProgramUniformMatrix2fvEXT, isCallValid, context, programPacked,
                      locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniformMatrix2x3fvEXT(GLuint program,
                                                 GLint location,
                                                 GLsizei count,
                                                 GLboolean transpose,
                                                 const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniformMatrix2x3fvEXT,
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateProgramUniformMatrix2x3fvEXT(
                                context, programPacked, locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->programUniformMatrix2x3fv(programPacked, locationPacked, count, transpose,
                                               value);
        }
        ANGLE_CAPTURE(ProgramUniformMatrix2x3fvEXT, isCallValid, context, programPacked,
                      locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniformMatrix2x4fvEXT(GLuint program,
                                                 GLint location,
                                                 GLsizei count,
                                                 GLboolean transpose,
                                                 const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniformMatrix2x4fvEXT,
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateProgramUniformMatrix2x4fvEXT(
                                context, programPacked, locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->programUniformMatrix2x4fv(programPacked, locationPacked, count, transpose,
                                               value);
        }
        ANGLE_CAPTURE(ProgramUniformMatrix2x4fvEXT, isCallValid, context, programPacked,
                      locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniformMatrix3fvEXT(GLuint program,
                                               GLint location,
                                               GLsizei count,
                                               GLboolean transpose,
                                               const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniformMatrix3fvEXT,
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateProgramUniformMatrix3fvEXT(
                                context, programPacked, locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->programUniformMatrix3fv(programPacked, locationPacked, count, transpose,
                                             value);
        }
        ANGLE_CAPTURE(ProgramUniformMatrix3fvEXT, isCallValid, context, programPacked,
                      locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniformMatrix3x2fvEXT(GLuint program,
                                                 GLint location,
                                                 GLsizei count,
                                                 GLboolean transpose,
                                                 const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniformMatrix3x2fvEXT,
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateProgramUniformMatrix3x2fvEXT(
                                context, programPacked, locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->programUniformMatrix3x2fv(programPacked, locationPacked, count, transpose,
                                               value);
        }
        ANGLE_CAPTURE(ProgramUniformMatrix3x2fvEXT, isCallValid, context, programPacked,
                      locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniformMatrix3x4fvEXT(GLuint program,
                                                 GLint location,
                                                 GLsizei count,
                                                 GLboolean transpose,
                                                 const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniformMatrix3x4fvEXT,
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateProgramUniformMatrix3x4fvEXT(
                                context, programPacked, locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->programUniformMatrix3x4fv(programPacked, locationPacked, count, transpose,
                                               value);
        }
        ANGLE_CAPTURE(ProgramUniformMatrix3x4fvEXT, isCallValid, context, programPacked,
                      locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniformMatrix4fvEXT(GLuint program,
                                               GLint location,
                                               GLsizei count,
                                               GLboolean transpose,
                                               const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniformMatrix4fvEXT,
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateProgramUniformMatrix4fvEXT(
                                context, programPacked, locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->programUniformMatrix4fv(programPacked, locationPacked, count, transpose,
                                             value);
        }
        ANGLE_CAPTURE(ProgramUniformMatrix4fvEXT, isCallValid, context, programPacked,
                      locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniformMatrix4x2fvEXT(GLuint program,
                                                 GLint location,
                                                 GLsizei count,
                                                 GLboolean transpose,
                                                 const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniformMatrix4x2fvEXT,
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateProgramUniformMatrix4x2fvEXT(
                                context, programPacked, locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->programUniformMatrix4x2fv(programPacked, locationPacked, count, transpose,
                                               value);
        }
        ANGLE_CAPTURE(ProgramUniformMatrix4x2fvEXT, isCallValid, context, programPacked,
                      locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniformMatrix4x3fvEXT(GLuint program,
                                                 GLint location,
                                                 GLsizei count,
                                                 GLboolean transpose,
                                                 const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniformMatrix4x3fvEXT,
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateProgramUniformMatrix4x3fvEXT(
                                context, programPacked, locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->programUniformMatrix4x3fv(programPacked, locationPacked, count, transpose,
                                               value);
        }
        ANGLE_CAPTURE(ProgramUniformMatrix4x3fvEXT, isCallValid, context, programPacked,
                      locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_UseProgramStagesEXT(GLuint pipeline, GLbitfield stages, GLuint program)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUseProgramStagesEXT, "context = %d, pipeline = %u, stages = %s, program = %u",
          CID(context), pipeline,
          GLbitfieldToString(GLenumGroup::UseProgramStageMask, stages).c_str(), program);

    if (context)
    {
        ProgramPipelineID pipelinePacked = PackParam<ProgramPipelineID>(pipeline);
        ShaderProgramID programPacked    = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateUseProgramStagesEXT(context, pipelinePacked, stages, programPacked));
        if (isCallValid)
        {
            context->useProgramStages(pipelinePacked, stages, programPacked);
        }
        ANGLE_CAPTURE(UseProgramStagesEXT, isCallValid, context, pipelinePacked, stages,
                      programPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ValidateProgramPipelineEXT(GLuint pipeline)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLValidateProgramPipelineEXT, "context = %d, pipeline = %u", CID(context),
          pipeline);

    if (context)
    {
        ProgramPipelineID pipelinePacked = PackParam<ProgramPipelineID>(pipeline);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateValidateProgramPipelineEXT(context, pipelinePacked));
        if (isCallValid)
        {
            context->validateProgramPipeline(pipelinePacked);
        }
        ANGLE_CAPTURE(ValidateProgramPipelineEXT, isCallValid, context, pipelinePacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_EXT_shader_framebuffer_fetch_non_coherent
void GL_APIENTRY GL_FramebufferFetchBarrierEXT()
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFramebufferFetchBarrierEXT, "context = %d", CID(context));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateFramebufferFetchBarrierEXT(context));
        if (isCallValid)
        {
            context->framebufferFetchBarrier();
        }
        ANGLE_CAPTURE(FramebufferFetchBarrierEXT, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_EXT_shader_io_blocks

// GL_EXT_tessellation_shader
void GL_APIENTRY GL_PatchParameteriEXT(GLenum pname, GLint value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPatchParameteriEXT, "context = %d, pname = %s, value = %d", CID(context),
          GLenumToString(GLenumGroup::PatchParameterName, pname), value);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidatePatchParameteriEXT(context, pname, value));
        if (isCallValid)
        {
            context->patchParameteri(pname, value);
        }
        ANGLE_CAPTURE(PatchParameteriEXT, isCallValid, context, pname, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_EXT_texture_border_clamp
void GL_APIENTRY GL_GetSamplerParameterIivEXT(GLuint sampler, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetSamplerParameterIivEXT,
          "context = %d, sampler = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname), (uintptr_t)params);

    if (context)
    {
        SamplerID samplerPacked                               = PackParam<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetSamplerParameterIivEXT(context, samplerPacked, pname, params));
        if (isCallValid)
        {
            context->getSamplerParameterIiv(samplerPacked, pname, params);
        }
        ANGLE_CAPTURE(GetSamplerParameterIivEXT, isCallValid, context, samplerPacked, pname,
                      params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetSamplerParameterIuivEXT(GLuint sampler, GLenum pname, GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetSamplerParameterIuivEXT,
          "context = %d, sampler = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname), (uintptr_t)params);

    if (context)
    {
        SamplerID samplerPacked                               = PackParam<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetSamplerParameterIuivEXT(context, samplerPacked, pname, params));
        if (isCallValid)
        {
            context->getSamplerParameterIuiv(samplerPacked, pname, params);
        }
        ANGLE_CAPTURE(GetSamplerParameterIuivEXT, isCallValid, context, samplerPacked, pname,
                      params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetTexParameterIivEXT(GLenum target, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexParameterIivEXT,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::GetTextureParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetTexParameterIivEXT(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getTexParameterIiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetTexParameterIivEXT, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetTexParameterIuivEXT(GLenum target, GLenum pname, GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexParameterIuivEXT,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::GetTextureParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetTexParameterIuivEXT(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getTexParameterIuiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetTexParameterIuivEXT, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_SamplerParameterIivEXT(GLuint sampler, GLenum pname, const GLint *param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSamplerParameterIivEXT,
          "context = %d, sampler = %u, pname = %s, param = 0x%016" PRIxPTR "", CID(context),
          sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname), (uintptr_t)param);

    if (context)
    {
        SamplerID samplerPacked                               = PackParam<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateSamplerParameterIivEXT(context, samplerPacked, pname, param));
        if (isCallValid)
        {
            context->samplerParameterIiv(samplerPacked, pname, param);
        }
        ANGLE_CAPTURE(SamplerParameterIivEXT, isCallValid, context, samplerPacked, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_SamplerParameterIuivEXT(GLuint sampler, GLenum pname, const GLuint *param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSamplerParameterIuivEXT,
          "context = %d, sampler = %u, pname = %s, param = 0x%016" PRIxPTR "", CID(context),
          sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname), (uintptr_t)param);

    if (context)
    {
        SamplerID samplerPacked                               = PackParam<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateSamplerParameterIuivEXT(context, samplerPacked, pname, param));
        if (isCallValid)
        {
            context->samplerParameterIuiv(samplerPacked, pname, param);
        }
        ANGLE_CAPTURE(SamplerParameterIuivEXT, isCallValid, context, samplerPacked, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexParameterIivEXT(GLenum target, GLenum pname, const GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexParameterIivEXT,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::TextureParameterName, pname), (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexParameterIivEXT(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->texParameterIiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(TexParameterIivEXT, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexParameterIuivEXT(GLenum target, GLenum pname, const GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexParameterIuivEXT,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::TextureParameterName, pname), (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexParameterIuivEXT(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->texParameterIuiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(TexParameterIuivEXT, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_EXT_texture_buffer
void GL_APIENTRY GL_TexBufferEXT(GLenum target, GLenum internalformat, GLuint buffer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexBufferEXT, "context = %d, target = %s, internalformat = %s, buffer = %u",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::InternalFormat, internalformat), buffer);

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        BufferID bufferPacked                                 = PackParam<BufferID>(buffer);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexBufferEXT(context, targetPacked, internalformat, bufferPacked));
        if (isCallValid)
        {
            context->texBuffer(targetPacked, internalformat, bufferPacked);
        }
        ANGLE_CAPTURE(TexBufferEXT, isCallValid, context, targetPacked, internalformat,
                      bufferPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexBufferRangeEXT(GLenum target,
                                      GLenum internalformat,
                                      GLuint buffer,
                                      GLintptr offset,
                                      GLsizeiptr size)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexBufferRangeEXT,
          "context = %d, target = %s, internalformat = %s, buffer = %u, offset = %llu, size = %llu",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::InternalFormat, internalformat), buffer,
          static_cast<unsigned long long>(offset), static_cast<unsigned long long>(size));

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        BufferID bufferPacked                                 = PackParam<BufferID>(buffer);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexBufferRangeEXT(context, targetPacked, internalformat,
                                                      bufferPacked, offset, size));
        if (isCallValid)
        {
            context->texBufferRange(targetPacked, internalformat, bufferPacked, offset, size);
        }
        ANGLE_CAPTURE(TexBufferRangeEXT, isCallValid, context, targetPacked, internalformat,
                      bufferPacked, offset, size);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_EXT_texture_compression_bptc

// GL_EXT_texture_compression_dxt1

// GL_EXT_texture_compression_rgtc

// GL_EXT_texture_compression_s3tc

// GL_EXT_texture_compression_s3tc_srgb

// GL_EXT_texture_cube_map_array

// GL_EXT_texture_filter_anisotropic

// GL_EXT_texture_format_BGRA8888

// GL_EXT_texture_sRGB_R8

// GL_EXT_texture_sRGB_RG8

// GL_EXT_texture_storage
void GL_APIENTRY GL_TexStorage1DEXT(GLenum target,
                                    GLsizei levels,
                                    GLenum internalformat,
                                    GLsizei width)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexStorage1DEXT,
          "context = %d, target = %s, levels = %d, internalformat = %s, width = %d", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target), levels,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexStorage1DEXT(context, target, levels, internalformat, width));
        if (isCallValid)
        {
            context->texStorage1D(target, levels, internalformat, width);
        }
        ANGLE_CAPTURE(TexStorage1DEXT, isCallValid, context, target, levels, internalformat, width);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexStorage2DEXT(GLenum target,
                                    GLsizei levels,
                                    GLenum internalformat,
                                    GLsizei width,
                                    GLsizei height)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexStorage2DEXT,
          "context = %d, target = %s, levels = %d, internalformat = %s, width = %d, height = %d",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), levels,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height);

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexStorage2DEXT(context, targetPacked, levels, internalformat, width, height));
        if (isCallValid)
        {
            context->texStorage2D(targetPacked, levels, internalformat, width, height);
        }
        ANGLE_CAPTURE(TexStorage2DEXT, isCallValid, context, targetPacked, levels, internalformat,
                      width, height);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexStorage3DEXT(GLenum target,
                                    GLsizei levels,
                                    GLenum internalformat,
                                    GLsizei width,
                                    GLsizei height,
                                    GLsizei depth)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexStorage3DEXT,
          "context = %d, target = %s, levels = %d, internalformat = %s, width = %d, height = %d, "
          "depth = %d",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), levels,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height, depth);

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexStorage3DEXT(context, targetPacked, levels, internalformat,
                                                    width, height, depth));
        if (isCallValid)
        {
            context->texStorage3D(targetPacked, levels, internalformat, width, height, depth);
        }
        ANGLE_CAPTURE(TexStorage3DEXT, isCallValid, context, targetPacked, levels, internalformat,
                      width, height, depth);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_KHR_blend_equation_advanced
void GL_APIENTRY GL_BlendBarrierKHR()
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBlendBarrierKHR, "context = %d", CID(context));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateBlendBarrierKHR(context));
        if (isCallValid)
        {
            context->blendBarrier();
        }
        ANGLE_CAPTURE(BlendBarrierKHR, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_KHR_debug
void GL_APIENTRY GL_DebugMessageCallbackKHR(GLDEBUGPROCKHR callback, const void *userParam)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDebugMessageCallbackKHR,
          "context = %d, callback = 0x%016" PRIxPTR ", userParam = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)callback, (uintptr_t)userParam);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDebugMessageCallbackKHR(context, callback, userParam));
        if (isCallValid)
        {
            context->debugMessageCallback(callback, userParam);
        }
        ANGLE_CAPTURE(DebugMessageCallbackKHR, isCallValid, context, callback, userParam);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DebugMessageControlKHR(GLenum source,
                                           GLenum type,
                                           GLenum severity,
                                           GLsizei count,
                                           const GLuint *ids,
                                           GLboolean enabled)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDebugMessageControlKHR,
          "context = %d, source = %s, type = %s, severity = %s, count = %d, ids = 0x%016" PRIxPTR
          ", enabled = %s",
          CID(context), GLenumToString(GLenumGroup::DebugSource, source),
          GLenumToString(GLenumGroup::DebugType, type),
          GLenumToString(GLenumGroup::DebugSeverity, severity), count, (uintptr_t)ids,
          GLbooleanToString(enabled));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateDebugMessageControlKHR(context, source, type, severity, count, ids, enabled));
        if (isCallValid)
        {
            context->debugMessageControl(source, type, severity, count, ids, enabled);
        }
        ANGLE_CAPTURE(DebugMessageControlKHR, isCallValid, context, source, type, severity, count,
                      ids, enabled);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DebugMessageInsertKHR(GLenum source,
                                          GLenum type,
                                          GLuint id,
                                          GLenum severity,
                                          GLsizei length,
                                          const GLchar *buf)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDebugMessageInsertKHR,
          "context = %d, source = %s, type = %s, id = %u, severity = %s, length = %d, buf = "
          "0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DebugSource, source),
          GLenumToString(GLenumGroup::DebugType, type), id,
          GLenumToString(GLenumGroup::DebugSeverity, severity), length, (uintptr_t)buf);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateDebugMessageInsertKHR(context, source, type, id, severity, length, buf));
        if (isCallValid)
        {
            context->debugMessageInsert(source, type, id, severity, length, buf);
        }
        ANGLE_CAPTURE(DebugMessageInsertKHR, isCallValid, context, source, type, id, severity,
                      length, buf);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

GLuint GL_APIENTRY GL_GetDebugMessageLogKHR(GLuint count,
                                            GLsizei bufSize,
                                            GLenum *sources,
                                            GLenum *types,
                                            GLuint *ids,
                                            GLenum *severities,
                                            GLsizei *lengths,
                                            GLchar *messageLog)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetDebugMessageLogKHR,
          "context = %d, count = %u, bufSize = %d, sources = 0x%016" PRIxPTR
          ", types = 0x%016" PRIxPTR ", ids = 0x%016" PRIxPTR ", severities = 0x%016" PRIxPTR
          ", lengths = 0x%016" PRIxPTR ", messageLog = 0x%016" PRIxPTR "",
          CID(context), count, bufSize, (uintptr_t)sources, (uintptr_t)types, (uintptr_t)ids,
          (uintptr_t)severities, (uintptr_t)lengths, (uintptr_t)messageLog);

    GLuint returnValue;
    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetDebugMessageLogKHR(context, count, bufSize, sources, types,
                                                          ids, severities, lengths, messageLog));
        if (isCallValid)
        {
            returnValue = context->getDebugMessageLog(count, bufSize, sources, types, ids,
                                                      severities, lengths, messageLog);
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLGetDebugMessageLogKHR, GLuint>();
        }
        ANGLE_CAPTURE(GetDebugMessageLogKHR, isCallValid, context, count, bufSize, sources, types,
                      ids, severities, lengths, messageLog, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetDebugMessageLogKHR, GLuint>();
    }
    return returnValue;
}

void GL_APIENTRY GL_GetObjectLabelKHR(GLenum identifier,
                                      GLuint name,
                                      GLsizei bufSize,
                                      GLsizei *length,
                                      GLchar *label)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetObjectLabelKHR,
          "context = %d, identifier = %s, name = %u, bufSize = %d, length = 0x%016" PRIxPTR
          ", label = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, identifier), name, bufSize,
          (uintptr_t)length, (uintptr_t)label);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetObjectLabelKHR(context, identifier, name, bufSize, length, label));
        if (isCallValid)
        {
            context->getObjectLabel(identifier, name, bufSize, length, label);
        }
        ANGLE_CAPTURE(GetObjectLabelKHR, isCallValid, context, identifier, name, bufSize, length,
                      label);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetObjectPtrLabelKHR(const void *ptr,
                                         GLsizei bufSize,
                                         GLsizei *length,
                                         GLchar *label)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetObjectPtrLabelKHR,
          "context = %d, ptr = 0x%016" PRIxPTR ", bufSize = %d, length = 0x%016" PRIxPTR
          ", label = 0x%016" PRIxPTR "",
          CID(context), (uintptr_t)ptr, bufSize, (uintptr_t)length, (uintptr_t)label);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetObjectPtrLabelKHR(context, ptr, bufSize, length, label));
        if (isCallValid)
        {
            context->getObjectPtrLabel(ptr, bufSize, length, label);
        }
        ANGLE_CAPTURE(GetObjectPtrLabelKHR, isCallValid, context, ptr, bufSize, length, label);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetPointervKHR(GLenum pname, void **params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetPointervKHR, "context = %d, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetPointervKHR(context, pname, params));
        if (isCallValid)
        {
            context->getPointerv(pname, params);
        }
        ANGLE_CAPTURE(GetPointervKHR, isCallValid, context, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ObjectLabelKHR(GLenum identifier,
                                   GLuint name,
                                   GLsizei length,
                                   const GLchar *label)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLObjectLabelKHR,
          "context = %d, identifier = %s, name = %u, length = %d, label = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::ObjectIdentifier, identifier), name, length,
          (uintptr_t)label);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateObjectLabelKHR(context, identifier, name, length, label));
        if (isCallValid)
        {
            context->objectLabel(identifier, name, length, label);
        }
        ANGLE_CAPTURE(ObjectLabelKHR, isCallValid, context, identifier, name, length, label);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ObjectPtrLabelKHR(const void *ptr, GLsizei length, const GLchar *label)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLObjectPtrLabelKHR,
          "context = %d, ptr = 0x%016" PRIxPTR ", length = %d, label = 0x%016" PRIxPTR "",
          CID(context), (uintptr_t)ptr, length, (uintptr_t)label);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateObjectPtrLabelKHR(context, ptr, length, label));
        if (isCallValid)
        {
            context->objectPtrLabel(ptr, length, label);
        }
        ANGLE_CAPTURE(ObjectPtrLabelKHR, isCallValid, context, ptr, length, label);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_PopDebugGroupKHR()
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPopDebugGroupKHR, "context = %d", CID(context));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidatePopDebugGroupKHR(context));
        if (isCallValid)
        {
            context->popDebugGroup();
        }
        ANGLE_CAPTURE(PopDebugGroupKHR, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_PushDebugGroupKHR(GLenum source,
                                      GLuint id,
                                      GLsizei length,
                                      const GLchar *message)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPushDebugGroupKHR,
          "context = %d, source = %s, id = %u, length = %d, message = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DebugSource, source), id, length,
          (uintptr_t)message);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidatePushDebugGroupKHR(context, source, id, length, message));
        if (isCallValid)
        {
            context->pushDebugGroup(source, id, length, message);
        }
        ANGLE_CAPTURE(PushDebugGroupKHR, isCallValid, context, source, id, length, message);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_KHR_parallel_shader_compile
void GL_APIENTRY GL_MaxShaderCompilerThreadsKHR(GLuint count)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMaxShaderCompilerThreadsKHR, "context = %d, count = %u", CID(context), count);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateMaxShaderCompilerThreadsKHR(context, count));
        if (isCallValid)
        {
            context->maxShaderCompilerThreads(count);
        }
        ANGLE_CAPTURE(MaxShaderCompilerThreadsKHR, isCallValid, context, count);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_NV_fence
void GL_APIENTRY GL_DeleteFencesNV(GLsizei n, const GLuint *fences)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDeleteFencesNV, "context = %d, n = %d, fences = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)fences);

    if (context)
    {
        const FenceNVID *fencesPacked = PackParam<const FenceNVID *>(fences);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDeleteFencesNV(context, n, fencesPacked));
        if (isCallValid)
        {
            context->deleteFencesNV(n, fencesPacked);
        }
        ANGLE_CAPTURE(DeleteFencesNV, isCallValid, context, n, fencesPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_FinishFenceNV(GLuint fence)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFinishFenceNV, "context = %d, fence = %u", CID(context), fence);

    if (context)
    {
        FenceNVID fencePacked                                 = PackParam<FenceNVID>(fence);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateFinishFenceNV(context, fencePacked));
        if (isCallValid)
        {
            context->finishFenceNV(fencePacked);
        }
        ANGLE_CAPTURE(FinishFenceNV, isCallValid, context, fencePacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GenFencesNV(GLsizei n, GLuint *fences)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGenFencesNV, "context = %d, n = %d, fences = 0x%016" PRIxPTR "", CID(context),
          n, (uintptr_t)fences);

    if (context)
    {
        FenceNVID *fencesPacked                               = PackParam<FenceNVID *>(fences);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenFencesNV(context, n, fencesPacked));
        if (isCallValid)
        {
            context->genFencesNV(n, fencesPacked);
        }
        ANGLE_CAPTURE(GenFencesNV, isCallValid, context, n, fencesPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetFenceivNV(GLuint fence, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetFenceivNV,
          "context = %d, fence = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context), fence,
          GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)params);

    if (context)
    {
        FenceNVID fencePacked                                 = PackParam<FenceNVID>(fence);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetFenceivNV(context, fencePacked, pname, params));
        if (isCallValid)
        {
            context->getFenceivNV(fencePacked, pname, params);
        }
        ANGLE_CAPTURE(GetFenceivNV, isCallValid, context, fencePacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

GLboolean GL_APIENTRY GL_IsFenceNV(GLuint fence)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLIsFenceNV, "context = %d, fence = %u", CID(context), fence);

    GLboolean returnValue;
    if (context)
    {
        FenceNVID fencePacked                                 = PackParam<FenceNVID>(fence);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateIsFenceNV(context, fencePacked));
        if (isCallValid)
        {
            returnValue = context->isFenceNV(fencePacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsFenceNV, GLboolean>();
        }
        ANGLE_CAPTURE(IsFenceNV, isCallValid, context, fencePacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsFenceNV, GLboolean>();
    }
    return returnValue;
}

void GL_APIENTRY GL_SetFenceNV(GLuint fence, GLenum condition)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSetFenceNV, "context = %d, fence = %u, condition = %s", CID(context), fence,
          GLenumToString(GLenumGroup::DefaultGroup, condition));

    if (context)
    {
        FenceNVID fencePacked                                 = PackParam<FenceNVID>(fence);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateSetFenceNV(context, fencePacked, condition));
        if (isCallValid)
        {
            context->setFenceNV(fencePacked, condition);
        }
        ANGLE_CAPTURE(SetFenceNV, isCallValid, context, fencePacked, condition);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

GLboolean GL_APIENTRY GL_TestFenceNV(GLuint fence)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTestFenceNV, "context = %d, fence = %u", CID(context), fence);

    GLboolean returnValue;
    if (context)
    {
        FenceNVID fencePacked                                 = PackParam<FenceNVID>(fence);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateTestFenceNV(context, fencePacked));
        if (isCallValid)
        {
            returnValue = context->testFenceNV(fencePacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLTestFenceNV, GLboolean>();
        }
        ANGLE_CAPTURE(TestFenceNV, isCallValid, context, fencePacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLTestFenceNV, GLboolean>();
    }
    return returnValue;
}

// GL_NV_framebuffer_blit
void GL_APIENTRY GL_BlitFramebufferNV(GLint srcX0,
                                      GLint srcY0,
                                      GLint srcX1,
                                      GLint srcY1,
                                      GLint dstX0,
                                      GLint dstY0,
                                      GLint dstX1,
                                      GLint dstY1,
                                      GLbitfield mask,
                                      GLenum filter)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBlitFramebufferNV,
          "context = %d, srcX0 = %d, srcY0 = %d, srcX1 = %d, srcY1 = %d, dstX0 = %d, dstY0 = %d, "
          "dstX1 = %d, dstY1 = %d, mask = %s, filter = %s",
          CID(context), srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1,
          GLbitfieldToString(GLenumGroup::ClearBufferMask, mask).c_str(),
          GLenumToString(GLenumGroup::BlitFramebufferFilter, filter));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBlitFramebufferNV(context, srcX0, srcY0, srcX1, srcY1, dstX0,
                                                      dstY0, dstX1, dstY1, mask, filter));
        if (isCallValid)
        {
            context->blitFramebufferNV(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask,
                                       filter);
        }
        ANGLE_CAPTURE(BlitFramebufferNV, isCallValid, context, srcX0, srcY0, srcX1, srcY1, dstX0,
                      dstY0, dstX1, dstY1, mask, filter);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_OES_EGL_image
void GL_APIENTRY GL_EGLImageTargetRenderbufferStorageOES(GLenum target, GLeglImageOES image)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLEGLImageTargetRenderbufferStorageOES,
          "context = %d, target = %s, image = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::DefaultGroup, target), (uintptr_t)image);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateEGLImageTargetRenderbufferStorageOES(context, target, image));
        if (isCallValid)
        {
            context->eGLImageTargetRenderbufferStorage(target, image);
        }
        ANGLE_CAPTURE(EGLImageTargetRenderbufferStorageOES, isCallValid, context, target, image);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_EGLImageTargetTexture2DOES(GLenum target, GLeglImageOES image)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLEGLImageTargetTexture2DOES,
          "context = %d, target = %s, image = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::DefaultGroup, target), (uintptr_t)image);

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateEGLImageTargetTexture2DOES(context, targetPacked, image));
        if (isCallValid)
        {
            context->eGLImageTargetTexture2D(targetPacked, image);
        }
        ANGLE_CAPTURE(EGLImageTargetTexture2DOES, isCallValid, context, targetPacked, image);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_OES_compressed_ETC1_RGB8_texture

// GL_OES_copy_image
void GL_APIENTRY GL_CopyImageSubDataOES(GLuint srcName,
                                        GLenum srcTarget,
                                        GLint srcLevel,
                                        GLint srcX,
                                        GLint srcY,
                                        GLint srcZ,
                                        GLuint dstName,
                                        GLenum dstTarget,
                                        GLint dstLevel,
                                        GLint dstX,
                                        GLint dstY,
                                        GLint dstZ,
                                        GLsizei srcWidth,
                                        GLsizei srcHeight,
                                        GLsizei srcDepth)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCopyImageSubDataOES,
          "context = %d, srcName = %u, srcTarget = %s, srcLevel = %d, srcX = %d, srcY = %d, srcZ = "
          "%d, dstName = %u, dstTarget = %s, dstLevel = %d, dstX = %d, dstY = %d, dstZ = %d, "
          "srcWidth = %d, srcHeight = %d, srcDepth = %d",
          CID(context), srcName, GLenumToString(GLenumGroup::CopyBufferSubDataTarget, srcTarget),
          srcLevel, srcX, srcY, srcZ, dstName,
          GLenumToString(GLenumGroup::CopyBufferSubDataTarget, dstTarget), dstLevel, dstX, dstY,
          dstZ, srcWidth, srcHeight, srcDepth);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateCopyImageSubDataOES(context, srcName, srcTarget, srcLevel, srcX, srcY, srcZ,
                                         dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth,
                                         srcHeight, srcDepth));
        if (isCallValid)
        {
            context->copyImageSubData(srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName,
                                      dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth, srcHeight,
                                      srcDepth);
        }
        ANGLE_CAPTURE(CopyImageSubDataOES, isCallValid, context, srcName, srcTarget, srcLevel, srcX,
                      srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth,
                      srcHeight, srcDepth);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_OES_depth32

// GL_OES_draw_buffers_indexed
void GL_APIENTRY GL_BlendEquationSeparateiOES(GLuint buf, GLenum modeRGB, GLenum modeAlpha)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBlendEquationSeparateiOES,
          "context = %d, buf = %u, modeRGB = %s, modeAlpha = %s", CID(context), buf,
          GLenumToString(GLenumGroup::BlendEquationModeEXT, modeRGB),
          GLenumToString(GLenumGroup::BlendEquationModeEXT, modeAlpha));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBlendEquationSeparateiOES(context, buf, modeRGB, modeAlpha));
        if (isCallValid)
        {
            context->blendEquationSeparatei(buf, modeRGB, modeAlpha);
        }
        ANGLE_CAPTURE(BlendEquationSeparateiOES, isCallValid, context, buf, modeRGB, modeAlpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_BlendEquationiOES(GLuint buf, GLenum mode)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBlendEquationiOES, "context = %d, buf = %u, mode = %s", CID(context), buf,
          GLenumToString(GLenumGroup::BlendEquationModeEXT, mode));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBlendEquationiOES(context, buf, mode));
        if (isCallValid)
        {
            context->blendEquationi(buf, mode);
        }
        ANGLE_CAPTURE(BlendEquationiOES, isCallValid, context, buf, mode);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY
GL_BlendFuncSeparateiOES(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBlendFuncSeparateiOES,
          "context = %d, buf = %u, srcRGB = %s, dstRGB = %s, srcAlpha = %s, dstAlpha = %s",
          CID(context), buf, GLenumToString(GLenumGroup::BlendingFactor, srcRGB),
          GLenumToString(GLenumGroup::BlendingFactor, dstRGB),
          GLenumToString(GLenumGroup::BlendingFactor, srcAlpha),
          GLenumToString(GLenumGroup::BlendingFactor, dstAlpha));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateBlendFuncSeparateiOES(context, buf, srcRGB, dstRGB, srcAlpha, dstAlpha));
        if (isCallValid)
        {
            context->blendFuncSeparatei(buf, srcRGB, dstRGB, srcAlpha, dstAlpha);
        }
        ANGLE_CAPTURE(BlendFuncSeparateiOES, isCallValid, context, buf, srcRGB, dstRGB, srcAlpha,
                      dstAlpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_BlendFunciOES(GLuint buf, GLenum src, GLenum dst)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBlendFunciOES, "context = %d, buf = %u, src = %s, dst = %s", CID(context), buf,
          GLenumToString(GLenumGroup::BlendingFactor, src),
          GLenumToString(GLenumGroup::BlendingFactor, dst));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBlendFunciOES(context, buf, src, dst));
        if (isCallValid)
        {
            context->blendFunci(buf, src, dst);
        }
        ANGLE_CAPTURE(BlendFunciOES, isCallValid, context, buf, src, dst);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ColorMaskiOES(GLuint index, GLboolean r, GLboolean g, GLboolean b, GLboolean a)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColorMaskiOES, "context = %d, index = %u, r = %s, g = %s, b = %s, a = %s",
          CID(context), index, GLbooleanToString(r), GLbooleanToString(g), GLbooleanToString(b),
          GLbooleanToString(a));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateColorMaskiOES(context, index, r, g, b, a));
        if (isCallValid)
        {
            context->colorMaski(index, r, g, b, a);
        }
        ANGLE_CAPTURE(ColorMaskiOES, isCallValid, context, index, r, g, b, a);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DisableiOES(GLenum target, GLuint index)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDisableiOES, "context = %d, target = %s, index = %u", CID(context),
          GLenumToString(GLenumGroup::EnableCap, target), index);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDisableiOES(context, target, index));
        if (isCallValid)
        {
            context->disablei(target, index);
        }
        ANGLE_CAPTURE(DisableiOES, isCallValid, context, target, index);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_EnableiOES(GLenum target, GLuint index)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLEnableiOES, "context = %d, target = %s, index = %u", CID(context),
          GLenumToString(GLenumGroup::EnableCap, target), index);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateEnableiOES(context, target, index));
        if (isCallValid)
        {
            context->enablei(target, index);
        }
        ANGLE_CAPTURE(EnableiOES, isCallValid, context, target, index);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

GLboolean GL_APIENTRY GL_IsEnablediOES(GLenum target, GLuint index)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLIsEnablediOES, "context = %d, target = %s, index = %u", CID(context),
          GLenumToString(GLenumGroup::EnableCap, target), index);

    GLboolean returnValue;
    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsEnablediOES(context, target, index));
        if (isCallValid)
        {
            returnValue = context->isEnabledi(target, index);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsEnablediOES, GLboolean>();
        }
        ANGLE_CAPTURE(IsEnablediOES, isCallValid, context, target, index, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsEnablediOES, GLboolean>();
    }
    return returnValue;
}

// GL_OES_draw_elements_base_vertex
void GL_APIENTRY GL_DrawElementsBaseVertexOES(GLenum mode,
                                              GLsizei count,
                                              GLenum type,
                                              const void *indices,
                                              GLint basevertex)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawElementsBaseVertexOES,
          "context = %d, mode = %s, count = %d, type = %s, indices = 0x%016" PRIxPTR
          ", basevertex = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, basevertex);

    if (context)
    {
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked                           = PackParam<DrawElementsType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDrawElementsBaseVertexOES(context, modePacked, count,
                                                              typePacked, indices, basevertex));
        if (isCallValid)
        {
            context->drawElementsBaseVertex(modePacked, count, typePacked, indices, basevertex);
        }
        ANGLE_CAPTURE(DrawElementsBaseVertexOES, isCallValid, context, modePacked, count,
                      typePacked, indices, basevertex);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DrawElementsInstancedBaseVertexOES(GLenum mode,
                                                       GLsizei count,
                                                       GLenum type,
                                                       const void *indices,
                                                       GLsizei instancecount,
                                                       GLint basevertex)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawElementsInstancedBaseVertexOES,
          "context = %d, mode = %s, count = %d, type = %s, indices = 0x%016" PRIxPTR
          ", instancecount = %d, basevertex = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, instancecount,
          basevertex);

    if (context)
    {
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked                           = PackParam<DrawElementsType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawElementsInstancedBaseVertexOES(
                                                             context, modePacked, count, typePacked,
                                                             indices, instancecount, basevertex));
        if (isCallValid)
        {
            context->drawElementsInstancedBaseVertex(modePacked, count, typePacked, indices,
                                                     instancecount, basevertex);
        }
        ANGLE_CAPTURE(DrawElementsInstancedBaseVertexOES, isCallValid, context, modePacked, count,
                      typePacked, indices, instancecount, basevertex);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DrawRangeElementsBaseVertexOES(GLenum mode,
                                                   GLuint start,
                                                   GLuint end,
                                                   GLsizei count,
                                                   GLenum type,
                                                   const void *indices,
                                                   GLint basevertex)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawRangeElementsBaseVertexOES,
          "context = %d, mode = %s, start = %u, end = %u, count = %d, type = %s, indices = "
          "0x%016" PRIxPTR ", basevertex = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), start, end, count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, basevertex);

    if (context)
    {
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked                           = PackParam<DrawElementsType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawRangeElementsBaseVertexOES(
                                                             context, modePacked, start, end, count,
                                                             typePacked, indices, basevertex));
        if (isCallValid)
        {
            context->drawRangeElementsBaseVertex(modePacked, start, end, count, typePacked, indices,
                                                 basevertex);
        }
        ANGLE_CAPTURE(DrawRangeElementsBaseVertexOES, isCallValid, context, modePacked, start, end,
                      count, typePacked, indices, basevertex);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// MultiDrawElementsBaseVertexEXT is already defined.

// GL_OES_draw_texture
void GL_APIENTRY GL_DrawTexfOES(GLfloat x, GLfloat y, GLfloat z, GLfloat width, GLfloat height)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawTexfOES, "context = %d, x = %f, y = %f, z = %f, width = %f, height = %f",
          CID(context), x, y, z, width, height);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDrawTexfOES(context, x, y, z, width, height));
        if (isCallValid)
        {
            context->drawTexf(x, y, z, width, height);
        }
        ANGLE_CAPTURE(DrawTexfOES, isCallValid, context, x, y, z, width, height);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DrawTexfvOES(const GLfloat *coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawTexfvOES, "context = %d, coords = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)coords);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawTexfvOES(context, coords));
        if (isCallValid)
        {
            context->drawTexfv(coords);
        }
        ANGLE_CAPTURE(DrawTexfvOES, isCallValid, context, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DrawTexiOES(GLint x, GLint y, GLint z, GLint width, GLint height)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawTexiOES, "context = %d, x = %d, y = %d, z = %d, width = %d, height = %d",
          CID(context), x, y, z, width, height);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDrawTexiOES(context, x, y, z, width, height));
        if (isCallValid)
        {
            context->drawTexi(x, y, z, width, height);
        }
        ANGLE_CAPTURE(DrawTexiOES, isCallValid, context, x, y, z, width, height);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DrawTexivOES(const GLint *coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawTexivOES, "context = %d, coords = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)coords);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawTexivOES(context, coords));
        if (isCallValid)
        {
            context->drawTexiv(coords);
        }
        ANGLE_CAPTURE(DrawTexivOES, isCallValid, context, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DrawTexsOES(GLshort x, GLshort y, GLshort z, GLshort width, GLshort height)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawTexsOES, "context = %d, x = %d, y = %d, z = %d, width = %d, height = %d",
          CID(context), x, y, z, width, height);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDrawTexsOES(context, x, y, z, width, height));
        if (isCallValid)
        {
            context->drawTexs(x, y, z, width, height);
        }
        ANGLE_CAPTURE(DrawTexsOES, isCallValid, context, x, y, z, width, height);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DrawTexsvOES(const GLshort *coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawTexsvOES, "context = %d, coords = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)coords);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawTexsvOES(context, coords));
        if (isCallValid)
        {
            context->drawTexsv(coords);
        }
        ANGLE_CAPTURE(DrawTexsvOES, isCallValid, context, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DrawTexxOES(GLfixed x, GLfixed y, GLfixed z, GLfixed width, GLfixed height)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawTexxOES,
          "context = %d, x = 0x%X, y = 0x%X, z = 0x%X, width = 0x%X, height = 0x%X", CID(context),
          x, y, z, width, height);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDrawTexxOES(context, x, y, z, width, height));
        if (isCallValid)
        {
            context->drawTexx(x, y, z, width, height);
        }
        ANGLE_CAPTURE(DrawTexxOES, isCallValid, context, x, y, z, width, height);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DrawTexxvOES(const GLfixed *coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawTexxvOES, "context = %d, coords = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)coords);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawTexxvOES(context, coords));
        if (isCallValid)
        {
            context->drawTexxv(coords);
        }
        ANGLE_CAPTURE(DrawTexxvOES, isCallValid, context, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_OES_framebuffer_object
void GL_APIENTRY GL_BindFramebufferOES(GLenum target, GLuint framebuffer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBindFramebufferOES, "context = %d, target = %s, framebuffer = %u",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target), framebuffer);

    if (context)
    {
        FramebufferID framebufferPacked = PackParam<FramebufferID>(framebuffer);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBindFramebufferOES(context, target, framebufferPacked));
        if (isCallValid)
        {
            context->bindFramebuffer(target, framebufferPacked);
        }
        ANGLE_CAPTURE(BindFramebufferOES, isCallValid, context, target, framebufferPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_BindRenderbufferOES(GLenum target, GLuint renderbuffer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBindRenderbufferOES, "context = %d, target = %s, renderbuffer = %u",
          CID(context), GLenumToString(GLenumGroup::RenderbufferTarget, target), renderbuffer);

    if (context)
    {
        RenderbufferID renderbufferPacked = PackParam<RenderbufferID>(renderbuffer);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBindRenderbufferOES(context, target, renderbufferPacked));
        if (isCallValid)
        {
            context->bindRenderbuffer(target, renderbufferPacked);
        }
        ANGLE_CAPTURE(BindRenderbufferOES, isCallValid, context, target, renderbufferPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

GLenum GL_APIENTRY GL_CheckFramebufferStatusOES(GLenum target)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCheckFramebufferStatusOES, "context = %d, target = %s", CID(context),
          GLenumToString(GLenumGroup::FramebufferTarget, target));

    GLenum returnValue;
    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateCheckFramebufferStatusOES(context, target));
        if (isCallValid)
        {
            returnValue = context->checkFramebufferStatus(target);
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLCheckFramebufferStatusOES, GLenum>();
        }
        ANGLE_CAPTURE(CheckFramebufferStatusOES, isCallValid, context, target, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue =
            GetDefaultReturnValue<angle::EntryPoint::GLCheckFramebufferStatusOES, GLenum>();
    }
    return returnValue;
}

void GL_APIENTRY GL_DeleteFramebuffersOES(GLsizei n, const GLuint *framebuffers)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDeleteFramebuffersOES,
          "context = %d, n = %d, framebuffers = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)framebuffers);

    if (context)
    {
        const FramebufferID *framebuffersPacked = PackParam<const FramebufferID *>(framebuffers);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDeleteFramebuffersOES(context, n, framebuffersPacked));
        if (isCallValid)
        {
            context->deleteFramebuffers(n, framebuffersPacked);
        }
        ANGLE_CAPTURE(DeleteFramebuffersOES, isCallValid, context, n, framebuffersPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DeleteRenderbuffersOES(GLsizei n, const GLuint *renderbuffers)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDeleteRenderbuffersOES,
          "context = %d, n = %d, renderbuffers = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)renderbuffers);

    if (context)
    {
        const RenderbufferID *renderbuffersPacked =
            PackParam<const RenderbufferID *>(renderbuffers);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDeleteRenderbuffersOES(context, n, renderbuffersPacked));
        if (isCallValid)
        {
            context->deleteRenderbuffers(n, renderbuffersPacked);
        }
        ANGLE_CAPTURE(DeleteRenderbuffersOES, isCallValid, context, n, renderbuffersPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_FramebufferRenderbufferOES(GLenum target,
                                               GLenum attachment,
                                               GLenum renderbuffertarget,
                                               GLuint renderbuffer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFramebufferRenderbufferOES,
          "context = %d, target = %s, attachment = %s, renderbuffertarget = %s, renderbuffer = %u",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment),
          GLenumToString(GLenumGroup::RenderbufferTarget, renderbuffertarget), renderbuffer);

    if (context)
    {
        RenderbufferID renderbufferPacked = PackParam<RenderbufferID>(renderbuffer);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateFramebufferRenderbufferOES(context, target, attachment, renderbuffertarget,
                                                renderbufferPacked));
        if (isCallValid)
        {
            context->framebufferRenderbuffer(target, attachment, renderbuffertarget,
                                             renderbufferPacked);
        }
        ANGLE_CAPTURE(FramebufferRenderbufferOES, isCallValid, context, target, attachment,
                      renderbuffertarget, renderbufferPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_FramebufferTexture2DOES(GLenum target,
                                            GLenum attachment,
                                            GLenum textarget,
                                            GLuint texture,
                                            GLint level)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFramebufferTexture2DOES,
          "context = %d, target = %s, attachment = %s, textarget = %s, texture = %u, level = %d",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment),
          GLenumToString(GLenumGroup::TextureTarget, textarget), texture, level);

    if (context)
    {
        TextureTarget textargetPacked                         = PackParam<TextureTarget>(textarget);
        TextureID texturePacked                               = PackParam<TextureID>(texture);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateFramebufferTexture2DOES(context, target, attachment,
                                                            textargetPacked, texturePacked, level));
        if (isCallValid)
        {
            context->framebufferTexture2D(target, attachment, textargetPacked, texturePacked,
                                          level);
        }
        ANGLE_CAPTURE(FramebufferTexture2DOES, isCallValid, context, target, attachment,
                      textargetPacked, texturePacked, level);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GenFramebuffersOES(GLsizei n, GLuint *framebuffers)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGenFramebuffersOES, "context = %d, n = %d, framebuffers = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)framebuffers);

    if (context)
    {
        FramebufferID *framebuffersPacked = PackParam<FramebufferID *>(framebuffers);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGenFramebuffersOES(context, n, framebuffersPacked));
        if (isCallValid)
        {
            context->genFramebuffers(n, framebuffersPacked);
        }
        ANGLE_CAPTURE(GenFramebuffersOES, isCallValid, context, n, framebuffersPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GenRenderbuffersOES(GLsizei n, GLuint *renderbuffers)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGenRenderbuffersOES, "context = %d, n = %d, renderbuffers = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)renderbuffers);

    if (context)
    {
        RenderbufferID *renderbuffersPacked = PackParam<RenderbufferID *>(renderbuffers);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGenRenderbuffersOES(context, n, renderbuffersPacked));
        if (isCallValid)
        {
            context->genRenderbuffers(n, renderbuffersPacked);
        }
        ANGLE_CAPTURE(GenRenderbuffersOES, isCallValid, context, n, renderbuffersPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GenerateMipmapOES(GLenum target)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGenerateMipmapOES, "context = %d, target = %s", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target));

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenerateMipmapOES(context, targetPacked));
        if (isCallValid)
        {
            context->generateMipmap(targetPacked);
        }
        ANGLE_CAPTURE(GenerateMipmapOES, isCallValid, context, targetPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetFramebufferAttachmentParameterivOES(GLenum target,
                                                           GLenum attachment,
                                                           GLenum pname,
                                                           GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetFramebufferAttachmentParameterivOES,
          "context = %d, target = %s, attachment = %s, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment),
          GLenumToString(GLenumGroup::FramebufferAttachmentParameterName, pname),
          (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetFramebufferAttachmentParameterivOES(
                                              context, target, attachment, pname, params));
        if (isCallValid)
        {
            context->getFramebufferAttachmentParameteriv(target, attachment, pname, params);
        }
        ANGLE_CAPTURE(GetFramebufferAttachmentParameterivOES, isCallValid, context, target,
                      attachment, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetRenderbufferParameterivOES(GLenum target, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetRenderbufferParameterivOES,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::RenderbufferTarget, target),
          GLenumToString(GLenumGroup::RenderbufferParameterName, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetRenderbufferParameterivOES(context, target, pname, params));
        if (isCallValid)
        {
            context->getRenderbufferParameteriv(target, pname, params);
        }
        ANGLE_CAPTURE(GetRenderbufferParameterivOES, isCallValid, context, target, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

GLboolean GL_APIENTRY GL_IsFramebufferOES(GLuint framebuffer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLIsFramebufferOES, "context = %d, framebuffer = %u", CID(context), framebuffer);

    GLboolean returnValue;
    if (context)
    {
        FramebufferID framebufferPacked = PackParam<FramebufferID>(framebuffer);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsFramebufferOES(context, framebufferPacked));
        if (isCallValid)
        {
            returnValue = context->isFramebuffer(framebufferPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsFramebufferOES, GLboolean>();
        }
        ANGLE_CAPTURE(IsFramebufferOES, isCallValid, context, framebufferPacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsFramebufferOES, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY GL_IsRenderbufferOES(GLuint renderbuffer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLIsRenderbufferOES, "context = %d, renderbuffer = %u", CID(context),
          renderbuffer);

    GLboolean returnValue;
    if (context)
    {
        RenderbufferID renderbufferPacked = PackParam<RenderbufferID>(renderbuffer);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsRenderbufferOES(context, renderbufferPacked));
        if (isCallValid)
        {
            returnValue = context->isRenderbuffer(renderbufferPacked);
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLIsRenderbufferOES, GLboolean>();
        }
        ANGLE_CAPTURE(IsRenderbufferOES, isCallValid, context, renderbufferPacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsRenderbufferOES, GLboolean>();
    }
    return returnValue;
}

void GL_APIENTRY GL_RenderbufferStorageOES(GLenum target,
                                           GLenum internalformat,
                                           GLsizei width,
                                           GLsizei height)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRenderbufferStorageOES,
          "context = %d, target = %s, internalformat = %s, width = %d, height = %d", CID(context),
          GLenumToString(GLenumGroup::RenderbufferTarget, target),
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateRenderbufferStorageOES(context, target, internalformat, width, height));
        if (isCallValid)
        {
            context->renderbufferStorage(target, internalformat, width, height);
        }
        ANGLE_CAPTURE(RenderbufferStorageOES, isCallValid, context, target, internalformat, width,
                      height);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_OES_get_program_binary
void GL_APIENTRY GL_GetProgramBinaryOES(GLuint program,
                                        GLsizei bufSize,
                                        GLsizei *length,
                                        GLenum *binaryFormat,
                                        void *binary)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetProgramBinaryOES,
          "context = %d, program = %u, bufSize = %d, length = 0x%016" PRIxPTR
          ", binaryFormat = 0x%016" PRIxPTR ", binary = 0x%016" PRIxPTR "",
          CID(context), program, bufSize, (uintptr_t)length, (uintptr_t)binaryFormat,
          (uintptr_t)binary);

    if (context)
    {
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetProgramBinaryOES(context, programPacked, bufSize, length,
                                                        binaryFormat, binary));
        if (isCallValid)
        {
            context->getProgramBinary(programPacked, bufSize, length, binaryFormat, binary);
        }
        ANGLE_CAPTURE(GetProgramBinaryOES, isCallValid, context, programPacked, bufSize, length,
                      binaryFormat, binary);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramBinaryOES(GLuint program,
                                     GLenum binaryFormat,
                                     const void *binary,
                                     GLint length)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramBinaryOES,
          "context = %d, program = %u, binaryFormat = %s, binary = 0x%016" PRIxPTR ", length = %d",
          CID(context), program, GLenumToString(GLenumGroup::DefaultGroup, binaryFormat),
          (uintptr_t)binary, length);

    if (context)
    {
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramBinaryOES(context, programPacked, binaryFormat, binary, length));
        if (isCallValid)
        {
            context->programBinary(programPacked, binaryFormat, binary, length);
        }
        ANGLE_CAPTURE(ProgramBinaryOES, isCallValid, context, programPacked, binaryFormat, binary,
                      length);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_OES_mapbuffer
void GL_APIENTRY GL_GetBufferPointervOES(GLenum target, GLenum pname, void **params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetBufferPointervOES,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::BufferTargetARB, target),
          GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)params);

    if (context)
    {
        BufferBinding targetPacked                            = PackParam<BufferBinding>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetBufferPointervOES(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getBufferPointerv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetBufferPointervOES, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void *GL_APIENTRY GL_MapBufferOES(GLenum target, GLenum access)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMapBufferOES, "context = %d, target = %s, access = %s", CID(context),
          GLenumToString(GLenumGroup::BufferTargetARB, target),
          GLenumToString(GLenumGroup::BufferAccessARB, access));

    void *returnValue;
    if (context)
    {
        BufferBinding targetPacked                            = PackParam<BufferBinding>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateMapBufferOES(context, targetPacked, access));
        if (isCallValid)
        {
            returnValue = context->mapBuffer(targetPacked, access);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLMapBufferOES, void *>();
        }
        ANGLE_CAPTURE(MapBufferOES, isCallValid, context, targetPacked, access, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLMapBufferOES, void *>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY GL_UnmapBufferOES(GLenum target)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUnmapBufferOES, "context = %d, target = %s", CID(context),
          GLenumToString(GLenumGroup::DefaultGroup, target));

    GLboolean returnValue;
    if (context)
    {
        BufferBinding targetPacked                            = PackParam<BufferBinding>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUnmapBufferOES(context, targetPacked));
        if (isCallValid)
        {
            returnValue = context->unmapBuffer(targetPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLUnmapBufferOES, GLboolean>();
        }
        ANGLE_CAPTURE(UnmapBufferOES, isCallValid, context, targetPacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLUnmapBufferOES, GLboolean>();
    }
    return returnValue;
}

// GL_OES_matrix_palette
void GL_APIENTRY GL_CurrentPaletteMatrixOES(GLuint matrixpaletteindex)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCurrentPaletteMatrixOES, "context = %d, matrixpaletteindex = %u", CID(context),
          matrixpaletteindex);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateCurrentPaletteMatrixOES(context, matrixpaletteindex));
        if (isCallValid)
        {
            context->currentPaletteMatrix(matrixpaletteindex);
        }
        ANGLE_CAPTURE(CurrentPaletteMatrixOES, isCallValid, context, matrixpaletteindex);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_LoadPaletteFromModelViewMatrixOES()
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLoadPaletteFromModelViewMatrixOES, "context = %d", CID(context));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateLoadPaletteFromModelViewMatrixOES(context));
        if (isCallValid)
        {
            context->loadPaletteFromModelViewMatrix();
        }
        ANGLE_CAPTURE(LoadPaletteFromModelViewMatrixOES, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MatrixIndexPointerOES(GLint size,
                                          GLenum type,
                                          GLsizei stride,
                                          const void *pointer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMatrixIndexPointerOES,
          "context = %d, size = %d, type = %s, stride = %d, pointer = 0x%016" PRIxPTR "",
          CID(context), size, GLenumToString(GLenumGroup::DefaultGroup, type), stride,
          (uintptr_t)pointer);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateMatrixIndexPointerOES(context, size, type, stride, pointer));
        if (isCallValid)
        {
            context->matrixIndexPointer(size, type, stride, pointer);
        }
        ANGLE_CAPTURE(MatrixIndexPointerOES, isCallValid, context, size, type, stride, pointer);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_WeightPointerOES(GLint size, GLenum type, GLsizei stride, const void *pointer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLWeightPointerOES,
          "context = %d, size = %d, type = %s, stride = %d, pointer = 0x%016" PRIxPTR "",
          CID(context), size, GLenumToString(GLenumGroup::DefaultGroup, type), stride,
          (uintptr_t)pointer);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateWeightPointerOES(context, size, type, stride, pointer));
        if (isCallValid)
        {
            context->weightPointer(size, type, stride, pointer);
        }
        ANGLE_CAPTURE(WeightPointerOES, isCallValid, context, size, type, stride, pointer);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_OES_point_size_array
void GL_APIENTRY GL_PointSizePointerOES(GLenum type, GLsizei stride, const void *pointer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPointSizePointerOES,
          "context = %d, type = %s, stride = %d, pointer = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::DefaultGroup, type), stride, (uintptr_t)pointer);

    if (context)
    {
        VertexAttribType typePacked                           = PackParam<VertexAttribType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidatePointSizePointerOES(context, typePacked, stride, pointer));
        if (isCallValid)
        {
            context->pointSizePointer(typePacked, stride, pointer);
        }
        ANGLE_CAPTURE(PointSizePointerOES, isCallValid, context, typePacked, stride, pointer);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_OES_query_matrix
GLbitfield GL_APIENTRY GL_QueryMatrixxOES(GLfixed *mantissa, GLint *exponent)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLQueryMatrixxOES,
          "context = %d, mantissa = 0x%016" PRIxPTR ", exponent = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)mantissa, (uintptr_t)exponent);

    GLbitfield returnValue;
    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateQueryMatrixxOES(context, mantissa, exponent));
        if (isCallValid)
        {
            returnValue = context->queryMatrixx(mantissa, exponent);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLQueryMatrixxOES, GLbitfield>();
        }
        ANGLE_CAPTURE(QueryMatrixxOES, isCallValid, context, mantissa, exponent, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLQueryMatrixxOES, GLbitfield>();
    }
    return returnValue;
}

// GL_OES_sample_shading
void GL_APIENTRY GL_MinSampleShadingOES(GLfloat value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMinSampleShadingOES, "context = %d, value = %f", CID(context), value);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateMinSampleShadingOES(context, value));
        if (isCallValid)
        {
            context->minSampleShading(value);
        }
        ANGLE_CAPTURE(MinSampleShadingOES, isCallValid, context, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_OES_shader_io_blocks

// GL_OES_texture_3D
void GL_APIENTRY GL_CompressedTexImage3DOES(GLenum target,
                                            GLint level,
                                            GLenum internalformat,
                                            GLsizei width,
                                            GLsizei height,
                                            GLsizei depth,
                                            GLint border,
                                            GLsizei imageSize,
                                            const void *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCompressedTexImage3DOES,
          "context = %d, target = %s, level = %d, internalformat = %s, width = %d, height = %d, "
          "depth = %d, border = %d, imageSize = %d, data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height, depth, border,
          imageSize, (uintptr_t)data);

    if (context)
    {
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateCompressedTexImage3DOES(context, targetPacked, level, internalformat, width,
                                             height, depth, border, imageSize, data));
        if (isCallValid)
        {
            context->compressedTexImage3D(targetPacked, level, internalformat, width, height, depth,
                                          border, imageSize, data);
        }
        ANGLE_CAPTURE(CompressedTexImage3DOES, isCallValid, context, targetPacked, level,
                      internalformat, width, height, depth, border, imageSize, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_CompressedTexSubImage3DOES(GLenum target,
                                               GLint level,
                                               GLint xoffset,
                                               GLint yoffset,
                                               GLint zoffset,
                                               GLsizei width,
                                               GLsizei height,
                                               GLsizei depth,
                                               GLenum format,
                                               GLsizei imageSize,
                                               const void *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCompressedTexSubImage3DOES,
          "context = %d, target = %s, level = %d, xoffset = %d, yoffset = %d, zoffset = %d, width "
          "= %d, height = %d, depth = %d, format = %s, imageSize = %d, data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level, xoffset, yoffset,
          zoffset, width, height, depth, GLenumToString(GLenumGroup::PixelFormat, format),
          imageSize, (uintptr_t)data);

    if (context)
    {
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateCompressedTexSubImage3DOES(
                                context, targetPacked, level, xoffset, yoffset, zoffset, width,
                                height, depth, format, imageSize, data));
        if (isCallValid)
        {
            context->compressedTexSubImage3D(targetPacked, level, xoffset, yoffset, zoffset, width,
                                             height, depth, format, imageSize, data);
        }
        ANGLE_CAPTURE(CompressedTexSubImage3DOES, isCallValid, context, targetPacked, level,
                      xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_CopyTexSubImage3DOES(GLenum target,
                                         GLint level,
                                         GLint xoffset,
                                         GLint yoffset,
                                         GLint zoffset,
                                         GLint x,
                                         GLint y,
                                         GLsizei width,
                                         GLsizei height)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCopyTexSubImage3DOES,
          "context = %d, target = %s, level = %d, xoffset = %d, yoffset = %d, zoffset = %d, x = "
          "%d, y = %d, width = %d, height = %d",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target), level, xoffset, yoffset,
          zoffset, x, y, width, height);

    if (context)
    {
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateCopyTexSubImage3DOES(context, targetPacked, level, xoffset,
                                                         yoffset, zoffset, x, y, width, height));
        if (isCallValid)
        {
            context->copyTexSubImage3D(targetPacked, level, xoffset, yoffset, zoffset, x, y, width,
                                       height);
        }
        ANGLE_CAPTURE(CopyTexSubImage3DOES, isCallValid, context, targetPacked, level, xoffset,
                      yoffset, zoffset, x, y, width, height);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_FramebufferTexture3DOES(GLenum target,
                                            GLenum attachment,
                                            GLenum textarget,
                                            GLuint texture,
                                            GLint level,
                                            GLint zoffset)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFramebufferTexture3DOES,
          "context = %d, target = %s, attachment = %s, textarget = %s, texture = %u, level = %d, "
          "zoffset = %d",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment),
          GLenumToString(GLenumGroup::TextureTarget, textarget), texture, level, zoffset);

    if (context)
    {
        TextureTarget textargetPacked                         = PackParam<TextureTarget>(textarget);
        TextureID texturePacked                               = PackParam<TextureID>(texture);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateFramebufferTexture3DOES(context, target, attachment, textargetPacked,
                                             texturePacked, level, zoffset));
        if (isCallValid)
        {
            context->framebufferTexture3D(target, attachment, textargetPacked, texturePacked, level,
                                          zoffset);
        }
        ANGLE_CAPTURE(FramebufferTexture3DOES, isCallValid, context, target, attachment,
                      textargetPacked, texturePacked, level, zoffset);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexImage3DOES(GLenum target,
                                  GLint level,
                                  GLenum internalformat,
                                  GLsizei width,
                                  GLsizei height,
                                  GLsizei depth,
                                  GLint border,
                                  GLenum format,
                                  GLenum type,
                                  const void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexImage3DOES,
          "context = %d, target = %s, level = %d, internalformat = %s, width = %d, height = %d, "
          "depth = %d, border = %d, format = %s, type = %s, pixels = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height, depth, border,
          GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), (uintptr_t)pixels);

    if (context)
    {
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexImage3DOES(context, targetPacked, level, internalformat, width, height,
                                   depth, border, format, type, pixels));
        if (isCallValid)
        {
            context->texImage3D(targetPacked, level, internalformat, width, height, depth, border,
                                format, type, pixels);
        }
        ANGLE_CAPTURE(TexImage3DOES, isCallValid, context, targetPacked, level, internalformat,
                      width, height, depth, border, format, type, pixels);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexSubImage3DOES(GLenum target,
                                     GLint level,
                                     GLint xoffset,
                                     GLint yoffset,
                                     GLint zoffset,
                                     GLsizei width,
                                     GLsizei height,
                                     GLsizei depth,
                                     GLenum format,
                                     GLenum type,
                                     const void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexSubImage3DOES,
          "context = %d, target = %s, level = %d, xoffset = %d, yoffset = %d, zoffset = %d, width "
          "= %d, height = %d, depth = %d, format = %s, type = %s, pixels = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level, xoffset, yoffset,
          zoffset, width, height, depth, GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), (uintptr_t)pixels);

    if (context)
    {
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexSubImage3DOES(context, targetPacked, level, xoffset, yoffset, zoffset,
                                      width, height, depth, format, type, pixels));
        if (isCallValid)
        {
            context->texSubImage3D(targetPacked, level, xoffset, yoffset, zoffset, width, height,
                                   depth, format, type, pixels);
        }
        ANGLE_CAPTURE(TexSubImage3DOES, isCallValid, context, targetPacked, level, xoffset, yoffset,
                      zoffset, width, height, depth, format, type, pixels);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_OES_texture_border_clamp
void GL_APIENTRY GL_GetSamplerParameterIivOES(GLuint sampler, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetSamplerParameterIivOES,
          "context = %d, sampler = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname), (uintptr_t)params);

    if (context)
    {
        SamplerID samplerPacked                               = PackParam<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetSamplerParameterIivOES(context, samplerPacked, pname, params));
        if (isCallValid)
        {
            context->getSamplerParameterIiv(samplerPacked, pname, params);
        }
        ANGLE_CAPTURE(GetSamplerParameterIivOES, isCallValid, context, samplerPacked, pname,
                      params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetSamplerParameterIuivOES(GLuint sampler, GLenum pname, GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetSamplerParameterIuivOES,
          "context = %d, sampler = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname), (uintptr_t)params);

    if (context)
    {
        SamplerID samplerPacked                               = PackParam<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetSamplerParameterIuivOES(context, samplerPacked, pname, params));
        if (isCallValid)
        {
            context->getSamplerParameterIuiv(samplerPacked, pname, params);
        }
        ANGLE_CAPTURE(GetSamplerParameterIuivOES, isCallValid, context, samplerPacked, pname,
                      params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetTexParameterIivOES(GLenum target, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexParameterIivOES,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::GetTextureParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetTexParameterIivOES(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getTexParameterIiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetTexParameterIivOES, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetTexParameterIuivOES(GLenum target, GLenum pname, GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexParameterIuivOES,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::GetTextureParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetTexParameterIuivOES(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getTexParameterIuiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetTexParameterIuivOES, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_SamplerParameterIivOES(GLuint sampler, GLenum pname, const GLint *param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSamplerParameterIivOES,
          "context = %d, sampler = %u, pname = %s, param = 0x%016" PRIxPTR "", CID(context),
          sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname), (uintptr_t)param);

    if (context)
    {
        SamplerID samplerPacked                               = PackParam<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateSamplerParameterIivOES(context, samplerPacked, pname, param));
        if (isCallValid)
        {
            context->samplerParameterIiv(samplerPacked, pname, param);
        }
        ANGLE_CAPTURE(SamplerParameterIivOES, isCallValid, context, samplerPacked, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_SamplerParameterIuivOES(GLuint sampler, GLenum pname, const GLuint *param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSamplerParameterIuivOES,
          "context = %d, sampler = %u, pname = %s, param = 0x%016" PRIxPTR "", CID(context),
          sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname), (uintptr_t)param);

    if (context)
    {
        SamplerID samplerPacked                               = PackParam<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateSamplerParameterIuivOES(context, samplerPacked, pname, param));
        if (isCallValid)
        {
            context->samplerParameterIuiv(samplerPacked, pname, param);
        }
        ANGLE_CAPTURE(SamplerParameterIuivOES, isCallValid, context, samplerPacked, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexParameterIivOES(GLenum target, GLenum pname, const GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexParameterIivOES,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::TextureParameterName, pname), (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexParameterIivOES(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->texParameterIiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(TexParameterIivOES, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexParameterIuivOES(GLenum target, GLenum pname, const GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexParameterIuivOES,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::TextureParameterName, pname), (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexParameterIuivOES(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->texParameterIuiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(TexParameterIuivOES, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_OES_texture_buffer
void GL_APIENTRY GL_TexBufferOES(GLenum target, GLenum internalformat, GLuint buffer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexBufferOES, "context = %d, target = %s, internalformat = %s, buffer = %u",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::InternalFormat, internalformat), buffer);

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        BufferID bufferPacked                                 = PackParam<BufferID>(buffer);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexBufferOES(context, targetPacked, internalformat, bufferPacked));
        if (isCallValid)
        {
            context->texBuffer(targetPacked, internalformat, bufferPacked);
        }
        ANGLE_CAPTURE(TexBufferOES, isCallValid, context, targetPacked, internalformat,
                      bufferPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexBufferRangeOES(GLenum target,
                                      GLenum internalformat,
                                      GLuint buffer,
                                      GLintptr offset,
                                      GLsizeiptr size)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexBufferRangeOES,
          "context = %d, target = %s, internalformat = %s, buffer = %u, offset = %llu, size = %llu",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::InternalFormat, internalformat), buffer,
          static_cast<unsigned long long>(offset), static_cast<unsigned long long>(size));

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        BufferID bufferPacked                                 = PackParam<BufferID>(buffer);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexBufferRangeOES(context, targetPacked, internalformat,
                                                      bufferPacked, offset, size));
        if (isCallValid)
        {
            context->texBufferRange(targetPacked, internalformat, bufferPacked, offset, size);
        }
        ANGLE_CAPTURE(TexBufferRangeOES, isCallValid, context, targetPacked, internalformat,
                      bufferPacked, offset, size);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_OES_texture_cube_map
void GL_APIENTRY GL_GetTexGenfvOES(GLenum coord, GLenum pname, GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexGenfvOES,
          "context = %d, coord = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureCoordName, coord),
          GLenumToString(GLenumGroup::TextureGenParameter, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetTexGenfvOES(context, coord, pname, params));
        if (isCallValid)
        {
            context->getTexGenfv(coord, pname, params);
        }
        ANGLE_CAPTURE(GetTexGenfvOES, isCallValid, context, coord, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetTexGenivOES(GLenum coord, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexGenivOES,
          "context = %d, coord = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureCoordName, coord),
          GLenumToString(GLenumGroup::TextureGenParameter, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetTexGenivOES(context, coord, pname, params));
        if (isCallValid)
        {
            context->getTexGeniv(coord, pname, params);
        }
        ANGLE_CAPTURE(GetTexGenivOES, isCallValid, context, coord, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetTexGenxvOES(GLenum coord, GLenum pname, GLfixed *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexGenxvOES,
          "context = %d, coord = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureCoordName, coord),
          GLenumToString(GLenumGroup::TextureGenParameter, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetTexGenxvOES(context, coord, pname, params));
        if (isCallValid)
        {
            context->getTexGenxv(coord, pname, params);
        }
        ANGLE_CAPTURE(GetTexGenxvOES, isCallValid, context, coord, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexGenfOES(GLenum coord, GLenum pname, GLfloat param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexGenfOES, "context = %d, coord = %s, pname = %s, param = %f", CID(context),
          GLenumToString(GLenumGroup::TextureCoordName, coord),
          GLenumToString(GLenumGroup::TextureGenParameter, pname), param);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTexGenfOES(context, coord, pname, param));
        if (isCallValid)
        {
            context->texGenf(coord, pname, param);
        }
        ANGLE_CAPTURE(TexGenfOES, isCallValid, context, coord, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexGenfvOES(GLenum coord, GLenum pname, const GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexGenfvOES,
          "context = %d, coord = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureCoordName, coord),
          GLenumToString(GLenumGroup::TextureGenParameter, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTexGenfvOES(context, coord, pname, params));
        if (isCallValid)
        {
            context->texGenfv(coord, pname, params);
        }
        ANGLE_CAPTURE(TexGenfvOES, isCallValid, context, coord, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexGeniOES(GLenum coord, GLenum pname, GLint param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexGeniOES, "context = %d, coord = %s, pname = %s, param = %d", CID(context),
          GLenumToString(GLenumGroup::TextureCoordName, coord),
          GLenumToString(GLenumGroup::TextureGenParameter, pname), param);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTexGeniOES(context, coord, pname, param));
        if (isCallValid)
        {
            context->texGeni(coord, pname, param);
        }
        ANGLE_CAPTURE(TexGeniOES, isCallValid, context, coord, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexGenivOES(GLenum coord, GLenum pname, const GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexGenivOES,
          "context = %d, coord = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureCoordName, coord),
          GLenumToString(GLenumGroup::TextureGenParameter, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTexGenivOES(context, coord, pname, params));
        if (isCallValid)
        {
            context->texGeniv(coord, pname, params);
        }
        ANGLE_CAPTURE(TexGenivOES, isCallValid, context, coord, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexGenxOES(GLenum coord, GLenum pname, GLfixed param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexGenxOES, "context = %d, coord = %s, pname = %s, param = 0x%X", CID(context),
          GLenumToString(GLenumGroup::TextureCoordName, coord),
          GLenumToString(GLenumGroup::TextureGenParameter, pname), param);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTexGenxOES(context, coord, pname, param));
        if (isCallValid)
        {
            context->texGenx(coord, pname, param);
        }
        ANGLE_CAPTURE(TexGenxOES, isCallValid, context, coord, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexGenxvOES(GLenum coord, GLenum pname, const GLfixed *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexGenxvOES,
          "context = %d, coord = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureCoordName, coord),
          GLenumToString(GLenumGroup::TextureGenParameter, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateTexGenxvOES(context, coord, pname, params));
        if (isCallValid)
        {
            context->texGenxv(coord, pname, params);
        }
        ANGLE_CAPTURE(TexGenxvOES, isCallValid, context, coord, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_OES_texture_cube_map_array

// GL_OES_texture_half_float

// GL_OES_texture_stencil8

// GL_OES_texture_storage_multisample_2d_array
void GL_APIENTRY GL_TexStorage3DMultisampleOES(GLenum target,
                                               GLsizei samples,
                                               GLenum internalformat,
                                               GLsizei width,
                                               GLsizei height,
                                               GLsizei depth,
                                               GLboolean fixedsamplelocations)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexStorage3DMultisampleOES,
          "context = %d, target = %s, samples = %d, internalformat = %s, width = %d, height = %d, "
          "depth = %d, fixedsamplelocations = %s",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), samples,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height, depth,
          GLbooleanToString(fixedsamplelocations));

    if (context)
    {
        TextureType targetPacked                              = PackParam<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexStorage3DMultisampleOES(context, targetPacked, samples, internalformat,
                                                width, height, depth, fixedsamplelocations));
        if (isCallValid)
        {
            context->texStorage3DMultisample(targetPacked, samples, internalformat, width, height,
                                             depth, fixedsamplelocations);
        }
        ANGLE_CAPTURE(TexStorage3DMultisampleOES, isCallValid, context, targetPacked, samples,
                      internalformat, width, height, depth, fixedsamplelocations);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_OES_vertex_array_object
void GL_APIENTRY GL_BindVertexArrayOES(GLuint array)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBindVertexArrayOES, "context = %d, array = %u", CID(context), array);

    if (context)
    {
        VertexArrayID arrayPacked                             = PackParam<VertexArrayID>(array);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBindVertexArrayOES(context, arrayPacked));
        if (isCallValid)
        {
            context->bindVertexArray(arrayPacked);
        }
        ANGLE_CAPTURE(BindVertexArrayOES, isCallValid, context, arrayPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DeleteVertexArraysOES(GLsizei n, const GLuint *arrays)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDeleteVertexArraysOES, "context = %d, n = %d, arrays = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)arrays);

    if (context)
    {
        const VertexArrayID *arraysPacked = PackParam<const VertexArrayID *>(arrays);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDeleteVertexArraysOES(context, n, arraysPacked));
        if (isCallValid)
        {
            context->deleteVertexArrays(n, arraysPacked);
        }
        ANGLE_CAPTURE(DeleteVertexArraysOES, isCallValid, context, n, arraysPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GenVertexArraysOES(GLsizei n, GLuint *arrays)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGenVertexArraysOES, "context = %d, n = %d, arrays = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)arrays);

    if (context)
    {
        VertexArrayID *arraysPacked                           = PackParam<VertexArrayID *>(arrays);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenVertexArraysOES(context, n, arraysPacked));
        if (isCallValid)
        {
            context->genVertexArrays(n, arraysPacked);
        }
        ANGLE_CAPTURE(GenVertexArraysOES, isCallValid, context, n, arraysPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

GLboolean GL_APIENTRY GL_IsVertexArrayOES(GLuint array)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLIsVertexArrayOES, "context = %d, array = %u", CID(context), array);

    GLboolean returnValue;
    if (context)
    {
        VertexArrayID arrayPacked                             = PackParam<VertexArrayID>(array);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsVertexArrayOES(context, arrayPacked));
        if (isCallValid)
        {
            returnValue = context->isVertexArray(arrayPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsVertexArrayOES, GLboolean>();
        }
        ANGLE_CAPTURE(IsVertexArrayOES, isCallValid, context, arrayPacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsVertexArrayOES, GLboolean>();
    }
    return returnValue;
}

// GL_OVR_multiview
void GL_APIENTRY GL_FramebufferTextureMultiviewOVR(GLenum target,
                                                   GLenum attachment,
                                                   GLuint texture,
                                                   GLint level,
                                                   GLint baseViewIndex,
                                                   GLsizei numViews)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFramebufferTextureMultiviewOVR,
          "context = %d, target = %s, attachment = %s, texture = %u, level = %d, baseViewIndex = "
          "%d, numViews = %d",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment), texture, level,
          baseViewIndex, numViews);

    if (context)
    {
        TextureID texturePacked                               = PackParam<TextureID>(texture);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateFramebufferTextureMultiviewOVR(context, target, attachment, texturePacked,
                                                    level, baseViewIndex, numViews));
        if (isCallValid)
        {
            context->framebufferTextureMultiview(target, attachment, texturePacked, level,
                                                 baseViewIndex, numViews);
        }
        ANGLE_CAPTURE(FramebufferTextureMultiviewOVR, isCallValid, context, target, attachment,
                      texturePacked, level, baseViewIndex, numViews);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL_OVR_multiview2

// EGL_ANGLE_explicit_context
void GL_APIENTRY GL_ActiveShaderProgramContextANGLE(GLeglContext ctx,
                                                    GLuint pipeline,
                                                    GLuint program)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLActiveShaderProgram, "context = %d, pipeline = %u, program = %u", CID(context),
          pipeline, program);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ProgramPipelineID pipelinePacked = PackParam<ProgramPipelineID>(pipeline);
        ShaderProgramID programPacked    = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateActiveShaderProgram(context, pipelinePacked, programPacked));
        if (isCallValid)
        {
            context->activeShaderProgram(pipelinePacked, programPacked);
        }
        ANGLE_CAPTURE(ActiveShaderProgram, isCallValid, context, pipelinePacked, programPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_ActiveShaderProgramEXTContextANGLE(GLeglContext ctx,
                                                       GLuint pipeline,
                                                       GLuint program)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLActiveShaderProgramEXT, "context = %d, pipeline = %u, program = %u",
          CID(context), pipeline, program);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ProgramPipelineID pipelinePacked = PackParam<ProgramPipelineID>(pipeline);
        ShaderProgramID programPacked    = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateActiveShaderProgramEXT(context, pipelinePacked, programPacked));
        if (isCallValid)
        {
            context->activeShaderProgram(pipelinePacked, programPacked);
        }
        ANGLE_CAPTURE(ActiveShaderProgramEXT, isCallValid, context, pipelinePacked, programPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_ActiveTextureContextANGLE(GLeglContext ctx, GLenum texture)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLActiveTexture, "context = %d, texture = %s", CID(context),
          GLenumToString(GLenumGroup::TextureUnit, texture));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateActiveTexture(context, texture));
        if (isCallValid)
        {
            context->activeTexture(texture);
        }
        ANGLE_CAPTURE(ActiveTexture, isCallValid, context, texture);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_AlphaFuncContextANGLE(GLeglContext ctx, GLenum func, GLfloat ref)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLAlphaFunc, "context = %d, func = %s, ref = %f", CID(context),
          GLenumToString(GLenumGroup::AlphaFunction, func), ref);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        AlphaTestFunc funcPacked                              = PackParam<AlphaTestFunc>(func);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateAlphaFunc(context, funcPacked, ref));
        if (isCallValid)
        {
            context->alphaFunc(funcPacked, ref);
        }
        ANGLE_CAPTURE(AlphaFunc, isCallValid, context, funcPacked, ref);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_AlphaFuncxContextANGLE(GLeglContext ctx, GLenum func, GLfixed ref)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLAlphaFuncx, "context = %d, func = %s, ref = 0x%X", CID(context),
          GLenumToString(GLenumGroup::AlphaFunction, func), ref);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        AlphaTestFunc funcPacked                              = PackParam<AlphaTestFunc>(func);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateAlphaFuncx(context, funcPacked, ref));
        if (isCallValid)
        {
            context->alphaFuncx(funcPacked, ref);
        }
        ANGLE_CAPTURE(AlphaFuncx, isCallValid, context, funcPacked, ref);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_AttachShaderContextANGLE(GLeglContext ctx, GLuint program, GLuint shader)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLAttachShader, "context = %d, program = %u, shader = %u", CID(context), program,
          shader);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        ShaderProgramID shaderPacked                          = PackParam<ShaderProgramID>(shader);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateAttachShader(context, programPacked, shaderPacked));
        if (isCallValid)
        {
            context->attachShader(programPacked, shaderPacked);
        }
        ANGLE_CAPTURE(AttachShader, isCallValid, context, programPacked, shaderPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BeginQueryContextANGLE(GLeglContext ctx, GLenum target, GLuint id)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBeginQuery, "context = %d, target = %s, id = %u", CID(context),
          GLenumToString(GLenumGroup::QueryTarget, target), id);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        QueryType targetPacked                                = PackParam<QueryType>(target);
        QueryID idPacked                                      = PackParam<QueryID>(id);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBeginQuery(context, targetPacked, idPacked));
        if (isCallValid)
        {
            context->beginQuery(targetPacked, idPacked);
        }
        ANGLE_CAPTURE(BeginQuery, isCallValid, context, targetPacked, idPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BeginQueryEXTContextANGLE(GLeglContext ctx, GLenum target, GLuint id)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBeginQueryEXT, "context = %d, target = %s, id = %u", CID(context),
          GLenumToString(GLenumGroup::QueryTarget, target), id);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        QueryType targetPacked                                = PackParam<QueryType>(target);
        QueryID idPacked                                      = PackParam<QueryID>(id);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBeginQueryEXT(context, targetPacked, idPacked));
        if (isCallValid)
        {
            context->beginQuery(targetPacked, idPacked);
        }
        ANGLE_CAPTURE(BeginQueryEXT, isCallValid, context, targetPacked, idPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BeginTransformFeedbackContextANGLE(GLeglContext ctx, GLenum primitiveMode)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBeginTransformFeedback, "context = %d, primitiveMode = %s", CID(context),
          GLenumToString(GLenumGroup::PrimitiveType, primitiveMode));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode primitiveModePacked = PackParam<PrimitiveMode>(primitiveMode);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBeginTransformFeedback(context, primitiveModePacked));
        if (isCallValid)
        {
            context->beginTransformFeedback(primitiveModePacked);
        }
        ANGLE_CAPTURE(BeginTransformFeedback, isCallValid, context, primitiveModePacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BindAttribLocationContextANGLE(GLeglContext ctx,
                                                   GLuint program,
                                                   GLuint index,
                                                   const GLchar *name)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBindAttribLocation,
          "context = %d, program = %u, index = %u, name = 0x%016" PRIxPTR "", CID(context), program,
          index, (uintptr_t)name);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBindAttribLocation(context, programPacked, index, name));
        if (isCallValid)
        {
            context->bindAttribLocation(programPacked, index, name);
        }
        ANGLE_CAPTURE(BindAttribLocation, isCallValid, context, programPacked, index, name);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BindBufferContextANGLE(GLeglContext ctx, GLenum target, GLuint buffer)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBindBuffer, "context = %d, target = %s, buffer = %u", CID(context),
          GLenumToString(GLenumGroup::BufferTargetARB, target), buffer);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked                            = PackParam<BufferBinding>(target);
        BufferID bufferPacked                                 = PackParam<BufferID>(buffer);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBindBuffer(context, targetPacked, bufferPacked));
        if (isCallValid)
        {
            context->bindBuffer(targetPacked, bufferPacked);
        }
        ANGLE_CAPTURE(BindBuffer, isCallValid, context, targetPacked, bufferPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BindBufferBaseContextANGLE(GLeglContext ctx,
                                               GLenum target,
                                               GLuint index,
                                               GLuint buffer)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBindBufferBase, "context = %d, target = %s, index = %u, buffer = %u",
          CID(context), GLenumToString(GLenumGroup::BufferTargetARB, target), index, buffer);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked                            = PackParam<BufferBinding>(target);
        BufferID bufferPacked                                 = PackParam<BufferID>(buffer);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBindBufferBase(context, targetPacked, index, bufferPacked));
        if (isCallValid)
        {
            context->bindBufferBase(targetPacked, index, bufferPacked);
        }
        ANGLE_CAPTURE(BindBufferBase, isCallValid, context, targetPacked, index, bufferPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BindBufferRangeContextANGLE(GLeglContext ctx,
                                                GLenum target,
                                                GLuint index,
                                                GLuint buffer,
                                                GLintptr offset,
                                                GLsizeiptr size)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBindBufferRange,
          "context = %d, target = %s, index = %u, buffer = %u, offset = %llu, size = %llu",
          CID(context), GLenumToString(GLenumGroup::BufferTargetARB, target), index, buffer,
          static_cast<unsigned long long>(offset), static_cast<unsigned long long>(size));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked                            = PackParam<BufferBinding>(target);
        BufferID bufferPacked                                 = PackParam<BufferID>(buffer);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateBindBufferRange(context, targetPacked, index, bufferPacked, offset, size));
        if (isCallValid)
        {
            context->bindBufferRange(targetPacked, index, bufferPacked, offset, size);
        }
        ANGLE_CAPTURE(BindBufferRange, isCallValid, context, targetPacked, index, bufferPacked,
                      offset, size);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BindFragDataLocationEXTContextANGLE(GLeglContext ctx,
                                                        GLuint program,
                                                        GLuint color,
                                                        const GLchar *name)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBindFragDataLocationEXT,
          "context = %d, program = %u, color = %u, name = 0x%016" PRIxPTR "", CID(context), program,
          color, (uintptr_t)name);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBindFragDataLocationEXT(context, programPacked, color, name));
        if (isCallValid)
        {
            context->bindFragDataLocation(programPacked, color, name);
        }
        ANGLE_CAPTURE(BindFragDataLocationEXT, isCallValid, context, programPacked, color, name);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BindFragDataLocationIndexedEXTContextANGLE(GLeglContext ctx,
                                                               GLuint program,
                                                               GLuint colorNumber,
                                                               GLuint index,
                                                               const GLchar *name)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBindFragDataLocationIndexedEXT,
          "context = %d, program = %u, colorNumber = %u, index = %u, name = 0x%016" PRIxPTR "",
          CID(context), program, colorNumber, index, (uintptr_t)name);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBindFragDataLocationIndexedEXT(
                                              context, programPacked, colorNumber, index, name));
        if (isCallValid)
        {
            context->bindFragDataLocationIndexed(programPacked, colorNumber, index, name);
        }
        ANGLE_CAPTURE(BindFragDataLocationIndexedEXT, isCallValid, context, programPacked,
                      colorNumber, index, name);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BindFramebufferContextANGLE(GLeglContext ctx, GLenum target, GLuint framebuffer)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBindFramebuffer, "context = %d, target = %s, framebuffer = %u", CID(context),
          GLenumToString(GLenumGroup::FramebufferTarget, target), framebuffer);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        FramebufferID framebufferPacked = PackParam<FramebufferID>(framebuffer);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBindFramebuffer(context, target, framebufferPacked));
        if (isCallValid)
        {
            context->bindFramebuffer(target, framebufferPacked);
        }
        ANGLE_CAPTURE(BindFramebuffer, isCallValid, context, target, framebufferPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BindFramebufferOESContextANGLE(GLeglContext ctx,
                                                   GLenum target,
                                                   GLuint framebuffer)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBindFramebufferOES, "context = %d, target = %s, framebuffer = %u",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target), framebuffer);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        FramebufferID framebufferPacked = PackParam<FramebufferID>(framebuffer);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBindFramebufferOES(context, target, framebufferPacked));
        if (isCallValid)
        {
            context->bindFramebuffer(target, framebufferPacked);
        }
        ANGLE_CAPTURE(BindFramebufferOES, isCallValid, context, target, framebufferPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BindImageTextureContextANGLE(GLeglContext ctx,
                                                 GLuint unit,
                                                 GLuint texture,
                                                 GLint level,
                                                 GLboolean layered,
                                                 GLint layer,
                                                 GLenum access,
                                                 GLenum format)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBindImageTexture,
          "context = %d, unit = %u, texture = %u, level = %d, layered = %s, layer = %d, access = "
          "%s, format = %s",
          CID(context), unit, texture, level, GLbooleanToString(layered), layer,
          GLenumToString(GLenumGroup::BufferAccessARB, access),
          GLenumToString(GLenumGroup::InternalFormat, format));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TextureID texturePacked                               = PackParam<TextureID>(texture);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBindImageTexture(context, unit, texturePacked, level, layered,
                                                     layer, access, format));
        if (isCallValid)
        {
            context->bindImageTexture(unit, texturePacked, level, layered, layer, access, format);
        }
        ANGLE_CAPTURE(BindImageTexture, isCallValid, context, unit, texturePacked, level, layered,
                      layer, access, format);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BindProgramPipelineContextANGLE(GLeglContext ctx, GLuint pipeline)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBindProgramPipeline, "context = %d, pipeline = %u", CID(context), pipeline);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ProgramPipelineID pipelinePacked = PackParam<ProgramPipelineID>(pipeline);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBindProgramPipeline(context, pipelinePacked));
        if (isCallValid)
        {
            context->bindProgramPipeline(pipelinePacked);
        }
        ANGLE_CAPTURE(BindProgramPipeline, isCallValid, context, pipelinePacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BindProgramPipelineEXTContextANGLE(GLeglContext ctx, GLuint pipeline)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBindProgramPipelineEXT, "context = %d, pipeline = %u", CID(context), pipeline);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ProgramPipelineID pipelinePacked = PackParam<ProgramPipelineID>(pipeline);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBindProgramPipelineEXT(context, pipelinePacked));
        if (isCallValid)
        {
            context->bindProgramPipeline(pipelinePacked);
        }
        ANGLE_CAPTURE(BindProgramPipelineEXT, isCallValid, context, pipelinePacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BindRenderbufferContextANGLE(GLeglContext ctx,
                                                 GLenum target,
                                                 GLuint renderbuffer)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBindRenderbuffer, "context = %d, target = %s, renderbuffer = %u", CID(context),
          GLenumToString(GLenumGroup::RenderbufferTarget, target), renderbuffer);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        RenderbufferID renderbufferPacked = PackParam<RenderbufferID>(renderbuffer);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBindRenderbuffer(context, target, renderbufferPacked));
        if (isCallValid)
        {
            context->bindRenderbuffer(target, renderbufferPacked);
        }
        ANGLE_CAPTURE(BindRenderbuffer, isCallValid, context, target, renderbufferPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BindRenderbufferOESContextANGLE(GLeglContext ctx,
                                                    GLenum target,
                                                    GLuint renderbuffer)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBindRenderbufferOES, "context = %d, target = %s, renderbuffer = %u",
          CID(context), GLenumToString(GLenumGroup::RenderbufferTarget, target), renderbuffer);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        RenderbufferID renderbufferPacked = PackParam<RenderbufferID>(renderbuffer);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBindRenderbufferOES(context, target, renderbufferPacked));
        if (isCallValid)
        {
            context->bindRenderbuffer(target, renderbufferPacked);
        }
        ANGLE_CAPTURE(BindRenderbufferOES, isCallValid, context, target, renderbufferPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BindSamplerContextANGLE(GLeglContext ctx, GLuint unit, GLuint sampler)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBindSampler, "context = %d, unit = %u, sampler = %u", CID(context), unit,
          sampler);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        SamplerID samplerPacked                               = PackParam<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBindSampler(context, unit, samplerPacked));
        if (isCallValid)
        {
            context->bindSampler(unit, samplerPacked);
        }
        ANGLE_CAPTURE(BindSampler, isCallValid, context, unit, samplerPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BindTextureContextANGLE(GLeglContext ctx, GLenum target, GLuint texture)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBindTexture, "context = %d, target = %s, texture = %u", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target), texture);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                              = PackParam<TextureType>(target);
        TextureID texturePacked                               = PackParam<TextureID>(texture);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBindTexture(context, targetPacked, texturePacked));
        if (isCallValid)
        {
            context->bindTexture(targetPacked, texturePacked);
        }
        ANGLE_CAPTURE(BindTexture, isCallValid, context, targetPacked, texturePacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BindTransformFeedbackContextANGLE(GLeglContext ctx, GLenum target, GLuint id)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBindTransformFeedback, "context = %d, target = %s, id = %u", CID(context),
          GLenumToString(GLenumGroup::BindTransformFeedbackTarget, target), id);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TransformFeedbackID idPacked                          = PackParam<TransformFeedbackID>(id);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBindTransformFeedback(context, target, idPacked));
        if (isCallValid)
        {
            context->bindTransformFeedback(target, idPacked);
        }
        ANGLE_CAPTURE(BindTransformFeedback, isCallValid, context, target, idPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BindVertexArrayContextANGLE(GLeglContext ctx, GLuint array)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBindVertexArray, "context = %d, array = %u", CID(context), array);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        VertexArrayID arrayPacked                             = PackParam<VertexArrayID>(array);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBindVertexArray(context, arrayPacked));
        if (isCallValid)
        {
            context->bindVertexArray(arrayPacked);
        }
        ANGLE_CAPTURE(BindVertexArray, isCallValid, context, arrayPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BindVertexArrayOESContextANGLE(GLeglContext ctx, GLuint array)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBindVertexArrayOES, "context = %d, array = %u", CID(context), array);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        VertexArrayID arrayPacked                             = PackParam<VertexArrayID>(array);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBindVertexArrayOES(context, arrayPacked));
        if (isCallValid)
        {
            context->bindVertexArray(arrayPacked);
        }
        ANGLE_CAPTURE(BindVertexArrayOES, isCallValid, context, arrayPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BindVertexBufferContextANGLE(GLeglContext ctx,
                                                 GLuint bindingindex,
                                                 GLuint buffer,
                                                 GLintptr offset,
                                                 GLsizei stride)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBindVertexBuffer,
          "context = %d, bindingindex = %u, buffer = %u, offset = %llu, stride = %d", CID(context),
          bindingindex, buffer, static_cast<unsigned long long>(offset), stride);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        BufferID bufferPacked                                 = PackParam<BufferID>(buffer);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateBindVertexBuffer(context, bindingindex, bufferPacked, offset, stride));
        if (isCallValid)
        {
            context->bindVertexBuffer(bindingindex, bufferPacked, offset, stride);
        }
        ANGLE_CAPTURE(BindVertexBuffer, isCallValid, context, bindingindex, bufferPacked, offset,
                      stride);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BlendBarrierContextANGLE(GLeglContext ctx)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBlendBarrier, "context = %d", CID(context));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateBlendBarrier(context));
        if (isCallValid)
        {
            context->blendBarrier();
        }
        ANGLE_CAPTURE(BlendBarrier, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BlendBarrierKHRContextANGLE(GLeglContext ctx)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBlendBarrierKHR, "context = %d", CID(context));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateBlendBarrierKHR(context));
        if (isCallValid)
        {
            context->blendBarrier();
        }
        ANGLE_CAPTURE(BlendBarrierKHR, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY
GL_BlendColorContextANGLE(GLeglContext ctx, GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBlendColor, "context = %d, red = %f, green = %f, blue = %f, alpha = %f",
          CID(context), red, green, blue, alpha);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBlendColor(context, red, green, blue, alpha));
        if (isCallValid)
        {
            context->blendColor(red, green, blue, alpha);
        }
        ANGLE_CAPTURE(BlendColor, isCallValid, context, red, green, blue, alpha);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BlendEquationContextANGLE(GLeglContext ctx, GLenum mode)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBlendEquation, "context = %d, mode = %s", CID(context),
          GLenumToString(GLenumGroup::BlendEquationModeEXT, mode));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateBlendEquation(context, mode));
        if (isCallValid)
        {
            context->blendEquation(mode);
        }
        ANGLE_CAPTURE(BlendEquation, isCallValid, context, mode);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BlendEquationSeparateContextANGLE(GLeglContext ctx,
                                                      GLenum modeRGB,
                                                      GLenum modeAlpha)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBlendEquationSeparate, "context = %d, modeRGB = %s, modeAlpha = %s",
          CID(context), GLenumToString(GLenumGroup::BlendEquationModeEXT, modeRGB),
          GLenumToString(GLenumGroup::BlendEquationModeEXT, modeAlpha));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBlendEquationSeparate(context, modeRGB, modeAlpha));
        if (isCallValid)
        {
            context->blendEquationSeparate(modeRGB, modeAlpha);
        }
        ANGLE_CAPTURE(BlendEquationSeparate, isCallValid, context, modeRGB, modeAlpha);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BlendEquationSeparateiContextANGLE(GLeglContext ctx,
                                                       GLuint buf,
                                                       GLenum modeRGB,
                                                       GLenum modeAlpha)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBlendEquationSeparatei, "context = %d, buf = %u, modeRGB = %s, modeAlpha = %s",
          CID(context), buf, GLenumToString(GLenumGroup::BlendEquationModeEXT, modeRGB),
          GLenumToString(GLenumGroup::BlendEquationModeEXT, modeAlpha));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBlendEquationSeparatei(context, buf, modeRGB, modeAlpha));
        if (isCallValid)
        {
            context->blendEquationSeparatei(buf, modeRGB, modeAlpha);
        }
        ANGLE_CAPTURE(BlendEquationSeparatei, isCallValid, context, buf, modeRGB, modeAlpha);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BlendEquationSeparateiEXTContextANGLE(GLeglContext ctx,
                                                          GLuint buf,
                                                          GLenum modeRGB,
                                                          GLenum modeAlpha)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBlendEquationSeparateiEXT,
          "context = %d, buf = %u, modeRGB = %s, modeAlpha = %s", CID(context), buf,
          GLenumToString(GLenumGroup::BlendEquationModeEXT, modeRGB),
          GLenumToString(GLenumGroup::BlendEquationModeEXT, modeAlpha));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBlendEquationSeparateiEXT(context, buf, modeRGB, modeAlpha));
        if (isCallValid)
        {
            context->blendEquationSeparatei(buf, modeRGB, modeAlpha);
        }
        ANGLE_CAPTURE(BlendEquationSeparateiEXT, isCallValid, context, buf, modeRGB, modeAlpha);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BlendEquationSeparateiOESContextANGLE(GLeglContext ctx,
                                                          GLuint buf,
                                                          GLenum modeRGB,
                                                          GLenum modeAlpha)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBlendEquationSeparateiOES,
          "context = %d, buf = %u, modeRGB = %s, modeAlpha = %s", CID(context), buf,
          GLenumToString(GLenumGroup::BlendEquationModeEXT, modeRGB),
          GLenumToString(GLenumGroup::BlendEquationModeEXT, modeAlpha));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBlendEquationSeparateiOES(context, buf, modeRGB, modeAlpha));
        if (isCallValid)
        {
            context->blendEquationSeparatei(buf, modeRGB, modeAlpha);
        }
        ANGLE_CAPTURE(BlendEquationSeparateiOES, isCallValid, context, buf, modeRGB, modeAlpha);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BlendEquationiContextANGLE(GLeglContext ctx, GLuint buf, GLenum mode)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBlendEquationi, "context = %d, buf = %u, mode = %s", CID(context), buf,
          GLenumToString(GLenumGroup::BlendEquationModeEXT, mode));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBlendEquationi(context, buf, mode));
        if (isCallValid)
        {
            context->blendEquationi(buf, mode);
        }
        ANGLE_CAPTURE(BlendEquationi, isCallValid, context, buf, mode);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BlendEquationiEXTContextANGLE(GLeglContext ctx, GLuint buf, GLenum mode)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBlendEquationiEXT, "context = %d, buf = %u, mode = %s", CID(context), buf,
          GLenumToString(GLenumGroup::BlendEquationModeEXT, mode));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBlendEquationiEXT(context, buf, mode));
        if (isCallValid)
        {
            context->blendEquationi(buf, mode);
        }
        ANGLE_CAPTURE(BlendEquationiEXT, isCallValid, context, buf, mode);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BlendEquationiOESContextANGLE(GLeglContext ctx, GLuint buf, GLenum mode)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBlendEquationiOES, "context = %d, buf = %u, mode = %s", CID(context), buf,
          GLenumToString(GLenumGroup::BlendEquationModeEXT, mode));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBlendEquationiOES(context, buf, mode));
        if (isCallValid)
        {
            context->blendEquationi(buf, mode);
        }
        ANGLE_CAPTURE(BlendEquationiOES, isCallValid, context, buf, mode);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BlendFuncContextANGLE(GLeglContext ctx, GLenum sfactor, GLenum dfactor)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBlendFunc, "context = %d, sfactor = %s, dfactor = %s", CID(context),
          GLenumToString(GLenumGroup::BlendingFactor, sfactor),
          GLenumToString(GLenumGroup::BlendingFactor, dfactor));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBlendFunc(context, sfactor, dfactor));
        if (isCallValid)
        {
            context->blendFunc(sfactor, dfactor);
        }
        ANGLE_CAPTURE(BlendFunc, isCallValid, context, sfactor, dfactor);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BlendFuncSeparateContextANGLE(GLeglContext ctx,
                                                  GLenum sfactorRGB,
                                                  GLenum dfactorRGB,
                                                  GLenum sfactorAlpha,
                                                  GLenum dfactorAlpha)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBlendFuncSeparate,
          "context = %d, sfactorRGB = %s, dfactorRGB = %s, sfactorAlpha = %s, dfactorAlpha = %s",
          CID(context), GLenumToString(GLenumGroup::BlendingFactor, sfactorRGB),
          GLenumToString(GLenumGroup::BlendingFactor, dfactorRGB),
          GLenumToString(GLenumGroup::BlendingFactor, sfactorAlpha),
          GLenumToString(GLenumGroup::BlendingFactor, dfactorAlpha));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBlendFuncSeparate(context, sfactorRGB, dfactorRGB,
                                                                    sfactorAlpha, dfactorAlpha));
        if (isCallValid)
        {
            context->blendFuncSeparate(sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha);
        }
        ANGLE_CAPTURE(BlendFuncSeparate, isCallValid, context, sfactorRGB, dfactorRGB, sfactorAlpha,
                      dfactorAlpha);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BlendFuncSeparateiContextANGLE(GLeglContext ctx,
                                                   GLuint buf,
                                                   GLenum srcRGB,
                                                   GLenum dstRGB,
                                                   GLenum srcAlpha,
                                                   GLenum dstAlpha)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBlendFuncSeparatei,
          "context = %d, buf = %u, srcRGB = %s, dstRGB = %s, srcAlpha = %s, dstAlpha = %s",
          CID(context), buf, GLenumToString(GLenumGroup::BlendingFactor, srcRGB),
          GLenumToString(GLenumGroup::BlendingFactor, dstRGB),
          GLenumToString(GLenumGroup::BlendingFactor, srcAlpha),
          GLenumToString(GLenumGroup::BlendingFactor, dstAlpha));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateBlendFuncSeparatei(context, buf, srcRGB, dstRGB, srcAlpha, dstAlpha));
        if (isCallValid)
        {
            context->blendFuncSeparatei(buf, srcRGB, dstRGB, srcAlpha, dstAlpha);
        }
        ANGLE_CAPTURE(BlendFuncSeparatei, isCallValid, context, buf, srcRGB, dstRGB, srcAlpha,
                      dstAlpha);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BlendFuncSeparateiEXTContextANGLE(GLeglContext ctx,
                                                      GLuint buf,
                                                      GLenum srcRGB,
                                                      GLenum dstRGB,
                                                      GLenum srcAlpha,
                                                      GLenum dstAlpha)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBlendFuncSeparateiEXT,
          "context = %d, buf = %u, srcRGB = %s, dstRGB = %s, srcAlpha = %s, dstAlpha = %s",
          CID(context), buf, GLenumToString(GLenumGroup::BlendingFactor, srcRGB),
          GLenumToString(GLenumGroup::BlendingFactor, dstRGB),
          GLenumToString(GLenumGroup::BlendingFactor, srcAlpha),
          GLenumToString(GLenumGroup::BlendingFactor, dstAlpha));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateBlendFuncSeparateiEXT(context, buf, srcRGB, dstRGB, srcAlpha, dstAlpha));
        if (isCallValid)
        {
            context->blendFuncSeparatei(buf, srcRGB, dstRGB, srcAlpha, dstAlpha);
        }
        ANGLE_CAPTURE(BlendFuncSeparateiEXT, isCallValid, context, buf, srcRGB, dstRGB, srcAlpha,
                      dstAlpha);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BlendFuncSeparateiOESContextANGLE(GLeglContext ctx,
                                                      GLuint buf,
                                                      GLenum srcRGB,
                                                      GLenum dstRGB,
                                                      GLenum srcAlpha,
                                                      GLenum dstAlpha)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBlendFuncSeparateiOES,
          "context = %d, buf = %u, srcRGB = %s, dstRGB = %s, srcAlpha = %s, dstAlpha = %s",
          CID(context), buf, GLenumToString(GLenumGroup::BlendingFactor, srcRGB),
          GLenumToString(GLenumGroup::BlendingFactor, dstRGB),
          GLenumToString(GLenumGroup::BlendingFactor, srcAlpha),
          GLenumToString(GLenumGroup::BlendingFactor, dstAlpha));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateBlendFuncSeparateiOES(context, buf, srcRGB, dstRGB, srcAlpha, dstAlpha));
        if (isCallValid)
        {
            context->blendFuncSeparatei(buf, srcRGB, dstRGB, srcAlpha, dstAlpha);
        }
        ANGLE_CAPTURE(BlendFuncSeparateiOES, isCallValid, context, buf, srcRGB, dstRGB, srcAlpha,
                      dstAlpha);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BlendFunciContextANGLE(GLeglContext ctx, GLuint buf, GLenum src, GLenum dst)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBlendFunci, "context = %d, buf = %u, src = %s, dst = %s", CID(context), buf,
          GLenumToString(GLenumGroup::BlendingFactor, src),
          GLenumToString(GLenumGroup::BlendingFactor, dst));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBlendFunci(context, buf, src, dst));
        if (isCallValid)
        {
            context->blendFunci(buf, src, dst);
        }
        ANGLE_CAPTURE(BlendFunci, isCallValid, context, buf, src, dst);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BlendFunciEXTContextANGLE(GLeglContext ctx, GLuint buf, GLenum src, GLenum dst)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBlendFunciEXT, "context = %d, buf = %u, src = %s, dst = %s", CID(context), buf,
          GLenumToString(GLenumGroup::BlendingFactor, src),
          GLenumToString(GLenumGroup::BlendingFactor, dst));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBlendFunciEXT(context, buf, src, dst));
        if (isCallValid)
        {
            context->blendFunci(buf, src, dst);
        }
        ANGLE_CAPTURE(BlendFunciEXT, isCallValid, context, buf, src, dst);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BlendFunciOESContextANGLE(GLeglContext ctx, GLuint buf, GLenum src, GLenum dst)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBlendFunciOES, "context = %d, buf = %u, src = %s, dst = %s", CID(context), buf,
          GLenumToString(GLenumGroup::BlendingFactor, src),
          GLenumToString(GLenumGroup::BlendingFactor, dst));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBlendFunciOES(context, buf, src, dst));
        if (isCallValid)
        {
            context->blendFunci(buf, src, dst);
        }
        ANGLE_CAPTURE(BlendFunciOES, isCallValid, context, buf, src, dst);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BlitFramebufferContextANGLE(GLeglContext ctx,
                                                GLint srcX0,
                                                GLint srcY0,
                                                GLint srcX1,
                                                GLint srcY1,
                                                GLint dstX0,
                                                GLint dstY0,
                                                GLint dstX1,
                                                GLint dstY1,
                                                GLbitfield mask,
                                                GLenum filter)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBlitFramebuffer,
          "context = %d, srcX0 = %d, srcY0 = %d, srcX1 = %d, srcY1 = %d, dstX0 = %d, dstY0 = %d, "
          "dstX1 = %d, dstY1 = %d, mask = %s, filter = %s",
          CID(context), srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1,
          GLbitfieldToString(GLenumGroup::ClearBufferMask, mask).c_str(),
          GLenumToString(GLenumGroup::BlitFramebufferFilter, filter));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBlitFramebuffer(context, srcX0, srcY0, srcX1, srcY1, dstX0,
                                                    dstY0, dstX1, dstY1, mask, filter));
        if (isCallValid)
        {
            context->blitFramebuffer(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask,
                                     filter);
        }
        ANGLE_CAPTURE(BlitFramebuffer, isCallValid, context, srcX0, srcY0, srcX1, srcY1, dstX0,
                      dstY0, dstX1, dstY1, mask, filter);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BlitFramebufferANGLEContextANGLE(GLeglContext ctx,
                                                     GLint srcX0,
                                                     GLint srcY0,
                                                     GLint srcX1,
                                                     GLint srcY1,
                                                     GLint dstX0,
                                                     GLint dstY0,
                                                     GLint dstX1,
                                                     GLint dstY1,
                                                     GLbitfield mask,
                                                     GLenum filter)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBlitFramebufferANGLE,
          "context = %d, srcX0 = %d, srcY0 = %d, srcX1 = %d, srcY1 = %d, dstX0 = %d, dstY0 = %d, "
          "dstX1 = %d, dstY1 = %d, mask = %s, filter = %s",
          CID(context), srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1,
          GLbitfieldToString(GLenumGroup::ClearBufferMask, mask).c_str(),
          GLenumToString(GLenumGroup::BlitFramebufferFilter, filter));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBlitFramebufferANGLE(context, srcX0, srcY0, srcX1, srcY1, dstX0,
                                                         dstY0, dstX1, dstY1, mask, filter));
        if (isCallValid)
        {
            context->blitFramebuffer(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask,
                                     filter);
        }
        ANGLE_CAPTURE(BlitFramebufferANGLE, isCallValid, context, srcX0, srcY0, srcX1, srcY1, dstX0,
                      dstY0, dstX1, dstY1, mask, filter);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BlitFramebufferNVContextANGLE(GLeglContext ctx,
                                                  GLint srcX0,
                                                  GLint srcY0,
                                                  GLint srcX1,
                                                  GLint srcY1,
                                                  GLint dstX0,
                                                  GLint dstY0,
                                                  GLint dstX1,
                                                  GLint dstY1,
                                                  GLbitfield mask,
                                                  GLenum filter)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBlitFramebufferNV,
          "context = %d, srcX0 = %d, srcY0 = %d, srcX1 = %d, srcY1 = %d, dstX0 = %d, dstY0 = %d, "
          "dstX1 = %d, dstY1 = %d, mask = %s, filter = %s",
          CID(context), srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1,
          GLbitfieldToString(GLenumGroup::ClearBufferMask, mask).c_str(),
          GLenumToString(GLenumGroup::BlitFramebufferFilter, filter));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBlitFramebufferNV(context, srcX0, srcY0, srcX1, srcY1, dstX0,
                                                      dstY0, dstX1, dstY1, mask, filter));
        if (isCallValid)
        {
            context->blitFramebufferNV(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask,
                                       filter);
        }
        ANGLE_CAPTURE(BlitFramebufferNV, isCallValid, context, srcX0, srcY0, srcX1, srcY1, dstX0,
                      dstY0, dstX1, dstY1, mask, filter);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BufferDataContextANGLE(GLeglContext ctx,
                                           GLenum target,
                                           GLsizeiptr size,
                                           const void *data,
                                           GLenum usage)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBufferData,
          "context = %d, target = %s, size = %llu, data = 0x%016" PRIxPTR ", usage = %s",
          CID(context), GLenumToString(GLenumGroup::BufferTargetARB, target),
          static_cast<unsigned long long>(size), (uintptr_t)data,
          GLenumToString(GLenumGroup::BufferUsageARB, usage));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked                            = PackParam<BufferBinding>(target);
        BufferUsage usagePacked                               = PackParam<BufferUsage>(usage);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBufferData(context, targetPacked, size, data, usagePacked));
        if (isCallValid)
        {
            context->bufferData(targetPacked, size, data, usagePacked);
        }
        ANGLE_CAPTURE(BufferData, isCallValid, context, targetPacked, size, data, usagePacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BufferStorageEXTContextANGLE(GLeglContext ctx,
                                                 GLenum target,
                                                 GLsizeiptr size,
                                                 const void *data,
                                                 GLbitfield flags)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBufferStorageEXT,
          "context = %d, target = %s, size = %llu, data = 0x%016" PRIxPTR ", flags = %s",
          CID(context), GLenumToString(GLenumGroup::BufferStorageTarget, target),
          static_cast<unsigned long long>(size), (uintptr_t)data,
          GLbitfieldToString(GLenumGroup::MapBufferUsageMask, flags).c_str());

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked                            = PackParam<BufferBinding>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBufferStorageEXT(context, targetPacked, size, data, flags));
        if (isCallValid)
        {
            context->bufferStorage(targetPacked, size, data, flags);
        }
        ANGLE_CAPTURE(BufferStorageEXT, isCallValid, context, targetPacked, size, data, flags);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BufferStorageExternalEXTContextANGLE(GLeglContext ctx,
                                                         GLenum target,
                                                         GLintptr offset,
                                                         GLsizeiptr size,
                                                         GLeglClientBufferEXT clientBuffer,
                                                         GLbitfield flags)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBufferStorageExternalEXT,
          "context = %d, target = %s, offset = %llu, size = %llu, clientBuffer = 0x%016" PRIxPTR
          ", flags = %s",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target),
          static_cast<unsigned long long>(offset), static_cast<unsigned long long>(size),
          (uintptr_t)clientBuffer,
          GLbitfieldToString(GLenumGroup::MapBufferUsageMask, flags).c_str());

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked                            = PackParam<BufferBinding>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBufferStorageExternalEXT(context, targetPacked, offset, size,
                                                             clientBuffer, flags));
        if (isCallValid)
        {
            context->bufferStorageExternal(targetPacked, offset, size, clientBuffer, flags);
        }
        ANGLE_CAPTURE(BufferStorageExternalEXT, isCallValid, context, targetPacked, offset, size,
                      clientBuffer, flags);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BufferStorageMemEXTContextANGLE(GLeglContext ctx,
                                                    GLenum target,
                                                    GLsizeiptr size,
                                                    GLuint memory,
                                                    GLuint64 offset)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBufferStorageMemEXT,
          "context = %d, target = %s, size = %llu, memory = %u, offset = %llu", CID(context),
          GLenumToString(GLenumGroup::BufferTargetARB, target),
          static_cast<unsigned long long>(size), memory, static_cast<unsigned long long>(offset));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                              = PackParam<TextureType>(target);
        MemoryObjectID memoryPacked                           = PackParam<MemoryObjectID>(memory);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateBufferStorageMemEXT(context, targetPacked, size, memoryPacked, offset));
        if (isCallValid)
        {
            context->bufferStorageMem(targetPacked, size, memoryPacked, offset);
        }
        ANGLE_CAPTURE(BufferStorageMemEXT, isCallValid, context, targetPacked, size, memoryPacked,
                      offset);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_BufferSubDataContextANGLE(GLeglContext ctx,
                                              GLenum target,
                                              GLintptr offset,
                                              GLsizeiptr size,
                                              const void *data)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLBufferSubData,
          "context = %d, target = %s, offset = %llu, size = %llu, data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::BufferTargetARB, target),
          static_cast<unsigned long long>(offset), static_cast<unsigned long long>(size),
          (uintptr_t)data);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked                            = PackParam<BufferBinding>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBufferSubData(context, targetPacked, offset, size, data));
        if (isCallValid)
        {
            context->bufferSubData(targetPacked, offset, size, data);
        }
        ANGLE_CAPTURE(BufferSubData, isCallValid, context, targetPacked, offset, size, data);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

GLenum GL_APIENTRY GL_CheckFramebufferStatusContextANGLE(GLeglContext ctx, GLenum target)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLCheckFramebufferStatus, "context = %d, target = %s", CID(context),
          GLenumToString(GLenumGroup::FramebufferTarget, target));

    GLenum returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateCheckFramebufferStatus(context, target));
        if (isCallValid)
        {
            returnValue = context->checkFramebufferStatus(target);
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLCheckFramebufferStatus, GLenum>();
        }
        ANGLE_CAPTURE(CheckFramebufferStatus, isCallValid, context, target, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLCheckFramebufferStatus, GLenum>();
    }
    return returnValue;
}

GLenum GL_APIENTRY GL_CheckFramebufferStatusOESContextANGLE(GLeglContext ctx, GLenum target)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLCheckFramebufferStatusOES, "context = %d, target = %s", CID(context),
          GLenumToString(GLenumGroup::FramebufferTarget, target));

    GLenum returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateCheckFramebufferStatusOES(context, target));
        if (isCallValid)
        {
            returnValue = context->checkFramebufferStatus(target);
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLCheckFramebufferStatusOES, GLenum>();
        }
        ANGLE_CAPTURE(CheckFramebufferStatusOES, isCallValid, context, target, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue =
            GetDefaultReturnValue<angle::EntryPoint::GLCheckFramebufferStatusOES, GLenum>();
    }
    return returnValue;
}

void GL_APIENTRY GL_ClearContextANGLE(GLeglContext ctx, GLbitfield mask)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLClear, "context = %d, mask = %s", CID(context),
          GLbitfieldToString(GLenumGroup::ClearBufferMask, mask).c_str());

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateClear(context, mask));
        if (isCallValid)
        {
            context->clear(mask);
        }
        ANGLE_CAPTURE(Clear, isCallValid, context, mask);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_ClearBufferfiContextANGLE(GLeglContext ctx,
                                              GLenum buffer,
                                              GLint drawbuffer,
                                              GLfloat depth,
                                              GLint stencil)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLClearBufferfi,
          "context = %d, buffer = %s, drawbuffer = %d, depth = %f, stencil = %d", CID(context),
          GLenumToString(GLenumGroup::Buffer, buffer), drawbuffer, depth, stencil);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateClearBufferfi(context, buffer, drawbuffer, depth, stencil));
        if (isCallValid)
        {
            context->clearBufferfi(buffer, drawbuffer, depth, stencil);
        }
        ANGLE_CAPTURE(ClearBufferfi, isCallValid, context, buffer, drawbuffer, depth, stencil);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_ClearBufferfvContextANGLE(GLeglContext ctx,
                                              GLenum buffer,
                                              GLint drawbuffer,
                                              const GLfloat *value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLClearBufferfv,
          "context = %d, buffer = %s, drawbuffer = %d, value = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::Buffer, buffer), drawbuffer, (uintptr_t)value);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateClearBufferfv(context, buffer, drawbuffer, value));
        if (isCallValid)
        {
            context->clearBufferfv(buffer, drawbuffer, value);
        }
        ANGLE_CAPTURE(ClearBufferfv, isCallValid, context, buffer, drawbuffer, value);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_ClearBufferivContextANGLE(GLeglContext ctx,
                                              GLenum buffer,
                                              GLint drawbuffer,
                                              const GLint *value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLClearBufferiv,
          "context = %d, buffer = %s, drawbuffer = %d, value = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::Buffer, buffer), drawbuffer, (uintptr_t)value);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateClearBufferiv(context, buffer, drawbuffer, value));
        if (isCallValid)
        {
            context->clearBufferiv(buffer, drawbuffer, value);
        }
        ANGLE_CAPTURE(ClearBufferiv, isCallValid, context, buffer, drawbuffer, value);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_ClearBufferuivContextANGLE(GLeglContext ctx,
                                               GLenum buffer,
                                               GLint drawbuffer,
                                               const GLuint *value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLClearBufferuiv,
          "context = %d, buffer = %s, drawbuffer = %d, value = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::Buffer, buffer), drawbuffer, (uintptr_t)value);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateClearBufferuiv(context, buffer, drawbuffer, value));
        if (isCallValid)
        {
            context->clearBufferuiv(buffer, drawbuffer, value);
        }
        ANGLE_CAPTURE(ClearBufferuiv, isCallValid, context, buffer, drawbuffer, value);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY
GL_ClearColorContextANGLE(GLeglContext ctx, GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLClearColor, "context = %d, red = %f, green = %f, blue = %f, alpha = %f",
          CID(context), red, green, blue, alpha);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateClearColor(context, red, green, blue, alpha));
        if (isCallValid)
        {
            context->clearColor(red, green, blue, alpha);
        }
        ANGLE_CAPTURE(ClearColor, isCallValid, context, red, green, blue, alpha);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_ClearColorxContextANGLE(GLeglContext ctx,
                                            GLfixed red,
                                            GLfixed green,
                                            GLfixed blue,
                                            GLfixed alpha)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLClearColorx,
          "context = %d, red = 0x%X, green = 0x%X, blue = 0x%X, alpha = 0x%X", CID(context), red,
          green, blue, alpha);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateClearColorx(context, red, green, blue, alpha));
        if (isCallValid)
        {
            context->clearColorx(red, green, blue, alpha);
        }
        ANGLE_CAPTURE(ClearColorx, isCallValid, context, red, green, blue, alpha);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_ClearDepthfContextANGLE(GLeglContext ctx, GLfloat d)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLClearDepthf, "context = %d, d = %f", CID(context), d);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateClearDepthf(context, d));
        if (isCallValid)
        {
            context->clearDepthf(d);
        }
        ANGLE_CAPTURE(ClearDepthf, isCallValid, context, d);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_ClearDepthxContextANGLE(GLeglContext ctx, GLfixed depth)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLClearDepthx, "context = %d, depth = 0x%X", CID(context), depth);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateClearDepthx(context, depth));
        if (isCallValid)
        {
            context->clearDepthx(depth);
        }
        ANGLE_CAPTURE(ClearDepthx, isCallValid, context, depth);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_ClearStencilContextANGLE(GLeglContext ctx, GLint s)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLClearStencil, "context = %d, s = %d", CID(context), s);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateClearStencil(context, s));
        if (isCallValid)
        {
            context->clearStencil(s);
        }
        ANGLE_CAPTURE(ClearStencil, isCallValid, context, s);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_ClientActiveTextureContextANGLE(GLeglContext ctx, GLenum texture)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLClientActiveTexture, "context = %d, texture = %s", CID(context),
          GLenumToString(GLenumGroup::TextureUnit, texture));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateClientActiveTexture(context, texture));
        if (isCallValid)
        {
            context->clientActiveTexture(texture);
        }
        ANGLE_CAPTURE(ClientActiveTexture, isCallValid, context, texture);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

GLenum GL_APIENTRY GL_ClientWaitSyncContextANGLE(GLeglContext ctx,
                                                 GLsync sync,
                                                 GLbitfield flags,
                                                 GLuint64 timeout)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLClientWaitSync,
          "context = %d, sync = 0x%016" PRIxPTR ", flags = %s, timeout = %llu", CID(context),
          (uintptr_t)sync, GLbitfieldToString(GLenumGroup::SyncObjectMask, flags).c_str(),
          static_cast<unsigned long long>(timeout));

    GLenum returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateClientWaitSync(context, sync, flags, timeout));
        if (isCallValid)
        {
            returnValue = context->clientWaitSync(sync, flags, timeout);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLClientWaitSync, GLenum>();
        }
        ANGLE_CAPTURE(ClientWaitSync, isCallValid, context, sync, flags, timeout, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLClientWaitSync, GLenum>();
    }
    return returnValue;
}

void GL_APIENTRY GL_ClipControlEXTContextANGLE(GLeglContext ctx, GLenum origin, GLenum depth)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLClipControlEXT, "context = %d, origin = %s, depth = %s", CID(context),
          GLenumToString(GLenumGroup::DefaultGroup, origin),
          GLenumToString(GLenumGroup::DefaultGroup, depth));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateClipControlEXT(context, origin, depth));
        if (isCallValid)
        {
            context->clipControl(origin, depth);
        }
        ANGLE_CAPTURE(ClipControlEXT, isCallValid, context, origin, depth);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_ClipPlanefContextANGLE(GLeglContext ctx, GLenum p, const GLfloat *eqn)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLClipPlanef, "context = %d, p = %s, eqn = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::ClipPlaneName, p), (uintptr_t)eqn);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateClipPlanef(context, p, eqn));
        if (isCallValid)
        {
            context->clipPlanef(p, eqn);
        }
        ANGLE_CAPTURE(ClipPlanef, isCallValid, context, p, eqn);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_ClipPlanexContextANGLE(GLeglContext ctx, GLenum plane, const GLfixed *equation)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLClipPlanex, "context = %d, plane = %s, equation = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::ClipPlaneName, plane), (uintptr_t)equation);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateClipPlanex(context, plane, equation));
        if (isCallValid)
        {
            context->clipPlanex(plane, equation);
        }
        ANGLE_CAPTURE(ClipPlanex, isCallValid, context, plane, equation);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY
GL_Color4fContextANGLE(GLeglContext ctx, GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLColor4f, "context = %d, red = %f, green = %f, blue = %f, alpha = %f",
          CID(context), red, green, blue, alpha);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateColor4f(context, red, green, blue, alpha));
        if (isCallValid)
        {
            context->color4f(red, green, blue, alpha);
        }
        ANGLE_CAPTURE(Color4f, isCallValid, context, red, green, blue, alpha);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY
GL_Color4ubContextANGLE(GLeglContext ctx, GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLColor4ub, "context = %d, red = %d, green = %d, blue = %d, alpha = %d",
          CID(context), red, green, blue, alpha);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateColor4ub(context, red, green, blue, alpha));
        if (isCallValid)
        {
            context->color4ub(red, green, blue, alpha);
        }
        ANGLE_CAPTURE(Color4ub, isCallValid, context, red, green, blue, alpha);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY
GL_Color4xContextANGLE(GLeglContext ctx, GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLColor4x, "context = %d, red = 0x%X, green = 0x%X, blue = 0x%X, alpha = 0x%X",
          CID(context), red, green, blue, alpha);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateColor4x(context, red, green, blue, alpha));
        if (isCallValid)
        {
            context->color4x(red, green, blue, alpha);
        }
        ANGLE_CAPTURE(Color4x, isCallValid, context, red, green, blue, alpha);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_ColorMaskContextANGLE(GLeglContext ctx,
                                          GLboolean red,
                                          GLboolean green,
                                          GLboolean blue,
                                          GLboolean alpha)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLColorMask, "context = %d, red = %s, green = %s, blue = %s, alpha = %s",
          CID(context), GLbooleanToString(red), GLbooleanToString(green), GLbooleanToString(blue),
          GLbooleanToString(alpha));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateColorMask(context, red, green, blue, alpha));
        if (isCallValid)
        {
            context->colorMask(red, green, blue, alpha);
        }
        ANGLE_CAPTURE(ColorMask, isCallValid, context, red, green, blue, alpha);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_ColorMaskiContextANGLE(GLeglContext ctx,
                                           GLuint index,
                                           GLboolean r,
                                           GLboolean g,
                                           GLboolean b,
                                           GLboolean a)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLColorMaski, "context = %d, index = %u, r = %s, g = %s, b = %s, a = %s",
          CID(context), index, GLbooleanToString(r), GLbooleanToString(g), GLbooleanToString(b),
          GLbooleanToString(a));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateColorMaski(context, index, r, g, b, a));
        if (isCallValid)
        {
            context->colorMaski(index, r, g, b, a);
        }
        ANGLE_CAPTURE(ColorMaski, isCallValid, context, index, r, g, b, a);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_ColorMaskiEXTContextANGLE(GLeglContext ctx,
                                              GLuint index,
                                              GLboolean r,
                                              GLboolean g,
                                              GLboolean b,
                                              GLboolean a)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLColorMaskiEXT, "context = %d, index = %u, r = %s, g = %s, b = %s, a = %s",
          CID(context), index, GLbooleanToString(r), GLbooleanToString(g), GLbooleanToString(b),
          GLbooleanToString(a));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateColorMaskiEXT(context, index, r, g, b, a));
        if (isCallValid)
        {
            context->colorMaski(index, r, g, b, a);
        }
        ANGLE_CAPTURE(ColorMaskiEXT, isCallValid, context, index, r, g, b, a);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_ColorMaskiOESContextANGLE(GLeglContext ctx,
                                              GLuint index,
                                              GLboolean r,
                                              GLboolean g,
                                              GLboolean b,
                                              GLboolean a)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLColorMaskiOES, "context = %d, index = %u, r = %s, g = %s, b = %s, a = %s",
          CID(context), index, GLbooleanToString(r), GLbooleanToString(g), GLbooleanToString(b),
          GLbooleanToString(a));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateColorMaskiOES(context, index, r, g, b, a));
        if (isCallValid)
        {
            context->colorMaski(index, r, g, b, a);
        }
        ANGLE_CAPTURE(ColorMaskiOES, isCallValid, context, index, r, g, b, a);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_ColorPointerContextANGLE(GLeglContext ctx,
                                             GLint size,
                                             GLenum type,
                                             GLsizei stride,
                                             const void *pointer)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLColorPointer,
          "context = %d, size = %d, type = %s, stride = %d, pointer = 0x%016" PRIxPTR "",
          CID(context), size, GLenumToString(GLenumGroup::ColorPointerType, type), stride,
          (uintptr_t)pointer);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        VertexAttribType typePacked                           = PackParam<VertexAttribType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateColorPointer(context, size, typePacked, stride, pointer));
        if (isCallValid)
        {
            context->colorPointer(size, typePacked, stride, pointer);
        }
        ANGLE_CAPTURE(ColorPointer, isCallValid, context, size, typePacked, stride, pointer);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_CompileShaderContextANGLE(GLeglContext ctx, GLuint shader)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLCompileShader, "context = %d, shader = %u", CID(context), shader);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID shaderPacked                          = PackParam<ShaderProgramID>(shader);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateCompileShader(context, shaderPacked));
        if (isCallValid)
        {
            context->compileShader(shaderPacked);
        }
        ANGLE_CAPTURE(CompileShader, isCallValid, context, shaderPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_CompressedTexImage2DContextANGLE(GLeglContext ctx,
                                                     GLenum target,
                                                     GLint level,
                                                     GLenum internalformat,
                                                     GLsizei width,
                                                     GLsizei height,
                                                     GLint border,
                                                     GLsizei imageSize,
                                                     const void *data)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLCompressedTexImage2D,
          "context = %d, target = %s, level = %d, internalformat = %s, width = %d, height = %d, "
          "border = %d, imageSize = %d, data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height, border,
          imageSize, (uintptr_t)data);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateCompressedTexImage2D(context, targetPacked, level, internalformat, width,
                                          height, border, imageSize, data));
        if (isCallValid)
        {
            context->compressedTexImage2D(targetPacked, level, internalformat, width, height,
                                          border, imageSize, data);
        }
        ANGLE_CAPTURE(CompressedTexImage2D, isCallValid, context, targetPacked, level,
                      internalformat, width, height, border, imageSize, data);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_CompressedTexImage3DContextANGLE(GLeglContext ctx,
                                                     GLenum target,
                                                     GLint level,
                                                     GLenum internalformat,
                                                     GLsizei width,
                                                     GLsizei height,
                                                     GLsizei depth,
                                                     GLint border,
                                                     GLsizei imageSize,
                                                     const void *data)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLCompressedTexImage3D,
          "context = %d, target = %s, level = %d, internalformat = %s, width = %d, height = %d, "
          "depth = %d, border = %d, imageSize = %d, data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height, depth, border,
          imageSize, (uintptr_t)data);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateCompressedTexImage3D(context, targetPacked, level, internalformat, width,
                                          height, depth, border, imageSize, data));
        if (isCallValid)
        {
            context->compressedTexImage3D(targetPacked, level, internalformat, width, height, depth,
                                          border, imageSize, data);
        }
        ANGLE_CAPTURE(CompressedTexImage3D, isCallValid, context, targetPacked, level,
                      internalformat, width, height, depth, border, imageSize, data);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_CompressedTexImage3DOESContextANGLE(GLeglContext ctx,
                                                        GLenum target,
                                                        GLint level,
                                                        GLenum internalformat,
                                                        GLsizei width,
                                                        GLsizei height,
                                                        GLsizei depth,
                                                        GLint border,
                                                        GLsizei imageSize,
                                                        const void *data)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLCompressedTexImage3DOES,
          "context = %d, target = %s, level = %d, internalformat = %s, width = %d, height = %d, "
          "depth = %d, border = %d, imageSize = %d, data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height, depth, border,
          imageSize, (uintptr_t)data);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateCompressedTexImage3DOES(context, targetPacked, level, internalformat, width,
                                             height, depth, border, imageSize, data));
        if (isCallValid)
        {
            context->compressedTexImage3D(targetPacked, level, internalformat, width, height, depth,
                                          border, imageSize, data);
        }
        ANGLE_CAPTURE(CompressedTexImage3DOES, isCallValid, context, targetPacked, level,
                      internalformat, width, height, depth, border, imageSize, data);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_CompressedTexSubImage2DContextANGLE(GLeglContext ctx,
                                                        GLenum target,
                                                        GLint level,
                                                        GLint xoffset,
                                                        GLint yoffset,
                                                        GLsizei width,
                                                        GLsizei height,
                                                        GLenum format,
                                                        GLsizei imageSize,
                                                        const void *data)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLCompressedTexSubImage2D,
          "context = %d, target = %s, level = %d, xoffset = %d, yoffset = %d, width = %d, height = "
          "%d, format = %s, imageSize = %d, data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level, xoffset, yoffset,
          width, height, GLenumToString(GLenumGroup::PixelFormat, format), imageSize,
          (uintptr_t)data);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateCompressedTexSubImage2D(context, targetPacked, level, xoffset, yoffset, width,
                                             height, format, imageSize, data));
        if (isCallValid)
        {
            context->compressedTexSubImage2D(targetPacked, level, xoffset, yoffset, width, height,
                                             format, imageSize, data);
        }
        ANGLE_CAPTURE(CompressedTexSubImage2D, isCallValid, context, targetPacked, level, xoffset,
                      yoffset, width, height, format, imageSize, data);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_CompressedTexSubImage3DContextANGLE(GLeglContext ctx,
                                                        GLenum target,
                                                        GLint level,
                                                        GLint xoffset,
                                                        GLint yoffset,
                                                        GLint zoffset,
                                                        GLsizei width,
                                                        GLsizei height,
                                                        GLsizei depth,
                                                        GLenum format,
                                                        GLsizei imageSize,
                                                        const void *data)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLCompressedTexSubImage3D,
          "context = %d, target = %s, level = %d, xoffset = %d, yoffset = %d, zoffset = %d, width "
          "= %d, height = %d, depth = %d, format = %s, imageSize = %d, data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level, xoffset, yoffset,
          zoffset, width, height, depth, GLenumToString(GLenumGroup::PixelFormat, format),
          imageSize, (uintptr_t)data);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateCompressedTexSubImage3D(context, targetPacked, level, xoffset,
                                                            yoffset, zoffset, width, height, depth,
                                                            format, imageSize, data));
        if (isCallValid)
        {
            context->compressedTexSubImage3D(targetPacked, level, xoffset, yoffset, zoffset, width,
                                             height, depth, format, imageSize, data);
        }
        ANGLE_CAPTURE(CompressedTexSubImage3D, isCallValid, context, targetPacked, level, xoffset,
                      yoffset, zoffset, width, height, depth, format, imageSize, data);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_CompressedTexSubImage3DOESContextANGLE(GLeglContext ctx,
                                                           GLenum target,
                                                           GLint level,
                                                           GLint xoffset,
                                                           GLint yoffset,
                                                           GLint zoffset,
                                                           GLsizei width,
                                                           GLsizei height,
                                                           GLsizei depth,
                                                           GLenum format,
                                                           GLsizei imageSize,
                                                           const void *data)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLCompressedTexSubImage3DOES,
          "context = %d, target = %s, level = %d, xoffset = %d, yoffset = %d, zoffset = %d, width "
          "= %d, height = %d, depth = %d, format = %s, imageSize = %d, data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level, xoffset, yoffset,
          zoffset, width, height, depth, GLenumToString(GLenumGroup::PixelFormat, format),
          imageSize, (uintptr_t)data);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateCompressedTexSubImage3DOES(
                                context, targetPacked, level, xoffset, yoffset, zoffset, width,
                                height, depth, format, imageSize, data));
        if (isCallValid)
        {
            context->compressedTexSubImage3D(targetPacked, level, xoffset, yoffset, zoffset, width,
                                             height, depth, format, imageSize, data);
        }
        ANGLE_CAPTURE(CompressedTexSubImage3DOES, isCallValid, context, targetPacked, level,
                      xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_CopyBufferSubDataContextANGLE(GLeglContext ctx,
                                                  GLenum readTarget,
                                                  GLenum writeTarget,
                                                  GLintptr readOffset,
                                                  GLintptr writeOffset,
                                                  GLsizeiptr size)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLCopyBufferSubData,
          "context = %d, readTarget = %s, writeTarget = %s, readOffset = %llu, writeOffset = %llu, "
          "size = %llu",
          CID(context), GLenumToString(GLenumGroup::CopyBufferSubDataTarget, readTarget),
          GLenumToString(GLenumGroup::CopyBufferSubDataTarget, writeTarget),
          static_cast<unsigned long long>(readOffset), static_cast<unsigned long long>(writeOffset),
          static_cast<unsigned long long>(size));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding readTargetPacked  = PackParam<BufferBinding>(readTarget);
        BufferBinding writeTargetPacked = PackParam<BufferBinding>(writeTarget);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateCopyBufferSubData(context, readTargetPacked, writeTargetPacked,
                                                      readOffset, writeOffset, size));
        if (isCallValid)
        {
            context->copyBufferSubData(readTargetPacked, writeTargetPacked, readOffset, writeOffset,
                                       size);
        }
        ANGLE_CAPTURE(CopyBufferSubData, isCallValid, context, readTargetPacked, writeTargetPacked,
                      readOffset, writeOffset, size);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_CopyImageSubDataContextANGLE(GLeglContext ctx,
                                                 GLuint srcName,
                                                 GLenum srcTarget,
                                                 GLint srcLevel,
                                                 GLint srcX,
                                                 GLint srcY,
                                                 GLint srcZ,
                                                 GLuint dstName,
                                                 GLenum dstTarget,
                                                 GLint dstLevel,
                                                 GLint dstX,
                                                 GLint dstY,
                                                 GLint dstZ,
                                                 GLsizei srcWidth,
                                                 GLsizei srcHeight,
                                                 GLsizei srcDepth)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLCopyImageSubData,
          "context = %d, srcName = %u, srcTarget = %s, srcLevel = %d, srcX = %d, srcY = %d, srcZ = "
          "%d, dstName = %u, dstTarget = %s, dstLevel = %d, dstX = %d, dstY = %d, dstZ = %d, "
          "srcWidth = %d, srcHeight = %d, srcDepth = %d",
          CID(context), srcName, GLenumToString(GLenumGroup::CopyBufferSubDataTarget, srcTarget),
          srcLevel, srcX, srcY, srcZ, dstName,
          GLenumToString(GLenumGroup::CopyBufferSubDataTarget, dstTarget), dstLevel, dstX, dstY,
          dstZ, srcWidth, srcHeight, srcDepth);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateCopyImageSubData(context, srcName, srcTarget, srcLevel, srcX,
                                                     srcY, srcZ, dstName, dstTarget, dstLevel, dstX,
                                                     dstY, dstZ, srcWidth, srcHeight, srcDepth));
        if (isCallValid)
        {
            context->copyImageSubData(srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName,
                                      dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth, srcHeight,
                                      srcDepth);
        }
        ANGLE_CAPTURE(CopyImageSubData, isCallValid, context, srcName, srcTarget, srcLevel, srcX,
                      srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth,
                      srcHeight, srcDepth);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_CopyImageSubDataEXTContextANGLE(GLeglContext ctx,
                                                    GLuint srcName,
                                                    GLenum srcTarget,
                                                    GLint srcLevel,
                                                    GLint srcX,
                                                    GLint srcY,
                                                    GLint srcZ,
                                                    GLuint dstName,
                                                    GLenum dstTarget,
                                                    GLint dstLevel,
                                                    GLint dstX,
                                                    GLint dstY,
                                                    GLint dstZ,
                                                    GLsizei srcWidth,
                                                    GLsizei srcHeight,
                                                    GLsizei srcDepth)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLCopyImageSubDataEXT,
          "context = %d, srcName = %u, srcTarget = %s, srcLevel = %d, srcX = %d, srcY = %d, srcZ = "
          "%d, dstName = %u, dstTarget = %s, dstLevel = %d, dstX = %d, dstY = %d, dstZ = %d, "
          "srcWidth = %d, srcHeight = %d, srcDepth = %d",
          CID(context), srcName, GLenumToString(GLenumGroup::CopyBufferSubDataTarget, srcTarget),
          srcLevel, srcX, srcY, srcZ, dstName,
          GLenumToString(GLenumGroup::CopyBufferSubDataTarget, dstTarget), dstLevel, dstX, dstY,
          dstZ, srcWidth, srcHeight, srcDepth);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateCopyImageSubDataEXT(context, srcName, srcTarget, srcLevel, srcX, srcY, srcZ,
                                         dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth,
                                         srcHeight, srcDepth));
        if (isCallValid)
        {
            context->copyImageSubData(srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName,
                                      dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth, srcHeight,
                                      srcDepth);
        }
        ANGLE_CAPTURE(CopyImageSubDataEXT, isCallValid, context, srcName, srcTarget, srcLevel, srcX,
                      srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth,
                      srcHeight, srcDepth);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_CopyImageSubDataOESContextANGLE(GLeglContext ctx,
                                                    GLuint srcName,
                                                    GLenum srcTarget,
                                                    GLint srcLevel,
                                                    GLint srcX,
                                                    GLint srcY,
                                                    GLint srcZ,
                                                    GLuint dstName,
                                                    GLenum dstTarget,
                                                    GLint dstLevel,
                                                    GLint dstX,
                                                    GLint dstY,
                                                    GLint dstZ,
                                                    GLsizei srcWidth,
                                                    GLsizei srcHeight,
                                                    GLsizei srcDepth)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLCopyImageSubDataOES,
          "context = %d, srcName = %u, srcTarget = %s, srcLevel = %d, srcX = %d, srcY = %d, srcZ = "
          "%d, dstName = %u, dstTarget = %s, dstLevel = %d, dstX = %d, dstY = %d, dstZ = %d, "
          "srcWidth = %d, srcHeight = %d, srcDepth = %d",
          CID(context), srcName, GLenumToString(GLenumGroup::CopyBufferSubDataTarget, srcTarget),
          srcLevel, srcX, srcY, srcZ, dstName,
          GLenumToString(GLenumGroup::CopyBufferSubDataTarget, dstTarget), dstLevel, dstX, dstY,
          dstZ, srcWidth, srcHeight, srcDepth);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateCopyImageSubDataOES(context, srcName, srcTarget, srcLevel, srcX, srcY, srcZ,
                                         dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth,
                                         srcHeight, srcDepth));
        if (isCallValid)
        {
            context->copyImageSubData(srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName,
                                      dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth, srcHeight,
                                      srcDepth);
        }
        ANGLE_CAPTURE(CopyImageSubDataOES, isCallValid, context, srcName, srcTarget, srcLevel, srcX,
                      srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth,
                      srcHeight, srcDepth);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_CopyTexImage2DContextANGLE(GLeglContext ctx,
                                               GLenum target,
                                               GLint level,
                                               GLenum internalformat,
                                               GLint x,
                                               GLint y,
                                               GLsizei width,
                                               GLsizei height,
                                               GLint border)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLCopyTexImage2D,
          "context = %d, target = %s, level = %d, internalformat = %s, x = %d, y = %d, width = %d, "
          "height = %d, border = %d",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), x, y, width, height, border);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateCopyTexImage2D(context, targetPacked, level, internalformat, x,
                                                   y, width, height, border));
        if (isCallValid)
        {
            context->copyTexImage2D(targetPacked, level, internalformat, x, y, width, height,
                                    border);
        }
        ANGLE_CAPTURE(CopyTexImage2D, isCallValid, context, targetPacked, level, internalformat, x,
                      y, width, height, border);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_CopyTexSubImage2DContextANGLE(GLeglContext ctx,
                                                  GLenum target,
                                                  GLint level,
                                                  GLint xoffset,
                                                  GLint yoffset,
                                                  GLint x,
                                                  GLint y,
                                                  GLsizei width,
                                                  GLsizei height)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLCopyTexSubImage2D,
          "context = %d, target = %s, level = %d, xoffset = %d, yoffset = %d, x = %d, y = %d, "
          "width = %d, height = %d",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level, xoffset, yoffset,
          x, y, width, height);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateCopyTexSubImage2D(context, targetPacked, level, xoffset,
                                                      yoffset, x, y, width, height));
        if (isCallValid)
        {
            context->copyTexSubImage2D(targetPacked, level, xoffset, yoffset, x, y, width, height);
        }
        ANGLE_CAPTURE(CopyTexSubImage2D, isCallValid, context, targetPacked, level, xoffset,
                      yoffset, x, y, width, height);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_CopyTexSubImage3DContextANGLE(GLeglContext ctx,
                                                  GLenum target,
                                                  GLint level,
                                                  GLint xoffset,
                                                  GLint yoffset,
                                                  GLint zoffset,
                                                  GLint x,
                                                  GLint y,
                                                  GLsizei width,
                                                  GLsizei height)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLCopyTexSubImage3D,
          "context = %d, target = %s, level = %d, xoffset = %d, yoffset = %d, zoffset = %d, x = "
          "%d, y = %d, width = %d, height = %d",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level, xoffset, yoffset,
          zoffset, x, y, width, height);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateCopyTexSubImage3D(context, targetPacked, level, xoffset,
                                                      yoffset, zoffset, x, y, width, height));
        if (isCallValid)
        {
            context->copyTexSubImage3D(targetPacked, level, xoffset, yoffset, zoffset, x, y, width,
                                       height);
        }
        ANGLE_CAPTURE(CopyTexSubImage3D, isCallValid, context, targetPacked, level, xoffset,
                      yoffset, zoffset, x, y, width, height);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_CopyTexSubImage3DOESContextANGLE(GLeglContext ctx,
                                                     GLenum target,
                                                     GLint level,
                                                     GLint xoffset,
                                                     GLint yoffset,
                                                     GLint zoffset,
                                                     GLint x,
                                                     GLint y,
                                                     GLsizei width,
                                                     GLsizei height)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLCopyTexSubImage3DOES,
          "context = %d, target = %s, level = %d, xoffset = %d, yoffset = %d, zoffset = %d, x = "
          "%d, y = %d, width = %d, height = %d",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target), level, xoffset, yoffset,
          zoffset, x, y, width, height);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateCopyTexSubImage3DOES(context, targetPacked, level, xoffset,
                                                         yoffset, zoffset, x, y, width, height));
        if (isCallValid)
        {
            context->copyTexSubImage3D(targetPacked, level, xoffset, yoffset, zoffset, x, y, width,
                                       height);
        }
        ANGLE_CAPTURE(CopyTexSubImage3DOES, isCallValid, context, targetPacked, level, xoffset,
                      yoffset, zoffset, x, y, width, height);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_CreateMemoryObjectsEXTContextANGLE(GLeglContext ctx,
                                                       GLsizei n,
                                                       GLuint *memoryObjects)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLCreateMemoryObjectsEXT,
          "context = %d, n = %d, memoryObjects = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)memoryObjects);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        MemoryObjectID *memoryObjectsPacked = PackParam<MemoryObjectID *>(memoryObjects);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateCreateMemoryObjectsEXT(context, n, memoryObjectsPacked));
        if (isCallValid)
        {
            context->createMemoryObjects(n, memoryObjectsPacked);
        }
        ANGLE_CAPTURE(CreateMemoryObjectsEXT, isCallValid, context, n, memoryObjectsPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

GLuint GL_APIENTRY GL_CreateProgramContextANGLE(GLeglContext ctx)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLCreateProgram, "context = %d", CID(context));

    GLuint returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateCreateProgram(context));
        if (isCallValid)
        {
            returnValue = context->createProgram();
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLCreateProgram, GLuint>();
        }
        ANGLE_CAPTURE(CreateProgram, isCallValid, context, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLCreateProgram, GLuint>();
    }
    return returnValue;
}

GLuint GL_APIENTRY GL_CreateShaderContextANGLE(GLeglContext ctx, GLenum type)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLCreateShader, "context = %d, type = %s", CID(context),
          GLenumToString(GLenumGroup::ShaderType, type));

    GLuint returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderType typePacked                                 = PackParam<ShaderType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateCreateShader(context, typePacked));
        if (isCallValid)
        {
            returnValue = context->createShader(typePacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLCreateShader, GLuint>();
        }
        ANGLE_CAPTURE(CreateShader, isCallValid, context, typePacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLCreateShader, GLuint>();
    }
    return returnValue;
}

GLuint GL_APIENTRY GL_CreateShaderProgramvContextANGLE(GLeglContext ctx,
                                                       GLenum type,
                                                       GLsizei count,
                                                       const GLchar *const *strings)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLCreateShaderProgramv,
          "context = %d, type = %s, count = %d, strings = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::ShaderType, type), count, (uintptr_t)strings);

    GLuint returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderType typePacked                                 = PackParam<ShaderType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateCreateShaderProgramv(context, typePacked, count, strings));
        if (isCallValid)
        {
            returnValue = context->createShaderProgramv(typePacked, count, strings);
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLCreateShaderProgramv, GLuint>();
        }
        ANGLE_CAPTURE(CreateShaderProgramv, isCallValid, context, typePacked, count, strings,
                      returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLCreateShaderProgramv, GLuint>();
    }
    return returnValue;
}

GLuint GL_APIENTRY GL_CreateShaderProgramvEXTContextANGLE(GLeglContext ctx,
                                                          GLenum type,
                                                          GLsizei count,
                                                          const GLchar **strings)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLCreateShaderProgramvEXT,
          "context = %d, type = %s, count = %d, strings = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::ShaderType, type), count, (uintptr_t)strings);

    GLuint returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderType typePacked                                 = PackParam<ShaderType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateCreateShaderProgramvEXT(context, typePacked, count, strings));
        if (isCallValid)
        {
            returnValue = context->createShaderProgramv(typePacked, count, strings);
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLCreateShaderProgramvEXT, GLuint>();
        }
        ANGLE_CAPTURE(CreateShaderProgramvEXT, isCallValid, context, typePacked, count, strings,
                      returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLCreateShaderProgramvEXT, GLuint>();
    }
    return returnValue;
}

void GL_APIENTRY GL_CullFaceContextANGLE(GLeglContext ctx, GLenum mode)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLCullFace, "context = %d, mode = %s", CID(context),
          GLenumToString(GLenumGroup::CullFaceMode, mode));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        CullFaceMode modePacked                               = PackParam<CullFaceMode>(mode);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateCullFace(context, modePacked));
        if (isCallValid)
        {
            context->cullFace(modePacked);
        }
        ANGLE_CAPTURE(CullFace, isCallValid, context, modePacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_CurrentPaletteMatrixOESContextANGLE(GLeglContext ctx, GLuint matrixpaletteindex)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLCurrentPaletteMatrixOES, "context = %d, matrixpaletteindex = %u", CID(context),
          matrixpaletteindex);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateCurrentPaletteMatrixOES(context, matrixpaletteindex));
        if (isCallValid)
        {
            context->currentPaletteMatrix(matrixpaletteindex);
        }
        ANGLE_CAPTURE(CurrentPaletteMatrixOES, isCallValid, context, matrixpaletteindex);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DebugMessageCallbackContextANGLE(GLeglContext ctx,
                                                     GLDEBUGPROC callback,
                                                     const void *userParam)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDebugMessageCallback,
          "context = %d, callback = 0x%016" PRIxPTR ", userParam = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)callback, (uintptr_t)userParam);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDebugMessageCallback(context, callback, userParam));
        if (isCallValid)
        {
            context->debugMessageCallback(callback, userParam);
        }
        ANGLE_CAPTURE(DebugMessageCallback, isCallValid, context, callback, userParam);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DebugMessageCallbackKHRContextANGLE(GLeglContext ctx,
                                                        GLDEBUGPROCKHR callback,
                                                        const void *userParam)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDebugMessageCallbackKHR,
          "context = %d, callback = 0x%016" PRIxPTR ", userParam = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)callback, (uintptr_t)userParam);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDebugMessageCallbackKHR(context, callback, userParam));
        if (isCallValid)
        {
            context->debugMessageCallback(callback, userParam);
        }
        ANGLE_CAPTURE(DebugMessageCallbackKHR, isCallValid, context, callback, userParam);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DebugMessageControlContextANGLE(GLeglContext ctx,
                                                    GLenum source,
                                                    GLenum type,
                                                    GLenum severity,
                                                    GLsizei count,
                                                    const GLuint *ids,
                                                    GLboolean enabled)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDebugMessageControl,
          "context = %d, source = %s, type = %s, severity = %s, count = %d, ids = 0x%016" PRIxPTR
          ", enabled = %s",
          CID(context), GLenumToString(GLenumGroup::DebugSource, source),
          GLenumToString(GLenumGroup::DebugType, type),
          GLenumToString(GLenumGroup::DebugSeverity, severity), count, (uintptr_t)ids,
          GLbooleanToString(enabled));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateDebugMessageControl(context, source, type, severity, count, ids, enabled));
        if (isCallValid)
        {
            context->debugMessageControl(source, type, severity, count, ids, enabled);
        }
        ANGLE_CAPTURE(DebugMessageControl, isCallValid, context, source, type, severity, count, ids,
                      enabled);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DebugMessageControlKHRContextANGLE(GLeglContext ctx,
                                                       GLenum source,
                                                       GLenum type,
                                                       GLenum severity,
                                                       GLsizei count,
                                                       const GLuint *ids,
                                                       GLboolean enabled)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDebugMessageControlKHR,
          "context = %d, source = %s, type = %s, severity = %s, count = %d, ids = 0x%016" PRIxPTR
          ", enabled = %s",
          CID(context), GLenumToString(GLenumGroup::DebugSource, source),
          GLenumToString(GLenumGroup::DebugType, type),
          GLenumToString(GLenumGroup::DebugSeverity, severity), count, (uintptr_t)ids,
          GLbooleanToString(enabled));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateDebugMessageControlKHR(context, source, type, severity, count, ids, enabled));
        if (isCallValid)
        {
            context->debugMessageControl(source, type, severity, count, ids, enabled);
        }
        ANGLE_CAPTURE(DebugMessageControlKHR, isCallValid, context, source, type, severity, count,
                      ids, enabled);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DebugMessageInsertContextANGLE(GLeglContext ctx,
                                                   GLenum source,
                                                   GLenum type,
                                                   GLuint id,
                                                   GLenum severity,
                                                   GLsizei length,
                                                   const GLchar *buf)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDebugMessageInsert,
          "context = %d, source = %s, type = %s, id = %u, severity = %s, length = %d, buf = "
          "0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DebugSource, source),
          GLenumToString(GLenumGroup::DebugType, type), id,
          GLenumToString(GLenumGroup::DebugSeverity, severity), length, (uintptr_t)buf);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateDebugMessageInsert(context, source, type, id, severity, length, buf));
        if (isCallValid)
        {
            context->debugMessageInsert(source, type, id, severity, length, buf);
        }
        ANGLE_CAPTURE(DebugMessageInsert, isCallValid, context, source, type, id, severity, length,
                      buf);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DebugMessageInsertKHRContextANGLE(GLeglContext ctx,
                                                      GLenum source,
                                                      GLenum type,
                                                      GLuint id,
                                                      GLenum severity,
                                                      GLsizei length,
                                                      const GLchar *buf)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDebugMessageInsertKHR,
          "context = %d, source = %s, type = %s, id = %u, severity = %s, length = %d, buf = "
          "0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DebugSource, source),
          GLenumToString(GLenumGroup::DebugType, type), id,
          GLenumToString(GLenumGroup::DebugSeverity, severity), length, (uintptr_t)buf);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateDebugMessageInsertKHR(context, source, type, id, severity, length, buf));
        if (isCallValid)
        {
            context->debugMessageInsert(source, type, id, severity, length, buf);
        }
        ANGLE_CAPTURE(DebugMessageInsertKHR, isCallValid, context, source, type, id, severity,
                      length, buf);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DeleteBuffersContextANGLE(GLeglContext ctx, GLsizei n, const GLuint *buffers)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDeleteBuffers, "context = %d, n = %d, buffers = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)buffers);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        const BufferID *buffersPacked = PackParam<const BufferID *>(buffers);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDeleteBuffers(context, n, buffersPacked));
        if (isCallValid)
        {
            context->deleteBuffers(n, buffersPacked);
        }
        ANGLE_CAPTURE(DeleteBuffers, isCallValid, context, n, buffersPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DeleteFencesNVContextANGLE(GLeglContext ctx, GLsizei n, const GLuint *fences)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDeleteFencesNV, "context = %d, n = %d, fences = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)fences);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        const FenceNVID *fencesPacked = PackParam<const FenceNVID *>(fences);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDeleteFencesNV(context, n, fencesPacked));
        if (isCallValid)
        {
            context->deleteFencesNV(n, fencesPacked);
        }
        ANGLE_CAPTURE(DeleteFencesNV, isCallValid, context, n, fencesPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DeleteFramebuffersContextANGLE(GLeglContext ctx,
                                                   GLsizei n,
                                                   const GLuint *framebuffers)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDeleteFramebuffers, "context = %d, n = %d, framebuffers = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)framebuffers);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        const FramebufferID *framebuffersPacked = PackParam<const FramebufferID *>(framebuffers);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDeleteFramebuffers(context, n, framebuffersPacked));
        if (isCallValid)
        {
            context->deleteFramebuffers(n, framebuffersPacked);
        }
        ANGLE_CAPTURE(DeleteFramebuffers, isCallValid, context, n, framebuffersPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DeleteFramebuffersOESContextANGLE(GLeglContext ctx,
                                                      GLsizei n,
                                                      const GLuint *framebuffers)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDeleteFramebuffersOES,
          "context = %d, n = %d, framebuffers = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)framebuffers);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        const FramebufferID *framebuffersPacked = PackParam<const FramebufferID *>(framebuffers);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDeleteFramebuffersOES(context, n, framebuffersPacked));
        if (isCallValid)
        {
            context->deleteFramebuffers(n, framebuffersPacked);
        }
        ANGLE_CAPTURE(DeleteFramebuffersOES, isCallValid, context, n, framebuffersPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DeleteMemoryObjectsEXTContextANGLE(GLeglContext ctx,
                                                       GLsizei n,
                                                       const GLuint *memoryObjects)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDeleteMemoryObjectsEXT,
          "context = %d, n = %d, memoryObjects = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)memoryObjects);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        const MemoryObjectID *memoryObjectsPacked =
            PackParam<const MemoryObjectID *>(memoryObjects);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDeleteMemoryObjectsEXT(context, n, memoryObjectsPacked));
        if (isCallValid)
        {
            context->deleteMemoryObjects(n, memoryObjectsPacked);
        }
        ANGLE_CAPTURE(DeleteMemoryObjectsEXT, isCallValid, context, n, memoryObjectsPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DeleteProgramContextANGLE(GLeglContext ctx, GLuint program)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDeleteProgram, "context = %d, program = %u", CID(context), program);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDeleteProgram(context, programPacked));
        if (isCallValid)
        {
            context->deleteProgram(programPacked);
        }
        ANGLE_CAPTURE(DeleteProgram, isCallValid, context, programPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DeleteProgramPipelinesContextANGLE(GLeglContext ctx,
                                                       GLsizei n,
                                                       const GLuint *pipelines)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDeleteProgramPipelines, "context = %d, n = %d, pipelines = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)pipelines);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        const ProgramPipelineID *pipelinesPacked = PackParam<const ProgramPipelineID *>(pipelines);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDeleteProgramPipelines(context, n, pipelinesPacked));
        if (isCallValid)
        {
            context->deleteProgramPipelines(n, pipelinesPacked);
        }
        ANGLE_CAPTURE(DeleteProgramPipelines, isCallValid, context, n, pipelinesPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DeleteProgramPipelinesEXTContextANGLE(GLeglContext ctx,
                                                          GLsizei n,
                                                          const GLuint *pipelines)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDeleteProgramPipelinesEXT,
          "context = %d, n = %d, pipelines = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)pipelines);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        const ProgramPipelineID *pipelinesPacked = PackParam<const ProgramPipelineID *>(pipelines);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDeleteProgramPipelinesEXT(context, n, pipelinesPacked));
        if (isCallValid)
        {
            context->deleteProgramPipelines(n, pipelinesPacked);
        }
        ANGLE_CAPTURE(DeleteProgramPipelinesEXT, isCallValid, context, n, pipelinesPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DeleteQueriesContextANGLE(GLeglContext ctx, GLsizei n, const GLuint *ids)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDeleteQueries, "context = %d, n = %d, ids = 0x%016" PRIxPTR "", CID(context),
          n, (uintptr_t)ids);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        const QueryID *idsPacked                              = PackParam<const QueryID *>(ids);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDeleteQueries(context, n, idsPacked));
        if (isCallValid)
        {
            context->deleteQueries(n, idsPacked);
        }
        ANGLE_CAPTURE(DeleteQueries, isCallValid, context, n, idsPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DeleteQueriesEXTContextANGLE(GLeglContext ctx, GLsizei n, const GLuint *ids)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDeleteQueriesEXT, "context = %d, n = %d, ids = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)ids);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        const QueryID *idsPacked                              = PackParam<const QueryID *>(ids);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDeleteQueriesEXT(context, n, idsPacked));
        if (isCallValid)
        {
            context->deleteQueries(n, idsPacked);
        }
        ANGLE_CAPTURE(DeleteQueriesEXT, isCallValid, context, n, idsPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DeleteRenderbuffersContextANGLE(GLeglContext ctx,
                                                    GLsizei n,
                                                    const GLuint *renderbuffers)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDeleteRenderbuffers, "context = %d, n = %d, renderbuffers = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)renderbuffers);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        const RenderbufferID *renderbuffersPacked =
            PackParam<const RenderbufferID *>(renderbuffers);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDeleteRenderbuffers(context, n, renderbuffersPacked));
        if (isCallValid)
        {
            context->deleteRenderbuffers(n, renderbuffersPacked);
        }
        ANGLE_CAPTURE(DeleteRenderbuffers, isCallValid, context, n, renderbuffersPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DeleteRenderbuffersOESContextANGLE(GLeglContext ctx,
                                                       GLsizei n,
                                                       const GLuint *renderbuffers)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDeleteRenderbuffersOES,
          "context = %d, n = %d, renderbuffers = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)renderbuffers);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        const RenderbufferID *renderbuffersPacked =
            PackParam<const RenderbufferID *>(renderbuffers);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDeleteRenderbuffersOES(context, n, renderbuffersPacked));
        if (isCallValid)
        {
            context->deleteRenderbuffers(n, renderbuffersPacked);
        }
        ANGLE_CAPTURE(DeleteRenderbuffersOES, isCallValid, context, n, renderbuffersPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DeleteSamplersContextANGLE(GLeglContext ctx,
                                               GLsizei count,
                                               const GLuint *samplers)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDeleteSamplers, "context = %d, count = %d, samplers = 0x%016" PRIxPTR "",
          CID(context), count, (uintptr_t)samplers);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        const SamplerID *samplersPacked = PackParam<const SamplerID *>(samplers);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDeleteSamplers(context, count, samplersPacked));
        if (isCallValid)
        {
            context->deleteSamplers(count, samplersPacked);
        }
        ANGLE_CAPTURE(DeleteSamplers, isCallValid, context, count, samplersPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DeleteSemaphoresEXTContextANGLE(GLeglContext ctx,
                                                    GLsizei n,
                                                    const GLuint *semaphores)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDeleteSemaphoresEXT, "context = %d, n = %d, semaphores = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)semaphores);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        const SemaphoreID *semaphoresPacked = PackParam<const SemaphoreID *>(semaphores);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDeleteSemaphoresEXT(context, n, semaphoresPacked));
        if (isCallValid)
        {
            context->deleteSemaphores(n, semaphoresPacked);
        }
        ANGLE_CAPTURE(DeleteSemaphoresEXT, isCallValid, context, n, semaphoresPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DeleteShaderContextANGLE(GLeglContext ctx, GLuint shader)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDeleteShader, "context = %d, shader = %u", CID(context), shader);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID shaderPacked                          = PackParam<ShaderProgramID>(shader);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDeleteShader(context, shaderPacked));
        if (isCallValid)
        {
            context->deleteShader(shaderPacked);
        }
        ANGLE_CAPTURE(DeleteShader, isCallValid, context, shaderPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DeleteSyncContextANGLE(GLeglContext ctx, GLsync sync)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDeleteSync, "context = %d, sync = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)sync);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDeleteSync(context, sync));
        if (isCallValid)
        {
            context->deleteSync(sync);
        }
        ANGLE_CAPTURE(DeleteSync, isCallValid, context, sync);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DeleteTexturesContextANGLE(GLeglContext ctx, GLsizei n, const GLuint *textures)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDeleteTextures, "context = %d, n = %d, textures = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)textures);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        const TextureID *texturesPacked = PackParam<const TextureID *>(textures);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDeleteTextures(context, n, texturesPacked));
        if (isCallValid)
        {
            context->deleteTextures(n, texturesPacked);
        }
        ANGLE_CAPTURE(DeleteTextures, isCallValid, context, n, texturesPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DeleteTransformFeedbacksContextANGLE(GLeglContext ctx,
                                                         GLsizei n,
                                                         const GLuint *ids)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDeleteTransformFeedbacks, "context = %d, n = %d, ids = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)ids);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        const TransformFeedbackID *idsPacked = PackParam<const TransformFeedbackID *>(ids);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDeleteTransformFeedbacks(context, n, idsPacked));
        if (isCallValid)
        {
            context->deleteTransformFeedbacks(n, idsPacked);
        }
        ANGLE_CAPTURE(DeleteTransformFeedbacks, isCallValid, context, n, idsPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DeleteVertexArraysContextANGLE(GLeglContext ctx,
                                                   GLsizei n,
                                                   const GLuint *arrays)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDeleteVertexArrays, "context = %d, n = %d, arrays = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)arrays);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        const VertexArrayID *arraysPacked = PackParam<const VertexArrayID *>(arrays);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDeleteVertexArrays(context, n, arraysPacked));
        if (isCallValid)
        {
            context->deleteVertexArrays(n, arraysPacked);
        }
        ANGLE_CAPTURE(DeleteVertexArrays, isCallValid, context, n, arraysPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DeleteVertexArraysOESContextANGLE(GLeglContext ctx,
                                                      GLsizei n,
                                                      const GLuint *arrays)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDeleteVertexArraysOES, "context = %d, n = %d, arrays = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)arrays);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        const VertexArrayID *arraysPacked = PackParam<const VertexArrayID *>(arrays);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDeleteVertexArraysOES(context, n, arraysPacked));
        if (isCallValid)
        {
            context->deleteVertexArrays(n, arraysPacked);
        }
        ANGLE_CAPTURE(DeleteVertexArraysOES, isCallValid, context, n, arraysPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DepthFuncContextANGLE(GLeglContext ctx, GLenum func)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDepthFunc, "context = %d, func = %s", CID(context),
          GLenumToString(GLenumGroup::DepthFunction, func));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDepthFunc(context, func));
        if (isCallValid)
        {
            context->depthFunc(func);
        }
        ANGLE_CAPTURE(DepthFunc, isCallValid, context, func);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DepthMaskContextANGLE(GLeglContext ctx, GLboolean flag)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDepthMask, "context = %d, flag = %s", CID(context), GLbooleanToString(flag));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDepthMask(context, flag));
        if (isCallValid)
        {
            context->depthMask(flag);
        }
        ANGLE_CAPTURE(DepthMask, isCallValid, context, flag);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DepthRangefContextANGLE(GLeglContext ctx, GLfloat n, GLfloat f)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDepthRangef, "context = %d, n = %f, f = %f", CID(context), n, f);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDepthRangef(context, n, f));
        if (isCallValid)
        {
            context->depthRangef(n, f);
        }
        ANGLE_CAPTURE(DepthRangef, isCallValid, context, n, f);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DepthRangexContextANGLE(GLeglContext ctx, GLfixed n, GLfixed f)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDepthRangex, "context = %d, n = 0x%X, f = 0x%X", CID(context), n, f);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDepthRangex(context, n, f));
        if (isCallValid)
        {
            context->depthRangex(n, f);
        }
        ANGLE_CAPTURE(DepthRangex, isCallValid, context, n, f);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DetachShaderContextANGLE(GLeglContext ctx, GLuint program, GLuint shader)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDetachShader, "context = %d, program = %u, shader = %u", CID(context), program,
          shader);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        ShaderProgramID shaderPacked                          = PackParam<ShaderProgramID>(shader);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDetachShader(context, programPacked, shaderPacked));
        if (isCallValid)
        {
            context->detachShader(programPacked, shaderPacked);
        }
        ANGLE_CAPTURE(DetachShader, isCallValid, context, programPacked, shaderPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DisableContextANGLE(GLeglContext ctx, GLenum cap)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDisable, "context = %d, cap = %s", CID(context),
          GLenumToString(GLenumGroup::EnableCap, cap));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDisable(context, cap));
        if (isCallValid)
        {
            context->disable(cap);
        }
        ANGLE_CAPTURE(Disable, isCallValid, context, cap);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DisableClientStateContextANGLE(GLeglContext ctx, GLenum array)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDisableClientState, "context = %d, array = %s", CID(context),
          GLenumToString(GLenumGroup::EnableCap, array));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ClientVertexArrayType arrayPacked = PackParam<ClientVertexArrayType>(array);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDisableClientState(context, arrayPacked));
        if (isCallValid)
        {
            context->disableClientState(arrayPacked);
        }
        ANGLE_CAPTURE(DisableClientState, isCallValid, context, arrayPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DisableVertexAttribArrayContextANGLE(GLeglContext ctx, GLuint index)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDisableVertexAttribArray, "context = %d, index = %u", CID(context), index);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDisableVertexAttribArray(context, index));
        if (isCallValid)
        {
            context->disableVertexAttribArray(index);
        }
        ANGLE_CAPTURE(DisableVertexAttribArray, isCallValid, context, index);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DisableiContextANGLE(GLeglContext ctx, GLenum target, GLuint index)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDisablei, "context = %d, target = %s, index = %u", CID(context),
          GLenumToString(GLenumGroup::EnableCap, target), index);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDisablei(context, target, index));
        if (isCallValid)
        {
            context->disablei(target, index);
        }
        ANGLE_CAPTURE(Disablei, isCallValid, context, target, index);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DisableiEXTContextANGLE(GLeglContext ctx, GLenum target, GLuint index)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDisableiEXT, "context = %d, target = %s, index = %u", CID(context),
          GLenumToString(GLenumGroup::EnableCap, target), index);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDisableiEXT(context, target, index));
        if (isCallValid)
        {
            context->disablei(target, index);
        }
        ANGLE_CAPTURE(DisableiEXT, isCallValid, context, target, index);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DisableiOESContextANGLE(GLeglContext ctx, GLenum target, GLuint index)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDisableiOES, "context = %d, target = %s, index = %u", CID(context),
          GLenumToString(GLenumGroup::EnableCap, target), index);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDisableiOES(context, target, index));
        if (isCallValid)
        {
            context->disablei(target, index);
        }
        ANGLE_CAPTURE(DisableiOES, isCallValid, context, target, index);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DiscardFramebufferEXTContextANGLE(GLeglContext ctx,
                                                      GLenum target,
                                                      GLsizei numAttachments,
                                                      const GLenum *attachments)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDiscardFramebufferEXT,
          "context = %d, target = %s, numAttachments = %d, attachments = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target), numAttachments,
          (uintptr_t)attachments);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateDiscardFramebufferEXT(context, target, numAttachments, attachments));
        if (isCallValid)
        {
            context->discardFramebuffer(target, numAttachments, attachments);
        }
        ANGLE_CAPTURE(DiscardFramebufferEXT, isCallValid, context, target, numAttachments,
                      attachments);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DispatchComputeContextANGLE(GLeglContext ctx,
                                                GLuint num_groups_x,
                                                GLuint num_groups_y,
                                                GLuint num_groups_z)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDispatchCompute,
          "context = %d, num_groups_x = %u, num_groups_y = %u, num_groups_z = %u", CID(context),
          num_groups_x, num_groups_y, num_groups_z);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateDispatchCompute(context, num_groups_x, num_groups_y, num_groups_z));
        if (isCallValid)
        {
            context->dispatchCompute(num_groups_x, num_groups_y, num_groups_z);
        }
        ANGLE_CAPTURE(DispatchCompute, isCallValid, context, num_groups_x, num_groups_y,
                      num_groups_z);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DispatchComputeIndirectContextANGLE(GLeglContext ctx, GLintptr indirect)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDispatchComputeIndirect, "context = %d, indirect = %llu", CID(context),
          static_cast<unsigned long long>(indirect));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDispatchComputeIndirect(context, indirect));
        if (isCallValid)
        {
            context->dispatchComputeIndirect(indirect);
        }
        ANGLE_CAPTURE(DispatchComputeIndirect, isCallValid, context, indirect);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DrawArraysContextANGLE(GLeglContext ctx,
                                           GLenum mode,
                                           GLint first,
                                           GLsizei count)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDrawArrays, "context = %d, mode = %s, first = %d, count = %d", CID(context),
          GLenumToString(GLenumGroup::PrimitiveType, mode), first, count);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDrawArrays(context, modePacked, first, count));
        if (isCallValid)
        {
            context->drawArrays(modePacked, first, count);
        }
        ANGLE_CAPTURE(DrawArrays, isCallValid, context, modePacked, first, count);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DrawArraysIndirectContextANGLE(GLeglContext ctx,
                                                   GLenum mode,
                                                   const void *indirect)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDrawArraysIndirect, "context = %d, mode = %s, indirect = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), (uintptr_t)indirect);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDrawArraysIndirect(context, modePacked, indirect));
        if (isCallValid)
        {
            context->drawArraysIndirect(modePacked, indirect);
        }
        ANGLE_CAPTURE(DrawArraysIndirect, isCallValid, context, modePacked, indirect);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DrawArraysInstancedContextANGLE(GLeglContext ctx,
                                                    GLenum mode,
                                                    GLint first,
                                                    GLsizei count,
                                                    GLsizei instancecount)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDrawArraysInstanced,
          "context = %d, mode = %s, first = %d, count = %d, instancecount = %d", CID(context),
          GLenumToString(GLenumGroup::PrimitiveType, mode), first, count, instancecount);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateDrawArraysInstanced(context, modePacked, first, count, instancecount));
        if (isCallValid)
        {
            context->drawArraysInstanced(modePacked, first, count, instancecount);
        }
        ANGLE_CAPTURE(DrawArraysInstanced, isCallValid, context, modePacked, first, count,
                      instancecount);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DrawArraysInstancedANGLEContextANGLE(GLeglContext ctx,
                                                         GLenum mode,
                                                         GLint first,
                                                         GLsizei count,
                                                         GLsizei primcount)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDrawArraysInstancedANGLE,
          "context = %d, mode = %s, first = %d, count = %d, primcount = %d", CID(context),
          GLenumToString(GLenumGroup::PrimitiveType, mode), first, count, primcount);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateDrawArraysInstancedANGLE(context, modePacked, first, count, primcount));
        if (isCallValid)
        {
            context->drawArraysInstanced(modePacked, first, count, primcount);
        }
        ANGLE_CAPTURE(DrawArraysInstancedANGLE, isCallValid, context, modePacked, first, count,
                      primcount);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DrawArraysInstancedEXTContextANGLE(GLeglContext ctx,
                                                       GLenum mode,
                                                       GLint start,
                                                       GLsizei count,
                                                       GLsizei primcount)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDrawArraysInstancedEXT,
          "context = %d, mode = %s, start = %d, count = %d, primcount = %d", CID(context),
          GLenumToString(GLenumGroup::PrimitiveType, mode), start, count, primcount);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateDrawArraysInstancedEXT(context, modePacked, start, count, primcount));
        if (isCallValid)
        {
            context->drawArraysInstanced(modePacked, start, count, primcount);
        }
        ANGLE_CAPTURE(DrawArraysInstancedEXT, isCallValid, context, modePacked, start, count,
                      primcount);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DrawBuffersContextANGLE(GLeglContext ctx, GLsizei n, const GLenum *bufs)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDrawBuffers, "context = %d, n = %d, bufs = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)bufs);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawBuffers(context, n, bufs));
        if (isCallValid)
        {
            context->drawBuffers(n, bufs);
        }
        ANGLE_CAPTURE(DrawBuffers, isCallValid, context, n, bufs);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DrawBuffersEXTContextANGLE(GLeglContext ctx, GLsizei n, const GLenum *bufs)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDrawBuffersEXT, "context = %d, n = %d, bufs = 0x%016" PRIxPTR "", CID(context),
          n, (uintptr_t)bufs);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawBuffersEXT(context, n, bufs));
        if (isCallValid)
        {
            context->drawBuffers(n, bufs);
        }
        ANGLE_CAPTURE(DrawBuffersEXT, isCallValid, context, n, bufs);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DrawElementsContextANGLE(GLeglContext ctx,
                                             GLenum mode,
                                             GLsizei count,
                                             GLenum type,
                                             const void *indices)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDrawElements,
          "context = %d, mode = %s, count = %d, type = %s, indices = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked                           = PackParam<DrawElementsType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDrawElements(context, modePacked, count, typePacked, indices));
        if (isCallValid)
        {
            context->drawElements(modePacked, count, typePacked, indices);
        }
        ANGLE_CAPTURE(DrawElements, isCallValid, context, modePacked, count, typePacked, indices);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DrawElementsBaseVertexContextANGLE(GLeglContext ctx,
                                                       GLenum mode,
                                                       GLsizei count,
                                                       GLenum type,
                                                       const void *indices,
                                                       GLint basevertex)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDrawElementsBaseVertex,
          "context = %d, mode = %s, count = %d, type = %s, indices = 0x%016" PRIxPTR
          ", basevertex = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, basevertex);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked                           = PackParam<DrawElementsType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDrawElementsBaseVertex(context, modePacked, count, typePacked,
                                                           indices, basevertex));
        if (isCallValid)
        {
            context->drawElementsBaseVertex(modePacked, count, typePacked, indices, basevertex);
        }
        ANGLE_CAPTURE(DrawElementsBaseVertex, isCallValid, context, modePacked, count, typePacked,
                      indices, basevertex);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DrawElementsBaseVertexEXTContextANGLE(GLeglContext ctx,
                                                          GLenum mode,
                                                          GLsizei count,
                                                          GLenum type,
                                                          const void *indices,
                                                          GLint basevertex)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDrawElementsBaseVertexEXT,
          "context = %d, mode = %s, count = %d, type = %s, indices = 0x%016" PRIxPTR
          ", basevertex = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, basevertex);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked                           = PackParam<DrawElementsType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDrawElementsBaseVertexEXT(context, modePacked, count,
                                                              typePacked, indices, basevertex));
        if (isCallValid)
        {
            context->drawElementsBaseVertex(modePacked, count, typePacked, indices, basevertex);
        }
        ANGLE_CAPTURE(DrawElementsBaseVertexEXT, isCallValid, context, modePacked, count,
                      typePacked, indices, basevertex);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DrawElementsBaseVertexOESContextANGLE(GLeglContext ctx,
                                                          GLenum mode,
                                                          GLsizei count,
                                                          GLenum type,
                                                          const void *indices,
                                                          GLint basevertex)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDrawElementsBaseVertexOES,
          "context = %d, mode = %s, count = %d, type = %s, indices = 0x%016" PRIxPTR
          ", basevertex = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, basevertex);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked                           = PackParam<DrawElementsType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDrawElementsBaseVertexOES(context, modePacked, count,
                                                              typePacked, indices, basevertex));
        if (isCallValid)
        {
            context->drawElementsBaseVertex(modePacked, count, typePacked, indices, basevertex);
        }
        ANGLE_CAPTURE(DrawElementsBaseVertexOES, isCallValid, context, modePacked, count,
                      typePacked, indices, basevertex);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DrawElementsIndirectContextANGLE(GLeglContext ctx,
                                                     GLenum mode,
                                                     GLenum type,
                                                     const void *indirect)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDrawElementsIndirect,
          "context = %d, mode = %s, type = %s, indirect = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::PrimitiveType, mode),
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indirect);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked                           = PackParam<DrawElementsType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateDrawElementsIndirect(context, modePacked, typePacked, indirect));
        if (isCallValid)
        {
            context->drawElementsIndirect(modePacked, typePacked, indirect);
        }
        ANGLE_CAPTURE(DrawElementsIndirect, isCallValid, context, modePacked, typePacked, indirect);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DrawElementsInstancedContextANGLE(GLeglContext ctx,
                                                      GLenum mode,
                                                      GLsizei count,
                                                      GLenum type,
                                                      const void *indices,
                                                      GLsizei instancecount)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDrawElementsInstanced,
          "context = %d, mode = %s, count = %d, type = %s, indices = 0x%016" PRIxPTR
          ", instancecount = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, instancecount);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked                           = PackParam<DrawElementsType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDrawElementsInstanced(context, modePacked, count, typePacked,
                                                          indices, instancecount));
        if (isCallValid)
        {
            context->drawElementsInstanced(modePacked, count, typePacked, indices, instancecount);
        }
        ANGLE_CAPTURE(DrawElementsInstanced, isCallValid, context, modePacked, count, typePacked,
                      indices, instancecount);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DrawElementsInstancedANGLEContextANGLE(GLeglContext ctx,
                                                           GLenum mode,
                                                           GLsizei count,
                                                           GLenum type,
                                                           const void *indices,
                                                           GLsizei primcount)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDrawElementsInstancedANGLE,
          "context = %d, mode = %s, count = %d, type = %s, indices = 0x%016" PRIxPTR
          ", primcount = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), count,
          GLenumToString(GLenumGroup::PrimitiveType, type), (uintptr_t)indices, primcount);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked                           = PackParam<DrawElementsType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDrawElementsInstancedANGLE(context, modePacked, count,
                                                               typePacked, indices, primcount));
        if (isCallValid)
        {
            context->drawElementsInstanced(modePacked, count, typePacked, indices, primcount);
        }
        ANGLE_CAPTURE(DrawElementsInstancedANGLE, isCallValid, context, modePacked, count,
                      typePacked, indices, primcount);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DrawElementsInstancedBaseVertexContextANGLE(GLeglContext ctx,
                                                                GLenum mode,
                                                                GLsizei count,
                                                                GLenum type,
                                                                const void *indices,
                                                                GLsizei instancecount,
                                                                GLint basevertex)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDrawElementsInstancedBaseVertex,
          "context = %d, mode = %s, count = %d, type = %s, indices = 0x%016" PRIxPTR
          ", instancecount = %d, basevertex = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, instancecount,
          basevertex);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked                           = PackParam<DrawElementsType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawElementsInstancedBaseVertex(
                                                             context, modePacked, count, typePacked,
                                                             indices, instancecount, basevertex));
        if (isCallValid)
        {
            context->drawElementsInstancedBaseVertex(modePacked, count, typePacked, indices,
                                                     instancecount, basevertex);
        }
        ANGLE_CAPTURE(DrawElementsInstancedBaseVertex, isCallValid, context, modePacked, count,
                      typePacked, indices, instancecount, basevertex);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DrawElementsInstancedBaseVertexEXTContextANGLE(GLeglContext ctx,
                                                                   GLenum mode,
                                                                   GLsizei count,
                                                                   GLenum type,
                                                                   const void *indices,
                                                                   GLsizei instancecount,
                                                                   GLint basevertex)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDrawElementsInstancedBaseVertexEXT,
          "context = %d, mode = %s, count = %d, type = %s, indices = 0x%016" PRIxPTR
          ", instancecount = %d, basevertex = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, instancecount,
          basevertex);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked                           = PackParam<DrawElementsType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawElementsInstancedBaseVertexEXT(
                                                             context, modePacked, count, typePacked,
                                                             indices, instancecount, basevertex));
        if (isCallValid)
        {
            context->drawElementsInstancedBaseVertex(modePacked, count, typePacked, indices,
                                                     instancecount, basevertex);
        }
        ANGLE_CAPTURE(DrawElementsInstancedBaseVertexEXT, isCallValid, context, modePacked, count,
                      typePacked, indices, instancecount, basevertex);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DrawElementsInstancedBaseVertexOESContextANGLE(GLeglContext ctx,
                                                                   GLenum mode,
                                                                   GLsizei count,
                                                                   GLenum type,
                                                                   const void *indices,
                                                                   GLsizei instancecount,
                                                                   GLint basevertex)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDrawElementsInstancedBaseVertexOES,
          "context = %d, mode = %s, count = %d, type = %s, indices = 0x%016" PRIxPTR
          ", instancecount = %d, basevertex = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, instancecount,
          basevertex);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked                           = PackParam<DrawElementsType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawElementsInstancedBaseVertexOES(
                                                             context, modePacked, count, typePacked,
                                                             indices, instancecount, basevertex));
        if (isCallValid)
        {
            context->drawElementsInstancedBaseVertex(modePacked, count, typePacked, indices,
                                                     instancecount, basevertex);
        }
        ANGLE_CAPTURE(DrawElementsInstancedBaseVertexOES, isCallValid, context, modePacked, count,
                      typePacked, indices, instancecount, basevertex);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DrawElementsInstancedEXTContextANGLE(GLeglContext ctx,
                                                         GLenum mode,
                                                         GLsizei count,
                                                         GLenum type,
                                                         const void *indices,
                                                         GLsizei primcount)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDrawElementsInstancedEXT,
          "context = %d, mode = %s, count = %d, type = %s, indices = 0x%016" PRIxPTR
          ", primcount = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, primcount);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked                           = PackParam<DrawElementsType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDrawElementsInstancedEXT(context, modePacked, count, typePacked,
                                                             indices, primcount));
        if (isCallValid)
        {
            context->drawElementsInstanced(modePacked, count, typePacked, indices, primcount);
        }
        ANGLE_CAPTURE(DrawElementsInstancedEXT, isCallValid, context, modePacked, count, typePacked,
                      indices, primcount);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DrawRangeElementsContextANGLE(GLeglContext ctx,
                                                  GLenum mode,
                                                  GLuint start,
                                                  GLuint end,
                                                  GLsizei count,
                                                  GLenum type,
                                                  const void *indices)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDrawRangeElements,
          "context = %d, mode = %s, start = %u, end = %u, count = %d, type = %s, indices = "
          "0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), start, end, count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked                           = PackParam<DrawElementsType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDrawRangeElements(context, modePacked, start, end,
                                                                    count, typePacked, indices));
        if (isCallValid)
        {
            context->drawRangeElements(modePacked, start, end, count, typePacked, indices);
        }
        ANGLE_CAPTURE(DrawRangeElements, isCallValid, context, modePacked, start, end, count,
                      typePacked, indices);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DrawRangeElementsBaseVertexContextANGLE(GLeglContext ctx,
                                                            GLenum mode,
                                                            GLuint start,
                                                            GLuint end,
                                                            GLsizei count,
                                                            GLenum type,
                                                            const void *indices,
                                                            GLint basevertex)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDrawRangeElementsBaseVertex,
          "context = %d, mode = %s, start = %u, end = %u, count = %d, type = %s, indices = "
          "0x%016" PRIxPTR ", basevertex = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), start, end, count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, basevertex);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked                           = PackParam<DrawElementsType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawRangeElementsBaseVertex(
                                                             context, modePacked, start, end, count,
                                                             typePacked, indices, basevertex));
        if (isCallValid)
        {
            context->drawRangeElementsBaseVertex(modePacked, start, end, count, typePacked, indices,
                                                 basevertex);
        }
        ANGLE_CAPTURE(DrawRangeElementsBaseVertex, isCallValid, context, modePacked, start, end,
                      count, typePacked, indices, basevertex);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DrawRangeElementsBaseVertexEXTContextANGLE(GLeglContext ctx,
                                                               GLenum mode,
                                                               GLuint start,
                                                               GLuint end,
                                                               GLsizei count,
                                                               GLenum type,
                                                               const void *indices,
                                                               GLint basevertex)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDrawRangeElementsBaseVertexEXT,
          "context = %d, mode = %s, start = %u, end = %u, count = %d, type = %s, indices = "
          "0x%016" PRIxPTR ", basevertex = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), start, end, count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, basevertex);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked                           = PackParam<DrawElementsType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawRangeElementsBaseVertexEXT(
                                                             context, modePacked, start, end, count,
                                                             typePacked, indices, basevertex));
        if (isCallValid)
        {
            context->drawRangeElementsBaseVertex(modePacked, start, end, count, typePacked, indices,
                                                 basevertex);
        }
        ANGLE_CAPTURE(DrawRangeElementsBaseVertexEXT, isCallValid, context, modePacked, start, end,
                      count, typePacked, indices, basevertex);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DrawRangeElementsBaseVertexOESContextANGLE(GLeglContext ctx,
                                                               GLenum mode,
                                                               GLuint start,
                                                               GLuint end,
                                                               GLsizei count,
                                                               GLenum type,
                                                               const void *indices,
                                                               GLint basevertex)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDrawRangeElementsBaseVertexOES,
          "context = %d, mode = %s, start = %u, end = %u, count = %d, type = %s, indices = "
          "0x%016" PRIxPTR ", basevertex = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), start, end, count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, basevertex);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked                           = PackParam<DrawElementsType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawRangeElementsBaseVertexOES(
                                                             context, modePacked, start, end, count,
                                                             typePacked, indices, basevertex));
        if (isCallValid)
        {
            context->drawRangeElementsBaseVertex(modePacked, start, end, count, typePacked, indices,
                                                 basevertex);
        }
        ANGLE_CAPTURE(DrawRangeElementsBaseVertexOES, isCallValid, context, modePacked, start, end,
                      count, typePacked, indices, basevertex);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DrawTexfOESContextANGLE(GLeglContext ctx,
                                            GLfloat x,
                                            GLfloat y,
                                            GLfloat z,
                                            GLfloat width,
                                            GLfloat height)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDrawTexfOES, "context = %d, x = %f, y = %f, z = %f, width = %f, height = %f",
          CID(context), x, y, z, width, height);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDrawTexfOES(context, x, y, z, width, height));
        if (isCallValid)
        {
            context->drawTexf(x, y, z, width, height);
        }
        ANGLE_CAPTURE(DrawTexfOES, isCallValid, context, x, y, z, width, height);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DrawTexfvOESContextANGLE(GLeglContext ctx, const GLfloat *coords)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDrawTexfvOES, "context = %d, coords = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)coords);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawTexfvOES(context, coords));
        if (isCallValid)
        {
            context->drawTexfv(coords);
        }
        ANGLE_CAPTURE(DrawTexfvOES, isCallValid, context, coords);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY
GL_DrawTexiOESContextANGLE(GLeglContext ctx, GLint x, GLint y, GLint z, GLint width, GLint height)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDrawTexiOES, "context = %d, x = %d, y = %d, z = %d, width = %d, height = %d",
          CID(context), x, y, z, width, height);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDrawTexiOES(context, x, y, z, width, height));
        if (isCallValid)
        {
            context->drawTexi(x, y, z, width, height);
        }
        ANGLE_CAPTURE(DrawTexiOES, isCallValid, context, x, y, z, width, height);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DrawTexivOESContextANGLE(GLeglContext ctx, const GLint *coords)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDrawTexivOES, "context = %d, coords = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)coords);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawTexivOES(context, coords));
        if (isCallValid)
        {
            context->drawTexiv(coords);
        }
        ANGLE_CAPTURE(DrawTexivOES, isCallValid, context, coords);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DrawTexsOESContextANGLE(GLeglContext ctx,
                                            GLshort x,
                                            GLshort y,
                                            GLshort z,
                                            GLshort width,
                                            GLshort height)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDrawTexsOES, "context = %d, x = %d, y = %d, z = %d, width = %d, height = %d",
          CID(context), x, y, z, width, height);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDrawTexsOES(context, x, y, z, width, height));
        if (isCallValid)
        {
            context->drawTexs(x, y, z, width, height);
        }
        ANGLE_CAPTURE(DrawTexsOES, isCallValid, context, x, y, z, width, height);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DrawTexsvOESContextANGLE(GLeglContext ctx, const GLshort *coords)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDrawTexsvOES, "context = %d, coords = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)coords);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawTexsvOES(context, coords));
        if (isCallValid)
        {
            context->drawTexsv(coords);
        }
        ANGLE_CAPTURE(DrawTexsvOES, isCallValid, context, coords);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DrawTexxOESContextANGLE(GLeglContext ctx,
                                            GLfixed x,
                                            GLfixed y,
                                            GLfixed z,
                                            GLfixed width,
                                            GLfixed height)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDrawTexxOES,
          "context = %d, x = 0x%X, y = 0x%X, z = 0x%X, width = 0x%X, height = 0x%X", CID(context),
          x, y, z, width, height);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDrawTexxOES(context, x, y, z, width, height));
        if (isCallValid)
        {
            context->drawTexx(x, y, z, width, height);
        }
        ANGLE_CAPTURE(DrawTexxOES, isCallValid, context, x, y, z, width, height);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_DrawTexxvOESContextANGLE(GLeglContext ctx, const GLfixed *coords)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLDrawTexxvOES, "context = %d, coords = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)coords);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawTexxvOES(context, coords));
        if (isCallValid)
        {
            context->drawTexxv(coords);
        }
        ANGLE_CAPTURE(DrawTexxvOES, isCallValid, context, coords);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_EGLImageTargetRenderbufferStorageOESContextANGLE(GLeglContext ctx,
                                                                     GLenum target,
                                                                     GLeglImageOES image)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLEGLImageTargetRenderbufferStorageOES,
          "context = %d, target = %s, image = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::DefaultGroup, target), (uintptr_t)image);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateEGLImageTargetRenderbufferStorageOES(context, target, image));
        if (isCallValid)
        {
            context->eGLImageTargetRenderbufferStorage(target, image);
        }
        ANGLE_CAPTURE(EGLImageTargetRenderbufferStorageOES, isCallValid, context, target, image);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_EGLImageTargetTexture2DOESContextANGLE(GLeglContext ctx,
                                                           GLenum target,
                                                           GLeglImageOES image)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLEGLImageTargetTexture2DOES,
          "context = %d, target = %s, image = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::DefaultGroup, target), (uintptr_t)image);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                              = PackParam<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateEGLImageTargetTexture2DOES(context, targetPacked, image));
        if (isCallValid)
        {
            context->eGLImageTargetTexture2D(targetPacked, image);
        }
        ANGLE_CAPTURE(EGLImageTargetTexture2DOES, isCallValid, context, targetPacked, image);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_EnableContextANGLE(GLeglContext ctx, GLenum cap)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLEnable, "context = %d, cap = %s", CID(context),
          GLenumToString(GLenumGroup::EnableCap, cap));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateEnable(context, cap));
        if (isCallValid)
        {
            context->enable(cap);
        }
        ANGLE_CAPTURE(Enable, isCallValid, context, cap);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_EnableClientStateContextANGLE(GLeglContext ctx, GLenum array)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLEnableClientState, "context = %d, array = %s", CID(context),
          GLenumToString(GLenumGroup::EnableCap, array));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ClientVertexArrayType arrayPacked = PackParam<ClientVertexArrayType>(array);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateEnableClientState(context, arrayPacked));
        if (isCallValid)
        {
            context->enableClientState(arrayPacked);
        }
        ANGLE_CAPTURE(EnableClientState, isCallValid, context, arrayPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_EnableVertexAttribArrayContextANGLE(GLeglContext ctx, GLuint index)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLEnableVertexAttribArray, "context = %d, index = %u", CID(context), index);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateEnableVertexAttribArray(context, index));
        if (isCallValid)
        {
            context->enableVertexAttribArray(index);
        }
        ANGLE_CAPTURE(EnableVertexAttribArray, isCallValid, context, index);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_EnableiContextANGLE(GLeglContext ctx, GLenum target, GLuint index)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLEnablei, "context = %d, target = %s, index = %u", CID(context),
          GLenumToString(GLenumGroup::EnableCap, target), index);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateEnablei(context, target, index));
        if (isCallValid)
        {
            context->enablei(target, index);
        }
        ANGLE_CAPTURE(Enablei, isCallValid, context, target, index);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_EnableiEXTContextANGLE(GLeglContext ctx, GLenum target, GLuint index)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLEnableiEXT, "context = %d, target = %s, index = %u", CID(context),
          GLenumToString(GLenumGroup::EnableCap, target), index);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateEnableiEXT(context, target, index));
        if (isCallValid)
        {
            context->enablei(target, index);
        }
        ANGLE_CAPTURE(EnableiEXT, isCallValid, context, target, index);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_EnableiOESContextANGLE(GLeglContext ctx, GLenum target, GLuint index)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLEnableiOES, "context = %d, target = %s, index = %u", CID(context),
          GLenumToString(GLenumGroup::EnableCap, target), index);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateEnableiOES(context, target, index));
        if (isCallValid)
        {
            context->enablei(target, index);
        }
        ANGLE_CAPTURE(EnableiOES, isCallValid, context, target, index);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_EndQueryContextANGLE(GLeglContext ctx, GLenum target)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLEndQuery, "context = %d, target = %s", CID(context),
          GLenumToString(GLenumGroup::QueryTarget, target));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        QueryType targetPacked                                = PackParam<QueryType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateEndQuery(context, targetPacked));
        if (isCallValid)
        {
            context->endQuery(targetPacked);
        }
        ANGLE_CAPTURE(EndQuery, isCallValid, context, targetPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_EndQueryEXTContextANGLE(GLeglContext ctx, GLenum target)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLEndQueryEXT, "context = %d, target = %s", CID(context),
          GLenumToString(GLenumGroup::QueryTarget, target));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        QueryType targetPacked                                = PackParam<QueryType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateEndQueryEXT(context, targetPacked));
        if (isCallValid)
        {
            context->endQuery(targetPacked);
        }
        ANGLE_CAPTURE(EndQueryEXT, isCallValid, context, targetPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_EndTransformFeedbackContextANGLE(GLeglContext ctx)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLEndTransformFeedback, "context = %d", CID(context));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateEndTransformFeedback(context));
        if (isCallValid)
        {
            context->endTransformFeedback();
        }
        ANGLE_CAPTURE(EndTransformFeedback, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

GLsync GL_APIENTRY GL_FenceSyncContextANGLE(GLeglContext ctx, GLenum condition, GLbitfield flags)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLFenceSync, "context = %d, condition = %s, flags = %s", CID(context),
          GLenumToString(GLenumGroup::SyncCondition, condition),
          GLbitfieldToString(GLenumGroup::DefaultGroup, flags).c_str());

    GLsync returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateFenceSync(context, condition, flags));
        if (isCallValid)
        {
            returnValue = context->fenceSync(condition, flags);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLFenceSync, GLsync>();
        }
        ANGLE_CAPTURE(FenceSync, isCallValid, context, condition, flags, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLFenceSync, GLsync>();
    }
    return returnValue;
}

void GL_APIENTRY GL_FinishContextANGLE(GLeglContext ctx)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLFinish, "context = %d", CID(context));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateFinish(context));
        if (isCallValid)
        {
            context->finish();
        }
        ANGLE_CAPTURE(Finish, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_FinishFenceNVContextANGLE(GLeglContext ctx, GLuint fence)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLFinishFenceNV, "context = %d, fence = %u", CID(context), fence);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        FenceNVID fencePacked                                 = PackParam<FenceNVID>(fence);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateFinishFenceNV(context, fencePacked));
        if (isCallValid)
        {
            context->finishFenceNV(fencePacked);
        }
        ANGLE_CAPTURE(FinishFenceNV, isCallValid, context, fencePacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_FlushContextANGLE(GLeglContext ctx)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLFlush, "context = %d", CID(context));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateFlush(context));
        if (isCallValid)
        {
            context->flush();
        }
        ANGLE_CAPTURE(Flush, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_FlushMappedBufferRangeContextANGLE(GLeglContext ctx,
                                                       GLenum target,
                                                       GLintptr offset,
                                                       GLsizeiptr length)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLFlushMappedBufferRange,
          "context = %d, target = %s, offset = %llu, length = %llu", CID(context),
          GLenumToString(GLenumGroup::BufferTargetARB, target),
          static_cast<unsigned long long>(offset), static_cast<unsigned long long>(length));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked                            = PackParam<BufferBinding>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateFlushMappedBufferRange(context, targetPacked, offset, length));
        if (isCallValid)
        {
            context->flushMappedBufferRange(targetPacked, offset, length);
        }
        ANGLE_CAPTURE(FlushMappedBufferRange, isCallValid, context, targetPacked, offset, length);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_FlushMappedBufferRangeEXTContextANGLE(GLeglContext ctx,
                                                          GLenum target,
                                                          GLintptr offset,
                                                          GLsizeiptr length)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLFlushMappedBufferRangeEXT,
          "context = %d, target = %s, offset = %llu, length = %llu", CID(context),
          GLenumToString(GLenumGroup::BufferTargetARB, target),
          static_cast<unsigned long long>(offset), static_cast<unsigned long long>(length));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked                            = PackParam<BufferBinding>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateFlushMappedBufferRangeEXT(context, targetPacked, offset, length));
        if (isCallValid)
        {
            context->flushMappedBufferRange(targetPacked, offset, length);
        }
        ANGLE_CAPTURE(FlushMappedBufferRangeEXT, isCallValid, context, targetPacked, offset,
                      length);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_FogfContextANGLE(GLeglContext ctx, GLenum pname, GLfloat param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLFogf, "context = %d, pname = %s, param = %f", CID(context),
          GLenumToString(GLenumGroup::FogParameter, pname), param);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateFogf(context, pname, param));
        if (isCallValid)
        {
            context->fogf(pname, param);
        }
        ANGLE_CAPTURE(Fogf, isCallValid, context, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_FogfvContextANGLE(GLeglContext ctx, GLenum pname, const GLfloat *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLFogfv, "context = %d, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::FogParameter, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateFogfv(context, pname, params));
        if (isCallValid)
        {
            context->fogfv(pname, params);
        }
        ANGLE_CAPTURE(Fogfv, isCallValid, context, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_FogxContextANGLE(GLeglContext ctx, GLenum pname, GLfixed param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLFogx, "context = %d, pname = %s, param = 0x%X", CID(context),
          GLenumToString(GLenumGroup::FogPName, pname), param);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateFogx(context, pname, param));
        if (isCallValid)
        {
            context->fogx(pname, param);
        }
        ANGLE_CAPTURE(Fogx, isCallValid, context, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_FogxvContextANGLE(GLeglContext ctx, GLenum pname, const GLfixed *param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLFogxv, "context = %d, pname = %s, param = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::FogPName, pname), (uintptr_t)param);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateFogxv(context, pname, param));
        if (isCallValid)
        {
            context->fogxv(pname, param);
        }
        ANGLE_CAPTURE(Fogxv, isCallValid, context, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_FramebufferFetchBarrierEXTContextANGLE(GLeglContext ctx)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLFramebufferFetchBarrierEXT, "context = %d", CID(context));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateFramebufferFetchBarrierEXT(context));
        if (isCallValid)
        {
            context->framebufferFetchBarrier();
        }
        ANGLE_CAPTURE(FramebufferFetchBarrierEXT, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_FramebufferParameteriContextANGLE(GLeglContext ctx,
                                                      GLenum target,
                                                      GLenum pname,
                                                      GLint param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLFramebufferParameteri, "context = %d, target = %s, pname = %s, param = %d",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferParameterName, pname), param);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateFramebufferParameteri(context, target, pname, param));
        if (isCallValid)
        {
            context->framebufferParameteri(target, pname, param);
        }
        ANGLE_CAPTURE(FramebufferParameteri, isCallValid, context, target, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_FramebufferRenderbufferContextANGLE(GLeglContext ctx,
                                                        GLenum target,
                                                        GLenum attachment,
                                                        GLenum renderbuffertarget,
                                                        GLuint renderbuffer)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLFramebufferRenderbuffer,
          "context = %d, target = %s, attachment = %s, renderbuffertarget = %s, renderbuffer = %u",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment),
          GLenumToString(GLenumGroup::RenderbufferTarget, renderbuffertarget), renderbuffer);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        RenderbufferID renderbufferPacked = PackParam<RenderbufferID>(renderbuffer);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateFramebufferRenderbuffer(context, target, attachment, renderbuffertarget,
                                             renderbufferPacked));
        if (isCallValid)
        {
            context->framebufferRenderbuffer(target, attachment, renderbuffertarget,
                                             renderbufferPacked);
        }
        ANGLE_CAPTURE(FramebufferRenderbuffer, isCallValid, context, target, attachment,
                      renderbuffertarget, renderbufferPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_FramebufferRenderbufferOESContextANGLE(GLeglContext ctx,
                                                           GLenum target,
                                                           GLenum attachment,
                                                           GLenum renderbuffertarget,
                                                           GLuint renderbuffer)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLFramebufferRenderbufferOES,
          "context = %d, target = %s, attachment = %s, renderbuffertarget = %s, renderbuffer = %u",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment),
          GLenumToString(GLenumGroup::RenderbufferTarget, renderbuffertarget), renderbuffer);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        RenderbufferID renderbufferPacked = PackParam<RenderbufferID>(renderbuffer);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateFramebufferRenderbufferOES(context, target, attachment, renderbuffertarget,
                                                renderbufferPacked));
        if (isCallValid)
        {
            context->framebufferRenderbuffer(target, attachment, renderbuffertarget,
                                             renderbufferPacked);
        }
        ANGLE_CAPTURE(FramebufferRenderbufferOES, isCallValid, context, target, attachment,
                      renderbuffertarget, renderbufferPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_FramebufferTextureContextANGLE(GLeglContext ctx,
                                                   GLenum target,
                                                   GLenum attachment,
                                                   GLuint texture,
                                                   GLint level)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLFramebufferTexture,
          "context = %d, target = %s, attachment = %s, texture = %u, level = %d", CID(context),
          GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment), texture, level);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TextureID texturePacked                               = PackParam<TextureID>(texture);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateFramebufferTexture(context, target, attachment, texturePacked, level));
        if (isCallValid)
        {
            context->framebufferTexture(target, attachment, texturePacked, level);
        }
        ANGLE_CAPTURE(FramebufferTexture, isCallValid, context, target, attachment, texturePacked,
                      level);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_FramebufferTexture2DContextANGLE(GLeglContext ctx,
                                                     GLenum target,
                                                     GLenum attachment,
                                                     GLenum textarget,
                                                     GLuint texture,
                                                     GLint level)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLFramebufferTexture2D,
          "context = %d, target = %s, attachment = %s, textarget = %s, texture = %u, level = %d",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment),
          GLenumToString(GLenumGroup::TextureTarget, textarget), texture, level);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget textargetPacked                         = PackParam<TextureTarget>(textarget);
        TextureID texturePacked                               = PackParam<TextureID>(texture);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateFramebufferTexture2D(context, target, attachment,
                                                         textargetPacked, texturePacked, level));
        if (isCallValid)
        {
            context->framebufferTexture2D(target, attachment, textargetPacked, texturePacked,
                                          level);
        }
        ANGLE_CAPTURE(FramebufferTexture2D, isCallValid, context, target, attachment,
                      textargetPacked, texturePacked, level);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_FramebufferTexture2DMultisampleEXTContextANGLE(GLeglContext ctx,
                                                                   GLenum target,
                                                                   GLenum attachment,
                                                                   GLenum textarget,
                                                                   GLuint texture,
                                                                   GLint level,
                                                                   GLsizei samples)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLFramebufferTexture2DMultisampleEXT,
          "context = %d, target = %s, attachment = %s, textarget = %s, texture = %u, level = %d, "
          "samples = %d",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment),
          GLenumToString(GLenumGroup::TextureTarget, textarget), texture, level, samples);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget textargetPacked                         = PackParam<TextureTarget>(textarget);
        TextureID texturePacked                               = PackParam<TextureID>(texture);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateFramebufferTexture2DMultisampleEXT(
                 context, target, attachment, textargetPacked, texturePacked, level, samples));
        if (isCallValid)
        {
            context->framebufferTexture2DMultisample(target, attachment, textargetPacked,
                                                     texturePacked, level, samples);
        }
        ANGLE_CAPTURE(FramebufferTexture2DMultisampleEXT, isCallValid, context, target, attachment,
                      textargetPacked, texturePacked, level, samples);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_FramebufferTexture2DOESContextANGLE(GLeglContext ctx,
                                                        GLenum target,
                                                        GLenum attachment,
                                                        GLenum textarget,
                                                        GLuint texture,
                                                        GLint level)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLFramebufferTexture2DOES,
          "context = %d, target = %s, attachment = %s, textarget = %s, texture = %u, level = %d",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment),
          GLenumToString(GLenumGroup::TextureTarget, textarget), texture, level);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget textargetPacked                         = PackParam<TextureTarget>(textarget);
        TextureID texturePacked                               = PackParam<TextureID>(texture);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateFramebufferTexture2DOES(context, target, attachment,
                                                            textargetPacked, texturePacked, level));
        if (isCallValid)
        {
            context->framebufferTexture2D(target, attachment, textargetPacked, texturePacked,
                                          level);
        }
        ANGLE_CAPTURE(FramebufferTexture2DOES, isCallValid, context, target, attachment,
                      textargetPacked, texturePacked, level);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_FramebufferTexture3DOESContextANGLE(GLeglContext ctx,
                                                        GLenum target,
                                                        GLenum attachment,
                                                        GLenum textarget,
                                                        GLuint texture,
                                                        GLint level,
                                                        GLint zoffset)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLFramebufferTexture3DOES,
          "context = %d, target = %s, attachment = %s, textarget = %s, texture = %u, level = %d, "
          "zoffset = %d",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment),
          GLenumToString(GLenumGroup::TextureTarget, textarget), texture, level, zoffset);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget textargetPacked                         = PackParam<TextureTarget>(textarget);
        TextureID texturePacked                               = PackParam<TextureID>(texture);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateFramebufferTexture3DOES(context, target, attachment, textargetPacked,
                                             texturePacked, level, zoffset));
        if (isCallValid)
        {
            context->framebufferTexture3D(target, attachment, textargetPacked, texturePacked, level,
                                          zoffset);
        }
        ANGLE_CAPTURE(FramebufferTexture3DOES, isCallValid, context, target, attachment,
                      textargetPacked, texturePacked, level, zoffset);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_FramebufferTextureEXTContextANGLE(GLeglContext ctx,
                                                      GLenum target,
                                                      GLenum attachment,
                                                      GLuint texture,
                                                      GLint level)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLFramebufferTextureEXT,
          "context = %d, target = %s, attachment = %s, texture = %u, level = %d", CID(context),
          GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment), texture, level);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TextureID texturePacked                               = PackParam<TextureID>(texture);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateFramebufferTextureEXT(context, target, attachment, texturePacked, level));
        if (isCallValid)
        {
            context->framebufferTexture(target, attachment, texturePacked, level);
        }
        ANGLE_CAPTURE(FramebufferTextureEXT, isCallValid, context, target, attachment,
                      texturePacked, level);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_FramebufferTextureLayerContextANGLE(GLeglContext ctx,
                                                        GLenum target,
                                                        GLenum attachment,
                                                        GLuint texture,
                                                        GLint level,
                                                        GLint layer)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLFramebufferTextureLayer,
          "context = %d, target = %s, attachment = %s, texture = %u, level = %d, layer = %d",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment), texture, level, layer);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TextureID texturePacked                               = PackParam<TextureID>(texture);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateFramebufferTextureLayer(context, target, attachment,
                                                            texturePacked, level, layer));
        if (isCallValid)
        {
            context->framebufferTextureLayer(target, attachment, texturePacked, level, layer);
        }
        ANGLE_CAPTURE(FramebufferTextureLayer, isCallValid, context, target, attachment,
                      texturePacked, level, layer);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_FramebufferTextureMultiviewOVRContextANGLE(GLeglContext ctx,
                                                               GLenum target,
                                                               GLenum attachment,
                                                               GLuint texture,
                                                               GLint level,
                                                               GLint baseViewIndex,
                                                               GLsizei numViews)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLFramebufferTextureMultiviewOVR,
          "context = %d, target = %s, attachment = %s, texture = %u, level = %d, baseViewIndex = "
          "%d, numViews = %d",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment), texture, level,
          baseViewIndex, numViews);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TextureID texturePacked                               = PackParam<TextureID>(texture);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateFramebufferTextureMultiviewOVR(context, target, attachment, texturePacked,
                                                    level, baseViewIndex, numViews));
        if (isCallValid)
        {
            context->framebufferTextureMultiview(target, attachment, texturePacked, level,
                                                 baseViewIndex, numViews);
        }
        ANGLE_CAPTURE(FramebufferTextureMultiviewOVR, isCallValid, context, target, attachment,
                      texturePacked, level, baseViewIndex, numViews);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_FrontFaceContextANGLE(GLeglContext ctx, GLenum mode)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLFrontFace, "context = %d, mode = %s", CID(context),
          GLenumToString(GLenumGroup::FrontFaceDirection, mode));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateFrontFace(context, mode));
        if (isCallValid)
        {
            context->frontFace(mode);
        }
        ANGLE_CAPTURE(FrontFace, isCallValid, context, mode);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_FrustumfContextANGLE(GLeglContext ctx,
                                         GLfloat l,
                                         GLfloat r,
                                         GLfloat b,
                                         GLfloat t,
                                         GLfloat n,
                                         GLfloat f)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLFrustumf, "context = %d, l = %f, r = %f, b = %f, t = %f, n = %f, f = %f",
          CID(context), l, r, b, t, n, f);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateFrustumf(context, l, r, b, t, n, f));
        if (isCallValid)
        {
            context->frustumf(l, r, b, t, n, f);
        }
        ANGLE_CAPTURE(Frustumf, isCallValid, context, l, r, b, t, n, f);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_FrustumxContextANGLE(GLeglContext ctx,
                                         GLfixed l,
                                         GLfixed r,
                                         GLfixed b,
                                         GLfixed t,
                                         GLfixed n,
                                         GLfixed f)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLFrustumx,
          "context = %d, l = 0x%X, r = 0x%X, b = 0x%X, t = 0x%X, n = 0x%X, f = 0x%X", CID(context),
          l, r, b, t, n, f);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateFrustumx(context, l, r, b, t, n, f));
        if (isCallValid)
        {
            context->frustumx(l, r, b, t, n, f);
        }
        ANGLE_CAPTURE(Frustumx, isCallValid, context, l, r, b, t, n, f);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GenBuffersContextANGLE(GLeglContext ctx, GLsizei n, GLuint *buffers)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGenBuffers, "context = %d, n = %d, buffers = 0x%016" PRIxPTR "", CID(context),
          n, (uintptr_t)buffers);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        BufferID *buffersPacked                               = PackParam<BufferID *>(buffers);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenBuffers(context, n, buffersPacked));
        if (isCallValid)
        {
            context->genBuffers(n, buffersPacked);
        }
        ANGLE_CAPTURE(GenBuffers, isCallValid, context, n, buffersPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GenFencesNVContextANGLE(GLeglContext ctx, GLsizei n, GLuint *fences)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGenFencesNV, "context = %d, n = %d, fences = 0x%016" PRIxPTR "", CID(context),
          n, (uintptr_t)fences);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        FenceNVID *fencesPacked                               = PackParam<FenceNVID *>(fences);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenFencesNV(context, n, fencesPacked));
        if (isCallValid)
        {
            context->genFencesNV(n, fencesPacked);
        }
        ANGLE_CAPTURE(GenFencesNV, isCallValid, context, n, fencesPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GenFramebuffersContextANGLE(GLeglContext ctx, GLsizei n, GLuint *framebuffers)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGenFramebuffers, "context = %d, n = %d, framebuffers = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)framebuffers);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        FramebufferID *framebuffersPacked = PackParam<FramebufferID *>(framebuffers);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenFramebuffers(context, n, framebuffersPacked));
        if (isCallValid)
        {
            context->genFramebuffers(n, framebuffersPacked);
        }
        ANGLE_CAPTURE(GenFramebuffers, isCallValid, context, n, framebuffersPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GenFramebuffersOESContextANGLE(GLeglContext ctx,
                                                   GLsizei n,
                                                   GLuint *framebuffers)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGenFramebuffersOES, "context = %d, n = %d, framebuffers = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)framebuffers);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        FramebufferID *framebuffersPacked = PackParam<FramebufferID *>(framebuffers);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGenFramebuffersOES(context, n, framebuffersPacked));
        if (isCallValid)
        {
            context->genFramebuffers(n, framebuffersPacked);
        }
        ANGLE_CAPTURE(GenFramebuffersOES, isCallValid, context, n, framebuffersPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GenProgramPipelinesContextANGLE(GLeglContext ctx, GLsizei n, GLuint *pipelines)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGenProgramPipelines, "context = %d, n = %d, pipelines = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)pipelines);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ProgramPipelineID *pipelinesPacked = PackParam<ProgramPipelineID *>(pipelines);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenProgramPipelines(context, n, pipelinesPacked));
        if (isCallValid)
        {
            context->genProgramPipelines(n, pipelinesPacked);
        }
        ANGLE_CAPTURE(GenProgramPipelines, isCallValid, context, n, pipelinesPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GenProgramPipelinesEXTContextANGLE(GLeglContext ctx,
                                                       GLsizei n,
                                                       GLuint *pipelines)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGenProgramPipelinesEXT, "context = %d, n = %d, pipelines = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)pipelines);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ProgramPipelineID *pipelinesPacked = PackParam<ProgramPipelineID *>(pipelines);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGenProgramPipelinesEXT(context, n, pipelinesPacked));
        if (isCallValid)
        {
            context->genProgramPipelines(n, pipelinesPacked);
        }
        ANGLE_CAPTURE(GenProgramPipelinesEXT, isCallValid, context, n, pipelinesPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GenQueriesContextANGLE(GLeglContext ctx, GLsizei n, GLuint *ids)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGenQueries, "context = %d, n = %d, ids = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)ids);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        QueryID *idsPacked                                    = PackParam<QueryID *>(ids);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateGenQueries(context, n, idsPacked));
        if (isCallValid)
        {
            context->genQueries(n, idsPacked);
        }
        ANGLE_CAPTURE(GenQueries, isCallValid, context, n, idsPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GenQueriesEXTContextANGLE(GLeglContext ctx, GLsizei n, GLuint *ids)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGenQueriesEXT, "context = %d, n = %d, ids = 0x%016" PRIxPTR "", CID(context),
          n, (uintptr_t)ids);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        QueryID *idsPacked                                    = PackParam<QueryID *>(ids);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenQueriesEXT(context, n, idsPacked));
        if (isCallValid)
        {
            context->genQueries(n, idsPacked);
        }
        ANGLE_CAPTURE(GenQueriesEXT, isCallValid, context, n, idsPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GenRenderbuffersContextANGLE(GLeglContext ctx, GLsizei n, GLuint *renderbuffers)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGenRenderbuffers, "context = %d, n = %d, renderbuffers = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)renderbuffers);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        RenderbufferID *renderbuffersPacked = PackParam<RenderbufferID *>(renderbuffers);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGenRenderbuffers(context, n, renderbuffersPacked));
        if (isCallValid)
        {
            context->genRenderbuffers(n, renderbuffersPacked);
        }
        ANGLE_CAPTURE(GenRenderbuffers, isCallValid, context, n, renderbuffersPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GenRenderbuffersOESContextANGLE(GLeglContext ctx,
                                                    GLsizei n,
                                                    GLuint *renderbuffers)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGenRenderbuffersOES, "context = %d, n = %d, renderbuffers = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)renderbuffers);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        RenderbufferID *renderbuffersPacked = PackParam<RenderbufferID *>(renderbuffers);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGenRenderbuffersOES(context, n, renderbuffersPacked));
        if (isCallValid)
        {
            context->genRenderbuffers(n, renderbuffersPacked);
        }
        ANGLE_CAPTURE(GenRenderbuffersOES, isCallValid, context, n, renderbuffersPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GenSamplersContextANGLE(GLeglContext ctx, GLsizei count, GLuint *samplers)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGenSamplers, "context = %d, count = %d, samplers = 0x%016" PRIxPTR "",
          CID(context), count, (uintptr_t)samplers);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        SamplerID *samplersPacked                             = PackParam<SamplerID *>(samplers);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenSamplers(context, count, samplersPacked));
        if (isCallValid)
        {
            context->genSamplers(count, samplersPacked);
        }
        ANGLE_CAPTURE(GenSamplers, isCallValid, context, count, samplersPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GenSemaphoresEXTContextANGLE(GLeglContext ctx, GLsizei n, GLuint *semaphores)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGenSemaphoresEXT, "context = %d, n = %d, semaphores = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)semaphores);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        SemaphoreID *semaphoresPacked = PackParam<SemaphoreID *>(semaphores);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenSemaphoresEXT(context, n, semaphoresPacked));
        if (isCallValid)
        {
            context->genSemaphores(n, semaphoresPacked);
        }
        ANGLE_CAPTURE(GenSemaphoresEXT, isCallValid, context, n, semaphoresPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GenTexturesContextANGLE(GLeglContext ctx, GLsizei n, GLuint *textures)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGenTextures, "context = %d, n = %d, textures = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)textures);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TextureID *texturesPacked                             = PackParam<TextureID *>(textures);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenTextures(context, n, texturesPacked));
        if (isCallValid)
        {
            context->genTextures(n, texturesPacked);
        }
        ANGLE_CAPTURE(GenTextures, isCallValid, context, n, texturesPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GenTransformFeedbacksContextANGLE(GLeglContext ctx, GLsizei n, GLuint *ids)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGenTransformFeedbacks, "context = %d, n = %d, ids = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)ids);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TransformFeedbackID *idsPacked = PackParam<TransformFeedbackID *>(ids);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenTransformFeedbacks(context, n, idsPacked));
        if (isCallValid)
        {
            context->genTransformFeedbacks(n, idsPacked);
        }
        ANGLE_CAPTURE(GenTransformFeedbacks, isCallValid, context, n, idsPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GenVertexArraysContextANGLE(GLeglContext ctx, GLsizei n, GLuint *arrays)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGenVertexArrays, "context = %d, n = %d, arrays = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)arrays);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        VertexArrayID *arraysPacked                           = PackParam<VertexArrayID *>(arrays);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenVertexArrays(context, n, arraysPacked));
        if (isCallValid)
        {
            context->genVertexArrays(n, arraysPacked);
        }
        ANGLE_CAPTURE(GenVertexArrays, isCallValid, context, n, arraysPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GenVertexArraysOESContextANGLE(GLeglContext ctx, GLsizei n, GLuint *arrays)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGenVertexArraysOES, "context = %d, n = %d, arrays = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)arrays);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        VertexArrayID *arraysPacked                           = PackParam<VertexArrayID *>(arrays);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenVertexArraysOES(context, n, arraysPacked));
        if (isCallValid)
        {
            context->genVertexArrays(n, arraysPacked);
        }
        ANGLE_CAPTURE(GenVertexArraysOES, isCallValid, context, n, arraysPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GenerateMipmapContextANGLE(GLeglContext ctx, GLenum target)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGenerateMipmap, "context = %d, target = %s", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                              = PackParam<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenerateMipmap(context, targetPacked));
        if (isCallValid)
        {
            context->generateMipmap(targetPacked);
        }
        ANGLE_CAPTURE(GenerateMipmap, isCallValid, context, targetPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GenerateMipmapOESContextANGLE(GLeglContext ctx, GLenum target)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGenerateMipmapOES, "context = %d, target = %s", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                              = PackParam<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenerateMipmapOES(context, targetPacked));
        if (isCallValid)
        {
            context->generateMipmap(targetPacked);
        }
        ANGLE_CAPTURE(GenerateMipmapOES, isCallValid, context, targetPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetActiveAttribContextANGLE(GLeglContext ctx,
                                                GLuint program,
                                                GLuint index,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLint *size,
                                                GLenum *type,
                                                GLchar *name)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetActiveAttrib,
          "context = %d, program = %u, index = %u, bufSize = %d, length = 0x%016" PRIxPTR
          ", size = 0x%016" PRIxPTR ", type = 0x%016" PRIxPTR ", name = 0x%016" PRIxPTR "",
          CID(context), program, index, bufSize, (uintptr_t)length, (uintptr_t)size,
          (uintptr_t)type, (uintptr_t)name);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetActiveAttrib(context, programPacked, index, bufSize, length,
                                                    size, type, name));
        if (isCallValid)
        {
            context->getActiveAttrib(programPacked, index, bufSize, length, size, type, name);
        }
        ANGLE_CAPTURE(GetActiveAttrib, isCallValid, context, programPacked, index, bufSize, length,
                      size, type, name);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetActiveUniformContextANGLE(GLeglContext ctx,
                                                 GLuint program,
                                                 GLuint index,
                                                 GLsizei bufSize,
                                                 GLsizei *length,
                                                 GLint *size,
                                                 GLenum *type,
                                                 GLchar *name)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetActiveUniform,
          "context = %d, program = %u, index = %u, bufSize = %d, length = 0x%016" PRIxPTR
          ", size = 0x%016" PRIxPTR ", type = 0x%016" PRIxPTR ", name = 0x%016" PRIxPTR "",
          CID(context), program, index, bufSize, (uintptr_t)length, (uintptr_t)size,
          (uintptr_t)type, (uintptr_t)name);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetActiveUniform(context, programPacked, index, bufSize, length,
                                                     size, type, name));
        if (isCallValid)
        {
            context->getActiveUniform(programPacked, index, bufSize, length, size, type, name);
        }
        ANGLE_CAPTURE(GetActiveUniform, isCallValid, context, programPacked, index, bufSize, length,
                      size, type, name);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetActiveUniformBlockNameContextANGLE(GLeglContext ctx,
                                                          GLuint program,
                                                          GLuint uniformBlockIndex,
                                                          GLsizei bufSize,
                                                          GLsizei *length,
                                                          GLchar *uniformBlockName)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(
        context, GLGetActiveUniformBlockName,
        "context = %d, program = %u, uniformBlockIndex = %u, bufSize = %d, length = 0x%016" PRIxPTR
        ", uniformBlockName = 0x%016" PRIxPTR "",
        CID(context), program, uniformBlockIndex, bufSize, (uintptr_t)length,
        (uintptr_t)uniformBlockName);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked             = PackParam<ShaderProgramID>(program);
        UniformBlockIndex uniformBlockIndexPacked = PackParam<UniformBlockIndex>(uniformBlockIndex);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetActiveUniformBlockName(context, programPacked, uniformBlockIndexPacked,
                                               bufSize, length, uniformBlockName));
        if (isCallValid)
        {
            context->getActiveUniformBlockName(programPacked, uniformBlockIndexPacked, bufSize,
                                               length, uniformBlockName);
        }
        ANGLE_CAPTURE(GetActiveUniformBlockName, isCallValid, context, programPacked,
                      uniformBlockIndexPacked, bufSize, length, uniformBlockName);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetActiveUniformBlockivContextANGLE(GLeglContext ctx,
                                                        GLuint program,
                                                        GLuint uniformBlockIndex,
                                                        GLenum pname,
                                                        GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetActiveUniformBlockiv,
          "context = %d, program = %u, uniformBlockIndex = %u, pname = %s, params = 0x%016" PRIxPTR
          "",
          CID(context), program, uniformBlockIndex,
          GLenumToString(GLenumGroup::UniformBlockPName, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked             = PackParam<ShaderProgramID>(program);
        UniformBlockIndex uniformBlockIndexPacked = PackParam<UniformBlockIndex>(uniformBlockIndex);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetActiveUniformBlockiv(
                                context, programPacked, uniformBlockIndexPacked, pname, params));
        if (isCallValid)
        {
            context->getActiveUniformBlockiv(programPacked, uniformBlockIndexPacked, pname, params);
        }
        ANGLE_CAPTURE(GetActiveUniformBlockiv, isCallValid, context, programPacked,
                      uniformBlockIndexPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetActiveUniformsivContextANGLE(GLeglContext ctx,
                                                    GLuint program,
                                                    GLsizei uniformCount,
                                                    const GLuint *uniformIndices,
                                                    GLenum pname,
                                                    GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetActiveUniformsiv,
          "context = %d, program = %u, uniformCount = %d, uniformIndices = 0x%016" PRIxPTR
          ", pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), program, uniformCount, (uintptr_t)uniformIndices,
          GLenumToString(GLenumGroup::UniformPName, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetActiveUniformsiv(context, programPacked, uniformCount,
                                                        uniformIndices, pname, params));
        if (isCallValid)
        {
            context->getActiveUniformsiv(programPacked, uniformCount, uniformIndices, pname,
                                         params);
        }
        ANGLE_CAPTURE(GetActiveUniformsiv, isCallValid, context, programPacked, uniformCount,
                      uniformIndices, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetAttachedShadersContextANGLE(GLeglContext ctx,
                                                   GLuint program,
                                                   GLsizei maxCount,
                                                   GLsizei *count,
                                                   GLuint *shaders)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetAttachedShaders,
          "context = %d, program = %u, maxCount = %d, count = 0x%016" PRIxPTR
          ", shaders = 0x%016" PRIxPTR "",
          CID(context), program, maxCount, (uintptr_t)count, (uintptr_t)shaders);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        ShaderProgramID *shadersPacked = PackParam<ShaderProgramID *>(shaders);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetAttachedShaders(context, programPacked, maxCount, count, shadersPacked));
        if (isCallValid)
        {
            context->getAttachedShaders(programPacked, maxCount, count, shadersPacked);
        }
        ANGLE_CAPTURE(GetAttachedShaders, isCallValid, context, programPacked, maxCount, count,
                      shadersPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

GLint GL_APIENTRY GL_GetAttribLocationContextANGLE(GLeglContext ctx,
                                                   GLuint program,
                                                   const GLchar *name)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetAttribLocation, "context = %d, program = %u, name = 0x%016" PRIxPTR "",
          CID(context), program, (uintptr_t)name);

    GLint returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetAttribLocation(context, programPacked, name));
        if (isCallValid)
        {
            returnValue = context->getAttribLocation(programPacked, name);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetAttribLocation, GLint>();
        }
        ANGLE_CAPTURE(GetAttribLocation, isCallValid, context, programPacked, name, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetAttribLocation, GLint>();
    }
    return returnValue;
}

void GL_APIENTRY GL_GetBooleani_vContextANGLE(GLeglContext ctx,
                                              GLenum target,
                                              GLuint index,
                                              GLboolean *data)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetBooleani_v,
          "context = %d, target = %s, index = %u, data = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::BufferTargetARB, target), index, (uintptr_t)data);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetBooleani_v(context, target, index, data));
        if (isCallValid)
        {
            context->getBooleani_v(target, index, data);
        }
        ANGLE_CAPTURE(GetBooleani_v, isCallValid, context, target, index, data);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetBooleanvContextANGLE(GLeglContext ctx, GLenum pname, GLboolean *data)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetBooleanv, "context = %d, pname = %s, data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::GetPName, pname), (uintptr_t)data);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateGetBooleanv(context, pname, data));
        if (isCallValid)
        {
            context->getBooleanv(pname, data);
        }
        ANGLE_CAPTURE(GetBooleanv, isCallValid, context, pname, data);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetBufferParameteri64vContextANGLE(GLeglContext ctx,
                                                       GLenum target,
                                                       GLenum pname,
                                                       GLint64 *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetBufferParameteri64v,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::BufferTargetARB, target),
          GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked                            = PackParam<BufferBinding>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetBufferParameteri64v(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getBufferParameteri64v(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetBufferParameteri64v, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetBufferParameterivContextANGLE(GLeglContext ctx,
                                                     GLenum target,
                                                     GLenum pname,
                                                     GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetBufferParameteriv,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::BufferTargetARB, target),
          GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked                            = PackParam<BufferBinding>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetBufferParameteriv(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getBufferParameteriv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetBufferParameteriv, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetBufferPointervContextANGLE(GLeglContext ctx,
                                                  GLenum target,
                                                  GLenum pname,
                                                  void **params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetBufferPointerv,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::BufferTargetARB, target),
          GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked                            = PackParam<BufferBinding>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetBufferPointerv(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getBufferPointerv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetBufferPointerv, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetBufferPointervOESContextANGLE(GLeglContext ctx,
                                                     GLenum target,
                                                     GLenum pname,
                                                     void **params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetBufferPointervOES,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::BufferTargetARB, target),
          GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked                            = PackParam<BufferBinding>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetBufferPointervOES(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getBufferPointerv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetBufferPointervOES, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetClipPlanefContextANGLE(GLeglContext ctx, GLenum plane, GLfloat *equation)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetClipPlanef, "context = %d, plane = %s, equation = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::ClipPlaneName, plane), (uintptr_t)equation);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetClipPlanef(context, plane, equation));
        if (isCallValid)
        {
            context->getClipPlanef(plane, equation);
        }
        ANGLE_CAPTURE(GetClipPlanef, isCallValid, context, plane, equation);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetClipPlanexContextANGLE(GLeglContext ctx, GLenum plane, GLfixed *equation)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetClipPlanex, "context = %d, plane = %s, equation = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::ClipPlaneName, plane), (uintptr_t)equation);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetClipPlanex(context, plane, equation));
        if (isCallValid)
        {
            context->getClipPlanex(plane, equation);
        }
        ANGLE_CAPTURE(GetClipPlanex, isCallValid, context, plane, equation);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

GLuint GL_APIENTRY GL_GetDebugMessageLogContextANGLE(GLeglContext ctx,
                                                     GLuint count,
                                                     GLsizei bufSize,
                                                     GLenum *sources,
                                                     GLenum *types,
                                                     GLuint *ids,
                                                     GLenum *severities,
                                                     GLsizei *lengths,
                                                     GLchar *messageLog)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetDebugMessageLog,
          "context = %d, count = %u, bufSize = %d, sources = 0x%016" PRIxPTR
          ", types = 0x%016" PRIxPTR ", ids = 0x%016" PRIxPTR ", severities = 0x%016" PRIxPTR
          ", lengths = 0x%016" PRIxPTR ", messageLog = 0x%016" PRIxPTR "",
          CID(context), count, bufSize, (uintptr_t)sources, (uintptr_t)types, (uintptr_t)ids,
          (uintptr_t)severities, (uintptr_t)lengths, (uintptr_t)messageLog);

    GLuint returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetDebugMessageLog(context, count, bufSize, sources, types, ids,
                                                       severities, lengths, messageLog));
        if (isCallValid)
        {
            returnValue = context->getDebugMessageLog(count, bufSize, sources, types, ids,
                                                      severities, lengths, messageLog);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetDebugMessageLog, GLuint>();
        }
        ANGLE_CAPTURE(GetDebugMessageLog, isCallValid, context, count, bufSize, sources, types, ids,
                      severities, lengths, messageLog, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetDebugMessageLog, GLuint>();
    }
    return returnValue;
}

GLuint GL_APIENTRY GL_GetDebugMessageLogKHRContextANGLE(GLeglContext ctx,
                                                        GLuint count,
                                                        GLsizei bufSize,
                                                        GLenum *sources,
                                                        GLenum *types,
                                                        GLuint *ids,
                                                        GLenum *severities,
                                                        GLsizei *lengths,
                                                        GLchar *messageLog)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetDebugMessageLogKHR,
          "context = %d, count = %u, bufSize = %d, sources = 0x%016" PRIxPTR
          ", types = 0x%016" PRIxPTR ", ids = 0x%016" PRIxPTR ", severities = 0x%016" PRIxPTR
          ", lengths = 0x%016" PRIxPTR ", messageLog = 0x%016" PRIxPTR "",
          CID(context), count, bufSize, (uintptr_t)sources, (uintptr_t)types, (uintptr_t)ids,
          (uintptr_t)severities, (uintptr_t)lengths, (uintptr_t)messageLog);

    GLuint returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetDebugMessageLogKHR(context, count, bufSize, sources, types,
                                                          ids, severities, lengths, messageLog));
        if (isCallValid)
        {
            returnValue = context->getDebugMessageLog(count, bufSize, sources, types, ids,
                                                      severities, lengths, messageLog);
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLGetDebugMessageLogKHR, GLuint>();
        }
        ANGLE_CAPTURE(GetDebugMessageLogKHR, isCallValid, context, count, bufSize, sources, types,
                      ids, severities, lengths, messageLog, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetDebugMessageLogKHR, GLuint>();
    }
    return returnValue;
}

GLenum GL_APIENTRY GL_GetErrorContextANGLE(GLeglContext ctx)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetError, "context = %d", CID(context));

    GLenum returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateGetError(context));
        if (isCallValid)
        {
            returnValue = context->getError();
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetError, GLenum>();
        }
        ANGLE_CAPTURE(GetError, isCallValid, context, returnValue);
    }
    else
    {

        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetError, GLenum>();
    }
    return returnValue;
}

void GL_APIENTRY GL_GetFenceivNVContextANGLE(GLeglContext ctx,
                                             GLuint fence,
                                             GLenum pname,
                                             GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetFenceivNV,
          "context = %d, fence = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context), fence,
          GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        FenceNVID fencePacked                                 = PackParam<FenceNVID>(fence);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetFenceivNV(context, fencePacked, pname, params));
        if (isCallValid)
        {
            context->getFenceivNV(fencePacked, pname, params);
        }
        ANGLE_CAPTURE(GetFenceivNV, isCallValid, context, fencePacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetFixedvContextANGLE(GLeglContext ctx, GLenum pname, GLfixed *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetFixedv, "context = %d, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::GetPName, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateGetFixedv(context, pname, params));
        if (isCallValid)
        {
            context->getFixedv(pname, params);
        }
        ANGLE_CAPTURE(GetFixedv, isCallValid, context, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetFloatvContextANGLE(GLeglContext ctx, GLenum pname, GLfloat *data)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetFloatv, "context = %d, pname = %s, data = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::GetPName, pname), (uintptr_t)data);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateGetFloatv(context, pname, data));
        if (isCallValid)
        {
            context->getFloatv(pname, data);
        }
        ANGLE_CAPTURE(GetFloatv, isCallValid, context, pname, data);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

GLint GL_APIENTRY GL_GetFragDataIndexEXTContextANGLE(GLeglContext ctx,
                                                     GLuint program,
                                                     const GLchar *name)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetFragDataIndexEXT, "context = %d, program = %u, name = 0x%016" PRIxPTR "",
          CID(context), program, (uintptr_t)name);

    GLint returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetFragDataIndexEXT(context, programPacked, name));
        if (isCallValid)
        {
            returnValue = context->getFragDataIndex(programPacked, name);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetFragDataIndexEXT, GLint>();
        }
        ANGLE_CAPTURE(GetFragDataIndexEXT, isCallValid, context, programPacked, name, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetFragDataIndexEXT, GLint>();
    }
    return returnValue;
}

GLint GL_APIENTRY GL_GetFragDataLocationContextANGLE(GLeglContext ctx,
                                                     GLuint program,
                                                     const GLchar *name)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetFragDataLocation, "context = %d, program = %u, name = 0x%016" PRIxPTR "",
          CID(context), program, (uintptr_t)name);

    GLint returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetFragDataLocation(context, programPacked, name));
        if (isCallValid)
        {
            returnValue = context->getFragDataLocation(programPacked, name);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetFragDataLocation, GLint>();
        }
        ANGLE_CAPTURE(GetFragDataLocation, isCallValid, context, programPacked, name, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetFragDataLocation, GLint>();
    }
    return returnValue;
}

void GL_APIENTRY GL_GetFramebufferAttachmentParameterivContextANGLE(GLeglContext ctx,
                                                                    GLenum target,
                                                                    GLenum attachment,
                                                                    GLenum pname,
                                                                    GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetFramebufferAttachmentParameteriv,
          "context = %d, target = %s, attachment = %s, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment),
          GLenumToString(GLenumGroup::FramebufferAttachmentParameterName, pname),
          (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetFramebufferAttachmentParameteriv(
                                              context, target, attachment, pname, params));
        if (isCallValid)
        {
            context->getFramebufferAttachmentParameteriv(target, attachment, pname, params);
        }
        ANGLE_CAPTURE(GetFramebufferAttachmentParameteriv, isCallValid, context, target, attachment,
                      pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetFramebufferAttachmentParameterivOESContextANGLE(GLeglContext ctx,
                                                                       GLenum target,
                                                                       GLenum attachment,
                                                                       GLenum pname,
                                                                       GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetFramebufferAttachmentParameterivOES,
          "context = %d, target = %s, attachment = %s, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment),
          GLenumToString(GLenumGroup::FramebufferAttachmentParameterName, pname),
          (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetFramebufferAttachmentParameterivOES(
                                              context, target, attachment, pname, params));
        if (isCallValid)
        {
            context->getFramebufferAttachmentParameteriv(target, attachment, pname, params);
        }
        ANGLE_CAPTURE(GetFramebufferAttachmentParameterivOES, isCallValid, context, target,
                      attachment, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetFramebufferParameterivContextANGLE(GLeglContext ctx,
                                                          GLenum target,
                                                          GLenum pname,
                                                          GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetFramebufferParameteriv,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachmentParameterName, pname),
          (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetFramebufferParameteriv(context, target, pname, params));
        if (isCallValid)
        {
            context->getFramebufferParameteriv(target, pname, params);
        }
        ANGLE_CAPTURE(GetFramebufferParameteriv, isCallValid, context, target, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

GLenum GL_APIENTRY GL_GetGraphicsResetStatusContextANGLE(GLeglContext ctx)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetGraphicsResetStatus, "context = %d", CID(context));

    GLenum returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateGetGraphicsResetStatus(context));
        if (isCallValid)
        {
            returnValue = context->getGraphicsResetStatus();
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLGetGraphicsResetStatus, GLenum>();
        }
        ANGLE_CAPTURE(GetGraphicsResetStatus, isCallValid, context, returnValue);
    }
    else
    {

        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetGraphicsResetStatus, GLenum>();
    }
    return returnValue;
}

GLenum GL_APIENTRY GL_GetGraphicsResetStatusEXTContextANGLE(GLeglContext ctx)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetGraphicsResetStatusEXT, "context = %d", CID(context));

    GLenum returnValue;
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetGraphicsResetStatusEXT(context));
        if (isCallValid)
        {
            returnValue = context->getGraphicsResetStatus();
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLGetGraphicsResetStatusEXT, GLenum>();
        }
        ANGLE_CAPTURE(GetGraphicsResetStatusEXT, isCallValid, context, returnValue);
    }
    else
    {

        returnValue =
            GetDefaultReturnValue<angle::EntryPoint::GLGetGraphicsResetStatusEXT, GLenum>();
    }
    return returnValue;
}

void GL_APIENTRY GL_GetInteger64i_vContextANGLE(GLeglContext ctx,
                                                GLenum target,
                                                GLuint index,
                                                GLint64 *data)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetInteger64i_v,
          "context = %d, target = %s, index = %u, data = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TypeEnum, target), index, (uintptr_t)data);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetInteger64i_v(context, target, index, data));
        if (isCallValid)
        {
            context->getInteger64i_v(target, index, data);
        }
        ANGLE_CAPTURE(GetInteger64i_v, isCallValid, context, target, index, data);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetInteger64vContextANGLE(GLeglContext ctx, GLenum pname, GLint64 *data)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetInteger64v, "context = %d, pname = %s, data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::GetPName, pname), (uintptr_t)data);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetInteger64v(context, pname, data));
        if (isCallValid)
        {
            context->getInteger64v(pname, data);
        }
        ANGLE_CAPTURE(GetInteger64v, isCallValid, context, pname, data);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetInteger64vEXTContextANGLE(GLeglContext ctx, GLenum pname, GLint64 *data)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetInteger64vEXT, "context = %d, pname = %s, data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::GetPName, pname), (uintptr_t)data);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetInteger64vEXT(context, pname, data));
        if (isCallValid)
        {
            context->getInteger64v(pname, data);
        }
        ANGLE_CAPTURE(GetInteger64vEXT, isCallValid, context, pname, data);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetIntegeri_vContextANGLE(GLeglContext ctx,
                                              GLenum target,
                                              GLuint index,
                                              GLint *data)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetIntegeri_v,
          "context = %d, target = %s, index = %u, data = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TypeEnum, target), index, (uintptr_t)data);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetIntegeri_v(context, target, index, data));
        if (isCallValid)
        {
            context->getIntegeri_v(target, index, data);
        }
        ANGLE_CAPTURE(GetIntegeri_v, isCallValid, context, target, index, data);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetIntegervContextANGLE(GLeglContext ctx, GLenum pname, GLint *data)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetIntegerv, "context = %d, pname = %s, data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::GetPName, pname), (uintptr_t)data);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateGetIntegerv(context, pname, data));
        if (isCallValid)
        {
            context->getIntegerv(pname, data);
        }
        ANGLE_CAPTURE(GetIntegerv, isCallValid, context, pname, data);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetInternalformativContextANGLE(GLeglContext ctx,
                                                    GLenum target,
                                                    GLenum internalformat,
                                                    GLenum pname,
                                                    GLsizei bufSize,
                                                    GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetInternalformativ,
          "context = %d, target = %s, internalformat = %s, pname = %s, bufSize = %d, params = "
          "0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::InternalFormat, internalformat),
          GLenumToString(GLenumGroup::InternalFormatPName, pname), bufSize, (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetInternalformativ(context, target, internalformat, pname, bufSize, params));
        if (isCallValid)
        {
            context->getInternalformativ(target, internalformat, pname, bufSize, params);
        }
        ANGLE_CAPTURE(GetInternalformativ, isCallValid, context, target, internalformat, pname,
                      bufSize, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetLightfvContextANGLE(GLeglContext ctx,
                                           GLenum light,
                                           GLenum pname,
                                           GLfloat *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetLightfv, "context = %d, light = %s, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::LightName, light),
          GLenumToString(GLenumGroup::LightParameter, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        LightParameter pnamePacked                            = PackParam<LightParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetLightfv(context, light, pnamePacked, params));
        if (isCallValid)
        {
            context->getLightfv(light, pnamePacked, params);
        }
        ANGLE_CAPTURE(GetLightfv, isCallValid, context, light, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetLightxvContextANGLE(GLeglContext ctx,
                                           GLenum light,
                                           GLenum pname,
                                           GLfixed *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetLightxv, "context = %d, light = %s, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::LightName, light),
          GLenumToString(GLenumGroup::LightParameter, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        LightParameter pnamePacked                            = PackParam<LightParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetLightxv(context, light, pnamePacked, params));
        if (isCallValid)
        {
            context->getLightxv(light, pnamePacked, params);
        }
        ANGLE_CAPTURE(GetLightxv, isCallValid, context, light, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetMaterialfvContextANGLE(GLeglContext ctx,
                                              GLenum face,
                                              GLenum pname,
                                              GLfloat *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetMaterialfv,
          "context = %d, face = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::MaterialFace, face),
          GLenumToString(GLenumGroup::MaterialParameter, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        MaterialParameter pnamePacked                         = PackParam<MaterialParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetMaterialfv(context, face, pnamePacked, params));
        if (isCallValid)
        {
            context->getMaterialfv(face, pnamePacked, params);
        }
        ANGLE_CAPTURE(GetMaterialfv, isCallValid, context, face, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetMaterialxvContextANGLE(GLeglContext ctx,
                                              GLenum face,
                                              GLenum pname,
                                              GLfixed *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetMaterialxv,
          "context = %d, face = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::MaterialFace, face),
          GLenumToString(GLenumGroup::MaterialParameter, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        MaterialParameter pnamePacked                         = PackParam<MaterialParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetMaterialxv(context, face, pnamePacked, params));
        if (isCallValid)
        {
            context->getMaterialxv(face, pnamePacked, params);
        }
        ANGLE_CAPTURE(GetMaterialxv, isCallValid, context, face, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetMemoryObjectParameterivEXTContextANGLE(GLeglContext ctx,
                                                              GLuint memoryObject,
                                                              GLenum pname,
                                                              GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetMemoryObjectParameterivEXT,
          "context = %d, memoryObject = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          memoryObject, GLenumToString(GLenumGroup::MemoryObjectParameterName, pname),
          (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        MemoryObjectID memoryObjectPacked = PackParam<MemoryObjectID>(memoryObject);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetMemoryObjectParameterivEXT(context, memoryObjectPacked, pname, params));
        if (isCallValid)
        {
            context->getMemoryObjectParameteriv(memoryObjectPacked, pname, params);
        }
        ANGLE_CAPTURE(GetMemoryObjectParameterivEXT, isCallValid, context, memoryObjectPacked,
                      pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetMultisamplefvContextANGLE(GLeglContext ctx,
                                                 GLenum pname,
                                                 GLuint index,
                                                 GLfloat *val)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetMultisamplefv,
          "context = %d, pname = %s, index = %u, val = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::DefaultGroup, pname), index, (uintptr_t)val);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetMultisamplefv(context, pname, index, val));
        if (isCallValid)
        {
            context->getMultisamplefv(pname, index, val);
        }
        ANGLE_CAPTURE(GetMultisamplefv, isCallValid, context, pname, index, val);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetObjectLabelContextANGLE(GLeglContext ctx,
                                               GLenum identifier,
                                               GLuint name,
                                               GLsizei bufSize,
                                               GLsizei *length,
                                               GLchar *label)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetObjectLabel,
          "context = %d, identifier = %s, name = %u, bufSize = %d, length = 0x%016" PRIxPTR
          ", label = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, identifier), name, bufSize,
          (uintptr_t)length, (uintptr_t)label);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetObjectLabel(context, identifier, name, bufSize, length, label));
        if (isCallValid)
        {
            context->getObjectLabel(identifier, name, bufSize, length, label);
        }
        ANGLE_CAPTURE(GetObjectLabel, isCallValid, context, identifier, name, bufSize, length,
                      label);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetObjectLabelEXTContextANGLE(GLeglContext ctx,
                                                  GLenum type,
                                                  GLuint object,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLchar *label)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetObjectLabelEXT,
          "context = %d, type = %s, object = %u, bufSize = %d, length = 0x%016" PRIxPTR
          ", label = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, type), object, bufSize,
          (uintptr_t)length, (uintptr_t)label);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetObjectLabelEXT(context, type, object, bufSize, length, label));
        if (isCallValid)
        {
            context->getObjectLabel(type, object, bufSize, length, label);
        }
        ANGLE_CAPTURE(GetObjectLabelEXT, isCallValid, context, type, object, bufSize, length,
                      label);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetObjectLabelKHRContextANGLE(GLeglContext ctx,
                                                  GLenum identifier,
                                                  GLuint name,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLchar *label)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetObjectLabelKHR,
          "context = %d, identifier = %s, name = %u, bufSize = %d, length = 0x%016" PRIxPTR
          ", label = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, identifier), name, bufSize,
          (uintptr_t)length, (uintptr_t)label);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetObjectLabelKHR(context, identifier, name, bufSize, length, label));
        if (isCallValid)
        {
            context->getObjectLabel(identifier, name, bufSize, length, label);
        }
        ANGLE_CAPTURE(GetObjectLabelKHR, isCallValid, context, identifier, name, bufSize, length,
                      label);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetObjectPtrLabelContextANGLE(GLeglContext ctx,
                                                  const void *ptr,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLchar *label)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetObjectPtrLabel,
          "context = %d, ptr = 0x%016" PRIxPTR ", bufSize = %d, length = 0x%016" PRIxPTR
          ", label = 0x%016" PRIxPTR "",
          CID(context), (uintptr_t)ptr, bufSize, (uintptr_t)length, (uintptr_t)label);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetObjectPtrLabel(context, ptr, bufSize, length, label));
        if (isCallValid)
        {
            context->getObjectPtrLabel(ptr, bufSize, length, label);
        }
        ANGLE_CAPTURE(GetObjectPtrLabel, isCallValid, context, ptr, bufSize, length, label);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetObjectPtrLabelKHRContextANGLE(GLeglContext ctx,
                                                     const void *ptr,
                                                     GLsizei bufSize,
                                                     GLsizei *length,
                                                     GLchar *label)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetObjectPtrLabelKHR,
          "context = %d, ptr = 0x%016" PRIxPTR ", bufSize = %d, length = 0x%016" PRIxPTR
          ", label = 0x%016" PRIxPTR "",
          CID(context), (uintptr_t)ptr, bufSize, (uintptr_t)length, (uintptr_t)label);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetObjectPtrLabelKHR(context, ptr, bufSize, length, label));
        if (isCallValid)
        {
            context->getObjectPtrLabel(ptr, bufSize, length, label);
        }
        ANGLE_CAPTURE(GetObjectPtrLabelKHR, isCallValid, context, ptr, bufSize, length, label);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetPointervContextANGLE(GLeglContext ctx, GLenum pname, void **params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetPointerv, "context = %d, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::GetPointervPName, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetPointerv(context, pname, params));
        if (isCallValid)
        {
            context->getPointerv(pname, params);
        }
        ANGLE_CAPTURE(GetPointerv, isCallValid, context, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetPointervKHRContextANGLE(GLeglContext ctx, GLenum pname, void **params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetPointervKHR, "context = %d, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetPointervKHR(context, pname, params));
        if (isCallValid)
        {
            context->getPointerv(pname, params);
        }
        ANGLE_CAPTURE(GetPointervKHR, isCallValid, context, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetProgramBinaryContextANGLE(GLeglContext ctx,
                                                 GLuint program,
                                                 GLsizei bufSize,
                                                 GLsizei *length,
                                                 GLenum *binaryFormat,
                                                 void *binary)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetProgramBinary,
          "context = %d, program = %u, bufSize = %d, length = 0x%016" PRIxPTR
          ", binaryFormat = 0x%016" PRIxPTR ", binary = 0x%016" PRIxPTR "",
          CID(context), program, bufSize, (uintptr_t)length, (uintptr_t)binaryFormat,
          (uintptr_t)binary);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetProgramBinary(context, programPacked, bufSize,
                                                                   length, binaryFormat, binary));
        if (isCallValid)
        {
            context->getProgramBinary(programPacked, bufSize, length, binaryFormat, binary);
        }
        ANGLE_CAPTURE(GetProgramBinary, isCallValid, context, programPacked, bufSize, length,
                      binaryFormat, binary);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetProgramBinaryOESContextANGLE(GLeglContext ctx,
                                                    GLuint program,
                                                    GLsizei bufSize,
                                                    GLsizei *length,
                                                    GLenum *binaryFormat,
                                                    void *binary)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetProgramBinaryOES,
          "context = %d, program = %u, bufSize = %d, length = 0x%016" PRIxPTR
          ", binaryFormat = 0x%016" PRIxPTR ", binary = 0x%016" PRIxPTR "",
          CID(context), program, bufSize, (uintptr_t)length, (uintptr_t)binaryFormat,
          (uintptr_t)binary);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetProgramBinaryOES(context, programPacked, bufSize, length,
                                                        binaryFormat, binary));
        if (isCallValid)
        {
            context->getProgramBinary(programPacked, bufSize, length, binaryFormat, binary);
        }
        ANGLE_CAPTURE(GetProgramBinaryOES, isCallValid, context, programPacked, bufSize, length,
                      binaryFormat, binary);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetProgramInfoLogContextANGLE(GLeglContext ctx,
                                                  GLuint program,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLchar *infoLog)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetProgramInfoLog,
          "context = %d, program = %u, bufSize = %d, length = 0x%016" PRIxPTR
          ", infoLog = 0x%016" PRIxPTR "",
          CID(context), program, bufSize, (uintptr_t)length, (uintptr_t)infoLog);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetProgramInfoLog(context, programPacked, bufSize, length, infoLog));
        if (isCallValid)
        {
            context->getProgramInfoLog(programPacked, bufSize, length, infoLog);
        }
        ANGLE_CAPTURE(GetProgramInfoLog, isCallValid, context, programPacked, bufSize, length,
                      infoLog);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetProgramInterfaceivContextANGLE(GLeglContext ctx,
                                                      GLuint program,
                                                      GLenum programInterface,
                                                      GLenum pname,
                                                      GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetProgramInterfaceiv,
          "context = %d, program = %u, programInterface = %s, pname = %s, params = 0x%016" PRIxPTR
          "",
          CID(context), program, GLenumToString(GLenumGroup::ProgramInterface, programInterface),
          GLenumToString(GLenumGroup::ProgramInterfacePName, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetProgramInterfaceiv(context, programPacked, programInterface,
                                                          pname, params));
        if (isCallValid)
        {
            context->getProgramInterfaceiv(programPacked, programInterface, pname, params);
        }
        ANGLE_CAPTURE(GetProgramInterfaceiv, isCallValid, context, programPacked, programInterface,
                      pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetProgramPipelineInfoLogContextANGLE(GLeglContext ctx,
                                                          GLuint pipeline,
                                                          GLsizei bufSize,
                                                          GLsizei *length,
                                                          GLchar *infoLog)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetProgramPipelineInfoLog,
          "context = %d, pipeline = %u, bufSize = %d, length = 0x%016" PRIxPTR
          ", infoLog = 0x%016" PRIxPTR "",
          CID(context), pipeline, bufSize, (uintptr_t)length, (uintptr_t)infoLog);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ProgramPipelineID pipelinePacked = PackParam<ProgramPipelineID>(pipeline);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetProgramPipelineInfoLog(context, pipelinePacked, bufSize, length, infoLog));
        if (isCallValid)
        {
            context->getProgramPipelineInfoLog(pipelinePacked, bufSize, length, infoLog);
        }
        ANGLE_CAPTURE(GetProgramPipelineInfoLog, isCallValid, context, pipelinePacked, bufSize,
                      length, infoLog);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetProgramPipelineInfoLogEXTContextANGLE(GLeglContext ctx,
                                                             GLuint pipeline,
                                                             GLsizei bufSize,
                                                             GLsizei *length,
                                                             GLchar *infoLog)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetProgramPipelineInfoLogEXT,
          "context = %d, pipeline = %u, bufSize = %d, length = 0x%016" PRIxPTR
          ", infoLog = 0x%016" PRIxPTR "",
          CID(context), pipeline, bufSize, (uintptr_t)length, (uintptr_t)infoLog);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ProgramPipelineID pipelinePacked = PackParam<ProgramPipelineID>(pipeline);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetProgramPipelineInfoLogEXT(
                                              context, pipelinePacked, bufSize, length, infoLog));
        if (isCallValid)
        {
            context->getProgramPipelineInfoLog(pipelinePacked, bufSize, length, infoLog);
        }
        ANGLE_CAPTURE(GetProgramPipelineInfoLogEXT, isCallValid, context, pipelinePacked, bufSize,
                      length, infoLog);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetProgramPipelineivContextANGLE(GLeglContext ctx,
                                                     GLuint pipeline,
                                                     GLenum pname,
                                                     GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetProgramPipelineiv,
          "context = %d, pipeline = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          pipeline, GLenumToString(GLenumGroup::PipelineParameterName, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ProgramPipelineID pipelinePacked = PackParam<ProgramPipelineID>(pipeline);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetProgramPipelineiv(context, pipelinePacked, pname, params));
        if (isCallValid)
        {
            context->getProgramPipelineiv(pipelinePacked, pname, params);
        }
        ANGLE_CAPTURE(GetProgramPipelineiv, isCallValid, context, pipelinePacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetProgramPipelineivEXTContextANGLE(GLeglContext ctx,
                                                        GLuint pipeline,
                                                        GLenum pname,
                                                        GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetProgramPipelineivEXT,
          "context = %d, pipeline = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          pipeline, GLenumToString(GLenumGroup::PipelineParameterName, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ProgramPipelineID pipelinePacked = PackParam<ProgramPipelineID>(pipeline);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetProgramPipelineivEXT(context, pipelinePacked, pname, params));
        if (isCallValid)
        {
            context->getProgramPipelineiv(pipelinePacked, pname, params);
        }
        ANGLE_CAPTURE(GetProgramPipelineivEXT, isCallValid, context, pipelinePacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

GLuint GL_APIENTRY GL_GetProgramResourceIndexContextANGLE(GLeglContext ctx,
                                                          GLuint program,
                                                          GLenum programInterface,
                                                          const GLchar *name)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetProgramResourceIndex,
          "context = %d, program = %u, programInterface = %s, name = 0x%016" PRIxPTR "",
          CID(context), program, GLenumToString(GLenumGroup::ProgramInterface, programInterface),
          (uintptr_t)name);

    GLuint returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetProgramResourceIndex(context, programPacked, programInterface, name));
        if (isCallValid)
        {
            returnValue = context->getProgramResourceIndex(programPacked, programInterface, name);
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLGetProgramResourceIndex, GLuint>();
        }
        ANGLE_CAPTURE(GetProgramResourceIndex, isCallValid, context, programPacked,
                      programInterface, name, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetProgramResourceIndex, GLuint>();
    }
    return returnValue;
}

GLint GL_APIENTRY GL_GetProgramResourceLocationContextANGLE(GLeglContext ctx,
                                                            GLuint program,
                                                            GLenum programInterface,
                                                            const GLchar *name)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetProgramResourceLocation,
          "context = %d, program = %u, programInterface = %s, name = 0x%016" PRIxPTR "",
          CID(context), program, GLenumToString(GLenumGroup::ProgramInterface, programInterface),
          (uintptr_t)name);

    GLint returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetProgramResourceLocation(context, programPacked, programInterface, name));
        if (isCallValid)
        {
            returnValue =
                context->getProgramResourceLocation(programPacked, programInterface, name);
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLGetProgramResourceLocation, GLint>();
        }
        ANGLE_CAPTURE(GetProgramResourceLocation, isCallValid, context, programPacked,
                      programInterface, name, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue =
            GetDefaultReturnValue<angle::EntryPoint::GLGetProgramResourceLocation, GLint>();
    }
    return returnValue;
}

GLint GL_APIENTRY GL_GetProgramResourceLocationIndexEXTContextANGLE(GLeglContext ctx,
                                                                    GLuint program,
                                                                    GLenum programInterface,
                                                                    const GLchar *name)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetProgramResourceLocationIndexEXT,
          "context = %d, program = %u, programInterface = %s, name = 0x%016" PRIxPTR "",
          CID(context), program, GLenumToString(GLenumGroup::ProgramInterface, programInterface),
          (uintptr_t)name);

    GLint returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetProgramResourceLocationIndexEXT(
                                              context, programPacked, programInterface, name));
        if (isCallValid)
        {
            returnValue =
                context->getProgramResourceLocationIndex(programPacked, programInterface, name);
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLGetProgramResourceLocationIndexEXT,
                                      GLint>();
        }
        ANGLE_CAPTURE(GetProgramResourceLocationIndexEXT, isCallValid, context, programPacked,
                      programInterface, name, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue =
            GetDefaultReturnValue<angle::EntryPoint::GLGetProgramResourceLocationIndexEXT, GLint>();
    }
    return returnValue;
}

void GL_APIENTRY GL_GetProgramResourceNameContextANGLE(GLeglContext ctx,
                                                       GLuint program,
                                                       GLenum programInterface,
                                                       GLuint index,
                                                       GLsizei bufSize,
                                                       GLsizei *length,
                                                       GLchar *name)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetProgramResourceName,
          "context = %d, program = %u, programInterface = %s, index = %u, bufSize = %d, length = "
          "0x%016" PRIxPTR ", name = 0x%016" PRIxPTR "",
          CID(context), program, GLenumToString(GLenumGroup::ProgramInterface, programInterface),
          index, bufSize, (uintptr_t)length, (uintptr_t)name);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetProgramResourceName(context, programPacked, programInterface,
                                                           index, bufSize, length, name));
        if (isCallValid)
        {
            context->getProgramResourceName(programPacked, programInterface, index, bufSize, length,
                                            name);
        }
        ANGLE_CAPTURE(GetProgramResourceName, isCallValid, context, programPacked, programInterface,
                      index, bufSize, length, name);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetProgramResourceivContextANGLE(GLeglContext ctx,
                                                     GLuint program,
                                                     GLenum programInterface,
                                                     GLuint index,
                                                     GLsizei propCount,
                                                     const GLenum *props,
                                                     GLsizei bufSize,
                                                     GLsizei *length,
                                                     GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetProgramResourceiv,
          "context = %d, program = %u, programInterface = %s, index = %u, propCount = %d, props = "
          "0x%016" PRIxPTR ", bufSize = %d, length = 0x%016" PRIxPTR ", params = 0x%016" PRIxPTR "",
          CID(context), program, GLenumToString(GLenumGroup::ProgramInterface, programInterface),
          index, propCount, (uintptr_t)props, bufSize, (uintptr_t)length, (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetProgramResourceiv(context, programPacked, programInterface, index,
                                          propCount, props, bufSize, length, params));
        if (isCallValid)
        {
            context->getProgramResourceiv(programPacked, programInterface, index, propCount, props,
                                          bufSize, length, params);
        }
        ANGLE_CAPTURE(GetProgramResourceiv, isCallValid, context, programPacked, programInterface,
                      index, propCount, props, bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetProgramivContextANGLE(GLeglContext ctx,
                                             GLuint program,
                                             GLenum pname,
                                             GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetProgramiv,
          "context = %d, program = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          program, GLenumToString(GLenumGroup::ProgramPropertyARB, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetProgramiv(context, programPacked, pname, params));
        if (isCallValid)
        {
            context->getProgramiv(programPacked, pname, params);
        }
        ANGLE_CAPTURE(GetProgramiv, isCallValid, context, programPacked, pname, params);
    }
    else
    {}
}

void GL_APIENTRY GL_GetQueryObjecti64vEXTContextANGLE(GLeglContext ctx,
                                                      GLuint id,
                                                      GLenum pname,
                                                      GLint64 *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetQueryObjecti64vEXT,
          "context = %d, id = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context), id,
          GLenumToString(GLenumGroup::QueryObjectParameterName, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        QueryID idPacked                                      = PackParam<QueryID>(id);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetQueryObjecti64vEXT(context, idPacked, pname, params));
        if (isCallValid)
        {
            context->getQueryObjecti64v(idPacked, pname, params);
        }
        ANGLE_CAPTURE(GetQueryObjecti64vEXT, isCallValid, context, idPacked, pname, params);
    }
    else
    {}
}

void GL_APIENTRY GL_GetQueryObjectivEXTContextANGLE(GLeglContext ctx,
                                                    GLuint id,
                                                    GLenum pname,
                                                    GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetQueryObjectivEXT,
          "context = %d, id = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context), id,
          GLenumToString(GLenumGroup::QueryObjectParameterName, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        QueryID idPacked                                      = PackParam<QueryID>(id);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetQueryObjectivEXT(context, idPacked, pname, params));
        if (isCallValid)
        {
            context->getQueryObjectiv(idPacked, pname, params);
        }
        ANGLE_CAPTURE(GetQueryObjectivEXT, isCallValid, context, idPacked, pname, params);
    }
    else
    {}
}

void GL_APIENTRY GL_GetQueryObjectui64vEXTContextANGLE(GLeglContext ctx,
                                                       GLuint id,
                                                       GLenum pname,
                                                       GLuint64 *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetQueryObjectui64vEXT,
          "context = %d, id = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context), id,
          GLenumToString(GLenumGroup::QueryObjectParameterName, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        QueryID idPacked                                      = PackParam<QueryID>(id);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetQueryObjectui64vEXT(context, idPacked, pname, params));
        if (isCallValid)
        {
            context->getQueryObjectui64v(idPacked, pname, params);
        }
        ANGLE_CAPTURE(GetQueryObjectui64vEXT, isCallValid, context, idPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetQueryObjectuivContextANGLE(GLeglContext ctx,
                                                  GLuint id,
                                                  GLenum pname,
                                                  GLuint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetQueryObjectuiv,
          "context = %d, id = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context), id,
          GLenumToString(GLenumGroup::QueryObjectParameterName, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        QueryID idPacked                                      = PackParam<QueryID>(id);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetQueryObjectuiv(context, idPacked, pname, params));
        if (isCallValid)
        {
            context->getQueryObjectuiv(idPacked, pname, params);
        }
        ANGLE_CAPTURE(GetQueryObjectuiv, isCallValid, context, idPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetQueryObjectuivEXTContextANGLE(GLeglContext ctx,
                                                     GLuint id,
                                                     GLenum pname,
                                                     GLuint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetQueryObjectuivEXT,
          "context = %d, id = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context), id,
          GLenumToString(GLenumGroup::QueryObjectParameterName, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        QueryID idPacked                                      = PackParam<QueryID>(id);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetQueryObjectuivEXT(context, idPacked, pname, params));
        if (isCallValid)
        {
            context->getQueryObjectuiv(idPacked, pname, params);
        }
        ANGLE_CAPTURE(GetQueryObjectuivEXT, isCallValid, context, idPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetQueryivContextANGLE(GLeglContext ctx,
                                           GLenum target,
                                           GLenum pname,
                                           GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetQueryiv,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::QueryTarget, target),
          GLenumToString(GLenumGroup::QueryParameterName, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        QueryType targetPacked                                = PackParam<QueryType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetQueryiv(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getQueryiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetQueryiv, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetQueryivEXTContextANGLE(GLeglContext ctx,
                                              GLenum target,
                                              GLenum pname,
                                              GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetQueryivEXT,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::QueryTarget, target),
          GLenumToString(GLenumGroup::QueryParameterName, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        QueryType targetPacked                                = PackParam<QueryType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetQueryivEXT(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getQueryiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetQueryivEXT, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetRenderbufferParameterivContextANGLE(GLeglContext ctx,
                                                           GLenum target,
                                                           GLenum pname,
                                                           GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetRenderbufferParameteriv,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::RenderbufferTarget, target),
          GLenumToString(GLenumGroup::RenderbufferParameterName, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetRenderbufferParameteriv(context, target, pname, params));
        if (isCallValid)
        {
            context->getRenderbufferParameteriv(target, pname, params);
        }
        ANGLE_CAPTURE(GetRenderbufferParameteriv, isCallValid, context, target, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetRenderbufferParameterivOESContextANGLE(GLeglContext ctx,
                                                              GLenum target,
                                                              GLenum pname,
                                                              GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetRenderbufferParameterivOES,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::RenderbufferTarget, target),
          GLenumToString(GLenumGroup::RenderbufferParameterName, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetRenderbufferParameterivOES(context, target, pname, params));
        if (isCallValid)
        {
            context->getRenderbufferParameteriv(target, pname, params);
        }
        ANGLE_CAPTURE(GetRenderbufferParameterivOES, isCallValid, context, target, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetSamplerParameterIivContextANGLE(GLeglContext ctx,
                                                       GLuint sampler,
                                                       GLenum pname,
                                                       GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetSamplerParameterIiv,
          "context = %d, sampler = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        SamplerID samplerPacked                               = PackParam<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetSamplerParameterIiv(context, samplerPacked, pname, params));
        if (isCallValid)
        {
            context->getSamplerParameterIiv(samplerPacked, pname, params);
        }
        ANGLE_CAPTURE(GetSamplerParameterIiv, isCallValid, context, samplerPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetSamplerParameterIivEXTContextANGLE(GLeglContext ctx,
                                                          GLuint sampler,
                                                          GLenum pname,
                                                          GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetSamplerParameterIivEXT,
          "context = %d, sampler = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        SamplerID samplerPacked                               = PackParam<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetSamplerParameterIivEXT(context, samplerPacked, pname, params));
        if (isCallValid)
        {
            context->getSamplerParameterIiv(samplerPacked, pname, params);
        }
        ANGLE_CAPTURE(GetSamplerParameterIivEXT, isCallValid, context, samplerPacked, pname,
                      params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetSamplerParameterIivOESContextANGLE(GLeglContext ctx,
                                                          GLuint sampler,
                                                          GLenum pname,
                                                          GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetSamplerParameterIivOES,
          "context = %d, sampler = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        SamplerID samplerPacked                               = PackParam<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetSamplerParameterIivOES(context, samplerPacked, pname, params));
        if (isCallValid)
        {
            context->getSamplerParameterIiv(samplerPacked, pname, params);
        }
        ANGLE_CAPTURE(GetSamplerParameterIivOES, isCallValid, context, samplerPacked, pname,
                      params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetSamplerParameterIuivContextANGLE(GLeglContext ctx,
                                                        GLuint sampler,
                                                        GLenum pname,
                                                        GLuint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetSamplerParameterIuiv,
          "context = %d, sampler = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        SamplerID samplerPacked                               = PackParam<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetSamplerParameterIuiv(context, samplerPacked, pname, params));
        if (isCallValid)
        {
            context->getSamplerParameterIuiv(samplerPacked, pname, params);
        }
        ANGLE_CAPTURE(GetSamplerParameterIuiv, isCallValid, context, samplerPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetSamplerParameterIuivEXTContextANGLE(GLeglContext ctx,
                                                           GLuint sampler,
                                                           GLenum pname,
                                                           GLuint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetSamplerParameterIuivEXT,
          "context = %d, sampler = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        SamplerID samplerPacked                               = PackParam<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetSamplerParameterIuivEXT(context, samplerPacked, pname, params));
        if (isCallValid)
        {
            context->getSamplerParameterIuiv(samplerPacked, pname, params);
        }
        ANGLE_CAPTURE(GetSamplerParameterIuivEXT, isCallValid, context, samplerPacked, pname,
                      params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetSamplerParameterIuivOESContextANGLE(GLeglContext ctx,
                                                           GLuint sampler,
                                                           GLenum pname,
                                                           GLuint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetSamplerParameterIuivOES,
          "context = %d, sampler = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        SamplerID samplerPacked                               = PackParam<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetSamplerParameterIuivOES(context, samplerPacked, pname, params));
        if (isCallValid)
        {
            context->getSamplerParameterIuiv(samplerPacked, pname, params);
        }
        ANGLE_CAPTURE(GetSamplerParameterIuivOES, isCallValid, context, samplerPacked, pname,
                      params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetSamplerParameterfvContextANGLE(GLeglContext ctx,
                                                      GLuint sampler,
                                                      GLenum pname,
                                                      GLfloat *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetSamplerParameterfv,
          "context = %d, sampler = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        SamplerID samplerPacked                               = PackParam<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetSamplerParameterfv(context, samplerPacked, pname, params));
        if (isCallValid)
        {
            context->getSamplerParameterfv(samplerPacked, pname, params);
        }
        ANGLE_CAPTURE(GetSamplerParameterfv, isCallValid, context, samplerPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetSamplerParameterivContextANGLE(GLeglContext ctx,
                                                      GLuint sampler,
                                                      GLenum pname,
                                                      GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetSamplerParameteriv,
          "context = %d, sampler = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        SamplerID samplerPacked                               = PackParam<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetSamplerParameteriv(context, samplerPacked, pname, params));
        if (isCallValid)
        {
            context->getSamplerParameteriv(samplerPacked, pname, params);
        }
        ANGLE_CAPTURE(GetSamplerParameteriv, isCallValid, context, samplerPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetSemaphoreParameterui64vEXTContextANGLE(GLeglContext ctx,
                                                              GLuint semaphore,
                                                              GLenum pname,
                                                              GLuint64 *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetSemaphoreParameterui64vEXT,
          "context = %d, semaphore = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          semaphore, GLenumToString(GLenumGroup::SemaphoreParameterName, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        SemaphoreID semaphorePacked                           = PackParam<SemaphoreID>(semaphore);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetSemaphoreParameterui64vEXT(context, semaphorePacked, pname, params));
        if (isCallValid)
        {
            context->getSemaphoreParameterui64v(semaphorePacked, pname, params);
        }
        ANGLE_CAPTURE(GetSemaphoreParameterui64vEXT, isCallValid, context, semaphorePacked, pname,
                      params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetShaderInfoLogContextANGLE(GLeglContext ctx,
                                                 GLuint shader,
                                                 GLsizei bufSize,
                                                 GLsizei *length,
                                                 GLchar *infoLog)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetShaderInfoLog,
          "context = %d, shader = %u, bufSize = %d, length = 0x%016" PRIxPTR
          ", infoLog = 0x%016" PRIxPTR "",
          CID(context), shader, bufSize, (uintptr_t)length, (uintptr_t)infoLog);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID shaderPacked                          = PackParam<ShaderProgramID>(shader);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetShaderInfoLog(context, shaderPacked, bufSize, length, infoLog));
        if (isCallValid)
        {
            context->getShaderInfoLog(shaderPacked, bufSize, length, infoLog);
        }
        ANGLE_CAPTURE(GetShaderInfoLog, isCallValid, context, shaderPacked, bufSize, length,
                      infoLog);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetShaderPrecisionFormatContextANGLE(GLeglContext ctx,
                                                         GLenum shadertype,
                                                         GLenum precisiontype,
                                                         GLint *range,
                                                         GLint *precision)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetShaderPrecisionFormat,
          "context = %d, shadertype = %s, precisiontype = %s, range = 0x%016" PRIxPTR
          ", precision = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::ShaderType, shadertype),
          GLenumToString(GLenumGroup::PrecisionType, precisiontype), (uintptr_t)range,
          (uintptr_t)precision);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetShaderPrecisionFormat(context, shadertype, precisiontype,
                                                             range, precision));
        if (isCallValid)
        {
            context->getShaderPrecisionFormat(shadertype, precisiontype, range, precision);
        }
        ANGLE_CAPTURE(GetShaderPrecisionFormat, isCallValid, context, shadertype, precisiontype,
                      range, precision);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetShaderSourceContextANGLE(GLeglContext ctx,
                                                GLuint shader,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLchar *source)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetShaderSource,
          "context = %d, shader = %u, bufSize = %d, length = 0x%016" PRIxPTR
          ", source = 0x%016" PRIxPTR "",
          CID(context), shader, bufSize, (uintptr_t)length, (uintptr_t)source);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID shaderPacked                          = PackParam<ShaderProgramID>(shader);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetShaderSource(context, shaderPacked, bufSize, length, source));
        if (isCallValid)
        {
            context->getShaderSource(shaderPacked, bufSize, length, source);
        }
        ANGLE_CAPTURE(GetShaderSource, isCallValid, context, shaderPacked, bufSize, length, source);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetShaderivContextANGLE(GLeglContext ctx,
                                            GLuint shader,
                                            GLenum pname,
                                            GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetShaderiv,
          "context = %d, shader = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context), shader,
          GLenumToString(GLenumGroup::ShaderParameterName, pname), (uintptr_t)params);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID shaderPacked                          = PackParam<ShaderProgramID>(shader);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetShaderiv(context, shaderPacked, pname, params));
        if (isCallValid)
        {
            context->getShaderiv(shaderPacked, pname, params);
        }
        ANGLE_CAPTURE(GetShaderiv, isCallValid, context, shaderPacked, pname, params);
    }
    else
    {}
}

const GLubyte *GL_APIENTRY GL_GetStringContextANGLE(GLeglContext ctx, GLenum name)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetString, "context = %d, name = %s", CID(context),
          GLenumToString(GLenumGroup::StringName, name));

    const GLubyte *returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateGetString(context, name));
        if (isCallValid)
        {
            returnValue = context->getString(name);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetString, const GLubyte *>();
        }
        ANGLE_CAPTURE(GetString, isCallValid, context, name, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetString, const GLubyte *>();
    }
    return returnValue;
}

const GLubyte *GL_APIENTRY GL_GetStringiContextANGLE(GLeglContext ctx, GLenum name, GLuint index)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetStringi, "context = %d, name = %s, index = %u", CID(context),
          GLenumToString(GLenumGroup::StringName, name), index);

    const GLubyte *returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateGetStringi(context, name, index));
        if (isCallValid)
        {
            returnValue = context->getStringi(name, index);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetStringi, const GLubyte *>();
        }
        ANGLE_CAPTURE(GetStringi, isCallValid, context, name, index, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetStringi, const GLubyte *>();
    }
    return returnValue;
}

void GL_APIENTRY GL_GetSyncivContextANGLE(GLeglContext ctx,
                                          GLsync sync,
                                          GLenum pname,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLint *values)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetSynciv,
          "context = %d, sync = 0x%016" PRIxPTR
          ", pname = %s, bufSize = %d, length = 0x%016" PRIxPTR ", values = 0x%016" PRIxPTR "",
          CID(context), (uintptr_t)sync, GLenumToString(GLenumGroup::SyncParameterName, pname),
          bufSize, (uintptr_t)length, (uintptr_t)values);

    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetSynciv(context, sync, pname, bufSize, length, values));
        if (isCallValid)
        {
            context->getSynciv(sync, pname, bufSize, length, values);
        }
        ANGLE_CAPTURE(GetSynciv, isCallValid, context, sync, pname, bufSize, length, values);
    }
    else
    {}
}

void GL_APIENTRY GL_GetTexEnvfvContextANGLE(GLeglContext ctx,
                                            GLenum target,
                                            GLenum pname,
                                            GLfloat *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetTexEnvfv,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureEnvTarget, target),
          GLenumToString(GLenumGroup::TextureEnvParameter, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TextureEnvTarget targetPacked   = PackParam<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = PackParam<TextureEnvParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetTexEnvfv(context, targetPacked, pnamePacked, params));
        if (isCallValid)
        {
            context->getTexEnvfv(targetPacked, pnamePacked, params);
        }
        ANGLE_CAPTURE(GetTexEnvfv, isCallValid, context, targetPacked, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetTexEnvivContextANGLE(GLeglContext ctx,
                                            GLenum target,
                                            GLenum pname,
                                            GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetTexEnviv,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureEnvTarget, target),
          GLenumToString(GLenumGroup::TextureEnvParameter, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TextureEnvTarget targetPacked   = PackParam<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = PackParam<TextureEnvParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetTexEnviv(context, targetPacked, pnamePacked, params));
        if (isCallValid)
        {
            context->getTexEnviv(targetPacked, pnamePacked, params);
        }
        ANGLE_CAPTURE(GetTexEnviv, isCallValid, context, targetPacked, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetTexEnvxvContextANGLE(GLeglContext ctx,
                                            GLenum target,
                                            GLenum pname,
                                            GLfixed *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetTexEnvxv,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureEnvTarget, target),
          GLenumToString(GLenumGroup::TextureEnvParameter, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TextureEnvTarget targetPacked   = PackParam<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = PackParam<TextureEnvParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetTexEnvxv(context, targetPacked, pnamePacked, params));
        if (isCallValid)
        {
            context->getTexEnvxv(targetPacked, pnamePacked, params);
        }
        ANGLE_CAPTURE(GetTexEnvxv, isCallValid, context, targetPacked, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetTexGenfvOESContextANGLE(GLeglContext ctx,
                                               GLenum coord,
                                               GLenum pname,
                                               GLfloat *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetTexGenfvOES,
          "context = %d, coord = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureCoordName, coord),
          GLenumToString(GLenumGroup::TextureGenParameter, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetTexGenfvOES(context, coord, pname, params));
        if (isCallValid)
        {
            context->getTexGenfv(coord, pname, params);
        }
        ANGLE_CAPTURE(GetTexGenfvOES, isCallValid, context, coord, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetTexGenivOESContextANGLE(GLeglContext ctx,
                                               GLenum coord,
                                               GLenum pname,
                                               GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetTexGenivOES,
          "context = %d, coord = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureCoordName, coord),
          GLenumToString(GLenumGroup::TextureGenParameter, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetTexGenivOES(context, coord, pname, params));
        if (isCallValid)
        {
            context->getTexGeniv(coord, pname, params);
        }
        ANGLE_CAPTURE(GetTexGenivOES, isCallValid, context, coord, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetTexGenxvOESContextANGLE(GLeglContext ctx,
                                               GLenum coord,
                                               GLenum pname,
                                               GLfixed *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetTexGenxvOES,
          "context = %d, coord = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureCoordName, coord),
          GLenumToString(GLenumGroup::TextureGenParameter, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetTexGenxvOES(context, coord, pname, params));
        if (isCallValid)
        {
            context->getTexGenxv(coord, pname, params);
        }
        ANGLE_CAPTURE(GetTexGenxvOES, isCallValid, context, coord, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetTexLevelParameterfvContextANGLE(GLeglContext ctx,
                                                       GLenum target,
                                                       GLint level,
                                                       GLenum pname,
                                                       GLfloat *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetTexLevelParameterfv,
          "context = %d, target = %s, level = %d, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level,
          GLenumToString(GLenumGroup::GetTextureParameter, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetTexLevelParameterfv(context, targetPacked, level, pname, params));
        if (isCallValid)
        {
            context->getTexLevelParameterfv(targetPacked, level, pname, params);
        }
        ANGLE_CAPTURE(GetTexLevelParameterfv, isCallValid, context, targetPacked, level, pname,
                      params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetTexLevelParameterivContextANGLE(GLeglContext ctx,
                                                       GLenum target,
                                                       GLint level,
                                                       GLenum pname,
                                                       GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetTexLevelParameteriv,
          "context = %d, target = %s, level = %d, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), level,
          GLenumToString(GLenumGroup::GetTextureParameter, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked                            = PackParam<TextureTarget>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetTexLevelParameteriv(context, targetPacked, level, pname, params));
        if (isCallValid)
        {
            context->getTexLevelParameteriv(targetPacked, level, pname, params);
        }
        ANGLE_CAPTURE(GetTexLevelParameteriv, isCallValid, context, targetPacked, level, pname,
                      params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetTexParameterIivContextANGLE(GLeglContext ctx,
                                                   GLenum target,
                                                   GLenum pname,
                                                   GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetTexParameterIiv,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::GetTextureParameter, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                              = PackParam<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetTexParameterIiv(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getTexParameterIiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetTexParameterIiv, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetTexParameterIivEXTContextANGLE(GLeglContext ctx,
                                                      GLenum target,
                                                      GLenum pname,
                                                      GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetTexParameterIivEXT,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::GetTextureParameter, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                              = PackParam<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetTexParameterIivEXT(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getTexParameterIiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetTexParameterIivEXT, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetTexParameterIivOESContextANGLE(GLeglContext ctx,
                                                      GLenum target,
                                                      GLenum pname,
                                                      GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetTexParameterIivOES,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::GetTextureParameter, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                              = PackParam<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetTexParameterIivOES(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getTexParameterIiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetTexParameterIivOES, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetTexParameterIuivContextANGLE(GLeglContext ctx,
                                                    GLenum target,
                                                    GLenum pname,
                                                    GLuint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetTexParameterIuiv,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::GetTextureParameter, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                              = PackParam<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetTexParameterIuiv(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getTexParameterIuiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetTexParameterIuiv, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetTexParameterIuivEXTContextANGLE(GLeglContext ctx,
                                                       GLenum target,
                                                       GLenum pname,
                                                       GLuint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetTexParameterIuivEXT,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::GetTextureParameter, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                              = PackParam<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetTexParameterIuivEXT(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getTexParameterIuiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetTexParameterIuivEXT, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetTexParameterIuivOESContextANGLE(GLeglContext ctx,
                                                       GLenum target,
                                                       GLenum pname,
                                                       GLuint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetTexParameterIuivOES,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::GetTextureParameter, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                              = PackParam<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetTexParameterIuivOES(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getTexParameterIuiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetTexParameterIuivOES, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetTexParameterfvContextANGLE(GLeglContext ctx,
                                                  GLenum target,
                                                  GLenum pname,
                                                  GLfloat *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetTexParameterfv,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::GetTextureParameter, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                              = PackParam<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetTexParameterfv(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getTexParameterfv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetTexParameterfv, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetTexParameterivContextANGLE(GLeglContext ctx,
                                                  GLenum target,
                                                  GLenum pname,
                                                  GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetTexParameteriv,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::GetTextureParameter, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                              = PackParam<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetTexParameteriv(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getTexParameteriv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetTexParameteriv, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetTexParameterxvContextANGLE(GLeglContext ctx,
                                                  GLenum target,
                                                  GLenum pname,
                                                  GLfixed *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetTexParameterxv,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::GetTextureParameter, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked                              = PackParam<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetTexParameterxv(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getTexParameterxv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetTexParameterxv, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetTransformFeedbackVaryingContextANGLE(GLeglContext ctx,
                                                            GLuint program,
                                                            GLuint index,
                                                            GLsizei bufSize,
                                                            GLsizei *length,
                                                            GLsizei *size,
                                                            GLenum *type,
                                                            GLchar *name)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetTransformFeedbackVarying,
          "context = %d, program = %u, index = %u, bufSize = %d, length = 0x%016" PRIxPTR
          ", size = 0x%016" PRIxPTR ", type = 0x%016" PRIxPTR ", name = 0x%016" PRIxPTR "",
          CID(context), program, index, bufSize, (uintptr_t)length, (uintptr_t)size,
          (uintptr_t)type, (uintptr_t)name);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetTransformFeedbackVarying(context, programPacked, index,
                                                                bufSize, length, size, type, name));
        if (isCallValid)
        {
            context->getTransformFeedbackVarying(programPacked, index, bufSize, length, size, type,
                                                 name);
        }
        ANGLE_CAPTURE(GetTransformFeedbackVarying, isCallValid, context, programPacked, index,
                      bufSize, length, size, type, name);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetTranslatedShaderSourceANGLEContextANGLE(GLeglContext ctx,
                                                               GLuint shader,
                                                               GLsizei bufsize,
                                                               GLsizei *length,
                                                               GLchar *source)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetTranslatedShaderSourceANGLE,
          "context = %d, shader = %u, bufsize = %d, length = 0x%016" PRIxPTR
          ", source = 0x%016" PRIxPTR "",
          CID(context), shader, bufsize, (uintptr_t)length, (uintptr_t)source);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID shaderPacked                          = PackParam<ShaderProgramID>(shader);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetTranslatedShaderSourceANGLE(
                                              context, shaderPacked, bufsize, length, source));
        if (isCallValid)
        {
            context->getTranslatedShaderSource(shaderPacked, bufsize, length, source);
        }
        ANGLE_CAPTURE(GetTranslatedShaderSourceANGLE, isCallValid, context, shaderPacked, bufsize,
                      length, source);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

GLuint GL_APIENTRY GL_GetUniformBlockIndexContextANGLE(GLeglContext ctx,
                                                       GLuint program,
                                                       const GLchar *uniformBlockName)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetUniformBlockIndex,
          "context = %d, program = %u, uniformBlockName = 0x%016" PRIxPTR "", CID(context), program,
          (uintptr_t)uniformBlockName);

    GLuint returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetUniformBlockIndex(context, programPacked, uniformBlockName));
        if (isCallValid)
        {
            returnValue = context->getUniformBlockIndex(programPacked, uniformBlockName);
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLGetUniformBlockIndex, GLuint>();
        }
        ANGLE_CAPTURE(GetUniformBlockIndex, isCallValid, context, programPacked, uniformBlockName,
                      returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetUniformBlockIndex, GLuint>();
    }
    return returnValue;
}

void GL_APIENTRY GL_GetUniformIndicesContextANGLE(GLeglContext ctx,
                                                  GLuint program,
                                                  GLsizei uniformCount,
                                                  const GLchar *const *uniformNames,
                                                  GLuint *uniformIndices)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetUniformIndices,
          "context = %d, program = %u, uniformCount = %d, uniformNames = 0x%016" PRIxPTR
          ", uniformIndices = 0x%016" PRIxPTR "",
          CID(context), program, uniformCount, (uintptr_t)uniformNames, (uintptr_t)uniformIndices);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetUniformIndices(context, programPacked, uniformCount,
                                                      uniformNames, uniformIndices));
        if (isCallValid)
        {
            context->getUniformIndices(programPacked, uniformCount, uniformNames, uniformIndices);
        }
        ANGLE_CAPTURE(GetUniformIndices, isCallValid, context, programPacked, uniformCount,
                      uniformNames, uniformIndices);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

GLint GL_APIENTRY GL_GetUniformLocationContextANGLE(GLeglContext ctx,
                                                    GLuint program,
                                                    const GLchar *name)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetUniformLocation, "context = %d, program = %u, name = 0x%016" PRIxPTR "",
          CID(context), program, (uintptr_t)name);

    GLint returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetUniformLocation(context, programPacked, name));
        if (isCallValid)
        {
            returnValue = context->getUniformLocation(programPacked, name);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetUniformLocation, GLint>();
        }
        ANGLE_CAPTURE(GetUniformLocation, isCallValid, context, programPacked, name, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetUniformLocation, GLint>();
    }
    return returnValue;
}

void GL_APIENTRY GL_GetUniformfvContextANGLE(GLeglContext ctx,
                                             GLuint program,
                                             GLint location,
                                             GLfloat *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetUniformfv,
          "context = %d, program = %u, location = %d, params = 0x%016" PRIxPTR "", CID(context),
          program, location, (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetUniformfv(context, programPacked, locationPacked, params));
        if (isCallValid)
        {
            context->getUniformfv(programPacked, locationPacked, params);
        }
        ANGLE_CAPTURE(GetUniformfv, isCallValid, context, programPacked, locationPacked, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetUniformivContextANGLE(GLeglContext ctx,
                                             GLuint program,
                                             GLint location,
                                             GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetUniformiv,
          "context = %d, program = %u, location = %d, params = 0x%016" PRIxPTR "", CID(context),
          program, location, (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetUniformiv(context, programPacked, locationPacked, params));
        if (isCallValid)
        {
            context->getUniformiv(programPacked, locationPacked, params);
        }
        ANGLE_CAPTURE(GetUniformiv, isCallValid, context, programPacked, locationPacked, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetUniformuivContextANGLE(GLeglContext ctx,
                                              GLuint program,
                                              GLint location,
                                              GLuint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetUniformuiv,
          "context = %d, program = %u, location = %d, params = 0x%016" PRIxPTR "", CID(context),
          program, location, (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetUniformuiv(context, programPacked, locationPacked, params));
        if (isCallValid)
        {
            context->getUniformuiv(programPacked, locationPacked, params);
        }
        ANGLE_CAPTURE(GetUniformuiv, isCallValid, context, programPacked, locationPacked, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetUnsignedBytevEXTContextANGLE(GLeglContext ctx, GLenum pname, GLubyte *data)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetUnsignedBytevEXT, "context = %d, pname = %s, data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::GetPName, pname), (uintptr_t)data);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetUnsignedBytevEXT(context, pname, data));
        if (isCallValid)
        {
            context->getUnsignedBytev(pname, data);
        }
        ANGLE_CAPTURE(GetUnsignedBytevEXT, isCallValid, context, pname, data);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetUnsignedBytei_vEXTContextANGLE(GLeglContext ctx,
                                                      GLenum target,
                                                      GLuint index,
                                                      GLubyte *data)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetUnsignedBytei_vEXT,
          "context = %d, target = %s, index = %u, data = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::DefaultGroup, target), index, (uintptr_t)data);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetUnsignedBytei_vEXT(context, target, index, data));
        if (isCallValid)
        {
            context->getUnsignedBytei_v(target, index, data);
        }
        ANGLE_CAPTURE(GetUnsignedBytei_vEXT, isCallValid, context, target, index, data);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetVertexAttribIivContextANGLE(GLeglContext ctx,
                                                   GLuint index,
                                                   GLenum pname,
                                                   GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetVertexAttribIiv,
          "context = %d, index = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context), index,
          GLenumToString(GLenumGroup::VertexAttribEnum, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetVertexAttribIiv(context, index, pname, params));
        if (isCallValid)
        {
            context->getVertexAttribIiv(index, pname, params);
        }
        ANGLE_CAPTURE(GetVertexAttribIiv, isCallValid, context, index, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetVertexAttribIuivContextANGLE(GLeglContext ctx,
                                                    GLuint index,
                                                    GLenum pname,
                                                    GLuint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetVertexAttribIuiv,
          "context = %d, index = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context), index,
          GLenumToString(GLenumGroup::VertexAttribEnum, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetVertexAttribIuiv(context, index, pname, params));
        if (isCallValid)
        {
            context->getVertexAttribIuiv(index, pname, params);
        }
        ANGLE_CAPTURE(GetVertexAttribIuiv, isCallValid, context, index, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetVertexAttribPointervContextANGLE(GLeglContext ctx,
                                                        GLuint index,
                                                        GLenum pname,
                                                        void **pointer)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetVertexAttribPointerv,
          "context = %d, index = %u, pname = %s, pointer = 0x%016" PRIxPTR "", CID(context), index,
          GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)pointer);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetVertexAttribPointerv(context, index, pname, pointer));
        if (isCallValid)
        {
            context->getVertexAttribPointerv(index, pname, pointer);
        }
        ANGLE_CAPTURE(GetVertexAttribPointerv, isCallValid, context, index, pname, pointer);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetVertexAttribfvContextANGLE(GLeglContext ctx,
                                                  GLuint index,
                                                  GLenum pname,
                                                  GLfloat *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetVertexAttribfv,
          "context = %d, index = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context), index,
          GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetVertexAttribfv(context, index, pname, params));
        if (isCallValid)
        {
            context->getVertexAttribfv(index, pname, params);
        }
        ANGLE_CAPTURE(GetVertexAttribfv, isCallValid, context, index, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetVertexAttribivContextANGLE(GLeglContext ctx,
                                                  GLuint index,
                                                  GLenum pname,
                                                  GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetVertexAttribiv,
          "context = %d, index = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context), index,
          GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetVertexAttribiv(context, index, pname, params));
        if (isCallValid)
        {
            context->getVertexAttribiv(index, pname, params);
        }
        ANGLE_CAPTURE(GetVertexAttribiv, isCallValid, context, index, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetnUniformfvContextANGLE(GLeglContext ctx,
                                              GLuint program,
                                              GLint location,
                                              GLsizei bufSize,
                                              GLfloat *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetnUniformfv,
          "context = %d, program = %u, location = %d, bufSize = %d, params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetnUniformfv(context, programPacked, locationPacked, bufSize, params));
        if (isCallValid)
        {
            context->getnUniformfv(programPacked, locationPacked, bufSize, params);
        }
        ANGLE_CAPTURE(GetnUniformfv, isCallValid, context, programPacked, locationPacked, bufSize,
                      params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetnUniformfvEXTContextANGLE(GLeglContext ctx,
                                                 GLuint program,
                                                 GLint location,
                                                 GLsizei bufSize,
                                                 GLfloat *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetnUniformfvEXT,
          "context = %d, program = %u, location = %d, bufSize = %d, params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetnUniformfvEXT(context, programPacked, locationPacked, bufSize, params));
        if (isCallValid)
        {
            context->getnUniformfv(programPacked, locationPacked, bufSize, params);
        }
        ANGLE_CAPTURE(GetnUniformfvEXT, isCallValid, context, programPacked, locationPacked,
                      bufSize, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetnUniformivContextANGLE(GLeglContext ctx,
                                              GLuint program,
                                              GLint location,
                                              GLsizei bufSize,
                                              GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetnUniformiv,
          "context = %d, program = %u, location = %d, bufSize = %d, params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetnUniformiv(context, programPacked, locationPacked, bufSize, params));
        if (isCallValid)
        {
            context->getnUniformiv(programPacked, locationPacked, bufSize, params);
        }
        ANGLE_CAPTURE(GetnUniformiv, isCallValid, context, programPacked, locationPacked, bufSize,
                      params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetnUniformivEXTContextANGLE(GLeglContext ctx,
                                                 GLuint program,
                                                 GLint location,
                                                 GLsizei bufSize,
                                                 GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetnUniformivEXT,
          "context = %d, program = %u, location = %d, bufSize = %d, params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetnUniformivEXT(context, programPacked, locationPacked, bufSize, params));
        if (isCallValid)
        {
            context->getnUniformiv(programPacked, locationPacked, bufSize, params);
        }
        ANGLE_CAPTURE(GetnUniformivEXT, isCallValid, context, programPacked, locationPacked,
                      bufSize, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_GetnUniformuivContextANGLE(GLeglContext ctx,
                                               GLuint program,
                                               GLint location,
                                               GLsizei bufSize,
                                               GLuint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLGetnUniformuiv,
          "context = %d, program = %u, location = %d, bufSize = %d, params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetnUniformuiv(context, programPacked, locationPacked, bufSize, params));
        if (isCallValid)
        {
            context->getnUniformuiv(programPacked, locationPacked, bufSize, params);
        }
        ANGLE_CAPTURE(GetnUniformuiv, isCallValid, context, programPacked, locationPacked, bufSize,
                      params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_HintContextANGLE(GLeglContext ctx, GLenum target, GLenum mode)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLHint, "context = %d, target = %s, mode = %s", CID(context),
          GLenumToString(GLenumGroup::HintTarget, target),
          GLenumToString(GLenumGroup::HintMode, mode));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateHint(context, target, mode));
        if (isCallValid)
        {
            context->hint(target, mode);
        }
        ANGLE_CAPTURE(Hint, isCallValid, context, target, mode);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_ImportMemoryFdEXTContextANGLE(GLeglContext ctx,
                                                  GLuint memory,
                                                  GLuint64 size,
                                                  GLenum handleType,
                                                  GLint fd)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLImportMemoryFdEXT,
          "context = %d, memory = %u, size = %llu, handleType = %s, fd = %d", CID(context), memory,
          static_cast<unsigned long long>(size),
          GLenumToString(GLenumGroup::ExternalHandleType, handleType), fd);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        MemoryObjectID memoryPacked                           = PackParam<MemoryObjectID>(memory);
        HandleType handleTypePacked                           = PackParam<HandleType>(handleType);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateImportMemoryFdEXT(context, memoryPacked, size, handleTypePacked, fd));
        if (isCallValid)
        {
            context->importMemoryFd(memoryPacked, size, handleTypePacked, fd);
        }
        ANGLE_CAPTURE(ImportMemoryFdEXT, isCallValid, context, memoryPacked, size, handleTypePacked,
                      fd);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_ImportSemaphoreFdEXTContextANGLE(GLeglContext ctx,
                                                     GLuint semaphore,
                                                     GLenum handleType,
                                                     GLint fd)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLImportSemaphoreFdEXT, "context = %d, semaphore = %u, handleType = %s, fd = %d",
          CID(context), semaphore, GLenumToString(GLenumGroup::ExternalHandleType, handleType), fd);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        SemaphoreID semaphorePacked                           = PackParam<SemaphoreID>(semaphore);
        HandleType handleTypePacked                           = PackParam<HandleType>(handleType);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateImportSemaphoreFdEXT(context, semaphorePacked, handleTypePacked, fd));
        if (isCallValid)
        {
            context->importSemaphoreFd(semaphorePacked, handleTypePacked, fd);
        }
        ANGLE_CAPTURE(ImportSemaphoreFdEXT, isCallValid, context, semaphorePacked, handleTypePacked,
                      fd);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_InsertEventMarkerEXTContextANGLE(GLeglContext ctx,
                                                     GLsizei length,
                                                     const GLchar *marker)
{
    Context *context = static_cast<gl::Context *>(ctx);
    // Don't run the EVENT() macro on the EXT_debug_marker entry points.
    // It can interfere with the debug events being set by the caller.
    // EVENT(context, GLInsertEventMarkerEXT, "context = %d, length = %d, marker = 0x%016" PRIxPTR
    // "", CID(context), length, (uintptr_t)marker);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateInsertEventMarkerEXT(context, length, marker));
        if (isCallValid)
        {
            context->insertEventMarker(length, marker);
        }
        ANGLE_CAPTURE(InsertEventMarkerEXT, isCallValid, context, length, marker);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_InvalidateFramebufferContextANGLE(GLeglContext ctx,
                                                      GLenum target,
                                                      GLsizei numAttachments,
                                                      const GLenum *attachments)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLInvalidateFramebuffer,
          "context = %d, target = %s, numAttachments = %d, attachments = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::FramebufferTarget, target), numAttachments,
          (uintptr_t)attachments);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateInvalidateFramebuffer(context, target, numAttachments, attachments));
        if (isCallValid)
        {
            context->invalidateFramebuffer(target, numAttachments, attachments);
        }
        ANGLE_CAPTURE(InvalidateFramebuffer, isCallValid, context, target, numAttachments,
                      attachments);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_InvalidateSubFramebufferContextANGLE(GLeglContext ctx,
                                                         GLenum target,
                                                         GLsizei numAttachments,
                                                         const GLenum *attachments,
                                                         GLint x,
                                                         GLint y,
                                                         GLsizei width,
                                                         GLsizei height)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLInvalidateSubFramebuffer,
          "context = %d, target = %s, numAttachments = %d, attachments = 0x%016" PRIxPTR
          ", x = %d, y = %d, width = %d, height = %d",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target), numAttachments,
          (uintptr_t)attachments, x, y, width, height);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateInvalidateSubFramebuffer(context, target, numAttachments,
                                                             attachments, x, y, width, height));
        if (isCallValid)
        {
            context->invalidateSubFramebuffer(target, numAttachments, attachments, x, y, width,
                                              height);
        }
        ANGLE_CAPTURE(InvalidateSubFramebuffer, isCallValid, context, target, numAttachments,
                      attachments, x, y, width, height);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

GLboolean GL_APIENTRY GL_IsBufferContextANGLE(GLeglContext ctx, GLuint buffer)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLIsBuffer, "context = %d, buffer = %u", CID(context), buffer);

    GLboolean returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        BufferID bufferPacked                                 = PackParam<BufferID>(buffer);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateIsBuffer(context, bufferPacked));
        if (isCallValid)
        {
            returnValue = context->isBuffer(bufferPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsBuffer, GLboolean>();
        }
        ANGLE_CAPTURE(IsBuffer, isCallValid, context, bufferPacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsBuffer, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY GL_IsEnabledContextANGLE(GLeglContext ctx, GLenum cap)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLIsEnabled, "context = %d, cap = %s", CID(context),
          GLenumToString(GLenumGroup::EnableCap, cap));

    GLboolean returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateIsEnabled(context, cap));
        if (isCallValid)
        {
            returnValue = context->isEnabled(cap);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsEnabled, GLboolean>();
        }
        ANGLE_CAPTURE(IsEnabled, isCallValid, context, cap, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsEnabled, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY GL_IsEnablediContextANGLE(GLeglContext ctx, GLenum target, GLuint index)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLIsEnabledi, "context = %d, target = %s, index = %u", CID(context),
          GLenumToString(GLenumGroup::EnableCap, target), index);

    GLboolean returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsEnabledi(context, target, index));
        if (isCallValid)
        {
            returnValue = context->isEnabledi(target, index);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsEnabledi, GLboolean>();
        }
        ANGLE_CAPTURE(IsEnabledi, isCallValid, context, target, index, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsEnabledi, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY GL_IsEnablediEXTContextANGLE(GLeglContext ctx, GLenum target, GLuint index)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLIsEnablediEXT, "context = %d, target = %s, index = %u", CID(context),
          GLenumToString(GLenumGroup::EnableCap, target), index);

    GLboolean returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsEnablediEXT(context, target, index));
        if (isCallValid)
        {
            returnValue = context->isEnabledi(target, index);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsEnablediEXT, GLboolean>();
        }
        ANGLE_CAPTURE(IsEnablediEXT, isCallValid, context, target, index, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsEnablediEXT, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY GL_IsEnablediOESContextANGLE(GLeglContext ctx, GLenum target, GLuint index)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLIsEnablediOES, "context = %d, target = %s, index = %u", CID(context),
          GLenumToString(GLenumGroup::EnableCap, target), index);

    GLboolean returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsEnablediOES(context, target, index));
        if (isCallValid)
        {
            returnValue = context->isEnabledi(target, index);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsEnablediOES, GLboolean>();
        }
        ANGLE_CAPTURE(IsEnablediOES, isCallValid, context, target, index, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsEnablediOES, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY GL_IsFenceNVContextANGLE(GLeglContext ctx, GLuint fence)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLIsFenceNV, "context = %d, fence = %u", CID(context), fence);

    GLboolean returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        FenceNVID fencePacked                                 = PackParam<FenceNVID>(fence);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateIsFenceNV(context, fencePacked));
        if (isCallValid)
        {
            returnValue = context->isFenceNV(fencePacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsFenceNV, GLboolean>();
        }
        ANGLE_CAPTURE(IsFenceNV, isCallValid, context, fencePacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsFenceNV, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY GL_IsFramebufferContextANGLE(GLeglContext ctx, GLuint framebuffer)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLIsFramebuffer, "context = %d, framebuffer = %u", CID(context), framebuffer);

    GLboolean returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        FramebufferID framebufferPacked = PackParam<FramebufferID>(framebuffer);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsFramebuffer(context, framebufferPacked));
        if (isCallValid)
        {
            returnValue = context->isFramebuffer(framebufferPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsFramebuffer, GLboolean>();
        }
        ANGLE_CAPTURE(IsFramebuffer, isCallValid, context, framebufferPacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsFramebuffer, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY GL_IsFramebufferOESContextANGLE(GLeglContext ctx, GLuint framebuffer)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLIsFramebufferOES, "context = %d, framebuffer = %u", CID(context), framebuffer);

    GLboolean returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        FramebufferID framebufferPacked = PackParam<FramebufferID>(framebuffer);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsFramebufferOES(context, framebufferPacked));
        if (isCallValid)
        {
            returnValue = context->isFramebuffer(framebufferPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsFramebufferOES, GLboolean>();
        }
        ANGLE_CAPTURE(IsFramebufferOES, isCallValid, context, framebufferPacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsFramebufferOES, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY GL_IsMemoryObjectEXTContextANGLE(GLeglContext ctx, GLuint memoryObject)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLIsMemoryObjectEXT, "context = %d, memoryObject = %u", CID(context),
          memoryObject);

    GLboolean returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        MemoryObjectID memoryObjectPacked = PackParam<MemoryObjectID>(memoryObject);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsMemoryObjectEXT(context, memoryObjectPacked));
        if (isCallValid)
        {
            returnValue = context->isMemoryObject(memoryObjectPacked);
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLIsMemoryObjectEXT, GLboolean>();
        }
        ANGLE_CAPTURE(IsMemoryObjectEXT, isCallValid, context, memoryObjectPacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsMemoryObjectEXT, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY GL_IsProgramContextANGLE(GLeglContext ctx, GLuint program)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLIsProgram, "context = %d, program = %u", CID(context), program);

    GLboolean returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateIsProgram(context, programPacked));
        if (isCallValid)
        {
            returnValue = context->isProgram(programPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsProgram, GLboolean>();
        }
        ANGLE_CAPTURE(IsProgram, isCallValid, context, programPacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsProgram, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY GL_IsProgramPipelineContextANGLE(GLeglContext ctx, GLuint pipeline)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLIsProgramPipeline, "context = %d, pipeline = %u", CID(context), pipeline);

    GLboolean returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ProgramPipelineID pipelinePacked = PackParam<ProgramPipelineID>(pipeline);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsProgramPipeline(context, pipelinePacked));
        if (isCallValid)
        {
            returnValue = context->isProgramPipeline(pipelinePacked);
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLIsProgramPipeline, GLboolean>();
        }
        ANGLE_CAPTURE(IsProgramPipeline, isCallValid, context, pipelinePacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsProgramPipeline, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY GL_IsProgramPipelineEXTContextANGLE(GLeglContext ctx, GLuint pipeline)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLIsProgramPipelineEXT, "context = %d, pipeline = %u", CID(context), pipeline);

    GLboolean returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ProgramPipelineID pipelinePacked = PackParam<ProgramPipelineID>(pipeline);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsProgramPipelineEXT(context, pipelinePacked));
        if (isCallValid)
        {
            returnValue = context->isProgramPipeline(pipelinePacked);
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLIsProgramPipelineEXT, GLboolean>();
        }
        ANGLE_CAPTURE(IsProgramPipelineEXT, isCallValid, context, pipelinePacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsProgramPipelineEXT, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY GL_IsQueryContextANGLE(GLeglContext ctx, GLuint id)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLIsQuery, "context = %d, id = %u", CID(context), id);

    GLboolean returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        QueryID idPacked                                      = PackParam<QueryID>(id);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateIsQuery(context, idPacked));
        if (isCallValid)
        {
            returnValue = context->isQuery(idPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsQuery, GLboolean>();
        }
        ANGLE_CAPTURE(IsQuery, isCallValid, context, idPacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsQuery, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY GL_IsQueryEXTContextANGLE(GLeglContext ctx, GLuint id)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLIsQueryEXT, "context = %d, id = %u", CID(context), id);

    GLboolean returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        QueryID idPacked                                      = PackParam<QueryID>(id);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateIsQueryEXT(context, idPacked));
        if (isCallValid)
        {
            returnValue = context->isQuery(idPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsQueryEXT, GLboolean>();
        }
        ANGLE_CAPTURE(IsQueryEXT, isCallValid, context, idPacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsQueryEXT, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY GL_IsRenderbufferContextANGLE(GLeglContext ctx, GLuint renderbuffer)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLIsRenderbuffer, "context = %d, renderbuffer = %u", CID(context), renderbuffer);

    GLboolean returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        RenderbufferID renderbufferPacked = PackParam<RenderbufferID>(renderbuffer);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsRenderbuffer(context, renderbufferPacked));
        if (isCallValid)
        {
            returnValue = context->isRenderbuffer(renderbufferPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsRenderbuffer, GLboolean>();
        }
        ANGLE_CAPTURE(IsRenderbuffer, isCallValid, context, renderbufferPacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsRenderbuffer, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY GL_IsRenderbufferOESContextANGLE(GLeglContext ctx, GLuint renderbuffer)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLIsRenderbufferOES, "context = %d, renderbuffer = %u", CID(context),
          renderbuffer);

    GLboolean returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        RenderbufferID renderbufferPacked = PackParam<RenderbufferID>(renderbuffer);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsRenderbufferOES(context, renderbufferPacked));
        if (isCallValid)
        {
            returnValue = context->isRenderbuffer(renderbufferPacked);
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLIsRenderbufferOES, GLboolean>();
        }
        ANGLE_CAPTURE(IsRenderbufferOES, isCallValid, context, renderbufferPacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsRenderbufferOES, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY GL_IsSemaphoreEXTContextANGLE(GLeglContext ctx, GLuint semaphore)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLIsSemaphoreEXT, "context = %d, semaphore = %u", CID(context), semaphore);

    GLboolean returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        SemaphoreID semaphorePacked                           = PackParam<SemaphoreID>(semaphore);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsSemaphoreEXT(context, semaphorePacked));
        if (isCallValid)
        {
            returnValue = context->isSemaphore(semaphorePacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsSemaphoreEXT, GLboolean>();
        }
        ANGLE_CAPTURE(IsSemaphoreEXT, isCallValid, context, semaphorePacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsSemaphoreEXT, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY GL_IsSamplerContextANGLE(GLeglContext ctx, GLuint sampler)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLIsSampler, "context = %d, sampler = %u", CID(context), sampler);

    GLboolean returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        SamplerID samplerPacked                               = PackParam<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateIsSampler(context, samplerPacked));
        if (isCallValid)
        {
            returnValue = context->isSampler(samplerPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsSampler, GLboolean>();
        }
        ANGLE_CAPTURE(IsSampler, isCallValid, context, samplerPacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsSampler, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY GL_IsShaderContextANGLE(GLeglContext ctx, GLuint shader)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLIsShader, "context = %d, shader = %u", CID(context), shader);

    GLboolean returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID shaderPacked                          = PackParam<ShaderProgramID>(shader);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateIsShader(context, shaderPacked));
        if (isCallValid)
        {
            returnValue = context->isShader(shaderPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsShader, GLboolean>();
        }
        ANGLE_CAPTURE(IsShader, isCallValid, context, shaderPacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsShader, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY GL_IsSyncContextANGLE(GLeglContext ctx, GLsync sync)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLIsSync, "context = %d, sync = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)sync);

    GLboolean returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateIsSync(context, sync));
        if (isCallValid)
        {
            returnValue = context->isSync(sync);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsSync, GLboolean>();
        }
        ANGLE_CAPTURE(IsSync, isCallValid, context, sync, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsSync, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY GL_IsTextureContextANGLE(GLeglContext ctx, GLuint texture)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLIsTexture, "context = %d, texture = %u", CID(context), texture);

    GLboolean returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TextureID texturePacked                               = PackParam<TextureID>(texture);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateIsTexture(context, texturePacked));
        if (isCallValid)
        {
            returnValue = context->isTexture(texturePacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsTexture, GLboolean>();
        }
        ANGLE_CAPTURE(IsTexture, isCallValid, context, texturePacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsTexture, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY GL_IsTransformFeedbackContextANGLE(GLeglContext ctx, GLuint id)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLIsTransformFeedback, "context = %d, id = %u", CID(context), id);

    GLboolean returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        TransformFeedbackID idPacked                          = PackParam<TransformFeedbackID>(id);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsTransformFeedback(context, idPacked));
        if (isCallValid)
        {
            returnValue = context->isTransformFeedback(idPacked);
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLIsTransformFeedback, GLboolean>();
        }
        ANGLE_CAPTURE(IsTransformFeedback, isCallValid, context, idPacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsTransformFeedback, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY GL_IsVertexArrayContextANGLE(GLeglContext ctx, GLuint array)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLIsVertexArray, "context = %d, array = %u", CID(context), array);

    GLboolean returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        VertexArrayID arrayPacked                             = PackParam<VertexArrayID>(array);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsVertexArray(context, arrayPacked));
        if (isCallValid)
        {
            returnValue = context->isVertexArray(arrayPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsVertexArray, GLboolean>();
        }
        ANGLE_CAPTURE(IsVertexArray, isCallValid, context, arrayPacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsVertexArray, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY GL_IsVertexArrayOESContextANGLE(GLeglContext ctx, GLuint array)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLIsVertexArrayOES, "context = %d, array = %u", CID(context), array);

    GLboolean returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        VertexArrayID arrayPacked                             = PackParam<VertexArrayID>(array);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsVertexArrayOES(context, arrayPacked));
        if (isCallValid)
        {
            returnValue = context->isVertexArray(arrayPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsVertexArrayOES, GLboolean>();
        }
        ANGLE_CAPTURE(IsVertexArrayOES, isCallValid, context, arrayPacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsVertexArrayOES, GLboolean>();
    }
    return returnValue;
}

void GL_APIENTRY GL_LabelObjectEXTContextANGLE(GLeglContext ctx,
                                               GLenum type,
                                               GLuint object,
                                               GLsizei length,
                                               const GLchar *label)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLLabelObjectEXT,
          "context = %d, type = %s, object = %u, length = %d, label = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, type), object, length,
          (uintptr_t)label);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateLabelObjectEXT(context, type, object, length, label));
        if (isCallValid)
        {
            context->labelObject(type, object, length, label);
        }
        ANGLE_CAPTURE(LabelObjectEXT, isCallValid, context, type, object, length, label);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_LightModelfContextANGLE(GLeglContext ctx, GLenum pname, GLfloat param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLLightModelf, "context = %d, pname = %s, param = %f", CID(context),
          GLenumToString(GLenumGroup::LightModelParameter, pname), param);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateLightModelf(context, pname, param));
        if (isCallValid)
        {
            context->lightModelf(pname, param);
        }
        ANGLE_CAPTURE(LightModelf, isCallValid, context, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_LightModelfvContextANGLE(GLeglContext ctx, GLenum pname, const GLfloat *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLLightModelfv, "context = %d, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::LightModelParameter, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateLightModelfv(context, pname, params));
        if (isCallValid)
        {
            context->lightModelfv(pname, params);
        }
        ANGLE_CAPTURE(LightModelfv, isCallValid, context, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_LightModelxContextANGLE(GLeglContext ctx, GLenum pname, GLfixed param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLLightModelx, "context = %d, pname = %s, param = 0x%X", CID(context),
          GLenumToString(GLenumGroup::LightModelParameter, pname), param);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateLightModelx(context, pname, param));
        if (isCallValid)
        {
            context->lightModelx(pname, param);
        }
        ANGLE_CAPTURE(LightModelx, isCallValid, context, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_LightModelxvContextANGLE(GLeglContext ctx, GLenum pname, const GLfixed *param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLLightModelxv, "context = %d, pname = %s, param = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::LightModelParameter, pname), (uintptr_t)param);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateLightModelxv(context, pname, param));
        if (isCallValid)
        {
            context->lightModelxv(pname, param);
        }
        ANGLE_CAPTURE(LightModelxv, isCallValid, context, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_LightfContextANGLE(GLeglContext ctx, GLenum light, GLenum pname, GLfloat param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLLightf, "context = %d, light = %s, pname = %s, param = %f", CID(context),
          GLenumToString(GLenumGroup::LightName, light),
          GLenumToString(GLenumGroup::LightParameter, pname), param);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        LightParameter pnamePacked                            = PackParam<LightParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateLightf(context, light, pnamePacked, param));
        if (isCallValid)
        {
            context->lightf(light, pnamePacked, param);
        }
        ANGLE_CAPTURE(Lightf, isCallValid, context, light, pnamePacked, param);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_LightfvContextANGLE(GLeglContext ctx,
                                        GLenum light,
                                        GLenum pname,
                                        const GLfloat *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLLightfv, "context = %d, light = %s, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::LightName, light),
          GLenumToString(GLenumGroup::LightParameter, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        LightParameter pnamePacked                            = PackParam<LightParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateLightfv(context, light, pnamePacked, params));
        if (isCallValid)
        {
            context->lightfv(light, pnamePacked, params);
        }
        ANGLE_CAPTURE(Lightfv, isCallValid, context, light, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_LightxContextANGLE(GLeglContext ctx, GLenum light, GLenum pname, GLfixed param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLLightx, "context = %d, light = %s, pname = %s, param = 0x%X", CID(context),
          GLenumToString(GLenumGroup::LightName, light),
          GLenumToString(GLenumGroup::LightParameter, pname), param);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        LightParameter pnamePacked                            = PackParam<LightParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateLightx(context, light, pnamePacked, param));
        if (isCallValid)
        {
            context->lightx(light, pnamePacked, param);
        }
        ANGLE_CAPTURE(Lightx, isCallValid, context, light, pnamePacked, param);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_LightxvContextANGLE(GLeglContext ctx,
                                        GLenum light,
                                        GLenum pname,
                                        const GLfixed *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLLightxv, "context = %d, light = %s, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::LightName, light),
          GLenumToString(GLenumGroup::LightParameter, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        LightParameter pnamePacked                            = PackParam<LightParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateLightxv(context, light, pnamePacked, params));
        if (isCallValid)
        {
            context->lightxv(light, pnamePacked, params);
        }
        ANGLE_CAPTURE(Lightxv, isCallValid, context, light, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_LineWidthContextANGLE(GLeglContext ctx, GLfloat width)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLLineWidth, "context = %d, width = %f", CID(context), width);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateLineWidth(context, width));
        if (isCallValid)
        {
            context->lineWidth(width);
        }
        ANGLE_CAPTURE(LineWidth, isCallValid, context, width);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_LineWidthxContextANGLE(GLeglContext ctx, GLfixed width)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLLineWidthx, "context = %d, width = 0x%X", CID(context), width);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateLineWidthx(context, width));
        if (isCallValid)
        {
            context->lineWidthx(width);
        }
        ANGLE_CAPTURE(LineWidthx, isCallValid, context, width);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_LinkProgramContextANGLE(GLeglContext ctx, GLuint program)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLLinkProgram, "context = %d, program = %u", CID(context), program);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateLinkProgram(context, programPacked));
        if (isCallValid)
        {
            context->linkProgram(programPacked);
        }
        ANGLE_CAPTURE(LinkProgram, isCallValid, context, programPacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_LoadIdentityContextANGLE(GLeglContext ctx)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLLoadIdentity, "context = %d", CID(context));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateLoadIdentity(context));
        if (isCallValid)
        {
            context->loadIdentity();
        }
        ANGLE_CAPTURE(LoadIdentity, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_LoadMatrixfContextANGLE(GLeglContext ctx, const GLfloat *m)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLLoadMatrixf, "context = %d, m = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)m);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateLoadMatrixf(context, m));
        if (isCallValid)
        {
            context->loadMatrixf(m);
        }
        ANGLE_CAPTURE(LoadMatrixf, isCallValid, context, m);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_LoadMatrixxContextANGLE(GLeglContext ctx, const GLfixed *m)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLLoadMatrixx, "context = %d, m = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)m);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateLoadMatrixx(context, m));
        if (isCallValid)
        {
            context->loadMatrixx(m);
        }
        ANGLE_CAPTURE(LoadMatrixx, isCallValid, context, m);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_LoadPaletteFromModelViewMatrixOESContextANGLE(GLeglContext ctx)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLLoadPaletteFromModelViewMatrixOES, "context = %d", CID(context));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateLoadPaletteFromModelViewMatrixOES(context));
        if (isCallValid)
        {
            context->loadPaletteFromModelViewMatrix();
        }
        ANGLE_CAPTURE(LoadPaletteFromModelViewMatrixOES, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_LogicOpContextANGLE(GLeglContext ctx, GLenum opcode)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLLogicOp, "context = %d, opcode = %s", CID(context),
          GLenumToString(GLenumGroup::LogicOp, opcode));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        LogicalOperation opcodePacked                         = PackParam<LogicalOperation>(opcode);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateLogicOp(context, opcodePacked));
        if (isCallValid)
        {
            context->logicOp(opcodePacked);
        }
        ANGLE_CAPTURE(LogicOp, isCallValid, context, opcodePacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void *GL_APIENTRY GL_MapBufferOESContextANGLE(GLeglContext ctx, GLenum target, GLenum access)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLMapBufferOES, "context = %d, target = %s, access = %s", CID(context),
          GLenumToString(GLenumGroup::BufferTargetARB, target),
          GLenumToString(GLenumGroup::BufferAccessARB, access));

    void *returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked                            = PackParam<BufferBinding>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateMapBufferOES(context, targetPacked, access));
        if (isCallValid)
        {
            returnValue = context->mapBuffer(targetPacked, access);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLMapBufferOES, void *>();
        }
        ANGLE_CAPTURE(MapBufferOES, isCallValid, context, targetPacked, access, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLMapBufferOES, void *>();
    }
    return returnValue;
}

void *GL_APIENTRY GL_MapBufferRangeContextANGLE(GLeglContext ctx,
                                                GLenum target,
                                                GLintptr offset,
                                                GLsizeiptr length,
                                                GLbitfield access)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLMapBufferRange,
          "context = %d, target = %s, offset = %llu, length = %llu, access = %s", CID(context),
          GLenumToString(GLenumGroup::BufferTargetARB, target),
          static_cast<unsigned long long>(offset), static_cast<unsigned long long>(length),
          GLbitfieldToString(GLenumGroup::BufferAccessMask, access).c_str());

    void *returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked                            = PackParam<BufferBinding>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateMapBufferRange(context, targetPacked, offset, length, access));
        if (isCallValid)
        {
            returnValue = context->mapBufferRange(targetPacked, offset, length, access);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLMapBufferRange, void *>();
        }
        ANGLE_CAPTURE(MapBufferRange, isCallValid, context, targetPacked, offset, length, access,
                      returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLMapBufferRange, void *>();
    }
    return returnValue;
}

void *GL_APIENTRY GL_MapBufferRangeEXTContextANGLE(GLeglContext ctx,
                                                   GLenum target,
                                                   GLintptr offset,
                                                   GLsizeiptr length,
                                                   GLbitfield access)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLMapBufferRangeEXT,
          "context = %d, target = %s, offset = %llu, length = %llu, access = %s", CID(context),
          GLenumToString(GLenumGroup::BufferTargetARB, target),
          static_cast<unsigned long long>(offset), static_cast<unsigned long long>(length),
          GLbitfieldToString(GLenumGroup::BufferAccessMask, access).c_str());

    void *returnValue;
    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked                            = PackParam<BufferBinding>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMapBufferRangeEXT(context, targetPacked, offset, length, access));
        if (isCallValid)
        {
            returnValue = context->mapBufferRange(targetPacked, offset, length, access);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLMapBufferRangeEXT, void *>();
        }
        ANGLE_CAPTURE(MapBufferRangeEXT, isCallValid, context, targetPacked, offset, length, access,
                      returnValue);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLMapBufferRangeEXT, void *>();
    }
    return returnValue;
}

void GL_APIENTRY GL_MaterialfContextANGLE(GLeglContext ctx,
                                          GLenum face,
                                          GLenum pname,
                                          GLfloat param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLMaterialf, "context = %d, face = %s, pname = %s, param = %f", CID(context),
          GLenumToString(GLenumGroup::MaterialFace, face),
          GLenumToString(GLenumGroup::MaterialParameter, pname), param);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        MaterialParameter pnamePacked                         = PackParam<MaterialParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateMaterialf(context, face, pnamePacked, param));
        if (isCallValid)
        {
            context->materialf(face, pnamePacked, param);
        }
        ANGLE_CAPTURE(Materialf, isCallValid, context, face, pnamePacked, param);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_MaterialfvContextANGLE(GLeglContext ctx,
                                           GLenum face,
                                           GLenum pname,
                                           const GLfloat *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLMaterialfv, "context = %d, face = %s, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::MaterialFace, face),
          GLenumToString(GLenumGroup::MaterialParameter, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        MaterialParameter pnamePacked                         = PackParam<MaterialParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateMaterialfv(context, face, pnamePacked, params));
        if (isCallValid)
        {
            context->materialfv(face, pnamePacked, params);
        }
        ANGLE_CAPTURE(Materialfv, isCallValid, context, face, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_MaterialxContextANGLE(GLeglContext ctx,
                                          GLenum face,
                                          GLenum pname,
                                          GLfixed param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLMaterialx, "context = %d, face = %s, pname = %s, param = 0x%X", CID(context),
          GLenumToString(GLenumGroup::MaterialFace, face),
          GLenumToString(GLenumGroup::MaterialParameter, pname), param);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        MaterialParameter pnamePacked                         = PackParam<MaterialParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateMaterialx(context, face, pnamePacked, param));
        if (isCallValid)
        {
            context->materialx(face, pnamePacked, param);
        }
        ANGLE_CAPTURE(Materialx, isCallValid, context, face, pnamePacked, param);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_MaterialxvContextANGLE(GLeglContext ctx,
                                           GLenum face,
                                           GLenum pname,
                                           const GLfixed *param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLMaterialxv, "context = %d, face = %s, pname = %s, param = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::MaterialFace, face),
          GLenumToString(GLenumGroup::MaterialParameter, pname), (uintptr_t)param);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        MaterialParameter pnamePacked                         = PackParam<MaterialParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateMaterialxv(context, face, pnamePacked, param));
        if (isCallValid)
        {
            context->materialxv(face, pnamePacked, param);
        }
        ANGLE_CAPTURE(Materialxv, isCallValid, context, face, pnamePacked, param);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_MatrixIndexPointerOESContextANGLE(GLeglContext ctx,
                                                      GLint size,
                                                      GLenum type,
                                                      GLsizei stride,
                                                      const void *pointer)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLMatrixIndexPointerOES,
          "context = %d, size = %d, type = %s, stride = %d, pointer = 0x%016" PRIxPTR "",
          CID(context), size, GLenumToString(GLenumGroup::DefaultGroup, type), stride,
          (uintptr_t)pointer);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateMatrixIndexPointerOES(context, size, type, stride, pointer));
        if (isCallValid)
        {
            context->matrixIndexPointer(size, type, stride, pointer);
        }
        ANGLE_CAPTURE(MatrixIndexPointerOES, isCallValid, context, size, type, stride, pointer);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_MatrixModeContextANGLE(GLeglContext ctx, GLenum mode)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLMatrixMode, "context = %d, mode = %s", CID(context),
          GLenumToString(GLenumGroup::MatrixMode, mode));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        MatrixType modePacked                                 = PackParam<MatrixType>(mode);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateMatrixMode(context, modePacked));
        if (isCallValid)
        {
            context->matrixMode(modePacked);
        }
        ANGLE_CAPTURE(MatrixMode, isCallValid, context, modePacked);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_MaxShaderCompilerThreadsKHRContextANGLE(GLeglContext ctx, GLuint count)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLMaxShaderCompilerThreadsKHR, "context = %d, count = %u", CID(context), count);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateMaxShaderCompilerThreadsKHR(context, count));
        if (isCallValid)
        {
            context->maxShaderCompilerThreads(count);
        }
        ANGLE_CAPTURE(MaxShaderCompilerThreadsKHR, isCallValid, context, count);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_MemoryBarrierContextANGLE(GLeglContext ctx, GLbitfield barriers)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLMemoryBarrier, "context = %d, barriers = %s", CID(context),
          GLbitfieldToString(GLenumGroup::MemoryBarrierMask, barriers).c_str());

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateMemoryBarrier(context, barriers));
        if (isCallValid)
        {
            context->memoryBarrier(barriers);
        }
        ANGLE_CAPTURE(MemoryBarrier, isCallValid, context, barriers);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_MemoryBarrierByRegionContextANGLE(GLeglContext ctx, GLbitfield barriers)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLMemoryBarrierByRegion, "context = %d, barriers = %s", CID(context),
          GLbitfieldToString(GLenumGroup::MemoryBarrierMask, barriers).c_str());

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateMemoryBarrierByRegion(context, barriers));
        if (isCallValid)
        {
            context->memoryBarrierByRegion(barriers);
        }
        ANGLE_CAPTURE(MemoryBarrierByRegion, isCallValid, context, barriers);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_MemoryObjectParameterivEXTContextANGLE(GLeglContext ctx,
                                                           GLuint memoryObject,
                                                           GLenum pname,
                                                           const GLint *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLMemoryObjectParameterivEXT,
          "context = %d, memoryObject = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          memoryObject, GLenumToString(GLenumGroup::MemoryObjectParameterName, pname),
          (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        MemoryObjectID memoryObjectPacked = PackParam<MemoryObjectID>(memoryObject);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMemoryObjectParameterivEXT(context, memoryObjectPacked, pname, params));
        if (isCallValid)
        {
            context->memoryObjectParameteriv(memoryObjectPacked, pname, params);
        }
        ANGLE_CAPTURE(MemoryObjectParameterivEXT, isCallValid, context, memoryObjectPacked, pname,
                      params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_MinSampleShadingContextANGLE(GLeglContext ctx, GLfloat value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLMinSampleShading, "context = %d, value = %f", CID(context), value);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateMinSampleShading(context, value));
        if (isCallValid)
        {
            context->minSampleShading(value);
        }
        ANGLE_CAPTURE(MinSampleShading, isCallValid, context, value);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_MinSampleShadingOESContextANGLE(GLeglContext ctx, GLfloat value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLMinSampleShadingOES, "context = %d, value = %f", CID(context), value);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateMinSampleShadingOES(context, value));
        if (isCallValid)
        {
            context->minSampleShading(value);
        }
        ANGLE_CAPTURE(MinSampleShadingOES, isCallValid, context, value);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_MultMatrixfContextANGLE(GLeglContext ctx, const GLfloat *m)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLMultMatrixf, "context = %d, m = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)m);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateMultMatrixf(context, m));
        if (isCallValid)
        {
            context->multMatrixf(m);
        }
        ANGLE_CAPTURE(MultMatrixf, isCallValid, context, m);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_MultMatrixxContextANGLE(GLeglContext ctx, const GLfixed *m)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLMultMatrixx, "context = %d, m = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)m);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateMultMatrixx(context, m));
        if (isCallValid)
        {
            context->multMatrixx(m);
        }
        ANGLE_CAPTURE(MultMatrixx, isCallValid, context, m);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_MultiDrawElementsBaseVertexEXTContextANGLE(GLeglContext ctx,
                                                               GLenum mode,
                                                               const GLsizei *count,
                                                               GLenum type,
                                                               const void *const *indices,
                                                               GLsizei primcount,
                                                               const GLint *basevertex)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLMultiDrawElementsBaseVertexEXT,
          "context = %d, mode = %s, count = 0x%016" PRIxPTR ", type = %s, indices = 0x%016" PRIxPTR
          ", primcount = %d, basevertex = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), (uintptr_t)count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, primcount,
          (uintptr_t)basevertex);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked                              = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked                           = PackParam<DrawElementsType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateMultiDrawElementsBaseVertexEXT(
                                                             context, modePacked, count, typePacked,
                                                             indices, primcount, basevertex));
        if (isCallValid)
        {
            context->multiDrawElementsBaseVertex(modePacked, count, typePacked, indices, primcount,
                                                 basevertex);
        }
        ANGLE_CAPTURE(MultiDrawElementsBaseVertexEXT, isCallValid, context, modePacked, count,
                      typePacked, indices, primcount, basevertex);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_MultiTexCoord4fContextANGLE(GLeglContext ctx,
                                                GLenum target,
                                                GLfloat s,
                                                GLfloat t,
                                                GLfloat r,
                                                GLfloat q)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLMultiTexCoord4f, "context = %d, target = %s, s = %f, t = %f, r = %f, q = %f",
          CID(context), GLenumToString(GLenumGroup::TextureUnit, target), s, t, r, q);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateMultiTexCoord4f(context, target, s, t, r, q));
        if (isCallValid)
        {
            context->multiTexCoord4f(target, s, t, r, q);
        }
        ANGLE_CAPTURE(MultiTexCoord4f, isCallValid, context, target, s, t, r, q);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_MultiTexCoord4xContextANGLE(GLeglContext ctx,
                                                GLenum texture,
                                                GLfixed s,
                                                GLfixed t,
                                                GLfixed r,
                                                GLfixed q)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLMultiTexCoord4x,
          "context = %d, texture = %s, s = 0x%X, t = 0x%X, r = 0x%X, q = 0x%X", CID(context),
          GLenumToString(GLenumGroup::TextureUnit, texture), s, t, r, q);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateMultiTexCoord4x(context, texture, s, t, r, q));
        if (isCallValid)
        {
            context->multiTexCoord4x(texture, s, t, r, q);
        }
        ANGLE_CAPTURE(MultiTexCoord4x, isCallValid, context, texture, s, t, r, q);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_NamedBufferStorageExternalEXTContextANGLE(GLeglContext ctx,
                                                              GLuint buffer,
                                                              GLintptr offset,
                                                              GLsizeiptr size,
                                                              GLeglClientBufferEXT clientBuffer,
                                                              GLbitfield flags)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLNamedBufferStorageExternalEXT,
          "context = %d, buffer = %u, offset = %llu, size = %llu, clientBuffer = 0x%016" PRIxPTR
          ", flags = %s",
          CID(context), buffer, static_cast<unsigned long long>(offset),
          static_cast<unsigned long long>(size), (uintptr_t)clientBuffer,
          GLbitfieldToString(GLenumGroup::MapBufferUsageMask, flags).c_str());

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateNamedBufferStorageExternalEXT(
                                              context, buffer, offset, size, clientBuffer, flags));
        if (isCallValid)
        {
            context->namedBufferStorageExternal(buffer, offset, size, clientBuffer, flags);
        }
        ANGLE_CAPTURE(NamedBufferStorageExternalEXT, isCallValid, context, buffer, offset, size,
                      clientBuffer, flags);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_Normal3fContextANGLE(GLeglContext ctx, GLfloat nx, GLfloat ny, GLfloat nz)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLNormal3f, "context = %d, nx = %f, ny = %f, nz = %f", CID(context), nx, ny, nz);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateNormal3f(context, nx, ny, nz));
        if (isCallValid)
        {
            context->normal3f(nx, ny, nz);
        }
        ANGLE_CAPTURE(Normal3f, isCallValid, context, nx, ny, nz);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_Normal3xContextANGLE(GLeglContext ctx, GLfixed nx, GLfixed ny, GLfixed nz)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLNormal3x, "context = %d, nx = 0x%X, ny = 0x%X, nz = 0x%X", CID(context), nx,
          ny, nz);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateNormal3x(context, nx, ny, nz));
        if (isCallValid)
        {
            context->normal3x(nx, ny, nz);
        }
        ANGLE_CAPTURE(Normal3x, isCallValid, context, nx, ny, nz);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_NormalPointerContextANGLE(GLeglContext ctx,
                                              GLenum type,
                                              GLsizei stride,
                                              const void *pointer)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLNormalPointer,
          "context = %d, type = %s, stride = %d, pointer = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::NormalPointerType, type), stride, (uintptr_t)pointer);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        VertexAttribType typePacked                           = PackParam<VertexAttribType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateNormalPointer(context, typePacked, stride, pointer));
        if (isCallValid)
        {
            context->normalPointer(typePacked, stride, pointer);
        }
        ANGLE_CAPTURE(NormalPointer, isCallValid, context, typePacked, stride, pointer);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_ObjectLabelContextANGLE(GLeglContext ctx,
                                            GLenum identifier,
                                            GLuint name,
                                            GLsizei length,
                                            const GLchar *label)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLObjectLabel,
          "context = %d, identifier = %s, name = %u, length = %d, label = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::ObjectIdentifier, identifier), name, length,
          (uintptr_t)label);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateObjectLabel(context, identifier, name, length, label));
        if (isCallValid)
        {
            context->objectLabel(identifier, name, length, label);
        }
        ANGLE_CAPTURE(ObjectLabel, isCallValid, context, identifier, name, length, label);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_ObjectLabelKHRContextANGLE(GLeglContext ctx,
                                               GLenum identifier,
                                               GLuint name,
                                               GLsizei length,
                                               const GLchar *label)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLObjectLabelKHR,
          "context = %d, identifier = %s, name = %u, length = %d, label = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::ObjectIdentifier, identifier), name, length,
          (uintptr_t)label);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateObjectLabelKHR(context, identifier, name, length, label));
        if (isCallValid)
        {
            context->objectLabel(identifier, name, length, label);
        }
        ANGLE_CAPTURE(ObjectLabelKHR, isCallValid, context, identifier, name, length, label);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_ObjectPtrLabelContextANGLE(GLeglContext ctx,
                                               const void *ptr,
                                               GLsizei length,
                                               const GLchar *label)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLObjectPtrLabel,
          "context = %d, ptr = 0x%016" PRIxPTR ", length = %d, label = 0x%016" PRIxPTR "",
          CID(context), (uintptr_t)ptr, length, (uintptr_t)label);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateObjectPtrLabel(context, ptr, length, label));
        if (isCallValid)
        {
            context->objectPtrLabel(ptr, length, label);
        }
        ANGLE_CAPTURE(ObjectPtrLabel, isCallValid, context, ptr, length, label);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_ObjectPtrLabelKHRContextANGLE(GLeglContext ctx,
                                                  const void *ptr,
                                                  GLsizei length,
                                                  const GLchar *label)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLObjectPtrLabelKHR,
          "context = %d, ptr = 0x%016" PRIxPTR ", length = %d, label = 0x%016" PRIxPTR "",
          CID(context), (uintptr_t)ptr, length, (uintptr_t)label);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateObjectPtrLabelKHR(context, ptr, length, label));
        if (isCallValid)
        {
            context->objectPtrLabel(ptr, length, label);
        }
        ANGLE_CAPTURE(ObjectPtrLabelKHR, isCallValid, context, ptr, length, label);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_OrthofContextANGLE(GLeglContext ctx,
                                       GLfloat l,
                                       GLfloat r,
                                       GLfloat b,
                                       GLfloat t,
                                       GLfloat n,
                                       GLfloat f)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLOrthof, "context = %d, l = %f, r = %f, b = %f, t = %f, n = %f, f = %f",
          CID(context), l, r, b, t, n, f);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateOrthof(context, l, r, b, t, n, f));
        if (isCallValid)
        {
            context->orthof(l, r, b, t, n, f);
        }
        ANGLE_CAPTURE(Orthof, isCallValid, context, l, r, b, t, n, f);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_OrthoxContextANGLE(GLeglContext ctx,
                                       GLfixed l,
                                       GLfixed r,
                                       GLfixed b,
                                       GLfixed t,
                                       GLfixed n,
                                       GLfixed f)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLOrthox,
          "context = %d, l = 0x%X, r = 0x%X, b = 0x%X, t = 0x%X, n = 0x%X, f = 0x%X", CID(context),
          l, r, b, t, n, f);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateOrthox(context, l, r, b, t, n, f));
        if (isCallValid)
        {
            context->orthox(l, r, b, t, n, f);
        }
        ANGLE_CAPTURE(Orthox, isCallValid, context, l, r, b, t, n, f);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_PatchParameteriContextANGLE(GLeglContext ctx, GLenum pname, GLint value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLPatchParameteri, "context = %d, pname = %s, value = %d", CID(context),
          GLenumToString(GLenumGroup::PatchParameterName, pname), value);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidatePatchParameteri(context, pname, value));
        if (isCallValid)
        {
            context->patchParameteri(pname, value);
        }
        ANGLE_CAPTURE(PatchParameteri, isCallValid, context, pname, value);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_PatchParameteriEXTContextANGLE(GLeglContext ctx, GLenum pname, GLint value)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLPatchParameteriEXT, "context = %d, pname = %s, value = %d", CID(context),
          GLenumToString(GLenumGroup::PatchParameterName, pname), value);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidatePatchParameteriEXT(context, pname, value));
        if (isCallValid)
        {
            context->patchParameteri(pname, value);
        }
        ANGLE_CAPTURE(PatchParameteriEXT, isCallValid, context, pname, value);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_PauseTransformFeedbackContextANGLE(GLeglContext ctx)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLPauseTransformFeedback, "context = %d", CID(context));

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidatePauseTransformFeedback(context));
        if (isCallValid)
        {
            context->pauseTransformFeedback();
        }
        ANGLE_CAPTURE(PauseTransformFeedback, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_PixelStoreiContextANGLE(GLeglContext ctx, GLenum pname, GLint param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLPixelStorei, "context = %d, pname = %s, param = %d", CID(context),
          GLenumToString(GLenumGroup::PixelStoreParameter, pname), param);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidatePixelStorei(context, pname, param));
        if (isCallValid)
        {
            context->pixelStorei(pname, param);
        }
        ANGLE_CAPTURE(PixelStorei, isCallValid, context, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_PointParameterfContextANGLE(GLeglContext ctx, GLenum pname, GLfloat param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLPointParameterf, "context = %d, pname = %s, param = %f", CID(context),
          GLenumToString(GLenumGroup::DefaultGroup, pname), param);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        PointParameter pnamePacked                            = PackParam<PointParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidatePointParameterf(context, pnamePacked, param));
        if (isCallValid)
        {
            context->pointParameterf(pnamePacked, param);
        }
        ANGLE_CAPTURE(PointParameterf, isCallValid, context, pnamePacked, param);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_PointParameterfvContextANGLE(GLeglContext ctx,
                                                 GLenum pname,
                                                 const GLfloat *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLPointParameterfv, "context = %d, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        PointParameter pnamePacked                            = PackParam<PointParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidatePointParameterfv(context, pnamePacked, params));
        if (isCallValid)
        {
            context->pointParameterfv(pnamePacked, params);
        }
        ANGLE_CAPTURE(PointParameterfv, isCallValid, context, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_PointParameterxContextANGLE(GLeglContext ctx, GLenum pname, GLfixed param)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLPointParameterx, "context = %d, pname = %s, param = 0x%X", CID(context),
          GLenumToString(GLenumGroup::DefaultGroup, pname), param);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        PointParameter pnamePacked                            = PackParam<PointParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidatePointParameterx(context, pnamePacked, param));
        if (isCallValid)
        {
            context->pointParameterx(pnamePacked, param);
        }
        ANGLE_CAPTURE(PointParameterx, isCallValid, context, pnamePacked, param);
    }
    else
    {
        GenerateContextLostErrorOnContext(context);
    }
}

void GL_APIENTRY GL_PointParameterxvContextANGLE(GLeglContext ctx,
                                                 GLenum pname,
                                                 const GLfixed *params)
{
    Context *context = static_cast<gl::Context *>(ctx);
    EVENT(context, GLPointParameterxv, "context = %d, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)params);

    if (context && !context->isContextLost())
    {
        ASSERT(context == GetValidGlobalContext());
        PointParameter pnamePacked                            = PackParam<PointParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidatePointParameterxv(context, pnamePacked, params));
        if (isCallValid)
        {
            context->pointParameterxv(pnamePacked, params