# Attestation Policy (Developing)

CoCo AS provides a flexible policy support based on Rego to facilitate the customized verification rules.

Different token brokers will use the policy engine to evaluate different claims.
The simple token broker only evaluates the claim `allowed` while the EAR broker
implements a set of claims described below.

## Simple

The simple token broker only evaluates one claim, which is `allowed`.
Policies that are used with the simple token broker should evaulate
this claim either as `true` or `false`.

## EAR

EAR tokens support a more expressive policy result.
The EAR broker will evaluate the followig claims.
A valid policy must evaluate at least one of the following claims as number between 127 and -127.
* `instance_identity`
* `configuration`
* `executables`
* `file_system`
* `hardware`
* `runtime_opaque`
* `storage_opaque`
* `sourced_data`

These dimensions can be used to return a detailed, but generic description of the TCB of the attester.
More information about these trust claims, including what the numerical values of the claims represent,
can be found [here](https://datatracker.ietf.org/doc/draft-ietf-rats-ar4si/).

AS policies will be provide `data` and `input`. `data.reference` points to a dictionary of reference
values provided by the RVPS.

`input` are the TCB claims generated by the verifier.

See the [default policy](../src/token/ear_default_policy.rego) for an example.

## How to Use Policy

For both [gRPC CoCo AS](../../protos/attestation.proto) and [Restful CoCo AS](./restful-as.md), we have a
parameter named `policy_ids` to specify which policies to use to enforce the evidence check.

For a running CoCoAS, we can set any new policies.

Let's give some quick guides.

### gRPC CoCo AS

Firstly, start a gRPC CoCo AS
```shell
cd attestation-service/tests/e2e
make grpc.pid
```

Then, set a new policy to the CoCo AS.
We have prepared an [example SetPolicy request](../tests/coco-as/policy/grpc-set-policy.json) with [policy](../tests/coco-as/policy/new_policy.rego) and policy id `example-policy`. The policy should be `Base64 URL SAFE NO PAD` encoded.

```shell
REQ=$(cat ../../tests/coco-as/policy/grpc-set-policy.json)
grpcurl \
  -plaintext \
  -import-path ../../protos \
  -proto ../../protos/attestation.proto \
  -d @ 127.0.0.1:50004 attestation.AttestationService/SetAttestationPolicy <<EOF
$REQ
EOF
```

Then, we can use the policy to check against an evidence. We use the [request](../tests/coco-as/policy/check.json) to do this.

```shell
REQ=$(cat ../../tests/coco-as/policy/check.json)
grpcurl \
  -plaintext \
  -import-path ../../protos \
  -proto ../../protos/attestation.proto \
  -d @ 127.0.0.1:50004 attestation.AttestationService/AttestationEvaluate <<EOF
$REQ
EOF
```

### Restful CoCo AS

Firstly, start a Restful CoCo AS
```shell
cd attestation-service/tests/e2e
make restful.pid
```

Then, set a new policy to the CoCo AS.
We have prepared an [example SetPolicy request](../tests/coco-as/policy/restful-set-policy.json) with [policy](../tests/coco-as/policy/new_policy.rego) and policy id `example-policy`. The policy should be `Base64 URL SAFE NO PAD` encoded.

```shell
curl -k -X POST http://127.0.0.1:8080/policy \
     -i \
     -H 'Content-Type: application/json' \
     -d @../../tests/coco-as/policy/restful-set-policy.json
```

Then, we can use the policy to check against an evidence. We use the [request](../tests/coco-as/policy/check.json) to do this.

```shell
curl -k -X POST http://127.0.0.1:8080/attestation \
     -i \
     -H 'Content-Type: application/json' \
     -d @../../tests/coco-as/policy/check.json
```

## How to Write a Policy (Experimental)

:warning: **Warning:** The policy feature is still under development and it might be changed flexibly before we get a stable version.

We will introduce the format of policy by providing some examples to show the use cases.

1. The [default policy](../src/token/ear_default_policy.rego). This policy assigns multiple trust claims based on reference values. 
2. An [SGX policy](../tests/coco-as/policy/example-1.rego). The client want to ensure the `mr_signer` and `mrenclave` are both expected value.
3. A [TDX policy](../tests/coco-as/policy/example-2.rego). The client want to ensure the TDX module (reflected by `tdx.quote.body.mr_seam`), guest firmware (reflected by `tdx.quote.body.mr_td`), kernel (reflected by `tdx.ccel.kernel`) are all as expected.
4. A [IBM SE policy](../tests/coco-as/policy/example-3.rego). The client want to ensure the `se.version`, `se.tag`, `se.user_data`, `se.image_phkh` and `se.attestation_phkh` are all expected value.
