"""Generated client library for spanner version v1."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.spanner.v1 import spanner_v1_messages as messages


class SpannerV1(base_api.BaseApiClient):
  """Generated client library for service spanner version v1."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://spanner.googleapis.com/'

  _PACKAGE = u'spanner'
  _SCOPES = [u'https://www.googleapis.com/auth/cloud-platform', u'https://www.googleapis.com/auth/spanner.admin', u'https://www.googleapis.com/auth/spanner.data']
  _VERSION = u'v1'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _CLIENT_CLASS_NAME = u'SpannerV1'
  _URL_VERSION = u'v1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new spanner handle."""
    url = url or self.BASE_URL
    super(SpannerV1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_instanceConfigs = self.ProjectsInstanceConfigsService(self)
    self.projects_instances_databases_operations = self.ProjectsInstancesDatabasesOperationsService(self)
    self.projects_instances_databases_sessions = self.ProjectsInstancesDatabasesSessionsService(self)
    self.projects_instances_databases = self.ProjectsInstancesDatabasesService(self)
    self.projects_instances_operations = self.ProjectsInstancesOperationsService(self)
    self.projects_instances = self.ProjectsInstancesService(self)
    self.projects = self.ProjectsService(self)

  class ProjectsInstanceConfigsService(base_api.BaseApiService):
    """Service class for the projects_instanceConfigs resource."""

    _NAME = u'projects_instanceConfigs'

    def __init__(self, client):
      super(SpannerV1.ProjectsInstanceConfigsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets information about a particular instance configuration.

      Args:
        request: (SpannerProjectsInstanceConfigsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceConfig) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/instanceConfigs/{instanceConfigsId}',
        http_method=u'GET',
        method_id=u'spanner.projects.instanceConfigs.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'SpannerProjectsInstanceConfigsGetRequest',
        response_type_name=u'InstanceConfig',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the supported instance configurations for a given project.

      Args:
        request: (SpannerProjectsInstanceConfigsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListInstanceConfigsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/instanceConfigs',
        http_method=u'GET',
        method_id=u'spanner.projects.instanceConfigs.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v1/{+parent}/instanceConfigs',
        request_field='',
        request_type_name=u'SpannerProjectsInstanceConfigsListRequest',
        response_type_name=u'ListInstanceConfigsResponse',
        supports_download=False,
    )

  class ProjectsInstancesDatabasesOperationsService(base_api.BaseApiService):
    """Service class for the projects_instances_databases_operations resource."""

    _NAME = u'projects_instances_databases_operations'

    def __init__(self, client):
      super(SpannerV1.ProjectsInstancesDatabasesOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Starts asynchronous cancellation on a long-running operation.  The server.
makes a best effort to cancel the operation, but success is not
guaranteed.  If the server doesn't support this method, it returns
`google.rpc.Code.UNIMPLEMENTED`.  Clients can use
Operations.GetOperation or
other methods to check whether the cancellation succeeded or whether the
operation completed despite cancellation. On successful cancellation,
the operation is not deleted; instead, it becomes an operation with
an Operation.error value with a google.rpc.Status.code of 1,
corresponding to `Code.CANCELLED`.

      Args:
        request: (SpannerProjectsInstancesDatabasesOperationsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/operations/{operationsId}:cancel',
        http_method=u'POST',
        method_id=u'spanner.projects.instances.databases.operations.cancel',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}:cancel',
        request_field='',
        request_type_name=u'SpannerProjectsInstancesDatabasesOperationsCancelRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a long-running operation. This method indicates that the client is.
no longer interested in the operation result. It does not cancel the
operation. If the server doesn't support this method, it returns
`google.rpc.Code.UNIMPLEMENTED`.

      Args:
        request: (SpannerProjectsInstancesDatabasesOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/operations/{operationsId}',
        http_method=u'DELETE',
        method_id=u'spanner.projects.instances.databases.operations.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'SpannerProjectsInstancesDatabasesOperationsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation.  Clients can use this.
method to poll the operation result at intervals as recommended by the API
service.

      Args:
        request: (SpannerProjectsInstancesDatabasesOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/operations/{operationsId}',
        http_method=u'GET',
        method_id=u'spanner.projects.instances.databases.operations.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'SpannerProjectsInstancesDatabasesOperationsGetRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request. If the.
server doesn't support this method, it returns `UNIMPLEMENTED`.

NOTE: the `name` binding allows API services to override the binding
to use different resource name schemes, such as `users/*/operations`. To
override the binding, API services can add a binding such as
`"/v1/{name=users/*}/operations"` to their service configuration.
For backwards compatibility, the default name includes the operations
collection id, however overriding users must ensure the name binding
is the parent resource, without the operations collection id.

      Args:
        request: (SpannerProjectsInstancesDatabasesOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/operations',
        http_method=u'GET',
        method_id=u'spanner.projects.instances.databases.operations.list',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'SpannerProjectsInstancesDatabasesOperationsListRequest',
        response_type_name=u'ListOperationsResponse',
        supports_download=False,
    )

  class ProjectsInstancesDatabasesSessionsService(base_api.BaseApiService):
    """Service class for the projects_instances_databases_sessions resource."""

    _NAME = u'projects_instances_databases_sessions'

    def __init__(self, client):
      super(SpannerV1.ProjectsInstancesDatabasesSessionsService, self).__init__(client)
      self._upload_configs = {
          }

    def BeginTransaction(self, request, global_params=None):
      r"""Begins a new transaction. This step can often be skipped:.
Read, ExecuteSql and
Commit can begin a new transaction as a
side-effect.

      Args:
        request: (SpannerProjectsInstancesDatabasesSessionsBeginTransactionRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Transaction) The response message.
      """
      config = self.GetMethodConfig('BeginTransaction')
      return self._RunMethod(
          config, request, global_params=global_params)

    BeginTransaction.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/sessions/{sessionsId}:beginTransaction',
        http_method=u'POST',
        method_id=u'spanner.projects.instances.databases.sessions.beginTransaction',
        ordered_params=[u'session'],
        path_params=[u'session'],
        query_params=[],
        relative_path=u'v1/{+session}:beginTransaction',
        request_field=u'beginTransactionRequest',
        request_type_name=u'SpannerProjectsInstancesDatabasesSessionsBeginTransactionRequest',
        response_type_name=u'Transaction',
        supports_download=False,
    )

    def Commit(self, request, global_params=None):
      r"""Commits a transaction. The request includes the mutations to be.
applied to rows in the database.

`Commit` might return an `ABORTED` error. This can occur at any time;
commonly, the cause is conflicts with concurrent
transactions. However, it can also happen for a variety of other
reasons. If `Commit` returns `ABORTED`, the caller should re-attempt
the transaction from the beginning, re-using the same session.

      Args:
        request: (SpannerProjectsInstancesDatabasesSessionsCommitRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CommitResponse) The response message.
      """
      config = self.GetMethodConfig('Commit')
      return self._RunMethod(
          config, request, global_params=global_params)

    Commit.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/sessions/{sessionsId}:commit',
        http_method=u'POST',
        method_id=u'spanner.projects.instances.databases.sessions.commit',
        ordered_params=[u'session'],
        path_params=[u'session'],
        query_params=[],
        relative_path=u'v1/{+session}:commit',
        request_field=u'commitRequest',
        request_type_name=u'SpannerProjectsInstancesDatabasesSessionsCommitRequest',
        response_type_name=u'CommitResponse',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Creates a new session. A session can be used to perform.
transactions that read and/or modify data in a Cloud Spanner database.
Sessions are meant to be reused for many consecutive
transactions.

Sessions can only execute one transaction at a time. To execute
multiple concurrent read-write/write-only transactions, create
multiple sessions. Note that standalone reads and queries use a
transaction internally, and count toward the one transaction
limit.

Cloud Spanner limits the number of sessions that can exist at any given
time; thus, it is a good idea to delete idle and/or unneeded sessions.
Aside from explicit deletes, Cloud Spanner can delete sessions for which no
operations are sent for more than an hour. If a session is deleted,
requests to it return `NOT_FOUND`.

Idle sessions can be kept alive by sending a trivial SQL query
periodically, e.g., `"SELECT 1"`.

      Args:
        request: (SpannerProjectsInstancesDatabasesSessionsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Session) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/sessions',
        http_method=u'POST',
        method_id=u'spanner.projects.instances.databases.sessions.create',
        ordered_params=[u'database'],
        path_params=[u'database'],
        query_params=[],
        relative_path=u'v1/{+database}/sessions',
        request_field=u'createSessionRequest',
        request_type_name=u'SpannerProjectsInstancesDatabasesSessionsCreateRequest',
        response_type_name=u'Session',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Ends a session, releasing server resources associated with it.

      Args:
        request: (SpannerProjectsInstancesDatabasesSessionsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/sessions/{sessionsId}',
        http_method=u'DELETE',
        method_id=u'spanner.projects.instances.databases.sessions.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'SpannerProjectsInstancesDatabasesSessionsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def ExecuteSql(self, request, global_params=None):
      r"""Executes an SQL statement, returning all results in a single reply. This.
method cannot be used to return a result set larger than 10 MiB;
if the query yields more data than that, the query fails with
a `FAILED_PRECONDITION` error.

Operations inside read-write transactions might return `ABORTED`. If
this occurs, the application should restart the transaction from
the beginning. See Transaction for more details.

Larger result sets can be fetched in streaming fashion by calling
ExecuteStreamingSql instead.

      Args:
        request: (SpannerProjectsInstancesDatabasesSessionsExecuteSqlRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ResultSet) The response message.
      """
      config = self.GetMethodConfig('ExecuteSql')
      return self._RunMethod(
          config, request, global_params=global_params)

    ExecuteSql.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/sessions/{sessionsId}:executeSql',
        http_method=u'POST',
        method_id=u'spanner.projects.instances.databases.sessions.executeSql',
        ordered_params=[u'session'],
        path_params=[u'session'],
        query_params=[],
        relative_path=u'v1/{+session}:executeSql',
        request_field=u'executeSqlRequest',
        request_type_name=u'SpannerProjectsInstancesDatabasesSessionsExecuteSqlRequest',
        response_type_name=u'ResultSet',
        supports_download=False,
    )

    def ExecuteStreamingSql(self, request, global_params=None):
      r"""Like ExecuteSql, except returns the result.
set as a stream. Unlike ExecuteSql, there
is no limit on the size of the returned result set. However, no
individual row in the result set can exceed 100 MiB, and no
column value can exceed 10 MiB.

      Args:
        request: (SpannerProjectsInstancesDatabasesSessionsExecuteStreamingSqlRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PartialResultSet) The response message.
      """
      config = self.GetMethodConfig('ExecuteStreamingSql')
      return self._RunMethod(
          config, request, global_params=global_params)

    ExecuteStreamingSql.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/sessions/{sessionsId}:executeStreamingSql',
        http_method=u'POST',
        method_id=u'spanner.projects.instances.databases.sessions.executeStreamingSql',
        ordered_params=[u'session'],
        path_params=[u'session'],
        query_params=[],
        relative_path=u'v1/{+session}:executeStreamingSql',
        request_field=u'executeSqlRequest',
        request_type_name=u'SpannerProjectsInstancesDatabasesSessionsExecuteStreamingSqlRequest',
        response_type_name=u'PartialResultSet',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a session. Returns `NOT_FOUND` if the session does not exist.
This is mainly useful for determining whether a session is still
alive.

      Args:
        request: (SpannerProjectsInstancesDatabasesSessionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Session) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/sessions/{sessionsId}',
        http_method=u'GET',
        method_id=u'spanner.projects.instances.databases.sessions.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'SpannerProjectsInstancesDatabasesSessionsGetRequest',
        response_type_name=u'Session',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all sessions in a given database.

      Args:
        request: (SpannerProjectsInstancesDatabasesSessionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListSessionsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/sessions',
        http_method=u'GET',
        method_id=u'spanner.projects.instances.databases.sessions.list',
        ordered_params=[u'database'],
        path_params=[u'database'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1/{+database}/sessions',
        request_field='',
        request_type_name=u'SpannerProjectsInstancesDatabasesSessionsListRequest',
        response_type_name=u'ListSessionsResponse',
        supports_download=False,
    )

    def PartitionQuery(self, request, global_params=None):
      r"""Creates a set of partition tokens that can be used to execute a query.
operation in parallel.  Each of the returned partition tokens can be used
by ExecuteStreamingSql to specify a subset
of the query result to read.  The same session and read-only transaction
must be used by the PartitionQueryRequest used to create the
partition tokens and the ExecuteSqlRequests that use the partition tokens.
Partition tokens become invalid when the session used to create them
is deleted or begins a new transaction.

      Args:
        request: (SpannerProjectsInstancesDatabasesSessionsPartitionQueryRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PartitionResponse) The response message.
      """
      config = self.GetMethodConfig('PartitionQuery')
      return self._RunMethod(
          config, request, global_params=global_params)

    PartitionQuery.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/sessions/{sessionsId}:partitionQuery',
        http_method=u'POST',
        method_id=u'spanner.projects.instances.databases.sessions.partitionQuery',
        ordered_params=[u'session'],
        path_params=[u'session'],
        query_params=[],
        relative_path=u'v1/{+session}:partitionQuery',
        request_field=u'partitionQueryRequest',
        request_type_name=u'SpannerProjectsInstancesDatabasesSessionsPartitionQueryRequest',
        response_type_name=u'PartitionResponse',
        supports_download=False,
    )

    def PartitionRead(self, request, global_params=None):
      r"""Creates a set of partition tokens that can be used to execute a read.
operation in parallel.  Each of the returned partition tokens can be used
by StreamingRead to specify a subset of the read
result to read.  The same session and read-only transaction must be used by
the PartitionReadRequest used to create the partition tokens and the
ReadRequests that use the partition tokens.
Partition tokens become invalid when the session used to create them
is deleted or begins a new transaction.

      Args:
        request: (SpannerProjectsInstancesDatabasesSessionsPartitionReadRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PartitionResponse) The response message.
      """
      config = self.GetMethodConfig('PartitionRead')
      return self._RunMethod(
          config, request, global_params=global_params)

    PartitionRead.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/sessions/{sessionsId}:partitionRead',
        http_method=u'POST',
        method_id=u'spanner.projects.instances.databases.sessions.partitionRead',
        ordered_params=[u'session'],
        path_params=[u'session'],
        query_params=[],
        relative_path=u'v1/{+session}:partitionRead',
        request_field=u'partitionReadRequest',
        request_type_name=u'SpannerProjectsInstancesDatabasesSessionsPartitionReadRequest',
        response_type_name=u'PartitionResponse',
        supports_download=False,
    )

    def Read(self, request, global_params=None):
      r"""Reads rows from the database using key lookups and scans, as a.
simple key/value style alternative to
ExecuteSql.  This method cannot be used to
return a result set larger than 10 MiB; if the read matches more
data than that, the read fails with a `FAILED_PRECONDITION`
error.

Reads inside read-write transactions might return `ABORTED`. If
this occurs, the application should restart the transaction from
the beginning. See Transaction for more details.

Larger result sets can be yielded in streaming fashion by calling
StreamingRead instead.

      Args:
        request: (SpannerProjectsInstancesDatabasesSessionsReadRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ResultSet) The response message.
      """
      config = self.GetMethodConfig('Read')
      return self._RunMethod(
          config, request, global_params=global_params)

    Read.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/sessions/{sessionsId}:read',
        http_method=u'POST',
        method_id=u'spanner.projects.instances.databases.sessions.read',
        ordered_params=[u'session'],
        path_params=[u'session'],
        query_params=[],
        relative_path=u'v1/{+session}:read',
        request_field=u'readRequest',
        request_type_name=u'SpannerProjectsInstancesDatabasesSessionsReadRequest',
        response_type_name=u'ResultSet',
        supports_download=False,
    )

    def Rollback(self, request, global_params=None):
      r"""Rolls back a transaction, releasing any locks it holds. It is a good.
idea to call this for any transaction that includes one or more
Read or ExecuteSql requests and
ultimately decides not to commit.

`Rollback` returns `OK` if it successfully aborts the transaction, the
transaction was already aborted, or the transaction is not
found. `Rollback` never returns `ABORTED`.

      Args:
        request: (SpannerProjectsInstancesDatabasesSessionsRollbackRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Rollback')
      return self._RunMethod(
          config, request, global_params=global_params)

    Rollback.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/sessions/{sessionsId}:rollback',
        http_method=u'POST',
        method_id=u'spanner.projects.instances.databases.sessions.rollback',
        ordered_params=[u'session'],
        path_params=[u'session'],
        query_params=[],
        relative_path=u'v1/{+session}:rollback',
        request_field=u'rollbackRequest',
        request_type_name=u'SpannerProjectsInstancesDatabasesSessionsRollbackRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def StreamingRead(self, request, global_params=None):
      r"""Like Read, except returns the result set as a.
stream. Unlike Read, there is no limit on the
size of the returned result set. However, no individual row in
the result set can exceed 100 MiB, and no column value can exceed
10 MiB.

      Args:
        request: (SpannerProjectsInstancesDatabasesSessionsStreamingReadRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PartialResultSet) The response message.
      """
      config = self.GetMethodConfig('StreamingRead')
      return self._RunMethod(
          config, request, global_params=global_params)

    StreamingRead.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/sessions/{sessionsId}:streamingRead',
        http_method=u'POST',
        method_id=u'spanner.projects.instances.databases.sessions.streamingRead',
        ordered_params=[u'session'],
        path_params=[u'session'],
        query_params=[],
        relative_path=u'v1/{+session}:streamingRead',
        request_field=u'readRequest',
        request_type_name=u'SpannerProjectsInstancesDatabasesSessionsStreamingReadRequest',
        response_type_name=u'PartialResultSet',
        supports_download=False,
    )

  class ProjectsInstancesDatabasesService(base_api.BaseApiService):
    """Service class for the projects_instances_databases resource."""

    _NAME = u'projects_instances_databases'

    def __init__(self, client):
      super(SpannerV1.ProjectsInstancesDatabasesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new Cloud Spanner database and starts to prepare it for serving.
The returned long-running operation will
have a name of the format `<database_name>/operations/<operation_id>` and
can be used to track preparation of the database. The
metadata field type is
CreateDatabaseMetadata. The
response field type is
Database, if successful.

      Args:
        request: (SpannerProjectsInstancesDatabasesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/instances/{instancesId}/databases',
        http_method=u'POST',
        method_id=u'spanner.projects.instances.databases.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1/{+parent}/databases',
        request_field=u'createDatabaseRequest',
        request_type_name=u'SpannerProjectsInstancesDatabasesCreateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def DropDatabase(self, request, global_params=None):
      r"""Drops (aka deletes) a Cloud Spanner database.

      Args:
        request: (SpannerProjectsInstancesDatabasesDropDatabaseRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('DropDatabase')
      return self._RunMethod(
          config, request, global_params=global_params)

    DropDatabase.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}',
        http_method=u'DELETE',
        method_id=u'spanner.projects.instances.databases.dropDatabase',
        ordered_params=[u'database'],
        path_params=[u'database'],
        query_params=[],
        relative_path=u'v1/{+database}',
        request_field='',
        request_type_name=u'SpannerProjectsInstancesDatabasesDropDatabaseRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the state of a Cloud Spanner database.

      Args:
        request: (SpannerProjectsInstancesDatabasesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Database) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}',
        http_method=u'GET',
        method_id=u'spanner.projects.instances.databases.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'SpannerProjectsInstancesDatabasesGetRequest',
        response_type_name=u'Database',
        supports_download=False,
    )

    def GetDdl(self, request, global_params=None):
      r"""Returns the schema of a Cloud Spanner database as a list of formatted.
DDL statements. This method does not show pending schema updates, those may
be queried using the Operations API.

      Args:
        request: (SpannerProjectsInstancesDatabasesGetDdlRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GetDatabaseDdlResponse) The response message.
      """
      config = self.GetMethodConfig('GetDdl')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetDdl.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/ddl',
        http_method=u'GET',
        method_id=u'spanner.projects.instances.databases.getDdl',
        ordered_params=[u'database'],
        path_params=[u'database'],
        query_params=[],
        relative_path=u'v1/{+database}/ddl',
        request_field='',
        request_type_name=u'SpannerProjectsInstancesDatabasesGetDdlRequest',
        response_type_name=u'GetDatabaseDdlResponse',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a database resource. Returns an empty.
policy if a database exists but does not have a policy set.

Authorization requires `spanner.databases.getIamPolicy` permission on
resource.

      Args:
        request: (SpannerProjectsInstancesDatabasesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}:getIamPolicy',
        http_method=u'POST',
        method_id=u'spanner.projects.instances.databases.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1/{+resource}:getIamPolicy',
        request_field=u'getIamPolicyRequest',
        request_type_name=u'SpannerProjectsInstancesDatabasesGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists Cloud Spanner databases.

      Args:
        request: (SpannerProjectsInstancesDatabasesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListDatabasesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/instances/{instancesId}/databases',
        http_method=u'GET',
        method_id=u'spanner.projects.instances.databases.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v1/{+parent}/databases',
        request_field='',
        request_type_name=u'SpannerProjectsInstancesDatabasesListRequest',
        response_type_name=u'ListDatabasesResponse',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on a database resource. Replaces any.
existing policy.

Authorization requires `spanner.databases.setIamPolicy` permission on
resource.

      Args:
        request: (SpannerProjectsInstancesDatabasesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'spanner.projects.instances.databases.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'SpannerProjectsInstancesDatabasesSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that the caller has on the specified database resource.

Attempting this RPC on a non-existent Cloud Spanner database will result in
a NOT_FOUND error if the user has `spanner.databases.list` permission on
the containing Cloud Spanner instance. Otherwise returns an empty set of
permissions.

      Args:
        request: (SpannerProjectsInstancesDatabasesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}:testIamPermissions',
        http_method=u'POST',
        method_id=u'spanner.projects.instances.databases.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1/{+resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'SpannerProjectsInstancesDatabasesTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

    def UpdateDdl(self, request, global_params=None):
      r"""Updates the schema of a Cloud Spanner database by.
creating/altering/dropping tables, columns, indexes, etc. The returned
long-running operation will have a name of
the format `<database_name>/operations/<operation_id>` and can be used to
track execution of the schema change(s). The
metadata field type is
UpdateDatabaseDdlMetadata.  The operation has no response.

      Args:
        request: (SpannerProjectsInstancesDatabasesUpdateDdlRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('UpdateDdl')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateDdl.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/ddl',
        http_method=u'PATCH',
        method_id=u'spanner.projects.instances.databases.updateDdl',
        ordered_params=[u'database'],
        path_params=[u'database'],
        query_params=[],
        relative_path=u'v1/{+database}/ddl',
        request_field=u'updateDatabaseDdlRequest',
        request_type_name=u'SpannerProjectsInstancesDatabasesUpdateDdlRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class ProjectsInstancesOperationsService(base_api.BaseApiService):
    """Service class for the projects_instances_operations resource."""

    _NAME = u'projects_instances_operations'

    def __init__(self, client):
      super(SpannerV1.ProjectsInstancesOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Starts asynchronous cancellation on a long-running operation.  The server.
makes a best effort to cancel the operation, but success is not
guaranteed.  If the server doesn't support this method, it returns
`google.rpc.Code.UNIMPLEMENTED`.  Clients can use
Operations.GetOperation or
other methods to check whether the cancellation succeeded or whether the
operation completed despite cancellation. On successful cancellation,
the operation is not deleted; instead, it becomes an operation with
an Operation.error value with a google.rpc.Status.code of 1,
corresponding to `Code.CANCELLED`.

      Args:
        request: (SpannerProjectsInstancesOperationsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/instances/{instancesId}/operations/{operationsId}:cancel',
        http_method=u'POST',
        method_id=u'spanner.projects.instances.operations.cancel',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}:cancel',
        request_field='',
        request_type_name=u'SpannerProjectsInstancesOperationsCancelRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a long-running operation. This method indicates that the client is.
no longer interested in the operation result. It does not cancel the
operation. If the server doesn't support this method, it returns
`google.rpc.Code.UNIMPLEMENTED`.

      Args:
        request: (SpannerProjectsInstancesOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/instances/{instancesId}/operations/{operationsId}',
        http_method=u'DELETE',
        method_id=u'spanner.projects.instances.operations.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'SpannerProjectsInstancesOperationsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation.  Clients can use this.
method to poll the operation result at intervals as recommended by the API
service.

      Args:
        request: (SpannerProjectsInstancesOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/instances/{instancesId}/operations/{operationsId}',
        http_method=u'GET',
        method_id=u'spanner.projects.instances.operations.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'SpannerProjectsInstancesOperationsGetRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request. If the.
server doesn't support this method, it returns `UNIMPLEMENTED`.

NOTE: the `name` binding allows API services to override the binding
to use different resource name schemes, such as `users/*/operations`. To
override the binding, API services can add a binding such as
`"/v1/{name=users/*}/operations"` to their service configuration.
For backwards compatibility, the default name includes the operations
collection id, however overriding users must ensure the name binding
is the parent resource, without the operations collection id.

      Args:
        request: (SpannerProjectsInstancesOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/instances/{instancesId}/operations',
        http_method=u'GET',
        method_id=u'spanner.projects.instances.operations.list',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'SpannerProjectsInstancesOperationsListRequest',
        response_type_name=u'ListOperationsResponse',
        supports_download=False,
    )

  class ProjectsInstancesService(base_api.BaseApiService):
    """Service class for the projects_instances resource."""

    _NAME = u'projects_instances'

    def __init__(self, client):
      super(SpannerV1.ProjectsInstancesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates an instance and begins preparing it to begin serving. The.
returned long-running operation
can be used to track the progress of preparing the new
instance. The instance name is assigned by the caller. If the
named instance already exists, `CreateInstance` returns
`ALREADY_EXISTS`.

Immediately upon completion of this request:

  * The instance is readable via the API, with all requested attributes
    but no allocated resources. Its state is `CREATING`.

Until completion of the returned operation:

  * Cancelling the operation renders the instance immediately unreadable
    via the API.
  * The instance can be deleted.
  * All other attempts to modify the instance are rejected.

Upon completion of the returned operation:

  * Billing for all successfully-allocated resources begins (some types
    may have lower than the requested levels).
  * Databases can be created in the instance.
  * The instance's allocated resource levels are readable via the API.
  * The instance's state becomes `READY`.

The returned long-running operation will
have a name of the format `<instance_name>/operations/<operation_id>` and
can be used to track creation of the instance.  The
metadata field type is
CreateInstanceMetadata.
The response field type is
Instance, if successful.

      Args:
        request: (SpannerProjectsInstancesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/instances',
        http_method=u'POST',
        method_id=u'spanner.projects.instances.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1/{+parent}/instances',
        request_field=u'createInstanceRequest',
        request_type_name=u'SpannerProjectsInstancesCreateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an instance.

Immediately upon completion of the request:

  * Billing ceases for all of the instance's reserved resources.

Soon afterward:

  * The instance and *all of its databases* immediately and
    irrevocably disappear from the API. All data in the databases
    is permanently deleted.

      Args:
        request: (SpannerProjectsInstancesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/instances/{instancesId}',
        http_method=u'DELETE',
        method_id=u'spanner.projects.instances.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'SpannerProjectsInstancesDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets information about a particular instance.

      Args:
        request: (SpannerProjectsInstancesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Instance) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/instances/{instancesId}',
        http_method=u'GET',
        method_id=u'spanner.projects.instances.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'SpannerProjectsInstancesGetRequest',
        response_type_name=u'Instance',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for an instance resource. Returns an empty.
policy if an instance exists but does not have a policy set.

Authorization requires `spanner.instances.getIamPolicy` on
resource.

      Args:
        request: (SpannerProjectsInstancesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/instances/{instancesId}:getIamPolicy',
        http_method=u'POST',
        method_id=u'spanner.projects.instances.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1/{+resource}:getIamPolicy',
        request_field=u'getIamPolicyRequest',
        request_type_name=u'SpannerProjectsInstancesGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all instances in the given project.

      Args:
        request: (SpannerProjectsInstancesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListInstancesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/instances',
        http_method=u'GET',
        method_id=u'spanner.projects.instances.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1/{+parent}/instances',
        request_field='',
        request_type_name=u'SpannerProjectsInstancesListRequest',
        response_type_name=u'ListInstancesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an instance, and begins allocating or releasing resources.
as requested. The returned long-running
operation can be used to track the
progress of updating the instance. If the named instance does not
exist, returns `NOT_FOUND`.

Immediately upon completion of this request:

  * For resource types for which a decrease in the instance's allocation
    has been requested, billing is based on the newly-requested level.

Until completion of the returned operation:

  * Cancelling the operation sets its metadata's
    cancel_time, and begins
    restoring resources to their pre-request values. The operation
    is guaranteed to succeed at undoing all resource changes,
    after which point it terminates with a `CANCELLED` status.
  * All other attempts to modify the instance are rejected.
  * Reading the instance via the API continues to give the pre-request
    resource levels.

Upon completion of the returned operation:

  * Billing begins for all successfully-allocated resources (some types
    may have lower than the requested levels).
  * All newly-reserved resources are available for serving the instance's
    tables.
  * The instance's new resource levels are readable via the API.

The returned long-running operation will
have a name of the format `<instance_name>/operations/<operation_id>` and
can be used to track the instance modification.  The
metadata field type is
UpdateInstanceMetadata.
The response field type is
Instance, if successful.

Authorization requires `spanner.instances.update` permission on
resource name.

      Args:
        request: (SpannerProjectsInstancesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/instances/{instancesId}',
        http_method=u'PATCH',
        method_id=u'spanner.projects.instances.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field=u'updateInstanceRequest',
        request_type_name=u'SpannerProjectsInstancesPatchRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on an instance resource. Replaces any.
existing policy.

Authorization requires `spanner.instances.setIamPolicy` on
resource.

      Args:
        request: (SpannerProjectsInstancesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/instances/{instancesId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'spanner.projects.instances.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'SpannerProjectsInstancesSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that the caller has on the specified instance resource.

Attempting this RPC on a non-existent Cloud Spanner instance resource will
result in a NOT_FOUND error if the user has `spanner.instances.list`
permission on the containing Google Cloud Project. Otherwise returns an
empty set of permissions.

      Args:
        request: (SpannerProjectsInstancesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/instances/{instancesId}:testIamPermissions',
        http_method=u'POST',
        method_id=u'spanner.projects.instances.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1/{+resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'SpannerProjectsInstancesTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = u'projects'

    def __init__(self, client):
      super(SpannerV1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
