; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mattr=+sve -force-streaming-compatible-sve  < %s | FileCheck %s --check-prefixes=CHECK,SVE
; RUN: llc -mattr=+sve2 -force-streaming-compatible-sve  < %s | FileCheck %s --check-prefixes=CHECK,SVE2

target triple = "aarch64-unknown-linux-gnu"

;
; sext i1 -> i32
;

; NOTE: Covers the scenario where a SIGN_EXTEND_INREG is required, whose inreg
; type's element type is not byte based and thus cannot be lowered directly to
; an SVE instruction.
define void @sext_v8i1_v8i32(<8 x i1> %a, ptr %out) {
; CHECK-LABEL: sext_v8i1_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    uunpklo z0.h, z0.b
; CHECK-NEXT:    uunpklo z1.s, z0.h
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    lsl z1.s, z1.s, #31
; CHECK-NEXT:    lsl z0.s, z0.s, #31
; CHECK-NEXT:    asr z1.s, z1.s, #31
; CHECK-NEXT:    asr z0.s, z0.s, #31
; CHECK-NEXT:    stp q1, q0, [x0]
; CHECK-NEXT:    ret
  %b = sext <8 x i1> %a to <8 x i32>
  store <8 x i32> %b, ptr %out
  ret void
}

;
; sext i3 -> i64
;

; NOTE: Covers the scenario where a SIGN_EXTEND_INREG is required, whose inreg
; type's element type is not power-of-2 based and thus cannot be lowered
; directly to an SVE instruction.
define void @sext_v4i3_v4i64(<4 x i3> %a, ptr %out) {
; CHECK-LABEL: sext_v4i3_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    uunpklo z1.d, z0.s
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    lsl z1.d, z1.d, #61
; CHECK-NEXT:    lsl z0.d, z0.d, #61
; CHECK-NEXT:    asr z1.d, z1.d, #61
; CHECK-NEXT:    asr z0.d, z0.d, #61
; CHECK-NEXT:    stp q1, q0, [x0]
; CHECK-NEXT:    ret
  %b = sext <4 x i3> %a to <4 x i64>
  store <4 x i64> %b, ptr %out
  ret void
}

;
; sext i8 -> i16
;

define void @sext_v16i8_v16i16(<16 x i8> %a, ptr %out) {
; CHECK-LABEL: sext_v16i8_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    sunpklo z1.h, z0.b
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    sunpklo z0.h, z0.b
; CHECK-NEXT:    stp q1, q0, [x0]
; CHECK-NEXT:    ret
  %b = sext <16 x i8> %a to <16 x i16>
  store <16 x i16>%b, ptr %out
  ret void
}

; NOTE: Extra 'add' is to prevent the extend being combined with the load.
define void @sext_v32i8_v32i16(ptr %in, ptr %out) {
; CHECK-LABEL: sext_v32i8_v32i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    add z0.b, z0.b, z0.b
; CHECK-NEXT:    sunpklo z2.h, z0.b
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    add z1.b, z1.b, z1.b
; CHECK-NEXT:    sunpklo z0.h, z0.b
; CHECK-NEXT:    sunpklo z3.h, z1.b
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    sunpklo z1.h, z1.b
; CHECK-NEXT:    stp q2, q0, [x1]
; CHECK-NEXT:    stp q3, q1, [x1, #32]
; CHECK-NEXT:    ret
  %a = load <32 x i8>, ptr %in
  %b = add <32 x i8> %a, %a
  %c = sext <32 x i8> %b to <32 x i16>
  store <32 x i16> %c, ptr %out
  ret void
}

;
; sext i8 -> i32
;

define void @sext_v8i8_v8i32(<8 x i8> %a, ptr %out) {
; CHECK-LABEL: sext_v8i8_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    sunpklo z0.h, z0.b
; CHECK-NEXT:    sunpklo z1.s, z0.h
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    sunpklo z0.s, z0.h
; CHECK-NEXT:    stp q1, q0, [x0]
; CHECK-NEXT:    ret
  %b = sext <8 x i8> %a to <8 x i32>
  store <8 x i32>%b, ptr %out
  ret void
}

define void @sext_v16i8_v16i32(<16 x i8> %a, ptr %out) {
; CHECK-LABEL: sext_v16i8_v16i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    sunpklo z1.h, z0.b
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    sunpklo z2.s, z1.h
; CHECK-NEXT:    sunpklo z0.h, z0.b
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    sunpklo z3.s, z0.h
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    sunpklo z0.s, z0.h
; CHECK-NEXT:    stp q3, q0, [x0, #32]
; CHECK-NEXT:    sunpklo z0.s, z1.h
; CHECK-NEXT:    stp q2, q0, [x0]
; CHECK-NEXT:    ret
  %b = sext <16 x i8> %a to <16 x i32>
  store <16 x i32> %b, ptr %out
  ret void
}

define void @sext_v32i8_v32i32(ptr %in, ptr %out) {
; CHECK-LABEL: sext_v32i8_v32i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    add z0.b, z0.b, z0.b
; CHECK-NEXT:    sunpklo z2.h, z0.b
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    add z1.b, z1.b, z1.b
; CHECK-NEXT:    sunpklo z0.h, z0.b
; CHECK-NEXT:    sunpklo z3.h, z1.b
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    sunpklo z5.s, z3.h
; CHECK-NEXT:    ext z3.b, z3.b, z3.b, #8
; CHECK-NEXT:    sunpklo z1.h, z1.b
; CHECK-NEXT:    sunpklo z3.s, z3.h
; CHECK-NEXT:    sunpklo z4.s, z2.h
; CHECK-NEXT:    ext z2.b, z2.b, z2.b, #8
; CHECK-NEXT:    sunpklo z6.s, z0.h
; CHECK-NEXT:    stp q5, q3, [x1, #64]
; CHECK-NEXT:    sunpklo z5.s, z1.h
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    sunpklo z2.s, z2.h
; CHECK-NEXT:    sunpklo z1.s, z1.h
; CHECK-NEXT:    sunpklo z0.s, z0.h
; CHECK-NEXT:    stp q4, q2, [x1]
; CHECK-NEXT:    stp q6, q0, [x1, #32]
; CHECK-NEXT:    stp q5, q1, [x1, #96]
; CHECK-NEXT:    ret
  %a = load <32 x i8>, ptr %in
  %b = add <32 x i8> %a, %a
  %c = sext <32 x i8> %b to <32 x i32>
  store <32 x i32> %c, ptr %out
  ret void
}

;
; sext i8 -> i64
;

; NOTE: v4i8 is an unpacked typed stored within a v4i16 container. The sign
; extend is a two step process where the container is any_extend'd with the
; result feeding an inreg sign extend.
define void @sext_v4i8_v4i64(<4 x i8> %a, ptr %out) {
; CHECK-LABEL: sext_v4i8_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    uunpklo z1.d, z0.s
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    sxtb z1.d, p0/m, z1.d
; CHECK-NEXT:    sxtb z0.d, p0/m, z0.d
; CHECK-NEXT:    stp q1, q0, [x0]
; CHECK-NEXT:    ret
  %b = sext <4 x i8> %a to <4 x i64>
  store <4 x i64>%b, ptr %out
  ret void
}

define void @sext_v8i8_v8i64(<8 x i8> %a, ptr %out) {
; CHECK-LABEL: sext_v8i8_v8i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    sunpklo z0.h, z0.b
; CHECK-NEXT:    sunpklo z1.s, z0.h
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    sunpklo z0.s, z0.h
; CHECK-NEXT:    sunpklo z2.d, z1.s
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    sunpklo z3.d, z0.s
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    sunpklo z1.d, z1.s
; CHECK-NEXT:    sunpklo z0.d, z0.s
; CHECK-NEXT:    stp q2, q1, [x0]
; CHECK-NEXT:    stp q3, q0, [x0, #32]
; CHECK-NEXT:    ret
  %b = sext <8 x i8> %a to <8 x i64>
  store <8 x i64>%b, ptr %out
  ret void
}

define void @sext_v16i8_v16i64(<16 x i8> %a, ptr %out) {
; CHECK-LABEL: sext_v16i8_v16i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    sunpklo z1.h, z0.b
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    sunpklo z2.s, z1.h
; CHECK-NEXT:    sunpklo z0.h, z0.b
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    sunpklo z3.s, z0.h
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    sunpklo z0.s, z0.h
; CHECK-NEXT:    sunpklo z1.s, z1.h
; CHECK-NEXT:    sunpklo z6.d, z0.s
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    sunpklo z4.d, z2.s
; CHECK-NEXT:    sunpklo z5.d, z3.s
; CHECK-NEXT:    ext z3.b, z3.b, z3.b, #8
; CHECK-NEXT:    sunpklo z7.d, z1.s
; CHECK-NEXT:    ext z2.b, z2.b, z2.b, #8
; CHECK-NEXT:    sunpklo z0.d, z0.s
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    sunpklo z3.d, z3.s
; CHECK-NEXT:    sunpklo z2.d, z2.s
; CHECK-NEXT:    stp q5, q3, [x0, #64]
; CHECK-NEXT:    stp q4, q2, [x0]
; CHECK-NEXT:    stp q6, q0, [x0, #96]
; CHECK-NEXT:    sunpklo z0.d, z1.s
; CHECK-NEXT:    stp q7, q0, [x0, #32]
; CHECK-NEXT:    ret
  %b = sext <16 x i8> %a to <16 x i64>
  store <16 x i64> %b, ptr %out
  ret void
}

define void @sext_v32i8_v32i64(ptr %in, ptr %out) {
; CHECK-LABEL: sext_v32i8_v32i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    add z0.b, z0.b, z0.b
; CHECK-NEXT:    sunpklo z2.h, z0.b
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    add z1.b, z1.b, z1.b
; CHECK-NEXT:    sunpklo z0.h, z0.b
; CHECK-NEXT:    sunpklo z3.h, z1.b
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    sunpklo z5.s, z3.h
; CHECK-NEXT:    sunpklo z1.h, z1.b
; CHECK-NEXT:    ext z3.b, z3.b, z3.b, #8
; CHECK-NEXT:    sunpklo z4.s, z2.h
; CHECK-NEXT:    ext z2.b, z2.b, z2.b, #8
; CHECK-NEXT:    sunpklo z6.s, z0.h
; CHECK-NEXT:    sunpklo z7.s, z1.h
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    sunpklo z3.s, z3.h
; CHECK-NEXT:    sunpklo z2.s, z2.h
; CHECK-NEXT:    sunpklo z0.s, z0.h
; CHECK-NEXT:    sunpklo z1.s, z1.h
; CHECK-NEXT:    sunpklo z20.d, z3.s
; CHECK-NEXT:    sunpklo z22.d, z4.s
; CHECK-NEXT:    ext z4.b, z4.b, z4.b, #8
; CHECK-NEXT:    ext z3.b, z3.b, z3.b, #8
; CHECK-NEXT:    sunpklo z16.d, z2.s
; CHECK-NEXT:    sunpklo z17.d, z6.s
; CHECK-NEXT:    sunpklo z18.d, z0.s
; CHECK-NEXT:    sunpklo z19.d, z1.s
; CHECK-NEXT:    sunpklo z21.d, z7.s
; CHECK-NEXT:    sunpklo z23.d, z5.s
; CHECK-NEXT:    ext z5.b, z5.b, z5.b, #8
; CHECK-NEXT:    sunpklo z4.d, z4.s
; CHECK-NEXT:    ext z7.b, z7.b, z7.b, #8
; CHECK-NEXT:    sunpklo z3.d, z3.s
; CHECK-NEXT:    ext z6.b, z6.b, z6.b, #8
; CHECK-NEXT:    ext z2.b, z2.b, z2.b, #8
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    sunpklo z5.d, z5.s
; CHECK-NEXT:    stp q22, q4, [x1]
; CHECK-NEXT:    sunpklo z4.d, z7.s
; CHECK-NEXT:    stp q23, q5, [x1, #128]
; CHECK-NEXT:    sunpklo z2.d, z2.s
; CHECK-NEXT:    stp q20, q3, [x1, #160]
; CHECK-NEXT:    sunpklo z3.d, z6.s
; CHECK-NEXT:    sunpklo z1.d, z1.s
; CHECK-NEXT:    sunpklo z0.d, z0.s
; CHECK-NEXT:    stp q16, q2, [x1, #32]
; CHECK-NEXT:    stp q17, q3, [x1, #64]
; CHECK-NEXT:    stp q18, q0, [x1, #96]
; CHECK-NEXT:    stp q21, q4, [x1, #192]
; CHECK-NEXT:    stp q19, q1, [x1, #224]
; CHECK-NEXT:    ret
  %a = load <32 x i8>, ptr %in
  %b = add <32 x i8> %a, %a
  %c = sext <32 x i8> %b to <32 x i64>
  store <32 x i64> %c, ptr %out
  ret void
}

;
; sext i16 -> i32
;

define void @sext_v8i16_v8i32(<8 x i16> %a, ptr %out) {
; CHECK-LABEL: sext_v8i16_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    sunpklo z1.s, z0.h
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    sunpklo z0.s, z0.h
; CHECK-NEXT:    stp q1, q0, [x0]
; CHECK-NEXT:    ret
  %b = sext <8 x i16> %a to <8 x i32>
  store <8 x i32>%b, ptr %out
  ret void
}

define void @sext_v16i16_v16i32(ptr %in, ptr %out) {
; CHECK-LABEL: sext_v16i16_v16i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    add z0.h, z0.h, z0.h
; CHECK-NEXT:    sunpklo z2.s, z0.h
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    add z1.h, z1.h, z1.h
; CHECK-NEXT:    sunpklo z0.s, z0.h
; CHECK-NEXT:    sunpklo z3.s, z1.h
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    sunpklo z1.s, z1.h
; CHECK-NEXT:    stp q2, q0, [x1]
; CHECK-NEXT:    stp q3, q1, [x1, #32]
; CHECK-NEXT:    ret
  %a = load <16 x i16>, ptr %in
  %b = add <16 x i16> %a, %a
  %c = sext <16 x i16> %b to <16 x i32>
  store <16 x i32> %c, ptr %out
  ret void
}

;
; sext i16 -> i64
;

define void @sext_v4i16_v4i64(<4 x i16> %a, ptr %out) {
; CHECK-LABEL: sext_v4i16_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    sunpklo z0.s, z0.h
; CHECK-NEXT:    sunpklo z1.d, z0.s
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    sunpklo z0.d, z0.s
; CHECK-NEXT:    stp q1, q0, [x0]
; CHECK-NEXT:    ret
  %b = sext <4 x i16> %a to <4 x i64>
  store <4 x i64>%b, ptr %out
  ret void
}

define void @sext_v8i16_v8i64(<8 x i16> %a, ptr %out) {
; CHECK-LABEL: sext_v8i16_v8i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    sunpklo z1.s, z0.h
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    sunpklo z2.d, z1.s
; CHECK-NEXT:    sunpklo z0.s, z0.h
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    sunpklo z3.d, z0.s
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    sunpklo z0.d, z0.s
; CHECK-NEXT:    stp q3, q0, [x0, #32]
; CHECK-NEXT:    sunpklo z0.d, z1.s
; CHECK-NEXT:    stp q2, q0, [x0]
; CHECK-NEXT:    ret
  %b = sext <8 x i16> %a to <8 x i64>
  store <8 x i64>%b, ptr %out
  ret void
}

define void @sext_v16i16_v16i64(ptr %in, ptr %out) {
; CHECK-LABEL: sext_v16i16_v16i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    add z0.h, z0.h, z0.h
; CHECK-NEXT:    sunpklo z2.s, z0.h
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    add z1.h, z1.h, z1.h
; CHECK-NEXT:    sunpklo z0.s, z0.h
; CHECK-NEXT:    sunpklo z3.s, z1.h
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    sunpklo z5.d, z3.s
; CHECK-NEXT:    ext z3.b, z3.b, z3.b, #8
; CHECK-NEXT:    sunpklo z1.s, z1.h
; CHECK-NEXT:    sunpklo z3.d, z3.s
; CHECK-NEXT:    sunpklo z4.d, z2.s
; CHECK-NEXT:    ext z2.b, z2.b, z2.b, #8
; CHECK-NEXT:    sunpklo z6.d, z0.s
; CHECK-NEXT:    stp q5, q3, [x1, #64]
; CHECK-NEXT:    sunpklo z5.d, z1.s
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    sunpklo z2.d, z2.s
; CHECK-NEXT:    sunpklo z1.d, z1.s
; CHECK-NEXT:    sunpklo z0.d, z0.s
; CHECK-NEXT:    stp q4, q2, [x1]
; CHECK-NEXT:    stp q6, q0, [x1, #32]
; CHECK-NEXT:    stp q5, q1, [x1, #96]
; CHECK-NEXT:    ret
  %a = load <16 x i16>, ptr %in
  %b = add <16 x i16> %a, %a
  %c = sext <16 x i16> %b to <16 x i64>
  store <16 x i64> %c, ptr %out
  ret void
}

;
; sext i32 -> i64
;

define void @sext_v4i32_v4i64(<4 x i32> %a, ptr %out) {
; CHECK-LABEL: sext_v4i32_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    sunpklo z1.d, z0.s
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    sunpklo z0.d, z0.s
; CHECK-NEXT:    stp q1, q0, [x0]
; CHECK-NEXT:    ret
  %b = sext <4 x i32> %a to <4 x i64>
  store <4 x i64>%b, ptr %out
  ret void
}

define void @sext_v8i32_v8i64(ptr %in, ptr %out) {
; CHECK-LABEL: sext_v8i32_v8i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    add z0.s, z0.s, z0.s
; CHECK-NEXT:    sunpklo z2.d, z0.s
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    add z1.s, z1.s, z1.s
; CHECK-NEXT:    sunpklo z0.d, z0.s
; CHECK-NEXT:    sunpklo z3.d, z1.s
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    sunpklo z1.d, z1.s
; CHECK-NEXT:    stp q2, q0, [x1]
; CHECK-NEXT:    stp q3, q1, [x1, #32]
; CHECK-NEXT:    ret
  %a = load <8 x i32>, ptr %in
  %b = add <8 x i32> %a, %a
  %c = sext <8 x i32> %b to <8 x i64>
  store <8 x i64> %c, ptr %out
  ret void
}

;
; zext i8 -> i16
;

define void @zext_v16i8_v16i16(<16 x i8> %a, ptr %out) {
; CHECK-LABEL: zext_v16i8_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    uunpklo z1.h, z0.b
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z0.h, z0.b
; CHECK-NEXT:    stp q1, q0, [x0]
; CHECK-NEXT:    ret
  %b = zext <16 x i8> %a to <16 x i16>
  store <16 x i16>%b, ptr %out
  ret void
}

; NOTE: Extra 'add' is to prevent the extend being combined with the load.
define void @zext_v32i8_v32i16(ptr %in, ptr %out) {
; CHECK-LABEL: zext_v32i8_v32i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    add z0.b, z0.b, z0.b
; CHECK-NEXT:    uunpklo z2.h, z0.b
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    add z1.b, z1.b, z1.b
; CHECK-NEXT:    uunpklo z0.h, z0.b
; CHECK-NEXT:    uunpklo z3.h, z1.b
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    uunpklo z1.h, z1.b
; CHECK-NEXT:    stp q2, q0, [x1]
; CHECK-NEXT:    stp q3, q1, [x1, #32]
; CHECK-NEXT:    ret
  %a = load <32 x i8>, ptr %in
  %b = add <32 x i8> %a, %a
  %c = zext <32 x i8> %b to <32 x i16>
  store <32 x i16> %c, ptr %out
  ret void
}

;
; zext i8 -> i32
;

define void @zext_v8i8_v8i32(<8 x i8> %a, ptr %out) {
; CHECK-LABEL: zext_v8i8_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    uunpklo z0.h, z0.b
; CHECK-NEXT:    uunpklo z1.s, z0.h
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    stp q1, q0, [x0]
; CHECK-NEXT:    ret
  %b = zext <8 x i8> %a to <8 x i32>
  store <8 x i32>%b, ptr %out
  ret void
}

define void @zext_v16i8_v16i32(<16 x i8> %a, ptr %out) {
; CHECK-LABEL: zext_v16i8_v16i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    uunpklo z1.h, z0.b
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z2.s, z1.h
; CHECK-NEXT:    uunpklo z0.h, z0.b
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    uunpklo z3.s, z0.h
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    stp q3, q0, [x0, #32]
; CHECK-NEXT:    uunpklo z0.s, z1.h
; CHECK-NEXT:    stp q2, q0, [x0]
; CHECK-NEXT:    ret
  %b = zext <16 x i8> %a to <16 x i32>
  store <16 x i32> %b, ptr %out
  ret void
}

define void @zext_v32i8_v32i32(ptr %in, ptr %out) {
; CHECK-LABEL: zext_v32i8_v32i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    add z0.b, z0.b, z0.b
; CHECK-NEXT:    uunpklo z2.h, z0.b
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    add z1.b, z1.b, z1.b
; CHECK-NEXT:    uunpklo z0.h, z0.b
; CHECK-NEXT:    uunpklo z3.h, z1.b
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    uunpklo z5.s, z3.h
; CHECK-NEXT:    ext z3.b, z3.b, z3.b, #8
; CHECK-NEXT:    uunpklo z1.h, z1.b
; CHECK-NEXT:    uunpklo z3.s, z3.h
; CHECK-NEXT:    uunpklo z4.s, z2.h
; CHECK-NEXT:    ext z2.b, z2.b, z2.b, #8
; CHECK-NEXT:    uunpklo z6.s, z0.h
; CHECK-NEXT:    stp q5, q3, [x1, #64]
; CHECK-NEXT:    uunpklo z5.s, z1.h
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z2.s, z2.h
; CHECK-NEXT:    uunpklo z1.s, z1.h
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    stp q4, q2, [x1]
; CHECK-NEXT:    stp q6, q0, [x1, #32]
; CHECK-NEXT:    stp q5, q1, [x1, #96]
; CHECK-NEXT:    ret
  %a = load <32 x i8>, ptr %in
  %b = add <32 x i8> %a, %a
  %c = zext <32 x i8> %b to <32 x i32>
  store <32 x i32> %c, ptr %out
  ret void
}

;
; zext i8 -> i64
;

; NOTE: v4i8 is an unpacked typed stored within a v4i16 container. The zero
; extend is a two step process where the container is zero_extend_inreg'd with
; the result feeding a normal zero extend from halfs to doublewords.
define void @zext_v4i8_v4i64(<4 x i8> %a, ptr %out) {
; CHECK-LABEL: zext_v4i8_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    and z0.h, z0.h, #0xff
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    uunpklo z1.d, z0.s
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    stp q1, q0, [x0]
; CHECK-NEXT:    ret
  %b = zext <4 x i8> %a to <4 x i64>
  store <4 x i64>%b, ptr %out
  ret void
}

define void @zext_v8i8_v8i64(<8 x i8> %a, ptr %out) {
; CHECK-LABEL: zext_v8i8_v8i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    uunpklo z0.h, z0.b
; CHECK-NEXT:    uunpklo z1.s, z0.h
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    uunpklo z2.d, z1.s
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    uunpklo z3.d, z0.s
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z1.d, z1.s
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    stp q2, q1, [x0]
; CHECK-NEXT:    stp q3, q0, [x0, #32]
; CHECK-NEXT:    ret
  %b = zext <8 x i8> %a to <8 x i64>
  store <8 x i64>%b, ptr %out
  ret void
}

define void @zext_v16i8_v16i64(<16 x i8> %a, ptr %out) {
; CHECK-LABEL: zext_v16i8_v16i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    uunpklo z1.h, z0.b
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z2.s, z1.h
; CHECK-NEXT:    uunpklo z0.h, z0.b
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    uunpklo z3.s, z0.h
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    uunpklo z1.s, z1.h
; CHECK-NEXT:    uunpklo z6.d, z0.s
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z4.d, z2.s
; CHECK-NEXT:    uunpklo z5.d, z3.s
; CHECK-NEXT:    ext z3.b, z3.b, z3.b, #8
; CHECK-NEXT:    uunpklo z7.d, z1.s
; CHECK-NEXT:    ext z2.b, z2.b, z2.b, #8
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    uunpklo z3.d, z3.s
; CHECK-NEXT:    uunpklo z2.d, z2.s
; CHECK-NEXT:    stp q5, q3, [x0, #64]
; CHECK-NEXT:    stp q4, q2, [x0]
; CHECK-NEXT:    stp q6, q0, [x0, #96]
; CHECK-NEXT:    uunpklo z0.d, z1.s
; CHECK-NEXT:    stp q7, q0, [x0, #32]
; CHECK-NEXT:    ret
  %b = zext <16 x i8> %a to <16 x i64>
  store <16 x i64> %b, ptr %out
  ret void
}

define void @zext_v32i8_v32i64(ptr %in, ptr %out) {
; CHECK-LABEL: zext_v32i8_v32i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    add z0.b, z0.b, z0.b
; CHECK-NEXT:    uunpklo z2.h, z0.b
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    add z1.b, z1.b, z1.b
; CHECK-NEXT:    uunpklo z0.h, z0.b
; CHECK-NEXT:    uunpklo z3.h, z1.b
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    uunpklo z5.s, z3.h
; CHECK-NEXT:    uunpklo z1.h, z1.b
; CHECK-NEXT:    ext z3.b, z3.b, z3.b, #8
; CHECK-NEXT:    uunpklo z4.s, z2.h
; CHECK-NEXT:    ext z2.b, z2.b, z2.b, #8
; CHECK-NEXT:    uunpklo z6.s, z0.h
; CHECK-NEXT:    uunpklo z7.s, z1.h
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    uunpklo z3.s, z3.h
; CHECK-NEXT:    uunpklo z2.s, z2.h
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    uunpklo z1.s, z1.h
; CHECK-NEXT:    uunpklo z20.d, z3.s
; CHECK-NEXT:    uunpklo z22.d, z4.s
; CHECK-NEXT:    ext z4.b, z4.b, z4.b, #8
; CHECK-NEXT:    ext z3.b, z3.b, z3.b, #8
; CHECK-NEXT:    uunpklo z16.d, z2.s
; CHECK-NEXT:    uunpklo z17.d, z6.s
; CHECK-NEXT:    uunpklo z18.d, z0.s
; CHECK-NEXT:    uunpklo z19.d, z1.s
; CHECK-NEXT:    uunpklo z21.d, z7.s
; CHECK-NEXT:    uunpklo z23.d, z5.s
; CHECK-NEXT:    ext z5.b, z5.b, z5.b, #8
; CHECK-NEXT:    uunpklo z4.d, z4.s
; CHECK-NEXT:    ext z7.b, z7.b, z7.b, #8
; CHECK-NEXT:    uunpklo z3.d, z3.s
; CHECK-NEXT:    ext z6.b, z6.b, z6.b, #8
; CHECK-NEXT:    ext z2.b, z2.b, z2.b, #8
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z5.d, z5.s
; CHECK-NEXT:    stp q22, q4, [x1]
; CHECK-NEXT:    uunpklo z4.d, z7.s
; CHECK-NEXT:    stp q23, q5, [x1, #128]
; CHECK-NEXT:    uunpklo z2.d, z2.s
; CHECK-NEXT:    stp q20, q3, [x1, #160]
; CHECK-NEXT:    uunpklo z3.d, z6.s
; CHECK-NEXT:    uunpklo z1.d, z1.s
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    stp q16, q2, [x1, #32]
; CHECK-NEXT:    stp q17, q3, [x1, #64]
; CHECK-NEXT:    stp q18, q0, [x1, #96]
; CHECK-NEXT:    stp q21, q4, [x1, #192]
; CHECK-NEXT:    stp q19, q1, [x1, #224]
; CHECK-NEXT:    ret
  %a = load <32 x i8>, ptr %in
  %b = add <32 x i8> %a, %a
  %c = zext <32 x i8> %b to <32 x i64>
  store <32 x i64> %c, ptr %out
  ret void
}

;
; zext i16 -> i32
;

define void @zext_v8i16_v8i32(<8 x i16> %a, ptr %out) {
; CHECK-LABEL: zext_v8i16_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    uunpklo z1.s, z0.h
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    stp q1, q0, [x0]
; CHECK-NEXT:    ret
  %b = zext <8 x i16> %a to <8 x i32>
  store <8 x i32>%b, ptr %out
  ret void
}

define void @zext_v16i16_v16i32(ptr %in, ptr %out) {
; CHECK-LABEL: zext_v16i16_v16i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    add z0.h, z0.h, z0.h
; CHECK-NEXT:    uunpklo z2.s, z0.h
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    add z1.h, z1.h, z1.h
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    uunpklo z3.s, z1.h
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    uunpklo z1.s, z1.h
; CHECK-NEXT:    stp q2, q0, [x1]
; CHECK-NEXT:    stp q3, q1, [x1, #32]
; CHECK-NEXT:    ret
  %a = load <16 x i16>, ptr %in
  %b = add <16 x i16> %a, %a
  %c = zext <16 x i16> %b to <16 x i32>
  store <16 x i32> %c, ptr %out
  ret void
}

;
; zext i16 -> i64
;

define void @zext_v4i16_v4i64(<4 x i16> %a, ptr %out) {
; CHECK-LABEL: zext_v4i16_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    uunpklo z1.d, z0.s
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    stp q1, q0, [x0]
; CHECK-NEXT:    ret
  %b = zext <4 x i16> %a to <4 x i64>
  store <4 x i64>%b, ptr %out
  ret void
}

define void @zext_v8i16_v8i64(<8 x i16> %a, ptr %out) {
; CHECK-LABEL: zext_v8i16_v8i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    uunpklo z1.s, z0.h
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z2.d, z1.s
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    uunpklo z3.d, z0.s
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    stp q3, q0, [x0, #32]
; CHECK-NEXT:    uunpklo z0.d, z1.s
; CHECK-NEXT:    stp q2, q0, [x0]
; CHECK-NEXT:    ret
  %b = zext <8 x i16> %a to <8 x i64>
  store <8 x i64>%b, ptr %out
  ret void
}

define void @zext_v16i16_v16i64(ptr %in, ptr %out) {
; CHECK-LABEL: zext_v16i16_v16i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    add z0.h, z0.h, z0.h
; CHECK-NEXT:    uunpklo z2.s, z0.h
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    add z1.h, z1.h, z1.h
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    uunpklo z3.s, z1.h
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    uunpklo z5.d, z3.s
; CHECK-NEXT:    ext z3.b, z3.b, z3.b, #8
; CHECK-NEXT:    uunpklo z1.s, z1.h
; CHECK-NEXT:    uunpklo z3.d, z3.s
; CHECK-NEXT:    uunpklo z4.d, z2.s
; CHECK-NEXT:    ext z2.b, z2.b, z2.b, #8
; CHECK-NEXT:    uunpklo z6.d, z0.s
; CHECK-NEXT:    stp q5, q3, [x1, #64]
; CHECK-NEXT:    uunpklo z5.d, z1.s
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z2.d, z2.s
; CHECK-NEXT:    uunpklo z1.d, z1.s
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    stp q4, q2, [x1]
; CHECK-NEXT:    stp q6, q0, [x1, #32]
; CHECK-NEXT:    stp q5, q1, [x1, #96]
; CHECK-NEXT:    ret
  %a = load <16 x i16>, ptr %in
  %b = add <16 x i16> %a, %a
  %c = zext <16 x i16> %b to <16 x i64>
  store <16 x i64> %c, ptr %out
  ret void
}

;
; zext i32 -> i64
;

define void @zext_v4i32_v4i64(<4 x i32> %a, ptr %out) {
; CHECK-LABEL: zext_v4i32_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    uunpklo z1.d, z0.s
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    stp q1, q0, [x0]
; CHECK-NEXT:    ret
  %b = zext <4 x i32> %a to <4 x i64>
  store <4 x i64>%b, ptr %out
  ret void
}

define void @zext_v8i32_v8i64(ptr %in, ptr %out) {
; CHECK-LABEL: zext_v8i32_v8i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    add z0.s, z0.s, z0.s
; CHECK-NEXT:    uunpklo z2.d, z0.s
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    add z1.s, z1.s, z1.s
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    uunpklo z3.d, z1.s
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    uunpklo z1.d, z1.s
; CHECK-NEXT:    stp q2, q0, [x1]
; CHECK-NEXT:    stp q3, q1, [x1, #32]
; CHECK-NEXT:    ret
  %a = load <8 x i32>, ptr %in
  %b = add <8 x i32> %a, %a
  %c = zext <8 x i32> %b to <8 x i64>
  store <8 x i64> %c, ptr %out
  ret void
}

define void @extend_and_mul(i32 %0, <2 x i64> %1, ptr %2) {
; SVE-LABEL: extend_and_mul:
; SVE:       // %bb.0:
; SVE-NEXT:    mov z1.s, w0
; SVE-NEXT:    // kill: def $q0 killed $q0 def $z0
; SVE-NEXT:    ptrue p0.d, vl2
; SVE-NEXT:    uunpklo z1.d, z1.s
; SVE-NEXT:    mul z0.d, p0/m, z0.d, z1.d
; SVE-NEXT:    str q0, [x1]
; SVE-NEXT:    ret
;
; SVE2-LABEL: extend_and_mul:
; SVE2:       // %bb.0:
; SVE2-NEXT:    mov z1.s, w0
; SVE2-NEXT:    // kill: def $q0 killed $q0 def $z0
; SVE2-NEXT:    uunpklo z1.d, z1.s
; SVE2-NEXT:    mul z0.d, z1.d, z0.d
; SVE2-NEXT:    str q0, [x1]
; SVE2-NEXT:    ret
  %broadcast.splatinsert2 = insertelement <2 x i32> poison, i32 %0, i64 0
  %broadcast.splat3 = shufflevector <2 x i32> %broadcast.splatinsert2, <2 x i32> poison, <2 x i32> zeroinitializer
  %4 = zext <2 x i32> %broadcast.splat3 to <2 x i64>
  %5 = mul <2 x i64> %4, %1
  store <2 x i64> %5, ptr %2, align 2
  ret void
}

define void @extend_no_mul(i32 %0, <2 x i64> %1, ptr %2) {
; CHECK-LABEL: extend_no_mul:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov w8, w0
; CHECK-NEXT:    mov z0.d, x8
; CHECK-NEXT:    str q0, [x1]
; CHECK-NEXT:    ret
entry:
  %broadcast.splatinsert2 = insertelement <2 x i32> poison, i32 %0, i64 0
  %broadcast.splat3 = shufflevector <2 x i32> %broadcast.splatinsert2, <2 x i32> poison, <2 x i32> zeroinitializer
  %3 = zext <2 x i32> %broadcast.splat3 to <2 x i64>
  store <2 x i64> %3, ptr %2, align 2
  ret void
}
