; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; RUN: llc -verify-machineinstrs -stop-before=ppc-vsx-copy -vec-extabi \
; RUN:     -mcpu=pwr7  -mtriple powerpc-ibm-aix-xcoff < %s | \
; RUN: FileCheck %s

;; Fixed vector arguments to variadic functions are passed differently than
;; either arguments to non-variadic functions or arguments passed through
;; ellipses.
define double @callee(i32 %count, <4 x i32> %vsi, double %next, ...) {
  ; CHECK-LABEL: name: callee
  ; CHECK: bb.0.entry:
  ; CHECK:   LIFETIME_START %stack.0.arg_list
  ; CHECK:   [[ADDI:%[0-9]+]]:gprc = ADDI %fixed-stack.0, 0
  ; CHECK:   STW killed [[ADDI]], 0, %stack.0.arg_list :: (store (s32) into %ir.arg_list)
  ; CHECK:   [[ADDI1:%[0-9]+]]:gprc = ADDI %fixed-stack.0, 15
  ; CHECK:   [[RLWINM:%[0-9]+]]:gprc_and_gprc_nor0 = RLWINM killed [[ADDI1]], 0, 0, 27
  ; CHECK:   [[LFD:%[0-9]+]]:f8rc = LFD 16, killed [[RLWINM]] :: (load (s64) from %ir.argp.next, align 16)
  ; CHECK:   LIFETIME_END %stack.0.arg_list
  ; CHECK:   $f1 = COPY [[LFD]]
  ; CHECK:   BLR implicit $lr, implicit $rm, implicit $f1
entry:
  %arg_list = alloca ptr, align 4
  call void @llvm.lifetime.start.p0(i64 4, ptr nonnull %arg_list)
  call void @llvm.va_start(ptr nonnull %arg_list)
  %argp.cur = load ptr, ptr %arg_list, align 4
  %0 = ptrtoint ptr %argp.cur to i32
  %1 = add i32 %0, 15
  %2 = and i32 %1, -16
  %argp.cur.aligned = inttoptr i32 %2 to ptr
  %argp.next = getelementptr inbounds i8, ptr %argp.cur.aligned, i32 16
  %argp.next3 = getelementptr inbounds i8, ptr %argp.cur.aligned, i32 24
  store ptr %argp.next3, ptr %arg_list, align 4
  %3 = load double, ptr %argp.next, align 16
  call void @llvm.va_end(ptr nonnull %arg_list)
  call void @llvm.lifetime.end.p0(i64 4, ptr nonnull %arg_list)
  ret double %3
}

declare void @llvm.lifetime.start.p0(i64 immarg, ptr nocapture)

declare void @llvm.va_start(ptr)

declare void @llvm.va_end(ptr)

declare void @llvm.lifetime.end.p0(i64 immarg, ptr nocapture)

