; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-linux-gnu -mattr=-f16c -fixup-byte-word-insts=1 -verify-machineinstrs \
; RUN:   | FileCheck %s -check-prefixes=CHECK,CHECK-LIBCALL,BWON
; RUN: llc < %s -mtriple=x86_64-unknown-linux-gnu -mattr=-f16c  -fixup-byte-word-insts=0 -verify-machineinstrs \
; RUN:   | FileCheck %s -check-prefixes=CHECK,CHECK-LIBCALL,BWOFF
; RUN: llc < %s -mtriple=x86_64-unknown-linux-gnu -mattr=+f16c -fixup-byte-word-insts=1 -verify-machineinstrs \
; RUN:    | FileCheck %s -check-prefixes=CHECK,BWON,BWON-F16C
; RUN: llc < %s -mtriple=i686-unknown-linux-gnu -mattr +sse2 -fixup-byte-word-insts=0 -verify-machineinstrs \
; RUN:    | FileCheck %s -check-prefixes=CHECK-I686

define void @test_load_store(ptr %in, ptr %out) #0 {
; CHECK-LIBCALL-LABEL: test_load_store:
; CHECK-LIBCALL:       # %bb.0:
; CHECK-LIBCALL-NEXT:    pinsrw $0, (%rdi), %xmm0
; CHECK-LIBCALL-NEXT:    pextrw $0, %xmm0, %eax
; CHECK-LIBCALL-NEXT:    movw %ax, (%rsi)
; CHECK-LIBCALL-NEXT:    retq
;
; BWON-F16C-LABEL: test_load_store:
; BWON-F16C:       # %bb.0:
; BWON-F16C-NEXT:    vpinsrw $0, (%rdi), %xmm0, %xmm0
; BWON-F16C-NEXT:    vpextrw $0, %xmm0, (%rsi)
; BWON-F16C-NEXT:    retq
;
; CHECK-I686-LABEL: test_load_store:
; CHECK-I686:       # %bb.0:
; CHECK-I686-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-I686-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; CHECK-I686-NEXT:    pinsrw $0, (%ecx), %xmm0
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %ecx
; CHECK-I686-NEXT:    movw %cx, (%eax)
; CHECK-I686-NEXT:    retl
  %val = load half, ptr %in
  store half %val, ptr %out
  ret void
}

define i16 @test_bitcast_from_half(ptr %addr) #0 {
; BWON-LABEL: test_bitcast_from_half:
; BWON:       # %bb.0:
; BWON-NEXT:    movzwl (%rdi), %eax
; BWON-NEXT:    retq
;
; BWOFF-LABEL: test_bitcast_from_half:
; BWOFF:       # %bb.0:
; BWOFF-NEXT:    movw (%rdi), %ax
; BWOFF-NEXT:    retq
;
; CHECK-I686-LABEL: test_bitcast_from_half:
; CHECK-I686:       # %bb.0:
; CHECK-I686-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-I686-NEXT:    movw (%eax), %ax
; CHECK-I686-NEXT:    retl
  %val = load half, ptr %addr
  %val_int = bitcast half %val to i16
  ret i16 %val_int
}

define void @test_bitcast_to_half(ptr %addr, i16 %in) #0 {
; CHECK-LABEL: test_bitcast_to_half:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movw %si, (%rdi)
; CHECK-NEXT:    retq
;
; CHECK-I686-LABEL: test_bitcast_to_half:
; CHECK-I686:       # %bb.0:
; CHECK-I686-NEXT:    movw {{[0-9]+}}(%esp), %ax
; CHECK-I686-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; CHECK-I686-NEXT:    movw %ax, (%ecx)
; CHECK-I686-NEXT:    retl
  %val_fp = bitcast i16 %in to half
  store half %val_fp, ptr %addr
  ret void
}

define float @test_extend32(ptr %addr) #0 {
; CHECK-LIBCALL-LABEL: test_extend32:
; CHECK-LIBCALL:       # %bb.0:
; CHECK-LIBCALL-NEXT:    pinsrw $0, (%rdi), %xmm0
; CHECK-LIBCALL-NEXT:    jmp __extendhfsf2@PLT # TAILCALL
;
; BWON-F16C-LABEL: test_extend32:
; BWON-F16C:       # %bb.0:
; BWON-F16C-NEXT:    movzwl (%rdi), %eax
; BWON-F16C-NEXT:    vmovd %eax, %xmm0
; BWON-F16C-NEXT:    vcvtph2ps %xmm0, %xmm0
; BWON-F16C-NEXT:    retq
;
; CHECK-I686-LABEL: test_extend32:
; CHECK-I686:       # %bb.0:
; CHECK-I686-NEXT:    subl $12, %esp
; CHECK-I686-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-I686-NEXT:    pinsrw $0, (%eax), %xmm0
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %eax
; CHECK-I686-NEXT:    movw %ax, (%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    addl $12, %esp
; CHECK-I686-NEXT:    retl
  %val16 = load half, ptr %addr
  %val32 = fpext half %val16 to float
  ret float %val32
}

define double @test_extend64(ptr %addr) #0 {
; CHECK-LIBCALL-LABEL: test_extend64:
; CHECK-LIBCALL:       # %bb.0:
; CHECK-LIBCALL-NEXT:    pushq %rax
; CHECK-LIBCALL-NEXT:    pinsrw $0, (%rdi), %xmm0
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    cvtss2sd %xmm0, %xmm0
; CHECK-LIBCALL-NEXT:    popq %rax
; CHECK-LIBCALL-NEXT:    retq
;
; BWON-F16C-LABEL: test_extend64:
; BWON-F16C:       # %bb.0:
; BWON-F16C-NEXT:    movzwl (%rdi), %eax
; BWON-F16C-NEXT:    vmovd %eax, %xmm0
; BWON-F16C-NEXT:    vcvtph2ps %xmm0, %xmm0
; BWON-F16C-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; BWON-F16C-NEXT:    retq
;
; CHECK-I686-LABEL: test_extend64:
; CHECK-I686:       # %bb.0:
; CHECK-I686-NEXT:    subl $12, %esp
; CHECK-I686-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-I686-NEXT:    pinsrw $0, (%eax), %xmm0
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %eax
; CHECK-I686-NEXT:    movw %ax, (%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    addl $12, %esp
; CHECK-I686-NEXT:    retl
  %val16 = load half, ptr %addr
  %val32 = fpext half %val16 to double
  ret double %val32
}

define void @test_trunc32(float %in, ptr %addr) #0 {
; CHECK-LIBCALL-LABEL: test_trunc32:
; CHECK-LIBCALL:       # %bb.0:
; CHECK-LIBCALL-NEXT:    pushq %rbx
; CHECK-LIBCALL-NEXT:    movq %rdi, %rbx
; CHECK-LIBCALL-NEXT:    callq __truncsfhf2@PLT
; CHECK-LIBCALL-NEXT:    pextrw $0, %xmm0, %eax
; CHECK-LIBCALL-NEXT:    movw %ax, (%rbx)
; CHECK-LIBCALL-NEXT:    popq %rbx
; CHECK-LIBCALL-NEXT:    retq
;
; BWON-F16C-LABEL: test_trunc32:
; BWON-F16C:       # %bb.0:
; BWON-F16C-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; BWON-F16C-NEXT:    vmovd %xmm0, %eax
; BWON-F16C-NEXT:    movw %ax, (%rdi)
; BWON-F16C-NEXT:    retq
;
; CHECK-I686-LABEL: test_trunc32:
; CHECK-I686:       # %bb.0:
; CHECK-I686-NEXT:    pushl %esi
; CHECK-I686-NEXT:    subl $8, %esp
; CHECK-I686-NEXT:    movl {{[0-9]+}}(%esp), %esi
; CHECK-I686-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:    movd %xmm0, (%esp)
; CHECK-I686-NEXT:    calll __truncsfhf2
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %eax
; CHECK-I686-NEXT:    movw %ax, (%esi)
; CHECK-I686-NEXT:    addl $8, %esp
; CHECK-I686-NEXT:    popl %esi
; CHECK-I686-NEXT:    retl
  %val16 = fptrunc float %in to half
  store half %val16, ptr %addr
  ret void
}

define void @test_trunc64(double %in, ptr %addr) #0 {
; CHECK-LIBCALL-LABEL: test_trunc64:
; CHECK-LIBCALL:       # %bb.0:
; CHECK-LIBCALL-NEXT:    pushq %rbx
; CHECK-LIBCALL-NEXT:    movq %rdi, %rbx
; CHECK-LIBCALL-NEXT:    callq __truncdfhf2@PLT
; CHECK-LIBCALL-NEXT:    pextrw $0, %xmm0, %eax
; CHECK-LIBCALL-NEXT:    movw %ax, (%rbx)
; CHECK-LIBCALL-NEXT:    popq %rbx
; CHECK-LIBCALL-NEXT:    retq
;
; BWON-F16C-LABEL: test_trunc64:
; BWON-F16C:       # %bb.0:
; BWON-F16C-NEXT:    pushq %rbx
; BWON-F16C-NEXT:    movq %rdi, %rbx
; BWON-F16C-NEXT:    callq __truncdfhf2@PLT
; BWON-F16C-NEXT:    vpextrw $0, %xmm0, (%rbx)
; BWON-F16C-NEXT:    popq %rbx
; BWON-F16C-NEXT:    retq
;
; CHECK-I686-LABEL: test_trunc64:
; CHECK-I686:       # %bb.0:
; CHECK-I686-NEXT:    pushl %esi
; CHECK-I686-NEXT:    subl $8, %esp
; CHECK-I686-NEXT:    movl {{[0-9]+}}(%esp), %esi
; CHECK-I686-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; CHECK-I686-NEXT:    movq %xmm0, (%esp)
; CHECK-I686-NEXT:    calll __truncdfhf2
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %eax
; CHECK-I686-NEXT:    movw %ax, (%esi)
; CHECK-I686-NEXT:    addl $8, %esp
; CHECK-I686-NEXT:    popl %esi
; CHECK-I686-NEXT:    retl
  %val16 = fptrunc double %in to half
  store half %val16, ptr %addr
  ret void
}

define i64 @test_fptosi_i64(ptr %p) #0 {
; CHECK-LIBCALL-LABEL: test_fptosi_i64:
; CHECK-LIBCALL:       # %bb.0:
; CHECK-LIBCALL-NEXT:    pushq %rax
; CHECK-LIBCALL-NEXT:    pinsrw $0, (%rdi), %xmm0
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    cvttss2si %xmm0, %rax
; CHECK-LIBCALL-NEXT:    popq %rcx
; CHECK-LIBCALL-NEXT:    retq
;
; BWON-F16C-LABEL: test_fptosi_i64:
; BWON-F16C:       # %bb.0:
; BWON-F16C-NEXT:    movzwl (%rdi), %eax
; BWON-F16C-NEXT:    vmovd %eax, %xmm0
; BWON-F16C-NEXT:    vcvtph2ps %xmm0, %xmm0
; BWON-F16C-NEXT:    vcvttss2si %xmm0, %rax
; BWON-F16C-NEXT:    retq
;
; CHECK-I686-LABEL: test_fptosi_i64:
; CHECK-I686:       # %bb.0:
; CHECK-I686-NEXT:    subl $28, %esp
; CHECK-I686-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-I686-NEXT:    pinsrw $0, (%eax), %xmm0
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %eax
; CHECK-I686-NEXT:    movw %ax, (%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    flds {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    fnstcw {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; CHECK-I686-NEXT:    orl $3072, %eax # imm = 0xC00
; CHECK-I686-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    fldcw {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    fistpll {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    fldcw {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-I686-NEXT:    movl {{[0-9]+}}(%esp), %edx
; CHECK-I686-NEXT:    addl $28, %esp
; CHECK-I686-NEXT:    retl
  %a = load half, ptr %p, align 2
  %r = fptosi half %a to i64
  ret i64 %r
}

define void @test_sitofp_i64(i64 %a, ptr %p) #0 {
; CHECK-LIBCALL-LABEL: test_sitofp_i64:
; CHECK-LIBCALL:       # %bb.0:
; CHECK-LIBCALL-NEXT:    pushq %rbx
; CHECK-LIBCALL-NEXT:    movq %rsi, %rbx
; CHECK-LIBCALL-NEXT:    cvtsi2ss %rdi, %xmm0
; CHECK-LIBCALL-NEXT:    callq __truncsfhf2@PLT
; CHECK-LIBCALL-NEXT:    pextrw $0, %xmm0, %eax
; CHECK-LIBCALL-NEXT:    movw %ax, (%rbx)
; CHECK-LIBCALL-NEXT:    popq %rbx
; CHECK-LIBCALL-NEXT:    retq
;
; BWON-F16C-LABEL: test_sitofp_i64:
; BWON-F16C:       # %bb.0:
; BWON-F16C-NEXT:    vcvtsi2ss %rdi, %xmm0, %xmm0
; BWON-F16C-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; BWON-F16C-NEXT:    vmovd %xmm0, %eax
; BWON-F16C-NEXT:    movw %ax, (%rsi)
; BWON-F16C-NEXT:    retq
;
; CHECK-I686-LABEL: test_sitofp_i64:
; CHECK-I686:       # %bb.0:
; CHECK-I686-NEXT:    pushl %esi
; CHECK-I686-NEXT:    subl $24, %esp
; CHECK-I686-NEXT:    movl {{[0-9]+}}(%esp), %esi
; CHECK-I686-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; CHECK-I686-NEXT:    movlps %xmm0, {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    fildll {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:    movd %xmm0, (%esp)
; CHECK-I686-NEXT:    calll __truncsfhf2
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %eax
; CHECK-I686-NEXT:    movw %ax, (%esi)
; CHECK-I686-NEXT:    addl $24, %esp
; CHECK-I686-NEXT:    popl %esi
; CHECK-I686-NEXT:    retl
  %r = sitofp i64 %a to half
  store half %r, ptr %p
  ret void
}

define i64 @test_fptoui_i64(ptr %p) #0 {
; CHECK-LIBCALL-LABEL: test_fptoui_i64:
; CHECK-LIBCALL:       # %bb.0:
; CHECK-LIBCALL-NEXT:    pushq %rax
; CHECK-LIBCALL-NEXT:    pinsrw $0, (%rdi), %xmm0
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    cvttss2si %xmm0, %rcx
; CHECK-LIBCALL-NEXT:    movq %rcx, %rdx
; CHECK-LIBCALL-NEXT:    sarq $63, %rdx
; CHECK-LIBCALL-NEXT:    subss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-LIBCALL-NEXT:    cvttss2si %xmm0, %rax
; CHECK-LIBCALL-NEXT:    andq %rdx, %rax
; CHECK-LIBCALL-NEXT:    orq %rcx, %rax
; CHECK-LIBCALL-NEXT:    popq %rcx
; CHECK-LIBCALL-NEXT:    retq
;
; BWON-F16C-LABEL: test_fptoui_i64:
; BWON-F16C:       # %bb.0:
; BWON-F16C-NEXT:    movzwl (%rdi), %eax
; BWON-F16C-NEXT:    vmovd %eax, %xmm0
; BWON-F16C-NEXT:    vcvtph2ps %xmm0, %xmm0
; BWON-F16C-NEXT:    vcvttss2si %xmm0, %rcx
; BWON-F16C-NEXT:    movq %rcx, %rdx
; BWON-F16C-NEXT:    sarq $63, %rdx
; BWON-F16C-NEXT:    vsubss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; BWON-F16C-NEXT:    vcvttss2si %xmm0, %rax
; BWON-F16C-NEXT:    andq %rdx, %rax
; BWON-F16C-NEXT:    orq %rcx, %rax
; BWON-F16C-NEXT:    retq
;
; CHECK-I686-LABEL: test_fptoui_i64:
; CHECK-I686:       # %bb.0:
; CHECK-I686-NEXT:    subl $28, %esp
; CHECK-I686-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-I686-NEXT:    pinsrw $0, (%eax), %xmm0
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %eax
; CHECK-I686-NEXT:    movw %ax, (%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:    ucomiss %xmm1, %xmm0
; CHECK-I686-NEXT:    jae .LBB9_2
; CHECK-I686-NEXT:  # %bb.1:
; CHECK-I686-NEXT:    xorps %xmm1, %xmm1
; CHECK-I686-NEXT:  .LBB9_2:
; CHECK-I686-NEXT:    subss %xmm1, %xmm0
; CHECK-I686-NEXT:    movss %xmm0, {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    setae %al
; CHECK-I686-NEXT:    flds {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    fnstcw {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; CHECK-I686-NEXT:    orl $3072, %ecx # imm = 0xC00
; CHECK-I686-NEXT:    movw %cx, {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    fldcw {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    fistpll {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    fldcw {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    movzbl %al, %edx
; CHECK-I686-NEXT:    shll $31, %edx
; CHECK-I686-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; CHECK-I686-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-I686-NEXT:    addl $28, %esp
; CHECK-I686-NEXT:    retl
  %a = load half, ptr %p, align 2
  %r = fptoui half %a to i64
  ret i64 %r
}

define void @test_uitofp_i64(i64 %a, ptr %p) #0 {
; CHECK-LIBCALL-LABEL: test_uitofp_i64:
; CHECK-LIBCALL:       # %bb.0:
; CHECK-LIBCALL-NEXT:    pushq %rbx
; CHECK-LIBCALL-NEXT:    movq %rsi, %rbx
; CHECK-LIBCALL-NEXT:    testq %rdi, %rdi
; CHECK-LIBCALL-NEXT:    js .LBB10_1
; CHECK-LIBCALL-NEXT:  # %bb.2:
; CHECK-LIBCALL-NEXT:    cvtsi2ss %rdi, %xmm0
; CHECK-LIBCALL-NEXT:    jmp .LBB10_3
; CHECK-LIBCALL-NEXT:  .LBB10_1:
; CHECK-LIBCALL-NEXT:    movq %rdi, %rax
; CHECK-LIBCALL-NEXT:    shrq %rax
; CHECK-LIBCALL-NEXT:    andl $1, %edi
; CHECK-LIBCALL-NEXT:    orq %rax, %rdi
; CHECK-LIBCALL-NEXT:    cvtsi2ss %rdi, %xmm0
; CHECK-LIBCALL-NEXT:    addss %xmm0, %xmm0
; CHECK-LIBCALL-NEXT:  .LBB10_3:
; CHECK-LIBCALL-NEXT:    callq __truncsfhf2@PLT
; CHECK-LIBCALL-NEXT:    pextrw $0, %xmm0, %eax
; CHECK-LIBCALL-NEXT:    movw %ax, (%rbx)
; CHECK-LIBCALL-NEXT:    popq %rbx
; CHECK-LIBCALL-NEXT:    retq
;
; BWON-F16C-LABEL: test_uitofp_i64:
; BWON-F16C:       # %bb.0:
; BWON-F16C-NEXT:    testq %rdi, %rdi
; BWON-F16C-NEXT:    js .LBB10_1
; BWON-F16C-NEXT:  # %bb.2:
; BWON-F16C-NEXT:    vcvtsi2ss %rdi, %xmm0, %xmm0
; BWON-F16C-NEXT:    jmp .LBB10_3
; BWON-F16C-NEXT:  .LBB10_1:
; BWON-F16C-NEXT:    movq %rdi, %rax
; BWON-F16C-NEXT:    shrq %rax
; BWON-F16C-NEXT:    andl $1, %edi
; BWON-F16C-NEXT:    orq %rax, %rdi
; BWON-F16C-NEXT:    vcvtsi2ss %rdi, %xmm0, %xmm0
; BWON-F16C-NEXT:    vaddss %xmm0, %xmm0, %xmm0
; BWON-F16C-NEXT:  .LBB10_3:
; BWON-F16C-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; BWON-F16C-NEXT:    vmovd %xmm0, %eax
; BWON-F16C-NEXT:    movw %ax, (%rsi)
; BWON-F16C-NEXT:    retq
;
; CHECK-I686-LABEL: test_uitofp_i64:
; CHECK-I686:       # %bb.0:
; CHECK-I686-NEXT:    pushl %esi
; CHECK-I686-NEXT:    subl $24, %esp
; CHECK-I686-NEXT:    movl {{[0-9]+}}(%esp), %esi
; CHECK-I686-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-I686-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; CHECK-I686-NEXT:    movq %xmm0, {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    shrl $31, %eax
; CHECK-I686-NEXT:    fildll {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    fadds {{\.?LCPI[0-9]+_[0-9]+}}(,%eax,4)
; CHECK-I686-NEXT:    fstps (%esp)
; CHECK-I686-NEXT:    calll __truncsfhf2
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %eax
; CHECK-I686-NEXT:    movw %ax, (%esi)
; CHECK-I686-NEXT:    addl $24, %esp
; CHECK-I686-NEXT:    popl %esi
; CHECK-I686-NEXT:    retl
  %r = uitofp i64 %a to half
  store half %r, ptr %p
  ret void
}

define <4 x float> @test_extend32_vec4(ptr %p) #0 {
; CHECK-LIBCALL-LABEL: test_extend32_vec4:
; CHECK-LIBCALL:       # %bb.0:
; CHECK-LIBCALL-NEXT:    subq $72, %rsp
; CHECK-LIBCALL-NEXT:    pinsrw $0, (%rdi), %xmm0
; CHECK-LIBCALL-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    pinsrw $0, 2(%rdi), %xmm0
; CHECK-LIBCALL-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    pinsrw $0, 4(%rdi), %xmm0
; CHECK-LIBCALL-NEXT:    movdqa %xmm0, (%rsp) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    pinsrw $0, 6(%rdi), %xmm0
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    unpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; CHECK-LIBCALL-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; CHECK-LIBCALL-NEXT:    movaps %xmm0, (%rsp) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    unpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; CHECK-LIBCALL-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; CHECK-LIBCALL-NEXT:    unpcklpd (%rsp), %xmm0 # 16-byte Folded Reload
; CHECK-LIBCALL-NEXT:    # xmm0 = xmm0[0],mem[0]
; CHECK-LIBCALL-NEXT:    addq $72, %rsp
; CHECK-LIBCALL-NEXT:    retq
;
; BWON-F16C-LABEL: test_extend32_vec4:
; BWON-F16C:       # %bb.0:
; BWON-F16C-NEXT:    vcvtph2ps (%rdi), %xmm0
; BWON-F16C-NEXT:    retq
;
; CHECK-I686-LABEL: test_extend32_vec4:
; CHECK-I686:       # %bb.0:
; CHECK-I686-NEXT:    pushl %esi
; CHECK-I686-NEXT:    subl $88, %esp
; CHECK-I686-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-I686-NEXT:    pinsrw $0, (%eax), %xmm0
; CHECK-I686-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%e{{[sb]}}p) # 16-byte Spill
; CHECK-I686-NEXT:    pinsrw $0, 6(%eax), %xmm0
; CHECK-I686-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%e{{[sb]}}p) # 16-byte Spill
; CHECK-I686-NEXT:    pinsrw $0, 4(%eax), %xmm0
; CHECK-I686-NEXT:    pinsrw $0, 2(%eax), %xmm1
; CHECK-I686-NEXT:    pextrw $0, %xmm1, %eax
; CHECK-I686-NEXT:    movw %ax, (%esp)
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %esi
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    fstpt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Spill
; CHECK-I686-NEXT:    movw %si, (%esp)
; CHECK-I686-NEXT:    movdqa {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %esi
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    fstpt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Spill
; CHECK-I686-NEXT:    movw %si, (%esp)
; CHECK-I686-NEXT:    movdqa {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %esi
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    movw %si, (%esp)
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    fldt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Reload
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    fldt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Reload
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; CHECK-I686-NEXT:    movss {{.*#+}} xmm2 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; CHECK-I686-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; CHECK-I686-NEXT:    addl $88, %esp
; CHECK-I686-NEXT:    popl %esi
; CHECK-I686-NEXT:    retl
  %a = load <4 x half>, ptr %p, align 8
  %b = fpext <4 x half> %a to <4 x float>
  ret <4 x float> %b
}

define <4 x double> @test_extend64_vec4(ptr %p) #0 {
; CHECK-LIBCALL-LABEL: test_extend64_vec4:
; CHECK-LIBCALL:       # %bb.0:
; CHECK-LIBCALL-NEXT:    subq $72, %rsp
; CHECK-LIBCALL-NEXT:    pinsrw $0, 4(%rdi), %xmm0
; CHECK-LIBCALL-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    pinsrw $0, 6(%rdi), %xmm0
; CHECK-LIBCALL-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    pinsrw $0, (%rdi), %xmm0
; CHECK-LIBCALL-NEXT:    movdqa %xmm0, (%rsp) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    pinsrw $0, 2(%rdi), %xmm0
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    cvtss2sd %xmm0, %xmm0
; CHECK-LIBCALL-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    cvtss2sd %xmm0, %xmm0
; CHECK-LIBCALL-NEXT:    unpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; CHECK-LIBCALL-NEXT:    # xmm0 = xmm0[0],mem[0]
; CHECK-LIBCALL-NEXT:    movaps %xmm0, (%rsp) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    cvtss2sd %xmm0, %xmm0
; CHECK-LIBCALL-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    cvtss2sd %xmm0, %xmm1
; CHECK-LIBCALL-NEXT:    unpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; CHECK-LIBCALL-NEXT:    # xmm1 = xmm1[0],mem[0]
; CHECK-LIBCALL-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    addq $72, %rsp
; CHECK-LIBCALL-NEXT:    retq
;
; BWON-F16C-LABEL: test_extend64_vec4:
; BWON-F16C:       # %bb.0:
; BWON-F16C-NEXT:    vcvtph2ps (%rdi), %xmm0
; BWON-F16C-NEXT:    vcvtps2pd %xmm0, %ymm0
; BWON-F16C-NEXT:    retq
;
; CHECK-I686-LABEL: test_extend64_vec4:
; CHECK-I686:       # %bb.0:
; CHECK-I686-NEXT:    pushl %esi
; CHECK-I686-NEXT:    subl $104, %esp
; CHECK-I686-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-I686-NEXT:    pinsrw $0, 6(%eax), %xmm0
; CHECK-I686-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%e{{[sb]}}p) # 16-byte Spill
; CHECK-I686-NEXT:    pinsrw $0, (%eax), %xmm0
; CHECK-I686-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%e{{[sb]}}p) # 16-byte Spill
; CHECK-I686-NEXT:    pinsrw $0, 2(%eax), %xmm0
; CHECK-I686-NEXT:    pinsrw $0, 4(%eax), %xmm1
; CHECK-I686-NEXT:    pextrw $0, %xmm1, %eax
; CHECK-I686-NEXT:    movw %ax, (%esp)
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %esi
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    fstpt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Spill
; CHECK-I686-NEXT:    movw %si, (%esp)
; CHECK-I686-NEXT:    movdqa {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %esi
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    fstpt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Spill
; CHECK-I686-NEXT:    movw %si, (%esp)
; CHECK-I686-NEXT:    movdqa {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %esi
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    movw %si, (%esp)
; CHECK-I686-NEXT:    fstpl {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    fldt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Reload
; CHECK-I686-NEXT:    fstpl {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    fldt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Reload
; CHECK-I686-NEXT:    fstpl {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    fstpl {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; CHECK-I686-NEXT:    movhps {{.*#+}} xmm0 = xmm0[0,1],mem[0,1]
; CHECK-I686-NEXT:    movsd {{.*#+}} xmm1 = mem[0],zero
; CHECK-I686-NEXT:    movhps {{.*#+}} xmm1 = xmm1[0,1],mem[0,1]
; CHECK-I686-NEXT:    addl $104, %esp
; CHECK-I686-NEXT:    popl %esi
; CHECK-I686-NEXT:    retl
  %a = load <4 x half>, ptr %p, align 8
  %b = fpext <4 x half> %a to <4 x double>
  ret <4 x double> %b
}

define void @test_trunc32_vec4(<4 x float> %a, ptr %p) #0 {
; CHECK-LIBCALL-LABEL: test_trunc32_vec4:
; CHECK-LIBCALL:       # %bb.0:
; CHECK-LIBCALL-NEXT:    pushq %rbx
; CHECK-LIBCALL-NEXT:    subq $64, %rsp
; CHECK-LIBCALL-NEXT:    movq %rdi, %rbx
; CHECK-LIBCALL-NEXT:    movaps %xmm0, (%rsp) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; CHECK-LIBCALL-NEXT:    callq __truncsfhf2@PLT
; CHECK-LIBCALL-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; CHECK-LIBCALL-NEXT:    callq __truncsfhf2@PLT
; CHECK-LIBCALL-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3,3,3]
; CHECK-LIBCALL-NEXT:    callq __truncsfhf2@PLT
; CHECK-LIBCALL-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    callq __truncsfhf2@PLT
; CHECK-LIBCALL-NEXT:    pextrw $0, %xmm0, %eax
; CHECK-LIBCALL-NEXT:    movw %ax, (%rbx)
; CHECK-LIBCALL-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    pextrw $0, %xmm0, %eax
; CHECK-LIBCALL-NEXT:    movw %ax, 6(%rbx)
; CHECK-LIBCALL-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    pextrw $0, %xmm0, %eax
; CHECK-LIBCALL-NEXT:    movw %ax, 4(%rbx)
; CHECK-LIBCALL-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    pextrw $0, %xmm0, %eax
; CHECK-LIBCALL-NEXT:    movw %ax, 2(%rbx)
; CHECK-LIBCALL-NEXT:    addq $64, %rsp
; CHECK-LIBCALL-NEXT:    popq %rbx
; CHECK-LIBCALL-NEXT:    retq
;
; BWON-F16C-LABEL: test_trunc32_vec4:
; BWON-F16C:       # %bb.0:
; BWON-F16C-NEXT:    vcvtps2ph $4, %xmm0, (%rdi)
; BWON-F16C-NEXT:    retq
;
; CHECK-I686-LABEL: test_trunc32_vec4:
; CHECK-I686:       # %bb.0:
; CHECK-I686-NEXT:    pushl %esi
; CHECK-I686-NEXT:    subl $88, %esp
; CHECK-I686-NEXT:    movaps %xmm0, {{[-0-9]+}}(%e{{[sb]}}p) # 16-byte Spill
; CHECK-I686-NEXT:    movl {{[0-9]+}}(%esp), %esi
; CHECK-I686-NEXT:    movaps %xmm0, %xmm1
; CHECK-I686-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm0[1,1]
; CHECK-I686-NEXT:    movss %xmm1, (%esp)
; CHECK-I686-NEXT:    calll __truncsfhf2
; CHECK-I686-NEXT:    movaps %xmm0, {{[-0-9]+}}(%e{{[sb]}}p) # 16-byte Spill
; CHECK-I686-NEXT:    movaps {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-I686-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; CHECK-I686-NEXT:    movss %xmm0, (%esp)
; CHECK-I686-NEXT:    calll __truncsfhf2
; CHECK-I686-NEXT:    movaps %xmm0, {{[-0-9]+}}(%e{{[sb]}}p) # 16-byte Spill
; CHECK-I686-NEXT:    movaps {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-I686-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3,3,3]
; CHECK-I686-NEXT:    movss %xmm0, (%esp)
; CHECK-I686-NEXT:    calll __truncsfhf2
; CHECK-I686-NEXT:    movaps %xmm0, {{[-0-9]+}}(%e{{[sb]}}p) # 16-byte Spill
; CHECK-I686-NEXT:    movdqa {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-I686-NEXT:    movd %xmm0, (%esp)
; CHECK-I686-NEXT:    calll __truncsfhf2
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %eax
; CHECK-I686-NEXT:    movw %ax, (%esi)
; CHECK-I686-NEXT:    movdqa {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %eax
; CHECK-I686-NEXT:    movw %ax, 6(%esi)
; CHECK-I686-NEXT:    movdqa {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %eax
; CHECK-I686-NEXT:    movw %ax, 4(%esi)
; CHECK-I686-NEXT:    movdqa {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %eax
; CHECK-I686-NEXT:    movw %ax, 2(%esi)
; CHECK-I686-NEXT:    addl $88, %esp
; CHECK-I686-NEXT:    popl %esi
; CHECK-I686-NEXT:    retl
  %v = fptrunc <4 x float> %a to <4 x half>
  store <4 x half> %v, ptr %p
  ret void
}

define void @test_trunc64_vec4(<4 x double> %a, ptr %p) #0 {
; CHECK-LIBCALL-LABEL: test_trunc64_vec4:
; CHECK-LIBCALL:       # %bb.0:
; CHECK-LIBCALL-NEXT:    pushq %rbx
; CHECK-LIBCALL-NEXT:    subq $64, %rsp
; CHECK-LIBCALL-NEXT:    movq %rdi, %rbx
; CHECK-LIBCALL-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    movaps %xmm0, (%rsp) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; CHECK-LIBCALL-NEXT:    callq __truncdfhf2@PLT
; CHECK-LIBCALL-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; CHECK-LIBCALL-NEXT:    callq __truncdfhf2@PLT
; CHECK-LIBCALL-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    callq __truncdfhf2@PLT
; CHECK-LIBCALL-NEXT:    movaps %xmm0, (%rsp) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    callq __truncdfhf2@PLT
; CHECK-LIBCALL-NEXT:    pextrw $0, %xmm0, %eax
; CHECK-LIBCALL-NEXT:    movw %ax, 4(%rbx)
; CHECK-LIBCALL-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    pextrw $0, %xmm0, %eax
; CHECK-LIBCALL-NEXT:    movw %ax, (%rbx)
; CHECK-LIBCALL-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    pextrw $0, %xmm0, %eax
; CHECK-LIBCALL-NEXT:    movw %ax, 6(%rbx)
; CHECK-LIBCALL-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    pextrw $0, %xmm0, %eax
; CHECK-LIBCALL-NEXT:    movw %ax, 2(%rbx)
; CHECK-LIBCALL-NEXT:    addq $64, %rsp
; CHECK-LIBCALL-NEXT:    popq %rbx
; CHECK-LIBCALL-NEXT:    retq
;
; BWON-F16C-LABEL: test_trunc64_vec4:
; BWON-F16C:       # %bb.0:
; BWON-F16C-NEXT:    pushq %rbx
; BWON-F16C-NEXT:    subq $64, %rsp
; BWON-F16C-NEXT:    movq %rdi, %rbx
; BWON-F16C-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; BWON-F16C-NEXT:    vextractf128 $1, %ymm0, %xmm0
; BWON-F16C-NEXT:    vmovaps %xmm0, (%rsp) # 16-byte Spill
; BWON-F16C-NEXT:    vzeroupper
; BWON-F16C-NEXT:    callq __truncdfhf2@PLT
; BWON-F16C-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; BWON-F16C-NEXT:    vpermilpd $1, (%rsp), %xmm0 # 16-byte Folded Reload
; BWON-F16C-NEXT:    # xmm0 = mem[1,0]
; BWON-F16C-NEXT:    callq __truncdfhf2@PLT
; BWON-F16C-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; BWON-F16C-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; BWON-F16C-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; BWON-F16C-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; BWON-F16C-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; BWON-F16C-NEXT:    vzeroupper
; BWON-F16C-NEXT:    callq __truncdfhf2@PLT
; BWON-F16C-NEXT:    vmovaps %xmm0, (%rsp) # 16-byte Spill
; BWON-F16C-NEXT:    vpermilpd $1, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; BWON-F16C-NEXT:    # xmm0 = mem[1,0]
; BWON-F16C-NEXT:    callq __truncdfhf2@PLT
; BWON-F16C-NEXT:    vmovdqa (%rsp), %xmm1 # 16-byte Reload
; BWON-F16C-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; BWON-F16C-NEXT:    vpunpckldq {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; BWON-F16C-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; BWON-F16C-NEXT:    vmovq %xmm0, (%rbx)
; BWON-F16C-NEXT:    addq $64, %rsp
; BWON-F16C-NEXT:    popq %rbx
; BWON-F16C-NEXT:    retq
;
; CHECK-I686-LABEL: test_trunc64_vec4:
; CHECK-I686:       # %bb.0:
; CHECK-I686-NEXT:    pushl %esi
; CHECK-I686-NEXT:    subl $88, %esp
; CHECK-I686-NEXT:    movaps %xmm1, {{[-0-9]+}}(%e{{[sb]}}p) # 16-byte Spill
; CHECK-I686-NEXT:    movaps %xmm0, {{[-0-9]+}}(%e{{[sb]}}p) # 16-byte Spill
; CHECK-I686-NEXT:    movl {{[0-9]+}}(%esp), %esi
; CHECK-I686-NEXT:    movlps %xmm0, (%esp)
; CHECK-I686-NEXT:    calll __truncdfhf2
; CHECK-I686-NEXT:    movaps %xmm0, {{[-0-9]+}}(%e{{[sb]}}p) # 16-byte Spill
; CHECK-I686-NEXT:    movaps {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-I686-NEXT:    movhps %xmm0, (%esp)
; CHECK-I686-NEXT:    calll __truncdfhf2
; CHECK-I686-NEXT:    movaps %xmm0, {{[-0-9]+}}(%e{{[sb]}}p) # 16-byte Spill
; CHECK-I686-NEXT:    movaps {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-I686-NEXT:    movlps %xmm0, (%esp)
; CHECK-I686-NEXT:    calll __truncdfhf2
; CHECK-I686-NEXT:    movaps %xmm0, {{[-0-9]+}}(%e{{[sb]}}p) # 16-byte Spill
; CHECK-I686-NEXT:    movaps {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-I686-NEXT:    movhps %xmm0, (%esp)
; CHECK-I686-NEXT:    calll __truncdfhf2
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %eax
; CHECK-I686-NEXT:    movw %ax, 6(%esi)
; CHECK-I686-NEXT:    movdqa {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %eax
; CHECK-I686-NEXT:    movw %ax, 4(%esi)
; CHECK-I686-NEXT:    movdqa {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %eax
; CHECK-I686-NEXT:    movw %ax, 2(%esi)
; CHECK-I686-NEXT:    movdqa {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %eax
; CHECK-I686-NEXT:    movw %ax, (%esi)
; CHECK-I686-NEXT:    addl $88, %esp
; CHECK-I686-NEXT:    popl %esi
; CHECK-I686-NEXT:    retl
  %v = fptrunc <4 x double> %a to <4 x half>
  store <4 x half> %v, ptr %p
  ret void
}

declare float @test_floatret();

; On i686, if SSE2 is available, the return value from test_floatret is loaded
; to f80 and then rounded to f32.  The DAG combiner should not combine this
; fp_round and the subsequent fptrunc from float to half.
define half @test_f80trunc_nodagcombine() #0 {
; CHECK-LIBCALL-LABEL: test_f80trunc_nodagcombine:
; CHECK-LIBCALL:       # %bb.0:
; CHECK-LIBCALL-NEXT:    pushq %rax
; CHECK-LIBCALL-NEXT:    callq test_floatret@PLT
; CHECK-LIBCALL-NEXT:    callq __truncsfhf2@PLT
; CHECK-LIBCALL-NEXT:    popq %rax
; CHECK-LIBCALL-NEXT:    retq
;
; BWON-F16C-LABEL: test_f80trunc_nodagcombine:
; BWON-F16C:       # %bb.0:
; BWON-F16C-NEXT:    pushq %rax
; BWON-F16C-NEXT:    callq test_floatret@PLT
; BWON-F16C-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; BWON-F16C-NEXT:    vmovd %xmm0, %eax
; BWON-F16C-NEXT:    vpinsrw $0, %eax, %xmm0, %xmm0
; BWON-F16C-NEXT:    popq %rax
; BWON-F16C-NEXT:    retq
;
; CHECK-I686-LABEL: test_f80trunc_nodagcombine:
; CHECK-I686:       # %bb.0:
; CHECK-I686-NEXT:    subl $12, %esp
; CHECK-I686-NEXT:    calll test_floatret@PLT
; CHECK-I686-NEXT:    fstps (%esp)
; CHECK-I686-NEXT:    calll __truncsfhf2
; CHECK-I686-NEXT:    addl $12, %esp
; CHECK-I686-NEXT:    retl
  %1 = call float @test_floatret()
  %2 = fptrunc float %1 to half
  ret half %2
}




define float @test_sitofp_fadd_i32(i32 %a, ptr %b) #0 {
; CHECK-LIBCALL-LABEL: test_sitofp_fadd_i32:
; CHECK-LIBCALL:       # %bb.0:
; CHECK-LIBCALL-NEXT:    subq $40, %rsp
; CHECK-LIBCALL-NEXT:    pinsrw $0, (%rsi), %xmm0
; CHECK-LIBCALL-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    xorps %xmm0, %xmm0
; CHECK-LIBCALL-NEXT:    cvtsi2ss %edi, %xmm0
; CHECK-LIBCALL-NEXT:    callq __truncsfhf2@PLT
; CHECK-LIBCALL-NEXT:    movss %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 4-byte Spill
; CHECK-LIBCALL-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    movss %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 4-byte Spill
; CHECK-LIBCALL-NEXT:    movss {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 4-byte Reload
; CHECK-LIBCALL-NEXT:    # xmm0 = mem[0],zero,zero,zero
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    addss {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 4-byte Folded Reload
; CHECK-LIBCALL-NEXT:    callq __truncsfhf2@PLT
; CHECK-LIBCALL-NEXT:    addq $40, %rsp
; CHECK-LIBCALL-NEXT:    jmp __extendhfsf2@PLT # TAILCALL
;
; BWON-F16C-LABEL: test_sitofp_fadd_i32:
; BWON-F16C:       # %bb.0:
; BWON-F16C-NEXT:    movzwl (%rsi), %eax
; BWON-F16C-NEXT:    vcvtsi2ss %edi, %xmm0, %xmm0
; BWON-F16C-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; BWON-F16C-NEXT:    vpmovzxwq {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero
; BWON-F16C-NEXT:    vcvtph2ps %xmm0, %xmm0
; BWON-F16C-NEXT:    vmovd %eax, %xmm1
; BWON-F16C-NEXT:    vcvtph2ps %xmm1, %xmm1
; BWON-F16C-NEXT:    vaddss %xmm0, %xmm1, %xmm0
; BWON-F16C-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; BWON-F16C-NEXT:    vpmovzxwq {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero
; BWON-F16C-NEXT:    vcvtph2ps %xmm0, %xmm0
; BWON-F16C-NEXT:    retq
;
; CHECK-I686-LABEL: test_sitofp_fadd_i32:
; CHECK-I686:       # %bb.0:
; CHECK-I686-NEXT:    subl $60, %esp
; CHECK-I686-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-I686-NEXT:    pinsrw $0, (%eax), %xmm0
; CHECK-I686-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%e{{[sb]}}p) # 16-byte Spill
; CHECK-I686-NEXT:    xorps %xmm0, %xmm0
; CHECK-I686-NEXT:    cvtsi2ssl {{[0-9]+}}(%esp), %xmm0
; CHECK-I686-NEXT:    movss %xmm0, (%esp)
; CHECK-I686-NEXT:    calll __truncsfhf2
; CHECK-I686-NEXT:    movaps %xmm0, {{[-0-9]+}}(%e{{[sb]}}p) # 16-byte Spill
; CHECK-I686-NEXT:    movdqa {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %eax
; CHECK-I686-NEXT:    movw %ax, (%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    movdqa {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %eax
; CHECK-I686-NEXT:    movw %ax, (%esp)
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:    addss {{[0-9]+}}(%esp), %xmm0
; CHECK-I686-NEXT:    movss %xmm0, (%esp)
; CHECK-I686-NEXT:    calll __truncsfhf2
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %eax
; CHECK-I686-NEXT:    movw %ax, (%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    addl $60, %esp
; CHECK-I686-NEXT:    retl
  %tmp0 = load half, ptr %b
  %tmp1 = sitofp i32 %a to half
  %tmp2 = fadd half %tmp0, %tmp1
  %tmp3 = fpext half %tmp2 to float
  ret float %tmp3
}

define half @PR40273(half) #0 {
; CHECK-LIBCALL-LABEL: PR40273:
; CHECK-LIBCALL:       # %bb.0:
; CHECK-LIBCALL-NEXT:    pushq %rax
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    xorl %eax, %eax
; CHECK-LIBCALL-NEXT:    xorps %xmm1, %xmm1
; CHECK-LIBCALL-NEXT:    ucomiss %xmm1, %xmm0
; CHECK-LIBCALL-NEXT:    movl $15360, %ecx # imm = 0x3C00
; CHECK-LIBCALL-NEXT:    cmovnel %ecx, %eax
; CHECK-LIBCALL-NEXT:    cmovpl %ecx, %eax
; CHECK-LIBCALL-NEXT:    pinsrw $0, %eax, %xmm0
; CHECK-LIBCALL-NEXT:    popq %rax
; CHECK-LIBCALL-NEXT:    retq
;
; BWON-F16C-LABEL: PR40273:
; BWON-F16C:       # %bb.0:
; BWON-F16C-NEXT:    vpextrw $0, %xmm0, %eax
; BWON-F16C-NEXT:    movzwl %ax, %eax
; BWON-F16C-NEXT:    vmovd %eax, %xmm0
; BWON-F16C-NEXT:    vcvtph2ps %xmm0, %xmm0
; BWON-F16C-NEXT:    xorl %eax, %eax
; BWON-F16C-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; BWON-F16C-NEXT:    vucomiss %xmm1, %xmm0
; BWON-F16C-NEXT:    movl $15360, %ecx # imm = 0x3C00
; BWON-F16C-NEXT:    cmovnel %ecx, %eax
; BWON-F16C-NEXT:    cmovpl %ecx, %eax
; BWON-F16C-NEXT:    vpinsrw $0, %eax, %xmm0, %xmm0
; BWON-F16C-NEXT:    retq
;
; CHECK-I686-LABEL: PR40273:
; CHECK-I686:       # %bb.0:
; CHECK-I686-NEXT:    subl $12, %esp
; CHECK-I686-NEXT:    pinsrw $0, {{[0-9]+}}(%esp), %xmm0
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %eax
; CHECK-I686-NEXT:    movw %ax, (%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:    xorl %eax, %eax
; CHECK-I686-NEXT:    xorps %xmm1, %xmm1
; CHECK-I686-NEXT:    ucomiss %xmm1, %xmm0
; CHECK-I686-NEXT:    movl $15360, %ecx # imm = 0x3C00
; CHECK-I686-NEXT:    cmovnel %ecx, %eax
; CHECK-I686-NEXT:    cmovpl %ecx, %eax
; CHECK-I686-NEXT:    pinsrw $0, %eax, %xmm0
; CHECK-I686-NEXT:    addl $12, %esp
; CHECK-I686-NEXT:    retl
  %2 = fcmp une half %0, 0xH0000
  %3 = uitofp i1 %2 to half
  ret half %3
}

define void @brcond(half %0) #0 {
; CHECK-LIBCALL-LABEL: brcond:
; CHECK-LIBCALL:       # %bb.0: # %entry
; CHECK-LIBCALL-NEXT:    pushq %rax
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    xorps %xmm1, %xmm1
; CHECK-LIBCALL-NEXT:    ucomiss %xmm1, %xmm0
; CHECK-LIBCALL-NEXT:    setp %al
; CHECK-LIBCALL-NEXT:    setne %cl
; CHECK-LIBCALL-NEXT:    orb %al, %cl
; CHECK-LIBCALL-NEXT:    jne .LBB18_2
; CHECK-LIBCALL-NEXT:  # %bb.1: # %if.then
; CHECK-LIBCALL-NEXT:    popq %rax
; CHECK-LIBCALL-NEXT:    retq
; CHECK-LIBCALL-NEXT:  .LBB18_2: # %if.end
;
; BWON-F16C-LABEL: brcond:
; BWON-F16C:       # %bb.0: # %entry
; BWON-F16C-NEXT:    vpextrw $0, %xmm0, %eax
; BWON-F16C-NEXT:    movzwl %ax, %eax
; BWON-F16C-NEXT:    vmovd %eax, %xmm0
; BWON-F16C-NEXT:    vcvtph2ps %xmm0, %xmm0
; BWON-F16C-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; BWON-F16C-NEXT:    vucomiss %xmm1, %xmm0
; BWON-F16C-NEXT:    setp %al
; BWON-F16C-NEXT:    setne %cl
; BWON-F16C-NEXT:    orb %al, %cl
; BWON-F16C-NEXT:    jne .LBB18_2
; BWON-F16C-NEXT:  # %bb.1: # %if.then
; BWON-F16C-NEXT:    retq
; BWON-F16C-NEXT:  .LBB18_2: # %if.end
;
; CHECK-I686-LABEL: brcond:
; CHECK-I686:       # %bb.0: # %entry
; CHECK-I686-NEXT:    subl $12, %esp
; CHECK-I686-NEXT:    pinsrw $0, {{[0-9]+}}(%esp), %xmm0
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %eax
; CHECK-I686-NEXT:    movw %ax, (%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:    xorps %xmm1, %xmm1
; CHECK-I686-NEXT:    ucomiss %xmm1, %xmm0
; CHECK-I686-NEXT:    setp %al
; CHECK-I686-NEXT:    setne %cl
; CHECK-I686-NEXT:    orb %al, %cl
; CHECK-I686-NEXT:    jne .LBB18_2
; CHECK-I686-NEXT:  # %bb.1: # %if.then
; CHECK-I686-NEXT:    addl $12, %esp
; CHECK-I686-NEXT:    retl
; CHECK-I686-NEXT:  .LBB18_2: # %if.end
entry:
  %cmp = fcmp oeq half 0xH0000, %0
  br i1 %cmp, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  ret void

if.end:                                           ; preds = %entry
  unreachable
}

define half @test_sqrt(half %0) #0 {
; CHECK-LIBCALL-LABEL: test_sqrt:
; CHECK-LIBCALL:       # %bb.0: # %entry
; CHECK-LIBCALL-NEXT:    pushq %rax
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    sqrtss %xmm0, %xmm0
; CHECK-LIBCALL-NEXT:    callq __truncsfhf2@PLT
; CHECK-LIBCALL-NEXT:    popq %rax
; CHECK-LIBCALL-NEXT:    retq
;
; BWON-F16C-LABEL: test_sqrt:
; BWON-F16C:       # %bb.0: # %entry
; BWON-F16C-NEXT:    vpextrw $0, %xmm0, %eax
; BWON-F16C-NEXT:    movzwl %ax, %eax
; BWON-F16C-NEXT:    vmovd %eax, %xmm0
; BWON-F16C-NEXT:    vcvtph2ps %xmm0, %xmm0
; BWON-F16C-NEXT:    vsqrtss %xmm0, %xmm0, %xmm0
; BWON-F16C-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; BWON-F16C-NEXT:    vmovd %xmm0, %eax
; BWON-F16C-NEXT:    vpinsrw $0, %eax, %xmm0, %xmm0
; BWON-F16C-NEXT:    retq
;
; CHECK-I686-LABEL: test_sqrt:
; CHECK-I686:       # %bb.0: # %entry
; CHECK-I686-NEXT:    subl $12, %esp
; CHECK-I686-NEXT:    pinsrw $0, {{[0-9]+}}(%esp), %xmm0
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %eax
; CHECK-I686-NEXT:    movw %ax, (%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:    sqrtss %xmm0, %xmm0
; CHECK-I686-NEXT:    movss %xmm0, (%esp)
; CHECK-I686-NEXT:    calll __truncsfhf2
; CHECK-I686-NEXT:    addl $12, %esp
; CHECK-I686-NEXT:    retl
entry:
  %1 = call half @llvm.sqrt.f16(half %0)
  ret half %1
}

declare half @llvm.sqrt.f16(half)

define void @main.158() #0 {
; CHECK-LIBCALL-LABEL: main.158:
; CHECK-LIBCALL:       # %bb.0: # %entry
; CHECK-LIBCALL-NEXT:    pushq %rax
; CHECK-LIBCALL-NEXT:    xorps %xmm0, %xmm0
; CHECK-LIBCALL-NEXT:    callq __truncsfhf2@PLT
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; CHECK-LIBCALL-NEXT:    ucomiss %xmm0, %xmm1
; CHECK-LIBCALL-NEXT:    xorps %xmm0, %xmm0
; CHECK-LIBCALL-NEXT:    jae .LBB20_2
; CHECK-LIBCALL-NEXT:  # %bb.1: # %entry
; CHECK-LIBCALL-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-LIBCALL-NEXT:  .LBB20_2: # %entry
; CHECK-LIBCALL-NEXT:    callq __truncsfhf2@PLT
; CHECK-LIBCALL-NEXT:    pextrw $0, %xmm0, %eax
; CHECK-LIBCALL-NEXT:    movw %ax, (%rax)
; CHECK-LIBCALL-NEXT:    popq %rax
; CHECK-LIBCALL-NEXT:    retq
;
; BWON-F16C-LABEL: main.158:
; BWON-F16C:       # %bb.0: # %entry
; BWON-F16C-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; BWON-F16C-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; BWON-F16C-NEXT:    vpmovzxwq {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero
; BWON-F16C-NEXT:    vcvtph2ps %xmm0, %xmm0
; BWON-F16C-NEXT:    vmovss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; BWON-F16C-NEXT:    vucomiss %xmm0, %xmm1
; BWON-F16C-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; BWON-F16C-NEXT:    jae .LBB20_2
; BWON-F16C-NEXT:  # %bb.1: # %entry
; BWON-F16C-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; BWON-F16C-NEXT:  .LBB20_2: # %entry
; BWON-F16C-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; BWON-F16C-NEXT:    vmovd %xmm0, %eax
; BWON-F16C-NEXT:    movw %ax, (%rax)
; BWON-F16C-NEXT:    retq
;
; CHECK-I686-LABEL: main.158:
; CHECK-I686:       # %bb.0: # %entry
; CHECK-I686-NEXT:    subl $12, %esp
; CHECK-I686-NEXT:    pxor %xmm0, %xmm0
; CHECK-I686-NEXT:    movd %xmm0, (%esp)
; CHECK-I686-NEXT:    calll __truncsfhf2
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %eax
; CHECK-I686-NEXT:    movw %ax, (%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:    ucomiss {{[0-9]+}}(%esp), %xmm0
; CHECK-I686-NEXT:    xorps %xmm0, %xmm0
; CHECK-I686-NEXT:    jae .LBB20_2
; CHECK-I686-NEXT:  # %bb.1: # %entry
; CHECK-I686-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:  .LBB20_2: # %entry
; CHECK-I686-NEXT:    movss %xmm0, (%esp)
; CHECK-I686-NEXT:    calll __truncsfhf2
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %eax
; CHECK-I686-NEXT:    movw %ax, (%eax)
; CHECK-I686-NEXT:    addl $12, %esp
; CHECK-I686-NEXT:    retl
entry:
  %0 = tail call half @llvm.fabs.f16(half undef)
  %1 = fpext half %0 to float
  %compare.2 = fcmp ole half %0, 0xH4800
  %multiply.95 = fmul float %1, 5.000000e-01
  %add.82 = fadd float %multiply.95, -2.000000e+00
  %multiply.68 = fmul float %add.82, 0.000000e+00
  %subtract.65 = fsub float %multiply.68, 0.000000e+00
  %multiply.57 = fmul float undef, 0.000000e+00
  %2 = select i1 %compare.2, float 0.000000e+00, float %multiply.57
  %3 = fptrunc float %2 to half
  store half %3, ptr undef, align 2
  ret void
}

define void @main.45() #0 {
; CHECK-LIBCALL-LABEL: main.45:
; CHECK-LIBCALL:       # %bb.0: # %entry
; CHECK-LIBCALL-NEXT:    pushq %rbp
; CHECK-LIBCALL-NEXT:    pushq %r15
; CHECK-LIBCALL-NEXT:    pushq %r14
; CHECK-LIBCALL-NEXT:    pushq %rbx
; CHECK-LIBCALL-NEXT:    pushq %rax
; CHECK-LIBCALL-NEXT:    pinsrw $0, (%rax), %xmm0
; CHECK-LIBCALL-NEXT:    pextrw $0, %xmm0, %eax
; CHECK-LIBCALL-NEXT:    movd %eax, %xmm1
; CHECK-LIBCALL-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,0,0,0,4,5,6,7]
; CHECK-LIBCALL-NEXT:    movq %xmm1, %rbx
; CHECK-LIBCALL-NEXT:    movq %rbx, %r14
; CHECK-LIBCALL-NEXT:    shrq $48, %r14
; CHECK-LIBCALL-NEXT:    movq %rbx, %r15
; CHECK-LIBCALL-NEXT:    shrq $32, %r15
; CHECK-LIBCALL-NEXT:    movl %ebx, %ebp
; CHECK-LIBCALL-NEXT:    shrl $16, %ebp
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-LIBCALL-NEXT:    movl $32256, %eax # imm = 0x7E00
; CHECK-LIBCALL-NEXT:    cmovpl %eax, %ebp
; CHECK-LIBCALL-NEXT:    cmovpl %eax, %r15d
; CHECK-LIBCALL-NEXT:    cmovpl %eax, %r14d
; CHECK-LIBCALL-NEXT:    cmovpl %eax, %ebx
; CHECK-LIBCALL-NEXT:    movw %bx, (%rax)
; CHECK-LIBCALL-NEXT:    movw %r14w, (%rax)
; CHECK-LIBCALL-NEXT:    movw %r15w, (%rax)
; CHECK-LIBCALL-NEXT:    movw %bp, (%rax)
; CHECK-LIBCALL-NEXT:    addq $8, %rsp
; CHECK-LIBCALL-NEXT:    popq %rbx
; CHECK-LIBCALL-NEXT:    popq %r14
; CHECK-LIBCALL-NEXT:    popq %r15
; CHECK-LIBCALL-NEXT:    popq %rbp
; CHECK-LIBCALL-NEXT:    retq
;
; BWON-F16C-LABEL: main.45:
; BWON-F16C:       # %bb.0: # %entry
; BWON-F16C-NEXT:    movzwl (%rax), %eax
; BWON-F16C-NEXT:    vmovd %eax, %xmm0
; BWON-F16C-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm0[0,0,0,0,4,5,6,7]
; BWON-F16C-NEXT:    vcvtph2ps %xmm0, %xmm0
; BWON-F16C-NEXT:    xorl %eax, %eax
; BWON-F16C-NEXT:    vucomiss %xmm0, %xmm0
; BWON-F16C-NEXT:    movl $65535, %ecx # imm = 0xFFFF
; BWON-F16C-NEXT:    cmovnpl %eax, %ecx
; BWON-F16C-NEXT:    vmovd %ecx, %xmm0
; BWON-F16C-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,0,0,0,4,5,6,7]
; BWON-F16C-NEXT:    vpblendvb %xmm0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm0
; BWON-F16C-NEXT:    vmovq %xmm0, (%rax)
; BWON-F16C-NEXT:    retq
;
; CHECK-I686-LABEL: main.45:
; CHECK-I686:       # %bb.0: # %entry
; CHECK-I686-NEXT:    pushl %edi
; CHECK-I686-NEXT:    pushl %esi
; CHECK-I686-NEXT:    subl $20, %esp
; CHECK-I686-NEXT:    pinsrw $0, (%eax), %xmm0
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %eax
; CHECK-I686-NEXT:    movd %eax, %xmm0
; CHECK-I686-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,0,0,0,4,5,6,7]
; CHECK-I686-NEXT:    movd %xmm0, %esi
; CHECK-I686-NEXT:    movl %esi, %edi
; CHECK-I686-NEXT:    shrl $16, %edi
; CHECK-I686-NEXT:    movw %ax, (%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:    ucomiss %xmm0, %xmm0
; CHECK-I686-NEXT:    movl $32256, %eax # imm = 0x7E00
; CHECK-I686-NEXT:    cmovpl %eax, %esi
; CHECK-I686-NEXT:    cmovpl %eax, %edi
; CHECK-I686-NEXT:    movw %di, (%eax)
; CHECK-I686-NEXT:    movw %si, (%eax)
; CHECK-I686-NEXT:    addl $20, %esp
; CHECK-I686-NEXT:    popl %esi
; CHECK-I686-NEXT:    popl %edi
; CHECK-I686-NEXT:    retl
entry:
  %0 = load half, ptr undef, align 8
  %1 = bitcast half %0 to i16
  %broadcast.splatinsert = insertelement <4 x half> poison, half %0, i64 0
  %broadcast.splat = shufflevector <4 x half> %broadcast.splatinsert, <4 x half> poison, <4 x i32> zeroinitializer
  %broadcast.splatinsert13 = insertelement <4 x i16> poison, i16 %1, i64 0
  %broadcast.splat14 = shufflevector <4 x i16> %broadcast.splatinsert13, <4 x i16> poison, <4 x i32> zeroinitializer
  %2 = fcmp uno <4 x half> %broadcast.splat, zeroinitializer
  %3 = add <4 x i16> zeroinitializer, %broadcast.splat14
  %4 = select i1 undef, <4 x i16> undef, <4 x i16> %3
  %5 = select <4 x i1> undef, <4 x i16> undef, <4 x i16> %4
  %6 = bitcast <4 x i16> %5 to <4 x half>
  %7 = select <4 x i1> %2, <4 x half> <half 0xH7E00, half 0xH7E00, half 0xH7E00, half 0xH7E00>, <4 x half> %6
  store <4 x half> %7, ptr undef, align 16
  ret void
}

define half @fcopysign(half %x, half %y) {
; CHECK-LIBCALL-LABEL: fcopysign:
; CHECK-LIBCALL:       # %bb.0:
; CHECK-LIBCALL-NEXT:    pextrw $0, %xmm1, %eax
; CHECK-LIBCALL-NEXT:    andl $-32768, %eax # imm = 0x8000
; CHECK-LIBCALL-NEXT:    pextrw $0, %xmm0, %ecx
; CHECK-LIBCALL-NEXT:    andl $32767, %ecx # imm = 0x7FFF
; CHECK-LIBCALL-NEXT:    orl %eax, %ecx
; CHECK-LIBCALL-NEXT:    pinsrw $0, %ecx, %xmm0
; CHECK-LIBCALL-NEXT:    retq
;
; BWON-F16C-LABEL: fcopysign:
; BWON-F16C:       # %bb.0:
; BWON-F16C-NEXT:    vpextrw $0, %xmm1, %eax
; BWON-F16C-NEXT:    andl $-32768, %eax # imm = 0x8000
; BWON-F16C-NEXT:    vpextrw $0, %xmm0, %ecx
; BWON-F16C-NEXT:    andl $32767, %ecx # imm = 0x7FFF
; BWON-F16C-NEXT:    orl %eax, %ecx
; BWON-F16C-NEXT:    vpinsrw $0, %ecx, %xmm0, %xmm0
; BWON-F16C-NEXT:    retq
;
; CHECK-I686-LABEL: fcopysign:
; CHECK-I686:       # %bb.0:
; CHECK-I686-NEXT:    movl $-32768, %eax # imm = 0x8000
; CHECK-I686-NEXT:    andl {{[0-9]+}}(%esp), %eax
; CHECK-I686-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; CHECK-I686-NEXT:    andl $32767, %ecx # imm = 0x7FFF
; CHECK-I686-NEXT:    orl %eax, %ecx
; CHECK-I686-NEXT:    pinsrw $0, %ecx, %xmm0
; CHECK-I686-NEXT:    retl
  %a = call half @llvm.copysign.f16(half %x, half %y)
  ret half %a
}

declare half @llvm.fabs.f16(half)
declare half @llvm.copysign.f16(half, half)

define <8 x half> @select(i1 %c, <8 x half> %x, <8 x half> %y) {
; CHECK-LIBCALL-LABEL: select:
; CHECK-LIBCALL:       # %bb.0:
; CHECK-LIBCALL-NEXT:    testb $1, %dil
; CHECK-LIBCALL-NEXT:    jne .LBB23_2
; CHECK-LIBCALL-NEXT:  # %bb.1:
; CHECK-LIBCALL-NEXT:    movaps %xmm1, %xmm0
; CHECK-LIBCALL-NEXT:  .LBB23_2:
; CHECK-LIBCALL-NEXT:    retq
;
; BWON-F16C-LABEL: select:
; BWON-F16C:       # %bb.0:
; BWON-F16C-NEXT:    testb $1, %dil
; BWON-F16C-NEXT:    jne .LBB23_2
; BWON-F16C-NEXT:  # %bb.1:
; BWON-F16C-NEXT:    vmovaps %xmm1, %xmm0
; BWON-F16C-NEXT:  .LBB23_2:
; BWON-F16C-NEXT:    retq
;
; CHECK-I686-LABEL: select:
; CHECK-I686:       # %bb.0:
; CHECK-I686-NEXT:    testb $1, {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    jne .LBB23_2
; CHECK-I686-NEXT:  # %bb.1:
; CHECK-I686-NEXT:    movaps %xmm1, %xmm0
; CHECK-I686-NEXT:  .LBB23_2:
; CHECK-I686-NEXT:    retl
  %s = select i1 %c, <8 x half> %x, <8 x half> %y
  ret <8 x half> %s
}

define <8 x half> @shuffle(ptr %p) {
; CHECK-LIBCALL-LABEL: shuffle:
; CHECK-LIBCALL:       # %bb.0:
; CHECK-LIBCALL-NEXT:    movdqu (%rdi), %xmm0
; CHECK-LIBCALL-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,4,4,4]
; CHECK-LIBCALL-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,2,2,2]
; CHECK-LIBCALL-NEXT:    retq
;
; BWON-F16C-LABEL: shuffle:
; BWON-F16C:       # %bb.0:
; BWON-F16C-NEXT:    vpshufhw {{.*#+}} xmm0 = mem[0,1,2,3,4,4,4,4]
; BWON-F16C-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,2,2]
; BWON-F16C-NEXT:    retq
;
; CHECK-I686-LABEL: shuffle:
; CHECK-I686:       # %bb.0:
; CHECK-I686-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-I686-NEXT:    movdqu (%eax), %xmm0
; CHECK-I686-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,4,4,4]
; CHECK-I686-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,2,2,2]
; CHECK-I686-NEXT:    retl
  %1 = load <8 x half>, ptr %p, align 8
  %2 = shufflevector <8 x half> %1, <8 x half> poison, <8 x i32> <i32 4, i32 4, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  ret <8 x half> %2
}

declare half @llvm.minnum.f16(half, half)

define half @pr61271(half %0, half %1) #0 {
; CHECK-LIBCALL-LABEL: pr61271:
; CHECK-LIBCALL:       # %bb.0:
; CHECK-LIBCALL-NEXT:    pushq %rax
; CHECK-LIBCALL-NEXT:    movss %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 4-byte Spill
; CHECK-LIBCALL-NEXT:    movaps %xmm1, %xmm0
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    movss %xmm0, (%rsp) # 4-byte Spill
; CHECK-LIBCALL-NEXT:    movss {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 4-byte Reload
; CHECK-LIBCALL-NEXT:    # xmm0 = mem[0],zero,zero,zero
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    minss (%rsp), %xmm0 # 4-byte Folded Reload
; CHECK-LIBCALL-NEXT:    callq __truncsfhf2@PLT
; CHECK-LIBCALL-NEXT:    popq %rax
; CHECK-LIBCALL-NEXT:    retq
;
; BWON-F16C-LABEL: pr61271:
; BWON-F16C:       # %bb.0:
; BWON-F16C-NEXT:    vpextrw $0, %xmm0, %eax
; BWON-F16C-NEXT:    vpextrw $0, %xmm1, %ecx
; BWON-F16C-NEXT:    movzwl %cx, %ecx
; BWON-F16C-NEXT:    vmovd %ecx, %xmm0
; BWON-F16C-NEXT:    vcvtph2ps %xmm0, %xmm0
; BWON-F16C-NEXT:    movzwl %ax, %eax
; BWON-F16C-NEXT:    vmovd %eax, %xmm1
; BWON-F16C-NEXT:    vcvtph2ps %xmm1, %xmm1
; BWON-F16C-NEXT:    vminss %xmm0, %xmm1, %xmm0
; BWON-F16C-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; BWON-F16C-NEXT:    vmovd %xmm0, %eax
; BWON-F16C-NEXT:    vpinsrw $0, %eax, %xmm0, %xmm0
; BWON-F16C-NEXT:    retq
;
; CHECK-I686-LABEL: pr61271:
; CHECK-I686:       # %bb.0:
; CHECK-I686-NEXT:    subl $44, %esp
; CHECK-I686-NEXT:    pinsrw $0, {{[0-9]+}}(%esp), %xmm0
; CHECK-I686-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%e{{[sb]}}p) # 16-byte Spill
; CHECK-I686-NEXT:    pinsrw $0, {{[0-9]+}}(%esp), %xmm0
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %eax
; CHECK-I686-NEXT:    movw %ax, (%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    movdqa {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %eax
; CHECK-I686-NEXT:    movw %ax, (%esp)
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:    minss {{[0-9]+}}(%esp), %xmm0
; CHECK-I686-NEXT:    movss %xmm0, (%esp)
; CHECK-I686-NEXT:    calll __truncsfhf2
; CHECK-I686-NEXT:    addl $44, %esp
; CHECK-I686-NEXT:    retl
  %3 = call fast half @llvm.minnum.f16(half %0, half %1)
  ret half %3
}

declare <8 x half> @llvm.maxnum.v8f16(<8 x half>, <8 x half>)

define <8 x half> @maxnum_v8f16(<8 x half> %0, <8 x half> %1) #0 {
; CHECK-LIBCALL-LABEL: maxnum_v8f16:
; CHECK-LIBCALL:       # %bb.0:
; CHECK-LIBCALL-NEXT:    subq $184, %rsp
; CHECK-LIBCALL-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; CHECK-LIBCALL-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    movd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 4-byte Folded Spill
; CHECK-LIBCALL-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; CHECK-LIBCALL-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    movd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 4-byte Folded Spill
; CHECK-LIBCALL-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    movss %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 4-byte Spill
; CHECK-LIBCALL-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    ucomiss {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 4-byte Folded Reload
; CHECK-LIBCALL-NEXT:    movss {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 4-byte Reload
; CHECK-LIBCALL-NEXT:    # xmm0 = mem[0],zero,zero,zero
; CHECK-LIBCALL-NEXT:    ja .LBB26_2
; CHECK-LIBCALL-NEXT:  # %bb.1:
; CHECK-LIBCALL-NEXT:    movss {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 4-byte Reload
; CHECK-LIBCALL-NEXT:    # xmm0 = mem[0],zero,zero,zero
; CHECK-LIBCALL-NEXT:  .LBB26_2:
; CHECK-LIBCALL-NEXT:    callq __truncsfhf2@PLT
; CHECK-LIBCALL-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3,3,3]
; CHECK-LIBCALL-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    movss %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 4-byte Spill
; CHECK-LIBCALL-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3,3,3]
; CHECK-LIBCALL-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    movss %xmm0, (%rsp) # 4-byte Spill
; CHECK-LIBCALL-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    movss %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 4-byte Spill
; CHECK-LIBCALL-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    ucomiss {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 4-byte Folded Reload
; CHECK-LIBCALL-NEXT:    movss {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 4-byte Reload
; CHECK-LIBCALL-NEXT:    # xmm0 = mem[0],zero,zero,zero
; CHECK-LIBCALL-NEXT:    ja .LBB26_4
; CHECK-LIBCALL-NEXT:  # %bb.3:
; CHECK-LIBCALL-NEXT:    movss (%rsp), %xmm0 # 4-byte Reload
; CHECK-LIBCALL-NEXT:    # xmm0 = mem[0],zero,zero,zero
; CHECK-LIBCALL-NEXT:  .LBB26_4:
; CHECK-LIBCALL-NEXT:    callq __truncsfhf2@PLT
; CHECK-LIBCALL-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; CHECK-LIBCALL-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    movd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 4-byte Folded Spill
; CHECK-LIBCALL-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; CHECK-LIBCALL-NEXT:    movdqa %xmm0, (%rsp) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    movd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 4-byte Folded Spill
; CHECK-LIBCALL-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    movss %xmm0, (%rsp) # 4-byte Spill
; CHECK-LIBCALL-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    ucomiss (%rsp), %xmm0 # 4-byte Folded Reload
; CHECK-LIBCALL-NEXT:    movss {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 4-byte Reload
; CHECK-LIBCALL-NEXT:    # xmm0 = mem[0],zero,zero,zero
; CHECK-LIBCALL-NEXT:    ja .LBB26_6
; CHECK-LIBCALL-NEXT:  # %bb.5:
; CHECK-LIBCALL-NEXT:    movss {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 4-byte Reload
; CHECK-LIBCALL-NEXT:    # xmm0 = mem[0],zero,zero,zero
; CHECK-LIBCALL-NEXT:  .LBB26_6:
; CHECK-LIBCALL-NEXT:    callq __truncsfhf2@PLT
; CHECK-LIBCALL-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; CHECK-LIBCALL-NEXT:    movaps %xmm0, (%rsp) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    movss %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 4-byte Spill
; CHECK-LIBCALL-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; CHECK-LIBCALL-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    movss %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 4-byte Spill
; CHECK-LIBCALL-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    movss %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 4-byte Spill
; CHECK-LIBCALL-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    ucomiss {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 4-byte Folded Reload
; CHECK-LIBCALL-NEXT:    movss {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 4-byte Reload
; CHECK-LIBCALL-NEXT:    # xmm0 = mem[0],zero,zero,zero
; CHECK-LIBCALL-NEXT:    ja .LBB26_8
; CHECK-LIBCALL-NEXT:  # %bb.7:
; CHECK-LIBCALL-NEXT:    movss {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 4-byte Reload
; CHECK-LIBCALL-NEXT:    # xmm0 = mem[0],zero,zero,zero
; CHECK-LIBCALL-NEXT:  .LBB26_8:
; CHECK-LIBCALL-NEXT:    callq __truncsfhf2@PLT
; CHECK-LIBCALL-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    psrlq $48, %xmm0
; CHECK-LIBCALL-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    movd %xmm0, (%rsp) # 4-byte Folded Spill
; CHECK-LIBCALL-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    psrlq $48, %xmm0
; CHECK-LIBCALL-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    movd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 4-byte Folded Spill
; CHECK-LIBCALL-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    movss %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 4-byte Spill
; CHECK-LIBCALL-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    ucomiss {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 4-byte Folded Reload
; CHECK-LIBCALL-NEXT:    movss (%rsp), %xmm0 # 4-byte Reload
; CHECK-LIBCALL-NEXT:    # xmm0 = mem[0],zero,zero,zero
; CHECK-LIBCALL-NEXT:    ja .LBB26_10
; CHECK-LIBCALL-NEXT:  # %bb.9:
; CHECK-LIBCALL-NEXT:    movss {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 4-byte Reload
; CHECK-LIBCALL-NEXT:    # xmm0 = mem[0],zero,zero,zero
; CHECK-LIBCALL-NEXT:  .LBB26_10:
; CHECK-LIBCALL-NEXT:    callq __truncsfhf2@PLT
; CHECK-LIBCALL-NEXT:    movaps %xmm0, (%rsp) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; CHECK-LIBCALL-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    movss %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 4-byte Spill
; CHECK-LIBCALL-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; CHECK-LIBCALL-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    movss %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 4-byte Spill
; CHECK-LIBCALL-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    movss %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 4-byte Spill
; CHECK-LIBCALL-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    movss {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 4-byte Reload
; CHECK-LIBCALL-NEXT:    # xmm1 = mem[0],zero,zero,zero
; CHECK-LIBCALL-NEXT:    ucomiss {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 4-byte Folded Reload
; CHECK-LIBCALL-NEXT:    ja .LBB26_12
; CHECK-LIBCALL-NEXT:  # %bb.11:
; CHECK-LIBCALL-NEXT:    movss {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 4-byte Reload
; CHECK-LIBCALL-NEXT:    # xmm1 = mem[0],zero,zero,zero
; CHECK-LIBCALL-NEXT:  .LBB26_12:
; CHECK-LIBCALL-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    punpcklwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; CHECK-LIBCALL-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1],xmm0[2],mem[2],xmm0[3],mem[3]
; CHECK-LIBCALL-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    punpcklwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; CHECK-LIBCALL-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1],xmm0[2],mem[2],xmm0[3],mem[3]
; CHECK-LIBCALL-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    movaps %xmm1, %xmm0
; CHECK-LIBCALL-NEXT:    callq __truncsfhf2@PLT
; CHECK-LIBCALL-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    movss %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 4-byte Spill
; CHECK-LIBCALL-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    movss %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 4-byte Spill
; CHECK-LIBCALL-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    movss %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 4-byte Spill
; CHECK-LIBCALL-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    movss {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 4-byte Reload
; CHECK-LIBCALL-NEXT:    # xmm1 = mem[0],zero,zero,zero
; CHECK-LIBCALL-NEXT:    ucomiss {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 4-byte Folded Reload
; CHECK-LIBCALL-NEXT:    ja .LBB26_14
; CHECK-LIBCALL-NEXT:  # %bb.13:
; CHECK-LIBCALL-NEXT:    movss {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 4-byte Reload
; CHECK-LIBCALL-NEXT:    # xmm1 = mem[0],zero,zero,zero
; CHECK-LIBCALL-NEXT:  .LBB26_14:
; CHECK-LIBCALL-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    unpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; CHECK-LIBCALL-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; CHECK-LIBCALL-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    punpcklwd (%rsp), %xmm0 # 16-byte Folded Reload
; CHECK-LIBCALL-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1],xmm0[2],mem[2],xmm0[3],mem[3]
; CHECK-LIBCALL-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    movaps %xmm1, %xmm0
; CHECK-LIBCALL-NEXT:    callq __truncsfhf2@PLT
; CHECK-LIBCALL-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    psrld $16, %xmm0
; CHECK-LIBCALL-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    movd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 4-byte Folded Spill
; CHECK-LIBCALL-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    psrld $16, %xmm0
; CHECK-LIBCALL-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    movd %xmm0, (%rsp) # 4-byte Folded Spill
; CHECK-LIBCALL-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    movss %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 4-byte Spill
; CHECK-LIBCALL-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    callq __extendhfsf2@PLT
; CHECK-LIBCALL-NEXT:    ucomiss {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 4-byte Folded Reload
; CHECK-LIBCALL-NEXT:    movd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 4-byte Folded Reload
; CHECK-LIBCALL-NEXT:    # xmm0 = mem[0],zero,zero,zero
; CHECK-LIBCALL-NEXT:    ja .LBB26_16
; CHECK-LIBCALL-NEXT:  # %bb.15:
; CHECK-LIBCALL-NEXT:    movd (%rsp), %xmm0 # 4-byte Folded Reload
; CHECK-LIBCALL-NEXT:    # xmm0 = mem[0],zero,zero,zero
; CHECK-LIBCALL-NEXT:  .LBB26_16:
; CHECK-LIBCALL-NEXT:    callq __truncsfhf2@PLT
; CHECK-LIBCALL-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; CHECK-LIBCALL-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; CHECK-LIBCALL-NEXT:    punpckldq {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; CHECK-LIBCALL-NEXT:    # xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; CHECK-LIBCALL-NEXT:    punpcklqdq {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; CHECK-LIBCALL-NEXT:    # xmm1 = xmm1[0],mem[0]
; CHECK-LIBCALL-NEXT:    movdqa %xmm1, %xmm0
; CHECK-LIBCALL-NEXT:    addq $184, %rsp
; CHECK-LIBCALL-NEXT:    retq
;
; BWON-F16C-LABEL: maxnum_v8f16:
; BWON-F16C:       # %bb.0:
; BWON-F16C-NEXT:    vpsrldq {{.*#+}} xmm2 = xmm1[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; BWON-F16C-NEXT:    vpextrw $0, %xmm2, %eax
; BWON-F16C-NEXT:    movzwl %ax, %eax
; BWON-F16C-NEXT:    vmovd %eax, %xmm2
; BWON-F16C-NEXT:    vcvtph2ps %xmm2, %xmm2
; BWON-F16C-NEXT:    vpsrldq {{.*#+}} xmm3 = xmm0[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; BWON-F16C-NEXT:    vpextrw $0, %xmm3, %eax
; BWON-F16C-NEXT:    movzwl %ax, %eax
; BWON-F16C-NEXT:    vmovd %eax, %xmm3
; BWON-F16C-NEXT:    vcvtph2ps %xmm3, %xmm3
; BWON-F16C-NEXT:    vucomiss %xmm2, %xmm3
; BWON-F16C-NEXT:    ja .LBB26_2
; BWON-F16C-NEXT:  # %bb.1:
; BWON-F16C-NEXT:    vmovaps %xmm2, %xmm3
; BWON-F16C-NEXT:  .LBB26_2:
; BWON-F16C-NEXT:    vcvtps2ph $4, %xmm3, %xmm2
; BWON-F16C-NEXT:    vpshufd {{.*#+}} xmm3 = xmm1[3,3,3,3]
; BWON-F16C-NEXT:    vpextrw $0, %xmm3, %eax
; BWON-F16C-NEXT:    movzwl %ax, %eax
; BWON-F16C-NEXT:    vmovd %eax, %xmm3
; BWON-F16C-NEXT:    vcvtph2ps %xmm3, %xmm3
; BWON-F16C-NEXT:    vpshufd {{.*#+}} xmm4 = xmm0[3,3,3,3]
; BWON-F16C-NEXT:    vpextrw $0, %xmm4, %eax
; BWON-F16C-NEXT:    movzwl %ax, %eax
; BWON-F16C-NEXT:    vmovd %eax, %xmm4
; BWON-F16C-NEXT:    vcvtph2ps %xmm4, %xmm4
; BWON-F16C-NEXT:    vucomiss %xmm3, %xmm4
; BWON-F16C-NEXT:    ja .LBB26_4
; BWON-F16C-NEXT:  # %bb.3:
; BWON-F16C-NEXT:    vmovaps %xmm3, %xmm4
; BWON-F16C-NEXT:  .LBB26_4:
; BWON-F16C-NEXT:    vmovd %xmm2, %eax
; BWON-F16C-NEXT:    vcvtps2ph $4, %xmm4, %xmm2
; BWON-F16C-NEXT:    vmovd %xmm2, %ecx
; BWON-F16C-NEXT:    vpsrldq {{.*#+}} xmm2 = xmm1[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; BWON-F16C-NEXT:    vpextrw $0, %xmm2, %edx
; BWON-F16C-NEXT:    movzwl %dx, %edx
; BWON-F16C-NEXT:    vmovd %edx, %xmm2
; BWON-F16C-NEXT:    vcvtph2ps %xmm2, %xmm2
; BWON-F16C-NEXT:    vpsrldq {{.*#+}} xmm3 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; BWON-F16C-NEXT:    vpextrw $0, %xmm3, %edx
; BWON-F16C-NEXT:    movzwl %dx, %edx
; BWON-F16C-NEXT:    vmovd %edx, %xmm3
; BWON-F16C-NEXT:    vcvtph2ps %xmm3, %xmm3
; BWON-F16C-NEXT:    vucomiss %xmm2, %xmm3
; BWON-F16C-NEXT:    ja .LBB26_6
; BWON-F16C-NEXT:  # %bb.5:
; BWON-F16C-NEXT:    vmovaps %xmm2, %xmm3
; BWON-F16C-NEXT:  .LBB26_6:
; BWON-F16C-NEXT:    vcvtps2ph $4, %xmm3, %xmm2
; BWON-F16C-NEXT:    vmovd %xmm2, %edx
; BWON-F16C-NEXT:    vshufpd {{.*#+}} xmm2 = xmm1[1,0]
; BWON-F16C-NEXT:    vpextrw $0, %xmm2, %esi
; BWON-F16C-NEXT:    movzwl %si, %esi
; BWON-F16C-NEXT:    vmovd %esi, %xmm2
; BWON-F16C-NEXT:    vcvtph2ps %xmm2, %xmm2
; BWON-F16C-NEXT:    vshufpd {{.*#+}} xmm3 = xmm0[1,0]
; BWON-F16C-NEXT:    vpextrw $0, %xmm3, %esi
; BWON-F16C-NEXT:    movzwl %si, %esi
; BWON-F16C-NEXT:    vmovd %esi, %xmm3
; BWON-F16C-NEXT:    vcvtph2ps %xmm3, %xmm3
; BWON-F16C-NEXT:    vucomiss %xmm2, %xmm3
; BWON-F16C-NEXT:    ja .LBB26_8
; BWON-F16C-NEXT:  # %bb.7:
; BWON-F16C-NEXT:    vmovaps %xmm2, %xmm3
; BWON-F16C-NEXT:  .LBB26_8:
; BWON-F16C-NEXT:    vcvtps2ph $4, %xmm3, %xmm2
; BWON-F16C-NEXT:    vmovd %xmm2, %esi
; BWON-F16C-NEXT:    vpsrlq $48, %xmm1, %xmm2
; BWON-F16C-NEXT:    vpextrw $0, %xmm2, %edi
; BWON-F16C-NEXT:    movzwl %di, %edi
; BWON-F16C-NEXT:    vmovd %edi, %xmm2
; BWON-F16C-NEXT:    vcvtph2ps %xmm2, %xmm2
; BWON-F16C-NEXT:    vpsrlq $48, %xmm0, %xmm3
; BWON-F16C-NEXT:    vpextrw $0, %xmm3, %edi
; BWON-F16C-NEXT:    movzwl %di, %edi
; BWON-F16C-NEXT:    vmovd %edi, %xmm3
; BWON-F16C-NEXT:    vcvtph2ps %xmm3, %xmm6
; BWON-F16C-NEXT:    vucomiss %xmm2, %xmm6
; BWON-F16C-NEXT:    ja .LBB26_10
; BWON-F16C-NEXT:  # %bb.9:
; BWON-F16C-NEXT:    vmovaps %xmm2, %xmm6
; BWON-F16C-NEXT:  .LBB26_10:
; BWON-F16C-NEXT:    vpinsrw $0, %eax, %xmm0, %xmm2
; BWON-F16C-NEXT:    vpinsrw $0, %ecx, %xmm0, %xmm3
; BWON-F16C-NEXT:    vpinsrw $0, %edx, %xmm0, %xmm4
; BWON-F16C-NEXT:    vpinsrw $0, %esi, %xmm0, %xmm5
; BWON-F16C-NEXT:    vcvtps2ph $4, %xmm6, %xmm6
; BWON-F16C-NEXT:    vmovd %xmm6, %eax
; BWON-F16C-NEXT:    vmovshdup {{.*#+}} xmm6 = xmm1[1,1,3,3]
; BWON-F16C-NEXT:    vpextrw $0, %xmm6, %ecx
; BWON-F16C-NEXT:    movzwl %cx, %ecx
; BWON-F16C-NEXT:    vmovd %ecx, %xmm6
; BWON-F16C-NEXT:    vcvtph2ps %xmm6, %xmm6
; BWON-F16C-NEXT:    vmovshdup {{.*#+}} xmm7 = xmm0[1,1,3,3]
; BWON-F16C-NEXT:    vpextrw $0, %xmm7, %ecx
; BWON-F16C-NEXT:    movzwl %cx, %ecx
; BWON-F16C-NEXT:    vmovd %ecx, %xmm7
; BWON-F16C-NEXT:    vcvtph2ps %xmm7, %xmm7
; BWON-F16C-NEXT:    vucomiss %xmm6, %xmm7
; BWON-F16C-NEXT:    ja .LBB26_12
; BWON-F16C-NEXT:  # %bb.11:
; BWON-F16C-NEXT:    vmovaps %xmm6, %xmm7
; BWON-F16C-NEXT:  .LBB26_12:
; BWON-F16C-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[1],xmm2[1],xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; BWON-F16C-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm5[0],xmm4[0],xmm5[1],xmm4[1],xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; BWON-F16C-NEXT:    vpinsrw $0, %eax, %xmm0, %xmm4
; BWON-F16C-NEXT:    vcvtps2ph $4, %xmm7, %xmm5
; BWON-F16C-NEXT:    vmovd %xmm5, %eax
; BWON-F16C-NEXT:    vpinsrw $0, %eax, %xmm0, %xmm5
; BWON-F16C-NEXT:    vpextrw $0, %xmm1, %eax
; BWON-F16C-NEXT:    movzwl %ax, %eax
; BWON-F16C-NEXT:    vmovd %eax, %xmm6
; BWON-F16C-NEXT:    vcvtph2ps %xmm6, %xmm6
; BWON-F16C-NEXT:    vpextrw $0, %xmm0, %eax
; BWON-F16C-NEXT:    movzwl %ax, %eax
; BWON-F16C-NEXT:    vmovd %eax, %xmm7
; BWON-F16C-NEXT:    vcvtph2ps %xmm7, %xmm7
; BWON-F16C-NEXT:    vucomiss %xmm6, %xmm7
; BWON-F16C-NEXT:    ja .LBB26_14
; BWON-F16C-NEXT:  # %bb.13:
; BWON-F16C-NEXT:    vmovaps %xmm6, %xmm7
; BWON-F16C-NEXT:  .LBB26_14:
; BWON-F16C-NEXT:    vpunpckldq {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; BWON-F16C-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm5[0],xmm4[0],xmm5[1],xmm4[1],xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; BWON-F16C-NEXT:    vcvtps2ph $4, %xmm7, %xmm4
; BWON-F16C-NEXT:    vmovd %xmm4, %eax
; BWON-F16C-NEXT:    vpinsrw $0, %eax, %xmm0, %xmm4
; BWON-F16C-NEXT:    vpsrld $16, %xmm1, %xmm1
; BWON-F16C-NEXT:    vpextrw $0, %xmm1, %eax
; BWON-F16C-NEXT:    movzwl %ax, %eax
; BWON-F16C-NEXT:    vmovd %eax, %xmm1
; BWON-F16C-NEXT:    vcvtph2ps %xmm1, %xmm1
; BWON-F16C-NEXT:    vpsrld $16, %xmm0, %xmm0
; BWON-F16C-NEXT:    vpextrw $0, %xmm0, %eax
; BWON-F16C-NEXT:    movzwl %ax, %eax
; BWON-F16C-NEXT:    vmovd %eax, %xmm0
; BWON-F16C-NEXT:    vcvtph2ps %xmm0, %xmm0
; BWON-F16C-NEXT:    vucomiss %xmm1, %xmm0
; BWON-F16C-NEXT:    ja .LBB26_16
; BWON-F16C-NEXT:  # %bb.15:
; BWON-F16C-NEXT:    vmovaps %xmm1, %xmm0
; BWON-F16C-NEXT:  .LBB26_16:
; BWON-F16C-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; BWON-F16C-NEXT:    vmovd %xmm0, %eax
; BWON-F16C-NEXT:    vpinsrw $0, %eax, %xmm0, %xmm0
; BWON-F16C-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm4[0],xmm0[0],xmm4[1],xmm0[1],xmm4[2],xmm0[2],xmm4[3],xmm0[3]
; BWON-F16C-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1]
; BWON-F16C-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; BWON-F16C-NEXT:    retq
;
; CHECK-I686-LABEL: maxnum_v8f16:
; CHECK-I686:       # %bb.0:
; CHECK-I686-NEXT:    pushl %ebx
; CHECK-I686-NEXT:    pushl %edi
; CHECK-I686-NEXT:    pushl %esi
; CHECK-I686-NEXT:    subl $336, %esp # imm = 0x150
; CHECK-I686-NEXT:    movaps %xmm1, {{[-0-9]+}}(%e{{[sb]}}p) # 16-byte Spill
; CHECK-I686-NEXT:    movaps %xmm0, {{[-0-9]+}}(%e{{[sb]}}p) # 16-byte Spill
; CHECK-I686-NEXT:    movaps %xmm1, %xmm0
; CHECK-I686-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm1[1,1]
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %edi
; CHECK-I686-NEXT:    movw %di, (%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    fstpt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Spill
; CHECK-I686-NEXT:    movaps {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-I686-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %esi
; CHECK-I686-NEXT:    movw %si, (%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    fstpt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Spill
; CHECK-I686-NEXT:    movw %di, (%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    fstpt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Spill
; CHECK-I686-NEXT:    movdqa {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %edi
; CHECK-I686-NEXT:    movw %di, (%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    fstpt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Spill
; CHECK-I686-NEXT:    movdqa {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %ebx
; CHECK-I686-NEXT:    movw %bx, (%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    fstpt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Spill
; CHECK-I686-NEXT:    movw %di, (%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    fstpt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Spill
; CHECK-I686-NEXT:    movw %bx, (%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    movw %si, (%esp)
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    fldt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Reload
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    fldt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Reload
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    fldt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Reload
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:    ucomiss {{[0-9]+}}(%esp), %xmm0
; CHECK-I686-NEXT:    ja .LBB26_1
; CHECK-I686-NEXT:  # %bb.2:
; CHECK-I686-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:    jmp .LBB26_3
; CHECK-I686-NEXT:  .LBB26_1:
; CHECK-I686-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:  .LBB26_3:
; CHECK-I686-NEXT:    movss %xmm0, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    movss {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 4-byte Reload
; CHECK-I686-NEXT:    # xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:    movss %xmm0, (%esp)
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    fldt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Reload
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    fldt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Reload
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    fldt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Reload
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:    ucomiss {{[0-9]+}}(%esp), %xmm0
; CHECK-I686-NEXT:    ja .LBB26_4
; CHECK-I686-NEXT:  # %bb.5:
; CHECK-I686-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:    jmp .LBB26_6
; CHECK-I686-NEXT:  .LBB26_4:
; CHECK-I686-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:  .LBB26_6:
; CHECK-I686-NEXT:    movss %xmm0, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-I686-NEXT:    calll __truncsfhf2
; CHECK-I686-NEXT:    movaps %xmm0, {{[-0-9]+}}(%e{{[sb]}}p) # 16-byte Spill
; CHECK-I686-NEXT:    movss {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 4-byte Reload
; CHECK-I686-NEXT:    # xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:    movss %xmm0, (%esp)
; CHECK-I686-NEXT:    calll __truncsfhf2
; CHECK-I686-NEXT:    movaps %xmm0, {{[-0-9]+}}(%e{{[sb]}}p) # 16-byte Spill
; CHECK-I686-NEXT:    movdqa {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-I686-NEXT:    punpckhqdq {{.*#+}} xmm0 = xmm0[1,1]
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %edi
; CHECK-I686-NEXT:    movw %di, (%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    fstpt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Spill
; CHECK-I686-NEXT:    movdqa {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-I686-NEXT:    punpckhqdq {{.*#+}} xmm0 = xmm0[1,1]
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %esi
; CHECK-I686-NEXT:    movw %si, (%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    fstpt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Spill
; CHECK-I686-NEXT:    movw %di, (%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    fstpt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Spill
; CHECK-I686-NEXT:    movdqa {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-I686-NEXT:    psrlq $48, %xmm0
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %edi
; CHECK-I686-NEXT:    movw %di, (%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    fstpt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Spill
; CHECK-I686-NEXT:    movdqa {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-I686-NEXT:    psrlq $48, %xmm0
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %ebx
; CHECK-I686-NEXT:    movw %bx, (%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    fstpt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Spill
; CHECK-I686-NEXT:    movw %di, (%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    fstpt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Spill
; CHECK-I686-NEXT:    movw %bx, (%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    movw %si, (%esp)
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    fldt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Reload
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    fldt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Reload
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    fldt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Reload
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:    ucomiss {{[0-9]+}}(%esp), %xmm0
; CHECK-I686-NEXT:    ja .LBB26_7
; CHECK-I686-NEXT:  # %bb.8:
; CHECK-I686-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:    jmp .LBB26_9
; CHECK-I686-NEXT:  .LBB26_7:
; CHECK-I686-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:  .LBB26_9:
; CHECK-I686-NEXT:    movss %xmm0, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    movss {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 4-byte Reload
; CHECK-I686-NEXT:    # xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:    movss %xmm0, (%esp)
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    fldt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Reload
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    fldt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Reload
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    fldt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Reload
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:    ucomiss {{[0-9]+}}(%esp), %xmm0
; CHECK-I686-NEXT:    ja .LBB26_10
; CHECK-I686-NEXT:  # %bb.11:
; CHECK-I686-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:    jmp .LBB26_12
; CHECK-I686-NEXT:  .LBB26_10:
; CHECK-I686-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:  .LBB26_12:
; CHECK-I686-NEXT:    movss %xmm0, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-I686-NEXT:    calll __truncsfhf2
; CHECK-I686-NEXT:    movaps %xmm0, {{[-0-9]+}}(%e{{[sb]}}p) # 16-byte Spill
; CHECK-I686-NEXT:    movss {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 4-byte Reload
; CHECK-I686-NEXT:    # xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:    movss %xmm0, (%esp)
; CHECK-I686-NEXT:    calll __truncsfhf2
; CHECK-I686-NEXT:    movaps %xmm0, {{[-0-9]+}}(%e{{[sb]}}p) # 16-byte Spill
; CHECK-I686-NEXT:    movaps {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-I686-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3,3,3]
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %edi
; CHECK-I686-NEXT:    movw %di, (%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    fstpt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Spill
; CHECK-I686-NEXT:    movaps {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-I686-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3,3,3]
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %esi
; CHECK-I686-NEXT:    movw %si, (%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    fstpt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Spill
; CHECK-I686-NEXT:    movw %di, (%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    fstpt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Spill
; CHECK-I686-NEXT:    movdqa {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-I686-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %edi
; CHECK-I686-NEXT:    movw %di, (%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    fstpt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Spill
; CHECK-I686-NEXT:    movdqa {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-I686-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %ebx
; CHECK-I686-NEXT:    movw %bx, (%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    fstpt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Spill
; CHECK-I686-NEXT:    movw %di, (%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    fstpt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Spill
; CHECK-I686-NEXT:    movw %bx, (%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    movw %si, (%esp)
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    fldt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Reload
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    fldt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Reload
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    fldt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Reload
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:    ucomiss {{[0-9]+}}(%esp), %xmm0
; CHECK-I686-NEXT:    ja .LBB26_13
; CHECK-I686-NEXT:  # %bb.14:
; CHECK-I686-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:    jmp .LBB26_15
; CHECK-I686-NEXT:  .LBB26_13:
; CHECK-I686-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:  .LBB26_15:
; CHECK-I686-NEXT:    movss %xmm0, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    movss {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 4-byte Reload
; CHECK-I686-NEXT:    # xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:    movss %xmm0, (%esp)
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    fldt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Reload
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    fldt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Reload
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    fldt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Reload
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:    ucomiss {{[0-9]+}}(%esp), %xmm0
; CHECK-I686-NEXT:    ja .LBB26_16
; CHECK-I686-NEXT:  # %bb.17:
; CHECK-I686-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:    jmp .LBB26_18
; CHECK-I686-NEXT:  .LBB26_16:
; CHECK-I686-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:  .LBB26_18:
; CHECK-I686-NEXT:    movss %xmm0, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-I686-NEXT:    calll __truncsfhf2
; CHECK-I686-NEXT:    movaps %xmm0, {{[-0-9]+}}(%e{{[sb]}}p) # 16-byte Spill
; CHECK-I686-NEXT:    movss {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 4-byte Reload
; CHECK-I686-NEXT:    # xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:    movss %xmm0, (%esp)
; CHECK-I686-NEXT:    calll __truncsfhf2
; CHECK-I686-NEXT:    movaps %xmm0, {{[-0-9]+}}(%e{{[sb]}}p) # 16-byte Spill
; CHECK-I686-NEXT:    movdqa {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-I686-NEXT:    psrld $16, %xmm0
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %edi
; CHECK-I686-NEXT:    movw %di, (%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    fstpt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Spill
; CHECK-I686-NEXT:    movdqa {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-I686-NEXT:    psrld $16, %xmm0
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %esi
; CHECK-I686-NEXT:    movw %si, (%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    fstpt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Spill
; CHECK-I686-NEXT:    movw %di, (%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    fstpt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Spill
; CHECK-I686-NEXT:    movdqa {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-I686-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %edi
; CHECK-I686-NEXT:    movw %di, (%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    fstpt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Spill
; CHECK-I686-NEXT:    movdqa {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-I686-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; CHECK-I686-NEXT:    pextrw $0, %xmm0, %ebx
; CHECK-I686-NEXT:    movw %bx, (%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    fstpt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Spill
; CHECK-I686-NEXT:    movw %di, (%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    fstpt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Spill
; CHECK-I686-NEXT:    movw %bx, (%esp)
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    movw %si, (%esp)
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    fldt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Reload
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    fldt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Reload
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    fldt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Reload
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:    ucomiss {{[0-9]+}}(%esp), %xmm0
; CHECK-I686-NEXT:    ja .LBB26_19
; CHECK-I686-NEXT:  # %bb.20:
; CHECK-I686-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:    jmp .LBB26_21
; CHECK-I686-NEXT:  .LBB26_19:
; CHECK-I686-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:  .LBB26_21:
; CHECK-I686-NEXT:    movss %xmm0, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-I686-NEXT:    calll __extendhfsf2
; CHECK-I686-NEXT:    movss {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 4-byte Reload
; CHECK-I686-NEXT:    # xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:    movss %xmm0, (%esp)
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    fldt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Reload
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    fldt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Reload
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    fldt {{[-0-9]+}}(%e{{[sb]}}p) # 10-byte Folded Reload
; CHECK-I686-NEXT:    fstps {{[0-9]+}}(%esp)
; CHECK-I686-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:    ucomiss {{[0-9]+}}(%esp), %xmm0
; CHECK-I686-NEXT:    ja .LBB26_22
; CHECK-I686-NEXT:  # %bb.23:
; CHECK-I686-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:    jmp .LBB26_24
; CHECK-I686-NEXT:  .LBB26_22:
; CHECK-I686-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:  .LBB26_24:
; CHECK-I686-NEXT:    movd %xmm0, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; CHECK-I686-NEXT:    calll __truncsfhf2
; CHECK-I686-NEXT:    movss {{[-0-9]+}}(%e{{[sb]}}p), %xmm1 # 4-byte Reload
; CHECK-I686-NEXT:    # xmm1 = mem[0],zero,zero,zero
; CHECK-I686-NEXT:    movss %xmm1, (%esp)
; CHECK-I686-NEXT:    movdqa {{[-0-9]+}}(%e{{[sb]}}p), %xmm1 # 16-byte Reload
; CHECK-I686-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; CHECK-I686-NEXT:    movdqa {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-I686-NEXT:    punpcklwd {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; CHECK-I686-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1],xmm0[2],mem[2],xmm0[3],mem[3]
; CHECK-I686-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; CHECK-I686-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%e{{[sb]}}p) # 16-byte Spill
; CHECK-I686-NEXT:    movdqa {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-I686-NEXT:    punpcklwd {{[-0-9]+}}(%e{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; CHECK-I686-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1],xmm0[2],mem[2],xmm0[3],mem[3]
; CHECK-I686-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%e{{[sb]}}p) # 16-byte Spill
; CHECK-I686-NEXT:    calll __truncsfhf2
; CHECK-I686-NEXT:    movdqa {{[-0-9]+}}(%e{{[sb]}}p), %xmm1 # 16-byte Reload
; CHECK-I686-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; CHECK-I686-NEXT:    punpckldq {{[-0-9]+}}(%e{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; CHECK-I686-NEXT:    # xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; CHECK-I686-NEXT:    punpcklqdq {{[-0-9]+}}(%e{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; CHECK-I686-NEXT:    # xmm1 = xmm1[0],mem[0]
; CHECK-I686-NEXT:    movdqa %xmm1, %xmm0
; CHECK-I686-NEXT:    addl $336, %esp # imm = 0x150
; CHECK-I686-NEXT:    popl %esi
; CHECK-I686-NEXT:    popl %edi
; CHECK-I686-NEXT:    popl %ebx
; CHECK-I686-NEXT:    retl
  %3 = call fast <8 x half> @llvm.maxnum.v8f16(<8 x half> %0, <8 x half> %1)
  ret <8 x half> %3
}

define void @pr63114() {
; CHECK-LIBCALL-LABEL: pr63114:
; CHECK-LIBCALL:       # %bb.0:
; CHECK-LIBCALL-NEXT:    movdqu (%rax), %xmm4
; CHECK-LIBCALL-NEXT:    pshuflw {{.*#+}} xmm0 = xmm4[0,1,3,3,4,5,6,7]
; CHECK-LIBCALL-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,2,1]
; CHECK-LIBCALL-NEXT:    movdqa {{.*#+}} xmm1 = [65535,65535,65535,0,65535,65535,65535,65535]
; CHECK-LIBCALL-NEXT:    pand %xmm1, %xmm0
; CHECK-LIBCALL-NEXT:    movdqa {{.*#+}} xmm2 = [0,0,0,15360,0,0,0,0]
; CHECK-LIBCALL-NEXT:    por %xmm2, %xmm0
; CHECK-LIBCALL-NEXT:    movdqa {{.*#+}} xmm3 = [65535,65535,65535,65535,65535,65535,65535,0]
; CHECK-LIBCALL-NEXT:    pand %xmm3, %xmm0
; CHECK-LIBCALL-NEXT:    movdqa {{.*#+}} xmm5 = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60]
; CHECK-LIBCALL-NEXT:    por %xmm5, %xmm0
; CHECK-LIBCALL-NEXT:    pshufhw {{.*#+}} xmm6 = xmm4[0,1,2,3,4,5,7,7]
; CHECK-LIBCALL-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[0,2,2,3]
; CHECK-LIBCALL-NEXT:    pand %xmm1, %xmm6
; CHECK-LIBCALL-NEXT:    por %xmm2, %xmm6
; CHECK-LIBCALL-NEXT:    pand %xmm3, %xmm6
; CHECK-LIBCALL-NEXT:    por %xmm5, %xmm6
; CHECK-LIBCALL-NEXT:    pshufhw {{.*#+}} xmm7 = xmm4[0,1,2,3,5,5,5,5]
; CHECK-LIBCALL-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,3,0,3]
; CHECK-LIBCALL-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,5,5,5,5]
; CHECK-LIBCALL-NEXT:    pand %xmm1, %xmm4
; CHECK-LIBCALL-NEXT:    por %xmm2, %xmm4
; CHECK-LIBCALL-NEXT:    pand %xmm3, %xmm4
; CHECK-LIBCALL-NEXT:    por %xmm5, %xmm4
; CHECK-LIBCALL-NEXT:    pand %xmm1, %xmm7
; CHECK-LIBCALL-NEXT:    por %xmm2, %xmm7
; CHECK-LIBCALL-NEXT:    pand %xmm3, %xmm7
; CHECK-LIBCALL-NEXT:    por %xmm5, %xmm7
; CHECK-LIBCALL-NEXT:    movdqu %xmm7, 0
; CHECK-LIBCALL-NEXT:    movdqu %xmm4, 32
; CHECK-LIBCALL-NEXT:    movdqu %xmm6, 48
; CHECK-LIBCALL-NEXT:    movdqu %xmm0, 16
; CHECK-LIBCALL-NEXT:    retq
;
; BWON-F16C-LABEL: pr63114:
; BWON-F16C:       # %bb.0:
; BWON-F16C-NEXT:    vmovdqu (%rax), %xmm0
; BWON-F16C-NEXT:    vpsrld $16, %xmm0, %xmm1
; BWON-F16C-NEXT:    vbroadcastss (%rax), %xmm2
; BWON-F16C-NEXT:    vpsrldq {{.*#+}} xmm3 = xmm0[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; BWON-F16C-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[0,0],xmm3[0,0]
; BWON-F16C-NEXT:    vpinsrw $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm3
; BWON-F16C-NEXT:    vpsllq $48, %xmm3, %xmm4
; BWON-F16C-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1,2],xmm4[3],xmm2[4,5,6,7]
; BWON-F16C-NEXT:    vpslldq {{.*#+}} xmm3 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm3[0,1]
; BWON-F16C-NEXT:    vpor %xmm3, %xmm2, %xmm2
; BWON-F16C-NEXT:    vshufps {{.*#+}} xmm1 = xmm0[0,3],xmm1[2,0]
; BWON-F16C-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2],xmm4[3],xmm1[4,5,6,7]
; BWON-F16C-NEXT:    vpor %xmm3, %xmm1, %xmm1
; BWON-F16C-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; BWON-F16C-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm0[0,1,3,3,4,5,6,7]
; BWON-F16C-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,0,2,1]
; BWON-F16C-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1,2],xmm4[3],xmm2[4,5,6,7]
; BWON-F16C-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,5,6],xmm3[7]
; BWON-F16C-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,5,5,5,5]
; BWON-F16C-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2],xmm4[3],xmm0[4,5,6,7]
; BWON-F16C-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,5,6],xmm3[7]
; BWON-F16C-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; BWON-F16C-NEXT:    vmovups %ymm0, 0
; BWON-F16C-NEXT:    vmovups %ymm1, 32
; BWON-F16C-NEXT:    vzeroupper
; BWON-F16C-NEXT:    retq
;
; CHECK-I686-LABEL: pr63114:
; CHECK-I686:       # %bb.0:
; CHECK-I686-NEXT:    movdqu (%eax), %xmm6
; CHECK-I686-NEXT:    pshuflw {{.*#+}} xmm0 = xmm6[0,1,3,3,4,5,6,7]
; CHECK-I686-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,2,1]
; CHECK-I686-NEXT:    movdqa {{.*#+}} xmm1 = [65535,65535,65535,0,65535,65535,65535,65535]
; CHECK-I686-NEXT:    pand %xmm1, %xmm0
; CHECK-I686-NEXT:    movdqa {{.*#+}} xmm2 = [0,0,0,15360,0,0,0,0]
; CHECK-I686-NEXT:    por %xmm2, %xmm0
; CHECK-I686-NEXT:    movdqa {{.*#+}} xmm3 = [65535,65535,65535,65535,65535,65535,65535,0]
; CHECK-I686-NEXT:    pand %xmm3, %xmm0
; CHECK-I686-NEXT:    movdqa {{.*#+}} xmm4 = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60]
; CHECK-I686-NEXT:    por %xmm4, %xmm0
; CHECK-I686-NEXT:    pshufhw {{.*#+}} xmm5 = xmm6[0,1,2,3,4,5,7,7]
; CHECK-I686-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[0,2,2,3]
; CHECK-I686-NEXT:    pand %xmm1, %xmm5
; CHECK-I686-NEXT:    por %xmm2, %xmm5
; CHECK-I686-NEXT:    pand %xmm3, %xmm5
; CHECK-I686-NEXT:    por %xmm4, %xmm5
; CHECK-I686-NEXT:    pshufhw {{.*#+}} xmm7 = xmm6[0,1,2,3,5,5,5,5]
; CHECK-I686-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,3,0,3]
; CHECK-I686-NEXT:    pshufhw {{.*#+}} xmm6 = xmm6[0,1,2,3,5,5,5,5]
; CHECK-I686-NEXT:    pand %xmm1, %xmm6
; CHECK-I686-NEXT:    por %xmm2, %xmm6
; CHECK-I686-NEXT:    pand %xmm3, %xmm6
; CHECK-I686-NEXT:    por %xmm4, %xmm6
; CHECK-I686-NEXT:    pand %xmm1, %xmm7
; CHECK-I686-NEXT:    por %xmm2, %xmm7
; CHECK-I686-NEXT:    pand %xmm3, %xmm7
; CHECK-I686-NEXT:    por %xmm4, %xmm7
; CHECK-I686-NEXT:    movdqu %xmm7, 0
; CHECK-I686-NEXT:    movdqu %xmm6, 32
; CHECK-I686-NEXT:    movdqu %xmm5, 48
; CHECK-I686-NEXT:    movdqu %xmm0, 16
; CHECK-I686-NEXT:    retl
  %1 = load <24 x half>, ptr poison, align 2
  %2 = shufflevector <24 x half> %1, <24 x half> poison, <8 x i32> <i32 2, i32 5, i32 8, i32 11, i32 14, i32 17, i32 20, i32 23>
  %3 = shufflevector <8 x half> %2, <8 x half> <half 0xH3C00, half 0xH3C00, half 0xH3C00, half 0xH3C00, half 0xH3C00, half 0xH3C00, half 0xH3C00, half 0xH3C00>, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = shufflevector <16 x half> poison, <16 x half> %3, <32 x i32> <i32 0, i32 8, i32 16, i32 24, i32 1, i32 9, i32 17, i32 25, i32 2, i32 10, i32 18, i32 26, i32 3, i32 11, i32 19, i32 27, i32 4, i32 12, i32 20, i32 28, i32 5, i32 13, i32 21, i32 29, i32 6, i32 14, i32 22, i32 30, i32 7, i32 15, i32 23, i32 31>
  store <32 x half> %4, ptr null, align 2
  ret void
}

attributes #0 = { nounwind }
