; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s


define i32 @test1(i32 %X, i8 %A) {
; CHECK-LABEL: @test1(
; CHECK-NEXT:    [[SHIFT_UPGRD_1:%.*]] = zext i8 [[A:%.*]] to i32
; CHECK-NEXT:    [[Y1:%.*]] = lshr i32 [[X:%.*]], [[SHIFT_UPGRD_1]]
; CHECK-NEXT:    [[Z:%.*]] = and i32 [[Y1]], 1
; CHECK-NEXT:    ret i32 [[Z]]
;
  %shift.upgrd.1 = zext i8 %A to i32
  ; can be logical shift.
  %Y = ashr i32 %X, %shift.upgrd.1
  %Z = and i32 %Y, 1
  ret i32 %Z
}

define i32 @test2(i8 %a) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:    [[B:%.*]] = zext i8 [[A:%.*]] to i32
; CHECK-NEXT:    [[C:%.*]] = add nuw nsw i32 [[B]], 7
; CHECK-NEXT:    [[TMP1:%.*]] = lshr i32 [[C]], 3
; CHECK-NEXT:    ret i32 [[TMP1]]
;
  %b = zext i8 %a to i32
  %c = add i32 %b, 7
  %d = ashr i32 %c, 3
  ret i32 %d
}

define i64 @test3(i1 %X, i64 %Y, i1 %Cond) {
; CHECK-LABEL: @test3(
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    [[X2:%.*]] = sext i1 [[X:%.*]] to i64
; CHECK-NEXT:    br label [[C:%.*]]
; CHECK:       F:
; CHECK-NEXT:    [[Y2:%.*]] = ashr i64 [[Y:%.*]], 63
; CHECK-NEXT:    br label [[C]]
; CHECK:       C:
; CHECK-NEXT:    [[P:%.*]] = phi i64 [ [[X2]], [[T]] ], [ [[Y2]], [[F]] ]
; CHECK-NEXT:    ret i64 [[P]]
;
  br i1 %Cond, label %T, label %F
T:
  %X2 = sext i1 %X to i64
  br label %C
F:
  %Y2 = ashr i64 %Y, 63
  br label %C
C:
  %P = phi i64 [%X2, %T], [%Y2, %F]
  %S = ashr i64 %P, 12
  ret i64 %S
}

define i64 @test4(i1 %X, i64 %Y, i1 %Cond) {
; CHECK-LABEL: @test4(
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    [[X2:%.*]] = sext i1 [[X:%.*]] to i64
; CHECK-NEXT:    br label [[C:%.*]]
; CHECK:       F:
; CHECK-NEXT:    [[Y2:%.*]] = ashr i64 [[Y:%.*]], 63
; CHECK-NEXT:    br label [[C]]
; CHECK:       C:
; CHECK-NEXT:    [[P:%.*]] = phi i64 [ [[X2]], [[T]] ], [ [[Y2]], [[F]] ]
; CHECK-NEXT:    ret i64 [[P]]
;
  br i1 %Cond, label %T, label %F
T:
  %X2 = sext i1 %X to i64
  br label %C
F:
  %Y2 = ashr i64 %Y, 63
  br label %C
C:
  %P = phi i64 [%X2, %T], [%Y2, %F]
  %R = shl i64 %P, 12
  %S = ashr i64 %R, 12
  ret i64 %S
}

; rdar://7732987
define i32 @test5(i32 %Y, i1 %c1, i1 %c2, i1 %c3) {
; CHECK-LABEL: @test5(
; CHECK-NEXT:    br i1 [[C1:%.*]], label [[A:%.*]], label [[C:%.*]]
; CHECK:       A:
; CHECK-NEXT:    br i1 [[C2:%.*]], label [[B:%.*]], label [[D:%.*]]
; CHECK:       B:
; CHECK-NEXT:    br label [[D]]
; CHECK:       C:
; CHECK-NEXT:    br i1 [[C3:%.*]], label [[D]], label [[E:%.*]]
; CHECK:       D:
; CHECK-NEXT:    [[P:%.*]] = phi i32 [ 0, [[A]] ], [ 0, [[B]] ], [ [[Y:%.*]], [[C]] ]
; CHECK-NEXT:    [[S:%.*]] = ashr i32 [[P]], 16
; CHECK-NEXT:    ret i32 [[S]]
; CHECK:       E:
; CHECK-NEXT:    ret i32 0
;
  br i1 %c1, label %A, label %C
A:
  br i1 %c2, label %B, label %D
B:
  br label %D
C:
  br i1 %c3, label %D, label %E
D:
  %P = phi i32 [0, %A], [0, %B], [%Y, %C]
  %S = ashr i32 %P, 16
  ret i32 %S
E:
  ret i32 0
}

; (X >>s C1) >>s C2 --> X >>s (C1 + C2)

define i32 @ashr_ashr(i32 %x) {
; CHECK-LABEL: @ashr_ashr(
; CHECK-NEXT:    [[SH2:%.*]] = ashr i32 [[X:%.*]], 12
; CHECK-NEXT:    ret i32 [[SH2]]
;
  %sh1 = ashr i32 %x, 5
  %sh2 = ashr i32 %sh1, 7
  ret i32 %sh2
}

; PR3851
; (X >>s C1) >>s C2 --> X >>s (Bitwidth - 1)

define i32 @ashr_overshift(i32 %x) {
; CHECK-LABEL: @ashr_overshift(
; CHECK-NEXT:    [[SH2:%.*]] = ashr i32 [[X:%.*]], 31
; CHECK-NEXT:    ret i32 [[SH2]]
;
  %sh1 = ashr i32 %x, 15
  %sh2 = ashr i32 %sh1, 17
  ret i32 %sh2
}

; (X >>s C1) >>s C2 --> X >>s (C1 + C2)

define <2 x i32> @ashr_ashr_splat_vec(<2 x i32> %x) {
; CHECK-LABEL: @ashr_ashr_splat_vec(
; CHECK-NEXT:    [[SH2:%.*]] = ashr <2 x i32> [[X:%.*]], <i32 12, i32 12>
; CHECK-NEXT:    ret <2 x i32> [[SH2]]
;
  %sh1 = ashr <2 x i32> %x, <i32 5, i32 5>
  %sh2 = ashr <2 x i32> %sh1, <i32 7, i32 7>
  ret <2 x i32> %sh2
}

; (X >>s C1) >>s C2 --> X >>s (Bitwidth - 1)

define <2 x i32> @ashr_overshift_splat_vec(<2 x i32> %x) {
; CHECK-LABEL: @ashr_overshift_splat_vec(
; CHECK-NEXT:    [[SH2:%.*]] = ashr <2 x i32> [[X:%.*]], <i32 31, i32 31>
; CHECK-NEXT:    ret <2 x i32> [[SH2]]
;
  %sh1 = ashr <2 x i32> %x, <i32 15, i32 15>
  %sh2 = ashr <2 x i32> %sh1, <i32 17, i32 17>
  ret <2 x i32> %sh2
}

; ashr (sext X), C --> sext (ashr X, C')

define i32 @hoist_ashr_ahead_of_sext_1(i8 %x) {
; CHECK-LABEL: @hoist_ashr_ahead_of_sext_1(
; CHECK-NEXT:    [[TMP1:%.*]] = ashr i8 [[X:%.*]], 3
; CHECK-NEXT:    [[R:%.*]] = sext i8 [[TMP1]] to i32
; CHECK-NEXT:    ret i32 [[R]]
;
  %sext = sext i8 %x to i32
  %r = ashr i32 %sext, 3
  ret i32 %r
}

; ashr (sext X), C --> sext (ashr X, C')

define <2 x i32> @hoist_ashr_ahead_of_sext_1_splat(<2 x i8> %x) {
; CHECK-LABEL: @hoist_ashr_ahead_of_sext_1_splat(
; CHECK-NEXT:    [[TMP1:%.*]] = ashr <2 x i8> [[X:%.*]], <i8 3, i8 3>
; CHECK-NEXT:    [[R:%.*]] = sext <2 x i8> [[TMP1]] to <2 x i32>
; CHECK-NEXT:    ret <2 x i32> [[R]]
;
  %sext = sext <2 x i8> %x to <2 x i32>
  %r = ashr <2 x i32> %sext, <i32 3, i32 3>
  ret <2 x i32> %r
}

; ashr (sext X), C --> sext (ashr X, C') -- the shift amount must be clamped

define i32 @hoist_ashr_ahead_of_sext_2(i8 %x) {
; CHECK-LABEL: @hoist_ashr_ahead_of_sext_2(
; CHECK-NEXT:    [[TMP1:%.*]] = ashr i8 [[X:%.*]], 7
; CHECK-NEXT:    [[R:%.*]] = sext i8 [[TMP1]] to i32
; CHECK-NEXT:    ret i32 [[R]]
;
  %sext = sext i8 %x to i32
  %r = ashr i32 %sext, 8
  ret i32 %r
}

; ashr (sext X), C --> sext (ashr X, C') -- the shift amount must be clamped

define <2 x i32> @hoist_ashr_ahead_of_sext_2_splat(<2 x i8> %x) {
; CHECK-LABEL: @hoist_ashr_ahead_of_sext_2_splat(
; CHECK-NEXT:    [[TMP1:%.*]] = ashr <2 x i8> [[X:%.*]], <i8 7, i8 7>
; CHECK-NEXT:    [[R:%.*]] = sext <2 x i8> [[TMP1]] to <2 x i32>
; CHECK-NEXT:    ret <2 x i32> [[R]]
;
  %sext = sext <2 x i8> %x to <2 x i32>
  %r = ashr <2 x i32> %sext, <i32 8, i32 8>
  ret <2 x i32> %r
}

