; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; REQUIRES: aarch64-registered-target

; This test needs to be target specific due to the cost estimate in the output.

; RUN: opt -passes='lower-matrix-intrinsics' -S < %s | FileCheck %s
; RUN: opt -passes='lower-matrix-intrinsics' -S -o /dev/null -pass-remarks-output=%t < %s && FileCheck --input-file %t --check-prefix=REMARK %s

target datalayout = "e-m:o-i64:64-f80:128-n8:16:32:64-S128"
target triple = "aarch64-apple-ios"

define void @double_transpose(ptr %A, ptr %B) {
; REMARK:      Pass:            lower-matrix-intrinsics
; REMARK-NEXT: Name:            matrix-lowered
; REMARK-NEXT: Function:        double_transpose
; REMARK-NEXT: Args:
; REMARK-NEXT:   - String:          'Lowered with '
; REMARK-NEXT:   - NumStores:       '6'
; REMARK-NEXT:   - String:          ' stores, '
; REMARK-NEXT:   - NumLoads:        '6'
; REMARK-NEXT:   - String:          ' loads, '
; REMARK-NEXT:   - NumComputeOps:   '0'
; REMARK-NEXT:   - String:          ' compute ops, '
; REMARK-NEXT:   - NumExposedTransposes: '0'
; REMARK-NEXT:   - String:          ' exposed transposes'
; REMARK-NEXT:   - String:           |
; REMARK:            store(
; REMARK-NEXT:        load(addr %A),
; REMARK-NEXT:        addr %B)
; CHECK-LABEL: @double_transpose(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[COL_LOAD:%.*]] = load <3 x double>, ptr [[A:%.*]], align 16
; CHECK-NEXT:    [[VEC_GEP:%.*]] = getelementptr double, ptr [[A]], i64 3
; CHECK-NEXT:    [[COL_LOAD2:%.*]] = load <3 x double>, ptr [[VEC_GEP]], align 8
; CHECK-NEXT:    [[VEC_GEP3:%.*]] = getelementptr double, ptr [[A]], i64 6
; CHECK-NEXT:    [[COL_LOAD5:%.*]] = load <3 x double>, ptr [[VEC_GEP3]], align 16
; CHECK-NEXT:    store <3 x double> [[COL_LOAD]], ptr [[B:%.*]], align 16
; CHECK-NEXT:    [[VEC_GEP7:%.*]] = getelementptr double, ptr [[B]], i64 3
; CHECK-NEXT:    store <3 x double> [[COL_LOAD2]], ptr [[VEC_GEP7]], align 8
; CHECK-NEXT:    [[VEC_GEP9:%.*]] = getelementptr double, ptr [[B]], i64 6
; CHECK-NEXT:    store <3 x double> [[COL_LOAD5]], ptr [[VEC_GEP9]], align 16
; CHECK-NEXT:    ret void
;
entry:
  %a = load <9 x double>, ptr %A, align 16
  %at = call <9 x double> @llvm.matrix.transpose.v9f64.v9f64(<9 x double> %a, i32 3, i32 3)
  %att = call <9 x double> @llvm.matrix.transpose.v9f64.v9f64(<9 x double> %at, i32 3, i32 3)
  store <9 x double> %att, ptr %B, align 16
  ret void
}

define void @multiply_ntt(ptr %A, ptr %B, ptr %C, ptr %R) {
; REMARK:      Pass:            lower-matrix-intrinsics
; REMARK-NEXT: Name:            matrix-lowered
; REMARK-NEXT: Function:        multiply_ntt
; REMARK-NEXT: Args:
; REMARK-NEXT:   - String:          'Lowered with '
; REMARK-NEXT:   - NumStores:       '4'
; REMARK-NEXT:   - String:          ' stores, '
; REMARK-NEXT:   - NumLoads:        '10'
; REMARK-NEXT:   - String:          ' loads, '
; REMARK-NEXT:   - NumComputeOps:   '38'
; REMARK-NEXT:   - String:          ' compute ops, '
; REMARK-NEXT:   - NumExposedTransposes: '0'
; REMARK-NEXT:   - String:          ' exposed transposes'
; REMARK-NEXT:   - String:           |
; REMARK:            store(
; REMARK-NEXT:        multiply.2x3.3x4.double(
; REMARK-NEXT:         load(addr %A),
; REMARK-NEXT:         transpose.4x3.double(multiply.4x2.2x3.double(
; REMARK-NEXT:           load(addr %C),
; REMARK-NEXT:           load(addr %B)))),
; REMARK-NEXT:        addr %R)
; CHECK-LABEL: @multiply_ntt(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[COL_LOAD:%.*]] = load <2 x double>, ptr [[A:%.*]], align 16
; CHECK-NEXT:    [[VEC_GEP:%.*]] = getelementptr double, ptr [[A]], i64 2
; CHECK-NEXT:    [[COL_LOAD40:%.*]] = load <2 x double>, ptr [[VEC_GEP]], align 16
; CHECK-NEXT:    [[VEC_GEP41:%.*]] = getelementptr double, ptr [[A]], i64 4
; CHECK-NEXT:    [[COL_LOAD43:%.*]] = load <2 x double>, ptr [[VEC_GEP41]], align 16
; CHECK-NEXT:    [[TMP1:%.*]] = shufflevector <2 x double> [[COL_LOAD]], <2 x double> [[COL_LOAD40]], <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; CHECK-NEXT:    [[TMP2:%.*]] = shufflevector <2 x double> [[COL_LOAD43]], <2 x double> poison, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
; CHECK-NEXT:    [[TMP3:%.*]] = shufflevector <4 x double> [[TMP1]], <4 x double> [[TMP2]], <6 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5>
; CHECK-NEXT:    [[COL_LOAD45:%.*]] = load <2 x double>, ptr [[B:%.*]], align 16
; CHECK-NEXT:    [[VEC_GEP46:%.*]] = getelementptr double, ptr [[B]], i64 2
; CHECK-NEXT:    [[COL_LOAD48:%.*]] = load <2 x double>, ptr [[VEC_GEP46]], align 16
; CHECK-NEXT:    [[VEC_GEP49:%.*]] = getelementptr double, ptr [[B]], i64 4
; CHECK-NEXT:    [[COL_LOAD51:%.*]] = load <2 x double>, ptr [[VEC_GEP49]], align 16
; CHECK-NEXT:    [[COL_LOAD53:%.*]] = load <4 x double>, ptr [[C:%.*]], align 16
; CHECK-NEXT:    [[VEC_GEP54:%.*]] = getelementptr double, ptr [[C]], i64 4
; CHECK-NEXT:    [[COL_LOAD56:%.*]] = load <4 x double>, ptr [[VEC_GEP54]], align 16
; CHECK-NEXT:    [[BLOCK57:%.*]] = shufflevector <4 x double> [[COL_LOAD53]], <4 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP6:%.*]] = extractelement <2 x double> [[COL_LOAD45]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT58:%.*]] = insertelement <2 x double> poison, double [[TMP6]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT59:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT58]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP7:%.*]] = fmul <2 x double> [[BLOCK57]], [[SPLAT_SPLAT59]]
; CHECK-NEXT:    [[BLOCK60:%.*]] = shufflevector <4 x double> [[COL_LOAD56]], <4 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP8:%.*]] = extractelement <2 x double> [[COL_LOAD45]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT61:%.*]] = insertelement <2 x double> poison, double [[TMP8]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT62:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT61]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP9:%.*]] = fmul <2 x double> [[BLOCK60]], [[SPLAT_SPLAT62]]
; CHECK-NEXT:    [[TMP10:%.*]] = fadd <2 x double> [[TMP7]], [[TMP9]]
; CHECK-NEXT:    [[TMP11:%.*]] = shufflevector <2 x double> [[TMP10]], <2 x double> poison, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
; CHECK-NEXT:    [[TMP12:%.*]] = shufflevector <4 x double> undef, <4 x double> [[TMP11]], <4 x i32> <i32 4, i32 5, i32 2, i32 3>
; CHECK-NEXT:    [[BLOCK63:%.*]] = shufflevector <4 x double> [[COL_LOAD53]], <4 x double> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[TMP13:%.*]] = extractelement <2 x double> [[COL_LOAD45]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT64:%.*]] = insertelement <2 x double> poison, double [[TMP13]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT65:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT64]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP14:%.*]] = fmul <2 x double> [[BLOCK63]], [[SPLAT_SPLAT65]]
; CHECK-NEXT:    [[BLOCK66:%.*]] = shufflevector <4 x double> [[COL_LOAD56]], <4 x double> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[TMP15:%.*]] = extractelement <2 x double> [[COL_LOAD45]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT67:%.*]] = insertelement <2 x double> poison, double [[TMP15]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT68:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT67]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP16:%.*]] = fmul <2 x double> [[BLOCK66]], [[SPLAT_SPLAT68]]
; CHECK-NEXT:    [[TMP17:%.*]] = fadd <2 x double> [[TMP14]], [[TMP16]]
; CHECK-NEXT:    [[TMP18:%.*]] = shufflevector <2 x double> [[TMP17]], <2 x double> poison, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
; CHECK-NEXT:    [[TMP19:%.*]] = shufflevector <4 x double> [[TMP12]], <4 x double> [[TMP18]], <4 x i32> <i32 0, i32 1, i32 4, i32 5>
; CHECK-NEXT:    [[BLOCK69:%.*]] = shufflevector <4 x double> [[COL_LOAD53]], <4 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP20:%.*]] = extractelement <2 x double> [[COL_LOAD48]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT70:%.*]] = insertelement <2 x double> poison, double [[TMP20]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT71:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT70]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP21:%.*]] = fmul <2 x double> [[BLOCK69]], [[SPLAT_SPLAT71]]
; CHECK-NEXT:    [[BLOCK72:%.*]] = shufflevector <4 x double> [[COL_LOAD56]], <4 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP22:%.*]] = extractelement <2 x double> [[COL_LOAD48]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT73:%.*]] = insertelement <2 x double> poison, double [[TMP22]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT74:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT73]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP23:%.*]] = fmul <2 x double> [[BLOCK72]], [[SPLAT_SPLAT74]]
; CHECK-NEXT:    [[TMP24:%.*]] = fadd <2 x double> [[TMP21]], [[TMP23]]
; CHECK-NEXT:    [[TMP25:%.*]] = shufflevector <2 x double> [[TMP24]], <2 x double> poison, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
; CHECK-NEXT:    [[TMP26:%.*]] = shufflevector <4 x double> undef, <4 x double> [[TMP25]], <4 x i32> <i32 4, i32 5, i32 2, i32 3>
; CHECK-NEXT:    [[BLOCK75:%.*]] = shufflevector <4 x double> [[COL_LOAD53]], <4 x double> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[TMP27:%.*]] = extractelement <2 x double> [[COL_LOAD48]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT76:%.*]] = insertelement <2 x double> poison, double [[TMP27]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT77:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT76]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP28:%.*]] = fmul <2 x double> [[BLOCK75]], [[SPLAT_SPLAT77]]
; CHECK-NEXT:    [[BLOCK78:%.*]] = shufflevector <4 x double> [[COL_LOAD56]], <4 x double> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[TMP29:%.*]] = extractelement <2 x double> [[COL_LOAD48]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT79:%.*]] = insertelement <2 x double> poison, double [[TMP29]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT80:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT79]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP30:%.*]] = fmul <2 x double> [[BLOCK78]], [[SPLAT_SPLAT80]]
; CHECK-NEXT:    [[TMP31:%.*]] = fadd <2 x double> [[TMP28]], [[TMP30]]
; CHECK-NEXT:    [[TMP32:%.*]] = shufflevector <2 x double> [[TMP31]], <2 x double> poison, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
; CHECK-NEXT:    [[TMP33:%.*]] = shufflevector <4 x double> [[TMP26]], <4 x double> [[TMP32]], <4 x i32> <i32 0, i32 1, i32 4, i32 5>
; CHECK-NEXT:    [[BLOCK81:%.*]] = shufflevector <4 x double> [[COL_LOAD53]], <4 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP34:%.*]] = extractelement <2 x double> [[COL_LOAD51]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT82:%.*]] = insertelement <2 x double> poison, double [[TMP34]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT83:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT82]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP35:%.*]] = fmul <2 x double> [[BLOCK81]], [[SPLAT_SPLAT83]]
; CHECK-NEXT:    [[BLOCK84:%.*]] = shufflevector <4 x double> [[COL_LOAD56]], <4 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP36:%.*]] = extractelement <2 x double> [[COL_LOAD51]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT85:%.*]] = insertelement <2 x double> poison, double [[TMP36]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT86:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT85]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP37:%.*]] = fmul <2 x double> [[BLOCK84]], [[SPLAT_SPLAT86]]
; CHECK-NEXT:    [[TMP38:%.*]] = fadd <2 x double> [[TMP35]], [[TMP37]]
; CHECK-NEXT:    [[TMP39:%.*]] = shufflevector <2 x double> [[TMP38]], <2 x double> poison, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
; CHECK-NEXT:    [[TMP40:%.*]] = shufflevector <4 x double> undef, <4 x double> [[TMP39]], <4 x i32> <i32 4, i32 5, i32 2, i32 3>
; CHECK-NEXT:    [[BLOCK87:%.*]] = shufflevector <4 x double> [[COL_LOAD53]], <4 x double> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[TMP41:%.*]] = extractelement <2 x double> [[COL_LOAD51]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT88:%.*]] = insertelement <2 x double> poison, double [[TMP41]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT89:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT88]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP42:%.*]] = fmul <2 x double> [[BLOCK87]], [[SPLAT_SPLAT89]]
; CHECK-NEXT:    [[BLOCK90:%.*]] = shufflevector <4 x double> [[COL_LOAD56]], <4 x double> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[TMP43:%.*]] = extractelement <2 x double> [[COL_LOAD51]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT91:%.*]] = insertelement <2 x double> poison, double [[TMP43]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT92:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT91]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP44:%.*]] = fmul <2 x double> [[BLOCK90]], [[SPLAT_SPLAT92]]
; CHECK-NEXT:    [[TMP45:%.*]] = fadd <2 x double> [[TMP42]], [[TMP44]]
; CHECK-NEXT:    [[TMP46:%.*]] = shufflevector <2 x double> [[TMP45]], <2 x double> poison, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
; CHECK-NEXT:    [[TMP47:%.*]] = shufflevector <4 x double> [[TMP40]], <4 x double> [[TMP46]], <4 x i32> <i32 0, i32 1, i32 4, i32 5>
; CHECK-NEXT:    [[TMP48:%.*]] = shufflevector <4 x double> [[TMP19]], <4 x double> [[TMP33]], <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:    [[TMP49:%.*]] = shufflevector <4 x double> [[TMP47]], <4 x double> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef>
; CHECK-NEXT:    [[TMP50:%.*]] = shufflevector <8 x double> [[TMP48]], <8 x double> [[TMP49]], <12 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11>
; CHECK-NEXT:    [[SPLIT:%.*]] = shufflevector <6 x double> [[TMP3]], <6 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[SPLIT1:%.*]] = shufflevector <6 x double> [[TMP3]], <6 x double> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[SPLIT2:%.*]] = shufflevector <6 x double> [[TMP3]], <6 x double> poison, <2 x i32> <i32 4, i32 5>
; CHECK-NEXT:    [[SPLIT3:%.*]] = shufflevector <12 x double> [[TMP50]], <12 x double> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; CHECK-NEXT:    [[SPLIT4:%.*]] = shufflevector <12 x double> [[TMP50]], <12 x double> poison, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:    [[SPLIT5:%.*]] = shufflevector <12 x double> [[TMP50]], <12 x double> poison, <4 x i32> <i32 8, i32 9, i32 10, i32 11>
; CHECK-NEXT:    [[BLOCK:%.*]] = shufflevector <2 x double> [[SPLIT]], <2 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP51:%.*]] = extractelement <4 x double> [[SPLIT3]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <2 x double> poison, double [[TMP51]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP52:%.*]] = fmul <2 x double> [[BLOCK]], [[SPLAT_SPLAT]]
; CHECK-NEXT:    [[BLOCK6:%.*]] = shufflevector <2 x double> [[SPLIT1]], <2 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP53:%.*]] = extractelement <4 x double> [[SPLIT4]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT7:%.*]] = insertelement <2 x double> poison, double [[TMP53]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT8:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT7]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP54:%.*]] = fmul <2 x double> [[BLOCK6]], [[SPLAT_SPLAT8]]
; CHECK-NEXT:    [[TMP55:%.*]] = fadd <2 x double> [[TMP52]], [[TMP54]]
; CHECK-NEXT:    [[BLOCK9:%.*]] = shufflevector <2 x double> [[SPLIT2]], <2 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP56:%.*]] = extractelement <4 x double> [[SPLIT5]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT10:%.*]] = insertelement <2 x double> poison, double [[TMP56]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT11:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT10]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP57:%.*]] = fmul <2 x double> [[BLOCK9]], [[SPLAT_SPLAT11]]
; CHECK-NEXT:    [[TMP58:%.*]] = fadd <2 x double> [[TMP55]], [[TMP57]]
; CHECK-NEXT:    [[TMP59:%.*]] = shufflevector <2 x double> [[TMP58]], <2 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP60:%.*]] = shufflevector <2 x double> undef, <2 x double> [[TMP59]], <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[BLOCK12:%.*]] = shufflevector <2 x double> [[SPLIT]], <2 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP61:%.*]] = extractelement <4 x double> [[SPLIT3]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT13:%.*]] = insertelement <2 x double> poison, double [[TMP61]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT14:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT13]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP62:%.*]] = fmul <2 x double> [[BLOCK12]], [[SPLAT_SPLAT14]]
; CHECK-NEXT:    [[BLOCK15:%.*]] = shufflevector <2 x double> [[SPLIT1]], <2 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP63:%.*]] = extractelement <4 x double> [[SPLIT4]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT16:%.*]] = insertelement <2 x double> poison, double [[TMP63]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT17:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT16]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP64:%.*]] = fmul <2 x double> [[BLOCK15]], [[SPLAT_SPLAT17]]
; CHECK-NEXT:    [[TMP65:%.*]] = fadd <2 x double> [[TMP62]], [[TMP64]]
; CHECK-NEXT:    [[BLOCK18:%.*]] = shufflevector <2 x double> [[SPLIT2]], <2 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP66:%.*]] = extractelement <4 x double> [[SPLIT5]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT19:%.*]] = insertelement <2 x double> poison, double [[TMP66]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT20:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT19]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP67:%.*]] = fmul <2 x double> [[BLOCK18]], [[SPLAT_SPLAT20]]
; CHECK-NEXT:    [[TMP68:%.*]] = fadd <2 x double> [[TMP65]], [[TMP67]]
; CHECK-NEXT:    [[TMP69:%.*]] = shufflevector <2 x double> [[TMP68]], <2 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP70:%.*]] = shufflevector <2 x double> undef, <2 x double> [[TMP69]], <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[BLOCK21:%.*]] = shufflevector <2 x double> [[SPLIT]], <2 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP71:%.*]] = extractelement <4 x double> [[SPLIT3]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT22:%.*]] = insertelement <2 x double> poison, double [[TMP71]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT23:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT22]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP72:%.*]] = fmul <2 x double> [[BLOCK21]], [[SPLAT_SPLAT23]]
; CHECK-NEXT:    [[BLOCK24:%.*]] = shufflevector <2 x double> [[SPLIT1]], <2 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP73:%.*]] = extractelement <4 x double> [[SPLIT4]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT25:%.*]] = insertelement <2 x double> poison, double [[TMP73]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT26:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT25]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP74:%.*]] = fmul <2 x double> [[BLOCK24]], [[SPLAT_SPLAT26]]
; CHECK-NEXT:    [[TMP75:%.*]] = fadd <2 x double> [[TMP72]], [[TMP74]]
; CHECK-NEXT:    [[BLOCK27:%.*]] = shufflevector <2 x double> [[SPLIT2]], <2 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP76:%.*]] = extractelement <4 x double> [[SPLIT5]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT28:%.*]] = insertelement <2 x double> poison, double [[TMP76]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT29:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT28]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP77:%.*]] = fmul <2 x double> [[BLOCK27]], [[SPLAT_SPLAT29]]
; CHECK-NEXT:    [[TMP78:%.*]] = fadd <2 x double> [[TMP75]], [[TMP77]]
; CHECK-NEXT:    [[TMP79:%.*]] = shufflevector <2 x double> [[TMP78]], <2 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP80:%.*]] = shufflevector <2 x double> undef, <2 x double> [[TMP79]], <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[BLOCK30:%.*]] = shufflevector <2 x double> [[SPLIT]], <2 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP81:%.*]] = extractelement <4 x double> [[SPLIT3]], i64 3
; CHECK-NEXT:    [[SPLAT_SPLATINSERT31:%.*]] = insertelement <2 x double> poison, double [[TMP81]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT32:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT31]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP82:%.*]] = fmul <2 x double> [[BLOCK30]], [[SPLAT_SPLAT32]]
; CHECK-NEXT:    [[BLOCK33:%.*]] = shufflevector <2 x double> [[SPLIT1]], <2 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP83:%.*]] = extractelement <4 x double> [[SPLIT4]], i64 3
; CHECK-NEXT:    [[SPLAT_SPLATINSERT34:%.*]] = insertelement <2 x double> poison, double [[TMP83]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT35:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT34]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP84:%.*]] = fmul <2 x double> [[BLOCK33]], [[SPLAT_SPLAT35]]
; CHECK-NEXT:    [[TMP85:%.*]] = fadd <2 x double> [[TMP82]], [[TMP84]]
; CHECK-NEXT:    [[BLOCK36:%.*]] = shufflevector <2 x double> [[SPLIT2]], <2 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP86:%.*]] = extractelement <4 x double> [[SPLIT5]], i64 3
; CHECK-NEXT:    [[SPLAT_SPLATINSERT37:%.*]] = insertelement <2 x double> poison, double [[TMP86]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT38:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT37]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP87:%.*]] = fmul <2 x double> [[BLOCK36]], [[SPLAT_SPLAT38]]
; CHECK-NEXT:    [[TMP88:%.*]] = fadd <2 x double> [[TMP85]], [[TMP87]]
; CHECK-NEXT:    [[TMP89:%.*]] = shufflevector <2 x double> [[TMP88]], <2 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP90:%.*]] = shufflevector <2 x double> undef, <2 x double> [[TMP89]], <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    store <2 x double> [[TMP60]], ptr [[R:%.*]], align 16
; CHECK-NEXT:    [[VEC_GEP94:%.*]] = getelementptr double, ptr [[R]], i64 2
; CHECK-NEXT:    store <2 x double> [[TMP70]], ptr [[VEC_GEP94]], align 16
; CHECK-NEXT:    [[VEC_GEP96:%.*]] = getelementptr double, ptr [[R]], i64 4
; CHECK-NEXT:    store <2 x double> [[TMP80]], ptr [[VEC_GEP96]], align 16
; CHECK-NEXT:    [[VEC_GEP98:%.*]] = getelementptr double, ptr [[R]], i64 6
; CHECK-NEXT:    store <2 x double> [[TMP90]], ptr [[VEC_GEP98]], align 16
; CHECK-NEXT:    ret void
;
entry:
  %a = load <6 x double>, ptr %A, align 16
  %b = load <6 x double>, ptr %B, align 16
  %c = load <8 x double>, ptr %C, align 16
  %b_t = call <6 x double> @llvm.matrix.transpose.v6f64.v6f64(<6 x double> %b, i32 2, i32 3)
  %c_t = call <8 x double> @llvm.matrix.transpose.v8f64.v8f64(<8 x double> %c, i32 4, i32 2)
  %m1 = call <12 x double> @llvm.matrix.multiply.v12f64.v6f64.v8f64(<6 x double> %b_t, <8 x double> %c_t, i32 3, i32 2, i32 4)
  %m2 = call <8 x double> @llvm.matrix.multiply.v8f64.v6f64.v12f64(<6 x double> %a, <12 x double> %m1, i32 2, i32 3, i32 4)
  store <8 x double> %m2, ptr %R, align 16
  ret void
}

define void @multiply_tt_t(ptr %A, ptr %B, ptr %C) {
; REMARK:      Pass:            lower-matrix-intrinsics
; REMARK-NEXT: Name:            matrix-lowered
; REMARK-NEXT: Function:        multiply_tt_t
; REMARK-NEXT: Args:
; REMARK-NEXT:   - String:          'Lowered with '
; REMARK-NEXT:   - NumStores:       '6'
; REMARK-NEXT:   - String:          ' stores, '
; REMARK-NEXT:   - NumLoads:        '12'
; REMARK-NEXT:   - String:          ' loads, '
; REMARK-NEXT:   - NumComputeOps:   '30'
; REMARK-NEXT:   - String:          ' compute ops, '
; REMARK-NEXT:   - NumExposedTransposes: '0'
; REMARK-NEXT:   - String:          ' exposed transposes'
; REMARK-NEXT:   - String:           |
; REMARK:            store(
; REMARK-NEXT:        multiply.3x3.3x3.double(
; REMARK-NEXT:         load(addr %B),
; REMARK-NEXT:         load(addr %A)),
; REMARK-NEXT:        addr %C)
; CHECK-LABEL: @multiply_tt_t(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[COL_LOAD:%.*]] = load <3 x double>, ptr [[A:%.*]], align 16
; CHECK-NEXT:    [[VEC_GEP:%.*]] = getelementptr double, ptr [[A]], i64 3
; CHECK-NEXT:    [[COL_LOAD2:%.*]] = load <3 x double>, ptr [[VEC_GEP]], align 8
; CHECK-NEXT:    [[VEC_GEP3:%.*]] = getelementptr double, ptr [[A]], i64 6
; CHECK-NEXT:    [[COL_LOAD5:%.*]] = load <3 x double>, ptr [[VEC_GEP3]], align 16
; CHECK-NEXT:    [[COL_LOAD7:%.*]] = load <3 x double>, ptr [[B:%.*]], align 16
; CHECK-NEXT:    [[VEC_GEP8:%.*]] = getelementptr double, ptr [[B]], i64 3
; CHECK-NEXT:    [[COL_LOAD10:%.*]] = load <3 x double>, ptr [[VEC_GEP8]], align 8
; CHECK-NEXT:    [[VEC_GEP11:%.*]] = getelementptr double, ptr [[B]], i64 6
; CHECK-NEXT:    [[COL_LOAD13:%.*]] = load <3 x double>, ptr [[VEC_GEP11]], align 16
; CHECK-NEXT:    [[BLOCK:%.*]] = shufflevector <3 x double> [[COL_LOAD7]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP2:%.*]] = extractelement <3 x double> [[COL_LOAD]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <2 x double> poison, double [[TMP2]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = fmul <2 x double> [[BLOCK]], [[SPLAT_SPLAT]]
; CHECK-NEXT:    [[BLOCK14:%.*]] = shufflevector <3 x double> [[COL_LOAD10]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP4:%.*]] = extractelement <3 x double> [[COL_LOAD]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT15:%.*]] = insertelement <2 x double> poison, double [[TMP4]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT16:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT15]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP5:%.*]] = fmul <2 x double> [[BLOCK14]], [[SPLAT_SPLAT16]]
; CHECK-NEXT:    [[TMP6:%.*]] = fadd <2 x double> [[TMP3]], [[TMP5]]
; CHECK-NEXT:    [[BLOCK17:%.*]] = shufflevector <3 x double> [[COL_LOAD13]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP7:%.*]] = extractelement <3 x double> [[COL_LOAD]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT18:%.*]] = insertelement <2 x double> poison, double [[TMP7]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT19:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT18]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP8:%.*]] = fmul <2 x double> [[BLOCK17]], [[SPLAT_SPLAT19]]
; CHECK-NEXT:    [[TMP9:%.*]] = fadd <2 x double> [[TMP6]], [[TMP8]]
; CHECK-NEXT:    [[TMP10:%.*]] = shufflevector <2 x double> [[TMP9]], <2 x double> poison, <3 x i32> <i32 0, i32 1, i32 undef>
; CHECK-NEXT:    [[TMP11:%.*]] = shufflevector <3 x double> undef, <3 x double> [[TMP10]], <3 x i32> <i32 3, i32 4, i32 2>
; CHECK-NEXT:    [[BLOCK20:%.*]] = shufflevector <3 x double> [[COL_LOAD7]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP12:%.*]] = extractelement <3 x double> [[COL_LOAD]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT21:%.*]] = insertelement <1 x double> poison, double [[TMP12]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT22:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT21]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP13:%.*]] = fmul <1 x double> [[BLOCK20]], [[SPLAT_SPLAT22]]
; CHECK-NEXT:    [[BLOCK23:%.*]] = shufflevector <3 x double> [[COL_LOAD10]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP14:%.*]] = extractelement <3 x double> [[COL_LOAD]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT24:%.*]] = insertelement <1 x double> poison, double [[TMP14]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT25:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT24]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP15:%.*]] = fmul <1 x double> [[BLOCK23]], [[SPLAT_SPLAT25]]
; CHECK-NEXT:    [[TMP16:%.*]] = fadd <1 x double> [[TMP13]], [[TMP15]]
; CHECK-NEXT:    [[BLOCK26:%.*]] = shufflevector <3 x double> [[COL_LOAD13]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP17:%.*]] = extractelement <3 x double> [[COL_LOAD]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT27:%.*]] = insertelement <1 x double> poison, double [[TMP17]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT28:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT27]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP18:%.*]] = fmul <1 x double> [[BLOCK26]], [[SPLAT_SPLAT28]]
; CHECK-NEXT:    [[TMP19:%.*]] = fadd <1 x double> [[TMP16]], [[TMP18]]
; CHECK-NEXT:    [[TMP20:%.*]] = shufflevector <1 x double> [[TMP19]], <1 x double> poison, <3 x i32> <i32 0, i32 undef, i32 undef>
; CHECK-NEXT:    [[TMP21:%.*]] = shufflevector <3 x double> [[TMP11]], <3 x double> [[TMP20]], <3 x i32> <i32 0, i32 1, i32 3>
; CHECK-NEXT:    [[BLOCK29:%.*]] = shufflevector <3 x double> [[COL_LOAD7]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP22:%.*]] = extractelement <3 x double> [[COL_LOAD2]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT30:%.*]] = insertelement <2 x double> poison, double [[TMP22]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT31:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT30]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP23:%.*]] = fmul <2 x double> [[BLOCK29]], [[SPLAT_SPLAT31]]
; CHECK-NEXT:    [[BLOCK32:%.*]] = shufflevector <3 x double> [[COL_LOAD10]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP24:%.*]] = extractelement <3 x double> [[COL_LOAD2]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT33:%.*]] = insertelement <2 x double> poison, double [[TMP24]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT34:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT33]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP25:%.*]] = fmul <2 x double> [[BLOCK32]], [[SPLAT_SPLAT34]]
; CHECK-NEXT:    [[TMP26:%.*]] = fadd <2 x double> [[TMP23]], [[TMP25]]
; CHECK-NEXT:    [[BLOCK35:%.*]] = shufflevector <3 x double> [[COL_LOAD13]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP27:%.*]] = extractelement <3 x double> [[COL_LOAD2]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT36:%.*]] = insertelement <2 x double> poison, double [[TMP27]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT37:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT36]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP28:%.*]] = fmul <2 x double> [[BLOCK35]], [[SPLAT_SPLAT37]]
; CHECK-NEXT:    [[TMP29:%.*]] = fadd <2 x double> [[TMP26]], [[TMP28]]
; CHECK-NEXT:    [[TMP30:%.*]] = shufflevector <2 x double> [[TMP29]], <2 x double> poison, <3 x i32> <i32 0, i32 1, i32 undef>
; CHECK-NEXT:    [[TMP31:%.*]] = shufflevector <3 x double> undef, <3 x double> [[TMP30]], <3 x i32> <i32 3, i32 4, i32 2>
; CHECK-NEXT:    [[BLOCK38:%.*]] = shufflevector <3 x double> [[COL_LOAD7]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP32:%.*]] = extractelement <3 x double> [[COL_LOAD2]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT39:%.*]] = insertelement <1 x double> poison, double [[TMP32]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT40:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT39]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP33:%.*]] = fmul <1 x double> [[BLOCK38]], [[SPLAT_SPLAT40]]
; CHECK-NEXT:    [[BLOCK41:%.*]] = shufflevector <3 x double> [[COL_LOAD10]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP34:%.*]] = extractelement <3 x double> [[COL_LOAD2]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT42:%.*]] = insertelement <1 x double> poison, double [[TMP34]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT43:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT42]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP35:%.*]] = fmul <1 x double> [[BLOCK41]], [[SPLAT_SPLAT43]]
; CHECK-NEXT:    [[TMP36:%.*]] = fadd <1 x double> [[TMP33]], [[TMP35]]
; CHECK-NEXT:    [[BLOCK44:%.*]] = shufflevector <3 x double> [[COL_LOAD13]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP37:%.*]] = extractelement <3 x double> [[COL_LOAD2]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT45:%.*]] = insertelement <1 x double> poison, double [[TMP37]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT46:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT45]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP38:%.*]] = fmul <1 x double> [[BLOCK44]], [[SPLAT_SPLAT46]]
; CHECK-NEXT:    [[TMP39:%.*]] = fadd <1 x double> [[TMP36]], [[TMP38]]
; CHECK-NEXT:    [[TMP40:%.*]] = shufflevector <1 x double> [[TMP39]], <1 x double> poison, <3 x i32> <i32 0, i32 undef, i32 undef>
; CHECK-NEXT:    [[TMP41:%.*]] = shufflevector <3 x double> [[TMP31]], <3 x double> [[TMP40]], <3 x i32> <i32 0, i32 1, i32 3>
; CHECK-NEXT:    [[BLOCK47:%.*]] = shufflevector <3 x double> [[COL_LOAD7]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP42:%.*]] = extractelement <3 x double> [[COL_LOAD5]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT48:%.*]] = insertelement <2 x double> poison, double [[TMP42]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT49:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT48]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP43:%.*]] = fmul <2 x double> [[BLOCK47]], [[SPLAT_SPLAT49]]
; CHECK-NEXT:    [[BLOCK50:%.*]] = shufflevector <3 x double> [[COL_LOAD10]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP44:%.*]] = extractelement <3 x double> [[COL_LOAD5]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT51:%.*]] = insertelement <2 x double> poison, double [[TMP44]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT52:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT51]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP45:%.*]] = fmul <2 x double> [[BLOCK50]], [[SPLAT_SPLAT52]]
; CHECK-NEXT:    [[TMP46:%.*]] = fadd <2 x double> [[TMP43]], [[TMP45]]
; CHECK-NEXT:    [[BLOCK53:%.*]] = shufflevector <3 x double> [[COL_LOAD13]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP47:%.*]] = extractelement <3 x double> [[COL_LOAD5]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT54:%.*]] = insertelement <2 x double> poison, double [[TMP47]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT55:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT54]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP48:%.*]] = fmul <2 x double> [[BLOCK53]], [[SPLAT_SPLAT55]]
; CHECK-NEXT:    [[TMP49:%.*]] = fadd <2 x double> [[TMP46]], [[TMP48]]
; CHECK-NEXT:    [[TMP50:%.*]] = shufflevector <2 x double> [[TMP49]], <2 x double> poison, <3 x i32> <i32 0, i32 1, i32 undef>
; CHECK-NEXT:    [[TMP51:%.*]] = shufflevector <3 x double> undef, <3 x double> [[TMP50]], <3 x i32> <i32 3, i32 4, i32 2>
; CHECK-NEXT:    [[BLOCK56:%.*]] = shufflevector <3 x double> [[COL_LOAD7]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP52:%.*]] = extractelement <3 x double> [[COL_LOAD5]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT57:%.*]] = insertelement <1 x double> poison, double [[TMP52]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT58:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT57]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP53:%.*]] = fmul <1 x double> [[BLOCK56]], [[SPLAT_SPLAT58]]
; CHECK-NEXT:    [[BLOCK59:%.*]] = shufflevector <3 x double> [[COL_LOAD10]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP54:%.*]] = extractelement <3 x double> [[COL_LOAD5]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT60:%.*]] = insertelement <1 x double> poison, double [[TMP54]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT61:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT60]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP55:%.*]] = fmul <1 x double> [[BLOCK59]], [[SPLAT_SPLAT61]]
; CHECK-NEXT:    [[TMP56:%.*]] = fadd <1 x double> [[TMP53]], [[TMP55]]
; CHECK-NEXT:    [[BLOCK62:%.*]] = shufflevector <3 x double> [[COL_LOAD13]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP57:%.*]] = extractelement <3 x double> [[COL_LOAD5]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT63:%.*]] = insertelement <1 x double> poison, double [[TMP57]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT64:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT63]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP58:%.*]] = fmul <1 x double> [[BLOCK62]], [[SPLAT_SPLAT64]]
; CHECK-NEXT:    [[TMP59:%.*]] = fadd <1 x double> [[TMP56]], [[TMP58]]
; CHECK-NEXT:    [[TMP60:%.*]] = shufflevector <1 x double> [[TMP59]], <1 x double> poison, <3 x i32> <i32 0, i32 undef, i32 undef>
; CHECK-NEXT:    [[TMP61:%.*]] = shufflevector <3 x double> [[TMP51]], <3 x double> [[TMP60]], <3 x i32> <i32 0, i32 1, i32 3>
; CHECK-NEXT:    store <3 x double> [[TMP21]], ptr [[C:%.*]], align 16
; CHECK-NEXT:    [[VEC_GEP66:%.*]] = getelementptr double, ptr [[C]], i64 3
; CHECK-NEXT:    store <3 x double> [[TMP41]], ptr [[VEC_GEP66]], align 8
; CHECK-NEXT:    [[VEC_GEP68:%.*]] = getelementptr double, ptr [[C]], i64 6
; CHECK-NEXT:    store <3 x double> [[TMP61]], ptr [[VEC_GEP68]], align 16
; CHECK-NEXT:    ret void
;
entry:
  %a = load <9 x double>, ptr %A, align 16
  %at = call <9 x double> @llvm.matrix.transpose.v9f64.v9f64(<9 x double> %a, i32 3, i32 3)
  %b = load <9 x double>, ptr %B, align 16
  %bt = call <9 x double> @llvm.matrix.transpose.v9f64.v9f64(<9 x double> %b, i32 3, i32 3)
  %c = call <9 x double> @llvm.matrix.multiply.v9f64.v9f64.v9f64(<9 x double> %at, <9 x double> %bt, i32 3, i32 3, i32 3)
  %ct = call <9 x double> @llvm.matrix.transpose.v9f64.v9f64(<9 x double> %c, i32 3, i32 3)
  store <9 x double> %ct, ptr %C, align 16
  ret void
}

define void @multiply_nt_t(ptr %A, ptr %B, ptr %C) {
; REMARK:      Pass:            lower-matrix-intrinsics
; REMARK-NEXT: Name:            matrix-lowered
; REMARK-NEXT: Function:        multiply_nt_t
; REMARK-NEXT: Args:
; REMARK-NEXT:   - String:          'Lowered with '
; REMARK-NEXT:   - NumStores:       '4'
; REMARK-NEXT:   - String:          ' stores, '
; REMARK-NEXT:   - NumLoads:        '9'
; REMARK-NEXT:   - String:          ' loads, '
; REMARK-NEXT:   - NumComputeOps:   '20'
; REMARK-NEXT:   - String:          ' compute ops, '
; REMARK-NEXT:   - NumExposedTransposes: '0'
; REMARK-NEXT:   - String:          ' exposed transposes'
; REMARK-NEXT:   - String:           |
; REMARK:            store(
; REMARK-NEXT:        multiply.4x3.3x2.double(
; REMARK-NEXT:         load(addr %B),
; REMARK-NEXT:         transpose.2x3.double(load(addr %A))),
; REMARK-NEXT:        addr %C)
; CHECK-LABEL: @multiply_nt_t(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[COL_LOAD:%.*]] = load <2 x double>, ptr [[A:%.*]], align 16
; CHECK-NEXT:    [[VEC_GEP:%.*]] = getelementptr double, ptr [[A]], i64 2
; CHECK-NEXT:    [[COL_LOAD40:%.*]] = load <2 x double>, ptr [[VEC_GEP]], align 16
; CHECK-NEXT:    [[VEC_GEP41:%.*]] = getelementptr double, ptr [[A]], i64 4
; CHECK-NEXT:    [[COL_LOAD43:%.*]] = load <2 x double>, ptr [[VEC_GEP41]], align 16
; CHECK-NEXT:    [[TMP1:%.*]] = shufflevector <2 x double> [[COL_LOAD]], <2 x double> [[COL_LOAD40]], <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; CHECK-NEXT:    [[TMP2:%.*]] = shufflevector <2 x double> [[COL_LOAD43]], <2 x double> poison, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
; CHECK-NEXT:    [[TMP3:%.*]] = shufflevector <4 x double> [[TMP1]], <4 x double> [[TMP2]], <6 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5>
; CHECK-NEXT:    [[COL_LOAD45:%.*]] = load <4 x double>, ptr [[B:%.*]], align 16
; CHECK-NEXT:    [[VEC_GEP46:%.*]] = getelementptr double, ptr [[B]], i64 4
; CHECK-NEXT:    [[COL_LOAD48:%.*]] = load <4 x double>, ptr [[VEC_GEP46]], align 16
; CHECK-NEXT:    [[VEC_GEP49:%.*]] = getelementptr double, ptr [[B]], i64 8
; CHECK-NEXT:    [[COL_LOAD51:%.*]] = load <4 x double>, ptr [[VEC_GEP49]], align 16
; CHECK-NEXT:    [[TMP5:%.*]] = shufflevector <4 x double> [[COL_LOAD45]], <4 x double> [[COL_LOAD48]], <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:    [[TMP6:%.*]] = shufflevector <4 x double> [[COL_LOAD51]], <4 x double> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef>
; CHECK-NEXT:    [[TMP7:%.*]] = shufflevector <8 x double> [[TMP5]], <8 x double> [[TMP6]], <12 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11>
; CHECK-NEXT:    [[SPLIT:%.*]] = shufflevector <12 x double> [[TMP7]], <12 x double> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; CHECK-NEXT:    [[SPLIT1:%.*]] = shufflevector <12 x double> [[TMP7]], <12 x double> poison, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:    [[SPLIT2:%.*]] = shufflevector <12 x double> [[TMP7]], <12 x double> poison, <4 x i32> <i32 8, i32 9, i32 10, i32 11>
; CHECK-NEXT:    [[SPLIT3:%.*]] = shufflevector <6 x double> [[TMP3]], <6 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[SPLIT4:%.*]] = shufflevector <6 x double> [[TMP3]], <6 x double> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[SPLIT5:%.*]] = shufflevector <6 x double> [[TMP3]], <6 x double> poison, <2 x i32> <i32 4, i32 5>
; CHECK-NEXT:    [[BLOCK:%.*]] = shufflevector <4 x double> [[SPLIT]], <4 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP8:%.*]] = extractelement <2 x double> [[SPLIT3]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <2 x double> poison, double [[TMP8]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP9:%.*]] = fmul <2 x double> [[BLOCK]], [[SPLAT_SPLAT]]
; CHECK-NEXT:    [[BLOCK6:%.*]] = shufflevector <4 x double> [[SPLIT1]], <4 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP10:%.*]] = extractelement <2 x double> [[SPLIT4]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT7:%.*]] = insertelement <2 x double> poison, double [[TMP10]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT8:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT7]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP11:%.*]] = fmul <2 x double> [[BLOCK6]], [[SPLAT_SPLAT8]]
; CHECK-NEXT:    [[TMP12:%.*]] = fadd <2 x double> [[TMP9]], [[TMP11]]
; CHECK-NEXT:    [[BLOCK9:%.*]] = shufflevector <4 x double> [[SPLIT2]], <4 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP13:%.*]] = extractelement <2 x double> [[SPLIT5]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT10:%.*]] = insertelement <2 x double> poison, double [[TMP13]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT11:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT10]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP14:%.*]] = fmul <2 x double> [[BLOCK9]], [[SPLAT_SPLAT11]]
; CHECK-NEXT:    [[TMP15:%.*]] = fadd <2 x double> [[TMP12]], [[TMP14]]
; CHECK-NEXT:    [[TMP16:%.*]] = shufflevector <2 x double> [[TMP15]], <2 x double> poison, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
; CHECK-NEXT:    [[TMP17:%.*]] = shufflevector <4 x double> undef, <4 x double> [[TMP16]], <4 x i32> <i32 4, i32 5, i32 2, i32 3>
; CHECK-NEXT:    [[BLOCK12:%.*]] = shufflevector <4 x double> [[SPLIT]], <4 x double> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[TMP18:%.*]] = extractelement <2 x double> [[SPLIT3]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT13:%.*]] = insertelement <2 x double> poison, double [[TMP18]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT14:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT13]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP19:%.*]] = fmul <2 x double> [[BLOCK12]], [[SPLAT_SPLAT14]]
; CHECK-NEXT:    [[BLOCK15:%.*]] = shufflevector <4 x double> [[SPLIT1]], <4 x double> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[TMP20:%.*]] = extractelement <2 x double> [[SPLIT4]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT16:%.*]] = insertelement <2 x double> poison, double [[TMP20]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT17:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT16]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP21:%.*]] = fmul <2 x double> [[BLOCK15]], [[SPLAT_SPLAT17]]
; CHECK-NEXT:    [[TMP22:%.*]] = fadd <2 x double> [[TMP19]], [[TMP21]]
; CHECK-NEXT:    [[BLOCK18:%.*]] = shufflevector <4 x double> [[SPLIT2]], <4 x double> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[TMP23:%.*]] = extractelement <2 x double> [[SPLIT5]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT19:%.*]] = insertelement <2 x double> poison, double [[TMP23]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT20:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT19]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP24:%.*]] = fmul <2 x double> [[BLOCK18]], [[SPLAT_SPLAT20]]
; CHECK-NEXT:    [[TMP25:%.*]] = fadd <2 x double> [[TMP22]], [[TMP24]]
; CHECK-NEXT:    [[TMP26:%.*]] = shufflevector <2 x double> [[TMP25]], <2 x double> poison, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
; CHECK-NEXT:    [[TMP27:%.*]] = shufflevector <4 x double> [[TMP17]], <4 x double> [[TMP26]], <4 x i32> <i32 0, i32 1, i32 4, i32 5>
; CHECK-NEXT:    [[BLOCK21:%.*]] = shufflevector <4 x double> [[SPLIT]], <4 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP28:%.*]] = extractelement <2 x double> [[SPLIT3]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT22:%.*]] = insertelement <2 x double> poison, double [[TMP28]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT23:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT22]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP29:%.*]] = fmul <2 x double> [[BLOCK21]], [[SPLAT_SPLAT23]]
; CHECK-NEXT:    [[BLOCK24:%.*]] = shufflevector <4 x double> [[SPLIT1]], <4 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP30:%.*]] = extractelement <2 x double> [[SPLIT4]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT25:%.*]] = insertelement <2 x double> poison, double [[TMP30]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT26:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT25]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP31:%.*]] = fmul <2 x double> [[BLOCK24]], [[SPLAT_SPLAT26]]
; CHECK-NEXT:    [[TMP32:%.*]] = fadd <2 x double> [[TMP29]], [[TMP31]]
; CHECK-NEXT:    [[BLOCK27:%.*]] = shufflevector <4 x double> [[SPLIT2]], <4 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP33:%.*]] = extractelement <2 x double> [[SPLIT5]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT28:%.*]] = insertelement <2 x double> poison, double [[TMP33]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT29:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT28]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP34:%.*]] = fmul <2 x double> [[BLOCK27]], [[SPLAT_SPLAT29]]
; CHECK-NEXT:    [[TMP35:%.*]] = fadd <2 x double> [[TMP32]], [[TMP34]]
; CHECK-NEXT:    [[TMP36:%.*]] = shufflevector <2 x double> [[TMP35]], <2 x double> poison, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
; CHECK-NEXT:    [[TMP37:%.*]] = shufflevector <4 x double> undef, <4 x double> [[TMP36]], <4 x i32> <i32 4, i32 5, i32 2, i32 3>
; CHECK-NEXT:    [[BLOCK30:%.*]] = shufflevector <4 x double> [[SPLIT]], <4 x double> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[TMP38:%.*]] = extractelement <2 x double> [[SPLIT3]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT31:%.*]] = insertelement <2 x double> poison, double [[TMP38]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT32:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT31]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP39:%.*]] = fmul <2 x double> [[BLOCK30]], [[SPLAT_SPLAT32]]
; CHECK-NEXT:    [[BLOCK33:%.*]] = shufflevector <4 x double> [[SPLIT1]], <4 x double> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[TMP40:%.*]] = extractelement <2 x double> [[SPLIT4]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT34:%.*]] = insertelement <2 x double> poison, double [[TMP40]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT35:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT34]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP41:%.*]] = fmul <2 x double> [[BLOCK33]], [[SPLAT_SPLAT35]]
; CHECK-NEXT:    [[TMP42:%.*]] = fadd <2 x double> [[TMP39]], [[TMP41]]
; CHECK-NEXT:    [[BLOCK36:%.*]] = shufflevector <4 x double> [[SPLIT2]], <4 x double> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[TMP43:%.*]] = extractelement <2 x double> [[SPLIT5]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT37:%.*]] = insertelement <2 x double> poison, double [[TMP43]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT38:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT37]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP44:%.*]] = fmul <2 x double> [[BLOCK36]], [[SPLAT_SPLAT38]]
; CHECK-NEXT:    [[TMP45:%.*]] = fadd <2 x double> [[TMP42]], [[TMP44]]
; CHECK-NEXT:    [[TMP46:%.*]] = shufflevector <2 x double> [[TMP45]], <2 x double> poison, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
; CHECK-NEXT:    [[TMP47:%.*]] = shufflevector <4 x double> [[TMP37]], <4 x double> [[TMP46]], <4 x i32> <i32 0, i32 1, i32 4, i32 5>
; CHECK-NEXT:    store <4 x double> [[TMP27]], ptr [[C:%.*]], align 16
; CHECK-NEXT:    [[VEC_GEP53:%.*]] = getelementptr double, ptr [[C]], i64 4
; CHECK-NEXT:    store <4 x double> [[TMP47]], ptr [[VEC_GEP53]], align 16
; CHECK-NEXT:    ret void
;
entry:
  %a = load <6 x double>, ptr %A, align 16
  %b = load <12 x double>, ptr %B, align 16
  %bt = call <12 x double> @llvm.matrix.transpose.v12f64.v12f64(<12 x double> %b, i32 4, i32 3)
  %c = call <8 x double> @llvm.matrix.multiply.v8f64.v6f64.v12f64(<6 x double> %a, <12 x double> %bt, i32 2, i32 3, i32 4)
  %ct = call <8 x double> @llvm.matrix.transpose.v8f64.v8f64(<8 x double> %c, i32 2, i32 4)
  store <8 x double> %ct, ptr %C, align 16
  ret void
}

define void @multiply_ntt_t(ptr %A, ptr %B, ptr %C, ptr %R) {
; REMARK:      Pass:            lower-matrix-intrinsics
; REMARK-NEXT: Name:            matrix-lowered
; REMARK-NEXT: Function:        multiply_ntt_t
; REMARK-NEXT: Args:
; REMARK-NEXT:   - String:          'Lowered with '
; REMARK-NEXT:   - NumStores:       '6'
; REMARK-NEXT:   - String:          ' stores, '
; REMARK-NEXT:   - NumLoads:        '18'
; REMARK-NEXT:   - String:          ' loads, '
; REMARK-NEXT:   - NumComputeOps:   '60'
; REMARK-NEXT:   - String:          ' compute ops, '
; REMARK-NEXT:   - NumExposedTransposes: '0'
; REMARK-NEXT:   - String:          ' exposed transposes'
; REMARK-NEXT:   - String:           |
; REMARK:            store(
; REMARK-NEXT:        multiply.3x3.3x3.double(
; REMARK-NEXT:         multiply.3x3.3x3.double(
; REMARK-NEXT:          load(addr %C),
; REMARK-NEXT:          load(addr %B)),
; REMARK-NEXT:         transpose.3x3.double(load(addr %A))),
; REMARK-NEXT:        addr %R)
; CHECK-LABEL: @multiply_ntt_t(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[COL_LOAD:%.*]] = load <3 x double>, ptr [[A:%.*]], align 16
; CHECK-NEXT:    [[VEC_GEP:%.*]] = getelementptr double, ptr [[A]], i64 3
; CHECK-NEXT:    [[COL_LOAD59:%.*]] = load <3 x double>, ptr [[VEC_GEP]], align 8
; CHECK-NEXT:    [[VEC_GEP60:%.*]] = getelementptr double, ptr [[A]], i64 6
; CHECK-NEXT:    [[COL_LOAD62:%.*]] = load <3 x double>, ptr [[VEC_GEP60]], align 16
; CHECK-NEXT:    [[TMP1:%.*]] = shufflevector <3 x double> [[COL_LOAD]], <3 x double> [[COL_LOAD59]], <6 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5>
; CHECK-NEXT:    [[TMP2:%.*]] = shufflevector <3 x double> [[COL_LOAD62]], <3 x double> poison, <6 x i32> <i32 0, i32 1, i32 2, i32 undef, i32 undef, i32 undef>
; CHECK-NEXT:    [[TMP3:%.*]] = shufflevector <6 x double> [[TMP1]], <6 x double> [[TMP2]], <9 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8>
; CHECK-NEXT:    [[COL_LOAD64:%.*]] = load <3 x double>, ptr [[B:%.*]], align 16
; CHECK-NEXT:    [[VEC_GEP65:%.*]] = getelementptr double, ptr [[B]], i64 3
; CHECK-NEXT:    [[COL_LOAD67:%.*]] = load <3 x double>, ptr [[VEC_GEP65]], align 8
; CHECK-NEXT:    [[VEC_GEP68:%.*]] = getelementptr double, ptr [[B]], i64 6
; CHECK-NEXT:    [[COL_LOAD70:%.*]] = load <3 x double>, ptr [[VEC_GEP68]], align 16
; CHECK-NEXT:    [[COL_LOAD72:%.*]] = load <3 x double>, ptr [[C:%.*]], align 16
; CHECK-NEXT:    [[VEC_GEP73:%.*]] = getelementptr double, ptr [[C]], i64 3
; CHECK-NEXT:    [[COL_LOAD75:%.*]] = load <3 x double>, ptr [[VEC_GEP73]], align 8
; CHECK-NEXT:    [[VEC_GEP76:%.*]] = getelementptr double, ptr [[C]], i64 6
; CHECK-NEXT:    [[COL_LOAD78:%.*]] = load <3 x double>, ptr [[VEC_GEP76]], align 16
; CHECK-NEXT:    [[BLOCK79:%.*]] = shufflevector <3 x double> [[COL_LOAD72]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP6:%.*]] = extractelement <3 x double> [[COL_LOAD64]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT80:%.*]] = insertelement <2 x double> poison, double [[TMP6]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT81:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT80]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP7:%.*]] = fmul <2 x double> [[BLOCK79]], [[SPLAT_SPLAT81]]
; CHECK-NEXT:    [[BLOCK82:%.*]] = shufflevector <3 x double> [[COL_LOAD75]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP8:%.*]] = extractelement <3 x double> [[COL_LOAD64]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT83:%.*]] = insertelement <2 x double> poison, double [[TMP8]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT84:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT83]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP9:%.*]] = fmul <2 x double> [[BLOCK82]], [[SPLAT_SPLAT84]]
; CHECK-NEXT:    [[TMP10:%.*]] = fadd <2 x double> [[TMP7]], [[TMP9]]
; CHECK-NEXT:    [[BLOCK85:%.*]] = shufflevector <3 x double> [[COL_LOAD78]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP11:%.*]] = extractelement <3 x double> [[COL_LOAD64]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT86:%.*]] = insertelement <2 x double> poison, double [[TMP11]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT87:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT86]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP12:%.*]] = fmul <2 x double> [[BLOCK85]], [[SPLAT_SPLAT87]]
; CHECK-NEXT:    [[TMP13:%.*]] = fadd <2 x double> [[TMP10]], [[TMP12]]
; CHECK-NEXT:    [[TMP14:%.*]] = shufflevector <2 x double> [[TMP13]], <2 x double> poison, <3 x i32> <i32 0, i32 1, i32 undef>
; CHECK-NEXT:    [[TMP15:%.*]] = shufflevector <3 x double> undef, <3 x double> [[TMP14]], <3 x i32> <i32 3, i32 4, i32 2>
; CHECK-NEXT:    [[BLOCK88:%.*]] = shufflevector <3 x double> [[COL_LOAD72]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP16:%.*]] = extractelement <3 x double> [[COL_LOAD64]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT89:%.*]] = insertelement <1 x double> poison, double [[TMP16]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT90:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT89]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP17:%.*]] = fmul <1 x double> [[BLOCK88]], [[SPLAT_SPLAT90]]
; CHECK-NEXT:    [[BLOCK91:%.*]] = shufflevector <3 x double> [[COL_LOAD75]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP18:%.*]] = extractelement <3 x double> [[COL_LOAD64]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT92:%.*]] = insertelement <1 x double> poison, double [[TMP18]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT93:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT92]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP19:%.*]] = fmul <1 x double> [[BLOCK91]], [[SPLAT_SPLAT93]]
; CHECK-NEXT:    [[TMP20:%.*]] = fadd <1 x double> [[TMP17]], [[TMP19]]
; CHECK-NEXT:    [[BLOCK94:%.*]] = shufflevector <3 x double> [[COL_LOAD78]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP21:%.*]] = extractelement <3 x double> [[COL_LOAD64]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT95:%.*]] = insertelement <1 x double> poison, double [[TMP21]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT96:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT95]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP22:%.*]] = fmul <1 x double> [[BLOCK94]], [[SPLAT_SPLAT96]]
; CHECK-NEXT:    [[TMP23:%.*]] = fadd <1 x double> [[TMP20]], [[TMP22]]
; CHECK-NEXT:    [[TMP24:%.*]] = shufflevector <1 x double> [[TMP23]], <1 x double> poison, <3 x i32> <i32 0, i32 undef, i32 undef>
; CHECK-NEXT:    [[TMP25:%.*]] = shufflevector <3 x double> [[TMP15]], <3 x double> [[TMP24]], <3 x i32> <i32 0, i32 1, i32 3>
; CHECK-NEXT:    [[BLOCK97:%.*]] = shufflevector <3 x double> [[COL_LOAD72]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP26:%.*]] = extractelement <3 x double> [[COL_LOAD67]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT98:%.*]] = insertelement <2 x double> poison, double [[TMP26]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT99:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT98]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP27:%.*]] = fmul <2 x double> [[BLOCK97]], [[SPLAT_SPLAT99]]
; CHECK-NEXT:    [[BLOCK100:%.*]] = shufflevector <3 x double> [[COL_LOAD75]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP28:%.*]] = extractelement <3 x double> [[COL_LOAD67]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT101:%.*]] = insertelement <2 x double> poison, double [[TMP28]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT102:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT101]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP29:%.*]] = fmul <2 x double> [[BLOCK100]], [[SPLAT_SPLAT102]]
; CHECK-NEXT:    [[TMP30:%.*]] = fadd <2 x double> [[TMP27]], [[TMP29]]
; CHECK-NEXT:    [[BLOCK103:%.*]] = shufflevector <3 x double> [[COL_LOAD78]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP31:%.*]] = extractelement <3 x double> [[COL_LOAD67]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT104:%.*]] = insertelement <2 x double> poison, double [[TMP31]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT105:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT104]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP32:%.*]] = fmul <2 x double> [[BLOCK103]], [[SPLAT_SPLAT105]]
; CHECK-NEXT:    [[TMP33:%.*]] = fadd <2 x double> [[TMP30]], [[TMP32]]
; CHECK-NEXT:    [[TMP34:%.*]] = shufflevector <2 x double> [[TMP33]], <2 x double> poison, <3 x i32> <i32 0, i32 1, i32 undef>
; CHECK-NEXT:    [[TMP35:%.*]] = shufflevector <3 x double> undef, <3 x double> [[TMP34]], <3 x i32> <i32 3, i32 4, i32 2>
; CHECK-NEXT:    [[BLOCK106:%.*]] = shufflevector <3 x double> [[COL_LOAD72]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP36:%.*]] = extractelement <3 x double> [[COL_LOAD67]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT107:%.*]] = insertelement <1 x double> poison, double [[TMP36]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT108:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT107]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP37:%.*]] = fmul <1 x double> [[BLOCK106]], [[SPLAT_SPLAT108]]
; CHECK-NEXT:    [[BLOCK109:%.*]] = shufflevector <3 x double> [[COL_LOAD75]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP38:%.*]] = extractelement <3 x double> [[COL_LOAD67]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT110:%.*]] = insertelement <1 x double> poison, double [[TMP38]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT111:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT110]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP39:%.*]] = fmul <1 x double> [[BLOCK109]], [[SPLAT_SPLAT111]]
; CHECK-NEXT:    [[TMP40:%.*]] = fadd <1 x double> [[TMP37]], [[TMP39]]
; CHECK-NEXT:    [[BLOCK112:%.*]] = shufflevector <3 x double> [[COL_LOAD78]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP41:%.*]] = extractelement <3 x double> [[COL_LOAD67]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT113:%.*]] = insertelement <1 x double> poison, double [[TMP41]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT114:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT113]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP42:%.*]] = fmul <1 x double> [[BLOCK112]], [[SPLAT_SPLAT114]]
; CHECK-NEXT:    [[TMP43:%.*]] = fadd <1 x double> [[TMP40]], [[TMP42]]
; CHECK-NEXT:    [[TMP44:%.*]] = shufflevector <1 x double> [[TMP43]], <1 x double> poison, <3 x i32> <i32 0, i32 undef, i32 undef>
; CHECK-NEXT:    [[TMP45:%.*]] = shufflevector <3 x double> [[TMP35]], <3 x double> [[TMP44]], <3 x i32> <i32 0, i32 1, i32 3>
; CHECK-NEXT:    [[BLOCK115:%.*]] = shufflevector <3 x double> [[COL_LOAD72]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP46:%.*]] = extractelement <3 x double> [[COL_LOAD70]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT116:%.*]] = insertelement <2 x double> poison, double [[TMP46]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT117:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT116]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP47:%.*]] = fmul <2 x double> [[BLOCK115]], [[SPLAT_SPLAT117]]
; CHECK-NEXT:    [[BLOCK118:%.*]] = shufflevector <3 x double> [[COL_LOAD75]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP48:%.*]] = extractelement <3 x double> [[COL_LOAD70]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT119:%.*]] = insertelement <2 x double> poison, double [[TMP48]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT120:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT119]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP49:%.*]] = fmul <2 x double> [[BLOCK118]], [[SPLAT_SPLAT120]]
; CHECK-NEXT:    [[TMP50:%.*]] = fadd <2 x double> [[TMP47]], [[TMP49]]
; CHECK-NEXT:    [[BLOCK121:%.*]] = shufflevector <3 x double> [[COL_LOAD78]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP51:%.*]] = extractelement <3 x double> [[COL_LOAD70]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT122:%.*]] = insertelement <2 x double> poison, double [[TMP51]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT123:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT122]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP52:%.*]] = fmul <2 x double> [[BLOCK121]], [[SPLAT_SPLAT123]]
; CHECK-NEXT:    [[TMP53:%.*]] = fadd <2 x double> [[TMP50]], [[TMP52]]
; CHECK-NEXT:    [[TMP54:%.*]] = shufflevector <2 x double> [[TMP53]], <2 x double> poison, <3 x i32> <i32 0, i32 1, i32 undef>
; CHECK-NEXT:    [[TMP55:%.*]] = shufflevector <3 x double> undef, <3 x double> [[TMP54]], <3 x i32> <i32 3, i32 4, i32 2>
; CHECK-NEXT:    [[BLOCK124:%.*]] = shufflevector <3 x double> [[COL_LOAD72]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP56:%.*]] = extractelement <3 x double> [[COL_LOAD70]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT125:%.*]] = insertelement <1 x double> poison, double [[TMP56]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT126:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT125]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP57:%.*]] = fmul <1 x double> [[BLOCK124]], [[SPLAT_SPLAT126]]
; CHECK-NEXT:    [[BLOCK127:%.*]] = shufflevector <3 x double> [[COL_LOAD75]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP58:%.*]] = extractelement <3 x double> [[COL_LOAD70]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT128:%.*]] = insertelement <1 x double> poison, double [[TMP58]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT129:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT128]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP59:%.*]] = fmul <1 x double> [[BLOCK127]], [[SPLAT_SPLAT129]]
; CHECK-NEXT:    [[TMP60:%.*]] = fadd <1 x double> [[TMP57]], [[TMP59]]
; CHECK-NEXT:    [[BLOCK130:%.*]] = shufflevector <3 x double> [[COL_LOAD78]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP61:%.*]] = extractelement <3 x double> [[COL_LOAD70]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT131:%.*]] = insertelement <1 x double> poison, double [[TMP61]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT132:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT131]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP62:%.*]] = fmul <1 x double> [[BLOCK130]], [[SPLAT_SPLAT132]]
; CHECK-NEXT:    [[TMP63:%.*]] = fadd <1 x double> [[TMP60]], [[TMP62]]
; CHECK-NEXT:    [[TMP64:%.*]] = shufflevector <1 x double> [[TMP63]], <1 x double> poison, <3 x i32> <i32 0, i32 undef, i32 undef>
; CHECK-NEXT:    [[TMP65:%.*]] = shufflevector <3 x double> [[TMP55]], <3 x double> [[TMP64]], <3 x i32> <i32 0, i32 1, i32 3>
; CHECK-NEXT:    [[TMP66:%.*]] = shufflevector <3 x double> [[TMP25]], <3 x double> [[TMP45]], <6 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5>
; CHECK-NEXT:    [[TMP67:%.*]] = shufflevector <3 x double> [[TMP65]], <3 x double> poison, <6 x i32> <i32 0, i32 1, i32 2, i32 undef, i32 undef, i32 undef>
; CHECK-NEXT:    [[TMP68:%.*]] = shufflevector <6 x double> [[TMP66]], <6 x double> [[TMP67]], <9 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8>
; CHECK-NEXT:    [[SPLIT:%.*]] = shufflevector <9 x double> [[TMP68]], <9 x double> poison, <3 x i32> <i32 0, i32 1, i32 2>
; CHECK-NEXT:    [[SPLIT2:%.*]] = shufflevector <9 x double> [[TMP68]], <9 x double> poison, <3 x i32> <i32 3, i32 4, i32 5>
; CHECK-NEXT:    [[SPLIT3:%.*]] = shufflevector <9 x double> [[TMP68]], <9 x double> poison, <3 x i32> <i32 6, i32 7, i32 8>
; CHECK-NEXT:    [[SPLIT4:%.*]] = shufflevector <9 x double> [[TMP3]], <9 x double> poison, <3 x i32> <i32 0, i32 1, i32 2>
; CHECK-NEXT:    [[SPLIT5:%.*]] = shufflevector <9 x double> [[TMP3]], <9 x double> poison, <3 x i32> <i32 3, i32 4, i32 5>
; CHECK-NEXT:    [[SPLIT6:%.*]] = shufflevector <9 x double> [[TMP3]], <9 x double> poison, <3 x i32> <i32 6, i32 7, i32 8>
; CHECK-NEXT:    [[BLOCK:%.*]] = shufflevector <3 x double> [[SPLIT]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP69:%.*]] = extractelement <3 x double> [[SPLIT4]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <2 x double> poison, double [[TMP69]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP70:%.*]] = fmul <2 x double> [[BLOCK]], [[SPLAT_SPLAT]]
; CHECK-NEXT:    [[BLOCK7:%.*]] = shufflevector <3 x double> [[SPLIT2]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP71:%.*]] = extractelement <3 x double> [[SPLIT5]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT8:%.*]] = insertelement <2 x double> poison, double [[TMP71]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT9:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT8]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP72:%.*]] = fmul <2 x double> [[BLOCK7]], [[SPLAT_SPLAT9]]
; CHECK-NEXT:    [[TMP73:%.*]] = fadd <2 x double> [[TMP70]], [[TMP72]]
; CHECK-NEXT:    [[BLOCK10:%.*]] = shufflevector <3 x double> [[SPLIT3]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP74:%.*]] = extractelement <3 x double> [[SPLIT6]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT11:%.*]] = insertelement <2 x double> poison, double [[TMP74]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT12:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT11]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP75:%.*]] = fmul <2 x double> [[BLOCK10]], [[SPLAT_SPLAT12]]
; CHECK-NEXT:    [[TMP76:%.*]] = fadd <2 x double> [[TMP73]], [[TMP75]]
; CHECK-NEXT:    [[TMP77:%.*]] = shufflevector <2 x double> [[TMP76]], <2 x double> poison, <3 x i32> <i32 0, i32 1, i32 undef>
; CHECK-NEXT:    [[TMP78:%.*]] = shufflevector <3 x double> undef, <3 x double> [[TMP77]], <3 x i32> <i32 3, i32 4, i32 2>
; CHECK-NEXT:    [[BLOCK13:%.*]] = shufflevector <3 x double> [[SPLIT]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP79:%.*]] = extractelement <3 x double> [[SPLIT4]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT14:%.*]] = insertelement <1 x double> poison, double [[TMP79]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT15:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT14]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP80:%.*]] = fmul <1 x double> [[BLOCK13]], [[SPLAT_SPLAT15]]
; CHECK-NEXT:    [[BLOCK16:%.*]] = shufflevector <3 x double> [[SPLIT2]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP81:%.*]] = extractelement <3 x double> [[SPLIT5]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT17:%.*]] = insertelement <1 x double> poison, double [[TMP81]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT18:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT17]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP82:%.*]] = fmul <1 x double> [[BLOCK16]], [[SPLAT_SPLAT18]]
; CHECK-NEXT:    [[TMP83:%.*]] = fadd <1 x double> [[TMP80]], [[TMP82]]
; CHECK-NEXT:    [[BLOCK19:%.*]] = shufflevector <3 x double> [[SPLIT3]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP84:%.*]] = extractelement <3 x double> [[SPLIT6]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT20:%.*]] = insertelement <1 x double> poison, double [[TMP84]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT21:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT20]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP85:%.*]] = fmul <1 x double> [[BLOCK19]], [[SPLAT_SPLAT21]]
; CHECK-NEXT:    [[TMP86:%.*]] = fadd <1 x double> [[TMP83]], [[TMP85]]
; CHECK-NEXT:    [[TMP87:%.*]] = shufflevector <1 x double> [[TMP86]], <1 x double> poison, <3 x i32> <i32 0, i32 undef, i32 undef>
; CHECK-NEXT:    [[TMP88:%.*]] = shufflevector <3 x double> [[TMP78]], <3 x double> [[TMP87]], <3 x i32> <i32 0, i32 1, i32 3>
; CHECK-NEXT:    [[BLOCK22:%.*]] = shufflevector <3 x double> [[SPLIT]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP89:%.*]] = extractelement <3 x double> [[SPLIT4]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT23:%.*]] = insertelement <2 x double> poison, double [[TMP89]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT24:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT23]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP90:%.*]] = fmul <2 x double> [[BLOCK22]], [[SPLAT_SPLAT24]]
; CHECK-NEXT:    [[BLOCK25:%.*]] = shufflevector <3 x double> [[SPLIT2]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP91:%.*]] = extractelement <3 x double> [[SPLIT5]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT26:%.*]] = insertelement <2 x double> poison, double [[TMP91]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT27:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT26]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP92:%.*]] = fmul <2 x double> [[BLOCK25]], [[SPLAT_SPLAT27]]
; CHECK-NEXT:    [[TMP93:%.*]] = fadd <2 x double> [[TMP90]], [[TMP92]]
; CHECK-NEXT:    [[BLOCK28:%.*]] = shufflevector <3 x double> [[SPLIT3]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP94:%.*]] = extractelement <3 x double> [[SPLIT6]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT29:%.*]] = insertelement <2 x double> poison, double [[TMP94]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT30:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT29]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP95:%.*]] = fmul <2 x double> [[BLOCK28]], [[SPLAT_SPLAT30]]
; CHECK-NEXT:    [[TMP96:%.*]] = fadd <2 x double> [[TMP93]], [[TMP95]]
; CHECK-NEXT:    [[TMP97:%.*]] = shufflevector <2 x double> [[TMP96]], <2 x double> poison, <3 x i32> <i32 0, i32 1, i32 undef>
; CHECK-NEXT:    [[TMP98:%.*]] = shufflevector <3 x double> undef, <3 x double> [[TMP97]], <3 x i32> <i32 3, i32 4, i32 2>
; CHECK-NEXT:    [[BLOCK31:%.*]] = shufflevector <3 x double> [[SPLIT]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP99:%.*]] = extractelement <3 x double> [[SPLIT4]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT32:%.*]] = insertelement <1 x double> poison, double [[TMP99]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT33:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT32]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP100:%.*]] = fmul <1 x double> [[BLOCK31]], [[SPLAT_SPLAT33]]
; CHECK-NEXT:    [[BLOCK34:%.*]] = shufflevector <3 x double> [[SPLIT2]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP101:%.*]] = extractelement <3 x double> [[SPLIT5]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT35:%.*]] = insertelement <1 x double> poison, double [[TMP101]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT36:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT35]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP102:%.*]] = fmul <1 x double> [[BLOCK34]], [[SPLAT_SPLAT36]]
; CHECK-NEXT:    [[TMP103:%.*]] = fadd <1 x double> [[TMP100]], [[TMP102]]
; CHECK-NEXT:    [[BLOCK37:%.*]] = shufflevector <3 x double> [[SPLIT3]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP104:%.*]] = extractelement <3 x double> [[SPLIT6]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT38:%.*]] = insertelement <1 x double> poison, double [[TMP104]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT39:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT38]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP105:%.*]] = fmul <1 x double> [[BLOCK37]], [[SPLAT_SPLAT39]]
; CHECK-NEXT:    [[TMP106:%.*]] = fadd <1 x double> [[TMP103]], [[TMP105]]
; CHECK-NEXT:    [[TMP107:%.*]] = shufflevector <1 x double> [[TMP106]], <1 x double> poison, <3 x i32> <i32 0, i32 undef, i32 undef>
; CHECK-NEXT:    [[TMP108:%.*]] = shufflevector <3 x double> [[TMP98]], <3 x double> [[TMP107]], <3 x i32> <i32 0, i32 1, i32 3>
; CHECK-NEXT:    [[BLOCK40:%.*]] = shufflevector <3 x double> [[SPLIT]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP109:%.*]] = extractelement <3 x double> [[SPLIT4]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT41:%.*]] = insertelement <2 x double> poison, double [[TMP109]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT42:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT41]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP110:%.*]] = fmul <2 x double> [[BLOCK40]], [[SPLAT_SPLAT42]]
; CHECK-NEXT:    [[BLOCK43:%.*]] = shufflevector <3 x double> [[SPLIT2]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP111:%.*]] = extractelement <3 x double> [[SPLIT5]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT44:%.*]] = insertelement <2 x double> poison, double [[TMP111]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT45:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT44]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP112:%.*]] = fmul <2 x double> [[BLOCK43]], [[SPLAT_SPLAT45]]
; CHECK-NEXT:    [[TMP113:%.*]] = fadd <2 x double> [[TMP110]], [[TMP112]]
; CHECK-NEXT:    [[BLOCK46:%.*]] = shufflevector <3 x double> [[SPLIT3]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP114:%.*]] = extractelement <3 x double> [[SPLIT6]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT47:%.*]] = insertelement <2 x double> poison, double [[TMP114]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT48:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT47]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP115:%.*]] = fmul <2 x double> [[BLOCK46]], [[SPLAT_SPLAT48]]
; CHECK-NEXT:    [[TMP116:%.*]] = fadd <2 x double> [[TMP113]], [[TMP115]]
; CHECK-NEXT:    [[TMP117:%.*]] = shufflevector <2 x double> [[TMP116]], <2 x double> poison, <3 x i32> <i32 0, i32 1, i32 undef>
; CHECK-NEXT:    [[TMP118:%.*]] = shufflevector <3 x double> undef, <3 x double> [[TMP117]], <3 x i32> <i32 3, i32 4, i32 2>
; CHECK-NEXT:    [[BLOCK49:%.*]] = shufflevector <3 x double> [[SPLIT]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP119:%.*]] = extractelement <3 x double> [[SPLIT4]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT50:%.*]] = insertelement <1 x double> poison, double [[TMP119]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT51:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT50]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP120:%.*]] = fmul <1 x double> [[BLOCK49]], [[SPLAT_SPLAT51]]
; CHECK-NEXT:    [[BLOCK52:%.*]] = shufflevector <3 x double> [[SPLIT2]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP121:%.*]] = extractelement <3 x double> [[SPLIT5]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT53:%.*]] = insertelement <1 x double> poison, double [[TMP121]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT54:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT53]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP122:%.*]] = fmul <1 x double> [[BLOCK52]], [[SPLAT_SPLAT54]]
; CHECK-NEXT:    [[TMP123:%.*]] = fadd <1 x double> [[TMP120]], [[TMP122]]
; CHECK-NEXT:    [[BLOCK55:%.*]] = shufflevector <3 x double> [[SPLIT3]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP124:%.*]] = extractelement <3 x double> [[SPLIT6]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT56:%.*]] = insertelement <1 x double> poison, double [[TMP124]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT57:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT56]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP125:%.*]] = fmul <1 x double> [[BLOCK55]], [[SPLAT_SPLAT57]]
; CHECK-NEXT:    [[TMP126:%.*]] = fadd <1 x double> [[TMP123]], [[TMP125]]
; CHECK-NEXT:    [[TMP127:%.*]] = shufflevector <1 x double> [[TMP126]], <1 x double> poison, <3 x i32> <i32 0, i32 undef, i32 undef>
; CHECK-NEXT:    [[TMP128:%.*]] = shufflevector <3 x double> [[TMP118]], <3 x double> [[TMP127]], <3 x i32> <i32 0, i32 1, i32 3>
; CHECK-NEXT:    store <3 x double> [[TMP88]], ptr [[R:%.*]], align 16
; CHECK-NEXT:    [[VEC_GEP134:%.*]] = getelementptr double, ptr [[R]], i64 3
; CHECK-NEXT:    store <3 x double> [[TMP108]], ptr [[VEC_GEP134]], align 8
; CHECK-NEXT:    [[VEC_GEP136:%.*]] = getelementptr double, ptr [[R]], i64 6
; CHECK-NEXT:    store <3 x double> [[TMP128]], ptr [[VEC_GEP136]], align 16
; CHECK-NEXT:    ret void
;
entry:
  %a = load <9 x double>, ptr %A, align 16
  %b = load <9 x double>, ptr %B, align 16
  %bt = call <9 x double> @llvm.matrix.transpose.v9f64.v9f64(<9 x double> %b, i32 3, i32 3)
  %c = load <9 x double>, ptr %C, align 16
  %ct = call <9 x double> @llvm.matrix.transpose.v9f64.v9f64(<9 x double> %c, i32 3, i32 3)
  %btct = call <9 x double> @llvm.matrix.multiply.v9f64.v9f64.v9f64(<9 x double> %bt, <9 x double> %ct, i32 3, i32 3, i32 3)
  %abtct= call <9 x double> @llvm.matrix.multiply.v9f64.v9f64.v9f64(<9 x double> %a, <9 x double> %btct, i32 3, i32 3, i32 3)
  %abtct_t = call <9 x double> @llvm.matrix.transpose.v9f64.v9f64(<9 x double> %abtct, i32 3, i32 3)
  store <9 x double> %abtct_t, ptr %R, align 16
  ret void
}

define <4 x float> @mult_tt_same_op(<4 x float> %a) {
; CHECK-LABEL: @mult_tt_same_op(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SPLIT:%.*]] = shufflevector <4 x float> [[A:%.*]], <4 x float> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[SPLIT1:%.*]] = shufflevector <4 x float> [[A]], <4 x float> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[SPLIT2:%.*]] = shufflevector <4 x float> [[A]], <4 x float> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[SPLIT3:%.*]] = shufflevector <4 x float> [[A]], <4 x float> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[BLOCK:%.*]] = shufflevector <2 x float> [[SPLIT]], <2 x float> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP0:%.*]] = extractelement <2 x float> [[SPLIT2]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <2 x float> poison, float [[TMP0]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <2 x float> [[SPLAT_SPLATINSERT]], <2 x float> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP1:%.*]] = fmul <2 x float> [[BLOCK]], [[SPLAT_SPLAT]]
; CHECK-NEXT:    [[BLOCK4:%.*]] = shufflevector <2 x float> [[SPLIT1]], <2 x float> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP2:%.*]] = extractelement <2 x float> [[SPLIT2]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT5:%.*]] = insertelement <2 x float> poison, float [[TMP2]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT6:%.*]] = shufflevector <2 x float> [[SPLAT_SPLATINSERT5]], <2 x float> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = fmul <2 x float> [[BLOCK4]], [[SPLAT_SPLAT6]]
; CHECK-NEXT:    [[TMP4:%.*]] = fadd <2 x float> [[TMP1]], [[TMP3]]
; CHECK-NEXT:    [[TMP5:%.*]] = shufflevector <2 x float> [[TMP4]], <2 x float> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP6:%.*]] = shufflevector <2 x float> undef, <2 x float> [[TMP5]], <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[BLOCK7:%.*]] = shufflevector <2 x float> [[SPLIT]], <2 x float> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP7:%.*]] = extractelement <2 x float> [[SPLIT3]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT8:%.*]] = insertelement <2 x float> poison, float [[TMP7]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT9:%.*]] = shufflevector <2 x float> [[SPLAT_SPLATINSERT8]], <2 x float> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP8:%.*]] = fmul <2 x float> [[BLOCK7]], [[SPLAT_SPLAT9]]
; CHECK-NEXT:    [[BLOCK10:%.*]] = shufflevector <2 x float> [[SPLIT1]], <2 x float> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP9:%.*]] = extractelement <2 x float> [[SPLIT3]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT11:%.*]] = insertelement <2 x float> poison, float [[TMP9]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT12:%.*]] = shufflevector <2 x float> [[SPLAT_SPLATINSERT11]], <2 x float> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP10:%.*]] = fmul <2 x float> [[BLOCK10]], [[SPLAT_SPLAT12]]
; CHECK-NEXT:    [[TMP11:%.*]] = fadd <2 x float> [[TMP8]], [[TMP10]]
; CHECK-NEXT:    [[TMP12:%.*]] = shufflevector <2 x float> [[TMP11]], <2 x float> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP13:%.*]] = shufflevector <2 x float> undef, <2 x float> [[TMP12]], <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[TMP14:%.*]] = extractelement <2 x float> [[TMP6]], i64 0
; CHECK-NEXT:    [[TMP15:%.*]] = insertelement <2 x float> poison, float [[TMP14]], i64 0
; CHECK-NEXT:    [[TMP16:%.*]] = extractelement <2 x float> [[TMP13]], i64 0
; CHECK-NEXT:    [[TMP17:%.*]] = insertelement <2 x float> [[TMP15]], float [[TMP16]], i64 1
; CHECK-NEXT:    [[TMP18:%.*]] = extractelement <2 x float> [[TMP6]], i64 1
; CHECK-NEXT:    [[TMP19:%.*]] = insertelement <2 x float> poison, float [[TMP18]], i64 0
; CHECK-NEXT:    [[TMP20:%.*]] = extractelement <2 x float> [[TMP13]], i64 1
; CHECK-NEXT:    [[TMP21:%.*]] = insertelement <2 x float> [[TMP19]], float [[TMP20]], i64 1
; CHECK-NEXT:    [[TMP22:%.*]] = shufflevector <2 x float> [[TMP17]], <2 x float> [[TMP21]], <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; CHECK-NEXT:    ret <4 x float> [[TMP22]]
;
entry:
  %t = call <4 x float> @llvm.matrix.transpose.v4f32(<4 x float> %a, i32 2, i32 2)
  %m = call <4 x float> @llvm.matrix.multiply.v4f32.v4f32.v4f32(<4 x float> %t, <4 x float> %t, i32 2, i32 2, i32 2)
  ret <4 x float> %m
}

define <6 x double> @transpose_of_transpose_of_non_matrix_op(ptr %a) {
; CHECK-LABEL: @transpose_of_transpose_of_non_matrix_op(
; CHECK-NEXT:    [[COL_LOAD:%.*]] = load <2 x double>, ptr [[A:%.*]], align 8
; CHECK-NEXT:    [[VEC_GEP:%.*]] = getelementptr double, ptr [[A]], i64 4
; CHECK-NEXT:    [[COL_LOAD2:%.*]] = load <2 x double>, ptr [[VEC_GEP]], align 8
; CHECK-NEXT:    [[VEC_GEP3:%.*]] = getelementptr double, ptr [[A]], i64 8
; CHECK-NEXT:    [[COL_LOAD5:%.*]] = load <2 x double>, ptr [[VEC_GEP3]], align 8
; CHECK-NEXT:    [[VEC_GEP6:%.*]] = getelementptr double, ptr [[A]], i64 12
; CHECK-NEXT:    [[COL_LOAD8:%.*]] = load <2 x double>, ptr [[VEC_GEP6]], align 8
; CHECK-NEXT:    [[TMP1:%.*]] = shufflevector <2 x double> [[COL_LOAD]], <2 x double> [[COL_LOAD2]], <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; CHECK-NEXT:    [[TMP2:%.*]] = shufflevector <2 x double> [[COL_LOAD5]], <2 x double> [[COL_LOAD8]], <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; CHECK-NEXT:    [[TMP3:%.*]] = shufflevector <4 x double> [[TMP1]], <4 x double> [[TMP2]], <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:    [[SHUF:%.*]] = shufflevector <8 x double> [[TMP3]], <8 x double> poison, <6 x i32> <i32 0, i32 1, i32 2, i32 4, i32 5, i32 6>
; CHECK-NEXT:    ret <6 x double> [[SHUF]]
;
  %load = call <8 x double> @llvm.matrix.column.major.load.v8f64(ptr %a, i64 4, i1 false, i32 2, i32 4)
  %shuf = shufflevector <8 x double> %load, <8 x double> poison, <6 x i32> <i32 0, i32 1, i32 2, i32 4, i32 5, i32 6>
  %t = call <6 x double> @llvm.matrix.transpose.v6f64.v6f64(<6 x double> %shuf, i32 3, i32 2)
  %tt = call <6 x double> @llvm.matrix.transpose.v6f64.v6f64(<6 x double> %t, i32 2, i32 3)
  ret <6 x double> %tt
}

define <12 x double> @factor_transpose(<6 x double> %a, <8 x double> %b) {
; CHECK-LABEL: @factor_transpose(
; CHECK-NEXT:    [[SPLIT:%.*]] = shufflevector <8 x double> [[B:%.*]], <8 x double> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; CHECK-NEXT:    [[SPLIT1:%.*]] = shufflevector <8 x double> [[B]], <8 x double> poison, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:    [[SPLIT2:%.*]] = shufflevector <6 x double> [[A:%.*]], <6 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[SPLIT3:%.*]] = shufflevector <6 x double> [[A]], <6 x double> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[SPLIT4:%.*]] = shufflevector <6 x double> [[A]], <6 x double> poison, <2 x i32> <i32 4, i32 5>
; CHECK-NEXT:    [[BLOCK:%.*]] = shufflevector <4 x double> [[SPLIT]], <4 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP1:%.*]] = extractelement <2 x double> [[SPLIT2]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <2 x double> poison, double [[TMP1]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP2:%.*]] = fmul <2 x double> [[BLOCK]], [[SPLAT_SPLAT]]
; CHECK-NEXT:    [[BLOCK5:%.*]] = shufflevector <4 x double> [[SPLIT1]], <4 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP3:%.*]] = extractelement <2 x double> [[SPLIT2]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT6:%.*]] = insertelement <2 x double> poison, double [[TMP3]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT7:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT6]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP4:%.*]] = fmul <2 x double> [[BLOCK5]], [[SPLAT_SPLAT7]]
; CHECK-NEXT:    [[TMP5:%.*]] = fadd <2 x double> [[TMP2]], [[TMP4]]
; CHECK-NEXT:    [[TMP6:%.*]] = shufflevector <2 x double> [[TMP5]], <2 x double> poison, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
; CHECK-NEXT:    [[TMP7:%.*]] = shufflevector <4 x double> undef, <4 x double> [[TMP6]], <4 x i32> <i32 4, i32 5, i32 2, i32 3>
; CHECK-NEXT:    [[BLOCK8:%.*]] = shufflevector <4 x double> [[SPLIT]], <4 x double> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[TMP8:%.*]] = extractelement <2 x double> [[SPLIT2]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT9:%.*]] = insertelement <2 x double> poison, double [[TMP8]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT10:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT9]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP9:%.*]] = fmul <2 x double> [[BLOCK8]], [[SPLAT_SPLAT10]]
; CHECK-NEXT:    [[BLOCK11:%.*]] = shufflevector <4 x double> [[SPLIT1]], <4 x double> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[TMP10:%.*]] = extractelement <2 x double> [[SPLIT2]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT12:%.*]] = insertelement <2 x double> poison, double [[TMP10]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT13:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT12]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP11:%.*]] = fmul <2 x double> [[BLOCK11]], [[SPLAT_SPLAT13]]
; CHECK-NEXT:    [[TMP12:%.*]] = fadd <2 x double> [[TMP9]], [[TMP11]]
; CHECK-NEXT:    [[TMP13:%.*]] = shufflevector <2 x double> [[TMP12]], <2 x double> poison, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
; CHECK-NEXT:    [[TMP14:%.*]] = shufflevector <4 x double> [[TMP7]], <4 x double> [[TMP13]], <4 x i32> <i32 0, i32 1, i32 4, i32 5>
; CHECK-NEXT:    [[BLOCK14:%.*]] = shufflevector <4 x double> [[SPLIT]], <4 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP15:%.*]] = extractelement <2 x double> [[SPLIT3]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT15:%.*]] = insertelement <2 x double> poison, double [[TMP15]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT16:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT15]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP16:%.*]] = fmul <2 x double> [[BLOCK14]], [[SPLAT_SPLAT16]]
; CHECK-NEXT:    [[BLOCK17:%.*]] = shufflevector <4 x double> [[SPLIT1]], <4 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP17:%.*]] = extractelement <2 x double> [[SPLIT3]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT18:%.*]] = insertelement <2 x double> poison, double [[TMP17]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT19:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT18]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP18:%.*]] = fmul <2 x double> [[BLOCK17]], [[SPLAT_SPLAT19]]
; CHECK-NEXT:    [[TMP19:%.*]] = fadd <2 x double> [[TMP16]], [[TMP18]]
; CHECK-NEXT:    [[TMP20:%.*]] = shufflevector <2 x double> [[TMP19]], <2 x double> poison, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
; CHECK-NEXT:    [[TMP21:%.*]] = shufflevector <4 x double> undef, <4 x double> [[TMP20]], <4 x i32> <i32 4, i32 5, i32 2, i32 3>
; CHECK-NEXT:    [[BLOCK20:%.*]] = shufflevector <4 x double> [[SPLIT]], <4 x double> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[TMP22:%.*]] = extractelement <2 x double> [[SPLIT3]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT21:%.*]] = insertelement <2 x double> poison, double [[TMP22]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT22:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT21]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP23:%.*]] = fmul <2 x double> [[BLOCK20]], [[SPLAT_SPLAT22]]
; CHECK-NEXT:    [[BLOCK23:%.*]] = shufflevector <4 x double> [[SPLIT1]], <4 x double> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[TMP24:%.*]] = extractelement <2 x double> [[SPLIT3]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT24:%.*]] = insertelement <2 x double> poison, double [[TMP24]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT25:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT24]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP25:%.*]] = fmul <2 x double> [[BLOCK23]], [[SPLAT_SPLAT25]]
; CHECK-NEXT:    [[TMP26:%.*]] = fadd <2 x double> [[TMP23]], [[TMP25]]
; CHECK-NEXT:    [[TMP27:%.*]] = shufflevector <2 x double> [[TMP26]], <2 x double> poison, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
; CHECK-NEXT:    [[TMP28:%.*]] = shufflevector <4 x double> [[TMP21]], <4 x double> [[TMP27]], <4 x i32> <i32 0, i32 1, i32 4, i32 5>
; CHECK-NEXT:    [[BLOCK26:%.*]] = shufflevector <4 x double> [[SPLIT]], <4 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP29:%.*]] = extractelement <2 x double> [[SPLIT4]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT27:%.*]] = insertelement <2 x double> poison, double [[TMP29]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT28:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT27]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP30:%.*]] = fmul <2 x double> [[BLOCK26]], [[SPLAT_SPLAT28]]
; CHECK-NEXT:    [[BLOCK29:%.*]] = shufflevector <4 x double> [[SPLIT1]], <4 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP31:%.*]] = extractelement <2 x double> [[SPLIT4]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT30:%.*]] = insertelement <2 x double> poison, double [[TMP31]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT31:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT30]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP32:%.*]] = fmul <2 x double> [[BLOCK29]], [[SPLAT_SPLAT31]]
; CHECK-NEXT:    [[TMP33:%.*]] = fadd <2 x double> [[TMP30]], [[TMP32]]
; CHECK-NEXT:    [[TMP34:%.*]] = shufflevector <2 x double> [[TMP33]], <2 x double> poison, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
; CHECK-NEXT:    [[TMP35:%.*]] = shufflevector <4 x double> undef, <4 x double> [[TMP34]], <4 x i32> <i32 4, i32 5, i32 2, i32 3>
; CHECK-NEXT:    [[BLOCK32:%.*]] = shufflevector <4 x double> [[SPLIT]], <4 x double> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[TMP36:%.*]] = extractelement <2 x double> [[SPLIT4]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT33:%.*]] = insertelement <2 x double> poison, double [[TMP36]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT34:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT33]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP37:%.*]] = fmul <2 x double> [[BLOCK32]], [[SPLAT_SPLAT34]]
; CHECK-NEXT:    [[BLOCK35:%.*]] = shufflevector <4 x double> [[SPLIT1]], <4 x double> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[TMP38:%.*]] = extractelement <2 x double> [[SPLIT4]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT36:%.*]] = insertelement <2 x double> poison, double [[TMP38]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT37:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT36]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP39:%.*]] = fmul <2 x double> [[BLOCK35]], [[SPLAT_SPLAT37]]
; CHECK-NEXT:    [[TMP40:%.*]] = fadd <2 x double> [[TMP37]], [[TMP39]]
; CHECK-NEXT:    [[TMP41:%.*]] = shufflevector <2 x double> [[TMP40]], <2 x double> poison, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
; CHECK-NEXT:    [[TMP42:%.*]] = shufflevector <4 x double> [[TMP35]], <4 x double> [[TMP41]], <4 x i32> <i32 0, i32 1, i32 4, i32 5>
; CHECK-NEXT:    [[TMP43:%.*]] = extractelement <4 x double> [[TMP14]], i64 0
; CHECK-NEXT:    [[TMP44:%.*]] = insertelement <3 x double> poison, double [[TMP43]], i64 0
; CHECK-NEXT:    [[TMP45:%.*]] = extractelement <4 x double> [[TMP28]], i64 0
; CHECK-NEXT:    [[TMP46:%.*]] = insertelement <3 x double> [[TMP44]], double [[TMP45]], i64 1
; CHECK-NEXT:    [[TMP47:%.*]] = extractelement <4 x double> [[TMP42]], i64 0
; CHECK-NEXT:    [[TMP48:%.*]] = insertelement <3 x double> [[TMP46]], double [[TMP47]], i64 2
; CHECK-NEXT:    [[TMP49:%.*]] = extractelement <4 x double> [[TMP14]], i64 1
; CHECK-NEXT:    [[TMP50:%.*]] = insertelement <3 x double> poison, double [[TMP49]], i64 0
; CHECK-NEXT:    [[TMP51:%.*]] = extractelement <4 x double> [[TMP28]], i64 1
; CHECK-NEXT:    [[TMP52:%.*]] = insertelement <3 x double> [[TMP50]], double [[TMP51]], i64 1
; CHECK-NEXT:    [[TMP53:%.*]] = extractelement <4 x double> [[TMP42]], i64 1
; CHECK-NEXT:    [[TMP54:%.*]] = insertelement <3 x double> [[TMP52]], double [[TMP53]], i64 2
; CHECK-NEXT:    [[TMP55:%.*]] = extractelement <4 x double> [[TMP14]], i64 2
; CHECK-NEXT:    [[TMP56:%.*]] = insertelement <3 x double> poison, double [[TMP55]], i64 0
; CHECK-NEXT:    [[TMP57:%.*]] = extractelement <4 x double> [[TMP28]], i64 2
; CHECK-NEXT:    [[TMP58:%.*]] = insertelement <3 x double> [[TMP56]], double [[TMP57]], i64 1
; CHECK-NEXT:    [[TMP59:%.*]] = extractelement <4 x double> [[TMP42]], i64 2
; CHECK-NEXT:    [[TMP60:%.*]] = insertelement <3 x double> [[TMP58]], double [[TMP59]], i64 2
; CHECK-NEXT:    [[TMP61:%.*]] = extractelement <4 x double> [[TMP14]], i64 3
; CHECK-NEXT:    [[TMP62:%.*]] = insertelement <3 x double> poison, double [[TMP61]], i64 0
; CHECK-NEXT:    [[TMP63:%.*]] = extractelement <4 x double> [[TMP28]], i64 3
; CHECK-NEXT:    [[TMP64:%.*]] = insertelement <3 x double> [[TMP62]], double [[TMP63]], i64 1
; CHECK-NEXT:    [[TMP65:%.*]] = extractelement <4 x double> [[TMP42]], i64 3
; CHECK-NEXT:    [[TMP66:%.*]] = insertelement <3 x double> [[TMP64]], double [[TMP65]], i64 2
; CHECK-NEXT:    [[TMP67:%.*]] = shufflevector <3 x double> [[TMP48]], <3 x double> [[TMP54]], <6 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5>
; CHECK-NEXT:    [[TMP68:%.*]] = shufflevector <3 x double> [[TMP60]], <3 x double> [[TMP66]], <6 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5>
; CHECK-NEXT:    [[TMP69:%.*]] = shufflevector <6 x double> [[TMP67]], <6 x double> [[TMP68]], <12 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11>
; CHECK-NEXT:    ret <12 x double> [[TMP69]]
;
  %at = call <6 x double> @llvm.matrix.transpose.v6f64.v6f64(<6 x double> %a, i32 2, i32 3)
  %bt = call <8 x double> @llvm.matrix.transpose.v8f64.v8f64(<8 x double> %b, i32 4, i32 2)
  %m = call <12 x double> @llvm.matrix.multiply.v12f64.v6f64.v8f64(<6 x double> %at, <8 x double> %bt, i32 3, i32 2, i32 4)
  ret <12 x double> %m
}

declare <9 x double> @llvm.matrix.multiply.v9f64.v9f64.v9f64(<9 x double>, <9 x double>, i32, i32, i32)
declare <12 x double> @llvm.matrix.multiply.v12f64.v6f64.v8f64(<6 x double>, <8 x double>, i32, i32, i32)
declare <8 x double> @llvm.matrix.multiply.v8f64.v6f64.v12f64(<6 x double> %a, <12 x double>, i32, i32, i32)
declare <4 x float> @llvm.matrix.multiply.v4f32.v4f32.v4f32(<4 x float>, <4 x float>, i32, i32, i32)
declare <9 x double> @llvm.matrix.transpose.v9f64.v9f64(<9 x double>, i32, i32)
declare <6 x double> @llvm.matrix.transpose.v6f64.v6f64(<6 x double>, i32, i32)
declare <8 x double> @llvm.matrix.transpose.v8f64.v8f64(<8 x double>, i32, i32)
declare <12 x double> @llvm.matrix.transpose.v12f64.v12f64(<12 x double>, i32, i32)
declare <4 x float> @llvm.matrix.transpose.v4f32(<4 x float>, i32, i32)
declare <8 x double> @llvm.matrix.column.major.load.v8f64(ptr, i64, i1, i32, i32)
