﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/codeguru-security/CodeGuruSecurity_EXPORTS.h>
#include <aws/codeguru-security/model/FilePath.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace CodeGuruSecurity
{
namespace Model
{

  /**
   * <p>Information about a security vulnerability that Amazon CodeGuru Security
   * detected.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/Vulnerability">AWS
   * API Reference</a></p>
   */
  class Vulnerability
  {
  public:
    AWS_CODEGURUSECURITY_API Vulnerability();
    AWS_CODEGURUSECURITY_API Vulnerability(Aws::Utils::Json::JsonView jsonValue);
    AWS_CODEGURUSECURITY_API Vulnerability& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_CODEGURUSECURITY_API Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p> An object that describes the location of the detected security vulnerability
     * in your code.</p>
     */
    inline const FilePath& GetFilePath() const{ return m_filePath; }

    /**
     * <p> An object that describes the location of the detected security vulnerability
     * in your code.</p>
     */
    inline bool FilePathHasBeenSet() const { return m_filePathHasBeenSet; }

    /**
     * <p> An object that describes the location of the detected security vulnerability
     * in your code.</p>
     */
    inline void SetFilePath(const FilePath& value) { m_filePathHasBeenSet = true; m_filePath = value; }

    /**
     * <p> An object that describes the location of the detected security vulnerability
     * in your code.</p>
     */
    inline void SetFilePath(FilePath&& value) { m_filePathHasBeenSet = true; m_filePath = std::move(value); }

    /**
     * <p> An object that describes the location of the detected security vulnerability
     * in your code.</p>
     */
    inline Vulnerability& WithFilePath(const FilePath& value) { SetFilePath(value); return *this;}

    /**
     * <p> An object that describes the location of the detected security vulnerability
     * in your code.</p>
     */
    inline Vulnerability& WithFilePath(FilePath&& value) { SetFilePath(std::move(value)); return *this;}


    /**
     * <p>The identifier for the vulnerability.</p>
     */
    inline const Aws::String& GetId() const{ return m_id; }

    /**
     * <p>The identifier for the vulnerability.</p>
     */
    inline bool IdHasBeenSet() const { return m_idHasBeenSet; }

    /**
     * <p>The identifier for the vulnerability.</p>
     */
    inline void SetId(const Aws::String& value) { m_idHasBeenSet = true; m_id = value; }

    /**
     * <p>The identifier for the vulnerability.</p>
     */
    inline void SetId(Aws::String&& value) { m_idHasBeenSet = true; m_id = std::move(value); }

    /**
     * <p>The identifier for the vulnerability.</p>
     */
    inline void SetId(const char* value) { m_idHasBeenSet = true; m_id.assign(value); }

    /**
     * <p>The identifier for the vulnerability.</p>
     */
    inline Vulnerability& WithId(const Aws::String& value) { SetId(value); return *this;}

    /**
     * <p>The identifier for the vulnerability.</p>
     */
    inline Vulnerability& WithId(Aws::String&& value) { SetId(std::move(value)); return *this;}

    /**
     * <p>The identifier for the vulnerability.</p>
     */
    inline Vulnerability& WithId(const char* value) { SetId(value); return *this;}


    /**
     * <p> The number of times the vulnerability appears in your code.</p>
     */
    inline int GetItemCount() const{ return m_itemCount; }

    /**
     * <p> The number of times the vulnerability appears in your code.</p>
     */
    inline bool ItemCountHasBeenSet() const { return m_itemCountHasBeenSet; }

    /**
     * <p> The number of times the vulnerability appears in your code.</p>
     */
    inline void SetItemCount(int value) { m_itemCountHasBeenSet = true; m_itemCount = value; }

    /**
     * <p> The number of times the vulnerability appears in your code.</p>
     */
    inline Vulnerability& WithItemCount(int value) { SetItemCount(value); return *this;}


    /**
     * <p>One or more URL addresses that contain details about a vulnerability.</p>
     */
    inline const Aws::Vector<Aws::String>& GetReferenceUrls() const{ return m_referenceUrls; }

    /**
     * <p>One or more URL addresses that contain details about a vulnerability.</p>
     */
    inline bool ReferenceUrlsHasBeenSet() const { return m_referenceUrlsHasBeenSet; }

    /**
     * <p>One or more URL addresses that contain details about a vulnerability.</p>
     */
    inline void SetReferenceUrls(const Aws::Vector<Aws::String>& value) { m_referenceUrlsHasBeenSet = true; m_referenceUrls = value; }

    /**
     * <p>One or more URL addresses that contain details about a vulnerability.</p>
     */
    inline void SetReferenceUrls(Aws::Vector<Aws::String>&& value) { m_referenceUrlsHasBeenSet = true; m_referenceUrls = std::move(value); }

    /**
     * <p>One or more URL addresses that contain details about a vulnerability.</p>
     */
    inline Vulnerability& WithReferenceUrls(const Aws::Vector<Aws::String>& value) { SetReferenceUrls(value); return *this;}

    /**
     * <p>One or more URL addresses that contain details about a vulnerability.</p>
     */
    inline Vulnerability& WithReferenceUrls(Aws::Vector<Aws::String>&& value) { SetReferenceUrls(std::move(value)); return *this;}

    /**
     * <p>One or more URL addresses that contain details about a vulnerability.</p>
     */
    inline Vulnerability& AddReferenceUrls(const Aws::String& value) { m_referenceUrlsHasBeenSet = true; m_referenceUrls.push_back(value); return *this; }

    /**
     * <p>One or more URL addresses that contain details about a vulnerability.</p>
     */
    inline Vulnerability& AddReferenceUrls(Aws::String&& value) { m_referenceUrlsHasBeenSet = true; m_referenceUrls.push_back(std::move(value)); return *this; }

    /**
     * <p>One or more URL addresses that contain details about a vulnerability.</p>
     */
    inline Vulnerability& AddReferenceUrls(const char* value) { m_referenceUrlsHasBeenSet = true; m_referenceUrls.push_back(value); return *this; }


    /**
     * <p>One or more vulnerabilities that are related to the vulnerability being
     * described.</p>
     */
    inline const Aws::Vector<Aws::String>& GetRelatedVulnerabilities() const{ return m_relatedVulnerabilities; }

    /**
     * <p>One or more vulnerabilities that are related to the vulnerability being
     * described.</p>
     */
    inline bool RelatedVulnerabilitiesHasBeenSet() const { return m_relatedVulnerabilitiesHasBeenSet; }

    /**
     * <p>One or more vulnerabilities that are related to the vulnerability being
     * described.</p>
     */
    inline void SetRelatedVulnerabilities(const Aws::Vector<Aws::String>& value) { m_relatedVulnerabilitiesHasBeenSet = true; m_relatedVulnerabilities = value; }

    /**
     * <p>One or more vulnerabilities that are related to the vulnerability being
     * described.</p>
     */
    inline void SetRelatedVulnerabilities(Aws::Vector<Aws::String>&& value) { m_relatedVulnerabilitiesHasBeenSet = true; m_relatedVulnerabilities = std::move(value); }

    /**
     * <p>One or more vulnerabilities that are related to the vulnerability being
     * described.</p>
     */
    inline Vulnerability& WithRelatedVulnerabilities(const Aws::Vector<Aws::String>& value) { SetRelatedVulnerabilities(value); return *this;}

    /**
     * <p>One or more vulnerabilities that are related to the vulnerability being
     * described.</p>
     */
    inline Vulnerability& WithRelatedVulnerabilities(Aws::Vector<Aws::String>&& value) { SetRelatedVulnerabilities(std::move(value)); return *this;}

    /**
     * <p>One or more vulnerabilities that are related to the vulnerability being
     * described.</p>
     */
    inline Vulnerability& AddRelatedVulnerabilities(const Aws::String& value) { m_relatedVulnerabilitiesHasBeenSet = true; m_relatedVulnerabilities.push_back(value); return *this; }

    /**
     * <p>One or more vulnerabilities that are related to the vulnerability being
     * described.</p>
     */
    inline Vulnerability& AddRelatedVulnerabilities(Aws::String&& value) { m_relatedVulnerabilitiesHasBeenSet = true; m_relatedVulnerabilities.push_back(std::move(value)); return *this; }

    /**
     * <p>One or more vulnerabilities that are related to the vulnerability being
     * described.</p>
     */
    inline Vulnerability& AddRelatedVulnerabilities(const char* value) { m_relatedVulnerabilitiesHasBeenSet = true; m_relatedVulnerabilities.push_back(value); return *this; }

  private:

    FilePath m_filePath;
    bool m_filePathHasBeenSet = false;

    Aws::String m_id;
    bool m_idHasBeenSet = false;

    int m_itemCount;
    bool m_itemCountHasBeenSet = false;

    Aws::Vector<Aws::String> m_referenceUrls;
    bool m_referenceUrlsHasBeenSet = false;

    Aws::Vector<Aws::String> m_relatedVulnerabilities;
    bool m_relatedVulnerabilitiesHasBeenSet = false;
  };

} // namespace Model
} // namespace CodeGuruSecurity
} // namespace Aws
