﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/ds/model/ResetUserPasswordRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::DirectoryService::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

ResetUserPasswordRequest::ResetUserPasswordRequest() : 
    m_directoryIdHasBeenSet(false),
    m_userNameHasBeenSet(false),
    m_newPasswordHasBeenSet(false)
{
}

Aws::String ResetUserPasswordRequest::SerializePayload() const
{
  JsonValue payload;

  if(m_directoryIdHasBeenSet)
  {
   payload.WithString("DirectoryId", m_directoryId);

  }

  if(m_userNameHasBeenSet)
  {
   payload.WithString("UserName", m_userName);

  }

  if(m_newPasswordHasBeenSet)
  {
   payload.WithString("NewPassword", m_newPassword);

  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection ResetUserPasswordRequest::GetRequestSpecificHeaders() const
{
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "DirectoryService_20150416.ResetUserPassword"));
  return headers;

}




