/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.inject;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.scr.impl.helper.Coercions;
import org.osgi.framework.Bundle;
import org.osgi.service.component.ComponentException;

public class Annotations {
    private static final Pattern p = Pattern.compile("(\\$\\$)|(\\$)|(__)|(_)");

    public static <T> T toObject(Class<T> clazz, Map<String, Object> props, Bundle b, boolean supportsInterfaces) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        Method[] methods = clazz.getMethods();
        HashMap<String, Method> complexFields = new HashMap<String, Method>();
        for (Method method : methods) {
            Object cooked;
            String name = method.getName();
            String key = Annotations.fixup(name);
            Object raw = props.get(key);
            Class<?> returnType = method.getReturnType();
            if (returnType.isInterface() || returnType.isAnnotation()) {
                complexFields.put(key, method);
                continue;
            }
            try {
                if (returnType.isArray()) {
                    Class<?> componentType = returnType.getComponentType();
                    if (componentType.isInterface() || componentType.isAnnotation()) {
                        complexFields.put(key, method);
                        continue;
                    }
                    cooked = Annotations.coerceToArray(componentType, raw, b);
                } else {
                    cooked = Coercions.coerce(returnType, raw, b);
                }
            }
            catch (ComponentException e) {
                cooked = new Invalid(e);
            }
            m.put(name, cooked);
        }
        if (!complexFields.isEmpty()) {
            if (supportsInterfaces) {
                Map<String, List<Map<String, Object>>> nested = Annotations.extractSubMaps(complexFields.keySet(), props);
                for (Map.Entry entry : complexFields.entrySet()) {
                    Method method;
                    Class<?> returnType;
                    List<Map<String, Object>> proplist = nested.get(entry.getKey());
                    if (proplist == null) {
                        proplist = Collections.emptyList();
                    }
                    if ((returnType = (method = (Method)entry.getValue()).getReturnType()).isArray()) {
                        Class<?> componentType = returnType.getComponentType();
                        Object result = Array.newInstance(componentType, proplist.size());
                        for (int i = 0; i < proplist.size(); ++i) {
                            Map<String, Object> rawElement = proplist.get(i);
                            Object cooked = Annotations.toObject(componentType, rawElement, b, supportsInterfaces);
                            Array.set(result, i, cooked);
                        }
                        m.put(method.getName(), result);
                        continue;
                    }
                    if (proplist.isEmpty()) continue;
                    Object cooked = Annotations.toObject(returnType, proplist.get(0), b, supportsInterfaces);
                    m.put(method.getName(), cooked);
                }
            } else {
                for (Method method : complexFields.values()) {
                    m.put(method.getName(), new Invalid("Invalid annotation member type" + method.getReturnType().getName() + " for member: " + method.getName()));
                }
            }
        }
        Handler h = new Handler(m);
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)h);
    }

    private static Map<String, List<Map<String, Object>>> extractSubMaps(Collection<String> keys, Map<String, Object> map) {
        HashMap<String, List<Map<String, Object>>> result = new HashMap<String, List<Map<String, Object>>>();
        StringBuilder b = new StringBuilder("(");
        for (String key : keys) {
            b.append(key).append("|");
        }
        b.deleteCharAt(b.length() - 1);
        b.append(")\\.([0-9]*)\\.(.*)");
        Pattern p = Pattern.compile(b.toString());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String longKey = entry.getKey();
            Matcher m = p.matcher(longKey);
            if (!m.matches()) continue;
            String key = m.group(1);
            int index = Integer.parseInt(m.group(2));
            String subkey = m.group(3);
            ArrayList subMapsForKey = (ArrayList)result.get(key);
            if (subMapsForKey == null) {
                subMapsForKey = new ArrayList();
                result.put(key, subMapsForKey);
            }
            for (int i = subMapsForKey.size(); i <= index; ++i) {
                subMapsForKey.add(new HashMap());
            }
            Map subMap = (Map)subMapsForKey.get(index);
            subMap.put(subkey, entry.getValue());
        }
        return result;
    }

    private static Object coerceToArray(Class<?> componentType, Object raw, Bundle bundle) {
        if (raw == null) {
            return null;
        }
        if (raw.getClass().isArray()) {
            int size = Array.getLength(raw);
            Object result = Array.newInstance(componentType, size);
            for (int i = 0; i < size; ++i) {
                Object rawElement = Array.get(raw, i);
                Object cooked = Coercions.coerce(componentType, rawElement, bundle);
                Array.set(result, i, cooked);
            }
            return result;
        }
        if (raw instanceof Collection) {
            Collection raws = (Collection)raw;
            int size = raws.size();
            Object result = Array.newInstance(componentType, size);
            int i = 0;
            for (Object rawElement : raws) {
                Object cooked = Coercions.coerce(componentType, rawElement, bundle);
                Array.set(result, i++, cooked);
            }
            return result;
        }
        Object cooked = Coercions.coerce(componentType, raw, bundle);
        Object result = Array.newInstance(componentType, 1);
        Array.set(result, 0, cooked);
        return result;
    }

    static String fixup(String name) {
        Matcher m = p.matcher(name);
        StringBuffer b = new StringBuffer();
        while (m.find()) {
            String replacement = "";
            if (m.group(1) != null) {
                replacement = "\\$";
            }
            if (m.group(2) != null) {
                replacement = "";
            }
            if (m.group(3) != null) {
                replacement = "_";
            }
            if (m.group(4) != null) {
                replacement = ".";
            }
            m.appendReplacement(b, replacement);
        }
        m.appendTail(b);
        return b.toString();
    }

    private static final class Invalid {
        private final String message;

        public Invalid(ComponentException e) {
            this.message = e.getMessage();
        }

        public Invalid(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }

    private static final class Handler
    implements InvocationHandler {
        private final Map<String, Object> values;

        public Handler(Map<String, Object> values) {
            this.values = values;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object value = this.values.get(method.getName());
            if (value instanceof Invalid) {
                throw new ComponentException(((Invalid)value).getMessage());
            }
            return value;
        }
    }
}

