/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.inject;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.felix.scr.impl.helper.InitReferenceMethod;
import org.apache.felix.scr.impl.helper.MethodResult;
import org.apache.felix.scr.impl.helper.ReadOnlyDictionary;
import org.apache.felix.scr.impl.helper.ReferenceMethod;
import org.apache.felix.scr.impl.helper.SimpleLogger;
import org.apache.felix.scr.impl.inject.BindParameters;
import org.apache.felix.scr.impl.inject.ClassUtils;
import org.apache.felix.scr.impl.inject.SuitableMethodNotAccessibleException;
import org.apache.felix.scr.impl.manager.ComponentContextImpl;
import org.apache.felix.scr.impl.manager.RefPair;
import org.apache.felix.scr.impl.metadata.ReferenceMetadata;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class FieldHandler {
    private final ReferenceMetadata metadata;
    private final Class<?> componentClass;
    private volatile Field field;
    private volatile ParamType valueType;
    private volatile State state;

    public FieldHandler(ReferenceMetadata metadata, Class<?> componentClass) {
        this.metadata = metadata;
        this.componentClass = componentClass;
        this.state = NotResolved.INSTANCE;
    }

    private void setField(Field f, SimpleLogger logger) {
        this.field = f;
        if (f != null) {
            this.state = Resolved.INSTANCE;
            logger.log(4, "Found field: {0}", new Object[]{this.field}, null);
        } else {
            this.state = NotFound.INSTANCE;
            logger.log(1, "Field [{0}] not found; Component will fail", new Object[]{this.metadata.getField()}, null);
        }
    }

    private Field findField(SimpleLogger logger) throws InvocationTargetException {
        Class<?> targetClass = this.componentClass;
        ClassLoader targetClasslLoader = targetClass.getClassLoader();
        String targetPackage = FieldHandler.getPackageName(targetClass);
        Class<?> theClass = targetClass;
        boolean acceptPrivate = true;
        boolean acceptPackage = true;
        while (true) {
            if (logger.isLogEnabled(4)) {
                logger.log(4, "Locating field " + this.metadata.getField() + " in class " + theClass.getName(), null);
            }
            try {
                Field field = this.getField(theClass, acceptPrivate, acceptPackage, logger);
                if (field != null) {
                    return field;
                }
            }
            catch (SuitableMethodNotAccessibleException ex) {
                logger.log(1, "findField: Suitable but non-accessible field {0} found in class {1}, subclass of {2}", new Object[]{this.metadata.getField(), theClass.getName(), targetClass.getName()}, null);
                break;
            }
            theClass = theClass.getSuperclass();
            if (theClass == null) break;
            acceptPackage &= targetClasslLoader == theClass.getClassLoader() && targetPackage.equals(FieldHandler.getPackageName(theClass));
            acceptPrivate = false;
        }
        return null;
    }

    private Field getField(Class<?> clazz, boolean acceptPrivate, boolean acceptPackage, SimpleLogger logger) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        try {
            Field field = clazz.getDeclaredField(this.metadata.getField());
            if (FieldHandler.accept(field, acceptPrivate, acceptPackage)) {
                return field;
            }
            throw new SuitableMethodNotAccessibleException();
        }
        catch (NoSuchFieldException nsfe) {
            if (logger.isLogEnabled(4)) {
                logger.log(4, "Declared Field {0}.{1} not found", new Object[]{clazz.getName(), this.metadata.getField()}, null);
            }
        }
        catch (NoClassDefFoundError cdfe) {
            if (logger.isLogEnabled(2)) {
                StringBuffer buf = new StringBuffer();
                buf.append("Failure loooking up field ").append(this.metadata.getField());
                buf.append(" in class class ").append(clazz.getName()).append(". Assuming no such field.");
                logger.log(2, buf.toString(), cdfe);
            }
        }
        catch (SuitableMethodNotAccessibleException e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw new InvocationTargetException(throwable, "Unexpected problem trying to get field " + this.metadata.getField());
        }
        return null;
    }

    private Field validateField(Field f, SimpleLogger logger) {
        Class<?> fieldType = f.getType();
        Class<?> referenceType = ClassUtils.getClassFromComponentClassLoader(this.componentClass, this.metadata.getInterface(), logger);
        if (Modifier.isStatic(f.getModifiers())) {
            logger.log(1, "Field {0} in component {1} must not be static", new Object[]{this.metadata.getField(), this.componentClass}, null);
            this.valueType = ParamType.ignore;
            return f;
        }
        if (!this.metadata.isMultiple()) {
            if (fieldType.isAssignableFrom(referenceType)) {
                this.valueType = ParamType.serviceType;
            } else if (fieldType == ClassUtils.SERVICE_REFERENCE_CLASS) {
                this.valueType = ParamType.serviceReference;
            } else if (fieldType == ClassUtils.COMPONENTS_SERVICE_OBJECTS_CLASS) {
                this.valueType = ParamType.serviceObjects;
            } else if (fieldType == ClassUtils.MAP_CLASS) {
                this.valueType = ParamType.map;
            } else if (fieldType == ClassUtils.MAP_ENTRY_CLASS) {
                this.valueType = ParamType.tuple;
            } else {
                logger.log(1, "Field {0} in component {1} has unsupported type {2}", new Object[]{this.metadata.getField(), this.componentClass, fieldType.getName()}, null);
                this.valueType = ParamType.ignore;
            }
            if (!this.metadata.isStatic() && !Modifier.isVolatile(f.getModifiers())) {
                logger.log(1, "Field {0} in component {1} must be declared volatile to handle a dynamic reference", new Object[]{this.metadata.getField(), this.componentClass}, null);
                this.valueType = ParamType.ignore;
            }
            if (Modifier.isFinal(f.getModifiers())) {
                logger.log(1, "Field {0} in component {1} must not be declared as final", new Object[]{this.metadata.getField(), this.componentClass}, null);
                this.valueType = ParamType.ignore;
            }
        } else {
            if ("service".equals(this.metadata.getFieldCollectionType())) {
                this.valueType = ParamType.serviceType;
            } else if ("reference".equals(this.metadata.getFieldCollectionType())) {
                this.valueType = ParamType.serviceReference;
            } else if ("serviceobjects".equals(this.metadata.getFieldCollectionType())) {
                this.valueType = ParamType.serviceObjects;
            } else if ("properties".equals(this.metadata.getFieldCollectionType())) {
                this.valueType = ParamType.map;
            } else if ("tuple".equals(this.metadata.getFieldCollectionType())) {
                this.valueType = ParamType.tuple;
            }
            if (!ClassUtils.COLLECTION_CLASS.isAssignableFrom(fieldType)) {
                logger.log(1, "Field {0} in component {1} has unsupported type {2}", new Object[]{this.metadata.getField(), this.componentClass, fieldType.getName()}, null);
                this.valueType = ParamType.ignore;
            }
            if (this.metadata.isReplace()) {
                if (!this.metadata.isStatic() && !Modifier.isVolatile(f.getModifiers())) {
                    logger.log(1, "Field {0} in component {1} must be declared volatile to handle a dynamic reference", new Object[]{this.metadata.getField(), this.componentClass}, null);
                    this.valueType = ParamType.ignore;
                }
                if (fieldType != ClassUtils.LIST_CLASS && fieldType != ClassUtils.COLLECTION_CLASS) {
                    logger.log(1, "Field {0} in component {1} has unsupported type {2}. It must be one of java.util.Collection or java.util.List.", new Object[]{this.metadata.getField(), this.componentClass, fieldType.getName()}, null);
                    this.valueType = ParamType.ignore;
                }
                if (Modifier.isFinal(f.getModifiers())) {
                    logger.log(1, "Field {0} in component {1} must not be declared as final", new Object[]{this.metadata.getField(), this.componentClass}, null);
                    this.valueType = ParamType.ignore;
                }
            }
        }
        if (this.metadata.isStatic() && !this.metadata.isReplace()) {
            logger.log(1, "Update strategy for field {0} in component {1} only allowed for non static field references.", new Object[]{this.metadata.getField(), this.componentClass}, null);
            this.valueType = ParamType.ignore;
        }
        return f;
    }

    private Object getValue(ComponentContextImpl key, RefPair<?, ?> refPair) {
        Object obj;
        switch (this.valueType) {
            case serviceType: {
                obj = refPair.getServiceObject(key);
                break;
            }
            case serviceReference: {
                obj = refPair.getRef();
                break;
            }
            case serviceObjects: {
                obj = key.getComponentServiceObjectsHelper().getServiceObjects(refPair.getRef());
                break;
            }
            case map: {
                obj = new ReadOnlyDictionary(refPair.getRef());
                break;
            }
            case tuple: {
                ReadOnlyDictionary tupleKey = new ReadOnlyDictionary(refPair.getRef());
                Object tupleValue = refPair.getServiceObject(key);
                obj = new MapEntryImpl(tupleKey, tupleValue, refPair.getRef());
                break;
            }
            default: {
                obj = null;
            }
        }
        return obj;
    }

    private boolean initField(Object componentInstance, SimpleLogger logger) {
        if (this.valueType == ParamType.ignore) {
            return true;
        }
        try {
            if (this.metadata.isMultiple()) {
                if (this.metadata.isReplace()) {
                    this.setFieldValue(componentInstance, new CopyOnWriteArrayList());
                } else {
                    Class<?> fieldType = this.field.getType();
                    Object providedImpl = this.getFieldValue(componentInstance);
                    if (providedImpl == null) {
                        if (Modifier.isFinal(this.field.getModifiers())) {
                            logger.log(1, "Field {0} in component {1} must not be declared as final", new Object[]{this.metadata.getField(), this.componentClass}, null);
                            this.valueType = ParamType.ignore;
                            return true;
                        }
                        if (fieldType != ClassUtils.LIST_CLASS && fieldType != ClassUtils.COLLECTION_CLASS) {
                            logger.log(1, "Field {0} in component {1} has unsupported type {2}. It must be one of java.util.Collection or java.util.List.", new Object[]{this.metadata.getField(), this.componentClass, fieldType.getName()}, null);
                            this.valueType = ParamType.ignore;
                            return true;
                        }
                        if (fieldType == ClassUtils.LIST_CLASS) {
                            this.setFieldValue(componentInstance, new CopyOnWriteArrayList());
                        } else {
                            this.setFieldValue(componentInstance, new CopyOnWriteArraySet());
                        }
                    }
                }
            } else if (this.metadata.isOptional()) {
                this.setFieldValue(componentInstance, null);
            }
        }
        catch (InvocationTargetException ite) {
            this.valueType = ParamType.ignore;
            logger.log(1, "Field {0} in component {1} can't be initialized.", new Object[]{this.metadata.getField(), this.componentClass}, ite);
            return false;
        }
        return true;
    }

    private Collection<Object> getReplaceCollection(BindParameters bp) {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (Object val : bp.getComponentContext().getBoundValues(this.metadata.getName()).values()) {
            objects.add(val);
        }
        return objects;
    }

    private MethodResult updateField(METHOD_TYPE mType, Object componentInstance, BindParameters bp, SimpleLogger logger) throws InvocationTargetException {
        ComponentContextImpl<?> key = bp.getComponentContext();
        RefPair<?, ?> refPair = bp.getRefPair();
        if (!this.metadata.isMultiple()) {
            if (mType == METHOD_TYPE.UNBIND) {
                if (this.metadata.isOptional() && !this.metadata.isStatic() && bp.getComponentContext().getBoundValues(this.metadata.getName()).size() == 1) {
                    this.setFieldValue(componentInstance, null);
                }
                bp.getComponentContext().getBoundValues(this.metadata.getName()).remove(refPair);
            } else if (mType == METHOD_TYPE.UPDATED) {
                if (this.valueType == ParamType.map || this.valueType == ParamType.tuple) {
                    if (this.metadata.isStatic()) {
                        return MethodResult.REACTIVATE;
                    }
                    Object obj = this.getValue(key, refPair);
                    this.setFieldValue(componentInstance, obj);
                    bp.getComponentContext().getBoundValues(this.metadata.getName()).put(refPair, obj);
                }
            } else {
                Object obj = this.getValue(key, refPair);
                this.setFieldValue(componentInstance, obj);
                bp.getComponentContext().getBoundValues(this.metadata.getName()).put(refPair, obj);
            }
        } else if (mType == METHOD_TYPE.BIND) {
            Object obj = this.getValue(key, refPair);
            bp.getComponentContext().getBoundValues(this.metadata.getName()).put(refPair, obj);
            if (this.metadata.isReplace()) {
                this.setFieldValue(componentInstance, this.getReplaceCollection(bp));
            } else {
                Collection col = (Collection)this.getFieldValue(componentInstance);
                col.add(obj);
            }
        } else if (mType == METHOD_TYPE.UNBIND) {
            if (!this.metadata.isStatic()) {
                Object obj = bp.getComponentContext().getBoundValues(this.metadata.getName()).remove(refPair);
                if (this.metadata.isReplace()) {
                    this.setFieldValue(componentInstance, this.getReplaceCollection(bp));
                } else {
                    Collection col = (Collection)this.getFieldValue(componentInstance);
                    col.remove(obj);
                }
            }
        } else if (mType == METHOD_TYPE.UPDATED && (this.valueType == ParamType.map || this.valueType == ParamType.tuple)) {
            if (!this.metadata.isStatic()) {
                Object obj = this.getValue(key, refPair);
                Object oldObj = bp.getComponentContext().getBoundValues(this.metadata.getName()).put(refPair, obj);
                if (this.metadata.isReplace()) {
                    this.setFieldValue(componentInstance, this.getReplaceCollection(bp));
                } else {
                    Collection col = (Collection)this.getFieldValue(componentInstance);
                    col.add(obj);
                    col.remove(oldObj);
                }
            } else {
                return MethodResult.REACTIVATE;
            }
        }
        return MethodResult.VOID;
    }

    private void setFieldValue(Object componentInstance, Object value) throws InvocationTargetException {
        try {
            this.field.set(componentInstance, value);
        }
        catch (IllegalArgumentException iae) {
            throw new InvocationTargetException(iae);
        }
        catch (IllegalAccessException iae) {
            throw new InvocationTargetException(iae);
        }
    }

    private Object getFieldValue(Object componentInstance) throws InvocationTargetException {
        try {
            return this.field.get(componentInstance);
        }
        catch (IllegalArgumentException iae) {
            throw new InvocationTargetException(iae);
        }
        catch (IllegalAccessException iae) {
            throw new InvocationTargetException(iae);
        }
    }

    private static boolean accept(Field field, boolean acceptPrivate, boolean acceptPackage) {
        int mod = field.getModifiers();
        if (Modifier.isStatic(mod)) {
            return true;
        }
        if (Modifier.isPublic(mod) || Modifier.isProtected(mod)) {
            FieldHandler.setAccessible(field);
            return true;
        }
        if (Modifier.isPrivate(mod)) {
            if (acceptPrivate) {
                FieldHandler.setAccessible(field);
                return true;
            }
            return false;
        }
        if (acceptPackage) {
            FieldHandler.setAccessible(field);
            return true;
        }
        return false;
    }

    private static void setAccessible(final Field field) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                field.setAccessible(true);
                return null;
            }
        });
    }

    public static String getPackageName(Class<?> clazz) {
        String name = clazz.getName();
        int dot = name.lastIndexOf(46);
        return dot > 0 ? name.substring(0, dot) : "";
    }

    public boolean fieldExists(SimpleLogger logger) {
        return this.state.fieldExists(this, logger);
    }

    public ReferenceMethod getBind() {
        return new ReferenceMethodImpl(METHOD_TYPE.BIND, this);
    }

    public ReferenceMethod getUnbind() {
        return new ReferenceMethodImpl(METHOD_TYPE.UNBIND, this);
    }

    public ReferenceMethod getUpdated() {
        return new ReferenceMethodImpl(METHOD_TYPE.UPDATED, this);
    }

    public InitReferenceMethod getInit() {
        if (this.valueType == ParamType.ignore) {
            return null;
        }
        return new InitReferenceMethod(){

            @Override
            public boolean init(Object componentInstance, SimpleLogger logger) {
                if (FieldHandler.this.fieldExists(logger)) {
                    return FieldHandler.this.initField(componentInstance, logger);
                }
                return false;
            }
        };
    }

    public static final class ReferenceMethodImpl
    implements ReferenceMethod {
        private final METHOD_TYPE methodType;
        private final FieldHandler handler;

        public ReferenceMethodImpl(METHOD_TYPE mt, FieldHandler handler) {
            this.methodType = mt;
            this.handler = handler;
        }

        @Override
        public MethodResult invoke(Object componentInstance, ComponentContextImpl<?> componentContext, RefPair<?, ?> refPair, MethodResult methodCallFailureResult, SimpleLogger logger) {
            return this.invoke(componentInstance, new BindParameters(componentContext, refPair), methodCallFailureResult, logger);
        }

        public MethodResult invoke(Object componentInstance, BindParameters rawParameter, MethodResult methodCallFailureResult, SimpleLogger logger) {
            if (this.handler.valueType == ParamType.ignore) {
                return MethodResult.VOID;
            }
            try {
                return this.handler.state.invoke(this.handler, this.methodType, componentInstance, rawParameter, logger);
            }
            catch (InvocationTargetException ite) {
                logger.log(1, "The {0} field has thrown an exception", new Object[]{this.handler.metadata.getField()}, ite.getCause());
                return methodCallFailureResult;
            }
        }

        @Override
        public <S, T> boolean getServiceObject(ComponentContextImpl<S> key, RefPair<S, T> refPair, BundleContext context, SimpleLogger logger) {
            if (this.methodType != METHOD_TYPE.UNBIND && refPair.getServiceObject(key) == null && this.handler.fieldExists(logger) && (this.handler.valueType == ParamType.serviceType || this.handler.valueType == ParamType.tuple)) {
                return refPair.getServiceObject(key, context, logger);
            }
            return true;
        }
    }

    private static class Resolved
    implements State {
        private static final State INSTANCE = new Resolved();

        private Resolved() {
        }

        @Override
        public MethodResult invoke(FieldHandler handler, METHOD_TYPE mType, Object componentInstance, BindParameters rawParameter, SimpleLogger logger) throws InvocationTargetException {
            return handler.updateField(mType, componentInstance, rawParameter, logger);
        }

        @Override
        public boolean fieldExists(FieldHandler handler, SimpleLogger logger) {
            return true;
        }
    }

    private static class NotFound
    implements State {
        private static final State INSTANCE = new NotFound();

        private NotFound() {
        }

        @Override
        public MethodResult invoke(FieldHandler handler, METHOD_TYPE mType, Object componentInstance, BindParameters rawParameter, SimpleLogger logger) {
            logger.log(1, "Field [{0}] not found", new Object[]{handler.metadata.getField()}, null);
            return null;
        }

        @Override
        public boolean fieldExists(FieldHandler handler, SimpleLogger logger) {
            return false;
        }
    }

    private static class NotResolved
    implements State {
        private static final State INSTANCE = new NotResolved();

        private NotResolved() {
        }

        private synchronized void resolve(FieldHandler handler, SimpleLogger logger) {
            logger.log(4, "getting field: {0}", new Object[]{handler.metadata.getField()}, null);
            Field field = null;
            try {
                field = handler.findField(logger);
                field = handler.validateField(field, logger);
            }
            catch (InvocationTargetException ex) {
                logger.log(2, "{0} cannot be found", new Object[]{handler.metadata.getField()}, ex.getTargetException());
                field = null;
            }
            handler.setField(field, logger);
        }

        @Override
        public MethodResult invoke(FieldHandler handler, METHOD_TYPE mType, Object componentInstance, BindParameters rawParameter, SimpleLogger logger) throws InvocationTargetException {
            this.resolve(handler, logger);
            return handler.state.invoke(handler, mType, componentInstance, rawParameter, logger);
        }

        @Override
        public boolean fieldExists(FieldHandler handler, SimpleLogger logger) {
            this.resolve(handler, logger);
            return handler.state.fieldExists(handler, logger);
        }
    }

    private static interface State {
        public MethodResult invoke(FieldHandler var1, METHOD_TYPE var2, Object var3, BindParameters var4, SimpleLogger var5) throws InvocationTargetException;

        public boolean fieldExists(FieldHandler var1, SimpleLogger var2);
    }

    private final class MapEntryImpl
    implements Map.Entry,
    Comparable<Map.Entry<?, ?>> {
        private final Object key;
        private final Object value;
        private final ServiceReference<?> ref;

        public MapEntryImpl(Object key, Object value, ServiceReference<?> ref) {
            this.key = key;
            this.value = value;
            this.ref = ref;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int compareTo(Map.Entry<?, ?> o) {
            if (o == null) {
                return 1;
            }
            if (o instanceof MapEntryImpl) {
                MapEntryImpl other = (MapEntryImpl)o;
                return this.ref.compareTo(other.ref);
            }
            return new Integer(this.hashCode()).compareTo(o.hashCode());
        }
    }

    private static enum METHOD_TYPE {
        BIND,
        UNBIND,
        UPDATED;

    }

    private static enum ParamType {
        serviceReference,
        serviceObjects,
        serviceType,
        map,
        tuple,
        ignore;

    }
}

