/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines.vanilla;

import org.jquantlib.exercise.Exercise;
import org.jquantlib.instruments.Payoff;
import org.jquantlib.instruments.StrikedTypePayoff;
import org.jquantlib.math.UnaryFunctionDouble;
import org.jquantlib.math.integrals.SegmentIntegral;
import org.jquantlib.pricingengines.OneAssetStrikedOptionEngine;
import org.jquantlib.pricingengines.arguments.OneAssetOptionArguments;
import org.jquantlib.pricingengines.results.OneAssetOptionResults;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;

public class IntegralEngine
extends OneAssetStrikedOptionEngine {
    @Override
    public void calculate() {
        if (((OneAssetOptionArguments)this.arguments).exercise.type() != Exercise.Type.EUROPEAN) {
            throw new ArithmeticException("not a Euroepan Option");
        }
        if (!(((OneAssetOptionArguments)this.arguments).payoff instanceof StrikedTypePayoff)) {
            throw new ArithmeticException("non-striked payoff given");
        }
        StrikedTypePayoff payoff = (StrikedTypePayoff)((OneAssetOptionArguments)this.arguments).payoff;
        if (!(((OneAssetOptionArguments)this.arguments).stochasticProcess instanceof GeneralizedBlackScholesProcess)) {
            throw new ArithmeticException("Black-Scholes process required");
        }
        GeneralizedBlackScholesProcess process = (GeneralizedBlackScholesProcess)((OneAssetOptionArguments)this.arguments).stochasticProcess;
        double variance = process.blackVolatility().getLink().blackVariance(((OneAssetOptionArguments)this.arguments).exercise.lastDate(), payoff.strike());
        double dividendDiscount = process.dividendYield().getLink().discount(((OneAssetOptionArguments)this.arguments).exercise.lastDate());
        double riskFreeDiscount = process.riskFreeRate().getLink().discount(((OneAssetOptionArguments)this.arguments).exercise.lastDate());
        double drift = Math.log(dividendDiscount / riskFreeDiscount) - 0.5 * variance;
        Integrand f = new Integrand(((OneAssetOptionArguments)this.arguments).payoff, process.stateVariable().getLink().evaluate(), drift, variance);
        SegmentIntegral integrator = new SegmentIntegral(5000);
        double infinity = 10.0 * Math.sqrt(variance);
        ((OneAssetOptionResults)this.results).value = process.riskFreeRate().getLink().discount(((OneAssetOptionArguments)this.arguments).exercise.lastDate()) / Math.sqrt(Math.PI * 2 * variance) * integrator.evaluate(f, drift - infinity, drift + infinity);
    }

    private static class Integrand
    implements UnaryFunctionDouble {
        private Payoff payoff_;
        private double s0_;
        private double drift_;
        double variance_;

        public Integrand(Payoff payoff, double s0, double drift, double variance) {
            this.payoff_ = payoff;
            this.s0_ = s0;
            this.drift_ = drift;
            this.variance_ = variance;
        }

        @Override
        public double evaluate(double x) {
            double temp = this.s0_ * Math.exp(x);
            double result = this.payoff_.valueOf(temp);
            return result * Math.exp(-(x - this.drift_) * (x - this.drift_) / (2.0 * this.variance_));
        }
    }
}

