/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.examples;

import org.jquantlib.Configuration;
import org.jquantlib.daycounters.Actual365Fixed;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.exercise.AmericanExercise;
import org.jquantlib.exercise.EuropeanExercise;
import org.jquantlib.instruments.EuropeanOption;
import org.jquantlib.instruments.Option;
import org.jquantlib.instruments.PlainVanillaPayoff;
import org.jquantlib.instruments.VanillaOption;
import org.jquantlib.methods.lattices.AdditiveEQPBinomialTree;
import org.jquantlib.methods.lattices.CoxRossRubinstein;
import org.jquantlib.methods.lattices.JarrowRudd;
import org.jquantlib.methods.lattices.Joshi4;
import org.jquantlib.methods.lattices.LeisenReimer;
import org.jquantlib.methods.lattices.Tian;
import org.jquantlib.methods.lattices.Trigeorgis;
import org.jquantlib.pricingengines.AnalyticEuropeanEngine;
import org.jquantlib.pricingengines.vanilla.BaroneAdesiWhaleyApproximationEngine;
import org.jquantlib.pricingengines.vanilla.BinomialVanillaEngine;
import org.jquantlib.pricingengines.vanilla.BjerksundStenslandApproximationEngine;
import org.jquantlib.pricingengines.vanilla.IntegralEngine;
import org.jquantlib.pricingengines.vanilla.JuQuadraticApproximationEngine;
import org.jquantlib.pricingengines.vanilla.finitedifferences.FDAmericanEngine;
import org.jquantlib.pricingengines.vanilla.finitedifferences.FDEuropeanEngine;
import org.jquantlib.processes.BlackScholesMertonProcess;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.SimpleQuote;
import org.jquantlib.termstructures.BlackVolTermStructure;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.termstructures.volatilities.BlackConstantVol;
import org.jquantlib.termstructures.yieldcurves.FlatForward;
import org.jquantlib.util.Date;
import org.jquantlib.util.DateFactory;
import org.jquantlib.util.Month;
import org.jquantlib.util.StopClock;

public class EquityOptions {
    public static void main(String[] args) {
        System.out.println("\n\n::::: " + EquityOptions.class.getSimpleName() + " :::::");
        StopClock clock = new StopClock();
        clock.startClock();
        Option.Type type = Option.Type.PUT;
        double strike = 40.0;
        double underlying = 36.0;
        double riskFreeRate = 0.06;
        double volatility = 0.2;
        double dividendYield = 0.0;
        Date todaysDate = DateFactory.getFactory().getDate(15, Month.MAY, 1998);
        Date settlementDate = DateFactory.getFactory().getDate(17, Month.MAY, 1998);
        Configuration.getSystemConfiguration(null).getGlobalSettings().setEvaluationDate(todaysDate);
        Date maturity = DateFactory.getFactory().getDate(17, Month.MAY, 1999);
        Actual365Fixed dayCounter = Actual365Fixed.getDayCounter();
        System.out.println("                            Method      European      Bermudan      American");
        System.out.println("================================== ============= ============= =============");
        EuropeanExercise europeanExercise = new EuropeanExercise(maturity);
        AmericanExercise americanExercise = new AmericanExercise(settlementDate, maturity);
        Handle<SimpleQuote> underlyingH = new Handle<SimpleQuote>(new SimpleQuote(underlying));
        Handle<YieldTermStructure> flatDividendTS = new Handle<YieldTermStructure>(new FlatForward(settlementDate, dividendYield, (DayCounter)dayCounter));
        Handle<YieldTermStructure> flatTermStructure = new Handle<YieldTermStructure>(new FlatForward(settlementDate, riskFreeRate, (DayCounter)dayCounter));
        Handle<BlackVolTermStructure> flatVolTS = new Handle<BlackVolTermStructure>(new BlackConstantVol(settlementDate, volatility, (DayCounter)dayCounter));
        PlainVanillaPayoff payoff = new PlainVanillaPayoff(type, strike);
        BlackScholesMertonProcess stochasticProcess = new BlackScholesMertonProcess(underlyingH, flatDividendTS, flatTermStructure, flatVolTS);
        EuropeanOption europeanOption = new EuropeanOption(stochasticProcess, payoff, europeanExercise);
        VanillaOption americanOption = new VanillaOption(stochasticProcess, payoff, americanExercise, null);
        String fmt = "%34s %13.9f %13.9f %13.9f\n";
        String fmttbd = "%34s %13.9f %13.9f %13.9f  (TO BE DONE)\n";
        String method = "Black-Scholes";
        europeanOption.setPricingEngine(new AnalyticEuropeanEngine());
        System.out.printf(fmt, method, europeanOption.getNPV(), Double.NaN, Double.NaN);
        method = "Barone-Adesi/Whaley";
        americanOption.setPricingEngine(new BaroneAdesiWhaleyApproximationEngine());
        System.out.printf(fmt, method, Double.NaN, Double.NaN, americanOption.getNPV());
        method = "Bjerksund/Stensland";
        americanOption.setPricingEngine(new BjerksundStenslandApproximationEngine());
        System.out.printf(fmt, method, Double.NaN, Double.NaN, americanOption.getNPV());
        method = "Ju Quadratic";
        americanOption.setPricingEngine(new JuQuadraticApproximationEngine());
        System.out.printf(fmt, method, Double.NaN, Double.NaN, americanOption.getNPV());
        method = "Integral";
        europeanOption.setPricingEngine(new IntegralEngine());
        System.out.printf(fmt, method, europeanOption.getNPV(), Double.NaN, Double.NaN);
        int timeSteps = 801;
        method = "Finite differences";
        europeanOption.setPricingEngine(new FDEuropeanEngine(stochasticProcess, timeSteps, timeSteps - 1, false));
        americanOption.setPricingEngine(new FDAmericanEngine(stochasticProcess, timeSteps, timeSteps - 1, false));
        System.out.printf(fmt, method, europeanOption.getNPV(), Double.NaN, americanOption.getNPV());
        method = "Binomial Jarrow-Rudd";
        europeanOption.setPricingEngine(new BinomialVanillaEngine<JarrowRudd>(timeSteps){});
        americanOption.setPricingEngine(new BinomialVanillaEngine<JarrowRudd>(timeSteps){});
        System.out.printf(fmt, method, europeanOption.getNPV(), Double.NaN, americanOption.getNPV());
        method = "Binomial Cox-Ross-Rubinstein";
        europeanOption.setPricingEngine(new BinomialVanillaEngine<CoxRossRubinstein>(timeSteps){});
        americanOption.setPricingEngine(new BinomialVanillaEngine<CoxRossRubinstein>(timeSteps){});
        System.out.printf(fmt, method, europeanOption.getNPV(), Double.NaN, americanOption.getNPV());
        method = "Additive equiprobabilities";
        europeanOption.setPricingEngine(new BinomialVanillaEngine<AdditiveEQPBinomialTree>(timeSteps){});
        americanOption.setPricingEngine(new BinomialVanillaEngine<AdditiveEQPBinomialTree>(timeSteps){});
        System.out.printf(fmt, method, europeanOption.getNPV(), Double.NaN, americanOption.getNPV());
        method = "Binomial Trigeorgis";
        europeanOption.setPricingEngine(new BinomialVanillaEngine<Trigeorgis>(timeSteps){});
        americanOption.setPricingEngine(new BinomialVanillaEngine<Trigeorgis>(timeSteps){});
        System.out.printf(fmt, method, europeanOption.getNPV(), Double.NaN, americanOption.getNPV());
        method = "Binomial Tian";
        europeanOption.setPricingEngine(new BinomialVanillaEngine<Tian>(timeSteps){});
        americanOption.setPricingEngine(new BinomialVanillaEngine<Tian>(timeSteps){});
        System.out.printf(fmt, method, europeanOption.getNPV(), Double.NaN, americanOption.getNPV());
        method = "Binomial Leisen-Reimer";
        europeanOption.setPricingEngine(new BinomialVanillaEngine<LeisenReimer>(timeSteps){});
        americanOption.setPricingEngine(new BinomialVanillaEngine<LeisenReimer>(timeSteps){});
        System.out.printf(fmt, method, europeanOption.getNPV(), Double.NaN, americanOption.getNPV());
        method = "Binomial Joshi";
        europeanOption.setPricingEngine(new BinomialVanillaEngine<Joshi4>(timeSteps){});
        americanOption.setPricingEngine(new BinomialVanillaEngine<Joshi4>(timeSteps){});
        System.out.printf(fmt, method, europeanOption.getNPV(), Double.NaN, americanOption.getNPV());
        timeSteps = 1;
        int mcSeed = 42;
        int nSamples = 32768;
        int maxSamples = 0x100000;
        method = "Monte Carlo (crude)";
        System.out.printf(fmttbd, method, Double.NaN, Double.NaN, Double.NaN);
        method = "Monte Carlo (Sobol)";
        System.out.printf(fmttbd, method, Double.NaN, Double.NaN, Double.NaN);
        method = "Monte Carlo (Longstaff Schwartz)";
        System.out.printf(fmttbd, method, Double.NaN, Double.NaN, Double.NaN);
        clock.stopClock();
        clock.log();
    }
}

