/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.util;

import org.jquantlib.time.Weekday;
import org.jquantlib.util.Date;
import org.jquantlib.util.DefaultDate;
import org.jquantlib.util.Month;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DateFactory {
    private static final Logger logger = LoggerFactory.getLogger(DateFactory.class);
    private static DateFactory dateFactory;
    private static final DateFactory DEFAULT_DATE_UTIL;

    public static void setFactory(DateFactory dateUtil) {
        if (dateFactory != null) {
            throw new IllegalStateException("Dateutil already set ");
        }
        dateFactory = dateUtil;
    }

    public static DateFactory getFactory() {
        if (dateFactory == null) {
            return DEFAULT_DATE_UTIL;
        }
        return dateFactory;
    }

    public Date getMaxDate() {
        return dateFactory.getMaxDate();
    }

    public Date getMinDate() {
        return dateFactory.getMinDate();
    }

    public Date getTodaysDate() {
        return dateFactory.getTodaysDate();
    }

    public Date getDate(int day, Month month, int year) {
        return dateFactory.getDate(day, month, year);
    }

    public Date getDate(int day, int month, int year) {
        return dateFactory.getDate(day, month, year);
    }

    public Date getNthWeekday(int nth, Weekday dayOfWeek, Month month, int year) {
        return dateFactory.getNthWeekday(nth, dayOfWeek, month, year);
    }

    public Date parseISO(String str) {
        return dateFactory.parseISO(str);
    }

    public Date parse(String str, String fmt) {
        return dateFactory.parse(str, fmt);
    }

    public boolean isLeap(int year) {
        return dateFactory.isLeap(year);
    }

    static {
        DEFAULT_DATE_UTIL = new DefaultDate.JQLibDateUtil();
    }
}

