/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.randomnumbers;

import org.jquantlib.math.randomnumbers.RandomNumberGenerator;
import org.jquantlib.math.randomnumbers.SeedGenerator;
import org.jquantlib.methods.montecarlo.Sample;

public class MersenneTwisterUniformRng
implements RandomNumberGenerator {
    private static final int N = 624;
    private static final int M = 397;
    private static final long MATRIX_A = -1727483681L;
    private static final long UPPER_MASK = Integer.MIN_VALUE;
    private static final long LOWER_MASK = Integer.MAX_VALUE;
    private static final long TEMPERING_MASK_B = -1658038656L;
    private static final long TEMPERING_MASK_C = -272236544L;
    private static final long[] mag01 = new long[]{0L, -1727483681L};
    private int mti;
    private long[] mt = new long[624];

    public MersenneTwisterUniformRng(long seed) {
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        this.seedInitialization(seed);
    }

    public MersenneTwisterUniformRng(long[] seeds) {
        int k;
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        this.seedInitialization(19650218L);
        int i = 1;
        int j = 0;
        for (k = Math.max(624, seeds.length); k != 0; --k) {
            this.mt[i] = (this.mt[i] ^ (this.mt[i - 1] ^ this.mt[i - 1] >>> 30) * 1664525L) + seeds[j] + (long)j;
            ++j;
            if (++i >= 624) {
                this.mt[0] = this.mt[623];
                i = 1;
            }
            if (j < seeds.length) continue;
            j = 0;
        }
        for (k = 623; k != 0; --k) {
            this.mt[i] = (this.mt[i] ^ (this.mt[i - 1] ^ this.mt[i - 1] >>> 30) * 1566083941L) - (long)i;
            if (++i < 624) continue;
            this.mt[0] = this.mt[623];
            i = 1;
        }
        this.mt[0] = Integer.MIN_VALUE;
    }

    @Override
    public long nextInt32() {
        long y;
        if (this.mti >= 624) {
            int kk;
            long mtNext = this.mt[0];
            for (kk = 0; kk < 227; ++kk) {
                y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + 397] ^ y >>> 1 ^ mag01[(int)y & 1];
            }
            for (kk = 624; kk < 623; ++kk) {
                y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + -227] ^ y >>> 1 ^ mag01[(int)y & 1];
            }
            y = mtNext & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ y >>> 1 ^ mag01[(int)y & 1];
            this.mti = 0;
        }
        y = this.mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0xFFFFFFFF9D2C5680L;
        y ^= y << 15 & 0xFFFFFFFFEFC60000L;
        y ^= y >>> 18;
        return y;
    }

    @Override
    public final Sample<Double> next() {
        double result = ((double)this.nextInt32() + 0.5) / 4.294967296E9;
        Sample<Double> sample_value = new Sample<Double>(result, 1.0);
        return sample_value;
    }

    private void seedInitialization(long seed) {
        long s = seed != 0L ? seed : SeedGenerator.getInstance().get();
        this.mt[0] = s & 0xFFFFFFFFFFFFFFFFL;
        this.mti = 1;
        while (this.mti < 624) {
            this.mt[this.mti] = 1812433253L * (this.mt[this.mti - 1] ^ this.mt[this.mti - 1] >> 30) + (long)this.mti;
            int n = this.mti++;
            this.mt[n] = this.mt[n] & 0xFFFFFFFFFFFFFFFFL;
        }
    }
}

