/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.wisp.engine;

import com.alibaba.wisp.engine.StealAwareRunnable;
import com.alibaba.wisp.engine.TaskDispatcher;
import com.alibaba.wisp.engine.ThreadAsWisp;
import com.alibaba.wisp.engine.TimeOut;
import com.alibaba.wisp.engine.WispCarrier;
import com.alibaba.wisp.engine.WispConfiguration;
import com.alibaba.wisp.engine.WispControlGroup;
import com.alibaba.wisp.engine.WispCounter;
import com.alibaba.wisp.engine.WispCounterMXBeanImpl;
import com.alibaba.wisp.engine.WispEventPump;
import com.alibaba.wisp.engine.WispPerfCounterMonitor;
import com.alibaba.wisp.engine.WispScheduler;
import com.alibaba.wisp.engine.WispSysmon;
import com.alibaba.wisp.engine.WispTask;
import com.alibaba.wisp.engine.WispThreadWrapper;
import java.dyn.Coroutine;
import java.dyn.CoroutineExitException;
import java.dyn.CoroutineSupport;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Supplier;
import sun.misc.JavaLangAccess;
import sun.misc.SharedSecrets;
import sun.misc.WispEngineAccess;
import sun.nio.ch.Net;

public class WispEngine
extends AbstractExecutorService {
    private static final String WISP_ROOT_ENGINE_NAME = "Root";
    private static final AtomicReferenceFieldUpdater<WispEngine, Boolean> SHUTDOWN_UPDATER;
    static boolean shiftThreadModel;
    static final JavaLangAccess JLA;
    static final ThreadGroup DAEMON_THREAD_GROUP;
    static ScheduledExecutorService timer;
    static Set<Thread> carrierThreads;
    static Thread unparkDispatcher;
    static WispEngine WISP_ROOT_ENGINE;
    final WispScheduler scheduler;
    final Set<WispCarrier> carrierEngines;
    final Queue<WispTask> groupTaskCache = new ConcurrentLinkedQueue<WispTask>();
    final CyclicBarrier shutdownBarrier;
    volatile int runningTaskCount = 0;
    private CountDownLatch shutdownFuture;
    volatile Boolean hasBeenShutdown = false;
    volatile boolean terminated;

    public static boolean transparentWispSwitch() {
        return WispConfiguration.TRANSPARENT_WISP_SWITCH;
    }

    public static boolean enableThreadAsWisp() {
        return shiftThreadModel;
    }

    @Deprecated
    public static boolean isTransparentAsync() {
        return WispEngine.transparentWispSwitch();
    }

    private static ScheduledExecutorService createTimerScheduler() {
        return !WispConfiguration.WISP_HIGH_PRECISION_TIMER ? null : Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(DAEMON_THREAD_GROUP, runnable);
                thread.setDaemon(true);
                thread.setName("Wisp-Timer");
                return thread;
            }
        });
    }

    private static void initializeWispClass() {
        assert (JLA != null) : "WispCarrier should be initialized after System";
        assert (JLA.currentThread0().getName().equals("main")) : "Wisp need to be loaded by main thread";
        shiftThreadModel = WispConfiguration.ENABLE_THREAD_AS_WISP;
        carrierThreads = new ConcurrentSkipListSet<Thread>(new Comparator<Thread>(){

            @Override
            public int compare(Thread thread, Thread thread2) {
                return Long.compare(thread.getId(), thread2.getId());
            }
        });
        WISP_ROOT_ENGINE = new WispEngine(WISP_ROOT_ENGINE_NAME);
        if (WispEngine.transparentWispSwitch()) {
            WispEngine.initializeClasses();
            JLA.wispBooted();
        }
    }

    private static void initializeClasses() {
        try {
            Class.forName(CoroutineExitException.class.getName());
            Class.forName(WispThreadWrapper.class.getName());
            Class.forName(TaskDispatcher.class.getName());
            Class.forName(StartShutdown.class.getName());
            Class.forName(Coroutine.StealResult.class.getName());
            Class.forName(WispCounterMXBeanImpl.class.getName());
            Class.forName(ThreadAsWisp.class.getName());
            Class.forName(WispEventPump.class.getName());
            Class.forName(ShutdownEngine.class.getName());
            Class.forName(AbstractShutdownTask.class.getName());
            Class.forName(ShutdownControlGroup.class.getName());
            if (WispConfiguration.WISP_PROFILE) {
                Class.forName(WispPerfCounterMonitor.class.getName());
            }
            if (WispConfiguration.WISP_HIGH_PRECISION_TIMER) {
                timer.submit(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
            }
            new ConcurrentLinkedQueue().iterator();
            new ConcurrentSkipListMap().keySet().iterator();
            WispCarrier wispCarrier = WispCarrier.current();
            wispCarrier.addTimer(System.nanoTime() + Integer.MAX_VALUE, TimeOut.Action.JDK_UNPARK);
            WispCarrier.current().current.timeOut.doAction();
            wispCarrier.cancelTimer();
            wispCarrier.createResumeEntry(new WispTask(wispCarrier, null, false, false));
            WispTask.wrapRunOutsideWisp(null);
            WispEngine.registerPerfCounter(wispCarrier);
            WispEngine.deRegisterPerfCounter(wispCarrier);
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
    }

    private static void startWispDaemons() {
        if (WispEngine.transparentWispSwitch()) {
            unparkDispatcher = new Thread(DAEMON_THREAD_GROUP, new Runnable(){

                @Override
                public void run() {
                    int[] nArray = new int[12];
                    CoroutineSupport.setWispBooted();
                    block0: while (true) {
                        int n = WispEngine.getProxyUnpark(nArray);
                        int n2 = 0;
                        while (true) {
                            if (n2 >= n) continue block0;
                            WispTask.unparkById(nArray[n2]);
                            ++n2;
                        }
                        break;
                    }
                }
            }, "Wisp-Unpark-Dispatcher");
            unparkDispatcher.setDaemon(true);
            unparkDispatcher.start();
            WispSysmon.INSTANCE.startDaemon();
            WispEngine.WISP_ROOT_ENGINE.scheduler.startWorkerThreads();
            if (!WispConfiguration.CARRIER_AS_POLLER) {
                WispEventPump.Pool.INSTANCE.startPollerThreads();
            }
            if (WispConfiguration.WISP_PROFILE_LOG_ENABLED) {
                WispPerfCounterMonitor.INSTANCE.startDaemon();
            }
        }
    }

    private static void setWispEngineAccess() {
        SharedSecrets.setWispEngineAccess(new WispEngineAccess(){

            @Override
            public WispTask getCurrentTask() {
                return WispCarrier.current().getCurrentTask();
            }

            @Override
            public void registerEvent(SelectableChannel selectableChannel, int n) throws IOException {
                WispCarrier.current().registerEvent(selectableChannel, n);
            }

            @Override
            public void unregisterEvent() {
                WispCarrier.current().unregisterEvent();
            }

            @Override
            public int epollWait(int n, long l, int n2, long l2, AtomicReference<Object> atomicReference, Object object) throws IOException {
                return WispEventPump.Pool.INSTANCE.epollWaitForWisp(n, l, n2, l2, atomicReference, object);
            }

            @Override
            public void interruptEpoll(AtomicReference<Object> atomicReference, Object object, int n) {
                WispEventPump.Pool.INSTANCE.interruptEpoll(atomicReference, object, n);
            }

            @Override
            public void addTimer(long l) {
                WispCarrier.current().addTimer(l, TimeOut.Action.JDK_UNPARK);
            }

            @Override
            public void cancelTimer() {
                WispCarrier.current().cancelTimer();
            }

            @Override
            public void sleep(long l) {
                WispTask.sleep(l);
            }

            @Override
            public void yield() {
                WispCarrier.current().yield();
            }

            @Override
            public boolean isThreadTask(WispTask wispTask) {
                return wispTask.isThreadTask();
            }

            @Override
            public boolean isTimeout() {
                WispTask wispTask = WispCarrier.current().current;
                return wispTask.timeOut != null && wispTask.timeOut.expired();
            }

            @Override
            public void park(long l) {
                WispTask.jdkPark(l);
            }

            @Override
            public void unpark(WispTask wispTask) {
                if (wispTask != null) {
                    wispTask.jdkUnpark();
                }
            }

            @Override
            public void destroy() {
                WispCarrier.current().destroy();
            }

            @Override
            public boolean hasMoreTasks() {
                return WispCarrier.current().getTaskQueueLength() > 0;
            }

            @Override
            public boolean runningAsCoroutine(Thread thread) {
                return WispEngine.runningAsCoroutine(thread);
            }

            @Override
            public boolean usingWispEpoll() {
                return this.runningAsCoroutine(null);
            }

            @Override
            public boolean isAlive(WispTask wispTask) {
                return wispTask.isAlive();
            }

            @Override
            public void interrupt(WispTask wispTask) {
                wispTask.interrupt();
            }

            @Override
            public boolean testInterruptedAndClear(WispTask wispTask, boolean bl) {
                return wispTask.testInterruptedAndClear(bl);
            }

            @Override
            public boolean tryStartThreadAsWisp(Thread thread, Runnable runnable, long l) {
                return ThreadAsWisp.tryStart(thread, runnable, l == 0L ? (long)WispConfiguration.STACK_SIZE : l);
            }

            @Override
            public boolean isAllThreadAsWisp() {
                return WispConfiguration.ALL_THREAD_AS_WISP;
            }

            @Override
            public boolean useDirectSelectorWakeup() {
                return WispConfiguration.USE_DIRECT_SELECTOR_WAKEUP;
            }

            @Override
            public boolean enableSocketLock() {
                return WispConfiguration.WISP_ENABLE_SOCKET_LOCK;
            }

            @Override
            public StackTraceElement[] getStackTrace(WispTask wispTask) {
                return wispTask.getStackTrace();
            }

            @Override
            public void getCpuTime(long[] lArray, long[] lArray2) {
                WispTask wispTask = WispCarrier.current().getCurrentTask();
                assert (wispTask.getThreadWrapper() != null);
                for (int i = 0; i < lArray.length; ++i) {
                    if (lArray[i] == wispTask.getThreadWrapper().getId()) {
                        lArray2[i] = wispTask.getCpuTime();
                        continue;
                    }
                    for (WispTask wispTask2 : WispTask.id2Task.values()) {
                        Thread thread = wispTask2.getThreadWrapper();
                        if (thread == null || thread.getId() != lArray[i]) continue;
                        lArray2[i] = wispTask2.getCpuTime();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int poll(SelectableChannel selectableChannel, int n, long l) throws IOException {
                assert (n == Net.POLLIN || n == Net.POLLCONN || n == Net.POLLOUT);
                WispTask wispTask = WispCarrier.current().getCurrentTask();
                if (l > 0L) {
                    wispTask.carrier.addTimer(System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(l), TimeOut.Action.JDK_UNPARK);
                }
                try {
                    wispTask.carrier.registerEvent(selectableChannel, this.translateToSelectionKey(n));
                    this.park(-1L);
                    int n2 = l > 0L && wispTask.timeOut.expired() ? 0 : 1;
                    return n2;
                }
                finally {
                    if (l > 0L) {
                        wispTask.carrier.cancelTimer();
                    }
                    this.unregisterEvent();
                }
            }

            private int translateToSelectionKey(int n) {
                if (Net.POLLIN == n) {
                    return 1;
                }
                if (Net.POLLCONN == n) {
                    return 8;
                }
                if (Net.POLLOUT == n) {
                    return 4;
                }
                return 0;
            }
        });
    }

    public static WispEngine createEngine(int n, ThreadFactory threadFactory) {
        return new WispEngine(n, threadFactory);
    }

    private WispEngine(final String string) {
        this.carrierEngines = new ConcurrentSkipListSet<WispCarrier>();
        this.shutdownBarrier = null;
        this.scheduler = new WispScheduler(WispConfiguration.WORKER_COUNT, WispConfiguration.WISP_SCHEDULE_STEAL_RETRY, WispConfiguration.WISP_SCHEDULE_PUSH_RETRY, WispConfiguration.WISP_SCHEDULE_HELP_STEAL_RETRY, new ThreadFactory(){
            final AtomicInteger seq = new AtomicInteger();

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, "Wisp-" + string + "-Worker-" + this.seq.getAndIncrement());
                thread.setDaemon(true);
                return thread;
            }
        }, this, true);
    }

    private WispEngine(int n, ThreadFactory threadFactory) {
        this.carrierEngines = new ConcurrentSkipListSet<WispCarrier>();
        this.shutdownBarrier = new CyclicBarrier(n);
        this.scheduler = new WispScheduler(n, threadFactory, this);
        this.shutdownFuture = new CountDownLatch(1);
    }

    public static WispEngine current() {
        return WispCarrier.current().engine;
    }

    public static void dispatch(Runnable runnable) {
        WispEngine.current().execute(runnable);
    }

    @Deprecated
    public static boolean isShiftThreadModel() {
        return shiftThreadModel;
    }

    static boolean isEngineThread(Thread thread) {
        assert (DAEMON_THREAD_GROUP != null);
        return DAEMON_THREAD_GROUP == thread.getThreadGroup() || carrierThreads.contains(thread);
    }

    static long getNanoTime() {
        return WispConfiguration.WISP_PROFILE ? System.nanoTime() : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T runInCritical(Supplier<T> supplier) {
        WispCarrier wispCarrier = WispCarrier.current();
        boolean bl = wispCarrier.isInCritical;
        wispCarrier.isInCritical = true;
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            wispCarrier.isInCritical = bl;
        }
    }

    static boolean runningAsCoroutine(Thread thread) {
        WispTask wispTask;
        WispTask wispTask2 = wispTask = thread == null ? WispCarrier.current().getCurrentTask() : JLA.getWispTask(thread);
        assert (wispTask != null);
        return !wispTask.isThreadTask();
    }

    static WispCounter getWispCounter(long l) {
        return WispConfiguration.WISP_PROFILE ? WispPerfCounterMonitor.INSTANCE.getWispCounter(l) : null;
    }

    @Override
    public void shutdown() {
        if (!SHUTDOWN_UPDATER.compareAndSet(this, false, true)) {
            return;
        }
        for (WispCarrier wispCarrier : this.carrierEngines) {
            WispEngine.deRegisterPerfCounter(wispCarrier);
        }
        this.scheduler.execute(new StartShutdown(null));
    }

    void shutdown(WispControlGroup wispControlGroup) {
        this.scheduler.execute(new StartShutdown(wispControlGroup));
    }

    @Override
    public List<Runnable> shutdownNow() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<WispTask> getRunningTasks(WispControlGroup wispControlGroup) {
        assert ("SHUTDOWN_TASK".equals(WispCarrier.current().current.getName()));
        WispCarrier wispCarrier = WispCarrier.current();
        ArrayList<WispTask> arrayList = new ArrayList<WispTask>();
        boolean bl = wispCarrier.isInCritical;
        wispCarrier.isInCritical = true;
        try {
            for (WispTask wispTask : WispTask.id2Task.values()) {
                if (!wispTask.isAlive() || wispTask.carrier.engine != this || wispTask.isThreadTask() || wispTask.getName().equals("SHUTDOWN_TASK") || wispControlGroup != null && (!wispTask.inDestoryedGroup() || wispTask.controlGroup != wispControlGroup)) continue;
                arrayList.add(wispTask);
            }
            ArrayList<WispTask> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            wispCarrier.isInCritical = bl;
        }
    }

    @Override
    public boolean isShutdown() {
        return this.hasBeenShutdown;
    }

    @Override
    public boolean isTerminated() {
        return this.terminated;
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.shutdownFuture.await(l, timeUnit);
    }

    @Override
    public void execute(Runnable runnable) {
        this.startAsThread(runnable, "execute task", null, WispConfiguration.STACK_SIZE);
    }

    public List<Long> getWispCarrierIds() {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (WispCarrier wispCarrier : this.carrierEngines) {
            arrayList.add(wispCarrier.getId());
        }
        return arrayList;
    }

    static void registerPerfCounter(WispCarrier wispCarrier) {
        WispEngine.runInCritical(() -> {
            if (WispConfiguration.WISP_PROFILE) {
                WispPerfCounterMonitor.INSTANCE.register(wispCarrier.counter);
            }
            WispCounterMXBeanImpl.register(wispCarrier.counter);
            return null;
        });
    }

    static void deRegisterPerfCounter(WispCarrier wispCarrier) {
        WispEngine.runInCritical(() -> {
            if (WispConfiguration.WISP_PROFILE) {
                WispPerfCounterMonitor.INSTANCE.deRegister(wispCarrier.counter);
            }
            WispCounterMXBeanImpl.deRegister(wispCarrier.counter);
            return null;
        });
    }

    void startAsThread(Runnable runnable, String string, Thread thread, long l) {
        this.scheduler.execute(new TaskDispatcher(WispCarrier.current().current.ctxClassLoader, runnable, string, thread, l));
    }

    private static native void registerNatives();

    private static native int getProxyUnpark(int[] var0);

    static {
        WispEngine.registerNatives();
        WispEngine.setWispEngineAccess();
        timer = WispEngine.createTimerScheduler();
        SHUTDOWN_UPDATER = AtomicReferenceFieldUpdater.newUpdater(WispEngine.class, Boolean.class, "hasBeenShutdown");
        shiftThreadModel = WispConfiguration.ENABLE_THREAD_AS_WISP;
        JLA = SharedSecrets.getJavaLangAccess();
        DAEMON_THREAD_GROUP = new ThreadGroup(JLA.currentThread0().getThreadGroup(), "Daemon Thread Group");
    }

    class ShutdownControlGroup
    extends AbstractShutdownTask {
        private final WispControlGroup wispControlGroup;

        ShutdownControlGroup(WispControlGroup wispControlGroup) {
            this.wispControlGroup = wispControlGroup;
        }

        @Override
        List<WispTask> getTasksForShutdown() {
            return WispEngine.this.getRunningTasks(this.wispControlGroup);
        }

        @Override
        void finishShutdown() {
            this.wispControlGroup.destroyLatch.countDown();
        }
    }

    class ShutdownEngine
    extends AbstractShutdownTask {
        ShutdownEngine() {
        }

        @Override
        List<WispTask> getTasksForShutdown() {
            return WispEngine.this.getRunningTasks(null);
        }

        @Override
        void finishShutdown() {
            assert ("SHUTDOWN_TASK".equals(WispCarrier.current().current.getName()));
            WispEngine.this.terminated = true;
            for (WispCarrier wispCarrier : WispEngine.this.carrierEngines) {
                wispCarrier.worker.signal();
            }
            WispEngine.this.shutdownFuture.countDown();
        }
    }

    abstract class AbstractShutdownTask
    implements StealAwareRunnable {
        AbstractShutdownTask() {
        }

        @Override
        public void run() {
            List<WispTask> list;
            do {
                list = this.getTasksForShutdown();
                for (WispTask wispTask : list) {
                    if (!wispTask.isAlive()) continue;
                    wispTask.jdkUnpark();
                    wispTask.unpark();
                }
                WispTask.jdkPark(TimeUnit.MILLISECONDS.toNanos(1L));
            } while (!list.isEmpty());
            this.finishShutdown();
        }

        abstract List<WispTask> getTasksForShutdown();

        abstract void finishShutdown();
    }

    class StartShutdown
    implements StealAwareRunnable {
        private final WispControlGroup wispControlGroup;

        StartShutdown(WispControlGroup wispControlGroup) {
            this.wispControlGroup = wispControlGroup;
        }

        @Override
        public void run() {
            WispCarrier.current().runTaskInternal(this.wispControlGroup == null ? new ShutdownEngine() : new ShutdownControlGroup(this.wispControlGroup), "SHUTDOWN_TASK", null, null, WispConfiguration.STACK_SIZE);
        }
    }
}

