/*
  Simple DirectMedia Layer
  Copyright (C) 1997-2022 Sam Lantinga <slouken@libsdl.org>

  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented; you must not
     claim that you wrote the original software. If you use this software
     in a product, an acknowledgment in the product documentation would be
     appreciated but is not required.
  2. Altered source versions must be plainly marked as such, and must not be
     misrepresented as being the original software.
  3. This notice may not be removed or altered from any source distribution.
*/

/* DO NOT EDIT, THIS FILE WAS GENERATED BY build-scripts/gen_audio_resampler_filter.c */

#define RESAMPLER_ZERO_CROSSINGS 5
#define RESAMPLER_BITS_PER_SAMPLE 16
#define RESAMPLER_SAMPLES_PER_ZERO_CROSSING (1 << ((RESAMPLER_BITS_PER_SAMPLE / 2) + 1))
#define RESAMPLER_FILTER_SIZE ((RESAMPLER_SAMPLES_PER_ZERO_CROSSING * RESAMPLER_ZERO_CROSSINGS) + 1)

static const float ResamplerFilter[RESAMPLER_FILTER_SIZE] = {
    1.000000000f, 0.999993682f, 0.999974370f, 0.999941289f, 0.999894559f,
    0.999834180f, 0.999760151f, 0.999672413f, 0.999571025f, 0.999455988f,
    0.999327302f, 0.999184966f, 0.999028981f, 0.998859286f, 0.998676121f,
    0.998479128f, 0.998268604f, 0.998044431f, 0.997806668f, 0.997555375f,
    0.997290313f, 0.997011721f, 0.996719599f, 0.996413827f, 0.996094406f,
    0.995761573f, 0.995415151f, 0.995055199f, 0.994681656f, 0.994294584f,
    0.993894041f, 0.993480027f, 0.993052363f, 0.992611289f, 0.992156804f,
    0.991688788f, 0.991207361f, 0.990712583f, 0.990204275f, 0.989682615f,
    0.989147604f, 0.988599122f, 0.988037288f, 0.987462223f, 0.986873686f,
    0.986271918f, 0.985656738f, 0.985028386f, 0.984386861f, 0.983731806f,
    0.983063757f, 0.982382476f, 0.981687963f, 0.980980217f, 0.980259418f,
    0.979525447f, 0.978778243f, 0.978018105f, 0.977244914f, 0.976458490f,
    0.975659251f, 0.974846840f, 0.974021494f, 0.973183155f, 0.972331941f,
    0.971467674f, 0.970590651f, 0.969700634f, 0.968797863f, 0.967882276f,
    0.966953754f, 0.966012537f, 0.965058565f, 0.964091897f, 0.963112533f,
    0.962120414f, 0.961115718f, 0.960098326f, 0.959068418f, 0.958025992f,
    0.956970990f, 0.955903471f, 0.954823375f, 0.953730941f, 0.952626109f,
    0.951508820f, 0.950379193f, 0.949237227f, 0.948082924f, 0.946916521f,
    0.945737660f, 0.944546640f, 0.943343520f, 0.942128360f, 0.940900803f,
    0.939661384f, 0.938409984f, 0.937146366f, 0.935870886f, 0.934583426f,
    0.933284163f, 0.931972861f, 0.930649877f, 0.929314911f, 0.927968264f,
    0.926609993f, 0.925239921f, 0.923858225f, 0.922464967f, 0.921060085f,
    0.919643581f, 0.918215632f, 0.916776240f, 0.915325403f, 0.913863063f,
    0.912389517f, 0.910904646f, 0.909408391f, 0.907901049f, 0.906382322f,
    0.904852629f, 0.903311789f, 0.901759744f, 0.900196850f, 0.898622811f,
    0.897037864f, 0.895442069f, 0.893835366f, 0.892217875f, 0.890589595f,
    0.888950586f, 0.887300909f, 0.885640502f, 0.883969545f, 0.882288039f,
    0.880595982f, 0.878893554f, 0.877180517f, 0.875457227f, 0.873723626f,
    0.871979713f, 0.870225549f, 0.868461132f, 0.866686642f, 0.864902079f,
    0.863107383f, 0.861302733f, 0.859488070f, 0.857663572f, 0.855829120f,
    0.853984952f, 0.852130949f, 0.850267172f, 0.848393857f, 0.846510828f,
    0.844618261f, 0.842716157f, 0.840804636f, 0.838883698f, 0.836953342f,
    0.835013688f, 0.833064795f, 0.831106603f, 0.829139292f, 0.827162862f,
    0.825177312f, 0.823182821f, 0.821179330f, 0.819167018f, 0.817145705f,
    0.815115690f, 0.813076973f, 0.811029494f, 0.808973312f, 0.806908667f,
    0.804835379f, 0.802753687f, 0.800663531f, 0.798565030f, 0.796458125f,
    0.794343054f, 0.792219698f, 0.790088236f, 0.787948668f, 0.785801113f,
    0.783645451f, 0.781481922f, 0.779310465f, 0.777131259f, 0.774944246f,
    0.772749543f, 0.770547271f, 0.768337309f, 0.766119778f, 0.763894856f,
    0.761662483f, 0.759422719f, 0.757175624f, 0.754921377f, 0.752659857f,
    0.750391185f, 0.748115480f, 0.745832801f, 0.743543088f, 0.741246462f,
    0.738943100f, 0.736632884f, 0.734315932f, 0.731992364f, 0.729662120f,
    0.727325320f, 0.724982083f, 0.722632408f, 0.720276356f, 0.717914045f,
    0.715545416f, 0.713170588f, 0.710789680f, 0.708402693f, 0.706009746f,
    0.703610778f, 0.701205969f, 0.698795319f, 0.696378946f, 0.693956852f,
    0.691529095f, 0.689095736f, 0.686656833f, 0.684212506f, 0.681762815f,
    0.679307759f, 0.676847458f, 0.674381971f, 0.671911240f, 0.669435501f,
    0.666954637f, 0.664468944f, 0.661978245f, 0.659482718f, 0.656982541f,
    0.654477477f, 0.651967824f, 0.649453580f, 0.646934807f, 0.644411504f,
    0.641883910f, 0.639351964f, 0.636815608f, 0.634275198f, 0.631730616f,
    0.629181862f, 0.626629114f, 0.624072373f, 0.621511757f, 0.618947387f,
    0.616379082f, 0.613807201f, 0.611231565f, 0.608652413f, 0.606069744f,
    0.603483617f, 0.600894034f, 0.598301172f, 0.595705032f, 0.593105674f,
    0.590503156f, 0.587897599f, 0.585289061f, 0.582677484f, 0.580063045f,
    0.577445805f, 0.574825764f, 0.572203040f, 0.569577694f, 0.566949785f,
    0.564319372f, 0.561686456f, 0.559051216f, 0.556413651f, 0.553773820f,
    0.551131785f, 0.548487663f, 0.545841396f, 0.543193221f, 0.540543079f,
    0.537890971f, 0.535237134f, 0.532581568f, 0.529924273f, 0.527265370f,
    0.524604917f, 0.521942914f, 0.519279540f, 0.516614795f, 0.513948679f,
    0.511281490f, 0.508612931f, 0.505943298f, 0.503272593f, 0.500600994f,
    0.497928351f, 0.495254934f, 0.492580622f, 0.489905566f, 0.487229884f,
    0.484553576f, 0.481876701f, 0.479199320f, 0.476521552f, 0.473843396f,
    0.471164882f, 0.468486160f, 0.465807229f, 0.463128209f, 0.460449100f,
    0.457770079f, 0.455091029f, 0.452412128f, 0.449733406f, 0.447054923f,
    0.444376737f, 0.441698909f, 0.439021617f, 0.436344713f, 0.433668375f,
    0.430992693f, 0.428317666f, 0.425643355f, 0.422969848f, 0.420297176f,
    0.417625397f, 0.414954633f, 0.412284881f, 0.409616232f, 0.406948745f,
    0.404282451f, 0.401617438f, 0.398953736f, 0.396291435f, 0.393630594f,
    0.390971363f, 0.388313591f, 0.385657459f, 0.383003026f, 0.380350292f,
    0.377699375f, 0.375050306f, 0.372403204f, 0.369758040f, 0.367114902f,
    0.364473879f, 0.361834973f, 0.359198302f, 0.356563985f, 0.353931844f,
    0.351302117f, 0.348674864f, 0.346050024f, 0.343427807f, 0.340808123f,
    0.338191152f, 0.335576862f, 0.332965344f, 0.330356658f, 0.327750862f,
    0.325147986f, 0.322548091f, 0.319951355f, 0.317357630f, 0.314767033f,
    0.312179655f, 0.309595555f, 0.307014734f, 0.304437339f, 0.301863313f,
    0.299292803f, 0.296725839f, 0.294162393f, 0.291602641f, 0.289046586f,
    0.286494225f, 0.283945769f, 0.281401068f, 0.278860301f, 0.276323408f,
    0.273790598f, 0.271261781f, 0.268737078f, 0.266216546f, 0.263700217f,
    0.261188149f, 0.258680373f, 0.256176978f, 0.253677934f, 0.251183391f,
    0.248693451f, 0.246207923f, 0.243727028f, 0.241250798f, 0.238779247f,
    0.236312449f, 0.233850464f, 0.231393293f, 0.228941023f, 0.226493701f,
    0.224051371f, 0.221614078f, 0.219181836f, 0.216754735f, 0.214332923f,
    0.211916193f, 0.209504753f, 0.207098618f, 0.204697832f, 0.202302471f,
    0.199912533f, 0.197528124f, 0.195149198f, 0.192775860f, 0.190408155f,
    0.188046113f, 0.185689807f, 0.183339253f, 0.180994540f, 0.178655609f,
    0.176322535f, 0.173995405f, 0.171674222f, 0.169359058f, 0.167049929f,
    0.164746925f, 0.162450001f, 0.160159275f, 0.157874763f, 0.155596510f,
    0.153324530f, 0.151058972f, 0.148799688f, 0.146546826f, 0.144300416f,
    0.142060474f, 0.139827073f, 0.137600228f, 0.135380000f, 0.133166388f,
    0.130959451f, 0.128759250f, 0.126565769f, 0.124379098f, 0.122199245f,
    0.120026320f, 0.117860198f, 0.115701027f, 0.113548823f, 0.111403592f,
    0.109265402f, 0.107134290f, 0.105010264f, 0.102893390f, 0.100783676f,
    0.098681159f, 0.096585885f, 0.094497882f, 0.092417173f, 0.090343870f,
    0.088277847f, 0.086219221f, 0.084168032f, 0.082124293f, 0.080088042f,
    0.078059308f, 0.076038122f, 0.074024513f, 0.072018512f, 0.070020139f,
    0.068029441f, 0.066046432f, 0.064071149f, 0.062103685f, 0.060143925f,
    0.058191977f, 0.056247860f, 0.054311592f, 0.052383222f, 0.050462760f,
    0.048550237f, 0.046645675f, 0.044749107f, 0.042860553f, 0.040980037f,
    0.039107583f, 0.037243221f, 0.035387039f, 0.033538923f, 0.031698968f,
    0.029867193f, 0.028043624f, 0.026228283f, 0.024421191f, 0.022622371f,
    0.020831848f, 0.019049639f, 0.017275762f, 0.015510243f, 0.013753103f,
    0.012004361f, 0.010264101f, 0.008532210f, 0.006808777f, 0.005093819f,
    0.003387353f, 0.001689399f, -0.000000024f, -0.001680900f, -0.003353210f,
    -0.005016938f, -0.006672067f, -0.008318579f, -0.009956459f, -0.011585629f,
    -0.013206195f, -0.014818084f, -0.016421281f, -0.018015765f, -0.019601526f,
    -0.021178551f, -0.022746822f, -0.024306327f, -0.025857056f, -0.027398987f,
    -0.028932119f, -0.030456433f, -0.031971917f, -0.033478502f, -0.034976289f,
    -0.036465216f, -0.037945267f, -0.039416436f, -0.040878706f, -0.042332072f,
    -0.043776520f, -0.045212042f, -0.046638630f, -0.048056271f, -0.049464963f,
    -0.050864697f, -0.052255459f, -0.053637192f, -0.055009995f, -0.056373812f,
    -0.057728622f, -0.059074435f, -0.060411237f, -0.061739020f, -0.063057788f,
    -0.064367518f, -0.065668218f, -0.066959888f, -0.068242513f, -0.069516085f,
    -0.070780613f, -0.072036028f, -0.073282443f, -0.074519798f, -0.075748093f,
    -0.076967306f, -0.078177467f, -0.079378553f, -0.080570564f, -0.081753515f,
    -0.082927369f, -0.084092163f, -0.085247882f, -0.086394526f, -0.087532081f,
    -0.088660523f, -0.089779936f, -0.090890266f, -0.091991536f, -0.093083732f,
    -0.094166860f, -0.095240898f, -0.096305899f, -0.097361818f, -0.098408684f,
    -0.099446490f, -0.100475237f, -0.101494931f, -0.102505587f, -0.103507154f,
    -0.104499720f, -0.105483264f, -0.106457770f, -0.107423261f, -0.108379729f,
    -0.109327182f, -0.110265635f, -0.111195073f, -0.112115517f, -0.113026999f,
    -0.113929473f, -0.114823014f, -0.115707509f, -0.116583094f, -0.117449738f,
    -0.118307441f, -0.119156219f, -0.119996056f, -0.120826989f, -0.121649019f,
    -0.122462146f, -0.123266406f, -0.124061778f, -0.124848284f, -0.125625938f,
    -0.126394749f, -0.127154693f, -0.127905846f, -0.128648207f, -0.129381746f,
    -0.130106509f, -0.130822510f, -0.131529734f, -0.132228225f, -0.132917970f,
    -0.133599013f, -0.134271339f, -0.134934962f, -0.135589913f, -0.136236191f,
    -0.136873797f, -0.137502789f, -0.138123170f, -0.138734937f, -0.139338136f,
    -0.139932722f, -0.140518770f, -0.141096294f, -0.141665265f, -0.142225727f,
    -0.142777696f, -0.143321201f, -0.143856242f, -0.144382849f, -0.144900993f,
    -0.145410761f, -0.145912141f, -0.146405146f, -0.146889821f, -0.147366136f,
    -0.147834152f, -0.148293883f, -0.148745313f, -0.149188504f, -0.149623469f,
    -0.150050193f, -0.150468737f, -0.150879115f, -0.151281342f, -0.151675433f,
    -0.152061403f, -0.152439296f, -0.152809098f, -0.153170869f, -0.153524607f,
    -0.153870359f, -0.154208109f, -0.154537901f, -0.154859766f, -0.155173704f,
    -0.155479759f, -0.155777946f, -0.156068295f, -0.156350806f, -0.156625539f,
    -0.156892478f, -0.157151699f, -0.157403171f, -0.157646939f, -0.157883018f,
    -0.158111468f, -0.158332288f, -0.158545509f, -0.158751160f, -0.158949256f,
    -0.159139827f, -0.159322888f, -0.159498483f, -0.159666643f, -0.159827381f,
    -0.159980699f, -0.160126686f, -0.160265297f, -0.160396621f, -0.160520658f,
    -0.160637438f, -0.160746962f, -0.160849288f, -0.160944447f, -0.161032468f,
    -0.161113337f, -0.161187142f, -0.161253884f, -0.161313564f, -0.161366254f,
    -0.161411941f, -0.161450699f, -0.161482543f, -0.161507472f, -0.161525562f,
    -0.161536828f, -0.161541268f, -0.161538944f, -0.161529869f, -0.161514089f,
    -0.161491618f, -0.161462501f, -0.161426738f, -0.161384419f, -0.161335513f,
    -0.161280081f, -0.161218151f, -0.161149755f, -0.161074907f, -0.160993651f,
    -0.160906032f, -0.160812065f, -0.160711765f, -0.160605207f, -0.160492390f,
    -0.160373345f, -0.160248131f, -0.160116762f, -0.159979254f, -0.159835666f,
    -0.159686014f, -0.159530357f, -0.159368694f, -0.159201056f, -0.159027517f,
    -0.158848062f, -0.158662766f, -0.158471599f, -0.158274680f, -0.158071980f,
    -0.157863557f, -0.157649443f, -0.157429650f, -0.157204241f, -0.156973228f,
    -0.156736642f, -0.156494558f, -0.156246960f, -0.155993909f, -0.155735433f,
    -0.155471563f, -0.155202329f, -0.154927775f, -0.154647917f, -0.154362813f,
    -0.154072478f, -0.153776988f, -0.153476328f, -0.153170541f, -0.152859688f,
    -0.152543753f, -0.152222827f, -0.151896924f, -0.151566073f, -0.151230305f,
    -0.150889665f, -0.150544196f, -0.150193915f, -0.149838865f, -0.149479061f,
    -0.149114594f, -0.148745432f, -0.148371637f, -0.147993281f, -0.147610337f,
    -0.147222877f, -0.146830946f, -0.146434546f, -0.146033719f, -0.145628527f,
    -0.145218968f, -0.144805118f, -0.144386992f, -0.143964618f, -0.143538073f,
    -0.143107325f, -0.142672464f, -0.142233476f, -0.141790435f, -0.141343385f,
    -0.140892327f, -0.140437320f, -0.139978394f, -0.139515579f, -0.139048934f,
    -0.138578460f, -0.138104215f, -0.137626216f, -0.137144551f, -0.136659175f,
    -0.136170194f, -0.135677606f, -0.135181442f, -0.134681761f, -0.134178594f,
    -0.133671984f, -0.133161947f, -0.132648528f, -0.132131740f, -0.131611660f,
    -0.131088302f, -0.130561695f, -0.130031943f, -0.129498973f, -0.128962860f,
    -0.128423676f, -0.127881393f, -0.127336115f, -0.126787826f, -0.126236603f,
    -0.125682443f, -0.125125393f, -0.124565504f, -0.124002807f, -0.123437323f,
    -0.122869089f, -0.122298159f, -0.121724561f, -0.121148311f, -0.120569460f,
    -0.119988061f, -0.119404130f, -0.118817687f, -0.118228793f, -0.117637470f,
    -0.117043748f, -0.116447672f, -0.115849286f, -0.115248613f, -0.114645667f,
    -0.114040568f, -0.113433234f, -0.112823755f, -0.112212166f, -0.111598492f,
    -0.110982776f, -0.110365056f, -0.109745361f, -0.109123722f, -0.108500175f,
    -0.107874751f, -0.107247494f, -0.106618427f, -0.105987601f, -0.105355024f,
    -0.104720749f, -0.104084812f, -0.103447236f, -0.102808066f, -0.102167316f,
    -0.101525046f, -0.100881256f, -0.100236014f, -0.099589340f, -0.098941252f,
    -0.098291807f, -0.097641021f, -0.096988983f, -0.096335620f, -0.095681041f,
    -0.095025249f, -0.094368286f, -0.093710184f, -0.093050972f, -0.092390701f,
    -0.091729380f, -0.091067046f, -0.090403758f, -0.089739501f, -0.089074343f,
    -0.088408306f, -0.087741412f, -0.087073699f, -0.086405218f, -0.085735977f,
    -0.085065998f, -0.084395349f, -0.083724037f, -0.083052084f, -0.082379535f,
    -0.081706434f, -0.081032783f, -0.080358639f, -0.079684012f, -0.079008937f,
    -0.078333504f, -0.077657640f, -0.076981425f, -0.076304883f, -0.075628042f,
    -0.074950956f, -0.074273616f, -0.073596083f, -0.072918370f, -0.072240517f,
    -0.071562558f, -0.070884496f, -0.070206381f, -0.069528244f, -0.068850100f,
    -0.068171993f, -0.067493953f, -0.066815972f, -0.066138126f, -0.065460421f,
    -0.064782880f, -0.064105548f, -0.063428439f, -0.062751584f, -0.062075011f,
    -0.061398748f, -0.060722828f, -0.060047265f, -0.059372153f, -0.058697399f,
    -0.058023106f, -0.057349272f, -0.056675948f, -0.056003150f, -0.055330887f,
    -0.054659221f, -0.053988155f, -0.053317714f, -0.052647941f, -0.051978838f,
    -0.051310450f, -0.050642796f, -0.049975898f, -0.049309790f, -0.048644483f,
    -0.047980014f, -0.047316402f, -0.046653673f, -0.045991853f, -0.045330971f,
    -0.044671040f, -0.044012092f, -0.043354150f, -0.042697236f, -0.042041373f,
    -0.041386627f, -0.040732939f, -0.040080376f, -0.039428953f, -0.038778704f,
    -0.038129643f, -0.037481792f, -0.036835186f, -0.036189832f, -0.035545766f,
    -0.034902997f, -0.034261558f, -0.033621464f, -0.032982741f, -0.032345407f,
    -0.031709481f, -0.031074993f, -0.030441960f, -0.029810399f, -0.029180335f,
    -0.028551787f, -0.027924776f, -0.027299322f, -0.026675448f, -0.026053172f,
    -0.025432510f, -0.024813488f, -0.024196124f, -0.023580479f, -0.022966485f,
    -0.022354206f, -0.021743659f, -0.021134868f, -0.020527845f, -0.019922616f,
    -0.019319192f, -0.018717598f, -0.018117845f, -0.017519956f, -0.016923945f,
    -0.016329836f, -0.015737642f, -0.015147380f, -0.014559067f, -0.013972721f,
    -0.013388360f, -0.012805998f, -0.012225654f, -0.011647343f, -0.011071082f,
    -0.010496887f, -0.009924773f, -0.009354758f, -0.008786854f, -0.008221081f,
    -0.007657450f, -0.007096022f, -0.006536725f, -0.005979617f, -0.005424712f,
    -0.004872025f, -0.004321571f, -0.003773364f, -0.003227417f, -0.002683746f,
    -0.002142363f, -0.001603282f, -0.001066516f, -0.000532080f, 0.000000015f,
    0.000529755f, 0.001057127f, 0.001582118f, 0.002104717f, 0.002624909f,
    0.003142685f, 0.003658031f, 0.004170935f, 0.004681387f, 0.005189373f,
    0.005694883f, 0.006197905f, 0.006698429f, 0.007196404f, 0.007691898f,
    0.008184860f, 0.008675281f, 0.009163151f, 0.009648458f, 0.010131192f,
    0.010611345f, 0.011088905f, 0.011563865f, 0.012036213f, 0.012505942f,
    0.012973041f, 0.013437501f, 0.013899315f, 0.014358475f, 0.014814967f,
    0.015268789f, 0.015719930f, 0.016168380f, 0.016614137f, 0.017057184f,
    0.017497523f, 0.017935142f, 0.018370032f, 0.018802188f, 0.019231608f,
    0.019658273f, 0.020082152f, 0.020503307f, 0.020921690f, 0.021337299f,
    0.021750130f, 0.022160176f, 0.022567427f, 0.022971880f, 0.023373535f,
    0.023772376f, 0.024168408f, 0.024561619f, 0.024952007f, 0.025339566f,
    0.025724288f, 0.026106175f, 0.026485221f, 0.026861422f, 0.027234772f,
    0.027605265f, 0.027972901f, 0.028337676f, 0.028699588f, 0.029058624f,
    0.029414795f, 0.029768089f, 0.030118505f, 0.030466037f, 0.030810660f,
    0.031152423f, 0.031491302f, 0.031827286f, 0.032160383f, 0.032490581f,
    0.032817882f, 0.033142287f, 0.033463787f, 0.033782389f, 0.034098089f,
    0.034410883f, 0.034720775f, 0.035027757f, 0.035331838f, 0.035633009f,
    0.035931274f, 0.036226626f, 0.036519073f, 0.036808614f, 0.037095241f,
    0.037378959f, 0.037659772f, 0.037937686f, 0.038212679f, 0.038484775f,
    0.038753960f, 0.039020218f, 0.039283592f, 0.039544068f, 0.039801639f,
    0.040056318f, 0.040308096f, 0.040556971f, 0.040802956f, 0.041046046f,
    0.041286245f, 0.041523557f, 0.041757982f, 0.041989524f, 0.042218179f,
    0.042443957f, 0.042666860f, 0.042886890f, 0.043104045f, 0.043318339f,
    0.043529764f, 0.043738328f, 0.043944035f, 0.044146888f, 0.044346895f,
    0.044544052f, 0.044738363f, 0.044929843f, 0.045118481f, 0.045304272f,
    0.045487255f, 0.045667417f, 0.045844764f, 0.046019293f, 0.046191018f,
    0.046359941f, 0.046526067f, 0.046689399f, 0.046849940f, 0.047007702f,
    0.047162689f, 0.047314901f, 0.047464348f, 0.047611035f, 0.047754966f,
    0.047896147f, 0.048034586f, 0.048170291f, 0.048303265f, 0.048433512f,
    0.048561048f, 0.048685864f, 0.048807982f, 0.048927400f, 0.049044125f,
    0.049158167f, 0.049269531f, 0.049378205f, 0.049484238f, 0.049587611f,
    0.049688339f, 0.049786422f, 0.049881872f, 0.049974691f, 0.050064899f,
    0.050152492f, 0.050237484f, 0.050319877f, 0.050399683f, 0.050476916f,
    0.050551571f, 0.050623666f, 0.050693203f, 0.050760195f, 0.050824653f,
    0.050886583f, 0.050945986f, 0.051002879f, 0.051057268f, 0.051109165f,
    0.051158577f, 0.051205512f, 0.051249981f, 0.051291991f, 0.051331542f,
    0.051368665f, 0.051403359f, 0.051435627f, 0.051465489f, 0.051492948f,
    0.051518012f, 0.051540703f, 0.051561009f, 0.051578961f, 0.051594563f,
    0.051607810f, 0.051618744f, 0.051627338f, 0.051633626f, 0.051637612f,
    0.051639307f, 0.051638719f, 0.051635865f, 0.051630747f, 0.051623378f,
    0.051613763f, 0.051601931f, 0.051587880f, 0.051571615f, 0.051553156f,
    0.051532514f, 0.051509693f, 0.051484708f, 0.051457576f, 0.051428299f,
    0.051396891f, 0.051363368f, 0.051327739f, 0.051290002f, 0.051250193f,
    0.051208302f, 0.051164351f, 0.051118344f, 0.051070303f, 0.051020239f,
    0.050968144f, 0.050914053f, 0.050857969f, 0.050799899f, 0.050739862f,
    0.050677869f, 0.050613929f, 0.050548054f, 0.050480254f, 0.050410546f,
    0.050338943f, 0.050265454f, 0.050190084f, 0.050112855f, 0.050033774f,
    0.049952857f, 0.049870111f, 0.049785554f, 0.049699202f, 0.049611051f,
    0.049521122f, 0.049429435f, 0.049335998f, 0.049240820f, 0.049143907f,
    0.049045283f, 0.048944961f, 0.048842940f, 0.048739251f, 0.048633892f,
    0.048526883f, 0.048418235f, 0.048307955f, 0.048196062f, 0.048082568f,
    0.047967490f, 0.047850832f, 0.047732603f, 0.047612831f, 0.047491513f,
    0.047368675f, 0.047244325f, 0.047118478f, 0.046991132f, 0.046862319f,
    0.046732042f, 0.046600312f, 0.046467155f, 0.046332560f, 0.046196572f,
    0.046059173f, 0.045920394f, 0.045780238f, 0.045638733f, 0.045495875f,
    0.045351684f, 0.045206167f, 0.045059349f, 0.044911236f, 0.044761848f,
    0.044611182f, 0.044459261f, 0.044306096f, 0.044151701f, 0.043996092f,
    0.043839272f, 0.043681268f, 0.043522079f, 0.043361723f, 0.043200217f,
    0.043037571f, 0.042873796f, 0.042708915f, 0.042542927f, 0.042375844f,
    0.042207699f, 0.042038482f, 0.041868217f, 0.041696910f, 0.041524585f,
    0.041351244f, 0.041176908f, 0.041001581f, 0.040825289f, 0.040648032f,
    0.040469825f, 0.040290687f, 0.040110629f, 0.039929654f, 0.039747790f,
    0.039565038f, 0.039381415f, 0.039196935f, 0.039011609f, 0.038825445f,
    0.038638465f, 0.038450673f, 0.038262092f, 0.038072724f, 0.037882581f,
    0.037691690f, 0.037500042f, 0.037307668f, 0.037114572f, 0.036920771f,
    0.036726266f, 0.036531083f, 0.036335230f, 0.036138717f, 0.035941560f,
    0.035743766f, 0.035545345f, 0.035346344f, 0.035146721f, 0.034946512f,
    0.034745730f, 0.034544386f, 0.034342494f, 0.034140065f, 0.033937111f,
    0.033733644f, 0.033529676f, 0.033325221f, 0.033120286f, 0.032914892f,
    0.032709036f, 0.032502741f, 0.032296017f, 0.032088876f, 0.031881329f,
    0.031673383f, 0.031465057f, 0.031256359f, 0.031047301f, 0.030837893f,
    0.030628148f, 0.030418083f, 0.030207697f, 0.029997014f, 0.029786035f,
    0.029574780f, 0.029363252f, 0.029151469f, 0.028939439f, 0.028727176f,
    0.028514685f, 0.028301982f, 0.028089074f, 0.027875982f, 0.027662706f,
    0.027449260f, 0.027235655f, 0.027021904f, 0.026808018f, 0.026594002f,
    0.026379872f, 0.026165638f, 0.025951311f, 0.025736896f, 0.025522409f,
    0.025307864f, 0.025093259f, 0.024878617f, 0.024663944f, 0.024449248f,
    0.024234539f, 0.024019832f, 0.023805158f, 0.023590479f, 0.023375830f,
    0.023161218f, 0.022946658f, 0.022732155f, 0.022517720f, 0.022303363f,
    0.022089096f, 0.021874927f, 0.021660868f, 0.021446921f, 0.021233102f,
    0.021019425f, 0.020805888f, 0.020592507f, 0.020379292f, 0.020166250f,
    0.019953389f, 0.019740723f, 0.019528257f, 0.019316001f, 0.019103965f,
    0.018892156f, 0.018680587f, 0.018469261f, 0.018258194f, 0.018047387f,
    0.017836852f, 0.017626595f, 0.017416634f, 0.017206967f, 0.016997607f,
    0.016788563f, 0.016579840f, 0.016371451f, 0.016163401f, 0.015955698f,
    0.015748354f, 0.015541371f, 0.015334761f, 0.015128531f, 0.014922690f,
    0.014717245f, 0.014512201f, 0.014307571f, 0.014103360f, 0.013899575f,
    0.013696224f, 0.013493315f, 0.013290856f, 0.013088853f, 0.012887316f,
    0.012686247f, 0.012485661f, 0.012285583f, 0.012085971f, 0.011886863f,
    0.011688258f, 0.011490168f, 0.011292599f, 0.011095556f, 0.010899050f,
    0.010703083f, 0.010507663f, 0.010312798f, 0.010118493f, 0.009924755f,
    0.009731592f, 0.009539006f, 0.009347008f, 0.009155600f, 0.008964794f,
    0.008774590f, 0.008584999f, 0.008396022f, 0.008207668f, 0.008019943f,
    0.007832851f, 0.007646400f, 0.007460595f, 0.007275441f, 0.007090943f,
    0.006907108f, 0.006723941f, 0.006541446f, 0.006359630f, 0.006178498f,
    0.005998055f, 0.005818305f, 0.005639255f, 0.005460909f, 0.005283272f,
    0.005106349f, 0.004930146f, 0.004754666f, 0.004579914f, 0.004405896f,
    0.004232615f, 0.004060077f, 0.003888285f, 0.003717245f, 0.003546960f,
    0.003377435f, 0.003208674f, 0.003040682f, 0.002873462f, 0.002707019f,
    0.002541356f, 0.002376478f, 0.002212389f, 0.002049116f, 0.001886615f,
    0.001724914f, 0.001564016f, 0.001403926f, 0.001244646f, 0.001086180f,
    0.000928532f, 0.000771705f, 0.000615702f, 0.000460527f, 0.000306183f,
    0.000152673f, -0.000000001f, -0.000151834f, -0.000302824f, -0.000452968f,
    -0.000602263f, -0.000750707f, -0.000898296f, -0.001045028f, -0.001190900f,
    -0.001335910f, -0.001480055f, -0.001623332f, -0.001765741f, -0.001907276f,
    -0.002047938f, -0.002187723f, -0.002326628f, -0.002464653f, -0.002601795f,
    -0.002738052f, -0.002873422f, -0.003007903f, -0.003141493f, -0.003274190f,
    -0.003405993f, -0.003536900f, -0.003666909f, -0.003796018f, -0.003924227f,
    -0.004051533f, -0.004177936f, -0.004303433f, -0.004428024f, -0.004551707f,
    -0.004674482f, -0.004796346f, -0.004917298f, -0.005037338f, -0.005156465f,
    -0.005274678f, -0.005391975f, -0.005508356f, -0.005623801f, -0.005738347f,
    -0.005851975f, -0.005964684f, -0.006076474f, -0.006187343f, -0.006297291f,
    -0.006406318f, -0.006514424f, -0.006621608f, -0.006727869f, -0.006833209f,
    -0.006937624f, -0.007041118f, -0.007143687f, -0.007245334f, -0.007346058f,
    -0.007445859f, -0.007544736f, -0.007642691f, -0.007739722f, -0.007835831f,
    -0.007931018f, -0.008025283f, -0.008118626f, -0.008211047f, -0.008302549f,
    -0.008393129f, -0.008482790f, -0.008571531f, -0.008659353f, -0.008746257f,
    -0.008832245f, -0.008917316f, -0.009001471f, -0.009084711f, -0.009167036f,
    -0.009248449f, -0.009328948f, -0.009408538f, -0.009487216f, -0.009564986f,
    -0.009641849f, -0.009717803f, -0.009792852f, -0.009866998f, -0.009940239f,
    -0.010012579f, -0.010084019f, -0.010154560f, -0.010224204f, -0.010292951f,
    -0.010360803f, -0.010427763f, -0.010493831f, -0.010558996f, -0.010623286f,
    -0.010686691f, -0.010749210f, -0.010810846f, -0.010871602f, -0.010931478f,
    -0.010990476f, -0.011048601f, -0.011105850f, -0.011162230f, -0.011217739f,
    -0.011272381f, -0.011326157f, -0.011379071f, -0.011431124f, -0.011482318f,
    -0.011532655f, -0.011582140f, -0.011630770f, -0.011678550f, -0.011725485f,
    -0.011771576f, -0.011816822f, -0.011861229f, -0.011904799f, -0.011947533f,
    -0.011989436f, -0.012030509f, -0.012070752f, -0.012110173f, -0.012148771f,
    -0.012186551f, -0.012223513f, -0.012259661f, -0.012295000f, -0.012329529f,
    -0.012363252f, -0.012396174f, -0.012428297f, -0.012459621f, -0.012490152f,
    -0.012519893f, -0.012548844f, -0.012577013f, -0.012604399f, -0.012631006f,
    -0.012656839f, -0.012681897f, -0.012706185f, -0.012729709f, -0.012752469f,
    -0.012774469f, -0.012795713f, -0.012816204f, -0.012835944f, -0.012854930f,
    -0.012873179f, -0.012890689f, -0.012907463f, -0.012923501f, -0.012938812f,
    -0.012953395f, -0.012967254f, -0.012980393f, -0.012992817f, -0.013004529f,
    -0.013015532f, -0.013025828f, -0.013035421f, -0.013044316f, -0.013052518f,
    -0.013060026f, -0.013066847f, -0.013072984f, -0.013078442f, -0.013083221f,
    -0.013087329f, -0.013090767f, -0.013093537f, -0.013095647f, -0.013097100f,
    -0.013097897f, -0.013098043f, -0.013097542f, -0.013096399f, -0.013094617f,
    -0.013092197f, -0.013089147f, -0.013085471f, -0.013081170f, -0.013076247f,
    -0.013070711f, -0.013064560f, -0.013057803f, -0.013050442f, -0.013042479f,
    -0.013033919f, -0.013024768f, -0.013015027f, -0.013004702f, -0.012993797f,
    -0.012982314f, -0.012970260f, -0.012957636f, -0.012944449f, -0.012930701f,
    -0.012916395f, -0.012901539f, -0.012886133f, -0.012870182f, -0.012853689f,
    -0.012836664f, -0.012819104f, -0.012801019f, -0.012782406f, -0.012763276f,
    -0.012743629f, -0.012723471f, -0.012702805f, -0.012681637f, -0.012659966f,
    -0.012637801f, -0.012615148f, -0.012592005f, -0.012568381f, -0.012544277f,
    -0.012519698f, -0.012494650f, -0.012469133f, -0.012443157f, -0.012416720f,
    -0.012389832f, -0.012362492f, -0.012334707f, -0.012306482f, -0.012277817f,
    -0.012248720f, -0.012219194f, -0.012189244f, -0.012158873f, -0.012128084f,
    -0.012096884f, -0.012065274f, -0.012033261f, -0.012000849f, -0.011968041f,
    -0.011934839f, -0.011901250f, -0.011867279f, -0.011832927f, -0.011798202f,
    -0.011763104f, -0.011727640f, -0.011691812f, -0.011655626f, -0.011619086f,
    -0.011582195f, -0.011544957f, -0.011507377f, -0.011469459f, -0.011431207f,
    -0.011392625f, -0.011353718f, -0.011314487f, -0.011274938f, -0.011235079f,
    -0.011194907f, -0.011154431f, -0.011113651f, -0.011072575f, -0.011031206f,
    -0.010989547f, -0.010947601f, -0.010905375f, -0.010862871f, -0.010820094f,
    -0.010777046f, -0.010733733f, -0.010690158f, -0.010646327f, -0.010602240f,
    -0.010557905f, -0.010513324f, -0.010468500f, -0.010423439f, -0.010378144f,
    -0.010332618f, -0.010286866f, -0.010240891f, -0.010194698f, -0.010148291f,
    -0.010101672f, -0.010054846f, -0.010007816f, -0.009960588f, -0.009913164f,
    -0.009865548f, -0.009817744f, -0.009769755f, -0.009721586f, -0.009673241f,
    -0.009624721f, -0.009576033f, -0.009527179f, -0.009478163f, -0.009428989f,
    -0.009379660f, -0.009330180f, -0.009280552f, -0.009230781f, -0.009180869f,
    -0.009130822f, -0.009080641f, -0.009030331f, -0.008979894f, -0.008929336f,
    -0.008878659f, -0.008827867f, -0.008776963f, -0.008725950f, -0.008674833f,
    -0.008623619f, -0.008572303f, -0.008520893f, -0.008469390f, -0.008417801f,
    -0.008366127f, -0.008314372f, -0.008262540f, -0.008210634f, -0.008158657f,
    -0.008106613f, -0.008054503f, -0.008002332f, -0.007950104f, -0.007897821f,
    -0.007845488f, -0.007793106f, -0.007740679f, -0.007688211f, -0.007635703f,
    -0.007583159f, -0.007530585f, -0.007477981f, -0.007425350f, -0.007372697f,
    -0.007320023f, -0.007267332f, -0.007214627f, -0.007161912f, -0.007109188f,
    -0.007056459f, -0.007003729f, -0.006951000f, -0.006898273f, -0.006845553f,
    -0.006792843f, -0.006740147f, -0.006687465f, -0.006634800f, -0.006582157f,
    -0.006529537f, -0.006476944f, -0.006424380f, -0.006371849f, -0.006319351f,
    -0.006266891f, -0.006214471f, -0.006162094f, -0.006109761f, -0.006057477f,
    -0.006005243f, -0.005953063f, -0.005900938f, -0.005848871f, -0.005796865f,
    -0.005744927f, -0.005693051f, -0.005641241f, -0.005589503f, -0.005537837f,
    -0.005486248f, -0.005434736f, -0.005383304f, -0.005331955f, -0.005280690f,
    -0.005229514f, -0.005178426f, -0.005127430f, -0.005076529f, -0.005025723f,
    -0.004975016f, -0.004924410f, -0.004873907f, -0.004823509f, -0.004773218f,
    -0.004723036f, -0.004672966f, -0.004623009f, -0.004573168f, -0.004523444f,
    -0.004473840f, -0.004424357f, -0.004374999f, -0.004325765f, -0.004276660f,
    -0.004227683f, -0.004178838f, -0.004130126f, -0.004081549f, -0.004033110f,
    -0.003984808f, -0.003936647f, -0.003888629f, -0.003840754f, -0.003793026f,
    -0.003745445f, -0.003698014f, -0.003650733f, -0.003603605f, -0.003556631f,
    -0.003509813f, -0.003463153f, -0.003416652f, -0.003370312f, -0.003324133f,
    -0.003278119f, -0.003232269f, -0.003186587f, -0.003141073f, -0.003095729f,
    -0.003050560f, -0.003005560f, -0.002960733f, -0.002916081f, -0.002871606f,
    -0.002827310f, -0.002783192f, -0.002739255f, -0.002695500f, -0.002651928f,
    -0.002608541f, -0.002565339f, -0.002522324f, -0.002479498f, -0.002436860f,
    -0.002394413f, -0.002352157f, -0.002310094f, -0.002268225f, -0.002226550f,
    -0.002185071f, -0.002143790f, -0.002102705f, -0.002061821f, -0.002021135f,
    -0.001980651f, -0.001940368f, -0.001900289f, -0.001860412f, -0.001820740f,
    -0.001781274f, -0.001742014f, -0.001702961f, -0.001664116f, -0.001625479f,
    -0.001587052f, -0.001548836f, -0.001510830f, -0.001473036f, -0.001435455f,
    -0.001398086f, -0.001360932f, -0.001323992f, -0.001287267f, -0.001250757f,
    -0.001214464f, -0.001178389f, -0.001142530f, -0.001106890f, -0.001071468f,
    -0.001036266f, -0.001001283f, -0.000966520f, -0.000931978f, -0.000897657f,
    -0.000863557f, -0.000829685f, -0.000796029f, -0.000762597f, -0.000729387f,
    -0.000696401f, -0.000663639f, -0.000631101f, -0.000598788f, -0.000566699f,
    -0.000534836f, -0.000503197f, -0.000471784f, -0.000440597f, -0.000409636f,
    -0.000378901f, -0.000348393f, -0.000318111f, -0.000288056f, -0.000258228f,
    -0.000228626f, -0.000199252f, -0.000170105f, -0.000141186f, -0.000112493f,
    -0.000084028f, -0.000055791f, -0.000027781f, 0.000000002f, 0.000027557f,
    0.000054884f, 0.000081984f, 0.000108857f, 0.000135502f, 0.000161920f,
    0.000188111f, 0.000214075f, 0.000239812f, 0.000265322f, 0.000290606f,
    0.000315663f, 0.000340493f, 0.000365097f, 0.000389476f, 0.000413628f,
    0.000437555f, 0.000461256f, 0.000484733f, 0.000507984f, 0.000531011f,
    0.000553814f, 0.000576393f, 0.000598748f, 0.000620879f, 0.000642788f,
    0.000664473f, 0.000685933f, 0.000707174f, 0.000728194f, 0.000748993f,
    0.000769570f, 0.000789927f, 0.000810064f, 0.000829982f, 0.000849680f,
    0.000869160f, 0.000888421f, 0.000907465f, 0.000926291f, 0.000944901f,
    0.000963294f, 0.000981472f, 0.000999434f, 0.001017181f, 0.001034715f,
    0.001052034f, 0.001069141f, 0.001086035f, 0.001102717f, 0.001119188f,
    0.001135448f, 0.001151499f, 0.001167339f, 0.001182971f, 0.001198395f,
    0.001213611f, 0.001228620f, 0.001243423f, 0.001258021f, 0.001272413f,
    0.001286602f, 0.001300586f, 0.001314368f, 0.001327948f, 0.001341327f,
    0.001354505f, 0.001367483f, 0.001380263f, 0.001392843f, 0.001405226f,
    0.001417413f, 0.001429403f, 0.001441198f, 0.001452798f, 0.001464205f,
    0.001475418f, 0.001486440f, 0.001497271f, 0.001507911f, 0.001518361f,
    0.001528623f, 0.001538696f, 0.001548581f, 0.001558281f, 0.001567796f,
    0.001577127f, 0.001586274f, 0.001595238f, 0.001604020f, 0.001612622f,
    0.001621043f, 0.001629285f, 0.001637349f, 0.001645236f, 0.001652946f,
    0.001660481f, 0.001667841f, 0.001675027f, 0.001682041f, 0.001688883f,
    0.001695554f, 0.001702055f, 0.001708387f, 0.001714552f, 0.001720549f,
    0.001726380f, 0.001732047f, 0.001737549f, 0.001742888f, 0.001748065f,
    0.001753081f, 0.001757936f, 0.001762632f, 0.001767171f, 0.001771552f,
    0.001775777f, 0.001779847f, 0.001783762f, 0.001787525f, 0.001791135f,
    0.001794595f, 0.001797904f, 0.001801064f, 0.001804076f, 0.001806941f,
    0.001809660f, 0.001812234f, 0.001814664f, 0.001816952f, 0.001819097f,
    0.001821102f, 0.001822967f, 0.001824693f, 0.001826282f, 0.001827733f,
    0.001829050f, 0.001830231f, 0.001831278f, 0.001832194f, 0.001832979f,
    0.001833633f, 0.001834158f, 0.001834554f, 0.001834824f, 0.001834967f,
    0.001834986f, 0.001834880f, 0.001834651f, 0.001834301f, 0.001833830f,
    0.001833239f, 0.001832529f, 0.001831702f, 0.001830758f, 0.001829698f,
    0.001828525f, 0.001827237f, 0.001825838f, 0.001824327f, 0.001822706f,
    0.001820976f, 0.001819138f, 0.001817193f, 0.001815141f, 0.001812985f,
    0.001810725f, 0.001808363f, 0.001805898f, 0.001803333f, 0.001800668f,
    0.001797904f, 0.001795043f, 0.001792086f, 0.001789033f, 0.001785886f,
    0.001782645f, 0.001779312f, 0.001775887f, 0.001772373f, 0.001768769f,
    0.001765078f, 0.001761299f, 0.001757434f, 0.001753483f, 0.001749449f,
    0.001745332f, 0.001741133f, 0.001736853f, 0.001732493f, 0.001728054f,
    0.001723537f, 0.001718944f, 0.001714273f, 0.001709529f, 0.001704710f,
    0.001699819f, 0.001694857f, 0.001689823f, 0.001684719f, 0.001679546f,
    0.001674306f, 0.001668998f, 0.001663625f, 0.001658187f, 0.001652685f,
    0.001647120f, 0.001641493f, 0.001635804f, 0.001630056f, 0.001624249f,
    0.001618383f, 0.001612461f, 0.001606481f, 0.001600448f, 0.001594359f,
    0.001588217f, 0.001582022f, 0.001575776f, 0.001569480f, 0.001563134f,
    0.001556739f, 0.001550296f, 0.001543806f, 0.001537270f, 0.001530689f,
    0.001524064f, 0.001517395f, 0.001510684f, 0.001503932f, 0.001497139f,
    0.001490306f, 0.001483435f, 0.001476525f, 0.001469578f, 0.001462596f,
    0.001455577f, 0.001448524f, 0.001441438f, 0.001434318f, 0.001427167f,
    0.001419984f, 0.001412771f, 0.001405529f, 0.001398258f, 0.001390959f,
    0.001383633f, 0.001376281f, 0.001368903f, 0.001361501f, 0.001354076f,
    0.001346627f, 0.001339155f, 0.001331663f, 0.001324150f, 0.001316617f,
    0.001309064f, 0.001301494f, 0.001293906f, 0.001286301f, 0.001278680f,
    0.001271044f, 0.001263393f, 0.001255728f, 0.001248050f, 0.001240360f,
    0.001232658f, 0.001224945f, 0.001217221f, 0.001209488f, 0.001201747f,
    0.001193997f, 0.001186240f, 0.001178476f, 0.001170706f, 0.001162930f,
    0.001155150f, 0.001147365f, 0.001139577f, 0.001131787f, 0.001123994f,
    0.001116200f, 0.001108405f, 0.001100609f, 0.001092814f, 0.001085020f,
    0.001077228f, 0.001069438f, 0.001061651f, 0.001053867f, 0.001046087f,
    0.001038312f, 0.001030542f, 0.001022778f, 0.001015020f, 0.001007270f,
    0.000999526f, 0.000991791f, 0.000984065f, 0.000976347f, 0.000968640f,
    0.000960942f, 0.000953256f, 0.000945580f, 0.000937917f, 0.000930266f,
    0.000922628f, 0.000915002f, 0.000907391f, 0.000899794f, 0.000892212f,
    0.000884646f, 0.000877095f, 0.000869560f, 0.000862042f, 0.000854541f,
    0.000847058f, 0.000839593f, 0.000832147f, 0.000824719f, 0.000817311f,
    0.000809923f, 0.000802555f, 0.000795208f, 0.000787881f, 0.000780577f,
    0.000773294f, 0.000766033f, 0.000758795f, 0.000751581f, 0.000744389f,
    0.000737222f, 0.000730079f, 0.000722960f, 0.000715866f, 0.000708798f,
    0.000701755f, 0.000694738f, 0.000687748f, 0.000680784f, 0.000673847f,
    0.000666937f, 0.000660055f, 0.000653202f, 0.000646376f, 0.000639579f,
    0.000632810f, 0.000626071f, 0.000619362f, 0.000612682f, 0.000606032f,
    0.000599412f, 0.000592823f, 0.000586265f, 0.000579738f, 0.000573242f,
    0.000566777f, 0.000560345f, 0.000553944f, 0.000547577f, 0.000541241f,
    0.000534938f, 0.000528668f, 0.000522432f, 0.000516228f, 0.000510059f,
    0.000503923f, 0.000497821f, 0.000491753f, 0.000485720f, 0.000479721f,
    0.000473757f, 0.000467828f, 0.000461934f, 0.000456075f, 0.000450252f,
    0.000444464f, 0.000438712f, 0.000432996f, 0.000427316f, 0.000421672f,
    0.000416064f, 0.000410493f, 0.000404958f, 0.000399460f, 0.000393998f,
    0.000388574f, 0.000383186f, 0.000377836f, 0.000372523f, 0.000367247f,
    0.000362008f, 0.000356807f, 0.000351643f, 0.000346517f, 0.000341429f,
    0.000336378f, 0.000331366f, 0.000326391f, 0.000321454f, 0.000316555f,
    0.000311695f, 0.000306872f, 0.000302088f, 0.000297341f, 0.000292633f,
    0.000287963f, 0.000283332f, 0.000278739f, 0.000274184f, 0.000269667f,
    0.000265189f, 0.000260749f, 0.000256348f, 0.000251985f, 0.000247661f,
    0.000243374f, 0.000239126f, 0.000234917f, 0.000230745f, 0.000226613f,
    0.000222518f, 0.000218462f, 0.000214443f, 0.000210464f, 0.000206522f,
    0.000202618f, 0.000198753f, 0.000194926f, 0.000191136f, 0.000187385f,
    0.000183671f, 0.000179996f, 0.000176358f, 0.000172758f, 0.000169195f,
    0.000165670f, 0.000162183f, 0.000158733f, 0.000155321f, 0.000151945f,
    0.000148607f, 0.000145307f, 0.000142043f, 0.000138816f, 0.000135626f,
    0.000132473f, 0.000129356f, 0.000126276f, 0.000123233f, 0.000120225f,
    0.000117255f, 0.000114320f, 0.000111421f, 0.000108558f, 0.000105731f,
    0.000102940f, 0.000100184f, 0.000097463f, 0.000094778f, 0.000092128f,
    0.000089513f, 0.000086933f, 0.000084388f, 0.000081878f, 0.000079402f,
    0.000076960f, 0.000074552f, 0.000072179f, 0.000069839f, 0.000067534f,
    0.000065261f, 0.000063023f, 0.000060817f, 0.000058645f, 0.000056506f,
    0.000054399f, 0.000052326f, 0.000050284f, 0.000048275f, 0.000046299f,
    0.000044354f, 0.000042441f, 0.000040560f, 0.000038710f, 0.000036891f,
    0.000035104f, 0.000033348f, 0.000031622f, 0.000029927f, 0.000028263f,
    0.000026628f, 0.000025024f, 0.000023450f, 0.000021905f, 0.000020390f,
    0.000018904f, 0.000017447f, 0.000016019f, 0.000014620f, 0.000013249f,
    0.000011907f, 0.000010593f, 0.000009307f, 0.000008048f, 0.000006818f,
    0.000005614f, 0.000004438f, 0.000003288f, 0.000002166f, 0.000001070f,
    -0.000000000f
};

static const float ResamplerFilterDifference[RESAMPLER_FILTER_SIZE] = {
    -0.000006318f, -0.000019312f, -0.000033081f, -0.000046730f, -0.000060380f,
    -0.000074029f, -0.000087738f, -0.000101388f, -0.000115037f, -0.000128686f,
    -0.000142336f, -0.000155985f, -0.000169694f, -0.000183165f, -0.000196993f,
    -0.000210524f, -0.000224173f, -0.000237763f, -0.000251293f, -0.000265062f,
    -0.000278592f, -0.000292122f, -0.000305772f, -0.000319421f, -0.000332832f,
    -0.000346422f, -0.000359952f, -0.000373542f, -0.000387073f, -0.000400543f,
    -0.000414014f, -0.000427663f, -0.000441074f, -0.000454485f, -0.000468016f,
    -0.000481427f, -0.000494778f, -0.000508308f, -0.000521660f, -0.000535011f,
    -0.000548482f, -0.000561833f, -0.000575066f, -0.000588536f, -0.000601768f,
    -0.000615180f, -0.000628352f, -0.000641525f, -0.000655055f, -0.000668049f,
    -0.000681281f, -0.000694513f, -0.000707746f, -0.000720799f, -0.000733972f,
    -0.000747204f, -0.000760138f, -0.000773191f, -0.000786424f, -0.000799239f,
    -0.000812411f, -0.000825346f, -0.000838339f, -0.000851214f, -0.000864267f,
    -0.000877023f, -0.000890017f, -0.000902772f, -0.000915587f, -0.000928521f,
    -0.000941217f, -0.000953972f, -0.000966668f, -0.000979364f, -0.000992119f,
    -0.001004696f, -0.001017392f, -0.001029909f, -0.001042426f, -0.001055002f,
    -0.001067519f, -0.001080096f, -0.001092434f, -0.001104832f, -0.001117289f,
    -0.001129627f, -0.001141965f, -0.001154304f, -0.001166403f, -0.001178861f,
    -0.001191020f, -0.001203120f, -0.001215160f, -0.001227558f, -0.001239419f,
    -0.001251400f, -0.001263618f, -0.001275480f, -0.001287460f, -0.001299262f,
    -0.001311302f, -0.001322985f, -0.001334965f, -0.001346648f, -0.001358271f,
    -0.001370072f, -0.001381695f, -0.001393259f, -0.001404881f, -0.001416504f,
    -0.001427948f, -0.001439393f, -0.001450837f, -0.001462340f, -0.001473546f,
    -0.001484871f, -0.001496255f, -0.001507342f, -0.001518726f, -0.001529694f,
    -0.001540840f, -0.001552045f, -0.001562893f, -0.001574039f, -0.001584947f,
    -0.001595795f, -0.001606703f, -0.001617491f, -0.001628280f, -0.001639009f,
    -0.001649678f, -0.001660407f, -0.001670957f, -0.001681507f, -0.001692057f,
    -0.001702428f, -0.001713037f, -0.001723289f, -0.001733601f, -0.001743913f,
    -0.001754165f, -0.001764417f, -0.001774490f, -0.001784563f, -0.001794696f,
    -0.001804650f, -0.001814663f, -0.001824498f, -0.001834452f, -0.001844168f,
    -0.001854002f, -0.001863778f, -0.001873314f, -0.001883030f, -0.001892567f,
    -0.001902103f, -0.001911521f, -0.001920938f, -0.001930356f, -0.001939654f,
    -0.001948893f, -0.001958191f, -0.001967311f, -0.001976430f, -0.001985550f,
    -0.001994491f, -0.002003491f, -0.002012312f, -0.002021313f, -0.002030015f,
    -0.002038717f, -0.002047479f, -0.002056181f, -0.002064645f, -0.002073288f,
    -0.002081692f, -0.002090156f, -0.002098501f, -0.002106905f, -0.002115071f,
    -0.002123356f, -0.002131462f, -0.002139568f, -0.002147555f, -0.002155662f,
    -0.002163529f, -0.002171457f, -0.002179205f, -0.002187014f, -0.002194703f,
    -0.002202272f, -0.002209961f, -0.002217531f, -0.002224922f, -0.002232373f,
    -0.002239764f, -0.002247095f, -0.002254248f, -0.002261519f, -0.002268672f,
    -0.002275705f, -0.002282679f, -0.002289712f, -0.002296627f, -0.002303362f,
    -0.002310216f, -0.002316952f, -0.002323568f, -0.002330244f, -0.002336800f,
    -0.002343237f, -0.002349675f, -0.002356052f, -0.002362311f, -0.002368629f,
    -0.002374828f, -0.002380908f, -0.002386987f, -0.002392948f, -0.002398968f,
    -0.002404809f, -0.002410650f, -0.002416372f, -0.002422094f, -0.002427757f,
    -0.002433360f, -0.002438903f, -0.002444327f, -0.002449691f, -0.002455056f,
    -0.002460301f, -0.002465487f, -0.002470732f, -0.002475739f, -0.002480865f,
    -0.002485693f, -0.002490699f, -0.002495527f, -0.002500176f, -0.002505064f,
    -0.002509654f, -0.002514243f, -0.002518773f, -0.002523303f, -0.002527595f,
    -0.002531946f, -0.002536356f, -0.002540410f, -0.002544582f, -0.002548754f,
    -0.002552748f, -0.002556741f, -0.002560616f, -0.002564371f, -0.002568305f,
    -0.002571881f, -0.002575636f, -0.002579153f, -0.002582669f, -0.002586126f,
    -0.002589583f, -0.002592862f, -0.002596140f, -0.002599359f, -0.002602518f,
    -0.002605557f, -0.002608538f, -0.002611578f, -0.002614439f, -0.002617240f,
    -0.002620041f, -0.002622724f, -0.002625346f, -0.002627909f, -0.002630413f,
    -0.002632916f, -0.002635241f, -0.002637565f, -0.002639830f, -0.002642035f,
    -0.002644122f, -0.002646267f, -0.002648175f, -0.002650142f, -0.002652109f,
    -0.002653837f, -0.002655566f, -0.002657294f, -0.002658904f, -0.002660453f,
    -0.002662003f, -0.002663374f, -0.002664745f, -0.002666116f, -0.002667189f,
    -0.002668560f, -0.002669632f, -0.002670705f, -0.002671599f, -0.002672642f,
    -0.002673417f, -0.002674311f, -0.002675056f, -0.002675682f, -0.002676308f,
    -0.002676874f, -0.002677381f, -0.002677768f, -0.002678156f, -0.002678514f,
    -0.002678722f, -0.002678931f, -0.002679020f, -0.002679110f, -0.002679020f,
    -0.002679050f, -0.002678901f, -0.002678722f, -0.002678484f, -0.002678186f,
    -0.002677828f, -0.002677292f, -0.002676904f, -0.002676338f, -0.002675682f,
    -0.002675027f, -0.002674311f, -0.002673507f, -0.002672672f, -0.002671778f,
    -0.002670765f, -0.002669752f, -0.002668649f, -0.002667487f, -0.002666295f,
    -0.002665013f, -0.002663702f, -0.002662301f, -0.002660841f, -0.002659231f,
    -0.002657771f, -0.002656132f, -0.002654433f, -0.002652735f, -0.002650917f,
    -0.002649069f, -0.002647102f, -0.002645165f, -0.002643138f, -0.002641022f,
    -0.002638906f, -0.002636671f, -0.002634317f, -0.002632141f, -0.002629727f,
    -0.002627254f, -0.002624840f, -0.002622217f, -0.002619684f, -0.002616972f,
    -0.002614290f, -0.002611518f, -0.002608687f, -0.002605796f, -0.002602875f,
    -0.002599895f, -0.002596736f, -0.002593726f, -0.002590597f, -0.002587378f,
    -0.002584100f, -0.002580822f, -0.002577394f, -0.002574027f, -0.002570510f,
    -0.002566963f, -0.002563447f, -0.002559751f, -0.002556056f, -0.002552360f,
    -0.002548456f, -0.002544701f, -0.002540767f, -0.002536893f, -0.002532810f,
    -0.002528816f, -0.002524704f, -0.002520531f, -0.002516329f, -0.002512068f,
    -0.002507776f, -0.002503395f, -0.002499044f, -0.002494544f, -0.002489939f,
    -0.002485529f, -0.002480894f, -0.002476230f, -0.002471551f, -0.002466798f,
    -0.002461985f, -0.002457172f, -0.002452269f, -0.002447322f, -0.002442330f,
    -0.002437294f, -0.002432242f, -0.002427101f, -0.002421811f, -0.002416730f,
    -0.002411440f, -0.002406135f, -0.002400786f, -0.002395362f, -0.002389938f,
    -0.002384409f, -0.002378926f, -0.002373338f, -0.002367705f, -0.002362043f,
    -0.002356306f, -0.002350554f, -0.002344713f, -0.002338931f, -0.002333075f,
    -0.002327129f, -0.002321184f, -0.002315164f, -0.002309129f, -0.002303004f,
    -0.002296925f, -0.002290726f, -0.002284512f, -0.002278253f, -0.002271980f,
    -0.002265558f, -0.002259284f, -0.002252862f, -0.002246410f, -0.002239943f,
    -0.002233401f, -0.002226844f, -0.002220228f, -0.002213612f, -0.002206936f,
    -0.002200201f, -0.002193481f, -0.002186671f, -0.002179854f, -0.002172925f,
    -0.002166122f, -0.002159171f, -0.002152205f, -0.002145231f, -0.002138190f,
    -0.002131112f, -0.002124026f, -0.002116874f, -0.002109714f, -0.002102517f,
    -0.002095275f, -0.002088003f, -0.002080709f, -0.002073303f, -0.002066024f,
    -0.002058625f, -0.002051190f, -0.002043739f, -0.002036251f, -0.002028733f,
    -0.002021186f, -0.002013609f, -0.002006002f, -0.001998372f, -0.001990698f,
    -0.001983009f, -0.001975283f, -0.001967464f, -0.001959760f, -0.001951948f,
    -0.001944117f, -0.001936268f, -0.001928370f, -0.001920462f, -0.001912523f,
    -0.001904562f, -0.001896568f, -0.001888555f, -0.001880515f, -0.001872454f,
    -0.001864363f, -0.001856182f, -0.001848117f, -0.001839954f, -0.001831776f,
    -0.001823569f, -0.001815341f, -0.001807092f, -0.001798820f, -0.001790524f,
    -0.001782209f, -0.001773877f, -0.001765518f, -0.001757140f, -0.001748742f,
    -0.001740261f, -0.001731890f, -0.001723433f, -0.001714959f, -0.001706466f,
    -0.001697953f, -0.001689423f, -0.001680876f, -0.001672311f, -0.001663728f,
    -0.001655128f, -0.001646512f, -0.001637880f, -0.001629170f, -0.001620566f,
    -0.001611889f, -0.001603196f, -0.001594484f, -0.001585761f, -0.001577025f,
    -0.001568271f, -0.001559505f, -0.001550728f, -0.001541931f, -0.001533132f,
    -0.001524314f, -0.001515483f, -0.001506586f, -0.001497786f, -0.001488928f,
    -0.001480050f, -0.001471169f, -0.001462270f, -0.001453366f, -0.001444448f,
    -0.001435522f, -0.001426589f, -0.001417641f, -0.001408692f, -0.001399733f,
    -0.001390763f, -0.001381733f, -0.001372803f, -0.001363818f, -0.001354810f,
    -0.001345813f, -0.001336802f, -0.001327783f, -0.001318768f, -0.001309730f,
    -0.001300700f, -0.001291670f, -0.001282625f, -0.001273572f, -0.001264527f,
    -0.001255415f, -0.001246415f, -0.001237355f, -0.001228295f, -0.001219213f,
    -0.001210161f, -0.001201086f, -0.001192011f, -0.001182951f, -0.001173854f,
    -0.001164794f, -0.001155719f, -0.001146644f, -0.001137555f, -0.001128443f,
    -0.001119412f, -0.001110330f, -0.001101270f, -0.001092196f, -0.001083128f,
    -0.001074038f, -0.001065001f, -0.001055919f, -0.001046866f, -0.001037806f,
    -0.001028746f, -0.001019694f, -0.001010656f, -0.001001567f, -0.000992566f,
    -0.000983544f, -0.000974506f, -0.000965491f, -0.000956468f, -0.000947453f,
    -0.000938453f, -0.000929438f, -0.000920445f, -0.000911482f, -0.000902474f,
    -0.000893541f, -0.000884496f, -0.000875585f, -0.000866644f, -0.000857703f,
    -0.000848778f, -0.000839837f, -0.000830933f, -0.000822030f, -0.000813127f,
    -0.000804260f, -0.000795372f, -0.000786506f, -0.000777654f, -0.000768811f,
    -0.000759944f, -0.000751153f, -0.000742361f, -0.000733539f, -0.000724763f,
    -0.000716001f, -0.000707224f, -0.000698492f, -0.000689745f, -0.000681043f,
    -0.000672325f, -0.000663623f, -0.000654951f, -0.000646278f, -0.000637606f,
    -0.000628993f, -0.000620380f, -0.000611767f, -0.000603199f, -0.000594586f,
    -0.000586048f, -0.000577524f, -0.000568971f, -0.000560462f, -0.000551969f,
    -0.000543505f, -0.000535041f, -0.000526607f, -0.000518143f, -0.000509769f,
    -0.000501379f, -0.000493005f, -0.000484675f, -0.000476316f, -0.000468016f,
    -0.000459731f, -0.000451431f, -0.000443190f, -0.000434965f, -0.000426725f,
    -0.000418544f, -0.000410378f, -0.000402227f, -0.000394091f, -0.000385970f,
    -0.000377893f, -0.000369802f, -0.000361770f, -0.000353739f, -0.000345752f,
    -0.000337750f, -0.000329792f, -0.000321865f, -0.000313938f, -0.000306055f,
    -0.000298187f, -0.000290349f, -0.000282511f, -0.000274733f, -0.000266939f,
    -0.000259221f, -0.000251472f, -0.000243768f, -0.000236079f, -0.000228450f,
    -0.000220820f, -0.000213221f, -0.000205651f, -0.000198096f, -0.000190571f,
    -0.000183061f, -0.000175595f, -0.000168160f, -0.000160739f, -0.000153318f,
    -0.000145987f, -0.000138611f, -0.000131324f, -0.000124037f, -0.000116780f,
    -0.000109524f, -0.000102326f, -0.000095159f, -0.000088021f, -0.000080869f,
    -0.000073805f, -0.000066742f, -0.000059679f, -0.000052691f, -0.000045687f,
    -0.000038758f, -0.000031844f, -0.000024930f, -0.000018090f, -0.000011265f,
    -0.000004441f, 0.000002325f, 0.000009075f, 0.000015780f, 0.000022471f,
    0.000029117f, 0.000035763f, 0.000042319f, 0.000048906f, 0.000055432f,
    0.000061929f, 0.000068396f, 0.000074849f, 0.000081256f, 0.000087619f,
    0.000093967f, 0.000100300f, 0.000106558f, 0.000112817f, 0.000119045f,
    0.000125214f, 0.000131369f, 0.000137508f, 0.000143588f, 0.000149652f,
    0.000155658f, 0.000161663f, 0.000167638f, 0.000173539f, 0.000179455f,
    0.000185296f, 0.000191167f, 0.000196919f, 0.000202700f, 0.000208423f,
    0.000214115f, 0.000219792f, 0.000225410f, 0.000231013f, 0.000236586f,
    0.000242084f, 0.000247598f, 0.000253052f, 0.000258476f, 0.000263870f,
    0.000269234f, 0.000274554f, 0.000279859f, 0.000285104f, 0.000290334f,
    0.000295490f, 0.000300661f, 0.000305787f, 0.000310853f, 0.000315934f,
    0.000320926f, 0.000325903f, 0.000330850f, 0.000335768f, 0.000340641f,
    0.000345469f, 0.000350282f, 0.000355050f, 0.000359803f, 0.000364468f,
    0.000369161f, 0.000373796f, 0.000378355f, 0.000382945f, 0.000387460f,
    0.000391930f, 0.000396401f, 0.000400826f, 0.000405192f, 0.000409558f,
    0.000413850f, 0.000418127f, 0.000422373f, 0.000426546f, 0.000430748f,
    0.000434861f, 0.000438988f, 0.000443041f, 0.000447050f, 0.000451058f,
    0.000455007f, 0.000458926f, 0.000462815f, 0.000466645f, 0.000470474f,
    0.000474244f, 0.000477999f, 0.000481665f, 0.000485376f, 0.000488982f,
    0.000492588f, 0.000496164f, 0.000499681f, 0.000503168f, 0.000506610f,
    0.000510037f, 0.000513420f, 0.000516787f, 0.000520080f, 0.000523359f,
    0.000526607f, 0.000529751f, 0.000532970f, 0.000536114f, 0.000539184f,
    0.000542283f, 0.000545278f, 0.000548288f, 0.000551224f, 0.000554159f,
    0.000557050f, 0.000559889f, 0.000562698f, 0.000565484f, 0.000568233f,
    0.000570931f, 0.000573598f, 0.000576250f, 0.000578851f, 0.000581399f,
    0.000583932f, 0.000586443f, 0.000588894f, 0.000591323f, 0.000593722f,
    0.000596076f, 0.000598386f, 0.000600673f, 0.000602946f, 0.000605099f,
    0.000607334f, 0.000609480f, 0.000611588f, 0.000613675f, 0.000615716f,
    0.000617720f, 0.000619695f, 0.000621639f, 0.000623547f, 0.000625424f,
    0.000627257f, 0.000629067f, 0.000630826f, 0.000632577f, 0.000634275f,
    0.000635937f, 0.000637576f, 0.000639170f, 0.000640750f, 0.000642270f,
    0.000643790f, 0.000645243f, 0.000646673f, 0.000648089f, 0.000649445f,
    0.000650786f, 0.000652038f, 0.000653364f, 0.000654578f, 0.000655793f,
    0.000656962f, 0.000658102f, 0.000659212f, 0.000660270f, 0.000661321f,
    0.000662334f, 0.000663288f, 0.000664257f, 0.000665158f, 0.000666037f,
    0.000666894f, 0.000667714f, 0.000668481f, 0.000669241f, 0.000669979f,
    0.000670649f, 0.000671312f, 0.000671953f, 0.000672549f, 0.000673100f,
    0.000673652f, 0.000674143f, 0.000674628f, 0.000675075f, 0.000675432f,
    0.000675865f, 0.000676215f, 0.000676543f, 0.000676841f, 0.000677086f,
    0.000677340f, 0.000677533f, 0.000677712f, 0.000677854f, 0.000677958f,
    0.000678062f, 0.000678115f, 0.000678137f, 0.000678144f, 0.000678107f,
    0.000678040f, 0.000677980f, 0.000677846f, 0.000677705f, 0.000677541f,
    0.000677332f, 0.000677109f, 0.000676855f, 0.000676572f, 0.000676263f,
    0.000675920f, 0.000675563f, 0.000675112f, 0.000674754f, 0.000674292f,
    0.000673834f, 0.000673324f, 0.000672799f, 0.000672262f, 0.000671666f,
    0.000671066f, 0.000670440f, 0.000669774f, 0.000669103f, 0.000668388f,
    0.000667654f, 0.000666898f, 0.000666108f, 0.000665307f, 0.000664469f,
    0.000663612f, 0.000662729f, 0.000661820f, 0.000660881f, 0.000659931f,
    0.000658948f, 0.000657942f, 0.000656914f, 0.000655863f, 0.000654746f,
    0.000653688f, 0.000652563f, 0.000651423f, 0.000650249f, 0.000649061f,
    0.000647850f, 0.000646606f, 0.000645354f, 0.000644065f, 0.000642769f,
    0.000641439f, 0.000640094f, 0.000638723f, 0.000637334f, 0.000635926f,
    0.000634488f, 0.000633033f, 0.000631562f, 0.000630064f, 0.000628548f,
    0.000627011f, 0.000625454f, 0.000623874f, 0.000622276f, 0.000620661f,
    0.000619022f, 0.000617364f, 0.000615645f, 0.000613993f, 0.000612279f,
    0.000610547f, 0.000608791f, 0.000607023f, 0.000605229f, 0.000603424f,
    0.000601593f, 0.000599753f, 0.000597889f, 0.000596011f, 0.000594109f,
    0.000592194f, 0.000590262f, 0.000588313f, 0.000586346f, 0.000584361f,
    0.000582362f, 0.000580344f, 0.000578311f, 0.000576260f, 0.000574195f,
    0.000572114f, 0.000570015f, 0.000567904f, 0.000565774f, 0.000563630f,
    0.000561428f, 0.000559297f, 0.000557108f, 0.000554904f, 0.000552687f,
    0.000550454f, 0.000548207f, 0.000545946f, 0.000543671f, 0.000541383f,
    0.000539081f, 0.000536765f, 0.000534437f, 0.000532095f, 0.000529740f,
    0.000527372f, 0.000524992f, 0.000522598f, 0.000520193f, 0.000517776f,
    0.000515345f, 0.000512904f, 0.000510451f, 0.000507986f, 0.000505510f,
    0.000503022f, 0.000500523f, 0.000497975f, 0.000495494f, 0.000492963f,
    0.000490420f, 0.000487870f, 0.000485308f, 0.000482734f, 0.000480153f,
    0.000477560f, 0.000474961f, 0.000472347f, 0.000469729f, 0.000467099f,
    0.000464460f, 0.000461814f, 0.000459160f, 0.000456492f, 0.000453821f,
    0.000451141f, 0.000448450f, 0.000445757f, 0.000443047f, 0.000440339f,
    0.000437619f, 0.000434890f, 0.000432156f, 0.000429420f, 0.000426665f,
    0.000423878f, 0.000421155f, 0.000418384f, 0.000415608f, 0.000412831f,
    0.000410046f, 0.000407251f, 0.000404453f, 0.000401655f, 0.000398841f,
    0.000396032f, 0.000393212f, 0.000390388f, 0.000387559f, 0.000384722f,
    0.000381887f, 0.000379046f, 0.000376200f, 0.000373350f, 0.000370493f,
    0.000367636f, 0.000364775f, 0.000361912f, 0.000359036f, 0.000356171f,
    0.000353293f, 0.000350416f, 0.000347532f, 0.000344623f, 0.000341764f,
    0.000338878f, 0.000335984f, 0.000333097f, 0.000330199f, 0.000327300f,
    0.000324406f, 0.000321500f, 0.000318602f, 0.000315700f, 0.000312794f,
    0.000309892f, 0.000306983f, 0.000304081f, 0.000301171f, 0.000298265f,
    0.000295352f, 0.000292446f, 0.000289541f, 0.000286628f, 0.000283718f,
    0.000280812f, 0.000277914f, 0.000274993f, 0.000272095f, 0.000269186f,
    0.000266258f, 0.000263374f, 0.000260476f, 0.000257570f, 0.000254679f,
    0.000251777f, 0.000248875f, 0.000245985f, 0.000243090f, 0.000240199f,
    0.000237312f, 0.000234425f, 0.000231542f, 0.000228655f, 0.000225779f,
    0.000222903f, 0.000220031f, 0.000217155f, 0.000214294f, 0.000211425f,
    0.000208564f, 0.000205707f, 0.000202853f, 0.000200007f, 0.000197157f,
    0.000194311f, 0.000191480f, 0.000188638f, 0.000185791f, 0.000182983f,
    0.000180162f, 0.000177346f, 0.000174530f, 0.000171725f, 0.000168923f,
    0.000166126f, 0.000163332f, 0.000160541f, 0.000157762f, 0.000154987f,
    0.000152212f, 0.000149447f, 0.000146687f, 0.000143930f, 0.000141181f,
    0.000138439f, 0.000135705f, 0.000132974f, 0.000130247f, 0.000127535f,
    0.000124816f, 0.000122119f, 0.000119418f, 0.000116725f, 0.000114042f,
    0.000111364f, 0.000108674f, 0.000106033f, 0.000103373f, 0.000100728f,
    0.000098083f, 0.000095449f, 0.000092819f, 0.000090208f, 0.000087593f,
    0.000084992f, 0.000082392f, 0.000079807f, 0.000077233f, 0.000074655f,
    0.000072096f, 0.000069536f, 0.000066992f, 0.000064459f, 0.000061929f,
    0.000059403f, 0.000056893f, 0.000054389f, 0.000051897f, 0.000049412f,
    0.000046935f, 0.000044469f, 0.000042010f, 0.000039551f, 0.000037123f,
    0.000034694f, 0.000032268f, 0.000029862f, 0.000027459f, 0.000025064f,
    0.000022691f, 0.000020307f, 0.000017952f, 0.000015602f, 0.000013247f,
    0.000010934f, 0.000008594f, 0.000006288f, 0.000003986f, 0.000001695f,
    -0.000000589f, -0.000002854f, -0.000005119f, -0.000007369f, -0.000009615f,
    -0.000011832f, -0.000014052f, -0.000016265f, -0.000018459f, -0.000020642f,
    -0.000022821f, -0.000024986f, -0.000027131f, -0.000029277f, -0.000031408f,
    -0.000033524f, -0.000035629f, -0.000037737f, -0.000039808f, -0.000041891f,
    -0.000043951f, -0.000046007f, -0.000048041f, -0.000050064f, -0.000052094f,
    -0.000054091f, -0.000056084f, -0.000058070f, -0.000060037f, -0.000061993f,
    -0.000063941f, -0.000065874f, -0.000067800f, -0.000069708f, -0.000071604f,
    -0.000073489f, -0.000075370f, -0.000077229f, -0.000079080f, -0.000080917f,
    -0.000082746f, -0.000084557f, -0.000086352f, -0.000088152f, -0.000089929f,
    -0.000091687f, -0.000093438f, -0.000095177f, -0.000096913f, -0.000098623f,
    -0.000100322f, -0.000102021f, -0.000103690f, -0.000105359f, -0.000107009f,
    -0.000108648f, -0.000110280f, -0.000111893f, -0.000113495f, -0.000115078f,
    -0.000116657f, -0.000118230f, -0.000119772f, -0.000121318f, -0.000122838f,
    -0.000124350f, -0.000125848f, -0.000127345f, -0.000128813f, -0.000130277f,
    -0.000131730f, -0.000133157f, -0.000134595f, -0.000135988f, -0.000137400f,
    -0.000138778f, -0.000140157f, -0.000141505f, -0.000142857f, -0.000144191f,
    -0.000145517f, -0.000146817f, -0.000148114f, -0.000149388f, -0.000150666f,
    -0.000151921f, -0.000153165f, -0.000154395f, -0.000155609f, -0.000156820f,
    -0.000158004f, -0.000159189f, -0.000160355f, -0.000161506f, -0.000162646f,
    -0.000163775f, -0.000164881f, -0.000165988f, -0.000167083f, -0.000168145f,
    -0.000169218f, -0.000170264f, -0.000171307f, -0.000172324f, -0.000173341f,
    -0.000174336f, -0.000175327f, -0.000176292f, -0.000177257f, -0.000178207f,
    -0.000179138f, -0.000180058f, -0.000180975f, -0.000181865f, -0.000182752f,
    -0.000183623f, -0.000184480f, -0.000185326f, -0.000186164f, -0.000186980f,
    -0.000187792f, -0.000188582f, -0.000189368f, -0.000190143f, -0.000190891f,
    -0.000191648f, -0.000192374f, -0.000193097f, -0.000193801f, -0.000194505f,
    -0.000195183f, -0.000195853f, -0.000196513f, -0.000197157f, -0.000197794f,
    -0.000198420f, -0.000199001f, -0.000199623f, -0.000200208f, -0.000200782f,
    -0.000201344f, -0.000201892f, -0.000202429f, -0.000202954f, -0.000203468f,
    -0.000203967f, -0.000204455f, -0.000204936f, -0.000205394f, -0.000205856f,
    -0.000206295f, -0.000206724f, -0.000207141f, -0.000207547f, -0.000207946f,
    -0.000208326f, -0.000208698f, -0.000209058f, -0.000209408f, -0.000209745f,
    -0.000210065f, -0.000210386f, -0.000210684f, -0.000210978f, -0.000211256f,
    -0.000211528f, -0.000211783f, -0.000212030f, -0.000212263f, -0.000212491f,
    -0.000212703f, -0.000212908f, -0.000213092f, -0.000213277f, -0.000213446f,
    -0.000213604f, -0.000213752f, -0.000213886f, -0.000214016f, -0.000214130f,
    -0.000214234f, -0.000214327f, -0.000214415f, -0.000214487f, -0.000214545f,
    -0.000214605f, -0.000214642f, -0.000214674f, -0.000214696f, -0.000214709f,
    -0.000214707f, -0.000214674f, -0.000214679f, -0.000214649f, -0.000214612f,
    -0.000214560f, -0.000214502f, -0.000214435f, -0.000214357f, -0.000214268f,
    -0.000214169f, -0.000214059f, -0.000213947f, -0.000213819f, -0.000213677f,
    -0.000213537f, -0.000213381f, -0.000213215f, -0.000213042f, -0.000212861f,
    -0.000212666f, -0.000212466f, -0.000212256f, -0.000212036f, -0.000211809f,
    -0.000211569f, -0.000211326f, -0.000211067f, -0.000210807f, -0.000210535f,
    -0.000210257f, -0.000209961f, -0.000209667f, -0.000209359f, -0.000209045f,
    -0.000208722f, -0.000208389f, -0.000208050f, -0.000207704f, -0.000207344f,
    -0.000206983f, -0.000206610f, -0.000206229f, -0.000205842f, -0.000205445f,
    -0.000205044f, -0.000204630f, -0.000204211f, -0.000203785f, -0.000203351f,
    -0.000202909f, -0.000202459f, -0.000202003f, -0.000201537f, -0.000201069f,
    -0.000200586f, -0.000200078f, -0.000199611f, -0.000199108f, -0.000198605f,
    -0.000198090f, -0.000197569f, -0.000197043f, -0.000196506f, -0.000195967f,
    -0.000195420f, -0.000194865f, -0.000194305f, -0.000193738f, -0.000193163f,
    -0.000192585f, -0.000191999f, -0.000191407f, -0.000190807f, -0.000190204f,
    -0.000189591f, -0.000188977f, -0.000188354f, -0.000187725f, -0.000187092f,
    -0.000186451f, -0.000185805f, -0.000185154f, -0.000184498f, -0.000183835f,
    -0.000183167f, -0.000182495f, -0.000181816f, -0.000181132f, -0.000180443f,
    -0.000179750f, -0.000179050f, -0.000178346f, -0.000177636f, -0.000176923f,
    -0.000176203f, -0.000175480f, -0.000174752f, -0.000174019f, -0.000173280f,
    -0.000172539f, -0.000171792f, -0.000171040f, -0.000170285f, -0.000169525f,
    -0.000168761f, -0.000167992f, -0.000167220f, -0.000166443f, -0.000165662f,
    -0.000164878f, -0.000164090f, -0.000163272f, -0.000162501f, -0.000161701f,
    -0.000160898f, -0.000160091f, -0.000159280f, -0.000158466f, -0.000157648f,
    -0.000156827f, -0.000156003f, -0.000155175f, -0.000154344f, -0.000153510f,
    -0.000152673f, -0.000151833f, -0.000150990f, -0.000150144f, -0.000149295f,
    -0.000148444f, -0.000147589f, -0.000146732f, -0.000145872f, -0.000145010f,
    -0.000144145f, -0.000143277f, -0.000142408f, -0.000141536f, -0.000140661f,
    -0.000139785f, -0.000138906f, -0.000138025f, -0.000137142f, -0.000136257f,
    -0.000135370f, -0.000134481f, -0.000133590f, -0.000132697f, -0.000131803f,
    -0.000130907f, -0.000130009f, -0.000129110f, -0.000128209f, -0.000127306f,
    -0.000126403f, -0.000125497f, -0.000124591f, -0.000123683f, -0.000122774f,
    -0.000121864f, -0.000120952f, -0.000120040f, -0.000119127f, -0.000118212f,
    -0.000117297f, -0.000116381f, -0.000115445f, -0.000114546f, -0.000113628f,
    -0.000112709f, -0.000111789f, -0.000110869f, -0.000109948f, -0.000109027f,
    -0.000108106f, -0.000107184f, -0.000106262f, -0.000105340f, -0.000104415f,
    -0.000103494f, -0.000102570f, -0.000101647f, -0.000100723f, -0.000099801f,
    -0.000098877f, -0.000097955f, -0.000097031f, -0.000096109f, -0.000095187f,
    -0.000094265f, -0.000093343f, -0.000092422f, -0.000091502f, -0.000090580f,
    -0.000089660f, -0.000088741f, -0.000087823f, -0.000086904f, -0.000085988f,
    -0.000085071f, -0.000084155f, -0.000083240f, -0.000082325f, -0.000081412f,
    -0.000080500f, -0.000079590f, -0.000078678f, -0.000077770f, -0.000076862f,
    -0.000075955f, -0.000075049f, -0.000074145f, -0.000073241f, -0.000072340f,
    -0.000071440f, -0.000070541f, -0.000069643f, -0.000068747f, -0.000067852f,
    -0.000066960f, -0.000066068f, -0.000065166f, -0.000064289f, -0.000063405f,
    -0.000062519f, -0.000061636f, -0.000060757f, -0.000059876f, -0.000058998f,
    -0.000058125f, -0.000057249f, -0.000056379f, -0.000055509f, -0.000054643f,
    -0.000053776f, -0.000052913f, -0.000052053f, -0.000051194f, -0.000050337f,
    -0.000049485f, -0.000048630f, -0.000047781f, -0.000046935f, -0.000046090f,
    -0.000045246f, -0.000044407f, -0.000043570f, -0.000042734f, -0.000041903f,
    -0.000041073f, -0.000040242f, -0.000039421f, -0.000038599f, -0.000037779f,
    -0.000036962f, -0.000036148f, -0.000035339f, -0.000034529f, -0.000033723f,
    -0.000032922f, -0.000032122f, -0.000031324f, -0.000030532f, -0.000029741f,
    -0.000028951f, -0.000028169f, -0.000027386f, -0.000026607f, -0.000025833f,
    -0.000025058f, -0.000024288f, -0.000023524f, -0.000022760f, -0.000022001f,
    -0.000021243f, -0.000020491f, -0.000019740f, -0.000018986f, -0.000018249f,
    -0.000017510f, -0.000016774f, -0.000016038f, -0.000015311f, -0.000014583f,
    -0.000013859f, -0.000013139f, -0.000012424f, -0.000011712f, -0.000011003f,
    -0.000010296f, -0.000009594f, -0.000008895f, -0.000008201f, -0.000007508f,
    -0.000006821f, -0.000006137f, -0.000005458f, -0.000004780f, -0.000004107f,
    -0.000003438f, -0.000002770f, -0.000002110f, -0.000001453f, -0.000000797f,
    -0.000000146f, 0.000000501f, 0.000001144f, 0.000001782f, 0.000002420f,
    0.000003050f, 0.000003677f, 0.000004301f, 0.000004923f, 0.000005536f,
    0.000006150f, 0.000006758f, 0.000007361f, 0.000007963f, 0.000008560f,
    0.000009151f, 0.000009741f, 0.000010326f, 0.000010905f, 0.000011482f,
    0.000012054f, 0.000012624f, 0.000013188f, 0.000013747f, 0.000014306f,
    0.000014856f, 0.000015406f, 0.000015951f, 0.000016493f, 0.000017026f,
    0.000017560f, 0.000018085f, 0.000018612f, 0.000019130f, 0.000019647f,
    0.000020158f, 0.000020666f, 0.000021168f, 0.000021671f, 0.000022165f,
    0.000022653f, 0.000023143f, 0.000023624f, 0.000024104f, 0.000024579f,
    0.000025048f, 0.000025516f, 0.000025976f, 0.000026437f, 0.000026888f,
    0.000027340f, 0.000027785f, 0.000028226f, 0.000028664f, 0.000029097f,
    0.000029526f, 0.000029950f, 0.000030371f, 0.000030789f, 0.000031200f,
    0.000031610f, 0.000032012f, 0.000032413f, 0.000032808f, 0.000033202f,
    0.000033589f, 0.000033971f, 0.000034352f, 0.000034725f, 0.000035098f,
    0.000035464f, 0.000035828f, 0.000036187f, 0.000036540f, 0.000036892f,
    0.000037238f, 0.000037580f, 0.000037918f, 0.000038252f, 0.000038582f,
    0.000038907f, 0.000039231f, 0.000039549f, 0.000039860f, 0.000040172f,
    0.000040476f, 0.000040780f, 0.000041076f, 0.000041369f, 0.000041659f,
    0.000041946f, 0.000042226f, 0.000042504f, 0.000042778f, 0.000043048f,
    0.000043313f, 0.000043575f, 0.000043831f, 0.000044088f, 0.000044335f,
    0.000044581f, 0.000044825f, 0.000045061f, 0.000045295f, 0.000045526f,
    0.000045752f, 0.000045975f, 0.000046193f, 0.000046407f, 0.000046619f,
    0.000046826f, 0.000047030f, 0.000047228f, 0.000047424f, 0.000047616f,
    0.000047805f, 0.000047988f, 0.000048169f, 0.000048346f, 0.000048519f,
    0.000048689f, 0.000048853f, 0.000049016f, 0.000049174f, 0.000049329f,
    0.000049480f, 0.000049627f, 0.000049771f, 0.000049912f, 0.000050047f,
    0.000050181f, 0.000050310f, 0.000050437f, 0.000050558f, 0.000050677f,
    0.000050792f, 0.000050904f, 0.000051012f, 0.000051118f, 0.000051214f,
    0.000051316f, 0.000051410f, 0.000051503f, 0.000051589f, 0.000051674f,
    0.000051755f, 0.000051832f, 0.000051906f, 0.000051977f, 0.000052044f,
    0.000052109f, 0.000052171f, 0.000052229f, 0.000052283f, 0.000052333f,
    0.000052382f, 0.000052427f, 0.000052468f, 0.000052508f, 0.000052543f,
    0.000052574f, 0.000052604f, 0.000052631f, 0.000052653f, 0.000052674f,
    0.000052691f, 0.000052704f, 0.000052716f, 0.000052724f, 0.000052729f,
    0.000052730f, 0.000052730f, 0.000052726f, 0.000052720f, 0.000052710f,
    0.000052697f, 0.000052682f, 0.000052664f, 0.000052643f, 0.000052620f,
    0.000052593f, 0.000052564f, 0.000052531f, 0.000052498f, 0.000052460f,
    0.000052420f, 0.000052377f, 0.000052333f, 0.000052284f, 0.000052234f,
    0.000052180f, 0.000052125f, 0.000052067f, 0.000052006f, 0.000051938f,
    0.000051877f, 0.000051809f, 0.000051738f, 0.000051666f, 0.000051590f,
    0.000051512f, 0.000051432f, 0.000051349f, 0.000051265f, 0.000051177f,
    0.000051088f, 0.000050996f, 0.000050901f, 0.000050805f, 0.000050707f,
    0.000050606f, 0.000050503f, 0.000050398f, 0.000050291f, 0.000050182f,
    0.000050070f, 0.000049957f, 0.000049842f, 0.000049724f, 0.000049604f,
    0.000049483f, 0.000049358f, 0.000049234f, 0.000049105f, 0.000048977f,
    0.000048845f, 0.000048712f, 0.000048577f, 0.000048439f, 0.000048302f,
    0.000048161f, 0.000048019f, 0.000047874f, 0.000047728f, 0.000047581f,
    0.000047431f, 0.000047280f, 0.000047128f, 0.000046974f, 0.000046818f,
    0.000046660f, 0.000046501f, 0.000046341f, 0.000046178f, 0.000046015f,
    0.000045849f, 0.000045683f, 0.000045514f, 0.000045344f, 0.000045168f,
    0.000045001f, 0.000044827f, 0.000044652f, 0.000044475f, 0.000044297f,
    0.000044117f, 0.000043937f, 0.000043755f, 0.000043572f, 0.000043387f,
    0.000043201f, 0.000043015f, 0.000042827f, 0.000042638f, 0.000042447f,
    0.000042256f, 0.000042063f, 0.000041869f, 0.000041675f, 0.000041479f,
    0.000041282f, 0.000041084f, 0.000040885f, 0.000040685f, 0.000040484f,
    0.000040283f, 0.000040080f, 0.000039876f, 0.000039672f, 0.000039466f,
    0.000039260f, 0.000039053f, 0.000038845f, 0.000038636f, 0.000038427f,
    0.000038217f, 0.000038006f, 0.000037794f, 0.000037581f, 0.000037368f,
    0.000037155f, 0.000036940f, 0.000036725f, 0.000036509f, 0.000036293f,
    0.000036076f, 0.000035858f, 0.000035640f, 0.000035422f, 0.000035202f,
    0.000034983f, 0.000034763f, 0.000034542f, 0.000034321f, 0.000034100f,
    0.000033873f, 0.000033655f, 0.000033432f, 0.000033209f, 0.000032986f,
    0.000032762f, 0.000032538f, 0.000032313f, 0.000032089f, 0.000031864f,
    0.000031638f, 0.000031413f, 0.000031187f, 0.000030961f, 0.000030735f,
    0.000030508f, 0.000030282f, 0.000030055f, 0.000029828f, 0.000029601f,
    0.000029374f, 0.000029147f, 0.000028920f, 0.000028692f, 0.000028465f,
    0.000028237f, 0.000028010f, 0.000027782f, 0.000027555f, 0.000027328f,
    0.000027100f, 0.000026873f, 0.000026645f, 0.000026418f, 0.000026191f,
    0.000025964f, 0.000025737f, 0.000025510f, 0.000025283f, 0.000025057f,
    0.000024830f, 0.000024604f, 0.000024378f, 0.000024152f, 0.000023927f,
    0.000023702f, 0.000023476f, 0.000023252f, 0.000023027f, 0.000022803f,
    0.000022579f, 0.000022355f, 0.000022132f, 0.000021908f, 0.000021686f,
    0.000021460f, 0.000021241f, 0.000021020f, 0.000020798f, 0.000020578f,
    0.000020357f, 0.000020137f, 0.000019917f, 0.000019698f, 0.000019480f,
    0.000019261f, 0.000019044f, 0.000018826f, 0.000018609f, 0.000018393f,
    0.000018177f, 0.000017962f, 0.000017748f, 0.000017533f, 0.000017320f,
    0.000017107f, 0.000016894f, 0.000016682f, 0.000016471f, 0.000016260f,
    0.000016050f, 0.000015841f, 0.000015632f, 0.000015424f, 0.000015216f,
    0.000015009f, 0.000014803f, 0.000014597f, 0.000014393f, 0.000014188f,
    0.000013985f, 0.000013782f, 0.000013580f, 0.000013379f, 0.000013178f,
    0.000012978f, 0.000012779f, 0.000012581f, 0.000012383f, 0.000012186f,
    0.000011990f, 0.000011795f, 0.000011600f, 0.000011407f, 0.000011214f,
    0.000011022f, 0.000010830f, 0.000010640f, 0.000010450f, 0.000010262f,
    0.000010074f, 0.000009884f, 0.000009700f, 0.000009515f, 0.000009331f,
    0.000009147f, 0.000008964f, 0.000008782f, 0.000008601f, 0.000008421f,
    0.000008242f, 0.000008064f, 0.000007887f, 0.000007710f, 0.000007535f,
    0.000007360f, 0.000007186f, 0.000007014f, 0.000006842f, 0.000006671f,
    0.000006501f, 0.000006332f, 0.000006164f, 0.000005997f, 0.000005831f,
    0.000005667f, 0.000005502f, 0.000005339f, 0.000005177f, 0.000005016f,
    0.000004855f, 0.000004696f, 0.000004538f, 0.000004381f, 0.000004225f,
    0.000004070f, 0.000003916f, 0.000003763f, 0.000003610f, 0.000003459f,
    0.000003309f, 0.000003160f, 0.000003012f, 0.000002865f, 0.000002719f,
    0.000002574f, 0.000002430f, 0.000002287f, 0.000002146f, 0.000002005f,
    0.000001865f, 0.000001726f, 0.000001589f, 0.000001452f, 0.000001316f,
    0.000001182f, 0.000001047f, 0.000000916f, 0.000000785f, 0.000000654f,
    0.000000525f, 0.000000397f, 0.000000270f, 0.000000143f, 0.000000019f,
    -0.000000106f, -0.000000228f, -0.000000351f, -0.000000471f, -0.000000591f,
    -0.000000710f, -0.000000827f, -0.000000944f, -0.000001059f, -0.000001174f,
    -0.000001287f, -0.000001399f, -0.000001511f, -0.000001621f, -0.000001730f,
    -0.000001838f, -0.000001945f, -0.000002051f, -0.000002156f, -0.000002260f,
    -0.000002363f, -0.000002465f, -0.000002565f, -0.000002665f, -0.000002763f,
    -0.000002861f, -0.000002958f, -0.000003053f, -0.000003147f, -0.000003241f,
    -0.000003333f, -0.000003424f, -0.000003514f, -0.000003604f, -0.000003692f,
    -0.000003779f, -0.000003865f, -0.000003950f, -0.000004034f, -0.000004117f,
    -0.000004199f, -0.000004280f, -0.000004360f, -0.000004439f, -0.000004517f,
    -0.000004594f, -0.000004670f, -0.000004744f, -0.000004819f, -0.000004891f,
    -0.000004963f, -0.000005034f, -0.000005104f, -0.000005173f, -0.000005240f,
    -0.000005307f, -0.000005373f, -0.000005438f, -0.000005502f, -0.000005565f,
    -0.000005627f, -0.000005688f, -0.000005748f, -0.000005807f, -0.000005866f,
    -0.000005922f, -0.000005979f, -0.000006034f, -0.000006089f, -0.000006142f,
    -0.000006194f, -0.000006246f, -0.000006297f, -0.000006346f, -0.000006395f,
    -0.000006443f, -0.000006490f, -0.000006536f, -0.000006581f, -0.000006625f,
    -0.000006668f, -0.000006711f, -0.000006752f, -0.000006793f, -0.000006833f,
    -0.000006872f, -0.000006909f, -0.000006947f, -0.000006983f, -0.000007018f,
    -0.000007053f, -0.000007086f, -0.000007119f, -0.000007151f, -0.000007183f,
    -0.000007213f, -0.000007242f, -0.000007271f, -0.000007299f, -0.000007326f,
    -0.000007352f, -0.000007377f, -0.000007402f, -0.000007426f, -0.000007449f,
    -0.000007471f, -0.000007493f, -0.000007513f, -0.000007533f, -0.000007552f,
    -0.000007570f, -0.000007588f, -0.000007605f, -0.000007621f, -0.000007636f,
    -0.000007651f, -0.000007665f, -0.000007678f, -0.000007690f, -0.000007702f,
    -0.000007713f, -0.000007723f, -0.000007733f, -0.000007742f, -0.000007750f,
    -0.000007757f, -0.000007764f, -0.000007770f, -0.000007775f, -0.000007780f,
    -0.000007784f, -0.000007788f, -0.000007791f, -0.000007793f, -0.000007794f,
    -0.000007795f, -0.000007795f, -0.000007795f, -0.000007794f, -0.000007792f,
    -0.000007790f, -0.000007787f, -0.000007784f, -0.000007780f, -0.000007775f,
    -0.000007770f, -0.000007764f, -0.000007758f, -0.000007751f, -0.000007743f,
    -0.000007735f, -0.000007726f, -0.000007717f, -0.000007708f, -0.000007698f,
    -0.000007687f, -0.000007675f, -0.000007663f, -0.000007651f, -0.000007638f,
    -0.000007625f, -0.000007611f, -0.000007597f, -0.000007582f, -0.000007567f,
    -0.000007551f, -0.000007535f, -0.000007518f, -0.000007501f, -0.000007483f,
    -0.000007465f, -0.000007446f, -0.000007427f, -0.000007408f, -0.000007388f,
    -0.000007368f, -0.000007347f, -0.000007326f, -0.000007305f, -0.000007283f,
    -0.000007261f, -0.000007238f, -0.000007215f, -0.000007191f, -0.000007168f,
    -0.000007143f, -0.000007119f, -0.000007094f, -0.000007068f, -0.000007043f,
    -0.000007017f, -0.000006991f, -0.000006964f, -0.000006937f, -0.000006909f,
    -0.000006882f, -0.000006854f, -0.000006826f, -0.000006797f, -0.000006768f,
    -0.000006739f, -0.000006710f, -0.000006680f, -0.000006650f, -0.000006620f,
    -0.000006589f, -0.000006558f, -0.000006527f, -0.000006496f, -0.000006464f,
    -0.000006432f, -0.000006400f, -0.000006368f, -0.000006336f, -0.000006303f,
    -0.000006270f, -0.000006237f, -0.000006203f, -0.000006170f, -0.000006136f,
    -0.000006102f, -0.000006068f, -0.000006033f, -0.000005999f, -0.000005964f,
    -0.000005929f, -0.000005894f, -0.000005859f, -0.000005823f, -0.000005788f,
    -0.000005752f, -0.000005716f, -0.000005680f, -0.000005644f, -0.000005608f,
    -0.000005571f, -0.000005535f, -0.000005498f, -0.000005461f, -0.000005424f,
    -0.000005388f, -0.000005350f, -0.000005313f, -0.000005276f, -0.000005239f,
    -0.000005201f, -0.000005164f, -0.000005126f, -0.000005088f, -0.000005051f,
    -0.000005013f, -0.000004975f, -0.000004937f, -0.000004899f, -0.000004861f,
    -0.000004823f, -0.000004784f, -0.000004746f, -0.000004708f, -0.000004670f,
    -0.000004632f, -0.000004593f, -0.000004555f, -0.000004517f, -0.000004478f,
    -0.000004440f, -0.000004401f, -0.000004363f, -0.000004324f, -0.000004286f,
    -0.000004248f, -0.000004210f, -0.000004171f, -0.000004133f, -0.000004095f,
    -0.000004056f, -0.000004018f, -0.000003980f, -0.000003942f, -0.000003904f,
    -0.000003865f, -0.000003827f, -0.000003789f, -0.000003751f, -0.000003714f,
    -0.000003676f, -0.000003638f, -0.000003600f, -0.000003562f, -0.000003525f,
    -0.000003487f, -0.000003450f, -0.000003412f, -0.000003375f, -0.000003338f,
    -0.000003301f, -0.000003264f, -0.000003227f, -0.000003190f, -0.000003153f,
    -0.000003117f, -0.000003080f, -0.000003044f, -0.000003007f, -0.000002971f,
    -0.000002935f, -0.000002899f, -0.000002863f, -0.000002827f, -0.000002791f,
    -0.000002756f, -0.000002720f, -0.000002685f, -0.000002650f, -0.000002615f,
    -0.000002580f, -0.000002545f, -0.000002511f, -0.000002476f, -0.000002442f,
    -0.000002408f, -0.000002373f, -0.000002340f, -0.000002306f, -0.000002272f,
    -0.000002239f, -0.000002205f, -0.000002172f, -0.000002139f, -0.000002106f,
    -0.000002074f, -0.000002041f, -0.000002009f, -0.000001977f, -0.000001945f,
    -0.000001913f, -0.000001881f, -0.000001850f, -0.000001818f, -0.000001787f,
    -0.000001756f, -0.000001726f, -0.000001695f, -0.000001665f, -0.000001634f,
    -0.000001604f, -0.000001574f, -0.000001545f, -0.000001515f, -0.000001486f,
    -0.000001457f, -0.000001428f, -0.000001399f, -0.000001371f, -0.000001342f,
    -0.000001314f, -0.000001286f, -0.000001258f, -0.000001231f, -0.000001203f,
    -0.000001176f, -0.000001149f, -0.000001123f, -0.000001096f, -0.000001070f,
    0.000000000f
};

/* vi: set ts=4 sw=4 expandtab: */

