﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/guardduty/model/MalwareProtectionConfigurationResult.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace GuardDuty
{
namespace Model
{

MalwareProtectionConfigurationResult::MalwareProtectionConfigurationResult() : 
    m_scanEc2InstanceWithFindingsHasBeenSet(false),
    m_serviceRoleHasBeenSet(false)
{
}

MalwareProtectionConfigurationResult::MalwareProtectionConfigurationResult(JsonView jsonValue) : 
    m_scanEc2InstanceWithFindingsHasBeenSet(false),
    m_serviceRoleHasBeenSet(false)
{
  *this = jsonValue;
}

MalwareProtectionConfigurationResult& MalwareProtectionConfigurationResult::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("scanEc2InstanceWithFindings"))
  {
    m_scanEc2InstanceWithFindings = jsonValue.GetObject("scanEc2InstanceWithFindings");

    m_scanEc2InstanceWithFindingsHasBeenSet = true;
  }

  if(jsonValue.ValueExists("serviceRole"))
  {
    m_serviceRole = jsonValue.GetString("serviceRole");

    m_serviceRoleHasBeenSet = true;
  }

  return *this;
}

JsonValue MalwareProtectionConfigurationResult::Jsonize() const
{
  JsonValue payload;

  if(m_scanEc2InstanceWithFindingsHasBeenSet)
  {
   payload.WithObject("scanEc2InstanceWithFindings", m_scanEc2InstanceWithFindings.Jsonize());

  }

  if(m_serviceRoleHasBeenSet)
  {
   payload.WithString("serviceRole", m_serviceRole);

  }

  return payload;
}

} // namespace Model
} // namespace GuardDuty
} // namespace Aws
