/*******************************************************************************
 * Copyright (C) 2022 Intel Corporation
 *
 * SPDX-License-Identifier: MIT
 ******************************************************************************/

#ifndef STATIC_HEADER_H
#define STATIC_HEADER_H

#include "igzip_lib.h"

#define LONG_BITS_CHECK 12
#define SHORT_BITS_CHECK 10
#if (LONG_BITS_CHECK == ISAL_DECODE_LONG_BITS) && (SHORT_BITS_CHECK == ISAL_DECODE_SHORT_BITS)
# define ISAL_STATIC_INFLATE_TABLE
#else
# warning "Incompatible compile time defines for optimized static inflate table."
#endif

struct inflate_huff_code_large static_lit_huff_code = {
	.short_code_lookup = {
		0x74000100, 0x84000050, 0x84000010, 0xc4000171,
		0x9400011d, 0x84000070, 0x84000030, 0x940000c0,
		0x74000108, 0x84000060, 0x84000020, 0x940000a0,
		0x84000000, 0x84000080, 0x84000040, 0x940000e0,
		0x74000104, 0x84000058, 0x84000018, 0x94000090,
		0xa4000139, 0x84000078, 0x84000038, 0x940000d0,
		0x8400010f, 0x84000068, 0x84000028, 0x940000b0,
		0x84000008, 0x84000088, 0x84000048, 0x940000f0,
		0x74000102, 0x84000054, 0x84000014, 0x36000060,
		0xa4000129, 0x84000074, 0x84000034, 0x940000c8,
		0x8400010b, 0x84000064, 0x84000024, 0x940000a8,
		0x84000004, 0x84000084, 0x84000044, 0x940000e8,
		0x74000106, 0x8400005c, 0x8400001c, 0x94000098,
		0xb4000151, 0x8400007c, 0x8400003c, 0x940000d8,
		0x94000115, 0x8400006c, 0x8400002c, 0x940000b8,
		0x8400000c, 0x8400008c, 0x8400004c, 0x940000f8,
		0x74000101, 0x84000052, 0x84000012, 0x36000020,
		0xa4000121, 0x84000072, 0x84000032, 0x940000c4,
		0x84000109, 0x84000062, 0x84000022, 0x940000a4,
		0x84000002, 0x84000082, 0x84000042, 0x940000e4,
		0x74000105, 0x8400005a, 0x8400001a, 0x94000094,
		0xb4000141, 0x8400007a, 0x8400003a, 0x940000d4,
		0x94000111, 0x8400006a, 0x8400002a, 0x940000b4,
		0x8400000a, 0x8400008a, 0x8400004a, 0x940000f4,
		0x74000103, 0x84000056, 0x84000016, 0x00000000,
		0xa4000131, 0x84000076, 0x84000036, 0x940000cc,
		0x8400010d, 0x84000066, 0x84000026, 0x940000ac,
		0x84000006, 0x84000086, 0x84000046, 0x940000ec,
		0x74000107, 0x8400005e, 0x8400001e, 0x9400009c,
		0xb4000161, 0x8400007e, 0x8400003e, 0x940000dc,
		0x94000119, 0x8400006e, 0x8400002e, 0x940000bc,
		0x8400000e, 0x8400008e, 0x8400004e, 0x940000fc,
		0x74000100, 0x84000051, 0x84000011, 0x36000000,
		0x9400011e, 0x84000071, 0x84000031, 0x940000c2,
		0x74000108, 0x84000061, 0x84000021, 0x940000a2,
		0x84000001, 0x84000081, 0x84000041, 0x940000e2,
		0x74000104, 0x84000059, 0x84000019, 0x94000092,
		0xa400013a, 0x84000079, 0x84000039, 0x940000d2,
		0x84000110, 0x84000069, 0x84000029, 0x940000b2,
		0x84000009, 0x84000089, 0x84000049, 0x940000f2,
		0x74000102, 0x84000055, 0x84000015, 0x84000200,
		0xa400012a, 0x84000075, 0x84000035, 0x940000ca,
		0x8400010c, 0x84000065, 0x84000025, 0x940000aa,
		0x84000005, 0x84000085, 0x84000045, 0x940000ea,
		0x74000106, 0x8400005d, 0x8400001d, 0x9400009a,
		0xb4000152, 0x8400007d, 0x8400003d, 0x940000da,
		0x94000116, 0x8400006d, 0x8400002d, 0x940000ba,
		0x8400000d, 0x8400008d, 0x8400004d, 0x940000fa,
		0x74000101, 0x84000053, 0x84000013, 0x36000040,
		0xa4000122, 0x84000073, 0x84000033, 0x940000c6,
		0x8400010a, 0x84000063, 0x84000023, 0x940000a6,
		0x84000003, 0x84000083, 0x84000043, 0x940000e6,
		0x74000105, 0x8400005b, 0x8400001b, 0x94000096,
		0xb4000142, 0x8400007b, 0x8400003b, 0x940000d6,
		0x94000112, 0x8400006b, 0x8400002b, 0x940000b6,
		0x8400000b, 0x8400008b, 0x8400004b, 0x940000f6,
		0x74000103, 0x84000057, 0x84000017, 0x00000000,
		0xa4000132, 0x84000077, 0x84000037, 0x940000ce,
		0x8400010e, 0x84000067, 0x84000027, 0x940000ae,
		0x84000007, 0x84000087, 0x84000047, 0x940000ee,
		0x74000107, 0x8400005f, 0x8400001f, 0x9400009e,
		0xb4000162, 0x8400007f, 0x8400003f, 0x940000de,
		0x9400011a, 0x8400006f, 0x8400002f, 0x940000be,
		0x8400000f, 0x8400008f, 0x8400004f, 0x940000fe,
		0x74000100, 0x84000050, 0x84000010, 0xc4000172,
		0x9400011f, 0x84000070, 0x84000030, 0x940000c1,
		0x74000108, 0x84000060, 0x84000020, 0x940000a1,
		0x84000000, 0x84000080, 0x84000040, 0x940000e1,
		0x74000104, 0x84000058, 0x84000018, 0x94000091,
		0xa400013b, 0x84000078, 0x84000038, 0x940000d1,
		0x8400010f, 0x84000068, 0x84000028, 0x940000b1,
		0x84000008, 0x84000088, 0x84000048, 0x940000f1,
		0x74000102, 0x84000054, 0x84000014, 0x36000062,
		0xa400012b, 0x84000074, 0x84000034, 0x940000c9,
		0x8400010b, 0x84000064, 0x84000024, 0x940000a9,
		0x84000004, 0x84000084, 0x84000044, 0x940000e9,
		0x74000106, 0x8400005c, 0x8400001c, 0x94000099,
		0xb4000153, 0x8400007c, 0x8400003c, 0x940000d9,
		0x94000117, 0x8400006c, 0x8400002c, 0x940000b9,
		0x8400000c, 0x8400008c, 0x8400004c, 0x940000f9,
		0x74000101, 0x84000052, 0x84000012, 0x36000022,
		0xa4000123, 0x84000072, 0x84000032, 0x940000c5,
		0x84000109, 0x84000062, 0x84000022, 0x940000a5,
		0x84000002, 0x84000082, 0x84000042, 0x940000e5,
		0x74000105, 0x8400005a, 0x8400001a, 0x94000095,
		0xb4000143, 0x8400007a, 0x8400003a, 0x940000d5,
		0x94000113, 0x8400006a, 0x8400002a, 0x940000b5,
		0x8400000a, 0x8400008a, 0x8400004a, 0x940000f5,
		0x74000103, 0x84000056, 0x84000016, 0x00000000,
		0xa4000133, 0x84000076, 0x84000036, 0x940000cd,
		0x8400010d, 0x84000066, 0x84000026, 0x940000ad,
		0x84000006, 0x84000086, 0x84000046, 0x940000ed,
		0x74000107, 0x8400005e, 0x8400001e, 0x9400009d,
		0xb4000163, 0x8400007e, 0x8400003e, 0x940000dd,
		0x9400011b, 0x8400006e, 0x8400002e, 0x940000bd,
		0x8400000e, 0x8400008e, 0x8400004e, 0x940000fd,
		0x74000100, 0x84000051, 0x84000011, 0x36000002,
		0x94000120, 0x84000071, 0x84000031, 0x940000c3,
		0x74000108, 0x84000061, 0x84000021, 0x940000a3,
		0x84000001, 0x84000081, 0x84000041, 0x940000e3,
		0x74000104, 0x84000059, 0x84000019, 0x94000093,
		0xa400013c, 0x84000079, 0x84000039, 0x940000d3,
		0x84000110, 0x84000069, 0x84000029, 0x940000b3,
		0x84000009, 0x84000089, 0x84000049, 0x940000f3,
		0x74000102, 0x84000055, 0x84000015, 0x84000200,
		0xa400012c, 0x84000075, 0x84000035, 0x940000cb,
		0x8400010c, 0x84000065, 0x84000025, 0x940000ab,
		0x84000005, 0x84000085, 0x84000045, 0x940000eb,
		0x74000106, 0x8400005d, 0x8400001d, 0x9400009b,
		0xb4000154, 0x8400007d, 0x8400003d, 0x940000db,
		0x94000118, 0x8400006d, 0x8400002d, 0x940000bb,
		0x8400000d, 0x8400008d, 0x8400004d, 0x940000fb,
		0x74000101, 0x84000053, 0x84000013, 0x36000042,
		0xa4000124, 0x84000073, 0x84000033, 0x940000c7,
		0x8400010a, 0x84000063, 0x84000023, 0x940000a7,
		0x84000003, 0x84000083, 0x84000043, 0x940000e7,
		0x74000105, 0x8400005b, 0x8400001b, 0x94000097,
		0xb4000144, 0x8400007b, 0x8400003b, 0x940000d7,
		0x94000114, 0x8400006b, 0x8400002b, 0x940000b7,
		0x8400000b, 0x8400008b, 0x8400004b, 0x940000f7,
		0x74000103, 0x84000057, 0x84000017, 0x00000000,
		0xa4000134, 0x84000077, 0x84000037, 0x940000cf,
		0x8400010e, 0x84000067, 0x84000027, 0x940000af,
		0x84000007, 0x84000087, 0x84000047, 0x940000ef,
		0x74000107, 0x8400005f, 0x8400001f, 0x9400009f,
		0xb4000164, 0x8400007f, 0x8400003f, 0x940000df,
		0x9400011c, 0x8400006f, 0x8400002f, 0x940000bf,
		0x8400000f, 0x8400008f, 0x8400004f, 0x940000ff,
		0x74000100, 0x84000050, 0x84000010, 0xc4000173,
		0x9400011d, 0x84000070, 0x84000030, 0x940000c0,
		0x74000108, 0x84000060, 0x84000020, 0x940000a0,
		0x84000000, 0x84000080, 0x84000040, 0x940000e0,
		0x74000104, 0x84000058, 0x84000018, 0x94000090,
		0xa400013d, 0x84000078, 0x84000038, 0x940000d0,
		0x8400010f, 0x84000068, 0x84000028, 0x940000b0,
		0x84000008, 0x84000088, 0x84000048, 0x940000f0,
		0x74000102, 0x84000054, 0x84000014, 0x36000064,
		0xa400012d, 0x84000074, 0x84000034, 0x940000c8,
		0x8400010b, 0x84000064, 0x84000024, 0x940000a8,
		0x84000004, 0x84000084, 0x84000044, 0x940000e8,
		0x74000106, 0x8400005c, 0x8400001c, 0x94000098,
		0xb4000155, 0x8400007c, 0x8400003c, 0x940000d8,
		0x94000115, 0x8400006c, 0x8400002c, 0x940000b8,
		0x8400000c, 0x8400008c, 0x8400004c, 0x940000f8,
		0x74000101, 0x84000052, 0x84000012, 0x36000024,
		0xa4000125, 0x84000072, 0x84000032, 0x940000c4,
		0x84000109, 0x84000062, 0x84000022, 0x940000a4,
		0x84000002, 0x84000082, 0x84000042, 0x940000e4,
		0x74000105, 0x8400005a, 0x8400001a, 0x94000094,
		0xb4000145, 0x8400007a, 0x8400003a, 0x940000d4,
		0x94000111, 0x8400006a, 0x8400002a, 0x940000b4,
		0x8400000a, 0x8400008a, 0x8400004a, 0x940000f4,
		0x74000103, 0x84000056, 0x84000016, 0x00000000,
		0xa4000135, 0x84000076, 0x84000036, 0x940000cc,
		0x8400010d, 0x84000066, 0x84000026, 0x940000ac,
		0x84000006, 0x84000086, 0x84000046, 0x940000ec,
		0x74000107, 0x8400005e, 0x8400001e, 0x9400009c,
		0xb4000165, 0x8400007e, 0x8400003e, 0x940000dc,
		0x94000119, 0x8400006e, 0x8400002e, 0x940000bc,
		0x8400000e, 0x8400008e, 0x8400004e, 0x940000fc,
		0x74000100, 0x84000051, 0x84000011, 0x36000004,
		0x9400011e, 0x84000071, 0x84000031, 0x940000c2,
		0x74000108, 0x84000061, 0x84000021, 0x940000a2,
		0x84000001, 0x84000081, 0x84000041, 0x940000e2,
		0x74000104, 0x84000059, 0x84000019, 0x94000092,
		0xa400013e, 0x84000079, 0x84000039, 0x940000d2,
		0x84000110, 0x84000069, 0x84000029, 0x940000b2,
		0x84000009, 0x84000089, 0x84000049, 0x940000f2,
		0x74000102, 0x84000055, 0x84000015, 0x84000200,
		0xa400012e, 0x84000075, 0x84000035, 0x940000ca,
		0x8400010c, 0x84000065, 0x84000025, 0x940000aa,
		0x84000005, 0x84000085, 0x84000045, 0x940000ea,
		0x74000106, 0x8400005d, 0x8400001d, 0x9400009a,
		0xb4000156, 0x8400007d, 0x8400003d, 0x940000da,
		0x94000116, 0x8400006d, 0x8400002d, 0x940000ba,
		0x8400000d, 0x8400008d, 0x8400004d, 0x940000fa,
		0x74000101, 0x84000053, 0x84000013, 0x36000044,
		0xa4000126, 0x84000073, 0x84000033, 0x940000c6,
		0x8400010a, 0x84000063, 0x84000023, 0x940000a6,
		0x84000003, 0x84000083, 0x84000043, 0x940000e6,
		0x74000105, 0x8400005b, 0x8400001b, 0x94000096,
		0xb4000146, 0x8400007b, 0x8400003b, 0x940000d6,
		0x94000112, 0x8400006b, 0x8400002b, 0x940000b6,
		0x8400000b, 0x8400008b, 0x8400004b, 0x940000f6,
		0x74000103, 0x84000057, 0x84000017, 0x00000000,
		0xa4000136, 0x84000077, 0x84000037, 0x940000ce,
		0x8400010e, 0x84000067, 0x84000027, 0x940000ae,
		0x84000007, 0x84000087, 0x84000047, 0x940000ee,
		0x74000107, 0x8400005f, 0x8400001f, 0x9400009e,
		0xb4000166, 0x8400007f, 0x8400003f, 0x940000de,
		0x9400011a, 0x8400006f, 0x8400002f, 0x940000be,
		0x8400000f, 0x8400008f, 0x8400004f, 0x940000fe,
		0x74000100, 0x84000050, 0x84000010, 0xc4000174,
		0x9400011f, 0x84000070, 0x84000030, 0x940000c1,
		0x74000108, 0x84000060, 0x84000020, 0x940000a1,
		0x84000000, 0x84000080, 0x84000040, 0x940000e1,
		0x74000104, 0x84000058, 0x84000018, 0x94000091,
		0xa400013f, 0x84000078, 0x84000038, 0x940000d1,
		0x8400010f, 0x84000068, 0x84000028, 0x940000b1,
		0x84000008, 0x84000088, 0x84000048, 0x940000f1,
		0x74000102, 0x84000054, 0x84000014, 0x36000066,
		0xa400012f, 0x84000074, 0x84000034, 0x940000c9,
		0x8400010b, 0x84000064, 0x84000024, 0x940000a9,
		0x84000004, 0x84000084, 0x84000044, 0x940000e9,
		0x74000106, 0x8400005c, 0x8400001c, 0x94000099,
		0xb4000157, 0x8400007c, 0x8400003c, 0x940000d9,
		0x94000117, 0x8400006c, 0x8400002c, 0x940000b9,
		0x8400000c, 0x8400008c, 0x8400004c, 0x940000f9,
		0x74000101, 0x84000052, 0x84000012, 0x36000026,
		0xa4000127, 0x84000072, 0x84000032, 0x940000c5,
		0x84000109, 0x84000062, 0x84000022, 0x940000a5,
		0x84000002, 0x84000082, 0x84000042, 0x940000e5,
		0x74000105, 0x8400005a, 0x8400001a, 0x94000095,
		0xb4000147, 0x8400007a, 0x8400003a, 0x940000d5,
		0x94000113, 0x8400006a, 0x8400002a, 0x940000b5,
		0x8400000a, 0x8400008a, 0x8400004a, 0x940000f5,
		0x74000103, 0x84000056, 0x84000016, 0x00000000,
		0xa4000137, 0x84000076, 0x84000036, 0x940000cd,
		0x8400010d, 0x84000066, 0x84000026, 0x940000ad,
		0x84000006, 0x84000086, 0x84000046, 0x940000ed,
		0x74000107, 0x8400005e, 0x8400001e, 0x9400009d,
		0xb4000167, 0x8400007e, 0x8400003e, 0x940000dd,
		0x9400011b, 0x8400006e, 0x8400002e, 0x940000bd,
		0x8400000e, 0x8400008e, 0x8400004e, 0x940000fd,
		0x74000100, 0x84000051, 0x84000011, 0x36000006,
		0x94000120, 0x84000071, 0x84000031, 0x940000c3,
		0x74000108, 0x84000061, 0x84000021, 0x940000a3,
		0x84000001, 0x84000081, 0x84000041, 0x940000e3,
		0x74000104, 0x84000059, 0x84000019, 0x94000093,
		0xa4000140, 0x84000079, 0x84000039, 0x940000d3,
		0x84000110, 0x84000069, 0x84000029, 0x940000b3,
		0x84000009, 0x84000089, 0x84000049, 0x940000f3,
		0x74000102, 0x84000055, 0x84000015, 0x84000200,
		0xa4000130, 0x84000075, 0x84000035, 0x940000cb,
		0x8400010c, 0x84000065, 0x84000025, 0x940000ab,
		0x84000005, 0x84000085, 0x84000045, 0x940000eb,
		0x74000106, 0x8400005d, 0x8400001d, 0x9400009b,
		0xb4000158, 0x8400007d, 0x8400003d, 0x940000db,
		0x94000118, 0x8400006d, 0x8400002d, 0x940000bb,
		0x8400000d, 0x8400008d, 0x8400004d, 0x940000fb,
		0x74000101, 0x84000053, 0x84000013, 0x36000046,
		0xa4000128, 0x84000073, 0x84000033, 0x940000c7,
		0x8400010a, 0x84000063, 0x84000023, 0x940000a7,
		0x84000003, 0x84000083, 0x84000043, 0x940000e7,
		0x74000105, 0x8400005b, 0x8400001b, 0x94000097,
		0xb4000148, 0x8400007b, 0x8400003b, 0x940000d7,
		0x94000114, 0x8400006b, 0x8400002b, 0x940000b7,
		0x8400000b, 0x8400008b, 0x8400004b, 0x940000f7,
		0x74000103, 0x84000057, 0x84000017, 0x00000000,
		0xa4000138, 0x84000077, 0x84000037, 0x940000cf,
		0x8400010e, 0x84000067, 0x84000027, 0x940000af,
		0x84000007, 0x84000087, 0x84000047, 0x940000ef,
		0x74000107, 0x8400005f, 0x8400001f, 0x9400009f,
		0xb4000168, 0x8400007f, 0x8400003f, 0x940000df,
		0x9400011c, 0x8400006f, 0x8400002f, 0x940000bf,
		0x8400000f, 0x8400008f, 0x8400004f, 0x940000ff,
		0x74000100, 0x84000050, 0x84000010, 0xc4000175,
		0x9400011d, 0x84000070, 0x84000030, 0x940000c0,
		0x74000108, 0x84000060, 0x84000020, 0x940000a0,
		0x84000000, 0x84000080, 0x84000040, 0x940000e0,
		0x74000104, 0x84000058, 0x84000018, 0x94000090,
		0xa4000139, 0x84000078, 0x84000038, 0x940000d0,
		0x8400010f, 0x84000068, 0x84000028, 0x940000b0,
		0x84000008, 0x84000088, 0x84000048, 0x940000f0,
		0x74000102, 0x84000054, 0x84000014, 0x36000068,
		0xa4000129, 0x84000074, 0x84000034, 0x940000c8,
		0x8400010b, 0x84000064, 0x84000024, 0x940000a8,
		0x84000004, 0x84000084, 0x84000044, 0x940000e8,
		0x74000106, 0x8400005c, 0x8400001c, 0x94000098,
		0xb4000159, 0x8400007c, 0x8400003c, 0x940000d8,
		0x94000115, 0x8400006c, 0x8400002c, 0x940000b8,
		0x8400000c, 0x8400008c, 0x8400004c, 0x940000f8,
		0x74000101, 0x84000052, 0x84000012, 0x36000028,
		0xa4000121, 0x84000072, 0x84000032, 0x940000c4,
		0x84000109, 0x84000062, 0x84000022, 0x940000a4,
		0x84000002, 0x84000082, 0x84000042, 0x940000e4,
		0x74000105, 0x8400005a, 0x8400001a, 0x94000094,
		0xb4000149, 0x8400007a, 0x8400003a, 0x940000d4,
		0x94000111, 0x8400006a, 0x8400002a, 0x940000b4,
		0x8400000a, 0x8400008a, 0x8400004a, 0x940000f4,
		0x74000103, 0x84000056, 0x84000016, 0x00000000,
		0xa4000131, 0x84000076, 0x84000036, 0x940000cc,
		0x8400010d, 0x84000066, 0x84000026, 0x940000ac,
		0x84000006, 0x84000086, 0x84000046, 0x940000ec,
		0x74000107, 0x8400005e, 0x8400001e, 0x9400009c,
		0xb4000169, 0x8400007e, 0x8400003e, 0x940000dc,
		0x94000119, 0x8400006e, 0x8400002e, 0x940000bc,
		0x8400000e, 0x8400008e, 0x8400004e, 0x940000fc,
		0x74000100, 0x84000051, 0x84000011, 0x36000008,
		0x9400011e, 0x84000071, 0x84000031, 0x940000c2,
		0x74000108, 0x84000061, 0x84000021, 0x940000a2,
		0x84000001, 0x84000081, 0x84000041, 0x940000e2,
		0x74000104, 0x84000059, 0x84000019, 0x94000092,
		0xa400013a, 0x84000079, 0x84000039, 0x940000d2,
		0x84000110, 0x84000069, 0x84000029, 0x940000b2,
		0x84000009, 0x84000089, 0x84000049, 0x940000f2,
		0x74000102, 0x84000055, 0x84000015, 0x84000200,
		0xa400012a, 0x84000075, 0x84000035, 0x940000ca,
		0x8400010c, 0x84000065, 0x84000025, 0x940000aa,
		0x84000005, 0x84000085, 0x84000045, 0x940000ea,
		0x74000106, 0x8400005d, 0x8400001d, 0x9400009a,
		0xb400015a, 0x8400007d, 0x8400003d, 0x940000da,
		0x94000116, 0x8400006d, 0x8400002d, 0x940000ba,
		0x8400000d, 0x8400008d, 0x8400004d, 0x940000fa,
		0x74000101, 0x84000053, 0x84000013, 0x36000048,
		0xa4000122, 0x84000073, 0x84000033, 0x940000c6,
		0x8400010a, 0x84000063, 0x84000023, 0x940000a6,
		0x84000003, 0x84000083, 0x84000043, 0x940000e6,
		0x74000105, 0x8400005b, 0x8400001b, 0x94000096,
		0xb400014a, 0x8400007b, 0x8400003b, 0x940000d6,
		0x94000112, 0x8400006b, 0x8400002b, 0x940000b6,
		0x8400000b, 0x8400008b, 0x8400004b, 0x940000f6,
		0x74000103, 0x84000057, 0x84000017, 0x00000000,
		0xa4000132, 0x84000077, 0x84000037, 0x940000ce,
		0x8400010e, 0x84000067, 0x84000027, 0x940000ae,
		0x84000007, 0x84000087, 0x84000047, 0x940000ee,
		0x74000107, 0x8400005f, 0x8400001f, 0x9400009e,
		0xb400016a, 0x8400007f, 0x8400003f, 0x940000de,
		0x9400011a, 0x8400006f, 0x8400002f, 0x940000be,
		0x8400000f, 0x8400008f, 0x8400004f, 0x940000fe,
		0x74000100, 0x84000050, 0x84000010, 0xc4000176,
		0x9400011f, 0x84000070, 0x84000030, 0x940000c1,
		0x74000108, 0x84000060, 0x84000020, 0x940000a1,
		0x84000000, 0x84000080, 0x84000040, 0x940000e1,
		0x74000104, 0x84000058, 0x84000018, 0x94000091,
		0xa400013b, 0x84000078, 0x84000038, 0x940000d1,
		0x8400010f, 0x84000068, 0x84000028, 0x940000b1,
		0x84000008, 0x84000088, 0x84000048, 0x940000f1,
		0x74000102, 0x84000054, 0x84000014, 0x3600006a,
		0xa400012b, 0x84000074, 0x84000034, 0x940000c9,
		0x8400010b, 0x84000064, 0x84000024, 0x940000a9,
		0x84000004, 0x84000084, 0x84000044, 0x940000e9,
		0x74000106, 0x8400005c, 0x8400001c, 0x94000099,
		0xb400015b, 0x8400007c, 0x8400003c, 0x940000d9,
		0x94000117, 0x8400006c, 0x8400002c, 0x940000b9,
		0x8400000c, 0x8400008c, 0x8400004c, 0x940000f9,
		0x74000101, 0x84000052, 0x84000012, 0x3600002a,
		0xa4000123, 0x84000072, 0x84000032, 0x940000c5,
		0x84000109, 0x84000062, 0x84000022, 0x940000a5,
		0x84000002, 0x84000082, 0x84000042, 0x940000e5,
		0x74000105, 0x8400005a, 0x8400001a, 0x94000095,
		0xb400014b, 0x8400007a, 0x8400003a, 0x940000d5,
		0x94000113, 0x8400006a, 0x8400002a, 0x940000b5,
		0x8400000a, 0x8400008a, 0x8400004a, 0x940000f5,
		0x74000103, 0x84000056, 0x84000016, 0x00000000,
		0xa4000133, 0x84000076, 0x84000036, 0x940000cd,
		0x8400010d, 0x84000066, 0x84000026, 0x940000ad,
		0x84000006, 0x84000086, 0x84000046, 0x940000ed,
		0x74000107, 0x8400005e, 0x8400001e, 0x9400009d,
		0xb400016b, 0x8400007e, 0x8400003e, 0x940000dd,
		0x9400011b, 0x8400006e, 0x8400002e, 0x940000bd,
		0x8400000e, 0x8400008e, 0x8400004e, 0x940000fd,
		0x74000100, 0x84000051, 0x84000011, 0x3600000a,
		0x94000120, 0x84000071, 0x84000031, 0x940000c3,
		0x74000108, 0x84000061, 0x84000021, 0x940000a3,
		0x84000001, 0x84000081, 0x84000041, 0x940000e3,
		0x74000104, 0x84000059, 0x84000019, 0x94000093,
		0xa400013c, 0x84000079, 0x84000039, 0x940000d3,
		0x84000110, 0x84000069, 0x84000029, 0x940000b3,
		0x84000009, 0x84000089, 0x84000049, 0x940000f3,
		0x74000102, 0x84000055, 0x84000015, 0x84000200,
		0xa400012c, 0x84000075, 0x84000035, 0x940000cb,
		0x8400010c, 0x84000065, 0x84000025, 0x940000ab,
		0x84000005, 0x84000085, 0x84000045, 0x940000eb,
		0x74000106, 0x8400005d, 0x8400001d, 0x9400009b,
		0xb400015c, 0x8400007d, 0x8400003d, 0x940000db,
		0x94000118, 0x8400006d, 0x8400002d, 0x940000bb,
		0x8400000d, 0x8400008d, 0x8400004d, 0x940000fb,
		0x74000101, 0x84000053, 0x84000013, 0x3600004a,
		0xa4000124, 0x84000073, 0x84000033, 0x940000c7,
		0x8400010a, 0x84000063, 0x84000023, 0x940000a7,
		0x84000003, 0x84000083, 0x84000043, 0x940000e7,
		0x74000105, 0x8400005b, 0x8400001b, 0x94000097,
		0xb400014c, 0x8400007b, 0x8400003b, 0x940000d7,
		0x94000114, 0x8400006b, 0x8400002b, 0x940000b7,
		0x8400000b, 0x8400008b, 0x8400004b, 0x940000f7,
		0x74000103, 0x84000057, 0x84000017, 0x00000000,
		0xa4000134, 0x84000077, 0x84000037, 0x940000cf,
		0x8400010e, 0x84000067, 0x84000027, 0x940000af,
		0x84000007, 0x84000087, 0x84000047, 0x940000ef,
		0x74000107, 0x8400005f, 0x8400001f, 0x9400009f,
		0xb400016c, 0x8400007f, 0x8400003f, 0x940000df,
		0x9400011c, 0x8400006f, 0x8400002f, 0x940000bf,
		0x8400000f, 0x8400008f, 0x8400004f, 0x940000ff,
		0x74000100, 0x84000050, 0x84000010, 0xc4000177,
		0x9400011d, 0x84000070, 0x84000030, 0x940000c0,
		0x74000108, 0x84000060, 0x84000020, 0x940000a0,
		0x84000000, 0x84000080, 0x84000040, 0x940000e0,
		0x74000104, 0x84000058, 0x84000018, 0x94000090,
		0xa400013d, 0x84000078, 0x84000038, 0x940000d0,
		0x8400010f, 0x84000068, 0x84000028, 0x940000b0,
		0x84000008, 0x84000088, 0x84000048, 0x940000f0,
		0x74000102, 0x84000054, 0x84000014, 0x3600006c,
		0xa400012d, 0x84000074, 0x84000034, 0x940000c8,
		0x8400010b, 0x84000064, 0x84000024, 0x940000a8,
		0x84000004, 0x84000084, 0x84000044, 0x940000e8,
		0x74000106, 0x8400005c, 0x8400001c, 0x94000098,
		0xb400015d, 0x8400007c, 0x8400003c, 0x940000d8,
		0x94000115, 0x8400006c, 0x8400002c, 0x940000b8,
		0x8400000c, 0x8400008c, 0x8400004c, 0x940000f8,
		0x74000101, 0x84000052, 0x84000012, 0x3600002c,
		0xa4000125, 0x84000072, 0x84000032, 0x940000c4,
		0x84000109, 0x84000062, 0x84000022, 0x940000a4,
		0x84000002, 0x84000082, 0x84000042, 0x940000e4,
		0x74000105, 0x8400005a, 0x8400001a, 0x94000094,
		0xb400014d, 0x8400007a, 0x8400003a, 0x940000d4,
		0x94000111, 0x8400006a, 0x8400002a, 0x940000b4,
		0x8400000a, 0x8400008a, 0x8400004a, 0x940000f4,
		0x74000103, 0x84000056, 0x84000016, 0x00000000,
		0xa4000135, 0x84000076, 0x84000036, 0x940000cc,
		0x8400010d, 0x84000066, 0x84000026, 0x940000ac,
		0x84000006, 0x84000086, 0x84000046, 0x940000ec,
		0x74000107, 0x8400005e, 0x8400001e, 0x9400009c,
		0xb400016d, 0x8400007e, 0x8400003e, 0x940000dc,
		0x94000119, 0x8400006e, 0x8400002e, 0x940000bc,
		0x8400000e, 0x8400008e, 0x8400004e, 0x940000fc,
		0x74000100, 0x84000051, 0x84000011, 0x3600000c,
		0x9400011e, 0x84000071, 0x84000031, 0x940000c2,
		0x74000108, 0x84000061, 0x84000021, 0x940000a2,
		0x84000001, 0x84000081, 0x84000041, 0x940000e2,
		0x74000104, 0x84000059, 0x84000019, 0x94000092,
		0xa400013e, 0x84000079, 0x84000039, 0x940000d2,
		0x84000110, 0x84000069, 0x84000029, 0x940000b2,
		0x84000009, 0x84000089, 0x84000049, 0x940000f2,
		0x74000102, 0x84000055, 0x84000015, 0x84000200,
		0xa400012e, 0x84000075, 0x84000035, 0x940000ca,
		0x8400010c, 0x84000065, 0x84000025, 0x940000aa,
		0x84000005, 0x84000085, 0x84000045, 0x940000ea,
		0x74000106, 0x8400005d, 0x8400001d, 0x9400009a,
		0xb400015e, 0x8400007d, 0x8400003d, 0x940000da,
		0x94000116, 0x8400006d, 0x8400002d, 0x940000ba,
		0x8400000d, 0x8400008d, 0x8400004d, 0x940000fa,
		0x74000101, 0x84000053, 0x84000013, 0x3600004c,
		0xa4000126, 0x84000073, 0x84000033, 0x940000c6,
		0x8400010a, 0x84000063, 0x84000023, 0x940000a6,
		0x84000003, 0x84000083, 0x84000043, 0x940000e6,
		0x74000105, 0x8400005b, 0x8400001b, 0x94000096,
		0xb400014e, 0x8400007b, 0x8400003b, 0x940000d6,
		0x94000112, 0x8400006b, 0x8400002b, 0x940000b6,
		0x8400000b, 0x8400008b, 0x8400004b, 0x940000f6,
		0x74000103, 0x84000057, 0x84000017, 0x00000000,
		0xa4000136, 0x84000077, 0x84000037, 0x940000ce,
		0x8400010e, 0x84000067, 0x84000027, 0x940000ae,
		0x84000007, 0x84000087, 0x84000047, 0x940000ee,
		0x74000107, 0x8400005f, 0x8400001f, 0x9400009e,
		0xb400016e, 0x8400007f, 0x8400003f, 0x940000de,
		0x9400011a, 0x8400006f, 0x8400002f, 0x940000be,
		0x8400000f, 0x8400008f, 0x8400004f, 0x940000fe,
		0x74000100, 0x84000050, 0x84000010, 0xc4000178,
		0x9400011f, 0x84000070, 0x84000030, 0x940000c1,
		0x74000108, 0x84000060, 0x84000020, 0x940000a1,
		0x84000000, 0x84000080, 0x84000040, 0x940000e1,
		0x74000104, 0x84000058, 0x84000018, 0x94000091,
		0xa400013f, 0x84000078, 0x84000038, 0x940000d1,
		0x8400010f, 0x84000068, 0x84000028, 0x940000b1,
		0x84000008, 0x84000088, 0x84000048, 0x940000f1,
		0x74000102, 0x84000054, 0x84000014, 0x3600006e,
		0xa400012f, 0x84000074, 0x84000034, 0x940000c9,
		0x8400010b, 0x84000064, 0x84000024, 0x940000a9,
		0x84000004, 0x84000084, 0x84000044, 0x940000e9,
		0x74000106, 0x8400005c, 0x8400001c, 0x94000099,
		0xb400015f, 0x8400007c, 0x8400003c, 0x940000d9,
		0x94000117, 0x8400006c, 0x8400002c, 0x940000b9,
		0x8400000c, 0x8400008c, 0x8400004c, 0x940000f9,
		0x74000101, 0x84000052, 0x84000012, 0x3600002e,
		0xa4000127, 0x84000072, 0x84000032, 0x940000c5,
		0x84000109, 0x84000062, 0x84000022, 0x940000a5,
		0x84000002, 0x84000082, 0x84000042, 0x940000e5,
		0x74000105, 0x8400005a, 0x8400001a, 0x94000095,
		0xb400014f, 0x8400007a, 0x8400003a, 0x940000d5,
		0x94000113, 0x8400006a, 0x8400002a, 0x940000b5,
		0x8400000a, 0x8400008a, 0x8400004a, 0x940000f5,
		0x74000103, 0x84000056, 0x84000016, 0x00000000,
		0xa4000137, 0x84000076, 0x84000036, 0x940000cd,
		0x8400010d, 0x84000066, 0x84000026, 0x940000ad,
		0x84000006, 0x84000086, 0x84000046, 0x940000ed,
		0x74000107, 0x8400005e, 0x8400001e, 0x9400009d,
		0xb400016f, 0x8400007e, 0x8400003e, 0x940000dd,
		0x9400011b, 0x8400006e, 0x8400002e, 0x940000bd,
		0x8400000e, 0x8400008e, 0x8400004e, 0x940000fd,
		0x74000100, 0x84000051, 0x84000011, 0x3600000e,
		0x94000120, 0x84000071, 0x84000031, 0x940000c3,
		0x74000108, 0x84000061, 0x84000021, 0x940000a3,
		0x84000001, 0x84000081, 0x84000041, 0x940000e3,
		0x74000104, 0x84000059, 0x84000019, 0x94000093,
		0xa4000140, 0x84000079, 0x84000039, 0x940000d3,
		0x84000110, 0x84000069, 0x84000029, 0x940000b3,
		0x84000009, 0x84000089, 0x84000049, 0x940000f3,
		0x74000102, 0x84000055, 0x84000015, 0x84000200,
		0xa4000130, 0x84000075, 0x84000035, 0x940000cb,
		0x8400010c, 0x84000065, 0x84000025, 0x940000ab,
		0x84000005, 0x84000085, 0x84000045, 0x940000eb,
		0x74000106, 0x8400005d, 0x8400001d, 0x9400009b,
		0xb4000160, 0x8400007d, 0x8400003d, 0x940000db,
		0x94000118, 0x8400006d, 0x8400002d, 0x940000bb,
		0x8400000d, 0x8400008d, 0x8400004d, 0x940000fb,
		0x74000101, 0x84000053, 0x84000013, 0x3600004e,
		0xa4000128, 0x84000073, 0x84000033, 0x940000c7,
		0x8400010a, 0x84000063, 0x84000023, 0x940000a7,
		0x84000003, 0x84000083, 0x84000043, 0x940000e7,
		0x74000105, 0x8400005b, 0x8400001b, 0x94000097,
		0xb4000150, 0x8400007b, 0x8400003b, 0x940000d7,
		0x94000114, 0x8400006b, 0x8400002b, 0x940000b7,
		0x8400000b, 0x8400008b, 0x8400004b, 0x940000f7,
		0x74000103, 0x84000057, 0x84000017, 0x00000000,
		0xa4000138, 0x84000077, 0x84000037, 0x940000cf,
		0x8400010e, 0x84000067, 0x84000027, 0x940000af,
		0x84000007, 0x84000087, 0x84000047, 0x940000ef,
		0x74000107, 0x8400005f, 0x8400001f, 0x9400009f,
		0xb4000170, 0x8400007f, 0x8400003f, 0x940000df,
		0x9400011c, 0x8400006f, 0x8400002f, 0x940000bf,
		0x8400000f, 0x8400008f, 0x8400004f, 0x940000ff,
		0x74000100, 0x84000050, 0x84000010, 0xc4000179,
		0x9400011d, 0x84000070, 0x84000030, 0x940000c0,
		0x74000108, 0x84000060, 0x84000020, 0x940000a0,
		0x84000000, 0x84000080, 0x84000040, 0x940000e0,
		0x74000104, 0x84000058, 0x84000018, 0x94000090,
		0xa4000139, 0x84000078, 0x84000038, 0x940000d0,
		0x8400010f, 0x84000068, 0x84000028, 0x940000b0,
		0x84000008, 0x84000088, 0x84000048, 0x940000f0,
		0x74000102, 0x84000054, 0x84000014, 0x36000070,
		0xa4000129, 0x84000074, 0x84000034, 0x940000c8,
		0x8400010b, 0x84000064, 0x84000024, 0x940000a8,
		0x84000004, 0x84000084, 0x84000044, 0x940000e8,
		0x74000106, 0x8400005c, 0x8400001c, 0x94000098,
		0xb4000151, 0x8400007c, 0x8400003c, 0x940000d8,
		0x94000115, 0x8400006c, 0x8400002c, 0x940000b8,
		0x8400000c, 0x8400008c, 0x8400004c, 0x940000f8,
		0x74000101, 0x84000052, 0x84000012, 0x36000030,
		0xa4000121, 0x84000072, 0x84000032, 0x940000c4,
		0x84000109, 0x84000062, 0x84000022, 0x940000a4,
		0x84000002, 0x84000082, 0x84000042, 0x940000e4,
		0x74000105, 0x8400005a, 0x8400001a, 0x94000094,
		0xb4000141, 0x8400007a, 0x8400003a, 0x940000d4,
		0x94000111, 0x8400006a, 0x8400002a, 0x940000b4,
		0x8400000a, 0x8400008a, 0x8400004a, 0x940000f4,
		0x74000103, 0x84000056, 0x84000016, 0x00000000,
		0xa4000131, 0x84000076, 0x84000036, 0x940000cc,
		0x8400010d, 0x84000066, 0x84000026, 0x940000ac,
		0x84000006, 0x84000086, 0x84000046, 0x940000ec,
		0x74000107, 0x8400005e, 0x8400001e, 0x9400009c,
		0xb4000161, 0x8400007e, 0x8400003e, 0x940000dc,
		0x94000119, 0x8400006e, 0x8400002e, 0x940000bc,
		0x8400000e, 0x8400008e, 0x8400004e, 0x940000fc,
		0x74000100, 0x84000051, 0x84000011, 0x36000010,
		0x9400011e, 0x84000071, 0x84000031, 0x940000c2,
		0x74000108, 0x84000061, 0x84000021, 0x940000a2,
		0x84000001, 0x84000081, 0x84000041, 0x940000e2,
		0x74000104, 0x84000059, 0x84000019, 0x94000092,
		0xa400013a, 0x84000079, 0x84000039, 0x940000d2,
		0x84000110, 0x84000069, 0x84000029, 0x940000b2,
		0x84000009, 0x84000089, 0x84000049, 0x940000f2,
		0x74000102, 0x84000055, 0x84000015, 0x84000200,
		0xa400012a, 0x84000075, 0x84000035, 0x940000ca,
		0x8400010c, 0x84000065, 0x84000025, 0x940000aa,
		0x84000005, 0x84000085, 0x84000045, 0x940000ea,
		0x74000106, 0x8400005d, 0x8400001d, 0x9400009a,
		0xb4000152, 0x8400007d, 0x8400003d, 0x940000da,
		0x94000116, 0x8400006d, 0x8400002d, 0x940000ba,
		0x8400000d, 0x8400008d, 0x8400004d, 0x940000fa,
		0x74000101, 0x84000053, 0x84000013, 0x36000050,
		0xa4000122, 0x84000073, 0x84000033, 0x940000c6,
		0x8400010a, 0x84000063, 0x84000023, 0x940000a6,
		0x84000003, 0x84000083, 0x84000043, 0x940000e6,
		0x74000105, 0x8400005b, 0x8400001b, 0x94000096,
		0xb4000142, 0x8400007b, 0x8400003b, 0x940000d6,
		0x94000112, 0x8400006b, 0x8400002b, 0x940000b6,
		0x8400000b, 0x8400008b, 0x8400004b, 0x940000f6,
		0x74000103, 0x84000057, 0x84000017, 0x00000000,
		0xa4000132, 0x84000077, 0x84000037, 0x940000ce,
		0x8400010e, 0x84000067, 0x84000027, 0x940000ae,
		0x84000007, 0x84000087, 0x84000047, 0x940000ee,
		0x74000107, 0x8400005f, 0x8400001f, 0x9400009e,
		0xb4000162, 0x8400007f, 0x8400003f, 0x940000de,
		0x9400011a, 0x8400006f, 0x8400002f, 0x940000be,
		0x8400000f, 0x8400008f, 0x8400004f, 0x940000fe,
		0x74000100, 0x84000050, 0x84000010, 0xc400017a,
		0x9400011f, 0x84000070, 0x84000030, 0x940000c1,
		0x74000108, 0x84000060, 0x84000020, 0x940000a1,
		0x84000000, 0x84000080, 0x84000040, 0x940000e1,
		0x74000104, 0x84000058, 0x84000018, 0x94000091,
		0xa400013b, 0x84000078, 0x84000038, 0x940000d1,
		0x8400010f, 0x84000068, 0x84000028, 0x940000b1,
		0x84000008, 0x84000088, 0x84000048, 0x940000f1,
		0x74000102, 0x84000054, 0x84000014, 0x36000072,
		0xa400012b, 0x84000074, 0x84000034, 0x940000c9,
		0x8400010b, 0x84000064, 0x84000024, 0x940000a9,
		0x84000004, 0x84000084, 0x84000044, 0x940000e9,
		0x74000106, 0x8400005c, 0x8400001c, 0x94000099,
		0xb4000153, 0x8400007c, 0x8400003c, 0x940000d9,
		0x94000117, 0x8400006c, 0x8400002c, 0x940000b9,
		0x8400000c, 0x8400008c, 0x8400004c, 0x940000f9,
		0x74000101, 0x84000052, 0x84000012, 0x36000032,
		0xa4000123, 0x84000072, 0x84000032, 0x940000c5,
		0x84000109, 0x84000062, 0x84000022, 0x940000a5,
		0x84000002, 0x84000082, 0x84000042, 0x940000e5,
		0x74000105, 0x8400005a, 0x8400001a, 0x94000095,
		0xb4000143, 0x8400007a, 0x8400003a, 0x940000d5,
		0x94000113, 0x8400006a, 0x8400002a, 0x940000b5,
		0x8400000a, 0x8400008a, 0x8400004a, 0x940000f5,
		0x74000103, 0x84000056, 0x84000016, 0x00000000,
		0xa4000133, 0x84000076, 0x84000036, 0x940000cd,
		0x8400010d, 0x84000066, 0x84000026, 0x940000ad,
		0x84000006, 0x84000086, 0x84000046, 0x940000ed,
		0x74000107, 0x8400005e, 0x8400001e, 0x9400009d,
		0xb4000163, 0x8400007e, 0x8400003e, 0x940000dd,
		0x9400011b, 0x8400006e, 0x8400002e, 0x940000bd,
		0x8400000e, 0x8400008e, 0x8400004e, 0x940000fd,
		0x74000100, 0x84000051, 0x84000011, 0x36000012,
		0x94000120, 0x84000071, 0x84000031, 0x940000c3,
		0x74000108, 0x84000061, 0x84000021, 0x940000a3,
		0x84000001, 0x84000081, 0x84000041, 0x940000e3,
		0x74000104, 0x84000059, 0x84000019, 0x94000093,
		0xa400013c, 0x84000079, 0x84000039, 0x940000d3,
		0x84000110, 0x84000069, 0x84000029, 0x940000b3,
		0x84000009, 0x84000089, 0x84000049, 0x940000f3,
		0x74000102, 0x84000055, 0x84000015, 0x84000200,
		0xa400012c, 0x84000075, 0x84000035, 0x940000cb,
		0x8400010c, 0x84000065, 0x84000025, 0x940000ab,
		0x84000005, 0x84000085, 0x84000045, 0x940000eb,
		0x74000106, 0x8400005d, 0x8400001d, 0x9400009b,
		0xb4000154, 0x8400007d, 0x8400003d, 0x940000db,
		0x94000118, 0x8400006d, 0x8400002d, 0x940000bb,
		0x8400000d, 0x8400008d, 0x8400004d, 0x940000fb,
		0x74000101, 0x84000053, 0x84000013, 0x36000052,
		0xa4000124, 0x84000073, 0x84000033, 0x940000c7,
		0x8400010a, 0x84000063, 0x84000023, 0x940000a7,
		0x84000003, 0x84000083, 0x84000043, 0x940000e7,
		0x74000105, 0x8400005b, 0x8400001b, 0x94000097,
		0xb4000144, 0x8400007b, 0x8400003b, 0x940000d7,
		0x94000114, 0x8400006b, 0x8400002b, 0x940000b7,
		0x8400000b, 0x8400008b, 0x8400004b, 0x940000f7,
		0x74000103, 0x84000057, 0x84000017, 0x00000000,
		0xa4000134, 0x84000077, 0x84000037, 0x940000cf,
		0x8400010e, 0x84000067, 0x84000027, 0x940000af,
		0x84000007, 0x84000087, 0x84000047, 0x940000ef,
		0x74000107, 0x8400005f, 0x8400001f, 0x9400009f,
		0xb4000164, 0x8400007f, 0x8400003f, 0x940000df,
		0x9400011c, 0x8400006f, 0x8400002f, 0x940000bf,
		0x8400000f, 0x8400008f, 0x8400004f, 0x940000ff,
		0x74000100, 0x84000050, 0x84000010, 0xc400017b,
		0x9400011d, 0x84000070, 0x84000030, 0x940000c0,
		0x74000108, 0x84000060, 0x84000020, 0x940000a0,
		0x84000000, 0x84000080, 0x84000040, 0x940000e0,
		0x74000104, 0x84000058, 0x84000018, 0x94000090,
		0xa400013d, 0x84000078, 0x84000038, 0x940000d0,
		0x8400010f, 0x84000068, 0x84000028, 0x940000b0,
		0x84000008, 0x84000088, 0x84000048, 0x940000f0,
		0x74000102, 0x84000054, 0x84000014, 0x36000074,
		0xa400012d, 0x84000074, 0x84000034, 0x940000c8,
		0x8400010b, 0x84000064, 0x84000024, 0x940000a8,
		0x84000004, 0x84000084, 0x84000044, 0x940000e8,
		0x74000106, 0x8400005c, 0x8400001c, 0x94000098,
		0xb4000155, 0x8400007c, 0x8400003c, 0x940000d8,
		0x94000115, 0x8400006c, 0x8400002c, 0x940000b8,
		0x8400000c, 0x8400008c, 0x8400004c, 0x940000f8,
		0x74000101, 0x84000052, 0x84000012, 0x36000034,
		0xa4000125, 0x84000072, 0x84000032, 0x940000c4,
		0x84000109, 0x84000062, 0x84000022, 0x940000a4,
		0x84000002, 0x84000082, 0x84000042, 0x940000e4,
		0x74000105, 0x8400005a, 0x8400001a, 0x94000094,
		0xb4000145, 0x8400007a, 0x8400003a, 0x940000d4,
		0x94000111, 0x8400006a, 0x8400002a, 0x940000b4,
		0x8400000a, 0x8400008a, 0x8400004a, 0x940000f4,
		0x74000103, 0x84000056, 0x84000016, 0x00000000,
		0xa4000135, 0x84000076, 0x84000036, 0x940000cc,
		0x8400010d, 0x84000066, 0x84000026, 0x940000ac,
		0x84000006, 0x84000086, 0x84000046, 0x940000ec,
		0x74000107, 0x8400005e, 0x8400001e, 0x9400009c,
		0xb4000165, 0x8400007e, 0x8400003e, 0x940000dc,
		0x94000119, 0x8400006e, 0x8400002e, 0x940000bc,
		0x8400000e, 0x8400008e, 0x8400004e, 0x940000fc,
		0x74000100, 0x84000051, 0x84000011, 0x36000014,
		0x9400011e, 0x84000071, 0x84000031, 0x940000c2,
		0x74000108, 0x84000061, 0x84000021, 0x940000a2,
		0x84000001, 0x84000081, 0x84000041, 0x940000e2,
		0x74000104, 0x84000059, 0x84000019, 0x94000092,
		0xa400013e, 0x84000079, 0x84000039, 0x940000d2,
		0x84000110, 0x84000069, 0x84000029, 0x940000b2,
		0x84000009, 0x84000089, 0x84000049, 0x940000f2,
		0x74000102, 0x84000055, 0x84000015, 0x84000200,
		0xa400012e, 0x84000075, 0x84000035, 0x940000ca,
		0x8400010c, 0x84000065, 0x84000025, 0x940000aa,
		0x84000005, 0x84000085, 0x84000045, 0x940000ea,
		0x74000106, 0x8400005d, 0x8400001d, 0x9400009a,
		0xb4000156, 0x8400007d, 0x8400003d, 0x940000da,
		0x94000116, 0x8400006d, 0x8400002d, 0x940000ba,
		0x8400000d, 0x8400008d, 0x8400004d, 0x940000fa,
		0x74000101, 0x84000053, 0x84000013, 0x36000054,
		0xa4000126, 0x84000073, 0x84000033, 0x940000c6,
		0x8400010a, 0x84000063, 0x84000023, 0x940000a6,
		0x84000003, 0x84000083, 0x84000043, 0x940000e6,
		0x74000105, 0x8400005b, 0x8400001b, 0x94000096,
		0xb4000146, 0x8400007b, 0x8400003b, 0x940000d6,
		0x94000112, 0x8400006b, 0x8400002b, 0x940000b6,
		0x8400000b, 0x8400008b, 0x8400004b, 0x940000f6,
		0x74000103, 0x84000057, 0x84000017, 0x00000000,
		0xa4000136, 0x84000077, 0x84000037, 0x940000ce,
		0x8400010e, 0x84000067, 0x84000027, 0x940000ae,
		0x84000007, 0x84000087, 0x84000047, 0x940000ee,
		0x74000107, 0x8400005f, 0x8400001f, 0x9400009e,
		0xb4000166, 0x8400007f, 0x8400003f, 0x940000de,
		0x9400011a, 0x8400006f, 0x8400002f, 0x940000be,
		0x8400000f, 0x8400008f, 0x8400004f, 0x940000fe,
		0x74000100, 0x84000050, 0x84000010, 0xc400017c,
		0x9400011f, 0x84000070, 0x84000030, 0x940000c1,
		0x74000108, 0x84000060, 0x84000020, 0x940000a1,
		0x84000000, 0x84000080, 0x84000040, 0x940000e1,
		0x74000104, 0x84000058, 0x84000018, 0x94000091,
		0xa400013f, 0x84000078, 0x84000038, 0x940000d1,
		0x8400010f, 0x84000068, 0x84000028, 0x940000b1,
		0x84000008, 0x84000088, 0x84000048, 0x940000f1,
		0x74000102, 0x84000054, 0x84000014, 0x36000076,
		0xa400012f, 0x84000074, 0x84000034, 0x940000c9,
		0x8400010b, 0x84000064, 0x84000024, 0x940000a9,
		0x84000004, 0x84000084, 0x84000044, 0x940000e9,
		0x74000106, 0x8400005c, 0x8400001c, 0x94000099,
		0xb4000157, 0x8400007c, 0x8400003c, 0x940000d9,
		0x94000117, 0x8400006c, 0x8400002c, 0x940000b9,
		0x8400000c, 0x8400008c, 0x8400004c, 0x940000f9,
		0x74000101, 0x84000052, 0x84000012, 0x36000036,
		0xa4000127, 0x84000072, 0x84000032, 0x940000c5,
		0x84000109, 0x84000062, 0x84000022, 0x940000a5,
		0x84000002, 0x84000082, 0x84000042, 0x940000e5,
		0x74000105, 0x8400005a, 0x8400001a, 0x94000095,
		0xb4000147, 0x8400007a, 0x8400003a, 0x940000d5,
		0x94000113, 0x8400006a, 0x8400002a, 0x940000b5,
		0x8400000a, 0x8400008a, 0x8400004a, 0x940000f5,
		0x74000103, 0x84000056, 0x84000016, 0x00000000,
		0xa4000137, 0x84000076, 0x84000036, 0x940000cd,
		0x8400010d, 0x84000066, 0x84000026, 0x940000ad,
		0x84000006, 0x84000086, 0x84000046, 0x940000ed,
		0x74000107, 0x8400005e, 0x8400001e, 0x9400009d,
		0xb4000167, 0x8400007e, 0x8400003e, 0x940000dd,
		0x9400011b, 0x8400006e, 0x8400002e, 0x940000bd,
		0x8400000e, 0x8400008e, 0x8400004e, 0x940000fd,
		0x74000100, 0x84000051, 0x84000011, 0x36000016,
		0x94000120, 0x84000071, 0x84000031, 0x940000c3,
		0x74000108, 0x84000061, 0x84000021, 0x940000a3,
		0x84000001, 0x84000081, 0x84000041, 0x940000e3,
		0x74000104, 0x84000059, 0x84000019, 0x94000093,
		0xa4000140, 0x84000079, 0x84000039, 0x940000d3,
		0x84000110, 0x84000069, 0x84000029, 0x940000b3,
		0x84000009, 0x84000089, 0x84000049, 0x940000f3,
		0x74000102, 0x84000055, 0x84000015, 0x84000200,
		0xa4000130, 0x84000075, 0x84000035, 0x940000cb,
		0x8400010c, 0x84000065, 0x84000025, 0x940000ab,
		0x84000005, 0x84000085, 0x84000045, 0x940000eb,
		0x74000106, 0x8400005d, 0x8400001d, 0x9400009b,
		0xb4000158, 0x8400007d, 0x8400003d, 0x940000db,
		0x94000118, 0x8400006d, 0x8400002d, 0x940000bb,
		0x8400000d, 0x8400008d, 0x8400004d, 0x940000fb,
		0x74000101, 0x84000053, 0x84000013, 0x36000056,
		0xa4000128, 0x84000073, 0x84000033, 0x940000c7,
		0x8400010a, 0x84000063, 0x84000023, 0x940000a7,
		0x84000003, 0x84000083, 0x84000043, 0x940000e7,
		0x74000105, 0x8400005b, 0x8400001b, 0x94000097,
		0xb4000148, 0x8400007b, 0x8400003b, 0x940000d7,
		0x94000114, 0x8400006b, 0x8400002b, 0x940000b7,
		0x8400000b, 0x8400008b, 0x8400004b, 0x940000f7,
		0x74000103, 0x84000057, 0x84000017, 0x00000000,
		0xa4000138, 0x84000077, 0x84000037, 0x940000cf,
		0x8400010e, 0x84000067, 0x84000027, 0x940000af,
		0x84000007, 0x84000087, 0x84000047, 0x940000ef,
		0x74000107, 0x8400005f, 0x8400001f, 0x9400009f,
		0xb4000168, 0x8400007f, 0x8400003f, 0x940000df,
		0x9400011c, 0x8400006f, 0x8400002f, 0x940000bf,
		0x8400000f, 0x8400008f, 0x8400004f, 0x940000ff,
		0x74000100, 0x84000050, 0x84000010, 0xc400017d,
		0x9400011d, 0x84000070, 0x84000030, 0x940000c0,
		0x74000108, 0x84000060, 0x84000020, 0x940000a0,
		0x84000000, 0x84000080, 0x84000040, 0x940000e0,
		0x74000104, 0x84000058, 0x84000018, 0x94000090,
		0xa4000139, 0x84000078, 0x84000038, 0x940000d0,
		0x8400010f, 0x84000068, 0x84000028, 0x940000b0,
		0x84000008, 0x84000088, 0x84000048, 0x940000f0,
		0x74000102, 0x84000054, 0x84000014, 0x36000078,
		0xa4000129, 0x84000074, 0x84000034, 0x940000c8,
		0x8400010b, 0x84000064, 0x84000024, 0x940000a8,
		0x84000004, 0x84000084, 0x84000044, 0x940000e8,
		0x74000106, 0x8400005c, 0x8400001c, 0x94000098,
		0xb4000159, 0x8400007c, 0x8400003c, 0x940000d8,
		0x94000115, 0x8400006c, 0x8400002c, 0x940000b8,
		0x8400000c, 0x8400008c, 0x8400004c, 0x940000f8,
		0x74000101, 0x84000052, 0x84000012, 0x36000038,
		0xa4000121, 0x84000072, 0x84000032, 0x940000c4,
		0x84000109, 0x84000062, 0x84000022, 0x940000a4,
		0x84000002, 0x84000082, 0x84000042, 0x940000e4,
		0x74000105, 0x8400005a, 0x8400001a, 0x94000094,
		0xb4000149, 0x8400007a, 0x8400003a, 0x940000d4,
		0x94000111, 0x8400006a, 0x8400002a, 0x940000b4,
		0x8400000a, 0x8400008a, 0x8400004a, 0x940000f4,
		0x74000103, 0x84000056, 0x84000016, 0x00000000,
		0xa4000131, 0x84000076, 0x84000036, 0x940000cc,
		0x8400010d, 0x84000066, 0x84000026, 0x940000ac,
		0x84000006, 0x84000086, 0x84000046, 0x940000ec,
		0x74000107, 0x8400005e, 0x8400001e, 0x9400009c,
		0xb4000169, 0x8400007e, 0x8400003e, 0x940000dc,
		0x94000119, 0x8400006e, 0x8400002e, 0x940000bc,
		0x8400000e, 0x8400008e, 0x8400004e, 0x940000fc,
		0x74000100, 0x84000051, 0x84000011, 0x36000018,
		0x9400011e, 0x84000071, 0x84000031, 0x940000c2,
		0x74000108, 0x84000061, 0x84000021, 0x940000a2,
		0x84000001, 0x84000081, 0x84000041, 0x940000e2,
		0x74000104, 0x84000059, 0x84000019, 0x94000092,
		0xa400013a, 0x84000079, 0x84000039, 0x940000d2,
		0x84000110, 0x84000069, 0x84000029, 0x940000b2,
		0x84000009, 0x84000089, 0x84000049, 0x940000f2,
		0x74000102, 0x84000055, 0x84000015, 0x84000200,
		0xa400012a, 0x84000075, 0x84000035, 0x940000ca,
		0x8400010c, 0x84000065, 0x84000025, 0x940000aa,
		0x84000005, 0x84000085, 0x84000045, 0x940000ea,
		0x74000106, 0x8400005d, 0x8400001d, 0x9400009a,
		0xb400015a, 0x8400007d, 0x8400003d, 0x940000da,
		0x94000116, 0x8400006d, 0x8400002d, 0x940000ba,
		0x8400000d, 0x8400008d, 0x8400004d, 0x940000fa,
		0x74000101, 0x84000053, 0x84000013, 0x36000058,
		0xa4000122, 0x84000073, 0x84000033, 0x940000c6,
		0x8400010a, 0x84000063, 0x84000023, 0x940000a6,
		0x84000003, 0x84000083, 0x84000043, 0x940000e6,
		0x74000105, 0x8400005b, 0x8400001b, 0x94000096,
		0xb400014a, 0x8400007b, 0x8400003b, 0x940000d6,
		0x94000112, 0x8400006b, 0x8400002b, 0x940000b6,
		0x8400000b, 0x8400008b, 0x8400004b, 0x940000f6,
		0x74000103, 0x84000057, 0x84000017, 0x00000000,
		0xa4000132, 0x84000077, 0x84000037, 0x940000ce,
		0x8400010e, 0x84000067, 0x84000027, 0x940000ae,
		0x84000007, 0x84000087, 0x84000047, 0x940000ee,
		0x74000107, 0x8400005f, 0x8400001f, 0x9400009e,
		0xb400016a, 0x8400007f, 0x8400003f, 0x940000de,
		0x9400011a, 0x8400006f, 0x8400002f, 0x940000be,
		0x8400000f, 0x8400008f, 0x8400004f, 0x940000fe,
		0x74000100, 0x84000050, 0x84000010, 0xc400017e,
		0x9400011f, 0x84000070, 0x84000030, 0x940000c1,
		0x74000108, 0x84000060, 0x84000020, 0x940000a1,
		0x84000000, 0x84000080, 0x84000040, 0x940000e1,
		0x74000104, 0x84000058, 0x84000018, 0x94000091,
		0xa400013b, 0x84000078, 0x84000038, 0x940000d1,
		0x8400010f, 0x84000068, 0x84000028, 0x940000b1,
		0x84000008, 0x84000088, 0x84000048, 0x940000f1,
		0x74000102, 0x84000054, 0x84000014, 0x3600007a,
		0xa400012b, 0x84000074, 0x84000034, 0x940000c9,
		0x8400010b, 0x84000064, 0x84000024, 0x940000a9,
		0x84000004, 0x84000084, 0x84000044, 0x940000e9,
		0x74000106, 0x8400005c, 0x8400001c, 0x94000099,
		0xb400015b, 0x8400007c, 0x8400003c, 0x940000d9,
		0x94000117, 0x8400006c, 0x8400002c, 0x940000b9,
		0x8400000c, 0x8400008c, 0x8400004c, 0x940000f9,
		0x74000101, 0x84000052, 0x84000012, 0x3600003a,
		0xa4000123, 0x84000072, 0x84000032, 0x940000c5,
		0x84000109, 0x84000062, 0x84000022, 0x940000a5,
		0x84000002, 0x84000082, 0x84000042, 0x940000e5,
		0x74000105, 0x8400005a, 0x8400001a, 0x94000095,
		0xb400014b, 0x8400007a, 0x8400003a, 0x940000d5,
		0x94000113, 0x8400006a, 0x8400002a, 0x940000b5,
		0x8400000a, 0x8400008a, 0x8400004a, 0x940000f5,
		0x74000103, 0x84000056, 0x84000016, 0x00000000,
		0xa4000133, 0x84000076, 0x84000036, 0x940000cd,
		0x8400010d, 0x84000066, 0x84000026, 0x940000ad,
		0x84000006, 0x84000086, 0x84000046, 0x940000ed,
		0x74000107, 0x8400005e, 0x8400001e, 0x9400009d,
		0xb400016b, 0x8400007e, 0x8400003e, 0x940000dd,
		0x9400011b, 0x8400006e, 0x8400002e, 0x940000bd,
		0x8400000e, 0x8400008e, 0x8400004e, 0x940000fd,
		0x74000100, 0x84000051, 0x84000011, 0x3600001a,
		0x94000120, 0x84000071, 0x84000031, 0x940000c3,
		0x74000108, 0x84000061, 0x84000021, 0x940000a3,
		0x84000001, 0x84000081, 0x84000041, 0x940000e3,
		0x74000104, 0x84000059, 0x84000019, 0x94000093,
		0xa400013c, 0x84000079, 0x84000039, 0x940000d3,
		0x84000110, 0x84000069, 0x84000029, 0x940000b3,
		0x84000009, 0x84000089, 0x84000049, 0x940000f3,
		0x74000102, 0x84000055, 0x84000015, 0x84000200,
		0xa400012c, 0x84000075, 0x84000035, 0x940000cb,
		0x8400010c, 0x84000065, 0x84000025, 0x940000ab,
		0x84000005, 0x84000085, 0x84000045, 0x940000eb,
		0x74000106, 0x8400005d, 0x8400001d, 0x9400009b,
		0xb400015c, 0x8400007d, 0x8400003d, 0x940000db,
		0x94000118, 0x8400006d, 0x8400002d, 0x940000bb,
		0x8400000d, 0x8400008d, 0x8400004d, 0x940000fb,
		0x74000101, 0x84000053, 0x84000013, 0x3600005a,
		0xa4000124, 0x84000073, 0x84000033, 0x940000c7,
		0x8400010a, 0x84000063, 0x84000023, 0x940000a7,
		0x84000003, 0x84000083, 0x84000043, 0x940000e7,
		0x74000105, 0x8400005b, 0x8400001b, 0x94000097,
		0xb400014c, 0x8400007b, 0x8400003b, 0x940000d7,
		0x94000114, 0x8400006b, 0x8400002b, 0x940000b7,
		0x8400000b, 0x8400008b, 0x8400004b, 0x940000f7,
		0x74000103, 0x84000057, 0x84000017, 0x00000000,
		0xa4000134, 0x84000077, 0x84000037, 0x940000cf,
		0x8400010e, 0x84000067, 0x84000027, 0x940000af,
		0x84000007, 0x84000087, 0x84000047, 0x940000ef,
		0x74000107, 0x8400005f, 0x8400001f, 0x9400009f,
		0xb400016c, 0x8400007f, 0x8400003f, 0x940000df,
		0x9400011c, 0x8400006f, 0x8400002f, 0x940000bf,
		0x8400000f, 0x8400008f, 0x8400004f, 0x940000ff,
		0x74000100, 0x84000050, 0x84000010, 0xc400017f,
		0x9400011d, 0x84000070, 0x84000030, 0x940000c0,
		0x74000108, 0x84000060, 0x84000020, 0x940000a0,
		0x84000000, 0x84000080, 0x84000040, 0x940000e0,
		0x74000104, 0x84000058, 0x84000018, 0x94000090,
		0xa400013d, 0x84000078, 0x84000038, 0x940000d0,
		0x8400010f, 0x84000068, 0x84000028, 0x940000b0,
		0x84000008, 0x84000088, 0x84000048, 0x940000f0,
		0x74000102, 0x84000054, 0x84000014, 0x3600007c,
		0xa400012d, 0x84000074, 0x84000034, 0x940000c8,
		0x8400010b, 0x84000064, 0x84000024, 0x940000a8,
		0x84000004, 0x84000084, 0x84000044, 0x940000e8,
		0x74000106, 0x8400005c, 0x8400001c, 0x94000098,
		0xb400015d, 0x8400007c, 0x8400003c, 0x940000d8,
		0x94000115, 0x8400006c, 0x8400002c, 0x940000b8,
		0x8400000c, 0x8400008c, 0x8400004c, 0x940000f8,
		0x74000101, 0x84000052, 0x84000012, 0x3600003c,
		0xa4000125, 0x84000072, 0x84000032, 0x940000c4,
		0x84000109, 0x84000062, 0x84000022, 0x940000a4,
		0x84000002, 0x84000082, 0x84000042, 0x940000e4,
		0x74000105, 0x8400005a, 0x8400001a, 0x94000094,
		0xb400014d, 0x8400007a, 0x8400003a, 0x940000d4,
		0x94000111, 0x8400006a, 0x8400002a, 0x940000b4,
		0x8400000a, 0x8400008a, 0x8400004a, 0x940000f4,
		0x74000103, 0x84000056, 0x84000016, 0x00000000,
		0xa4000135, 0x84000076, 0x84000036, 0x940000cc,
		0x8400010d, 0x84000066, 0x84000026, 0x940000ac,
		0x84000006, 0x84000086, 0x84000046, 0x940000ec,
		0x74000107, 0x8400005e, 0x8400001e, 0x9400009c,
		0xb400016d, 0x8400007e, 0x8400003e, 0x940000dc,
		0x94000119, 0x8400006e, 0x8400002e, 0x940000bc,
		0x8400000e, 0x8400008e, 0x8400004e, 0x940000fc,
		0x74000100, 0x84000051, 0x84000011, 0x3600001c,
		0x9400011e, 0x84000071, 0x84000031, 0x940000c2,
		0x74000108, 0x84000061, 0x84000021, 0x940000a2,
		0x84000001, 0x84000081, 0x84000041, 0x940000e2,
		0x74000104, 0x84000059, 0x84000019, 0x94000092,
		0xa400013e, 0x84000079, 0x84000039, 0x940000d2,
		0x84000110, 0x84000069, 0x84000029, 0x940000b2,
		0x84000009, 0x84000089, 0x84000049, 0x940000f2,
		0x74000102, 0x84000055, 0x84000015, 0x84000200,
		0xa400012e, 0x84000075, 0x84000035, 0x940000ca,
		0x8400010c, 0x84000065, 0x84000025, 0x940000aa,
		0x84000005, 0x84000085, 0x84000045, 0x940000ea,
		0x74000106, 0x8400005d, 0x8400001d, 0x9400009a,
		0xb400015e, 0x8400007d, 0x8400003d, 0x940000da,
		0x94000116, 0x8400006d, 0x8400002d, 0x940000ba,
		0x8400000d, 0x8400008d, 0x8400004d, 0x940000fa,
		0x74000101, 0x84000053, 0x84000013, 0x3600005c,
		0xa4000126, 0x84000073, 0x84000033, 0x940000c6,
		0x8400010a, 0x84000063, 0x84000023, 0x940000a6,
		0x84000003, 0x84000083, 0x84000043, 0x940000e6,
		0x74000105, 0x8400005b, 0x8400001b, 0x94000096,
		0xb400014e, 0x8400007b, 0x8400003b, 0x940000d6,
		0x94000112, 0x8400006b, 0x8400002b, 0x940000b6,
		0x8400000b, 0x8400008b, 0x8400004b, 0x940000f6,
		0x74000103, 0x84000057, 0x84000017, 0x00000000,
		0xa4000136, 0x84000077, 0x84000037, 0x940000ce,
		0x8400010e, 0x84000067, 0x84000027, 0x940000ae,
		0x84000007, 0x84000087, 0x84000047, 0x940000ee,
		0x74000107, 0x8400005f, 0x8400001f, 0x9400009e,
		0xb400016e, 0x8400007f, 0x8400003f, 0x940000de,
		0x9400011a, 0x8400006f, 0x8400002f, 0x940000be,
		0x8400000f, 0x8400008f, 0x8400004f, 0x940000fe,
		0x74000100, 0x84000050, 0x84000010, 0xc4000180,
		0x9400011f, 0x84000070, 0x84000030, 0x940000c1,
		0x74000108, 0x84000060, 0x84000020, 0x940000a1,
		0x84000000, 0x84000080, 0x84000040, 0x940000e1,
		0x74000104, 0x84000058, 0x84000018, 0x94000091,
		0xa400013f, 0x84000078, 0x84000038, 0x940000d1,
		0x8400010f, 0x84000068, 0x84000028, 0x940000b1,
		0x84000008, 0x84000088, 0x84000048, 0x940000f1,
		0x74000102, 0x84000054, 0x84000014, 0x3600007e,
		0xa400012f, 0x84000074, 0x84000034, 0x940000c9,
		0x8400010b, 0x84000064, 0x84000024, 0x940000a9,
		0x84000004, 0x84000084, 0x84000044, 0x940000e9,
		0x74000106, 0x8400005c, 0x8400001c, 0x94000099,
		0xb400015f, 0x8400007c, 0x8400003c, 0x940000d9,
		0x94000117, 0x8400006c, 0x8400002c, 0x940000b9,
		0x8400000c, 0x8400008c, 0x8400004c, 0x940000f9,
		0x74000101, 0x84000052, 0x84000012, 0x3600003e,
		0xa4000127, 0x84000072, 0x84000032, 0x940000c5,
		0x84000109, 0x84000062, 0x84000022, 0x940000a5,
		0x84000002, 0x84000082, 0x84000042, 0x940000e5,
		0x74000105, 0x8400005a, 0x8400001a, 0x94000095,
		0xb400014f, 0x8400007a, 0x8400003a, 0x940000d5,
		0x94000113, 0x8400006a, 0x8400002a, 0x940000b5,
		0x8400000a, 0x8400008a, 0x8400004a, 0x940000f5,
		0x74000103, 0x84000056, 0x84000016, 0x00000000,
		0xa4000137, 0x84000076, 0x84000036, 0x940000cd,
		0x8400010d, 0x84000066, 0x84000026, 0x940000ad,
		0x84000006, 0x84000086, 0x84000046, 0x940000ed,
		0x74000107, 0x8400005e, 0x8400001e, 0x9400009d,
		0xb400016f, 0x8400007e, 0x8400003e, 0x940000dd,
		0x9400011b, 0x8400006e, 0x8400002e, 0x940000bd,
		0x8400000e, 0x8400008e, 0x8400004e, 0x940000fd,
		0x74000100, 0x84000051, 0x84000011, 0x3600001e,
		0x94000120, 0x84000071, 0x84000031, 0x940000c3,
		0x74000108, 0x84000061, 0x84000021, 0x940000a3,
		0x84000001, 0x84000081, 0x84000041, 0x940000e3,
		0x74000104, 0x84000059, 0x84000019, 0x94000093,
		0xa4000140, 0x84000079, 0x84000039, 0x940000d3,
		0x84000110, 0x84000069, 0x84000029, 0x940000b3,
		0x84000009, 0x84000089, 0x84000049, 0x940000f3,
		0x74000102, 0x84000055, 0x84000015, 0x84000200,
		0xa4000130, 0x84000075, 0x84000035, 0x940000cb,
		0x8400010c, 0x84000065, 0x84000025, 0x940000ab,
		0x84000005, 0x84000085, 0x84000045, 0x940000eb,
		0x74000106, 0x8400005d, 0x8400001d, 0x9400009b,
		0xb4000160, 0x8400007d, 0x8400003d, 0x940000db,
		0x94000118, 0x8400006d, 0x8400002d, 0x940000bb,
		0x8400000d, 0x8400008d, 0x8400004d, 0x940000fb,
		0x74000101, 0x84000053, 0x84000013, 0x3600005e,
		0xa4000128, 0x84000073, 0x84000033, 0x940000c7,
		0x8400010a, 0x84000063, 0x84000023, 0x940000a7,
		0x84000003, 0x84000083, 0x84000043, 0x940000e7,
		0x74000105, 0x8400005b, 0x8400001b, 0x94000097,
		0xb4000150, 0x8400007b, 0x8400003b, 0x940000d7,
		0x94000114, 0x8400006b, 0x8400002b, 0x940000b7,
		0x8400000b, 0x8400008b, 0x8400004b, 0x940000f7,
		0x74000103, 0x84000057, 0x84000017, 0x00000000,
		0xa4000138, 0x84000077, 0x84000037, 0x940000cf,
		0x8400010e, 0x84000067, 0x84000027, 0x940000af,
		0x84000007, 0x84000087, 0x84000047, 0x940000ef,
		0x74000107, 0x8400005f, 0x8400001f, 0x9400009f,
		0xb4000170, 0x8400007f, 0x8400003f, 0x940000df,
		0x9400011c, 0x8400006f, 0x8400002f, 0x940000bf,
		0x8400000f, 0x8400008f, 0x8400004f, 0x940000ff	},

	.long_code_lookup = {
		0x3581, 0x3591, 0x3582, 0x3592, 0x3583, 0x3593, 0x3584, 0x3594,
		0x3585, 0x3595, 0x3586, 0x3596, 0x3587, 0x3597, 0x3588, 0x3598,
		0x3589, 0x3599, 0x358a, 0x359a, 0x358b, 0x359b, 0x358c, 0x359c,
		0x358d, 0x359d, 0x358e, 0x359e, 0x358f, 0x359f, 0x3590, 0x35a0,
		0x35a1, 0x35b1, 0x35a2, 0x35b2, 0x35a3, 0x35b3, 0x35a4, 0x35b4,
		0x35a5, 0x35b5, 0x35a6, 0x35b6, 0x35a7, 0x35b7, 0x35a8, 0x35b8,
		0x35a9, 0x35b9, 0x35aa, 0x35ba, 0x35ab, 0x35bb, 0x35ac, 0x35bc,
		0x35ad, 0x35bd, 0x35ae, 0x35be, 0x35af, 0x35bf, 0x35b0, 0x35c0,
		0x35c1, 0x35d1, 0x35c2, 0x35d2, 0x35c3, 0x35d3, 0x35c4, 0x35d4,
		0x35c5, 0x35d5, 0x35c6, 0x35d6, 0x35c7, 0x35d7, 0x35c8, 0x35d8,
		0x35c9, 0x35d9, 0x35ca, 0x35da, 0x35cb, 0x35db, 0x35cc, 0x35dc,
		0x35cd, 0x35dd, 0x35ce, 0x35de, 0x35cf, 0x35df, 0x35d0, 0x35e0,
		0x35e1, 0x35f1, 0x35e2, 0x35f2, 0x35e3, 0x35f3, 0x35e4, 0x35f4,
		0x35e5, 0x35f5, 0x35e6, 0x35f6, 0x35e7, 0x35f7, 0x35e8, 0x35f8,
		0x35e9, 0x35f9, 0x35ea, 0x35fa, 0x35eb, 0x35fb, 0x35ec, 0x35fc,
		0x35ed, 0x35fd, 0x35ee, 0x35fe, 0x35ef, 0x35ff, 0x35f0, 0x3600,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000	}
};

struct inflate_huff_code_small static_dist_huff_code = {
	.short_code_lookup = {
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005	},

	.long_code_lookup = {
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000	}
};

#endif
struct inflate_huff_code_large pregen_lit_huff_code = {
	.short_code_lookup = {
		0x24000102, 0x88010265, 0x44000103, 0xa8010277,
		0x24000102, 0x98010268, 0x78010220, 0xb80102e0,
		0x24000102, 0x88010273, 0x44000104, 0xb8010235,
		0x24000102, 0x74000108, 0x64000109, 0xc80102fd,
		0x24000102, 0x8801026f, 0x44000103, 0xb8010206,
		0x24000102, 0x98010270, 0x54000105, 0xc8010259,
		0x24000102, 0x9801020a, 0x44000104, 0xb8010249,
		0x24000102, 0xa8010230, 0x88010200, 0xb40000ad,
		0x24000102, 0x88010269, 0x44000103, 0x9400010d,
		0x24000102, 0x9801026d, 0xb8006520, 0xc8010223,
		0x24000102, 0x64000106, 0x44000104, 0xb801023f,
		0x24000102, 0xa8010204, 0x6400010a, 0xb4000087,
		0x24000102, 0x88010272, 0x44000103, 0xb8010210,
		0x24000102, 0x98010275, 0x54000105, 0xc80102a6,
		0x24000102, 0x98010263, 0x44000104, 0xb8010254,
		0x24000102, 0xa8010242, 0x88010261, 0xb40000d7,
		0x24000102, 0xc8006565, 0x44000103, 0xa80102ff,
		0x24000102, 0x9801026c, 0x98010320, 0xc8010211,
		0x24000102, 0xc8006573, 0x44000104, 0xb8010239,
		0x24000102, 0xa8010201, 0x64000109, 0xb4000017,
		0x24000102, 0xc800656f, 0x44000103, 0xb801020b,
		0x24000102, 0x98010274, 0x54000105, 0xc801027c,
		0x24000102, 0x9801022c, 0x44000104, 0xb801024f,
		0x24000102, 0xa8010232, 0xc8006500, 0xb40000c4,
		0x24000102, 0xc8006569, 0x44000103, 0xa4000111,
		0x24000102, 0x9801026e, 0x54000020, 0xc801023d,
		0x24000102, 0x64000106, 0x44000104, 0xb8010245,
		0x24000102, 0xa801022d, 0x6400010a, 0xb400009a,
		0x24000102, 0xc8006572, 0x44000103, 0xb8010228,
		0x24000102, 0x74000107, 0x54000105, 0xc80102e3,
		0x24000102, 0x98010264, 0x44000104, 0xb8010280,
		0x24000102, 0xa8010266, 0xc8006561, 0xb40000eb,
		0x24000102, 0xa8010365, 0x44000103, 0xa8010279,
		0x24000102, 0x74000068, 0x78010220, 0xb80102fe,
		0x24000102, 0xa8010373, 0x44000104, 0xb8010237,
		0x24000102, 0x74000108, 0x64000109, 0x36000008,
		0x24000102, 0xa801036f, 0x44000103, 0xb8010208,
		0x24000102, 0x74000070, 0x54000105, 0xc8010260,
		0x24000102, 0x7400000a, 0x44000104, 0xb801024d,
		0x24000102, 0xa8010231, 0xa8010300, 0xb40000b7,
		0x24000102, 0xa8010369, 0x44000103, 0x9400010f,
		0x24000102, 0x7400006d, 0xc8006820, 0xc801022a,
		0x24000102, 0x64000106, 0x44000104, 0xb8010243,
		0x24000102, 0xa801020d, 0x6400010a, 0xb4000092,
		0x24000102, 0xa8010372, 0x44000103, 0xb8010222,
		0x24000102, 0x74000075, 0x54000105, 0xc80102c1,
		0x24000102, 0x74000063, 0x44000104, 0xb8010276,
		0x24000102, 0xa8010262, 0xa8010361, 0xb40000df,
		0x24000102, 0x64000065, 0x44000103, 0x9400010b,
		0x24000102, 0x7400006c, 0xa8002020, 0xc8010218,
		0x24000102, 0x64000073, 0x44000104, 0xb801023b,
		0x24000102, 0xa8010203, 0x64000109, 0xb400007b,
		0x24000102, 0x6400006f, 0x44000103, 0xb801020e,
		0x24000102, 0x74000074, 0x54000105, 0xc801028f,
		0x24000102, 0x7400002c, 0x44000104, 0xb8010252,
		0x24000102, 0xa8010241, 0x64000000, 0xb40000cd,
		0x24000102, 0x64000069, 0x44000103, 0xb8010202,
		0x24000102, 0x7400006e, 0x54000020, 0xc8010255,
		0x24000102, 0x64000106, 0x44000104, 0xb8010247,
		0x24000102, 0xa801022e, 0x6400010a, 0xb40000a3,
		0x24000102, 0x64000072, 0x44000103, 0xb8010233,
		0x24000102, 0x74000107, 0x54000105, 0xc80102f3,
		0x24000102, 0x74000064, 0x44000104, 0xb80102c2,
		0x24000102, 0xa8010267, 0x64000061, 0xb40000f6,
		0x24000102, 0x88010265, 0x44000103, 0x84000077,
		0x24000102, 0xb8010368, 0x78010220, 0xb80102f0,
		0x24000102, 0x88010273, 0x44000104, 0xb8010236,
		0x24000102, 0x74000108, 0x64000109, 0xc400011d,
		0x24000102, 0x8801026f, 0x44000103, 0xb8010207,
		0x24000102, 0xb8010370, 0x54000105, 0xc801025c,
		0x24000102, 0xb801030a, 0x44000104, 0xb801024c,
		0x24000102, 0x84000030, 0x88010200, 0xb40000b2,
		0x24000102, 0x88010269, 0x44000103, 0x9400010e,
		0x24000102, 0xb801036d, 0xb8007320, 0xc8010225,
		0x24000102, 0x64000106, 0x44000104, 0xb8010240,
		0x24000102, 0x84000004, 0x6400010a, 0xb400008c,
		0x24000102, 0x88010272, 0x44000103, 0xb801021f,
		0x24000102, 0xb8010375, 0x54000105, 0xc80102b4,
		0x24000102, 0xb8010363, 0x44000104, 0xb801026b,
		0x24000102, 0x84000042, 0x88010261, 0xb40000db,
		0x24000102, 0x64000065, 0x44000103, 0x840000ff,
		0x24000102, 0xb801036c, 0x98010420, 0xc8010213,
		0x24000102, 0x64000073, 0x44000104, 0xb801023a,
		0x24000102, 0x84000001, 0x64000109, 0xb400001d,
		0x24000102, 0x6400006f, 0x44000103, 0xb801020c,
		0x24000102, 0xb8010374, 0x54000105, 0xc801027f,
		0x24000102, 0xb801032c, 0x44000104, 0xb8010250,
		0x24000102, 0x84000032, 0x64000000, 0xb40000c9,
		0x24000102, 0x64000069, 0x44000103, 0xa4000112,
		0x24000102, 0xb801036e, 0x54000020, 0xc801024b,
		0x24000102, 0x64000106, 0x44000104, 0xb8010246,
		0x24000102, 0x8400002d, 0x6400010a, 0xb400009e,
		0x24000102, 0x64000072, 0x44000103, 0xb8010229,
		0x24000102, 0x74000107, 0x54000105, 0xc80102e8,
		0x24000102, 0xb8010364, 0x44000104, 0xb80102c0,
		0x24000102, 0x84000066, 0x64000061, 0xb40000ef,
		0x24000102, 0xb8002065, 0x44000103, 0x84000079,
		0x24000102, 0x74000068, 0x78010220, 0xb4000115,
		0x24000102, 0xb8002073, 0x44000104, 0xb8010238,
		0x24000102, 0x74000108, 0x64000109, 0x36000018,
		0x24000102, 0xb800206f, 0x44000103, 0xb8010209,
		0x24000102, 0x74000070, 0x54000105, 0xc8010271,
		0x24000102, 0x7400000a, 0x44000104, 0xb801024e,
		0x24000102, 0x84000031, 0xb8002000, 0xb40000bb,
		0x24000102, 0xb8002069, 0x44000103, 0x94000110,
		0x24000102, 0x7400006d, 0xc8010820, 0xc801022f,
		0x24000102, 0x64000106, 0x44000104, 0xb8010244,
		0x24000102, 0x8400000d, 0x6400010a, 0xb4000096,
		0x24000102, 0xb8002072, 0x44000103, 0xb8010227,
		0x24000102, 0x74000075, 0x54000105, 0xc80102cf,
		0x24000102, 0x74000063, 0x44000104, 0xb8010278,
		0x24000102, 0x84000062, 0xb8002061, 0xb40000e5,
		0x24000102, 0x64000065, 0x44000103, 0x9400010c,
		0x24000102, 0x7400006c, 0xb8010920, 0xc801021e,
		0x24000102, 0x64000073, 0x44000104, 0xb801023e,
		0x24000102, 0x84000003, 0x64000109, 0xb4000083,
		0x24000102, 0x6400006f, 0x44000103, 0xb801020f,
		0x24000102, 0x74000074, 0x54000105, 0xc80102a0,
		0x24000102, 0x7400002c, 0x44000104, 0xb8010253,
		0x24000102, 0x84000041, 0x64000000, 0xb40000d3,
		0x24000102, 0x64000069, 0x44000103, 0xb8010205,
		0x24000102, 0x7400006e, 0x54000020, 0xc8010257,
		0x24000102, 0x64000106, 0x44000104, 0xb8010248,
		0x24000102, 0x8400002e, 0x6400010a, 0xb40000a9,
		0x24000102, 0x64000072, 0x44000103, 0xb8010234,
		0x24000102, 0x74000107, 0x54000105, 0xc80102f9,
		0x24000102, 0x74000064, 0x44000104, 0xb80102c3,
		0x24000102, 0x84000067, 0x64000061, 0x3e000120,
		0x24000102, 0x88010265, 0x44000103, 0xc8010377,
		0x24000102, 0x98010268, 0x78010220, 0x940000e0,
		0x24000102, 0x88010273, 0x44000104, 0x94000035,
		0x24000102, 0x74000108, 0x64000109, 0xc4000119,
		0x24000102, 0x8801026f, 0x44000103, 0x94000006,
		0x24000102, 0x98010270, 0x54000105, 0xc801025b,
		0x24000102, 0x9801020a, 0x44000104, 0x94000049,
		0x24000102, 0xc8010330, 0x88010200, 0xb40000af,
		0x24000102, 0x88010269, 0x44000103, 0x9400010d,
		0x24000102, 0x9801026d, 0xb8006f20, 0xc8010224,
		0x24000102, 0x64000106, 0x44000104, 0x9400003f,
		0x24000102, 0xc8010304, 0x6400010a, 0xb4000089,
		0x24000102, 0x88010272, 0x44000103, 0x94000010,
		0x24000102, 0x98010275, 0x54000105, 0xc80102b0,
		0x24000102, 0x98010263, 0x44000104, 0x94000054,
		0x24000102, 0xc8010342, 0x88010261, 0xb40000d9,
		0x24000102, 0xc8007365, 0x44000103, 0xc80103ff,
		0x24000102, 0x9801026c, 0x98010320, 0xc8010212,
		0x24000102, 0xc8007373, 0x44000104, 0x94000039,
		0x24000102, 0xc8010301, 0x64000109, 0xb400001a,
		0x24000102, 0xc800736f, 0x44000103, 0x9400000b,
		0x24000102, 0x98010274, 0x54000105, 0xc801027e,
		0x24000102, 0x9801022c, 0x44000104, 0x9400004f,
		0x24000102, 0xc8010332, 0xc8007300, 0xb40000c6,
		0x24000102, 0xc8007369, 0x44000103, 0xa4000113,
		0x24000102, 0x9801026e, 0x54000020, 0xc801024a,
		0x24000102, 0x64000106, 0x44000104, 0x94000045,
		0x24000102, 0xc801032d, 0x6400010a, 0xb400009c,
		0x24000102, 0xc8007372, 0x44000103, 0x94000028,
		0x24000102, 0x74000107, 0x54000105, 0xc80102e7,
		0x24000102, 0x98010264, 0x44000104, 0x94000080,
		0x24000102, 0xc8010366, 0xc8007361, 0xb40000ed,
		0x24000102, 0xa8010465, 0x44000103, 0xc8010379,
		0x24000102, 0x74000068, 0x78010220, 0x940000fe,
		0x24000102, 0xa8010473, 0x44000104, 0x94000037,
		0x24000102, 0x74000108, 0x64000109, 0x36000010,
		0x24000102, 0xa801046f, 0x44000103, 0x94000008,
		0x24000102, 0x74000070, 0x54000105, 0xc801026a,
		0x24000102, 0x7400000a, 0x44000104, 0x9400004d,
		0x24000102, 0xc8010331, 0xa8010400, 0xb40000b9,
		0x24000102, 0xa8010469, 0x44000103, 0x9400010f,
		0x24000102, 0x7400006d, 0xc8007020, 0xc801022b,
		0x24000102, 0x64000106, 0x44000104, 0x94000043,
		0x24000102, 0xc801030d, 0x6400010a, 0xb4000094,
		0x24000102, 0xa8010472, 0x44000103, 0x94000022,
		0x24000102, 0x74000075, 0x54000105, 0xc80102c7,
		0x24000102, 0x74000063, 0x44000104, 0x94000076,
		0x24000102, 0xc8010362, 0xa8010461, 0xb40000e2,
		0x24000102, 0x64000065, 0x44000103, 0x9400010b,
		0x24000102, 0x7400006c, 0xa8010520, 0xc801021c,
		0x24000102, 0x64000073, 0x44000104, 0x9400003b,
		0x24000102, 0xc8010303, 0x64000109, 0xb4000081,
		0x24000102, 0x6400006f, 0x44000103, 0x9400000e,
		0x24000102, 0x74000074, 0x54000105, 0xc8010290,
		0x24000102, 0x7400002c, 0x44000104, 0x94000052,
		0x24000102, 0xc8010341, 0x64000000, 0xb40000d1,
		0x24000102, 0x64000069, 0x44000103, 0x94000002,
		0x24000102, 0x7400006e, 0x54000020, 0xc8010256,
		0x24000102, 0x64000106, 0x44000104, 0x94000047,
		0x24000102, 0xc801032e, 0x6400010a, 0xb40000a7,
		0x24000102, 0x64000072, 0x44000103, 0x94000033,
		0x24000102, 0x74000107, 0x54000105, 0xc80102f8,
		0x24000102, 0x74000064, 0x44000104, 0x940000c2,
		0x24000102, 0xc8010367, 0x64000061, 0xb40000fa,
		0x24000102, 0x88010265, 0x44000103, 0x84000077,
		0x24000102, 0xc8002068, 0x78010220, 0x940000f0,
		0x24000102, 0x88010273, 0x44000104, 0x94000036,
		0x24000102, 0x74000108, 0x64000109, 0x36000000,
		0x24000102, 0x8801026f, 0x44000103, 0x94000007,
		0x24000102, 0xc8002070, 0x54000105, 0xc801025f,
		0x24000102, 0xc800200a, 0x44000104, 0x9400004c,
		0x24000102, 0x84000030, 0x88010200, 0xb40000b5,
		0x24000102, 0x88010269, 0x44000103, 0x9400010e,
		0x24000102, 0xc800206d, 0xc8000a20, 0xc8010226,
		0x24000102, 0x64000106, 0x44000104, 0x94000040,
		0x24000102, 0x84000004, 0x6400010a, 0xb400008e,
		0x24000102, 0x88010272, 0x44000103, 0x9400001f,
		0x24000102, 0xc8002075, 0x54000105, 0xc80102bd,
		0x24000102, 0xc8002063, 0x44000104, 0x9400006b,
		0x24000102, 0x84000042, 0x88010261, 0xb40000dd,
		0x24000102, 0x64000065, 0x44000103, 0x840000ff,
		0x24000102, 0xc800206c, 0x98010420, 0xc8010214,
		0x24000102, 0x64000073, 0x44000104, 0x9400003a,
		0x24000102, 0x84000001, 0x64000109, 0xb400005d,
		0x24000102, 0x6400006f, 0x44000103, 0x9400000c,
		0x24000102, 0xc8002074, 0x54000105, 0xc801028b,
		0x24000102, 0xc800202c, 0x44000104, 0x94000050,
		0x24000102, 0x84000032, 0x64000000, 0xb40000cb,
		0x24000102, 0x64000069, 0x44000103, 0xa4000114,
		0x24000102, 0xc800206e, 0x54000020, 0xc8010251,
		0x24000102, 0x64000106, 0x44000104, 0x94000046,
		0x24000102, 0x8400002d, 0x6400010a, 0xb40000a1,
		0x24000102, 0x64000072, 0x44000103, 0x94000029,
		0x24000102, 0x74000107, 0x54000105, 0xc80102f1,
		0x24000102, 0xc8002064, 0x44000104, 0x940000c0,
		0x24000102, 0x84000066, 0x64000061, 0xb40000f4,
		0x24000102, 0xc8010965, 0x44000103, 0x84000079,
		0x24000102, 0x74000068, 0x78010220, 0xb4000116,
		0x24000102, 0xc8010973, 0x44000104, 0x94000038,
		0x24000102, 0x74000108, 0x64000109, 0xb4000015,
		0x24000102, 0xc801096f, 0x44000103, 0x94000009,
		0x24000102, 0x74000070, 0x54000105, 0xc801027a,
		0x24000102, 0x7400000a, 0x44000104, 0x9400004e,
		0x24000102, 0x84000031, 0xc8010900, 0xb40000be,
		0x24000102, 0xc8010969, 0x44000103, 0x94000110,
		0x24000102, 0x7400006d, 0x54000020, 0xc801023c,
		0x24000102, 0x64000106, 0x44000104, 0x94000044,
		0x24000102, 0x8400000d, 0x6400010a, 0xb4000098,
		0x24000102, 0xc8010972, 0x44000103, 0x94000027,
		0x24000102, 0x74000075, 0x54000105, 0xc80102d0,
		0x24000102, 0x74000063, 0x44000104, 0x94000078,
		0x24000102, 0x84000062, 0xc8010961, 0xb40000e9,
		0x24000102, 0x64000065, 0x44000103, 0x9400010c,
		0x24000102, 0x7400006c, 0xb8000020, 0xc8010221,
		0x24000102, 0x64000073, 0x44000104, 0x9400003e,
		0x24000102, 0x84000003, 0x64000109, 0xb4000085,
		0x24000102, 0x6400006f, 0x44000103, 0x9400000f,
		0x24000102, 0x74000074, 0x54000105, 0xc80102a4,
		0x24000102, 0x7400002c, 0x44000104, 0x94000053,
		0x24000102, 0x84000041, 0x64000000, 0xb40000d5,
		0x24000102, 0x64000069, 0x44000103, 0x94000005,
		0x24000102, 0x7400006e, 0x54000020, 0xc8010258,
		0x24000102, 0x64000106, 0x44000104, 0x94000048,
		0x24000102, 0x8400002e, 0x6400010a, 0xb40000ab,
		0x24000102, 0x64000072, 0x44000103, 0x94000034,
		0x24000102, 0x74000107, 0x54000105, 0xc80102fc,
		0x24000102, 0x74000064, 0x44000104, 0x940000c3,
		0x24000102, 0x84000067, 0x64000061, 0x42000130,
		0x24000102, 0x88010265, 0x44000103, 0xa8010277,
		0x24000102, 0x98010268, 0x78010220, 0x940000e0,
		0x24000102, 0x88010273, 0x44000104, 0x94000035,
		0x24000102, 0x74000108, 0x64000109, 0xa40000fd,
		0x24000102, 0x8801026f, 0x44000103, 0x94000006,
		0x24000102, 0x98010270, 0x54000105, 0xa4000059,
		0x24000102, 0x9801020a, 0x44000104, 0x94000049,
		0x24000102, 0xa8010230, 0x88010200, 0xb40000ae,
		0x24000102, 0x88010269, 0x44000103, 0x9400010d,
		0x24000102, 0x9801026d, 0xb8006920, 0xa4000023,
		0x24000102, 0x64000106, 0x44000104, 0x9400003f,
		0x24000102, 0xa8010204, 0x6400010a, 0xb4000088,
		0x24000102, 0x88010272, 0x44000103, 0x94000010,
		0x24000102, 0x98010275, 0x54000105, 0xa40000a6,
		0x24000102, 0x98010263, 0x44000104, 0x94000054,
		0x24000102, 0xa8010242, 0x88010261, 0xb40000d8,
		0x24000102, 0xc8006f65, 0x44000103, 0xa80102ff,
		0x24000102, 0x9801026c, 0x98010320, 0xa4000011,
		0x24000102, 0xc8006f73, 0x44000104, 0x94000039,
		0x24000102, 0xa8010201, 0x64000109, 0xb4000019,
		0x24000102, 0xc8006f6f, 0x44000103, 0x9400000b,
		0x24000102, 0x98010274, 0x54000105, 0xa400007c,
		0x24000102, 0x9801022c, 0x44000104, 0x9400004f,
		0x24000102, 0xa8010232, 0xc8006f00, 0xb40000c5,
		0x24000102, 0xc8006f69, 0x44000103, 0xa4000111,
		0x24000102, 0x9801026e, 0x54000020, 0xa400003d,
		0x24000102, 0x64000106, 0x44000104, 0x94000045,
		0x24000102, 0xa801022d, 0x6400010a, 0xb400009b,
		0x24000102, 0xc8006f72, 0x44000103, 0x94000028,
		0x24000102, 0x74000107, 0x54000105, 0xa40000e3,
		0x24000102, 0x98010264, 0x44000104, 0x94000080,
		0x24000102, 0xa8010266, 0xc8006f61, 0xb40000ec,
		0x24000102, 0xa8010365, 0x44000103, 0xa8010279,
		0x24000102, 0x74000068, 0x78010220, 0x940000fe,
		0x24000102, 0xa8010373, 0x44000104, 0x94000037,
		0x24000102, 0x74000108, 0x64000109, 0x3600000a,
		0x24000102, 0xa801036f, 0x44000103, 0x94000008,
		0x24000102, 0x74000070, 0x54000105, 0xa4000060,
		0x24000102, 0x7400000a, 0x44000104, 0x9400004d,
		0x24000102, 0xa8010231, 0xa8010300, 0xb40000b8,
		0x24000102, 0xa8010369, 0x44000103, 0x9400010f,
		0x24000102, 0x7400006d, 0xc8006d20, 0xa400002a,
		0x24000102, 0x64000106, 0x44000104, 0x94000043,
		0x24000102, 0xa801020d, 0x6400010a, 0xb4000093,
		0x24000102, 0xa8010372, 0x44000103, 0x94000022,
		0x24000102, 0x74000075, 0x54000105, 0xa40000c1,
		0x24000102, 0x74000063, 0x44000104, 0x94000076,
		0x24000102, 0xa8010262, 0xa8010361, 0xb40000e1,
		0x24000102, 0x64000065, 0x44000103, 0x9400010b,
		0x24000102, 0x7400006c, 0xa8002020, 0xa4000018,
		0x24000102, 0x64000073, 0x44000104, 0x9400003b,
		0x24000102, 0xa8010203, 0x64000109, 0xb400007d,
		0x24000102, 0x6400006f, 0x44000103, 0x9400000e,
		0x24000102, 0x74000074, 0x54000105, 0xa400008f,
		0x24000102, 0x7400002c, 0x44000104, 0x94000052,
		0x24000102, 0xa8010241, 0x64000000, 0xb40000ce,
		0x24000102, 0x64000069, 0x44000103, 0x94000002,
		0x24000102, 0x7400006e, 0x54000020, 0xa4000055,
		0x24000102, 0x64000106, 0x44000104, 0x94000047,
		0x24000102, 0xa801022e, 0x6400010a, 0xb40000a5,
		0x24000102, 0x64000072, 0x44000103, 0x94000033,
		0x24000102, 0x74000107, 0x54000105, 0xa40000f3,
		0x24000102, 0x74000064, 0x44000104, 0x940000c2,
		0x24000102, 0xa8010267, 0x64000061, 0xb40000f7,
		0x24000102, 0x88010265, 0x44000103, 0x84000077,
		0x24000102, 0xb8010468, 0x78010220, 0x940000f0,
		0x24000102, 0x88010273, 0x44000104, 0x94000036,
		0x24000102, 0x74000108, 0x64000109, 0xc400011e,
		0x24000102, 0x8801026f, 0x44000103, 0x94000007,
		0x24000102, 0xb8010470, 0x54000105, 0xa400005c,
		0x24000102, 0xb801040a, 0x44000104, 0x9400004c,
		0x24000102, 0x84000030, 0x88010200, 0xb40000b3,
		0x24000102, 0x88010269, 0x44000103, 0x9400010e,
		0x24000102, 0xb801046d, 0xb8010620, 0xa4000025,
		0x24000102, 0x64000106, 0x44000104, 0x94000040,
		0x24000102, 0x84000004, 0x6400010a, 0xb400008d,
		0x24000102, 0x88010272, 0x44000103, 0x9400001f,
		0x24000102, 0xb8010475, 0x54000105, 0xa40000b4,
		0x24000102, 0xb8010463, 0x44000104, 0x9400006b,
		0x24000102, 0x84000042, 0x88010261, 0xb40000dc,
		0x24000102, 0x64000065, 0x44000103, 0x840000ff,
		0x24000102, 0xb801046c, 0x98010420, 0xa4000013,
		0x24000102, 0x64000073, 0x44000104, 0x9400003a,
		0x24000102, 0x84000001, 0x64000109, 0xb400005a,
		0x24000102, 0x6400006f, 0x44000103, 0x9400000c,
		0x24000102, 0xb8010474, 0x54000105, 0xa400007f,
		0x24000102, 0xb801042c, 0x44000104, 0x94000050,
		0x24000102, 0x84000032, 0x64000000, 0xb40000ca,
		0x24000102, 0x64000069, 0x44000103, 0xa4000112,
		0x24000102, 0xb801046e, 0x54000020, 0xa400004b,
		0x24000102, 0x64000106, 0x44000104, 0x94000046,
		0x24000102, 0x8400002d, 0x6400010a, 0xb400009f,
		0x24000102, 0x64000072, 0x44000103, 0x94000029,
		0x24000102, 0x74000107, 0x54000105, 0xa40000e8,
		0x24000102, 0xb8010464, 0x44000104, 0x940000c0,
		0x24000102, 0x84000066, 0x64000061, 0xb40000f2,
		0x24000102, 0xb8010565, 0x44000103, 0x84000079,
		0x24000102, 0x74000068, 0x78010220, 0xb4000117,
		0x24000102, 0xb8010573, 0x44000104, 0x94000038,
		0x24000102, 0x74000108, 0x64000109, 0x3600001a,
		0x24000102, 0xb801056f, 0x44000103, 0x94000009,
		0x24000102, 0x74000070, 0x54000105, 0xa4000071,
		0x24000102, 0x7400000a, 0x44000104, 0x9400004e,
		0x24000102, 0x84000031, 0xb8010500, 0xb40000bc,
		0x24000102, 0xb8010569, 0x44000103, 0x94000110,
		0x24000102, 0x7400006d, 0x54000020, 0xa400002f,
		0x24000102, 0x64000106, 0x44000104, 0x94000044,
		0x24000102, 0x8400000d, 0x6400010a, 0xb4000097,
		0x24000102, 0xb8010572, 0x44000103, 0x94000027,
		0x24000102, 0x74000075, 0x54000105, 0xa40000cf,
		0x24000102, 0x74000063, 0x44000104, 0x94000078,
		0x24000102, 0x84000062, 0xb8010561, 0xb40000e6,
		0x24000102, 0x64000065, 0x44000103, 0x9400010c,
		0x24000102, 0x7400006c, 0xb8010a20, 0xa400001e,
		0x24000102, 0x64000073, 0x44000104, 0x9400003e,
		0x24000102, 0x84000003, 0x64000109, 0xb4000084,
		0x24000102, 0x6400006f, 0x44000103, 0x9400000f,
		0x24000102, 0x74000074, 0x54000105, 0xa40000a0,
		0x24000102, 0x7400002c, 0x44000104, 0x94000053,
		0x24000102, 0x84000041, 0x64000000, 0xb40000d4,
		0x24000102, 0x64000069, 0x44000103, 0x94000005,
		0x24000102, 0x7400006e, 0x54000020, 0xa4000057,
		0x24000102, 0x64000106, 0x44000104, 0x94000048,
		0x24000102, 0x8400002e, 0x6400010a, 0xb40000aa,
		0x24000102, 0x64000072, 0x44000103, 0x94000034,
		0x24000102, 0x74000107, 0x54000105, 0xa40000f9,
		0x24000102, 0x74000064, 0x44000104, 0x940000c3,
		0x24000102, 0x84000067, 0x64000061, 0xb4000200,
		0x24000102, 0x88010265, 0x44000103, 0x84000077,
		0x24000102, 0x98010268, 0x78010220, 0x940000e0,
		0x24000102, 0x88010273, 0x44000104, 0x94000035,
		0x24000102, 0x74000108, 0x64000109, 0xc400011a,
		0x24000102, 0x8801026f, 0x44000103, 0x94000006,
		0x24000102, 0x98010270, 0x54000105, 0xa400005b,
		0x24000102, 0x9801020a, 0x44000104, 0x94000049,
		0x24000102, 0x84000030, 0x88010200, 0xb40000b1,
		0x24000102, 0x88010269, 0x44000103, 0x9400010d,
		0x24000102, 0x9801026d, 0xb8007220, 0xa4000024,
		0x24000102, 0x64000106, 0x44000104, 0x9400003f,
		0x24000102, 0x84000004, 0x6400010a, 0xb400008a,
		0x24000102, 0x88010272, 0x44000103, 0x94000010,
		0x24000102, 0x98010275, 0x54000105, 0xa40000b0,
		0x24000102, 0x98010263, 0x44000104, 0x94000054,
		0x24000102, 0x84000042, 0x88010261, 0xb40000da,
		0x24000102, 0x64000065, 0x44000103, 0x840000ff,
		0x24000102, 0x9801026c, 0x98010320, 0xa4000012,
		0x24000102, 0x64000073, 0x44000104, 0x94000039,
		0x24000102, 0x84000001, 0x64000109, 0xb400001b,
		0x24000102, 0x6400006f, 0x44000103, 0x9400000b,
		0x24000102, 0x98010274, 0x54000105, 0xa400007e,
		0x24000102, 0x9801022c, 0x44000104, 0x9400004f,
		0x24000102, 0x84000032, 0x64000000, 0xb40000c8,
		0x24000102, 0x64000069, 0x44000103, 0xa4000113,
		0x24000102, 0x9801026e, 0x54000020, 0xa400004a,
		0x24000102, 0x64000106, 0x44000104, 0x94000045,
		0x24000102, 0x8400002d, 0x6400010a, 0xb400009d,
		0x24000102, 0x64000072, 0x44000103, 0x94000028,
		0x24000102, 0x74000107, 0x54000105, 0xa40000e7,
		0x24000102, 0x98010264, 0x44000104, 0x94000080,
		0x24000102, 0x84000066, 0x64000061, 0xb40000ee,
		0x24000102, 0xa8010465, 0x44000103, 0x84000079,
		0x24000102, 0x74000068, 0x78010220, 0x940000fe,
		0x24000102, 0xa8010473, 0x44000104, 0x94000037,
		0x24000102, 0x74000108, 0x64000109, 0x36000012,
		0x24000102, 0xa801046f, 0x44000103, 0x94000008,
		0x24000102, 0x74000070, 0x54000105, 0xa400006a,
		0x24000102, 0x7400000a, 0x44000104, 0x9400004d,
		0x24000102, 0x84000031, 0xa8010400, 0xb40000ba,
		0x24000102, 0xa8010469, 0x44000103, 0x9400010f,
		0x24000102, 0x7400006d, 0xc8007520, 0xa400002b,
		0x24000102, 0x64000106, 0x44000104, 0x94000043,
		0x24000102, 0x8400000d, 0x6400010a, 0xb4000095,
		0x24000102, 0xa8010472, 0x44000103, 0x94000022,
		0x24000102, 0x74000075, 0x54000105, 0xa40000c7,
		0x24000102, 0x74000063, 0x44000104, 0x94000076,
		0x24000102, 0x84000062, 0xa8010461, 0xb40000e4,
		0x24000102, 0x64000065, 0x44000103, 0x9400010b,
		0x24000102, 0x7400006c, 0xa8010520, 0xa400001c,
		0x24000102, 0x64000073, 0x44000104, 0x9400003b,
		0x24000102, 0x84000003, 0x64000109, 0xb4000082,
		0x24000102, 0x6400006f, 0x44000103, 0x9400000e,
		0x24000102, 0x74000074, 0x54000105, 0xa4000090,
		0x24000102, 0x7400002c, 0x44000104, 0x94000052,
		0x24000102, 0x84000041, 0x64000000, 0xb40000d2,
		0x24000102, 0x64000069, 0x44000103, 0x94000002,
		0x24000102, 0x7400006e, 0x54000020, 0xa4000056,
		0x24000102, 0x64000106, 0x44000104, 0x94000047,
		0x24000102, 0x8400002e, 0x6400010a, 0xb40000a8,
		0x24000102, 0x64000072, 0x44000103, 0x94000033,
		0x24000102, 0x74000107, 0x54000105, 0xa40000f8,
		0x24000102, 0x74000064, 0x44000104, 0x940000c2,
		0x24000102, 0x84000067, 0x64000061, 0xb40000fb,
		0x24000102, 0x88010265, 0x44000103, 0x84000077,
		0x24000102, 0x74000068, 0x78010220, 0x940000f0,
		0x24000102, 0x88010273, 0x44000104, 0x94000036,
		0x24000102, 0x74000108, 0x64000109, 0x36000002,
		0x24000102, 0x8801026f, 0x44000103, 0x94000007,
		0x24000102, 0x74000070, 0x54000105, 0xa400005f,
		0x24000102, 0x7400000a, 0x44000104, 0x9400004c,
		0x24000102, 0x84000030, 0x88010200, 0xb40000b6,
		0x24000102, 0x88010269, 0x44000103, 0x9400010e,
		0x24000102, 0x7400006d, 0xc8006320, 0xa4000026,
		0x24000102, 0x64000106, 0x44000104, 0x94000040,
		0x24000102, 0x84000004, 0x6400010a, 0xb4000091,
		0x24000102, 0x88010272, 0x44000103, 0x9400001f,
		0x24000102, 0x74000075, 0x54000105, 0xa40000bd,
		0x24000102, 0x74000063, 0x44000104, 0x9400006b,
		0x24000102, 0x84000042, 0x88010261, 0xb40000de,
		0x24000102, 0x64000065, 0x44000103, 0x840000ff,
		0x24000102, 0x7400006c, 0x98010420, 0xa4000014,
		0x24000102, 0x64000073, 0x44000104, 0x9400003a,
		0x24000102, 0x84000001, 0x64000109, 0xb400005e,
		0x24000102, 0x6400006f, 0x44000103, 0x9400000c,
		0x24000102, 0x74000074, 0x54000105, 0xa400008b,
		0x24000102, 0x7400002c, 0x44000104, 0x94000050,
		0x24000102, 0x84000032, 0x64000000, 0xb40000cc,
		0x24000102, 0x64000069, 0x44000103, 0xa4000114,
		0x24000102, 0x7400006e, 0x54000020, 0xa4000051,
		0x24000102, 0x64000106, 0x44000104, 0x94000046,
		0x24000102, 0x8400002d, 0x6400010a, 0xb40000a2,
		0x24000102, 0x64000072, 0x44000103, 0x94000029,
		0x24000102, 0x74000107, 0x54000105, 0xa40000f1,
		0x24000102, 0x74000064, 0x44000104, 0x940000c0,
		0x24000102, 0x84000066, 0x64000061, 0xb40000f5,
		0x24000102, 0xc8000065, 0x44000103, 0x84000079,
		0x24000102, 0x74000068, 0x78010220, 0xb4000118,
		0x24000102, 0xc8000073, 0x44000104, 0x94000038,
		0x24000102, 0x74000108, 0x64000109, 0xb4000016,
		0x24000102, 0xc800006f, 0x44000103, 0x94000009,
		0x24000102, 0x74000070, 0x54000105, 0xa400007a,
		0x24000102, 0x7400000a, 0x44000104, 0x9400004e,
		0x24000102, 0x84000031, 0xc8000000, 0xb40000bf,
		0x24000102, 0xc8000069, 0x44000103, 0x94000110,
		0x24000102, 0x7400006d, 0x54000020, 0xa400003c,
		0x24000102, 0x64000106, 0x44000104, 0x94000044,
		0x24000102, 0x8400000d, 0x6400010a, 0xb4000099,
		0x24000102, 0xc8000072, 0x44000103, 0x94000027,
		0x24000102, 0x74000075, 0x54000105, 0xa40000d0,
		0x24000102, 0x74000063, 0x44000104, 0x94000078,
		0x24000102, 0x84000062, 0xc8000061, 0xb40000ea,
		0x24000102, 0x64000065, 0x44000103, 0x9400010c,
		0x24000102, 0x7400006c, 0xb8006120, 0xa4000021,
		0x24000102, 0x64000073, 0x44000104, 0x9400003e,
		0x24000102, 0x84000003, 0x64000109, 0xb4000086,
		0x24000102, 0x6400006f, 0x44000103, 0x9400000f,
		0x24000102, 0x74000074, 0x54000105, 0xa40000a4,
		0x24000102, 0x7400002c, 0x44000104, 0x94000053,
		0x24000102, 0x84000041, 0x64000000, 0xb40000d6,
		0x24000102, 0x64000069, 0x44000103, 0x94000005,
		0x24000102, 0x7400006e, 0x54000020, 0xa4000058,
		0x24000102, 0x64000106, 0x44000104, 0x94000048,
		0x24000102, 0x8400002e, 0x6400010a, 0xb40000ac,
		0x24000102, 0x64000072, 0x44000103, 0x94000034,
		0x24000102, 0x74000107, 0x54000105, 0xa40000fc,
		0x24000102, 0x74000064, 0x44000104, 0x940000c3,
		0x24000102, 0x84000067, 0x64000061, 0x46000140,
		0x24000102, 0x88010265, 0x44000103, 0xa8010277,
		0x24000102, 0x98010268, 0x78010220, 0xb80102e0,
		0x24000102, 0x88010273, 0x44000104, 0xb8010235,
		0x24000102, 0x74000108, 0x64000109, 0xa40000fd,
		0x24000102, 0x8801026f, 0x44000103, 0xb8010206,
		0x24000102, 0x98010270, 0x54000105, 0xa4000059,
		0x24000102, 0x9801020a, 0x44000104, 0xb8010249,
		0x24000102, 0xa8010230, 0x88010200, 0xb40000ad,
		0x24000102, 0x88010269, 0x44000103, 0x9400010d,
		0x24000102, 0x9801026d, 0xb8006520, 0xa4000023,
		0x24000102, 0x64000106, 0x44000104, 0xb801023f,
		0x24000102, 0xa8010204, 0x6400010a, 0xb4000087,
		0x24000102, 0x88010272, 0x44000103, 0xb8010210,
		0x24000102, 0x98010275, 0x54000105, 0xa40000a6,
		0x24000102, 0x98010263, 0x44000104, 0xb8010254,
		0x24000102, 0xa8010242, 0x88010261, 0xb40000d7,
		0x24000102, 0xc8006965, 0x44000103, 0xa80102ff,
		0x24000102, 0x9801026c, 0x98010320, 0xa4000011,
		0x24000102, 0xc8006973, 0x44000104, 0xb8010239,
		0x24000102, 0xa8010201, 0x64000109, 0xb4000017,
		0x24000102, 0xc800696f, 0x44000103, 0xb801020b,
		0x24000102, 0x98010274, 0x54000105, 0xa400007c,
		0x24000102, 0x9801022c, 0x44000104, 0xb801024f,
		0x24000102, 0xa8010232, 0xc8006900, 0xb40000c4,
		0x24000102, 0xc8006969, 0x44000103, 0xa4000111,
		0x24000102, 0x9801026e, 0x54000020, 0xa400003d,
		0x24000102, 0x64000106, 0x44000104, 0xb8010245,
		0x24000102, 0xa801022d, 0x6400010a, 0xb400009a,
		0x24000102, 0xc8006972, 0x44000103, 0xb8010228,
		0x24000102, 0x74000107, 0x54000105, 0xa40000e3,
		0x24000102, 0x98010264, 0x44000104, 0xb8010280,
		0x24000102, 0xa8010266, 0xc8006961, 0xb40000eb,
		0x24000102, 0xa8010365, 0x44000103, 0xa8010279,
		0x24000102, 0x74000068, 0x78010220, 0xb80102fe,
		0x24000102, 0xa8010373, 0x44000104, 0xb8010237,
		0x24000102, 0x74000108, 0x64000109, 0x3600000c,
		0x24000102, 0xa801036f, 0x44000103, 0xb8010208,
		0x24000102, 0x74000070, 0x54000105, 0xa4000060,
		0x24000102, 0x7400000a, 0x44000104, 0xb801024d,
		0x24000102, 0xa8010231, 0xa8010300, 0xb40000b7,
		0x24000102, 0xa8010369, 0x44000103, 0x9400010f,
		0x24000102, 0x7400006d, 0xc8006c20, 0xa400002a,
		0x24000102, 0x64000106, 0x44000104, 0xb8010243,
		0x24000102, 0xa801020d, 0x6400010a, 0xb4000092,
		0x24000102, 0xa8010372, 0x44000103, 0xb8010222,
		0x24000102, 0x74000075, 0x54000105, 0xa40000c1,
		0x24000102, 0x74000063, 0x44000104, 0xb8010276,
		0x24000102, 0xa8010262, 0xa8010361, 0xb40000df,
		0x24000102, 0x64000065, 0x44000103, 0x9400010b,
		0x24000102, 0x7400006c, 0xa8002020, 0xa4000018,
		0x24000102, 0x64000073, 0x44000104, 0xb801023b,
		0x24000102, 0xa8010203, 0x64000109, 0xb400007b,
		0x24000102, 0x6400006f, 0x44000103, 0xb801020e,
		0x24000102, 0x74000074, 0x54000105, 0xa400008f,
		0x24000102, 0x7400002c, 0x44000104, 0xb8010252,
		0x24000102, 0xa8010241, 0x64000000, 0xb40000cd,
		0x24000102, 0x64000069, 0x44000103, 0xb8010202,
		0x24000102, 0x7400006e, 0x54000020, 0xa4000055,
		0x24000102, 0x64000106, 0x44000104, 0xb8010247,
		0x24000102, 0xa801022e, 0x6400010a, 0xb40000a3,
		0x24000102, 0x64000072, 0x44000103, 0xb8010233,
		0x24000102, 0x74000107, 0x54000105, 0xa40000f3,
		0x24000102, 0x74000064, 0x44000104, 0xb80102c2,
		0x24000102, 0xa8010267, 0x64000061, 0xb40000f6,
		0x24000102, 0x88010265, 0x44000103, 0x84000077,
		0x24000102, 0xb8010368, 0x78010220, 0xb80102f0,
		0x24000102, 0x88010273, 0x44000104, 0xb8010236,
		0x24000102, 0x74000108, 0x64000109, 0xc400011f,
		0x24000102, 0x8801026f, 0x44000103, 0xb8010207,
		0x24000102, 0xb8010370, 0x54000105, 0xa400005c,
		0x24000102, 0xb801030a, 0x44000104, 0xb801024c,
		0x24000102, 0x84000030, 0x88010200, 0xb40000b2,
		0x24000102, 0x88010269, 0x44000103, 0x9400010e,
		0x24000102, 0xb801036d, 0xb8007320, 0xa4000025,
		0x24000102, 0x64000106, 0x44000104, 0xb8010240,
		0x24000102, 0x84000004, 0x6400010a, 0xb400008c,
		0x24000102, 0x88010272, 0x44000103, 0xb801021f,
		0x24000102, 0xb8010375, 0x54000105, 0xa40000b4,
		0x24000102, 0xb8010363, 0x44000104, 0xb801026b,
		0x24000102, 0x84000042, 0x88010261, 0xb40000db,
		0x24000102, 0x64000065, 0x44000103, 0x840000ff,
		0x24000102, 0xb801036c, 0x98010420, 0xa4000013,
		0x24000102, 0x64000073, 0x44000104, 0xb801023a,
		0x24000102, 0x84000001, 0x64000109, 0xb400001d,
		0x24000102, 0x6400006f, 0x44000103, 0xb801020c,
		0x24000102, 0xb8010374, 0x54000105, 0xa400007f,
		0x24000102, 0xb801032c, 0x44000104, 0xb8010250,
		0x24000102, 0x84000032, 0x64000000, 0xb40000c9,
		0x24000102, 0x64000069, 0x44000103, 0xa4000112,
		0x24000102, 0xb801036e, 0x54000020, 0xa400004b,
		0x24000102, 0x64000106, 0x44000104, 0xb8010246,
		0x24000102, 0x8400002d, 0x6400010a, 0xb400009e,
		0x24000102, 0x64000072, 0x44000103, 0xb8010229,
		0x24000102, 0x74000107, 0x54000105, 0xa40000e8,
		0x24000102, 0xb8010364, 0x44000104, 0xb80102c0,
		0x24000102, 0x84000066, 0x64000061, 0xb40000ef,
		0x24000102, 0xb8002065, 0x44000103, 0x84000079,
		0x24000102, 0x74000068, 0x78010220, 0xb4000115,
		0x24000102, 0xb8002073, 0x44000104, 0xb8010238,
		0x24000102, 0x74000108, 0x64000109, 0x3600001c,
		0x24000102, 0xb800206f, 0x44000103, 0xb8010209,
		0x24000102, 0x74000070, 0x54000105, 0xa4000071,
		0x24000102, 0x7400000a, 0x44000104, 0xb801024e,
		0x24000102, 0x84000031, 0xb8002000, 0xb40000bb,
		0x24000102, 0xb8002069, 0x44000103, 0x94000110,
		0x24000102, 0x7400006d, 0x54000020, 0xa400002f,
		0x24000102, 0x64000106, 0x44000104, 0xb8010244,
		0x24000102, 0x8400000d, 0x6400010a, 0xb4000096,
		0x24000102, 0xb8002072, 0x44000103, 0xb8010227,
		0x24000102, 0x74000075, 0x54000105, 0xa40000cf,
		0x24000102, 0x74000063, 0x44000104, 0xb8010278,
		0x24000102, 0x84000062, 0xb8002061, 0xb40000e5,
		0x24000102, 0x64000065, 0x44000103, 0x9400010c,
		0x24000102, 0x7400006c, 0xb8010920, 0xa400001e,
		0x24000102, 0x64000073, 0x44000104, 0xb801023e,
		0x24000102, 0x84000003, 0x64000109, 0xb4000083,
		0x24000102, 0x6400006f, 0x44000103, 0xb801020f,
		0x24000102, 0x74000074, 0x54000105, 0xa40000a0,
		0x24000102, 0x7400002c, 0x44000104, 0xb8010253,
		0x24000102, 0x84000041, 0x64000000, 0xb40000d3,
		0x24000102, 0x64000069, 0x44000103, 0xb8010205,
		0x24000102, 0x7400006e, 0x54000020, 0xa4000057,
		0x24000102, 0x64000106, 0x44000104, 0xb8010248,
		0x24000102, 0x8400002e, 0x6400010a, 0xb40000a9,
		0x24000102, 0x64000072, 0x44000103, 0xb8010234,
		0x24000102, 0x74000107, 0x54000105, 0xa40000f9,
		0x24000102, 0x74000064, 0x44000104, 0xb80102c3,
		0x24000102, 0x84000067, 0x64000061, 0x3e000128,
		0x24000102, 0x88010265, 0x44000103, 0xc8010477,
		0x24000102, 0x98010268, 0x78010220, 0x940000e0,
		0x24000102, 0x88010273, 0x44000104, 0x94000035,
		0x24000102, 0x74000108, 0x64000109, 0xc400011b,
		0x24000102, 0x8801026f, 0x44000103, 0x94000006,
		0x24000102, 0x98010270, 0x54000105, 0xa400005b,
		0x24000102, 0x9801020a, 0x44000104, 0x94000049,
		0x24000102, 0xc8010430, 0x88010200, 0xb40000af,
		0x24000102, 0x88010269, 0x44000103, 0x9400010d,
		0x24000102, 0x9801026d, 0xb8006f20, 0xa4000024,
		0x24000102, 0x64000106, 0x44000104, 0x9400003f,
		0x24000102, 0xc8010404, 0x6400010a, 0xb4000089,
		0x24000102, 0x88010272, 0x44000103, 0x94000010,
		0x24000102, 0x98010275, 0x54000105, 0xa40000b0,
		0x24000102, 0x98010263, 0x44000104, 0x94000054,
		0x24000102, 0xc8010442, 0x88010261, 0xb40000d9,
		0x24000102, 0xc8010665, 0x44000103, 0xc80104ff,
		0x24000102, 0x9801026c, 0x98010320, 0xa4000012,
		0x24000102, 0xc8010673, 0x44000104, 0x94000039,
		0x24000102, 0xc8010401, 0x64000109, 0xb400001a,
		0x24000102, 0xc801066f, 0x44000103, 0x9400000b,
		0x24000102, 0x98010274, 0x54000105, 0xa400007e,
		0x24000102, 0x9801022c, 0x44000104, 0x9400004f,
		0x24000102, 0xc8010432, 0xc8010600, 0xb40000c6,
		0x24000102, 0xc8010669, 0x44000103, 0xa4000113,
		0x24000102, 0x9801026e, 0x54000020, 0xa400004a,
		0x24000102, 0x64000106, 0x44000104, 0x94000045,
		0x24000102, 0xc801042d, 0x6400010a, 0xb400009c,
		0x24000102, 0xc8010672, 0x44000103, 0x94000028,
		0x24000102, 0x74000107, 0x54000105, 0xa40000e7,
		0x24000102, 0x98010264, 0x44000104, 0x94000080,
		0x24000102, 0xc8010466, 0xc8010661, 0xb40000ed,
		0x24000102, 0xa8010465, 0x44000103, 0xc8010479,
		0x24000102, 0x74000068, 0x78010220, 0x940000fe,
		0x24000102, 0xa8010473, 0x44000104, 0x94000037,
		0x24000102, 0x74000108, 0x64000109, 0x36000014,
		0x24000102, 0xa801046f, 0x44000103, 0x94000008,
		0x24000102, 0x74000070, 0x54000105, 0xa400006a,
		0x24000102, 0x7400000a, 0x44000104, 0x9400004d,
		0x24000102, 0xc8010431, 0xa8010400, 0xb40000b9,
		0x24000102, 0xa8010469, 0x44000103, 0x9400010f,
		0x24000102, 0x7400006d, 0xc8007420, 0xa400002b,
		0x24000102, 0x64000106, 0x44000104, 0x94000043,
		0x24000102, 0xc801040d, 0x6400010a, 0xb4000094,
		0x24000102, 0xa8010472, 0x44000103, 0x94000022,
		0x24000102, 0x74000075, 0x54000105, 0xa40000c7,
		0x24000102, 0x74000063, 0x44000104, 0x94000076,
		0x24000102, 0xc8010462, 0xa8010461, 0xb40000e2,
		0x24000102, 0x64000065, 0x44000103, 0x9400010b,
		0x24000102, 0x7400006c, 0xa8010520, 0xa400001c,
		0x24000102, 0x64000073, 0x44000104, 0x9400003b,
		0x24000102, 0xc8010403, 0x64000109, 0xb4000081,
		0x24000102, 0x6400006f, 0x44000103, 0x9400000e,
		0x24000102, 0x74000074, 0x54000105, 0xa4000090,
		0x24000102, 0x7400002c, 0x44000104, 0x94000052,
		0x24000102, 0xc8010441, 0x64000000, 0xb40000d1,
		0x24000102, 0x64000069, 0x44000103, 0x94000002,
		0x24000102, 0x7400006e, 0x54000020, 0xa4000056,
		0x24000102, 0x64000106, 0x44000104, 0x94000047,
		0x24000102, 0xc801042e, 0x6400010a, 0xb40000a7,
		0x24000102, 0x64000072, 0x44000103, 0x94000033,
		0x24000102, 0x74000107, 0x54000105, 0xa40000f8,
		0x24000102, 0x74000064, 0x44000104, 0x940000c2,
		0x24000102, 0xc8010467, 0x64000061, 0xb40000fa,
		0x24000102, 0x88010265, 0x44000103, 0x84000077,
		0x24000102, 0xc8010568, 0x78010220, 0x940000f0,
		0x24000102, 0x88010273, 0x44000104, 0x94000036,
		0x24000102, 0x74000108, 0x64000109, 0x36000004,
		0x24000102, 0x8801026f, 0x44000103, 0x94000007,
		0x24000102, 0xc8010570, 0x54000105, 0xa400005f,
		0x24000102, 0xc801050a, 0x44000104, 0x9400004c,
		0x24000102, 0x84000030, 0x88010200, 0xb40000b5,
		0x24000102, 0x88010269, 0x44000103, 0x9400010e,
		0x24000102, 0xc801056d, 0xc8002c20, 0xa4000026,
		0x24000102, 0x64000106, 0x44000104, 0x94000040,
		0x24000102, 0x84000004, 0x6400010a, 0xb400008e,
		0x24000102, 0x88010272, 0x44000103, 0x9400001f,
		0x24000102, 0xc8010575, 0x54000105, 0xa40000bd,
		0x24000102, 0xc8010563, 0x44000104, 0x9400006b,
		0x24000102, 0x84000042, 0x88010261, 0xb40000dd,
		0x24000102, 0x64000065, 0x44000103, 0x840000ff,
		0x24000102, 0xc801056c, 0x98010420, 0xa4000014,
		0x24000102, 0x64000073, 0x44000104, 0x9400003a,
		0x24000102, 0x84000001, 0x64000109, 0xb400005d,
		0x24000102, 0x6400006f, 0x44000103, 0x9400000c,
		0x24000102, 0xc8010574, 0x54000105, 0xa400008b,
		0x24000102, 0xc801052c, 0x44000104, 0x94000050,
		0x24000102, 0x84000032, 0x64000000, 0xb40000cb,
		0x24000102, 0x64000069, 0x44000103, 0xa4000114,
		0x24000102, 0xc801056e, 0x54000020, 0xa4000051,
		0x24000102, 0x64000106, 0x44000104, 0x94000046,
		0x24000102, 0x8400002d, 0x6400010a, 0xb40000a1,
		0x24000102, 0x64000072, 0x44000103, 0x94000029,
		0x24000102, 0x74000107, 0x54000105, 0xa40000f1,
		0x24000102, 0xc8010564, 0x44000104, 0x940000c0,
		0x24000102, 0x84000066, 0x64000061, 0xb40000f4,
		0x24000102, 0xc8010a65, 0x44000103, 0x84000079,
		0x24000102, 0x74000068, 0x78010220, 0xb4000116,
		0x24000102, 0xc8010a73, 0x44000104, 0x94000038,
		0x24000102, 0x74000108, 0x64000109, 0xb4000015,
		0x24000102, 0xc8010a6f, 0x44000103, 0x94000009,
		0x24000102, 0x74000070, 0x54000105, 0xa400007a,
		0x24000102, 0x7400000a, 0x44000104, 0x9400004e,
		0x24000102, 0x84000031, 0xc8010a00, 0xb40000be,
		0x24000102, 0xc8010a69, 0x44000103, 0x94000110,
		0x24000102, 0x7400006d, 0x54000020, 0xa400003c,
		0x24000102, 0x64000106, 0x44000104, 0x94000044,
		0x24000102, 0x8400000d, 0x6400010a, 0xb4000098,
		0x24000102, 0xc8010a72, 0x44000103, 0x94000027,
		0x24000102, 0x74000075, 0x54000105, 0xa40000d0,
		0x24000102, 0x74000063, 0x44000104, 0x94000078,
		0x24000102, 0x84000062, 0xc8010a61, 0xb40000e9,
		0x24000102, 0x64000065, 0x44000103, 0x9400010c,
		0x24000102, 0x7400006c, 0xb8000020, 0xa4000021,
		0x24000102, 0x64000073, 0x44000104, 0x9400003e,
		0x24000102, 0x84000003, 0x64000109, 0xb4000085,
		0x24000102, 0x6400006f, 0x44000103, 0x9400000f,
		0x24000102, 0x74000074, 0x54000105, 0xa40000a4,
		0x24000102, 0x7400002c, 0x44000104, 0x94000053,
		0x24000102, 0x84000041, 0x64000000, 0xb40000d5,
		0x24000102, 0x64000069, 0x44000103, 0x94000005,
		0x24000102, 0x7400006e, 0x54000020, 0xa4000058,
		0x24000102, 0x64000106, 0x44000104, 0x94000048,
		0x24000102, 0x8400002e, 0x6400010a, 0xb40000ab,
		0x24000102, 0x64000072, 0x44000103, 0x94000034,
		0x24000102, 0x74000107, 0x54000105, 0xa40000fc,
		0x24000102, 0x74000064, 0x44000104, 0x940000c3,
		0x24000102, 0x84000067, 0x64000061, 0x46000160,
		0x24000102, 0x88010265, 0x44000103, 0xa8010277,
		0x24000102, 0x98010268, 0x78010220, 0x940000e0,
		0x24000102, 0x88010273, 0x44000104, 0x94000035,
		0x24000102, 0x74000108, 0x64000109, 0xa40000fd,
		0x24000102, 0x8801026f, 0x44000103, 0x94000006,
		0x24000102, 0x98010270, 0x54000105, 0xa4000059,
		0x24000102, 0x9801020a, 0x44000104, 0x94000049,
		0x24000102, 0xa8010230, 0x88010200, 0xb40000ae,
		0x24000102, 0x88010269, 0x44000103, 0x9400010d,
		0x24000102, 0x9801026d, 0xb8006920, 0xa4000023,
		0x24000102, 0x64000106, 0x44000104, 0x9400003f,
		0x24000102, 0xa8010204, 0x6400010a, 0xb4000088,
		0x24000102, 0x88010272, 0x44000103, 0x94000010,
		0x24000102, 0x98010275, 0x54000105, 0xa40000a6,
		0x24000102, 0x98010263, 0x44000104, 0x94000054,
		0x24000102, 0xa8010242, 0x88010261, 0xb40000d8,
		0x24000102, 0xc8007265, 0x44000103, 0xa80102ff,
		0x24000102, 0x9801026c, 0x98010320, 0xa4000011,
		0x24000102, 0xc8007273, 0x44000104, 0x94000039,
		0x24000102, 0xa8010201, 0x64000109, 0xb4000019,
		0x24000102, 0xc800726f, 0x44000103, 0x9400000b,
		0x24000102, 0x98010274, 0x54000105, 0xa400007c,
		0x24000102, 0x9801022c, 0x44000104, 0x9400004f,
		0x24000102, 0xa8010232, 0xc8007200, 0xb40000c5,
		0x24000102, 0xc8007269, 0x44000103, 0xa4000111,
		0x24000102, 0x9801026e, 0x54000020, 0xa400003d,
		0x24000102, 0x64000106, 0x44000104, 0x94000045,
		0x24000102, 0xa801022d, 0x6400010a, 0xb400009b,
		0x24000102, 0xc8007272, 0x44000103, 0x94000028,
		0x24000102, 0x74000107, 0x54000105, 0xa40000e3,
		0x24000102, 0x98010264, 0x44000104, 0x94000080,
		0x24000102, 0xa8010266, 0xc8007261, 0xb40000ec,
		0x24000102, 0xa8010365, 0x44000103, 0xa8010279,
		0x24000102, 0x74000068, 0x78010220, 0x940000fe,
		0x24000102, 0xa8010373, 0x44000104, 0x94000037,
		0x24000102, 0x74000108, 0x64000109, 0x3600000e,
		0x24000102, 0xa801036f, 0x44000103, 0x94000008,
		0x24000102, 0x74000070, 0x54000105, 0xa4000060,
		0x24000102, 0x7400000a, 0x44000104, 0x9400004d,
		0x24000102, 0xa8010231, 0xa8010300, 0xb40000b8,
		0x24000102, 0xa8010369, 0x44000103, 0x9400010f,
		0x24000102, 0x7400006d, 0xc8006e20, 0xa400002a,
		0x24000102, 0x64000106, 0x44000104, 0x94000043,
		0x24000102, 0xa801020d, 0x6400010a, 0xb4000093,
		0x24000102, 0xa8010372, 0x44000103, 0x94000022,
		0x24000102, 0x74000075, 0x54000105, 0xa40000c1,
		0x24000102, 0x74000063, 0x44000104, 0x94000076,
		0x24000102, 0xa8010262, 0xa8010361, 0xb40000e1,
		0x24000102, 0x64000065, 0x44000103, 0x9400010b,
		0x24000102, 0x7400006c, 0xa8002020, 0xa4000018,
		0x24000102, 0x64000073, 0x44000104, 0x9400003b,
		0x24000102, 0xa8010203, 0x64000109, 0xb400007d,
		0x24000102, 0x6400006f, 0x44000103, 0x9400000e,
		0x24000102, 0x74000074, 0x54000105, 0xa400008f,
		0x24000102, 0x7400002c, 0x44000104, 0x94000052,
		0x24000102, 0xa8010241, 0x64000000, 0xb40000ce,
		0x24000102, 0x64000069, 0x44000103, 0x94000002,
		0x24000102, 0x7400006e, 0x54000020, 0xa4000055,
		0x24000102, 0x64000106, 0x44000104, 0x94000047,
		0x24000102, 0xa801022e, 0x6400010a, 0xb40000a5,
		0x24000102, 0x64000072, 0x44000103, 0x94000033,
		0x24000102, 0x74000107, 0x54000105, 0xa40000f3,
		0x24000102, 0x74000064, 0x44000104, 0x940000c2,
		0x24000102, 0xa8010267, 0x64000061, 0xb40000f7,
		0x24000102, 0x88010265, 0x44000103, 0x84000077,
		0x24000102, 0xb8010468, 0x78010220, 0x940000f0,
		0x24000102, 0x88010273, 0x44000104, 0x94000036,
		0x24000102, 0x74000108, 0x64000109, 0xc4000120,
		0x24000102, 0x8801026f, 0x44000103, 0x94000007,
		0x24000102, 0xb8010470, 0x54000105, 0xa400005c,
		0x24000102, 0xb801040a, 0x44000104, 0x9400004c,
		0x24000102, 0x84000030, 0x88010200, 0xb40000b3,
		0x24000102, 0x88010269, 0x44000103, 0x9400010e,
		0x24000102, 0xb801046d, 0xb8010620, 0xa4000025,
		0x24000102, 0x64000106, 0x44000104, 0x94000040,
		0x24000102, 0x84000004, 0x6400010a, 0xb400008d,
		0x24000102, 0x88010272, 0x44000103, 0x9400001f,
		0x24000102, 0xb8010475, 0x54000105, 0xa40000b4,
		0x24000102, 0xb8010463, 0x44000104, 0x9400006b,
		0x24000102, 0x84000042, 0x88010261, 0xb40000dc,
		0x24000102, 0x64000065, 0x44000103, 0x840000ff,
		0x24000102, 0xb801046c, 0x98010420, 0xa4000013,
		0x24000102, 0x64000073, 0x44000104, 0x9400003a,
		0x24000102, 0x84000001, 0x64000109, 0xb400005a,
		0x24000102, 0x6400006f, 0x44000103, 0x9400000c,
		0x24000102, 0xb8010474, 0x54000105, 0xa400007f,
		0x24000102, 0xb801042c, 0x44000104, 0x94000050,
		0x24000102, 0x84000032, 0x64000000, 0xb40000ca,
		0x24000102, 0x64000069, 0x44000103, 0xa4000112,
		0x24000102, 0xb801046e, 0x54000020, 0xa400004b,
		0x24000102, 0x64000106, 0x44000104, 0x94000046,
		0x24000102, 0x8400002d, 0x6400010a, 0xb400009f,
		0x24000102, 0x64000072, 0x44000103, 0x94000029,
		0x24000102, 0x74000107, 0x54000105, 0xa40000e8,
		0x24000102, 0xb8010464, 0x44000104, 0x940000c0,
		0x24000102, 0x84000066, 0x64000061, 0xb40000f2,
		0x24000102, 0xb8010565, 0x44000103, 0x84000079,
		0x24000102, 0x74000068, 0x78010220, 0xb4000117,
		0x24000102, 0xb8010573, 0x44000104, 0x94000038,
		0x24000102, 0x74000108, 0x64000109, 0x3600001e,
		0x24000102, 0xb801056f, 0x44000103, 0x94000009,
		0x24000102, 0x74000070, 0x54000105, 0xa4000071,
		0x24000102, 0x7400000a, 0x44000104, 0x9400004e,
		0x24000102, 0x84000031, 0xb8010500, 0xb40000bc,
		0x24000102, 0xb8010569, 0x44000103, 0x94000110,
		0x24000102, 0x7400006d, 0x54000020, 0xa400002f,
		0x24000102, 0x64000106, 0x44000104, 0x94000044,
		0x24000102, 0x8400000d, 0x6400010a, 0xb4000097,
		0x24000102, 0xb8010572, 0x44000103, 0x94000027,
		0x24000102, 0x74000075, 0x54000105, 0xa40000cf,
		0x24000102, 0x74000063, 0x44000104, 0x94000078,
		0x24000102, 0x84000062, 0xb8010561, 0xb40000e6,
		0x24000102, 0x64000065, 0x44000103, 0x9400010c,
		0x24000102, 0x7400006c, 0xb8010a20, 0xa400001e,
		0x24000102, 0x64000073, 0x44000104, 0x9400003e,
		0x24000102, 0x84000003, 0x64000109, 0xb4000084,
		0x24000102, 0x6400006f, 0x44000103, 0x9400000f,
		0x24000102, 0x74000074, 0x54000105, 0xa40000a0,
		0x24000102, 0x7400002c, 0x44000104, 0x94000053,
		0x24000102, 0x84000041, 0x64000000, 0xb40000d4,
		0x24000102, 0x64000069, 0x44000103, 0x94000005,
		0x24000102, 0x7400006e, 0x54000020, 0xa4000057,
		0x24000102, 0x64000106, 0x44000104, 0x94000048,
		0x24000102, 0x8400002e, 0x6400010a, 0xb40000aa,
		0x24000102, 0x64000072, 0x44000103, 0x94000034,
		0x24000102, 0x74000107, 0x54000105, 0xa40000f9,
		0x24000102, 0x74000064, 0x44000104, 0x940000c3,
		0x24000102, 0x84000067, 0x64000061, 0xb4000200,
		0x24000102, 0x88010265, 0x44000103, 0x84000077,
		0x24000102, 0x98010268, 0x78010220, 0x940000e0,
		0x24000102, 0x88010273, 0x44000104, 0x94000035,
		0x24000102, 0x74000108, 0x64000109, 0xc400011c,
		0x24000102, 0x8801026f, 0x44000103, 0x94000006,
		0x24000102, 0x98010270, 0x54000105, 0xa400005b,
		0x24000102, 0x9801020a, 0x44000104, 0x94000049,
		0x24000102, 0x84000030, 0x88010200, 0xb40000b1,
		0x24000102, 0x88010269, 0x44000103, 0x9400010d,
		0x24000102, 0x9801026d, 0xb8007220, 0xa4000024,
		0x24000102, 0x64000106, 0x44000104, 0x9400003f,
		0x24000102, 0x84000004, 0x6400010a, 0xb400008a,
		0x24000102, 0x88010272, 0x44000103, 0x94000010,
		0x24000102, 0x98010275, 0x54000105, 0xa40000b0,
		0x24000102, 0x98010263, 0x44000104, 0x94000054,
		0x24000102, 0x84000042, 0x88010261, 0xb40000da,
		0x24000102, 0x64000065, 0x44000103, 0x840000ff,
		0x24000102, 0x9801026c, 0x98010320, 0xa4000012,
		0x24000102, 0x64000073, 0x44000104, 0x94000039,
		0x24000102, 0x84000001, 0x64000109, 0xb400001b,
		0x24000102, 0x6400006f, 0x44000103, 0x9400000b,
		0x24000102, 0x98010274, 0x54000105, 0xa400007e,
		0x24000102, 0x9801022c, 0x44000104, 0x9400004f,
		0x24000102, 0x84000032, 0x64000000, 0xb40000c8,
		0x24000102, 0x64000069, 0x44000103, 0xa4000113,
		0x24000102, 0x9801026e, 0x54000020, 0xa400004a,
		0x24000102, 0x64000106, 0x44000104, 0x94000045,
		0x24000102, 0x8400002d, 0x6400010a, 0xb400009d,
		0x24000102, 0x64000072, 0x44000103, 0x94000028,
		0x24000102, 0x74000107, 0x54000105, 0xa40000e7,
		0x24000102, 0x98010264, 0x44000104, 0x94000080,
		0x24000102, 0x84000066, 0x64000061, 0xb40000ee,
		0x24000102, 0xa8010465, 0x44000103, 0x84000079,
		0x24000102, 0x74000068, 0x78010220, 0x940000fe,
		0x24000102, 0xa8010473, 0x44000104, 0x94000037,
		0x24000102, 0x74000108, 0x64000109, 0x36000016,
		0x24000102, 0xa801046f, 0x44000103, 0x94000008,
		0x24000102, 0x74000070, 0x54000105, 0xa400006a,
		0x24000102, 0x7400000a, 0x44000104, 0x9400004d,
		0x24000102, 0x84000031, 0xa8010400, 0xb40000ba,
		0x24000102, 0xa8010469, 0x44000103, 0x9400010f,
		0x24000102, 0x7400006d, 0xc8010720, 0xa400002b,
		0x24000102, 0x64000106, 0x44000104, 0x94000043,
		0x24000102, 0x8400000d, 0x6400010a, 0xb4000095,
		0x24000102, 0xa8010472, 0x44000103, 0x94000022,
		0x24000102, 0x74000075, 0x54000105, 0xa40000c7,
		0x24000102, 0x74000063, 0x44000104, 0x94000076,
		0x24000102, 0x84000062, 0xa8010461, 0xb40000e4,
		0x24000102, 0x64000065, 0x44000103, 0x9400010b,
		0x24000102, 0x7400006c, 0xa8010520, 0xa400001c,
		0x24000102, 0x64000073, 0x44000104, 0x9400003b,
		0x24000102, 0x84000003, 0x64000109, 0xb4000082,
		0x24000102, 0x6400006f, 0x44000103, 0x9400000e,
		0x24000102, 0x74000074, 0x54000105, 0xa4000090,
		0x24000102, 0x7400002c, 0x44000104, 0x94000052,
		0x24000102, 0x84000041, 0x64000000, 0xb40000d2,
		0x24000102, 0x64000069, 0x44000103, 0x94000002,
		0x24000102, 0x7400006e, 0x54000020, 0xa4000056,
		0x24000102, 0x64000106, 0x44000104, 0x94000047,
		0x24000102, 0x8400002e, 0x6400010a, 0xb40000a8,
		0x24000102, 0x64000072, 0x44000103, 0x94000033,
		0x24000102, 0x74000107, 0x54000105, 0xa40000f8,
		0x24000102, 0x74000064, 0x44000104, 0x940000c2,
		0x24000102, 0x84000067, 0x64000061, 0xb40000fb,
		0x24000102, 0x88010265, 0x44000103, 0x84000077,
		0x24000102, 0x74000068, 0x78010220, 0x940000f0,
		0x24000102, 0x88010273, 0x44000104, 0x94000036,
		0x24000102, 0x74000108, 0x64000109, 0x36000006,
		0x24000102, 0x8801026f, 0x44000103, 0x94000007,
		0x24000102, 0x74000070, 0x54000105, 0xa400005f,
		0x24000102, 0x7400000a, 0x44000104, 0x9400004c,
		0x24000102, 0x84000030, 0x88010200, 0xb40000b6,
		0x24000102, 0x88010269, 0x44000103, 0x9400010e,
		0x24000102, 0x7400006d, 0xc8006420, 0xa4000026,
		0x24000102, 0x64000106, 0x44000104, 0x94000040,
		0x24000102, 0x84000004, 0x6400010a, 0xb4000091,
		0x24000102, 0x88010272, 0x44000103, 0x9400001f,
		0x24000102, 0x74000075, 0x54000105, 0xa40000bd,
		0x24000102, 0x74000063, 0x44000104, 0x9400006b,
		0x24000102, 0x84000042, 0x88010261, 0xb40000de,
		0x24000102, 0x64000065, 0x44000103, 0x840000ff,
		0x24000102, 0x7400006c, 0x98010420, 0xa4000014,
		0x24000102, 0x64000073, 0x44000104, 0x9400003a,
		0x24000102, 0x84000001, 0x64000109, 0xb400005e,
		0x24000102, 0x6400006f, 0x44000103, 0x9400000c,
		0x24000102, 0x74000074, 0x54000105, 0xa400008b,
		0x24000102, 0x7400002c, 0x44000104, 0x94000050,
		0x24000102, 0x84000032, 0x64000000, 0xb40000cc,
		0x24000102, 0x64000069, 0x44000103, 0xa4000114,
		0x24000102, 0x7400006e, 0x54000020, 0xa4000051,
		0x24000102, 0x64000106, 0x44000104, 0x94000046,
		0x24000102, 0x8400002d, 0x6400010a, 0xb40000a2,
		0x24000102, 0x64000072, 0x44000103, 0x94000029,
		0x24000102, 0x74000107, 0x54000105, 0xa40000f1,
		0x24000102, 0x74000064, 0x44000104, 0x940000c0,
		0x24000102, 0x84000066, 0x64000061, 0xb40000f5,
		0x24000102, 0xc8006165, 0x44000103, 0x84000079,
		0x24000102, 0x74000068, 0x78010220, 0xb4000118,
		0x24000102, 0xc8006173, 0x44000104, 0x94000038,
		0x24000102, 0x74000108, 0x64000109, 0xb4000016,
		0x24000102, 0xc800616f, 0x44000103, 0x94000009,
		0x24000102, 0x74000070, 0x54000105, 0xa400007a,
		0x24000102, 0x7400000a, 0x44000104, 0x9400004e,
		0x24000102, 0x84000031, 0xc8006100, 0xb40000bf,
		0x24000102, 0xc8006169, 0x44000103, 0x94000110,
		0x24000102, 0x7400006d, 0x54000020, 0xa400003c,
		0x24000102, 0x64000106, 0x44000104, 0x94000044,
		0x24000102, 0x8400000d, 0x6400010a, 0xb4000099,
		0x24000102, 0xc8006172, 0x44000103, 0x94000027,
		0x24000102, 0x74000075, 0x54000105, 0xa40000d0,
		0x24000102, 0x74000063, 0x44000104, 0x94000078,
		0x24000102, 0x84000062, 0xc8006161, 0xb40000ea,
		0x24000102, 0x64000065, 0x44000103, 0x9400010c,
		0x24000102, 0x7400006c, 0xb8006120, 0xa4000021,
		0x24000102, 0x64000073, 0x44000104, 0x9400003e,
		0x24000102, 0x84000003, 0x64000109, 0xb4000086,
		0x24000102, 0x6400006f, 0x44000103, 0x9400000f,
		0x24000102, 0x74000074, 0x54000105, 0xa40000a4,
		0x24000102, 0x7400002c, 0x44000104, 0x94000053,
		0x24000102, 0x84000041, 0x64000000, 0xb40000d6,
		0x24000102, 0x64000069, 0x44000103, 0x94000005,
		0x24000102, 0x7400006e, 0x54000020, 0xa4000058,
		0x24000102, 0x64000106, 0x44000104, 0x94000048,
		0x24000102, 0x8400002e, 0x6400010a, 0xb40000ac,
		0x24000102, 0x64000072, 0x44000103, 0x94000034,
		0x24000102, 0x74000107, 0x54000105, 0xa40000fc,
		0x24000102, 0x74000064, 0x44000104, 0x940000c3,
		0x24000102, 0x84000067, 0x64000061, 0x52000020	},

	.long_code_lookup = {
		0x3521, 0x3525, 0x3522, 0x3526, 0x3523, 0x3527, 0x3524, 0x3528,
		0x3529, 0x352d, 0x352a, 0x352e, 0x352b, 0x352f, 0x352c, 0x3530,
		0x3531, 0x3535, 0x3532, 0x3536, 0x3533, 0x3537, 0x3534, 0x3538,
		0x3539, 0x353d, 0x353a, 0x353e, 0x353b, 0x353f, 0x353c, 0x3540,
		0x49a1, 0x3d00, 0x49a2, 0x51c1, 0x49a3, 0x3d01, 0x49a4, 0x51e1,
		0x49a5, 0x3d00, 0x49a6, 0x51c2, 0x49a7, 0x3d01, 0x49a8, 0x51e2,
		0x49a9, 0x3d00, 0x49aa, 0x51c3, 0x49ab, 0x3d01, 0x49ac, 0x51e3,
		0x49ad, 0x3d00, 0x49ae, 0x51c4, 0x49af, 0x3d01, 0x49b0, 0x51e4,
		0x49b1, 0x3d00, 0x49b2, 0x51c5, 0x49b3, 0x3d01, 0x49b4, 0x51e5,
		0x49b5, 0x3d00, 0x49b6, 0x51c6, 0x49b7, 0x3d01, 0x49b8, 0x51e6,
		0x49b9, 0x3d00, 0x49ba, 0x51c7, 0x49bb, 0x3d01, 0x49bc, 0x51e7,
		0x49bd, 0x3d00, 0x49be, 0x51c8, 0x49bf, 0x3d01, 0x49c0, 0x51e8,
		0x49a1, 0x3d00, 0x49a2, 0x51c9, 0x49a3, 0x3d01, 0x49a4, 0x51e9,
		0x49a5, 0x3d00, 0x49a6, 0x51ca, 0x49a7, 0x3d01, 0x49a8, 0x51ea,
		0x49a9, 0x3d00, 0x49aa, 0x51cb, 0x49ab, 0x3d01, 0x49ac, 0x51eb,
		0x49ad, 0x3d00, 0x49ae, 0x51cc, 0x49af, 0x3d01, 0x49b0, 0x51ec,
		0x49b1, 0x3d00, 0x49b2, 0x51cd, 0x49b3, 0x3d01, 0x49b4, 0x51ed,
		0x49b5, 0x3d00, 0x49b6, 0x51ce, 0x49b7, 0x3d01, 0x49b8, 0x51ee,
		0x49b9, 0x3d00, 0x49ba, 0x51cf, 0x49bb, 0x3d01, 0x49bc, 0x51ef,
		0x49bd, 0x3d00, 0x49be, 0x51d0, 0x49bf, 0x3d01, 0x49c0, 0x51f0,
		0x49a1, 0x3d00, 0x49a2, 0x51d1, 0x49a3, 0x3d01, 0x49a4, 0x51f1,
		0x49a5, 0x3d00, 0x49a6, 0x51d2, 0x49a7, 0x3d01, 0x49a8, 0x51f2,
		0x49a9, 0x3d00, 0x49aa, 0x51d3, 0x49ab, 0x3d01, 0x49ac, 0x51f3,
		0x49ad, 0x3d00, 0x49ae, 0x51d4, 0x49af, 0x3d01, 0x49b0, 0x51f4,
		0x49b1, 0x3d00, 0x49b2, 0x51d5, 0x49b3, 0x3d01, 0x49b4, 0x51f5,
		0x49b5, 0x3d00, 0x49b6, 0x51d6, 0x49b7, 0x3d01, 0x49b8, 0x51f6,
		0x49b9, 0x3d00, 0x49ba, 0x51d7, 0x49bb, 0x3d01, 0x49bc, 0x51f7,
		0x49bd, 0x3d00, 0x49be, 0x51d8, 0x49bf, 0x3d01, 0x49c0, 0x51f8,
		0x49a1, 0x3d00, 0x49a2, 0x51d9, 0x49a3, 0x3d01, 0x49a4, 0x51f9,
		0x49a5, 0x3d00, 0x49a6, 0x51da, 0x49a7, 0x3d01, 0x49a8, 0x51fa,
		0x49a9, 0x3d00, 0x49aa, 0x51db, 0x49ab, 0x3d01, 0x49ac, 0x51fb,
		0x49ad, 0x3d00, 0x49ae, 0x51dc, 0x49af, 0x3d01, 0x49b0, 0x51fc,
		0x49b1, 0x3d00, 0x49b2, 0x51dd, 0x49b3, 0x3d01, 0x49b4, 0x51fd,
		0x49b5, 0x3d00, 0x49b6, 0x51de, 0x49b7, 0x3d01, 0x49b8, 0x51fe,
		0x49b9, 0x3d00, 0x49ba, 0x51df, 0x49bb, 0x3d01, 0x49bc, 0x51ff,
		0x49bd, 0x3d00, 0x49be, 0x51e0, 0x49bf, 0x3d01, 0x49c0, 0x5200,
		0x3d41, 0x3d43, 0x3d45, 0x3d47, 0x3d49, 0x3d4b, 0x3d4d, 0x3d4f,
		0x3d42, 0x3d44, 0x3d46, 0x3d48, 0x3d4a, 0x3d4c, 0x3d4e, 0x3d50,
		0x4151, 0x4152, 0x4153, 0x4154, 0x4155, 0x4156, 0x4157, 0x4158,
		0x4159, 0x415a, 0x415b, 0x415c, 0x415d, 0x415e, 0x415f, 0x4160,
		0x4561, 0x4571, 0x4562, 0x4572, 0x4563, 0x4573, 0x4564, 0x4574,
		0x4565, 0x4575, 0x4566, 0x4576, 0x4567, 0x4577, 0x4568, 0x4578,
		0x4569, 0x4579, 0x456a, 0x457a, 0x456b, 0x457b, 0x456c, 0x457c,
		0x456d, 0x457d, 0x456e, 0x457e, 0x456f, 0x457f, 0x4570, 0x4580,
		0x4581, 0x4582, 0x4583, 0x4584, 0x4585, 0x4586, 0x4587, 0x4588,
		0x4589, 0x458a, 0x458b, 0x458c, 0x458d, 0x458e, 0x458f, 0x4590,
		0x4591, 0x4592, 0x4593, 0x4594, 0x4595, 0x4596, 0x4597, 0x4598,
		0x4599, 0x459a, 0x459b, 0x459c, 0x459d, 0x459e, 0x459f, 0x45a0,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000	}
};

struct inflate_huff_code_small pregen_dist_huff_code = {
	.short_code_lookup = {
		0x1956, 0x219a, 0x20f0, 0x2935, 0x20ce, 0x28ac, 0x2134, 0x29bc,
		0x1956, 0x288a, 0x2112, 0x2979, 0x20cf, 0x28f1, 0x2178, 0x3069,
		0x1956, 0x219a, 0x20f0, 0x2957, 0x20ce, 0x28ad, 0x2134, 0x3047,
		0x1956, 0x288b, 0x2112, 0x299b, 0x20cf, 0x2913, 0x2178, 0x3825,
		0x1956, 0x219a, 0x20f0, 0x2935, 0x20ce, 0x28ac, 0x2134, 0x29bc,
		0x1956, 0x288a, 0x2112, 0x2979, 0x20cf, 0x28f1, 0x2178, 0x31bd,
		0x1956, 0x219a, 0x20f0, 0x2957, 0x20ce, 0x28ad, 0x2134, 0x3068,
		0x1956, 0x288b, 0x2112, 0x299b, 0x20cf, 0x2913, 0x2178, 0x4000,
		0x1956, 0x219a, 0x20f0, 0x2935, 0x20ce, 0x28ac, 0x2134, 0x29bc,
		0x1956, 0x288a, 0x2112, 0x2979, 0x20cf, 0x28f1, 0x2178, 0x3069,
		0x1956, 0x219a, 0x20f0, 0x2957, 0x20ce, 0x28ad, 0x2134, 0x3047,
		0x1956, 0x288b, 0x2112, 0x299b, 0x20cf, 0x2913, 0x2178, 0x3846,
		0x1956, 0x219a, 0x20f0, 0x2935, 0x20ce, 0x28ac, 0x2134, 0x29bc,
		0x1956, 0x288a, 0x2112, 0x2979, 0x20cf, 0x28f1, 0x2178, 0x31bd,
		0x1956, 0x219a, 0x20f0, 0x2957, 0x20ce, 0x28ad, 0x2134, 0x3068,
		0x1956, 0x288b, 0x2112, 0x299b, 0x20cf, 0x2913, 0x2178, 0x4024,
		0x1956, 0x219a, 0x20f0, 0x2935, 0x20ce, 0x28ac, 0x2134, 0x29bc,
		0x1956, 0x288a, 0x2112, 0x2979, 0x20cf, 0x28f1, 0x2178, 0x3069,
		0x1956, 0x219a, 0x20f0, 0x2957, 0x20ce, 0x28ad, 0x2134, 0x3047,
		0x1956, 0x288b, 0x2112, 0x299b, 0x20cf, 0x2913, 0x2178, 0x3825,
		0x1956, 0x219a, 0x20f0, 0x2935, 0x20ce, 0x28ac, 0x2134, 0x29bc,
		0x1956, 0x288a, 0x2112, 0x2979, 0x20cf, 0x28f1, 0x2178, 0x31bd,
		0x1956, 0x219a, 0x20f0, 0x2957, 0x20ce, 0x28ad, 0x2134, 0x3068,
		0x1956, 0x288b, 0x2112, 0x299b, 0x20cf, 0x2913, 0x2178, 0x4002,
		0x1956, 0x219a, 0x20f0, 0x2935, 0x20ce, 0x28ac, 0x2134, 0x29bc,
		0x1956, 0x288a, 0x2112, 0x2979, 0x20cf, 0x28f1, 0x2178, 0x3069,
		0x1956, 0x219a, 0x20f0, 0x2957, 0x20ce, 0x28ad, 0x2134, 0x3047,
		0x1956, 0x288b, 0x2112, 0x299b, 0x20cf, 0x2913, 0x2178, 0x3846,
		0x1956, 0x219a, 0x20f0, 0x2935, 0x20ce, 0x28ac, 0x2134, 0x29bc,
		0x1956, 0x288a, 0x2112, 0x2979, 0x20cf, 0x28f1, 0x2178, 0x31bd,
		0x1956, 0x219a, 0x20f0, 0x2957, 0x20ce, 0x28ad, 0x2134, 0x3068,
		0x1956, 0x288b, 0x2112, 0x299b, 0x20cf, 0x2913, 0x2178, 0x4801,
		0x1956, 0x219a, 0x20f0, 0x2935, 0x20ce, 0x28ac, 0x2134, 0x29bc,
		0x1956, 0x288a, 0x2112, 0x2979, 0x20cf, 0x28f1, 0x2178, 0x3069,
		0x1956, 0x219a, 0x20f0, 0x2957, 0x20ce, 0x28ad, 0x2134, 0x3047,
		0x1956, 0x288b, 0x2112, 0x299b, 0x20cf, 0x2913, 0x2178, 0x3825,
		0x1956, 0x219a, 0x20f0, 0x2935, 0x20ce, 0x28ac, 0x2134, 0x29bc,
		0x1956, 0x288a, 0x2112, 0x2979, 0x20cf, 0x28f1, 0x2178, 0x31bd,
		0x1956, 0x219a, 0x20f0, 0x2957, 0x20ce, 0x28ad, 0x2134, 0x3068,
		0x1956, 0x288b, 0x2112, 0x299b, 0x20cf, 0x2913, 0x2178, 0x4000,
		0x1956, 0x219a, 0x20f0, 0x2935, 0x20ce, 0x28ac, 0x2134, 0x29bc,
		0x1956, 0x288a, 0x2112, 0x2979, 0x20cf, 0x28f1, 0x2178, 0x3069,
		0x1956, 0x219a, 0x20f0, 0x2957, 0x20ce, 0x28ad, 0x2134, 0x3047,
		0x1956, 0x288b, 0x2112, 0x299b, 0x20cf, 0x2913, 0x2178, 0x3846,
		0x1956, 0x219a, 0x20f0, 0x2935, 0x20ce, 0x28ac, 0x2134, 0x29bc,
		0x1956, 0x288a, 0x2112, 0x2979, 0x20cf, 0x28f1, 0x2178, 0x31bd,
		0x1956, 0x219a, 0x20f0, 0x2957, 0x20ce, 0x28ad, 0x2134, 0x3068,
		0x1956, 0x288b, 0x2112, 0x299b, 0x20cf, 0x2913, 0x2178, 0x4024,
		0x1956, 0x219a, 0x20f0, 0x2935, 0x20ce, 0x28ac, 0x2134, 0x29bc,
		0x1956, 0x288a, 0x2112, 0x2979, 0x20cf, 0x28f1, 0x2178, 0x3069,
		0x1956, 0x219a, 0x20f0, 0x2957, 0x20ce, 0x28ad, 0x2134, 0x3047,
		0x1956, 0x288b, 0x2112, 0x299b, 0x20cf, 0x2913, 0x2178, 0x3825,
		0x1956, 0x219a, 0x20f0, 0x2935, 0x20ce, 0x28ac, 0x2134, 0x29bc,
		0x1956, 0x288a, 0x2112, 0x2979, 0x20cf, 0x28f1, 0x2178, 0x31bd,
		0x1956, 0x219a, 0x20f0, 0x2957, 0x20ce, 0x28ad, 0x2134, 0x3068,
		0x1956, 0x288b, 0x2112, 0x299b, 0x20cf, 0x2913, 0x2178, 0x4002,
		0x1956, 0x219a, 0x20f0, 0x2935, 0x20ce, 0x28ac, 0x2134, 0x29bc,
		0x1956, 0x288a, 0x2112, 0x2979, 0x20cf, 0x28f1, 0x2178, 0x3069,
		0x1956, 0x219a, 0x20f0, 0x2957, 0x20ce, 0x28ad, 0x2134, 0x3047,
		0x1956, 0x288b, 0x2112, 0x299b, 0x20cf, 0x2913, 0x2178, 0x3846,
		0x1956, 0x219a, 0x20f0, 0x2935, 0x20ce, 0x28ac, 0x2134, 0x29bc,
		0x1956, 0x288a, 0x2112, 0x2979, 0x20cf, 0x28f1, 0x2178, 0x31bd,
		0x1956, 0x219a, 0x20f0, 0x2957, 0x20ce, 0x28ad, 0x2134, 0x3068,
		0x1956, 0x288b, 0x2112, 0x299b, 0x20cf, 0x2913, 0x2178, 0x4803,
		0x1956, 0x219a, 0x20f0, 0x2935, 0x20ce, 0x28ac, 0x2134, 0x29bc,
		0x1956, 0x288a, 0x2112, 0x2979, 0x20cf, 0x28f1, 0x2178, 0x3069,
		0x1956, 0x219a, 0x20f0, 0x2957, 0x20ce, 0x28ad, 0x2134, 0x3047,
		0x1956, 0x288b, 0x2112, 0x299b, 0x20cf, 0x2913, 0x2178, 0x3825,
		0x1956, 0x219a, 0x20f0, 0x2935, 0x20ce, 0x28ac, 0x2134, 0x29bc,
		0x1956, 0x288a, 0x2112, 0x2979, 0x20cf, 0x28f1, 0x2178, 0x31bd,
		0x1956, 0x219a, 0x20f0, 0x2957, 0x20ce, 0x28ad, 0x2134, 0x3068,
		0x1956, 0x288b, 0x2112, 0x299b, 0x20cf, 0x2913, 0x2178, 0x4000,
		0x1956, 0x219a, 0x20f0, 0x2935, 0x20ce, 0x28ac, 0x2134, 0x29bc,
		0x1956, 0x288a, 0x2112, 0x2979, 0x20cf, 0x28f1, 0x2178, 0x3069,
		0x1956, 0x219a, 0x20f0, 0x2957, 0x20ce, 0x28ad, 0x2134, 0x3047,
		0x1956, 0x288b, 0x2112, 0x299b, 0x20cf, 0x2913, 0x2178, 0x3846,
		0x1956, 0x219a, 0x20f0, 0x2935, 0x20ce, 0x28ac, 0x2134, 0x29bc,
		0x1956, 0x288a, 0x2112, 0x2979, 0x20cf, 0x28f1, 0x2178, 0x31bd,
		0x1956, 0x219a, 0x20f0, 0x2957, 0x20ce, 0x28ad, 0x2134, 0x3068,
		0x1956, 0x288b, 0x2112, 0x299b, 0x20cf, 0x2913, 0x2178, 0x4024,
		0x1956, 0x219a, 0x20f0, 0x2935, 0x20ce, 0x28ac, 0x2134, 0x29bc,
		0x1956, 0x288a, 0x2112, 0x2979, 0x20cf, 0x28f1, 0x2178, 0x3069,
		0x1956, 0x219a, 0x20f0, 0x2957, 0x20ce, 0x28ad, 0x2134, 0x3047,
		0x1956, 0x288b, 0x2112, 0x299b, 0x20cf, 0x2913, 0x2178, 0x3825,
		0x1956, 0x219a, 0x20f0, 0x2935, 0x20ce, 0x28ac, 0x2134, 0x29bc,
		0x1956, 0x288a, 0x2112, 0x2979, 0x20cf, 0x28f1, 0x2178, 0x31bd,
		0x1956, 0x219a, 0x20f0, 0x2957, 0x20ce, 0x28ad, 0x2134, 0x3068,
		0x1956, 0x288b, 0x2112, 0x299b, 0x20cf, 0x2913, 0x2178, 0x4002,
		0x1956, 0x219a, 0x20f0, 0x2935, 0x20ce, 0x28ac, 0x2134, 0x29bc,
		0x1956, 0x288a, 0x2112, 0x2979, 0x20cf, 0x28f1, 0x2178, 0x3069,
		0x1956, 0x219a, 0x20f0, 0x2957, 0x20ce, 0x28ad, 0x2134, 0x3047,
		0x1956, 0x288b, 0x2112, 0x299b, 0x20cf, 0x2913, 0x2178, 0x3846,
		0x1956, 0x219a, 0x20f0, 0x2935, 0x20ce, 0x28ac, 0x2134, 0x29bc,
		0x1956, 0x288a, 0x2112, 0x2979, 0x20cf, 0x28f1, 0x2178, 0x31bd,
		0x1956, 0x219a, 0x20f0, 0x2957, 0x20ce, 0x28ad, 0x2134, 0x3068,
		0x1956, 0x288b, 0x2112, 0x299b, 0x20cf, 0x2913, 0x2178, 0x4801,
		0x1956, 0x219a, 0x20f0, 0x2935, 0x20ce, 0x28ac, 0x2134, 0x29bc,
		0x1956, 0x288a, 0x2112, 0x2979, 0x20cf, 0x28f1, 0x2178, 0x3069,
		0x1956, 0x219a, 0x20f0, 0x2957, 0x20ce, 0x28ad, 0x2134, 0x3047,
		0x1956, 0x288b, 0x2112, 0x299b, 0x20cf, 0x2913, 0x2178, 0x3825,
		0x1956, 0x219a, 0x20f0, 0x2935, 0x20ce, 0x28ac, 0x2134, 0x29bc,
		0x1956, 0x288a, 0x2112, 0x2979, 0x20cf, 0x28f1, 0x2178, 0x31bd,
		0x1956, 0x219a, 0x20f0, 0x2957, 0x20ce, 0x28ad, 0x2134, 0x3068,
		0x1956, 0x288b, 0x2112, 0x299b, 0x20cf, 0x2913, 0x2178, 0x4000,
		0x1956, 0x219a, 0x20f0, 0x2935, 0x20ce, 0x28ac, 0x2134, 0x29bc,
		0x1956, 0x288a, 0x2112, 0x2979, 0x20cf, 0x28f1, 0x2178, 0x3069,
		0x1956, 0x219a, 0x20f0, 0x2957, 0x20ce, 0x28ad, 0x2134, 0x3047,
		0x1956, 0x288b, 0x2112, 0x299b, 0x20cf, 0x2913, 0x2178, 0x3846,
		0x1956, 0x219a, 0x20f0, 0x2935, 0x20ce, 0x28ac, 0x2134, 0x29bc,
		0x1956, 0x288a, 0x2112, 0x2979, 0x20cf, 0x28f1, 0x2178, 0x31bd,
		0x1956, 0x219a, 0x20f0, 0x2957, 0x20ce, 0x28ad, 0x2134, 0x3068,
		0x1956, 0x288b, 0x2112, 0x299b, 0x20cf, 0x2913, 0x2178, 0x4024,
		0x1956, 0x219a, 0x20f0, 0x2935, 0x20ce, 0x28ac, 0x2134, 0x29bc,
		0x1956, 0x288a, 0x2112, 0x2979, 0x20cf, 0x28f1, 0x2178, 0x3069,
		0x1956, 0x219a, 0x20f0, 0x2957, 0x20ce, 0x28ad, 0x2134, 0x3047,
		0x1956, 0x288b, 0x2112, 0x299b, 0x20cf, 0x2913, 0x2178, 0x3825,
		0x1956, 0x219a, 0x20f0, 0x2935, 0x20ce, 0x28ac, 0x2134, 0x29bc,
		0x1956, 0x288a, 0x2112, 0x2979, 0x20cf, 0x28f1, 0x2178, 0x31bd,
		0x1956, 0x219a, 0x20f0, 0x2957, 0x20ce, 0x28ad, 0x2134, 0x3068,
		0x1956, 0x288b, 0x2112, 0x299b, 0x20cf, 0x2913, 0x2178, 0x4002,
		0x1956, 0x219a, 0x20f0, 0x2935, 0x20ce, 0x28ac, 0x2134, 0x29bc,
		0x1956, 0x288a, 0x2112, 0x2979, 0x20cf, 0x28f1, 0x2178, 0x3069,
		0x1956, 0x219a, 0x20f0, 0x2957, 0x20ce, 0x28ad, 0x2134, 0x3047,
		0x1956, 0x288b, 0x2112, 0x299b, 0x20cf, 0x2913, 0x2178, 0x3846,
		0x1956, 0x219a, 0x20f0, 0x2935, 0x20ce, 0x28ac, 0x2134, 0x29bc,
		0x1956, 0x288a, 0x2112, 0x2979, 0x20cf, 0x28f1, 0x2178, 0x31bd,
		0x1956, 0x219a, 0x20f0, 0x2957, 0x20ce, 0x28ad, 0x2134, 0x3068,
		0x1956, 0x288b, 0x2112, 0x299b, 0x20cf, 0x2913, 0x2178, 0x4803	},

	.long_code_lookup = {
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000	}
};

