/* SPDX-License-Identifier: (BSD-3-Clause OR GPL-2.0-only) */
/* Copyright(c) 2017, 2019 - 2021 Intel Corporation */
#ifndef ADF_DEV_ERR_H_
#define ADF_DEV_ERR_H_

#include <linux/pci.h>
#include "adf_accel_devices.h"
#include "adf_transport_internal.h"
#include "adf_transport_access_macros.h"

#define ADF_ERRSOU0 (0x3A000 + 0x00)
#define ADF_ERRSOU1 (0x3A000 + 0x04)
#define ADF_ERRSOU2 (0x3A000 + 0x08)
#define ADF_ERRSOU3 (0x3A000 + 0x0C)
#define ADF_ERRSOU4 (0x3A000 + 0xD0)
#define ADF_ERRSOU5 (0x3A000 + 0xD8)
#define ADF_ERRMSK0 (0x3A000 + 0x10)
#define ADF_ERRMSK1 (0x3A000 + 0x14)
#define ADF_ERRMSK2 (0x3A000 + 0x18)
#define ADF_ERRMSK3 (0x3A000 + 0x1C)
#define ADF_ERRMSK4 (0x3A000 + 0xD4)
#define ADF_ERRMSK5 (0x3A000 + 0xDC)
#define ADF_EMSK3_CPM0_MASK BIT(2)
#define ADF_EMSK3_CPM1_MASK BIT(3)
#define ADF_EMSK5_CPM2_MASK BIT(16)
#define ADF_EMSK5_CPM3_MASK BIT(17)
#define ADF_EMSK5_CPM4_MASK BIT(18)
#define ADF_EPERRLOG (0x3A000 + 0x020)
#define ADF_RICPPINTCTL (0x3A000 + 0x110)
#define ADF_RICPPINTSTS (0x3A000 + 0x114)
#define ADF_RIERRPUSHID (0x3A000 + 0x118)
#define ADF_RIERRPULLID (0x3A000 + 0x11C)
#define ADF_CPP_CFC_ERR_STATUS (0x30000 + 0xC04)
#define ADF_CPP_CFC_ERR_PPID (0x30000 + 0xC08)
#define ADF_PDTCRTHRESH (0x3A400 + 0x10C)
#define ADF_TICPPINTCTL (0x3A400 + 0x138)
#define ADF_TICPPINTSTS (0x3A400 + 0x13C)
#define ADF_TIERRPUSHID (0x3A400 + 0x140)
#define ADF_TIERRPULLID (0x3A400 + 0x144)
#define ADF_TIMISCCTL (0x3A400 + 0x148)
#define ADF_TIMISCSTS (0x3A400 + 0x14C)
#define ADF_TIERRPPID (0x3A400 + 0x150)
#define ADF_TINPDBGSTSR (0x3A400 + 0x158)
#define ADF_TIPDBGSTSR (0x3A400 + 0x160)
#define ADF_TICDBGSTSR (0x3A400 + 0x168)
#define ADF_TIICDBGSTSR (0x3A400 + 0x170)
#define ADF_ADMINMSGSTSR (0x3A400 + 0x180)
#define ADF_SECRAMERR (0x3AC00 + 0x0)
#define ADF_SECRAMUERR (0x3AC00 + 0x04)
#define ADF_SECRAMERRAD (0x3AC00 + 0x08)
#define ADF_SECRAMUERRAD (0x3AC00 + 0x0C)
#define ADF_CPPMEMTGTERR (0x3AC00 + 0x10)
#define ADF_ERRPPID (0x3AC00 + 0x14)
#define ADF_WQSTAT(i) (0x30000 + 0x140 + (i) * 4)
#define ADF_INTSTATSSM(i) ((i) * 0x4000 + 0x04)
#define ADF_INTSTATSSM_SHANGERR BIT(13)
#define ADF_PPERR(i) ((i) * 0x4000 + 0x08)
#define ADF_PPERRID(i) ((i) * 0x4000 + 0x0C)
#define ADF_CERRSSMSH(i) ((i) * 0x4000 + 0x10)
#define ADF_UERRSSMSH(i) ((i) * 0x4000 + 0x18)
#define ADF_UERRSSMSHAD(i) ((i) * 0x4000 + 0x1C)
#define ADF_SLICEPWRDOWN(i) ((i) * 0x4000 + 0x2C)
#define ADF_CPMINSTID(i) ((i) * 0x4000 + 0x30)
#define ADF_SLICEHANGSTATUS(i) ((i) * 0x4000 + 0x4C)
#define ADF_CPM_SLICE_STATUS(i) ((i) * 0x4000 + 0x6C)
#define ADF_USTORE_ERROR_STATUS(i) (0x20000 + ((i) * 0x1000) + 0x80C)
#define ADF_REG_ERROR_STATUS(i) (0x20000 + ((i) * 0x1000) + 0x830)
#define ADF_CTX_ENABLES(i) (0x20000 + ((i) * 0x1000) + 0x818)
#define ADF_INDIRECT_CTX_STS(i) (0x20000 + ((i) * 0x1000) + 0x840)
#define ADF_ACTIVE_CTX_STS(i) (0x20000 + ((i) * 0x1000) + 0x844)
#define ADF_INDIRECT_CTX_SIG_EVENTS(i) (0x20000 + ((i) * 0x1000) + 0x848)
#define ADF_ACTIVE_CTX_SIG_EVENTS(i) (0x20000 + ((i) * 0x1000) + 0x84C)
#define ADF_INDIRECT_CTX_WAKEUP_EVENTS(i) (0x20000 + ((i) * 0x1000) + 0x850)
#define ADF_ACTIVE_CTX_WAKEUP_EVENTS(i) (0x20000 + ((i) * 0x1000) + 0x854)
#define ADF_MISC_CONTROL(i) (0x20000 + ((i) * 0x1000) + 0x960)
#define ADF_LOCAL_CSR_STATUS(i) (0x20000 + ((i) * 0x1000) + 0x980)
#define ADF_ENABLE_SLICE_HANG 0x000000
#define ADF_SLICE_HANG_AUTH0_MASK BIT(0)
#define ADF_SLICE_HANG_AUTH1_MASK BIT(1)
#define ADF_SLICE_HANG_AUTH2_MASK BIT(2)
#define ADF_SLICE_HANG_CPHR0_MASK BIT(4)
#define ADF_SLICE_HANG_CPHR1_MASK BIT(5)
#define ADF_SLICE_HANG_CPHR2_MASK BIT(6)
#define ADF_SLICE_HANG_CMP0_MASK BIT(8)
#define ADF_SLICE_HANG_CMP1_MASK BIT(9)
#define ADF_SLICE_HANG_XLT0_MASK BIT(12)
#define ADF_SLICE_HANG_XLT1_MASK BIT(13)
#define ADF_SLICE_HANG_MMP0_MASK BIT(16)
#define ADF_SLICE_HANG_MMP1_MASK BIT(17)
#define ADF_SLICE_HANG_MMP2_MASK BIT(18)
#define ADF_SLICE_HANG_MMP3_MASK BIT(19)
#define ADF_SLICE_HANG_MMP4_MASK BIT(20)
#define ADF_INTMASKSSM(i) ((i) * 0x4000 + 0x0)
#define ADF_SSMWDT(i) ((i) * 0x4000 + 0x54)
#define ADF_SSMWDTPKE(i) ((i) * 0x4000 + 0x58)
#define ADF_SHINTMASKSSM(i) ((i) * 0x4000 + 0x1018)
#define ADF_MAX_MMP (5)
#define ADF_MMP_BASE(i) ((i) * 0x1000 % 0x3800)
#define ADF_CERRSSMMMP(i, n) ((i) * 0x4000 + ADF_MMP_BASE(n) + 0x380)
#define ADF_CERRSSMMMPAD(i, n) ((i) * 0x4000 + ADF_MMP_BASE(n) + 0x384)
#define ADF_UERRSSMMMP(i, n) ((i) * 0x4000 + ADF_MMP_BASE(n) + 0x388)
#define ADF_UERRSSMMMPAD(i, n) ((i) * 0x4000 + ADF_MMP_BASE(n) + 0x38C)
#define ADF_EXPRPSSMCMP(i, n) ((i) * 0x4000 + ADF_MMP_BASE(n) + 0x400)
#define ADF_EXPRPSSMXLT(i, n) ((i) * 0x4000 + ADF_MMP_BASE(n) + 0x500)
#define ADF_SOFTERRORPARITY(i) ((i) * 0x4000 + 0x1000)
#define ADF_SSMSOFTERRORPARITYMASK(i) ((i) * 0x4000 + 0x1008)
#define ADF_SSMOMETHSTS(i) ((i) * 0x4000 + 0x1010)
#define ADF_SSMEMETHSTS(i) ((i) * 0x4000 + 0x1014)
#define ADF_PCI_CFG_EXP_SZ  (0x1000)

bool adf_check_slice_hang(struct adf_accel_dev *accel_dev);
void adf_print_gen2_err_registers(struct adf_accel_dev *accel_dev);
bool adf_handle_slice_hang(struct adf_accel_dev *accel_dev, u8 accel_num,
			   void __iomem *csr, u32 slice_hang_offset);
void adf_print_err_registers(struct adf_accel_dev *accel_dev);
void adf_clear_uncorrectable_error_regs(struct adf_accel_dev *accel_dev);

#endif
