---
aliases:
  - ../../../enterprise/access-control/custom-role-actions-scopes/
  - ../../../enterprise/access-control/permissions/
description: Learn about Grafana RBAC permissions, actions, and scopes.
menuTitle: RBAC permissions, actions, and scopes
title: Grafana RBAC permissions, actions, and scopes
weight: 80
---

# RBAC permissions, actions, and scopes

> **Note:** Available in [Grafana Enterprise]({{< relref "../../../../introduction/grafana-enterprise/" >}}) and [Grafana Cloud Advanced]({{< ref "/docs/grafana-cloud" >}}).

A permission is comprised of an action and a scope. When creating a custom role, consider the actions the user can perform and the resource(s) on which they can perform those actions.

To learn more about the Grafana resources to which you can apply RBAC, refer to [Resources with RBAC permissions]({{< relref "../#fixed-roles" >}}).

- **Action:** An action describes what tasks a user can perform on a resource.
- **Scope:** A scope describes where an action can be performed, such as reading a specific user profile. In this example, a permission is associated with the scope `users:<userId>` to the relevant role.

## Action definitions

The following list contains role-based access control actions.

| Action                               | Applicable scope                                                                        | Description                                                                                                                                                                                      |
| ------------------------------------ | --------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| `alert.instances.external:read`      | `datasources:*`<br>`datasources:uid:*`                                                  | Read alerts and silences in data sources that support alerting.                                                                                                                                  |
| `alert.instances.external:write`     | `datasources:*`<br>`datasources:uid:*`                                                  | Manage alerts and silences in data sources that support alerting.                                                                                                                                |
| `alert.instances:create`             | n/a                                                                                     | Create silences in the current organization.                                                                                                                                                     |
| `alert.instances:read`               | n/a                                                                                     | Read alerts and silences in the current organization.                                                                                                                                            |
| `alert.instances:write`              | n/a                                                                                     | Update and expire silences in the current organization.                                                                                                                                          |
| `alert.notifications.external:read`  | `datasources:*`<br>`datasources:uid:*`                                                  | Read templates, contact points, notification policies, and mute timings in data sources that support alerting.                                                                                   |
| `alert.notifications.external:write` | `datasources:*`<br>`datasources:uid:*`                                                  | Manage templates, contact points, notification policies, and mute timings in data sources that support alerting.                                                                                 |
| `alert.notifications:write`          | n/a                                                                                     | Manage templates, contact points, notification policies, and mute timings in the current organization.                                                                                           |
| `alert.notifications:read`           | n/a                                                                                     | Read all templates, contact points, notification policies, and mute timings in the current organization.                                                                                         |
| `alert.rules.external:read`          | `datasources:*`<br>`datasources:uid:*`                                                  | Read alert rules in data sources that support alerting (Prometheus, Mimir, and Loki)                                                                                                             |
| `alert.rules.external:write`         | `datasources:*`<br>`datasources:uid:*`                                                  | Create, update, and delete alert rules in data sources that support alerting (Mimir and Loki).                                                                                                   |
| `alert.rules:create`                 | `folders:*`<br>`folders:uid:*`                                                          | Create Grafana alert rules in a folder. Combine this permission with `folders:read` in a scope that includes the folder and `datasources:query` in the scope of data sources the user can query. |
| `alert.rules:delete`                 | `folders:*`<br>`folders:uid:*`                                                          | Delete Grafana alert rules in a folder. Combine this permission with `folders:read` in a scope that includes the folder and `datasources:query` in the scope of data sources the user can query. |
| `alert.rules:read`                   | `folders:*`<br>`folders:uid:*`                                                          | Read Grafana alert rules in a folder. Combine this permission with `folders:read` in a scope that includes the folder and `datasources:query` in the scope of data sources the user can query.   |
| `alert.rules:write`                  | `folders:*`<br>`folders:uid:*`                                                          | Update Grafana alert rules in a folder. Combine this permission with `folders:read` in a scope that includes the folder and `datasources:query` in the scope of data sources the user can query. |
| `alert.provisioning:read`            | n/a                                                                                     | Read all Grafana alert rules, notification policies, etc via provisioning API. Permissions to folders and datasource are not required.                                                           |
| `alert.provisioning:write`           | n/a                                                                                     | Update all Grafana alert rules, notification policies, etc via provisioning API. Permissions to folders and datasource are not required.                                                         |
| `annotations:create`                 | `annotations:*`<br>`annotations:type:*`                                                 | Create annotations.                                                                                                                                                                              |
| `annotations:delete`                 | `annotations:*`<br>`annotations:type:*`                                                 | Delete annotations.                                                                                                                                                                              |
| `annotations:read`                   | `annotations:*`<br>`annotations:type:*`                                                 | Read annotations and annotation tags.                                                                                                                                                            |
| `annotations:write`                  | `annotations:*`<br>`annotations:type:*`                                                 | Update annotations.                                                                                                                                                                              |
| `apikeys:create`                     | n/a                                                                                     | Create API keys.                                                                                                                                                                                 |
| `apikeys:read`                       | `apikeys:*`<br>`apikeys:id:*`                                                           | Read API keys.                                                                                                                                                                                   |
| `apikeys:delete`                     | `apikeys:*`<br>`apikeys:id:*`                                                           | Delete API keys.                                                                                                                                                                                 |
| `dashboards:create`                  | `folders:*`<br>`folders:uid:*`                                                          | Create dashboards in one or more folders.                                                                                                                                                        |
| `dashboards:delete`                  | `dashboards:*`<br>`dashboards:uid:*`<br>`folders:*`<br>`folders:uid:*`                  | Delete one or more dashboards.                                                                                                                                                                   |
| `dashboards.insights:read`           | n/a                                                                                     | Read dashboard insights data and see presence indicators.                                                                                                                                        |
| `dashboards.permissions:read`        | `dashboards:*`<br>`dashboards:uid:*`<br>`folders:*`<br>`folders:uid:*`                  | Read permissions for one or more dashboards.                                                                                                                                                     |
| `dashboards.permissions:write`       | `dashboards:*`<br>`dashboards:uid:*`<br>`folders:*`<br>`folders:uid:*`                  | Update permissions for one or more dashboards.                                                                                                                                                   |
| `dashboards:read`                    | `dashboards:*`<br>`dashboards:uid:*`<br>`folders:*`<br>`folders:uid:*`                  | Read one or more dashboards.                                                                                                                                                                     |
| `dashboards:write`                   | `dashboards:*`<br>`dashboards:uid:*`<br>`folders:*`<br>`folders:uid:*`                  | Update one or more dashboards.                                                                                                                                                                   |
| `datasources.caching:read`           | `datasources:*`<br>`datasources:uid:*`                                                  | Read data source query caching settings.                                                                                                                                                         |
| `datasources.caching:write`          | `datasources:*`<br>`datasources:uid:*`                                                  | Update data source query caching settings.                                                                                                                                                       |
| `datasources:create`                 | n/a                                                                                     | Create data sources.                                                                                                                                                                             |
| `datasources:delete`                 | `datasources:*`<br>`datasources:uid:*`                                                  | Delete data sources.                                                                                                                                                                             |
| `datasources:explore`                | n/a                                                                                     | Enable access to the **Explore** tab.                                                                                                                                                            |
| `datasources.id:read`                | `datasources:*`<br>`datasources:uid:*`                                                  | Read data source IDs.                                                                                                                                                                            |
| `datasources.insights:read`          | n/a                                                                                     | Read data sources insights data.                                                                                                                                                                 |
| `datasources.permissions:read`       | `datasources:*`<br>`datasources:uid:*`                                                  | List data source permissions.                                                                                                                                                                    |
| `datasources.permissions:write`      | `datasources:*`<br>`datasources:uid:*`                                                  | Update data source permissions.                                                                                                                                                                  |
| `datasources:query`                  | `datasources:*`<br>`datasources:uid:*`                                                  | Query data sources.                                                                                                                                                                              |
| `datasources:read`                   | `datasources:*`<br>`datasources:uid:*`                                                  | List data sources.                                                                                                                                                                               |
| `datasources:write`                  | `datasources:*`<br>`datasources:uid:*`                                                  | Update data sources.                                                                                                                                                                             |
| `folders.permissions:read`           | `folders:*`<br>`folders:uid:*`                                                          | Read permissions for one or more folders.                                                                                                                                                        |
| `folders.permissions:write`          | `folders:*`<br>`folders:uid:*`                                                          | Update permissions for one or more folders.                                                                                                                                                      |
| `folders:create`                     | n/a                                                                                     | Create folders.                                                                                                                                                                                  |
| `folders:delete`                     | `folders:*`<br>`folders:uid:*`                                                          | Delete one or more folders.                                                                                                                                                                      |
| `folders:read`                       | `folders:*`<br>`folders:uid:*`                                                          | Read one or more folders.                                                                                                                                                                        |
| `folders:write`                      | `folders:*`<br>`folders:uid:*`                                                          | Update one or more folders.                                                                                                                                                                      |
| `ldap.config:reload`                 | n/a                                                                                     | Reload the LDAP configuration.                                                                                                                                                                   |
| `ldap.status:read`                   | n/a                                                                                     | Verify the availability of the LDAP server or servers.                                                                                                                                           |
| `ldap.user:read`                     | n/a                                                                                     | Read users via LDAP.                                                                                                                                                                             |
| `ldap.user:sync`                     | n/a                                                                                     | Sync users via LDAP.                                                                                                                                                                             |
| `licensing.reports:read`             | n/a                                                                                     | Get custom permission reports.                                                                                                                                                                   |
| `licensing:delete`                   | n/a                                                                                     | Delete the license token.                                                                                                                                                                        |
| `licensing:read`                     | n/a                                                                                     | Read licensing information.                                                                                                                                                                      |
| `licensing:write`                    | n/a                                                                                     | Update the license token.                                                                                                                                                                        |
| `org.users:write`                    | `users:*` <br> `users:id:*`                                                             | Update the organization role (`Viewer`, `Editor`, or `Admin`) of a user.                                                                                                                         |
| `org.users:add`                      | `users:*`                                                                               | Add a user to an organization or invite a new user to an organization.                                                                                                                           |
| `org.users:read`                     | `users:*` <br> `users:id:*`                                                             | Get user profiles within an organization.                                                                                                                                                        |
| `org.users:remove`                   | `users:*` <br> `users:id:*`                                                             | Remove a user from an organization.                                                                                                                                                              |
| `org:create`                         | n/a                                                                                     | Create an organization.                                                                                                                                                                          |
| `orgs.preferences:read`              | `orgs:*` <br> `orgs:id:*`                                                               | Read organization preferences.                                                                                                                                                                   |
| `orgs.preferences:write`             | `orgs:*` <br> `orgs:id:*`                                                               | Update organization preferences.                                                                                                                                                                 |
| `orgs.quotas:read`                   | `orgs:*` <br> `orgs:id:*`                                                               | Read organization quotas.                                                                                                                                                                        |
| `orgs.quotas:write`                  | `orgs:*` <br> `orgs:id:*`                                                               | Update organization quotas.                                                                                                                                                                      |
| `orgs:delete`                        | `orgs:*` <br> `orgs:id:*`                                                               | Delete one or more organizations.                                                                                                                                                                |
| `orgs:read`                          | `orgs:*` <br> `orgs:id:*`                                                               | Read one or more organizations.                                                                                                                                                                  |
| `orgs:write`                         | `orgs:*` <br> `orgs:id:*`                                                               | Update one or more organizations.                                                                                                                                                                |
| `plugins.app:access`                 | `plugins:*` <br> `plugins:id:*`                                                         | Access one or more application plugins (still enforcing the organization role)                                                                                                                   |
| `provisioning:reload`                | `provisioners:*`                                                                        | Reload provisioning files. To find the exact scope for specific provisioner, see [Scope definitions]({{< relref "#scope-definitions" >}}).                                                       |
| `reports:create`                     | n/a                                                                                     | Create reports.                                                                                                                                                                                  |
| `reports:write`                      | `reports:*` <br> `reports:id:*`                                                         | Update reports.                                                                                                                                                                                  |
| `reports.settings:read`              | n/a                                                                                     | Read report settings.                                                                                                                                                                            |
| `reports.settings:write`             | n/a                                                                                     | Update report settings.                                                                                                                                                                          |
| `reports:delete`                     | `reports:*` <br> `reports:id:*`                                                         | Delete reports.                                                                                                                                                                                  |
| `reports:read`                       | `reports:*`                                                                             | List all available reports or get a specific report.                                                                                                                                             |
| `reports:send`                       | `reports:*`                                                                             | Send a report email.                                                                                                                                                                             |
| `roles:delete`                       | `permissions:type:delegate`                                                             | Delete a custom role.                                                                                                                                                                            |
| `roles:read`                         | `roles:*` <br> `roles:uid:*`                                                            | List roles and read a specific with its permissions.                                                                                                                                             |
| `roles:write`                        | `permissions:type:delegate`                                                             | Create or update a custom role.                                                                                                                                                                  |
| `roles:write`                        | `permissions:type:escalate`                                                             | Reset basic roles to their default permissions.                                                                                                                                                  |
| `server.stats:read`                  | n/a                                                                                     | Read Grafana instance statistics.                                                                                                                                                                |
| `serviceaccounts:write`              | `serviceaccounts:*`                                                                     | Create Grafana service accounts.                                                                                                                                                                 |
| `serviceaccounts:create`             | n/a                                                                                     | Update Grafana service accounts.                                                                                                                                                                 |
| `serviceaccounts:delete`             | `serviceaccounts:*`                                                                     | Delete Grafana service accounts.                                                                                                                                                                 |
| `serviceaccounts:read`               | `serviceaccounts:*`                                                                     | Read Grafana service accounts.                                                                                                                                                                   |
| `serviceaccounts.permissions:write`  | `serviceaccounts:*`                                                                     | Update Grafana service account permissions to control who can do what with the service account.                                                                                                  |
| `serviceaccounts.permissions:read`   | `serviceaccounts:*`                                                                     | Read Grafana service account permissions to see who can do what with the service account.                                                                                                        |
| `settings:read`                      | `settings:*`<br>`settings:auth.saml:*`<br>`settings:auth.saml:enabled` (property level) | Read the [Grafana configuration settings]({{< relref "../../../../setup-grafana/configure-grafana/" >}})                                                                                         |
| `settings:write`                     | `settings:*`<br>`settings:auth.saml:*`<br>`settings:auth.saml:enabled` (property level) | Update any Grafana configuration settings that can be [updated at runtime]({{< relref "../../../../setup-grafana/configure-grafana/settings-updates-at-runtime" >}}).                            |
| `status:accesscontrol`               | `services:accesscontrol`                                                                | Get access-control enabled status.                                                                                                                                                               |
| `teams.permissions:read`             | `teams:*`<br>`teams:id:*`                                                               | Read members and External Group Synchronization setup for teams.                                                                                                                                 |
| `teams.permissions:write`            | `teams:*`<br>`teams:id:*`                                                               | Add, remove and update members and manage External Group Synchronization setup for teams.                                                                                                        |
| `teams.roles:add`                    | `permissions:type:delegate`                                                             | Assign a role to a team.                                                                                                                                                                         |
| `teams.roles:read`                   | `teams:*`                                                                               | List roles assigned directly to a team.                                                                                                                                                          |
| `teams.roles:remove`                 | `permissions:type:delegate`                                                             | Unassign a role from a team.                                                                                                                                                                     |
| `teams:create`                       | n/a                                                                                     | Create teams.                                                                                                                                                                                    |
| `teams:delete`                       | `teams:*`<br>`teams:id:*`                                                               | Delete one or more teams.                                                                                                                                                                        |
| `teams:read`                         | `teams:*`<br>`teams:id:*`                                                               | Read one or more teams and team preferences.                                                                                                                                                     |
| `teams:write`                        | `teams:*`<br>`teams:id:*`                                                               | Update one or more teams and team preferences.                                                                                                                                                   |
| `users.authtoken:read`               | `global.users:*` <br> `global.users:id:*`                                               | List authentication tokens that are assigned to a user.                                                                                                                                          |
| `users.authtoken:write`              | `global.users:*` <br> `global.users:id:*`                                               | Update authentication tokens that are assigned to a user.                                                                                                                                        |
| `users.password:write`               | `global.users:*` <br> `global.users:id:*`                                               | Update a user’s password.                                                                                                                                                                        |
| `users.permissions:read`             | `users:*`                                                                               | List permissions of a user.                                                                                                                                                                      |
| `users.permissions:write`            | `global.users:*` <br> `global.users:id:*`                                               | Update a user’s organization-level permissions.                                                                                                                                                  |
| `users.quotas:read`                  | `global.users:*` <br> `global.users:id:*`                                               | List a user’s quotas.                                                                                                                                                                            |
| `users.quotas:write`                 | `global.users:*` <br> `global.users:id:*`                                               | Update a user’s quotas.                                                                                                                                                                          |
| `users.roles:add`                    | `permissions:type:delegate`                                                             | Assign a role to a user or a service account.                                                                                                                                                    |
| `users.roles:read`                   | `users:*`                                                                               | List roles assigned directly to a user or a service account.                                                                                                                                     |
| `users.roles:remove`                 | `permissions:type:delegate`                                                             | Unassign a role from a user or a service account.                                                                                                                                                |
| `users:create`                       | n/a                                                                                     | Create a user.                                                                                                                                                                                   |
| `users:delete`                       | `global.users:*` <br> `global.users:id:*`                                               | Delete a user.                                                                                                                                                                                   |
| `users:disable`                      | `global.users:*` <br> `global.users:id:*`                                               | Disable a user.                                                                                                                                                                                  |
| `users:enable`                       | `global.users:*` <br> `global.users:id:*`                                               | Enable a user.                                                                                                                                                                                   |
| `users:logout`                       | `global.users:*` <br> `global.users:id:*`                                               | Sign out a user.                                                                                                                                                                                 |
| `users:read`                         | `global.users:*`                                                                        | Read or search user profiles.                                                                                                                                                                    |
| `users:write`                        | `global.users:*` <br> `global.users:id:*`                                               | Update a user’s profile.                                                                                                                                                                         |

## Scope definitions

The following list contains role-based access control scopes.

| Scopes                                          | Descriptions                                                                                                                                                                                                                                       |
| ----------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `annotations:*`<br>`annotations:type:*`         | Restrict an action to a set of annotations. For example, `annotations:*` matches any annotation, `annotations:type:dashboard` matches annotations associated with dashboards and `annotations:type:organization` matches organization annotations. |
| `apikeys:*`<br>`apikeys:id:*`                   | Restrict an action to a set of API keys. For example, `apikeys:*` matches any API key, `apikey:id:1` matches the API key whose id is `1`.                                                                                                          |
| `dashboards:*`<br>`dashboards:uid:*`            | Restrict an action to a set of dashboards. For example, `dashboards:*` matches any dashboard, and `dashboards:uid:1` matches the dashboard whose UID is `1`.                                                                                       |
| `datasources:*`<br>`datasources:uid:*`          | Restrict an action to a set of data sources. For example, `datasources:*` matches any data source, and `datasources:uid:1` matches the data source whose UID is `1`.                                                                               |
| `folders:*`<br>`folders:uid:*`                  | Restrict an action to a set of folders. For example, `folders:*` matches any folder, and `folders:uid:1` matches the folder whose UID is `1`.                                                                                                      |
| `global.users:*` <br> `global.users:id:*`       | Restrict an action to a set of global users. For example, `global.users:*` matches any user and `global.users:id:1` matches the user whose ID is `1`.                                                                                              |
| `orgs:*` <br> `orgs:id:*`                       | Restrict an action to a set of organizations. For example, `orgs:*` matches any organization and `orgs:id:1` matches the organization whose ID is `1`.                                                                                             |
| `permissions:type:delegate`                     | The scope is only applicable for roles associated with the Access Control itself and indicates that you can delegate your permissions only, or a subset of it, by creating a new role or making an assignment.                                     |
| `permissions:type:escalate`                     | The scope is required to trigger the reset of basic roles permissions. It indicates that users might acquire additional permissions they did not previously have.                                                                                  |
| `provisioners:*`                                | Restrict an action to a set of provisioners. For example, `provisioners:*` matches any provisioner, and `provisioners:accesscontrol` matches the role-based access control [provisioner]({{< relref "./rbac-provisioning/" >}}).                   |
| `reports:*` <br> `reports:id:*`                 | Restrict an action to a set of reports. For example, `reports:*` matches any report and `reports:id:1` matches the report whose ID is `1`.                                                                                                         |
| `roles:*` <br> `roles:uid:*`                    | Restrict an action to a set of roles. For example, `roles:*` matches any role and `roles:uid:randomuid` matches only the role whose UID is `randomuid`.                                                                                            |
| `services:accesscontrol`                        | Restrict an action to target only the role-based access control service. You can use this in conjunction with the `status:accesscontrol` actions.                                                                                                  |
| `serviceaccounts:*` <br> `serviceaccounts:id:*` | Restrict an action to a set of service account from an organization. For example, `serviceaccounts:*` matches any service account and `serviceaccount:id:1` matches the service account whose ID is `1`.                                           |
| `settings:*`                                    | Restrict an action to a subset of settings. For example, `settings:*` matches all settings, `settings:auth.saml:*` matches all SAML settings, and `settings:auth.saml:enabled` matches the enable property on the SAML settings.                   |
| `teams:*` <br> `teams:id:*`                     | Restrict an action to a set of teams from an organization. For example, `teams:*` matches any team and `teams:id:1` matches the team whose ID is `1`.                                                                                              |
| `users:*` <br> `users:id:*`                     | Restrict an action to a set of users from an organization. For example, `users:*` matches any user and `users:id:1` matches the user whose ID is `1`.                                                                                              |
