/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collection;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.ssl.CipherPolicy;
import org.mozilla.jss.ssl.SSLAlertEvent;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import org.mozilla.jss.ssl.SSLClientCertificateSelectionCallback;
import org.mozilla.jss.ssl.SSLHandshakeCompletedEvent;
import org.mozilla.jss.ssl.SSLHandshakeCompletedListener;
import org.mozilla.jss.ssl.SSLInputStream;
import org.mozilla.jss.ssl.SSLOutputStream;
import org.mozilla.jss.ssl.SSLProtocolVariant;
import org.mozilla.jss.ssl.SSLSecurityStatus;
import org.mozilla.jss.ssl.SSLSocketListener;
import org.mozilla.jss.ssl.SSLVersionRange;
import org.mozilla.jss.ssl.SocketBase;
import org.mozilla.jss.ssl.SocketProxy;

public class SSLSocket
extends Socket {
    public static final int SSL2_RC4_128_WITH_MD5 = 65281;
    public static final int SSL2_RC4_128_EXPORT40_WITH_MD5 = 65282;
    public static final int SSL2_RC2_128_CBC_WITH_MD5 = 65283;
    public static final int SSL2_RC2_128_CBC_EXPORT40_WITH_MD5 = 65284;
    public static final int SSL2_IDEA_128_CBC_WITH_MD5 = 65285;
    public static final int SSL2_DES_64_CBC_WITH_MD5 = 65286;
    public static final int SSL2_DES_192_EDE3_CBC_WITH_MD5 = 65287;
    public static final int TLS_NULL_WITH_NULL_NULL = 0;
    @Deprecated
    public static final int SSL3_RSA_WITH_NULL_MD5 = 1;
    public static final int TLS_RSA_WITH_NULL_MD5 = 1;
    @Deprecated
    public static final int SSL3_RSA_WITH_NULL_SHA = 2;
    public static final int TLS_RSA_WITH_NULL_SHA = 2;
    public static final int SSL3_RSA_EXPORT_WITH_RC4_40_MD5 = 3;
    public static final int TLS_RSA_EXPORT_WITH_RC4_40_MD5 = 3;
    @Deprecated
    public static final int SSL3_RSA_WITH_RC4_128_MD5 = 4;
    public static final int TLS_RSA_WITH_RC4_128_MD5 = 4;
    @Deprecated
    public static final int SSL3_RSA_WITH_RC4_128_SHA = 5;
    public static final int TLS_RSA_WITH_RC4_128_SHA = 5;
    public static final int SSL3_RSA_EXPORT_WITH_RC2_CBC_40_MD5 = 6;
    public static final int TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5 = 6;
    @Deprecated
    public static final int SSL3_RSA_WITH_IDEA_CBC_SHA = 7;
    public static final int TLS_RSA_WITH_IDEA_CBC_SHA = 7;
    public static final int SSL3_RSA_EXPORT_WITH_DES40_CBC_SHA = 8;
    public static final int TLS_RSA_EXPORT_WITH_DES40_CBC_SHA = 8;
    @Deprecated
    public static final int SSL3_RSA_WITH_DES_CBC_SHA = 9;
    public static final int TLS_RSA_WITH_DES_CBC_SHA = 9;
    @Deprecated
    public static final int SSL3_RSA_WITH_3DES_EDE_CBC_SHA = 10;
    public static final int TLS_RSA_WITH_3DES_EDE_CBC_SHA = 10;
    public static final int SSL3_DH_DSS_EXPORT_WITH_DES40_CBC_SHA = 11;
    public static final int TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA = 11;
    @Deprecated
    public static final int SSL3_DH_DSS_WITH_DES_CBC_SHA = 12;
    public static final int TLS_DH_DSS_WITH_DES_CBC_SHA = 12;
    @Deprecated
    public static final int SSL3_DH_DSS_WITH_3DES_EDE_CBC_SHA = 13;
    public static final int TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA = 13;
    public static final int SSL3_DH_RSA_EXPORT_WITH_DES40_CBC_SHA = 14;
    public static final int TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA = 14;
    @Deprecated
    public static final int SSL3_DH_RSA_WITH_DES_CBC_SHA = 15;
    public static final int TLS_DH_RSA_WITH_DES_CBC_SHA = 15;
    @Deprecated
    public static final int SSL3_DH_RSA_WITH_3DES_EDE_CBC_SHA = 16;
    public static final int TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA = 16;
    public static final int SSL3_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA = 17;
    public static final int TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA = 17;
    @Deprecated
    public static final int SSL3_DHE_DSS_WITH_DES_CBC_SHA = 18;
    public static final int TLS_DHE_DSS_WITH_DES_CBC_SHA = 18;
    @Deprecated
    public static final int SSL3_DHE_DSS_WITH_3DES_EDE_CBC_SHA = 19;
    public static final int TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA = 19;
    public static final int SSL3_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA = 20;
    public static final int TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA = 20;
    @Deprecated
    public static final int SSL3_DHE_RSA_WITH_DES_CBC_SHA = 21;
    public static final int TLS_DHE_RSA_WITH_DES_CBC_SHA = 21;
    @Deprecated
    public static final int SSL3_DHE_RSA_WITH_3DES_EDE_CBC_SHA = 22;
    public static final int TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA = 22;
    public static final int SSL3_DH_ANON_EXPORT_WITH_RC4_40_MD5 = 23;
    public static final int TLS_DH_anon_EXPORT_WITH_RC4_40_MD5 = 23;
    @Deprecated
    public static final int SSL3_DH_ANON_WITH_RC4_128_MD5 = 24;
    public static final int TLS_DH_anon_WITH_RC4_128_MD5 = 24;
    public static final int SSL3_DH_ANON_EXPORT_WITH_DES40_CBC_SHA = 25;
    public static final int TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA = 25;
    @Deprecated
    public static final int SSL3_DH_ANON_WITH_DES_CBC_SHA = 26;
    public static final int TLS_DH_anon_WITH_DES_CBC_SHA = 26;
    @Deprecated
    public static final int SSL3_DH_ANON_WITH_3DES_EDE_CBC_SHA = 27;
    public static final int TLS_DH_anon_WITH_3DES_EDE_CBC_SHA = 27;
    @Deprecated
    public static final int SSL3_FORTEZZA_DMS_WITH_NULL_SHA = 28;
    @Deprecated
    public static final int SSL3_FORTEZZA_DMS_WITH_FORTEZZA_CBC_SHA = 29;
    @Deprecated
    public static final int SSL3_FORTEZZA_DMS_WITH_RC4_128_SHA = 30;
    public static final int SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA = 65279;
    public static final int SSL_RSA_FIPS_WITH_DES_CBC_SHA = 65278;
    public static final int TLS_RSA_EXPORT1024_WITH_DES_CBC_SHA = 98;
    public static final int TLS_RSA_EXPORT1024_WITH_RC4_56_SHA = 100;
    public static final int TLS_DHE_DSS_EXPORT1024_WITH_DES_CBC_SHA = 99;
    public static final int TLS_DHE_DSS_EXPORT1024_WITH_RC4_56_SHA = 101;
    public static final int TLS_DHE_DSS_WITH_RC4_128_SHA = 102;
    public static final int TLS_DHE_RSA_WITH_AES_128_CBC_SHA256 = 103;
    public static final int TLS_DHE_DSS_WITH_AES_256_CBC_SHA256 = 106;
    public static final int TLS_DHE_RSA_WITH_AES_256_CBC_SHA256 = 107;
    public static final int TLS_RSA_WITH_AES_128_CBC_SHA = 47;
    public static final int TLS_DH_DSS_WITH_AES_128_CBC_SHA = 48;
    public static final int TLS_DH_RSA_WITH_AES_128_CBC_SHA = 49;
    public static final int TLS_DHE_DSS_WITH_AES_128_CBC_SHA = 50;
    public static final int TLS_DHE_RSA_WITH_AES_128_CBC_SHA = 51;
    @Deprecated
    public static final int TLS_DH_ANON_WITH_AES_128_CBC_SHA = 52;
    public static final int TLS_DH_anon_WITH_AES_128_CBC_SHA = 52;
    public static final int TLS_RSA_WITH_AES_256_CBC_SHA = 53;
    public static final int TLS_DH_DSS_WITH_AES_256_CBC_SHA = 54;
    public static final int TLS_DH_RSA_WITH_AES_256_CBC_SHA = 55;
    public static final int TLS_DHE_DSS_WITH_AES_256_CBC_SHA = 56;
    public static final int TLS_DHE_RSA_WITH_AES_256_CBC_SHA = 57;
    @Deprecated
    public static final int TLS_DH_ANON_WITH_AES_256_CBC_SHA = 58;
    public static final int TLS_DH_anon_WITH_AES_256_CBC_SHA = 58;
    public static final int TLS_RSA_WITH_NULL_SHA256 = 59;
    public static final int TLS_RSA_WITH_AES_128_CBC_SHA256 = 60;
    public static final int TLS_RSA_WITH_AES_256_CBC_SHA256 = 61;
    public static final int TLS_DHE_DSS_WITH_AES_128_CBC_SHA256 = 64;
    public static final int TLS_RSA_WITH_CAMELLIA_128_CBC_SHA = 65;
    public static final int TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA = 66;
    public static final int TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA = 67;
    public static final int TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA = 68;
    public static final int TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA = 69;
    @Deprecated
    public static final int TLS_DH_ANON_WITH_CAMELLIA_128_CBC_SHA = 70;
    public static final int TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA = 70;
    public static final int TLS_RSA_WITH_CAMELLIA_256_CBC_SHA = 132;
    public static final int TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA = 133;
    public static final int TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA = 134;
    public static final int TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA = 135;
    public static final int TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA = 136;
    @Deprecated
    public static final int TLS_DH_ANON_WITH_CAMELLIA_256_CBC_SHA = 137;
    public static final int TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA = 137;
    public static final int TLS_RSA_WITH_SEED_CBC_SHA = 150;
    public static final int TLS_RSA_WITH_AES_128_GCM_SHA256 = 156;
    public static final int TLS_RSA_WITH_AES_256_GCM_SHA384 = 157;
    public static final int TLS_DHE_RSA_WITH_AES_128_GCM_SHA256 = 158;
    public static final int TLS_DHE_RSA_WITH_AES_256_GCM_SHA384 = 159;
    public static final int TLS_DHE_DSS_WITH_AES_128_GCM_SHA256 = 162;
    public static final int TLS_DHE_DSS_WITH_AES_256_GCM_SHA384 = 163;
    public static final int TLS_DHE_PSK_WITH_AES_128_GCM_SHA256 = 170;
    public static final int TLS_DHE_PSK_WITH_AES_256_GCM_SHA384 = 171;
    public static final int TLS_EMPTY_RENEGOTIATION_INFO_SCSV = 255;
    public static final int TLS_FALLBACK_SCSV = 22016;
    public static final int TLS_ECDH_ECDSA_WITH_NULL_SHA = 49153;
    public static final int TLS_ECDH_ECDSA_WITH_RC4_128_SHA = 49154;
    public static final int TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA = 49155;
    public static final int TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA = 49156;
    public static final int TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA = 49157;
    public static final int TLS_ECDHE_ECDSA_WITH_NULL_SHA = 49158;
    public static final int TLS_ECDHE_ECDSA_WITH_RC4_128_SHA = 49159;
    public static final int TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA = 49160;
    public static final int TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA = 49161;
    public static final int TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA = 49162;
    public static final int TLS_ECDH_RSA_WITH_NULL_SHA = 49163;
    public static final int TLS_ECDH_RSA_WITH_RC4_128_SHA = 49164;
    public static final int TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA = 49165;
    public static final int TLS_ECDH_RSA_WITH_AES_128_CBC_SHA = 49166;
    public static final int TLS_ECDH_RSA_WITH_AES_256_CBC_SHA = 49167;
    public static final int TLS_ECDHE_RSA_WITH_NULL_SHA = 49168;
    public static final int TLS_ECDHE_RSA_WITH_RC4_128_SHA = 49169;
    public static final int TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA = 49170;
    public static final int TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA = 49171;
    public static final int TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA = 49172;
    public static final int TLS_ECDH_anon_WITH_NULL_SHA = 49173;
    public static final int TLS_ECDH_anon_WITH_RC4_128_SHA = 49174;
    public static final int TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA = 49175;
    public static final int TLS_ECDH_anon_WITH_AES_128_CBC_SHA = 49176;
    public static final int TLS_ECDH_anon_WITH_AES_256_CBC_SHA = 49177;
    public static final int TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256 = 49187;
    public static final int TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384 = 49188;
    public static final int TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256 = 49191;
    public static final int TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384 = 49192;
    public static final int TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256 = 49195;
    public static final int TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384 = 49196;
    public static final int TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256 = 49197;
    public static final int TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256 = 49199;
    public static final int TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384 = 49200;
    public static final int TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256 = 49201;
    public static final int TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256 = 52392;
    public static final int TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256 = 52393;
    public static final int TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256 = 52394;
    public static final int TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256 = 52396;
    public static final int TLS_DHE_PSK_WITH_CHACHA20_POLY1305_SHA256 = 52397;
    public static final int TLS_ECDHE_PSK_WITH_AES_128_GCM_SHA256 = 53249;
    public static final int TLS_ECDHE_PSK_WITH_AES_256_GCM_SHA384 = 53250;
    public static final int TLS_AES_128_GCM_SHA256 = 4865;
    public static final int TLS_AES_256_GCM_SHA384 = 4866;
    public static final int TLS_CHACHA20_POLY1305_SHA256 = 4867;
    private Object readLock = new Object();
    private Object writeLock = new Object();
    private boolean isClosed = false;
    private boolean inRead = false;
    private boolean inWrite = false;
    private InetAddress inetAddress;
    private int port;
    private SocketProxy sockProxy = null;
    private boolean open = false;
    private boolean handshakeAsClient = true;
    private SocketBase base = new SocketBase();
    public static final int SSL_REQUIRE_NEVER = 17;
    public static final int SSL_REQUIRE_ALWAYS = 18;
    public static final int SSL_REQUIRE_FIRST_HANDSHAKE = 19;
    public static final int SSL_REQUIRE_NO_ERROR = 20;
    public static final int SSL_RENEGOTIATE_NEVER = 23;
    public static final int SSL_RENEGOTIATE_REQUIRES_XTN = 25;
    public static final int SSL_RENEGOTIATE_UNRESTRICTED = 24;
    public static final int SSL_RENEGOTIATE_TRANSITIONAL = 26;
    private Collection<SSLSocketListener> socketListeners = new ArrayList<SSLSocketListener>();
    private Collection<SSLHandshakeCompletedListener> handshakeCompletedListeners = new ArrayList<SSLHandshakeCompletedListener>();

    SSLSocket() {
    }

    void setSockProxy(SocketProxy sp) {
        this.sockProxy = sp;
        this.base.setProxy(sp);
    }

    public SSLSocket(String host, int port) throws IOException {
        this(InetAddress.getByName(host), port, null, 0);
    }

    public SSLSocket(InetAddress address, int port) throws IOException {
        this(address, port, null, 0);
    }

    public SSLSocket(String host, int port, InetAddress localAddr, int localPort) throws IOException {
        this(InetAddress.getByName(host), port, localAddr, localPort);
    }

    public SSLSocket(InetAddress address, int port, InetAddress localAddr, int localPort) throws IOException {
        this(address, port, localAddr, localPort, null, null);
    }

    public SSLSocket(String host, int port, InetAddress localAddr, int localPort, SSLCertificateApprovalCallback certApprovalCallback, SSLClientCertificateSelectionCallback clientCertSelectionCallback) throws IOException {
        this(InetAddress.getByName(host), port, localAddr, localPort, certApprovalCallback, clientCertSelectionCallback);
    }

    @Deprecated
    public SSLSocket(InetAddress address, int port, InetAddress localAddr, int localPort, boolean stream, SSLCertificateApprovalCallback certApprovalCallback, SSLClientCertificateSelectionCallback clientCertSelectionCallback) throws IOException {
        this(address, port, localAddr, localPort, certApprovalCallback, clientCertSelectionCallback);
    }

    public SSLSocket(InetAddress address, int port, InetAddress localAddr, int localPort, SSLCertificateApprovalCallback certApprovalCallback, SSLClientCertificateSelectionCallback clientCertSelectionCallback) throws IOException {
        this(address, address.getHostName(), port, localAddr, localPort, certApprovalCallback, clientCertSelectionCallback);
    }

    private SSLSocket(InetAddress address, String hostname, int port, InetAddress localAddr, int localPort, SSLCertificateApprovalCallback certApprovalCallback, SSLClientCertificateSelectionCallback clientCertSelectionCallback) throws IOException {
        int socketFamily = 50;
        if (SocketBase.supportsIPV6()) {
            socketFamily = 51;
        }
        this.sockProxy = new SocketProxy(this.base.socketCreate(this, certApprovalCallback, clientCertSelectionCallback, socketFamily));
        this.base.setProxy(this.sockProxy);
        if (localAddr != null || localPort > 0) {
            byte[] addrBA = null;
            if (localAddr != null) {
                addrBA = localAddr.getAddress();
            }
            this.base.socketBind(addrBA, localPort);
        }
        this.socketConnect(address.getAddress(), hostname, port);
    }

    public SSLSocket(Socket s, String host, SSLCertificateApprovalCallback certApprovalCallback, SSLClientCertificateSelectionCallback clientCertSelectionCallback) throws IOException {
        this.sockProxy = new SocketProxy(this.base.socketCreate(this, certApprovalCallback, clientCertSelectionCallback, s, host, 50));
        this.base.setProxy(this.sockProxy);
        this.resetHandshake();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InetAddress getInetAddress() {
        SSLSocket sSLSocket = this;
        synchronized (sSLSocket) {
            if (this.isClosed) {
                return null;
            }
            return this.base.getInetAddress();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InetAddress getLocalAddress() {
        SSLSocket sSLSocket = this;
        synchronized (sSLSocket) {
            if (this.isClosed) {
                return null;
            }
            return this.base.getLocalAddress();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLocalPort() {
        SSLSocket sSLSocket = this;
        synchronized (sSLSocket) {
            if (this.isClosed) {
                return -1;
            }
            return this.base.getLocalPort();
        }
    }

    @Override
    public native int getPort();

    @Override
    public InputStream getInputStream() throws IOException {
        return new SSLInputStream(this);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return new SSLOutputStream(this);
    }

    @Override
    public native void setTcpNoDelay(boolean var1) throws SocketException;

    @Override
    public native boolean getTcpNoDelay() throws SocketException;

    @Override
    public native void setKeepAlive(boolean var1) throws SocketException;

    @Override
    public native boolean getKeepAlive() throws SocketException;

    @Override
    public void shutdownInput() throws IOException {
        this.shutdownNative(5);
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.shutdownNative(6);
    }

    private native void shutdownNative(int var1) throws IOException;

    private native void abortReadWrite() throws IOException;

    @Override
    public native void setSoLinger(boolean var1, int var2) throws SocketException;

    @Override
    public native int getSoLinger() throws SocketException;

    @Override
    public synchronized void setSoTimeout(int timeout) throws SocketException {
        this.base.setTimeout(timeout);
    }

    @Override
    public synchronized int getSoTimeout() throws SocketException {
        return this.base.getTimeout();
    }

    @Override
    public synchronized native void setSendBufferSize(int var1) throws SocketException;

    @Override
    public synchronized native int getSendBufferSize() throws SocketException;

    @Override
    public synchronized native void setReceiveBufferSize(int var1) throws SocketException;

    @Override
    public synchronized native int getReceiveBufferSize() throws SocketException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this;
        synchronized (object) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            if (this.sockProxy == null) {
                return;
            }
            if (this.inRead || this.inWrite) {
                this.abortReadWrite();
            }
        }
        object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                this.base.close();
                this.sockProxy = null;
                this.base.setProxy(null);
            }
        }
    }

    private native void socketConnect(byte[] var1, String var2, int var3) throws SocketException;

    public void addSocketListener(SSLSocketListener listener) {
        this.socketListeners.add(listener);
        this.addHandshakeCompletedListener(listener);
    }

    public void removeSocketListener(SSLSocketListener listener) {
        this.socketListeners.remove(listener);
        this.removeHandshakeCompletedListener(listener);
    }

    private void fireAlertReceivedEvent(SSLAlertEvent event) {
        for (SSLSocketListener listener : this.socketListeners) {
            listener.alertReceived(event);
        }
    }

    private void fireAlertSentEvent(SSLAlertEvent event) {
        for (SSLSocketListener listener : this.socketListeners) {
            listener.alertSent(event);
        }
    }

    public void addHandshakeCompletedListener(SSLHandshakeCompletedListener listener) {
        this.handshakeCompletedListeners.add(listener);
    }

    public void removeHandshakeCompletedListener(SSLHandshakeCompletedListener listener) {
        this.handshakeCompletedListeners.remove(listener);
    }

    private void notifyAllHandshakeListeners() {
        SSLHandshakeCompletedEvent event = new SSLHandshakeCompletedEvent(this);
        for (SSLHandshakeCompletedListener listener : this.handshakeCompletedListeners) {
            listener.handshakeCompleted(event);
        }
    }

    public void enableSSL2(boolean enable) throws SocketException {
        this.base.enableSSL2(enable);
    }

    public static void enableSSL2Default(boolean enable) throws SocketException {
        SSLSocket.setSSLDefaultOption(0, enable);
    }

    public void enableSSL3(boolean enable) throws SocketException {
        this.base.enableSSL3(enable);
    }

    public static void enableSSL3Default(boolean enable) throws SocketException {
        SSLSocket.setSSLDefaultOption(1, enable);
    }

    public void enableTLS(boolean enable) throws SocketException {
        this.base.enableTLS(enable);
    }

    public static void enableTLSDefault(boolean enable) throws SocketException {
        SSLSocket.setSSLDefaultOption(2, enable);
    }

    public void enableSessionTickets(boolean enable) throws SocketException {
        this.base.enableSessionTickets(enable);
    }

    public static void enableSessionTicketsDefault(boolean enable) throws SocketException {
        SSLSocket.setSSLDefaultOption(21, enable);
    }

    public void enableRenegotiation(int mode) throws SocketException {
        if (mode < 23 || mode > 26) {
            throw new SocketException("Incorrect input value.");
        }
        this.base.enableRenegotiation(mode);
    }

    public static void enableRenegotiationDefault(int mode) throws SocketException {
        if (mode < 23 || mode > 26) {
            throw new SocketException("Incorrect input value.");
        }
        SSLSocket.setSSLDefaultOptionMode(22, mode);
    }

    public void enableRequireSafeNegotiation(boolean enable) throws SocketException {
        this.base.enableRequireSafeNegotiation(enable);
    }

    public static void enableRequireSafeNegotiationDefault(boolean enable) throws SocketException {
        SSLSocket.setSSLDefaultOption(27, enable);
    }

    public void enableRollbackDetection(boolean enable) throws SocketException {
        this.base.enableRollbackDetection(enable);
    }

    static void enableRollbackDetectionDefault(boolean enable) throws SocketException {
        SSLSocket.setSSLDefaultOption(13, enable);
    }

    public void enableStepDown(boolean enable) throws SocketException {
        this.base.enableStepDown(enable);
    }

    static void enableStepDownDefault(boolean enable) throws SocketException {
        SSLSocket.setSSLDefaultOption(14, enable);
    }

    public void enableFDX(boolean enable) throws SocketException {
        this.base.enableFDX(enable);
    }

    static void enableFDXDefault(boolean enable) throws SocketException {
        SSLSocket.setSSLDefaultOption(15, enable);
    }

    public void enableV2CompatibleHello(boolean enable) throws SocketException {
        this.base.enableV2CompatibleHello(enable);
    }

    static void enableV2CompatibleHelloDefault(boolean enable) throws SocketException {
        SSLSocket.setSSLDefaultOption(16, enable);
    }

    public void enablePostHandshakeAuth(boolean enable) throws SocketException {
        this.base.enablePostHandshakeAuth(enable);
    }

    public static void enablePostHandshakeAuthDefault(boolean enable) throws SocketException {
        SSLSocket.setSSLDefaultOption(36, enable);
    }

    public String getSSLOptions() {
        return this.base.getSSLOptions();
    }

    private static native int getSSLDefaultOption(int var0) throws SocketException;

    public static String getSSLDefaultOptions() {
        StringBuffer buf = new StringBuffer();
        try {
            buf.append("Default Options configured for all SSLSockets: ");
            buf.append("\nSSL_ENABLE_SSL2" + (SSLSocket.getSSLDefaultOption(0) != 0 ? "=on" : "=off"));
            buf.append("\nSSL_ENABLE_SSL3" + (SSLSocket.getSSLDefaultOption(1) != 0 ? "=on" : "=off"));
            buf.append("\nSSL_ENABLE_TLS" + (SSLSocket.getSSLDefaultOption(2) != 0 ? "=on" : "=off"));
            buf.append("\nSSL_ENABLE_SESSION_TICKETS" + (SSLSocket.getSSLDefaultOption(21) != 0 ? "=on" : "=off"));
            buf.append("\nSSL_REQUIRE_CERTIFICATE");
            switch (SSLSocket.getSSLDefaultOption(7)) {
                case 0: {
                    buf.append("=Never");
                    break;
                }
                case 1: {
                    buf.append("=Always");
                    break;
                }
                case 2: {
                    buf.append("=First Handshake");
                    break;
                }
                case 3: {
                    buf.append("=No Error");
                    break;
                }
                default: {
                    buf.append("=Report JSS Bug this option has a status.");
                }
            }
            buf.append("\nSSL_REQUEST_CERTIFICATE" + (SSLSocket.getSSLDefaultOption(8) != 0 ? "=on" : "=off"));
            buf.append("\nSSL_NO_CACHE" + (SSLSocket.getSSLDefaultOption(9) != 0 ? "=on" : "=off"));
            buf.append("\nSSL_ROLLBACK_DETECTION" + (SSLSocket.getSSLDefaultOption(13) != 0 ? "=on" : "=off"));
            buf.append("\nSSL_NO_STEP_DOWN" + (SSLSocket.getSSLDefaultOption(14) != 0 ? "=on" : "=off"));
            buf.append("\nSSL_ENABLE_FDX" + (SSLSocket.getSSLDefaultOption(15) != 0 ? "=on" : "=off"));
            buf.append("\nSSL_V2_COMPATIBLE_HELLO" + (SSLSocket.getSSLDefaultOption(16) != 0 ? "=on" : "=off"));
            buf.append("\nSSL_ENABLE_SESSION_TICKETS" + (SSLSocket.getSSLDefaultOption(21) != 0 ? "=on" : "=off"));
            buf.append("\nSSL_ENABLE_RENEGOTIATION");
            switch (SSLSocket.getSSLDefaultOption(22)) {
                case 0: {
                    buf.append("=SSL_RENEGOTIATE_NEVER");
                    break;
                }
                case 1: {
                    buf.append("=SSL_RENEGOTIATE_UNRESTRICTED");
                    break;
                }
                case 2: {
                    buf.append("=SSL_RENEGOTIATE_REQUIRES_XTN");
                    break;
                }
                case 3: {
                    buf.append("=SSL_RENEGOTIATE_TRANSITIONAL");
                    break;
                }
                default: {
                    buf.append("=Report JSS Bug this option has a status.");
                }
            }
            buf.append("\nSSL_REQUIRE_SAFE_NEGOTIATION" + (SSLSocket.getSSLDefaultOption(27) != 0 ? "=on" : "=off"));
        }
        catch (SocketException e) {
            buf.append("\ngetSSLDefaultOptions exception " + e.getMessage());
        }
        return buf.toString();
    }

    @Deprecated
    public void requireClientAuth(boolean require, boolean onRedo) throws SocketException {
        this.base.requireClientAuth(require, onRedo);
    }

    public void requireClientAuth(int mode) throws SocketException {
        if (mode < 17 || mode > 20) {
            throw new SocketException("Incorrect input value.");
        }
        this.base.requireClientAuth(mode);
    }

    @Deprecated
    public void requireClientAuthDefault(boolean require, boolean onRedo) throws SocketException {
        SSLSocket.setSSLDefaultOption(7, require ? (onRedo ? 1 : 2) : 0);
    }

    public static void requireClientAuthDefault(int mode) throws SocketException {
        if (mode < 17 || mode > 20) {
            throw new SocketException("Incorrect input value.");
        }
        SSLSocket.setSSLDefaultOption(8, true);
        SSLSocket.setSSLDefaultOptionMode(7, mode);
    }

    public native void forceHandshake() throws SocketException;

    public void setUseClientMode(boolean b) {
        this.handshakeAsClient = b;
    }

    public boolean getUseClientMode() {
        return this.handshakeAsClient;
    }

    public void resetHandshake() throws SocketException {
        this.resetHandshakeNative(this.handshakeAsClient);
    }

    private native void resetHandshakeNative(boolean var1) throws SocketException;

    public native SSLSecurityStatus getStatus() throws SocketException;

    public void setClientCertNickname(String nick) throws SocketException {
        this.base.setClientCertNickname(nick);
    }

    public void setClientCert(X509Certificate cert) throws SocketException {
        this.base.setClientCert(cert);
    }

    public void requestClientAuth(boolean b) throws SocketException {
        this.base.requestClientAuth(b);
    }

    @Deprecated
    public void setNeedClientAuth(boolean b) throws SocketException {
        this.base.requestClientAuth(b);
    }

    @Deprecated
    public void setNeedClientAuthNoExpiryCheck(boolean b) throws SocketException {
        this.base.requestClientAuthNoExpiryCheck(b);
    }

    public void useCache(boolean b) throws SocketException {
        this.base.useCache(b);
    }

    public void useCacheDefault(boolean b) throws SocketException {
        SSLSocket.setSSLDefaultOption(9, !b);
    }

    public static void setSSLVersionRangeDefault(SSLProtocolVariant ssl_variant, SSLVersionRange range) throws SocketException {
        if (range == null) {
            throw new SocketException("setSSLVersionRangeDefault: range null");
        }
        SSLSocket.setSSLVersionRangeDefault(ssl_variant.getEnum(), range.getMinVersion().value(), range.getMaxVersion().value());
    }

    public static SSLVersionRange boundSSLVersionRange(SSLProtocolVariant ssl_variant, SSLVersionRange range) throws SocketException {
        if (range == null) {
            throw new SocketException("setSSLVersionRangeDefault: range null");
        }
        return SSLSocket.boundSSLVersionRange(ssl_variant.getEnum(), range.getMinVersion().value(), range.getMaxVersion().value());
    }

    private static native void setSSLVersionRangeDefault(int var0, int var1, int var2) throws SocketException;

    private static native SSLVersionRange boundSSLVersionRange(int var0, int var1, int var2) throws SocketException;

    private static void setSSLDefaultOption(int option, boolean on) throws SocketException {
        SSLSocket.setSSLDefaultOption(option, on ? 1 : 0);
    }

    private static native void setSSLDefaultOption(int var0, int var1) throws SocketException;

    private static native void setSSLDefaultOptionMode(int var0, int var1) throws SocketException;

    public native void setCipherPreference(int var1, boolean var2) throws SocketException;

    public native boolean getCipherPreference(int var1) throws SocketException;

    public static native void setCipherPreferenceDefault(int var0, boolean var1) throws SocketException;

    public static native boolean getCipherPreferenceDefault(int var0) throws SocketException;

    native int socketAvailable() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int read(byte[] b, int off, int len) throws IOException, SocketTimeoutException {
        Object object = this.readLock;
        synchronized (object) {
            int iRet;
            SSLSocket sSLSocket = this;
            synchronized (sSLSocket) {
                if (this.isClosed) {
                    throw new IOException("Socket has been closed, and cannot be reused.");
                }
                this.inRead = true;
            }
            try {
                iRet = this.socketRead(b, off, len, this.base.getTimeout());
            }
            catch (SocketTimeoutException ste) {
                throw new SocketTimeoutException("SocketTimeoutException cannot read on socket: " + ste);
            }
            catch (IOException ioe) {
                throw new IOException("SocketException cannot read on socket: " + ioe.getMessage(), ioe);
            }
            finally {
                SSLSocket sSLSocket2 = this;
                synchronized (sSLSocket2) {
                    this.inRead = false;
                }
            }
            return iRet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(byte[] b, int off, int len) throws IOException, SocketTimeoutException {
        Object object = this.writeLock;
        synchronized (object) {
            SSLSocket sSLSocket = this;
            synchronized (sSLSocket) {
                if (this.isClosed) {
                    throw new IOException("Socket has been closed, and cannot be reused.");
                }
                this.inWrite = true;
            }
            try {
                this.socketWrite(b, off, len, this.base.getTimeout());
            }
            catch (SocketTimeoutException ste) {
                throw new SocketTimeoutException("SocketTimeoutException cannot write on socket: " + ste);
            }
            catch (IOException ioe) {
                throw new IOException("SocketException cannot write on socket: " + ioe.getMessage(), ioe);
            }
            finally {
                SSLSocket sSLSocket2 = this;
                synchronized (sSLSocket2) {
                    this.inWrite = false;
                }
            }
        }
    }

    private native int socketRead(byte[] var1, int var2, int var3, int var4) throws IOException;

    private native void socketWrite(byte[] var1, int var2, int var3, int var4) throws IOException;

    public native void invalidateSession() throws SocketException;

    public void redoHandshake() throws SocketException {
        this.redoHandshake(false);
    }

    public native void redoHandshake(boolean var1) throws SocketException;

    @Deprecated
    protected void finalize() throws Throwable {
        this.close();
    }

    public static void setCipherPolicy(CipherPolicy cp) throws SocketException {
        SSLSocket.setCipherPolicyNative(cp.getEnum());
    }

    private static native void setCipherPolicyNative(int var0) throws SocketException;

    @Override
    public String toString() {
        try {
            InetAddress inetAddr = this.getInetAddress();
            InetAddress localAddr = this.getLocalAddress();
            int port = this.getPort();
            int localPort = this.getLocalPort();
            StringBuffer buf = new StringBuffer();
            buf.append("SSLSocket[addr=");
            buf.append(inetAddr);
            buf.append(",localaddr=");
            buf.append(localAddr);
            buf.append(",port=");
            buf.append(port);
            buf.append(",localport=");
            buf.append(localPort);
            buf.append("]");
            return buf.toString();
        }
        catch (Exception e) {
            return "Exception caught in toString(): " + e.getMessage();
        }
    }

    public static boolean isFipsCipherSuite(int ciphersuite) throws SocketException {
        return SSLSocket.isFipsCipherSuiteNative(ciphersuite);
    }

    private static native boolean isFipsCipherSuiteNative(int var0) throws SocketException;

    public static native int[] getImplementedCipherSuites();
}

