/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Header;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.Form;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.Tag;

public class BOOLEAN
implements ASN1Value {
    public static final Tag TAG = new Tag(Tag.Class.UNIVERSAL, 1L);
    public static final Form FORM = Form.PRIMITIVE;
    private boolean val;
    private static final Template templateInstance = new Template();

    @Override
    public Tag getTag() {
        return TAG;
    }

    private ASN1Header getHeader(Tag implicitTag) {
        return new ASN1Header(implicitTag, FORM, 1L);
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    @Override
    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.getHeader(implicitTag).encode(ostream);
        if (this.val) {
            ostream.write(255);
        } else {
            ostream.write(0);
        }
    }

    public BOOLEAN(boolean val) {
        this.val = val;
    }

    public boolean toBoolean() {
        return this.val;
    }

    public String toString() {
        return this.val ? "true" : "false";
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        @Override
        public boolean tagMatch(Tag tag) {
            return tag.equals(TAG);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        @Override
        public ASN1Value decode(Tag tag, InputStream istream) throws IOException, InvalidBERException {
            try {
                ASN1Header head = new ASN1Header(istream);
                head.validate(tag, FORM);
                int b = istream.read();
                if (b == -1) {
                    throw new InvalidBERException("End-of-file reached while decoding BOOLEAN");
                }
                return b == 0 ? new BOOLEAN(false) : new BOOLEAN(true);
            }
            catch (InvalidBERException e) {
                throw new InvalidBERException(e, "BOOLEAN");
            }
        }
    }
}

