/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.BigInt;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.x509.CertAttrSet;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.OIDMap;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;

public class DeltaCRLIndicatorExtension
extends Extension
implements CertAttrSet {
    private static final long serialVersionUID = 7182919216525364676L;
    public static final String NAME = "DeltaCRLIndicator";
    public static final String NUMBER = "value";
    public static final String OID = "2.5.29.27";
    private BigInt baseCRLNumber = null;

    private void encodeThis() throws IOException {
        if (this.baseCRLNumber == null) {
            throw new IOException("Unintialized delta CRL indicator extension");
        }
        try (DerOutputStream os = new DerOutputStream();){
            os.putInteger(this.baseCRLNumber);
            this.extensionValue = os.toByteArray();
        }
    }

    public DeltaCRLIndicatorExtension(int baseCRLNum) throws IOException {
        this.baseCRLNumber = new BigInt(baseCRLNum);
        this.extensionId = PKIXExtensions.DeltaCRLIndicator_Id;
        this.critical = true;
        this.encodeThis();
    }

    public DeltaCRLIndicatorExtension(BigInteger baseCRLNum) throws IOException {
        this.baseCRLNumber = new BigInt(baseCRLNum);
        this.extensionId = PKIXExtensions.DeltaCRLIndicator_Id;
        this.critical = true;
        this.encodeThis();
    }

    public DeltaCRLIndicatorExtension(Boolean critical, BigInteger baseCRLNum) throws IOException {
        this.baseCRLNumber = new BigInt(baseCRLNum);
        this.extensionId = PKIXExtensions.DeltaCRLIndicator_Id;
        this.critical = critical;
        this.encodeThis();
    }

    public DeltaCRLIndicatorExtension(Boolean critical, Object value) throws IOException {
        this.extensionId = PKIXExtensions.DeltaCRLIndicator_Id;
        this.critical = critical;
        int len = Array.getLength(value);
        byte[] extValue = new byte[len];
        for (int i = 0; i < len; ++i) {
            extValue[i] = Array.getByte(value, i);
        }
        this.extensionValue = extValue;
        DerValue val = new DerValue(extValue);
        this.baseCRLNumber = val.getInteger();
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (name.equalsIgnoreCase(NUMBER)) {
            if (!(obj instanceof BigInteger)) {
                throw new IOException("Attribute must be of type BigInteger.");
            }
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:DeltaCRLIndicator.");
        }
        this.baseCRLNumber = new BigInt((BigInteger)obj);
    }

    @Override
    public Object get(String name) throws IOException {
        if (name.equalsIgnoreCase(NUMBER)) {
            if (this.baseCRLNumber == null) {
                return null;
            }
            return this.baseCRLNumber.toBigInteger();
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:DeltaCRLIndicator.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (!name.equalsIgnoreCase(NUMBER)) {
            throw new IOException("Attribute name not recognized by CertAttrSet:DeltaCRLIndicator.");
        }
        this.baseCRLNumber = null;
    }

    @Override
    public String toString() {
        String s = super.toString() + "Delta CRL Indicator: " + (this.baseCRLNumber == null ? "" : this.baseCRLNumber.toString()) + "\n";
        return s;
    }

    @Override
    public void decode(InputStream in) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.DeltaCRLIndicator_Id;
            this.critical = true;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        Vector<String> elements = new Vector<String>();
        elements.addElement(NUMBER);
        return elements.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }

    static {
        try {
            OIDMap.addAttribute(DeltaCRLIndicatorExtension.class.getName(), OID, NAME);
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
    }
}

