/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.PrettyPrintFormat;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;

public class X509Key
implements PublicKey {
    private static final long serialVersionUID = -5359250853002055002L;
    protected AlgorithmId algid;
    protected byte[] key;
    protected byte[] encodedKey;

    public X509Key() {
    }

    public X509Key(AlgorithmId algid, byte[] key) throws InvalidKeyException {
        this.algid = algid;
        this.key = key;
        this.encode();
    }

    public static X509Key parse(DerValue in) throws IOException {
        X509Key subjectKey;
        if (in.tag != 48) {
            throw new IOException("corrupt subject key");
        }
        AlgorithmId algorithm = AlgorithmId.parse(in.data.getDerValue());
        try {
            subjectKey = X509Key.buildX509Key(algorithm, in.data.getBitString());
        }
        catch (InvalidKeyException e) {
            throw new IOException("subject key, " + e.getMessage());
        }
        if (in.data.available() != 0) {
            throw new IOException("excess subject key");
        }
        return subjectKey;
    }

    protected void parseKeyBits() throws IOException, InvalidKeyException {
        this.encode();
    }

    static X509Key buildX509Key(AlgorithmId algid, byte[] key) throws IOException, InvalidKeyException {
        DerOutputStream x509EncodedKeyStream = new DerOutputStream();
        X509Key.encode(x509EncodedKeyStream, algid, key);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(x509EncodedKeyStream.toByteArray());
        try {
            KeyFactory keyFac = null;
            keyFac = Security.getProvider("Mozilla-JSS") == null ? KeyFactory.getInstance(algid.getName()) : KeyFactory.getInstance(algid.getName(), "Mozilla-JSS");
            PublicKey pubKey = keyFac.generatePublic(x509KeySpec);
            if (pubKey instanceof X509Key) {
                return (X509Key)pubKey;
            }
        }
        catch (NoSuchAlgorithmException keyFac) {
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeyException(e.toString());
        }
        catch (Exception e) {
            throw new InvalidKeyException(e.toString());
        }
        String classname = "";
        try {
            Provider sunProvider = Security.getProvider("SUN");
            if (sunProvider == null) {
                throw new InstantiationException();
            }
            classname = sunProvider.getProperty("PublicKey.X.509." + algid.getName());
            if (classname == null) {
                throw new InstantiationException();
            }
            Class<?> keyClass = Class.forName(classname);
            Object inst = keyClass.getConstructor(new Class[0]).newInstance(sunProvider.getProperty("PublicKey.X.509." + algid.getName()));
            if (inst instanceof X509Key) {
                X509Key result = (X509Key)inst;
                result.algid = algid;
                result.key = key;
                result.parseKeyBits();
                return result;
            }
        }
        catch (ClassNotFoundException sunProvider) {
        }
        catch (InstantiationException sunProvider) {
        }
        catch (IllegalAccessException e) {
            throw new IOException("IllegalAccessException : " + e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
        }
        catch (InvocationTargetException e) {
            throw new IOException("InvocationTargetException : " + e.getMessage(), e);
        }
        X509Key result = new X509Key();
        result.algid = algid;
        result.key = key;
        return result;
    }

    @Override
    public String getAlgorithm() {
        return this.algid.getName();
    }

    public AlgorithmId getAlgorithmId() {
        return this.algid;
    }

    public final void encode(DerOutputStream out) throws IOException {
        X509Key.encode(out, this.algid, this.key);
    }

    @Override
    public synchronized byte[] getEncoded() {
        byte[] result = null;
        try {
            result = this.encode();
        }
        catch (InvalidKeyException invalidKeyException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    public byte[] getKey() {
        return this.key;
    }

    public byte[] encode() throws InvalidKeyException {
        if (this.encodedKey == null) {
            try {
                DerOutputStream out = new DerOutputStream();
                this.encode(out);
                this.encodedKey = out.toByteArray();
            }
            catch (IOException e) {
                throw new InvalidKeyException("IOException : " + e.getMessage());
            }
        }
        return this.copyEncodedKey(this.encodedKey);
    }

    public String toString() {
        PrettyPrintFormat pp = new PrettyPrintFormat(" ", 20);
        String keybits = pp.toHexString(this.key);
        return "algorithm = " + this.algid.toString() + ", unparsed keybits = \n" + keybits;
    }

    public void decode(InputStream in) throws InvalidKeyException {
        try {
            DerValue val = new DerValue(in);
            if (val.tag != 48) {
                throw new InvalidKeyException("invalid key format");
            }
            this.algid = AlgorithmId.parse(val.data.getDerValue());
            this.key = val.data.getBitString();
            this.parseKeyBits();
            if (val.data.available() != 0) {
                throw new InvalidKeyException("excess key data");
            }
        }
        catch (IOException e) {
            throw new InvalidKeyException("IOException : " + e.getMessage());
        }
    }

    public void decode(byte[] encodedKey) throws InvalidKeyException {
        this.decode(new ByteArrayInputStream(encodedKey));
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.write(this.getEncoded());
    }

    private void readObject(ObjectInputStream stream) throws IOException {
        try {
            this.decode(stream);
        }
        catch (InvalidKeyException e) {
            throw new IOException("deserialized key is invalid: " + e.getMessage());
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Key) {
            Key key = (Key)object;
            byte[] b1 = this.encodedKey != null ? this.encodedKey : this.getEncoded();
            byte[] b2 = key.getEncoded();
            return MessageDigest.isEqual(b1, b2);
        }
        return false;
    }

    public int hashCode() {
        int retval = 0;
        byte[] b1 = this.getEncoded();
        for (int i = 1; i < b1.length; ++i) {
            retval += b1[i] * i;
        }
        return retval;
    }

    private byte[] copyEncodedKey(byte[] encodedKey) {
        int len = encodedKey.length;
        byte[] copy = new byte[len];
        System.arraycopy(encodedKey, 0, copy, 0, len);
        return copy;
    }

    static void encode(DerOutputStream out, AlgorithmId algid, byte[] key) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        algid.encode(tmp);
        tmp.putBitString(key);
        out.write((byte)48, tmp);
    }

    public static PublicKey parsePublicKey(DerValue in) throws IOException {
        PublicKey subjectKey;
        if (in.tag != 48) {
            throw new IOException("corrupt subject key");
        }
        AlgorithmId algorithm = AlgorithmId.parse(in.data.getDerValue());
        try {
            subjectKey = X509Key.buildPublicKey(algorithm, in.data.getBitString());
        }
        catch (InvalidKeyException e) {
            throw new IOException("subject key, " + e.getMessage());
        }
        if (in.data.available() != 0) {
            throw new IOException("excess subject key");
        }
        return subjectKey;
    }

    static PublicKey buildPublicKey(AlgorithmId algid, byte[] key) throws IOException, InvalidKeyException {
        DerOutputStream x509EncodedKeyStream = new DerOutputStream();
        X509Key.encode(x509EncodedKeyStream, algid, key);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(x509EncodedKeyStream.toByteArray());
        try {
            KeyFactory keyFac = null;
            keyFac = Security.getProvider("Mozilla-JSS") == null ? KeyFactory.getInstance(algid.getName()) : KeyFactory.getInstance(algid.getName(), "Mozilla-JSS");
            PublicKey pubKey = keyFac.generatePublic(x509KeySpec);
            return pubKey;
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidKeyException(e.toString());
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeyException(e.toString());
        }
        catch (Exception e) {
            throw new InvalidKeyException(e.toString());
        }
    }
}

