/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.security.KeyPair;
import java.util.Enumeration;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.KeyPairAlgorithm;
import org.mozilla.jss.crypto.KeyPairGenerator;
import org.mozilla.jss.crypto.KeyPairGeneratorSpi;
import org.mozilla.jss.crypto.Policy;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.Signature;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.pkcs11.PK11Token;
import org.mozilla.jss.tests.FilePasswordCallback;
import org.mozilla.jss.util.PasswordCallback;

public class SigTest {
    public static void usage() {
        System.out.println("Usage: java org.mozilla.jss.crypto.SigTest <dbdir> <pwfile> [tokenname]");
    }

    public static void main(String[] args) throws Exception {
        byte[] data = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        if (args.length < 2 || args.length > 3) {
            SigTest.usage();
            System.exit(1);
        }
        CryptoManager manager = CryptoManager.getInstance();
        manager.setPasswordCallback((PasswordCallback)new FilePasswordCallback(args[1]));
        Enumeration en = manager.getAllTokens();
        System.out.println("Available tokens:");
        while (en.hasMoreElements()) {
            PK11Token p = (PK11Token)en.nextElement();
            System.out.println(" token : " + p.getName());
        }
        CryptoToken token = args.length >= 3 ? manager.getTokenByName(args[2]) : manager.getInternalKeyStorageToken();
        KeyPairGenerator kpgen = token.getKeyPairGenerator(KeyPairAlgorithm.RSA);
        kpgen.initialize(Policy.RSA_MINIMUM_KEY_SIZE);
        KeyPairGeneratorSpi.Usage[] usages = new KeyPairGeneratorSpi.Usage[]{KeyPairGeneratorSpi.Usage.SIGN, KeyPairGeneratorSpi.Usage.VERIFY};
        KeyPairGeneratorSpi.Usage[] usages_mask = new KeyPairGeneratorSpi.Usage[]{KeyPairGeneratorSpi.Usage.SIGN, KeyPairGeneratorSpi.Usage.VERIFY};
        kpgen.setKeyPairUsages(usages, usages_mask);
        KeyPair keyPair = kpgen.genKeyPair();
        Signature signer = token.getSignatureContext(SignatureAlgorithm.RSASignatureWithSHA256Digest);
        System.out.println("Created a signing context");
        signer.initSign((PrivateKey)keyPair.getPrivate());
        System.out.println("initialized the signing operation");
        signer.update(data);
        System.out.println("updated signature with data");
        byte[] signature = signer.sign();
        System.out.println("Successfully signed!");
        signer.initVerify(keyPair.getPublic());
        System.out.println("initialized verification");
        signer.update(data);
        System.out.println("updated verification with data");
        if (!signer.verify(signature)) {
            throw new Exception("ERROR: Signature failed to verify.");
        }
        System.out.println("Signature Verified Successfully!");
        Signature signerPSS = token.getSignatureContext(SignatureAlgorithm.RSAPSSSignatureWithSHA256Digest);
        signerPSS.initSign((PrivateKey)keyPair.getPrivate());
        signerPSS.update(data);
        signature = signerPSS.sign();
        System.out.println("PSS Successfully signed!");
        signerPSS.initVerify(keyPair.getPublic());
        signerPSS.update(data);
        System.out.println("updated verification with data");
        if (!signerPSS.verify(signature)) {
            throw new Exception("ERROR: PSS Signature failed to verify.");
        }
        System.out.println("PSS Signature Verified Successfully!");
        System.out.println("SigTest passed.");
    }
}

