/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import org.mozilla.jss.nss.PR;
import org.mozilla.jss.nss.PRFDProxy;
import org.mozilla.jss.nss.SSL;
import org.mozilla.jss.nss.SSLChannelInfo;
import org.mozilla.jss.nss.SSLFDProxy;
import org.mozilla.jss.nss.SSLPreliminaryChannelInfo;
import org.mozilla.jss.nss.SecurityStatusResult;
import org.mozilla.jss.ssl.SSLCipher;

public class TestRawSSL {
    public static void TestSSLImportFD() throws Exception {
        PRFDProxy fd = PR.NewTCPSocket();
        assert (fd != null);
        SSLFDProxy ssl_fd = SSL.ImportFD(null, (PRFDProxy)fd);
        assert (ssl_fd != null);
        assert (PR.Close((SSLFDProxy)ssl_fd) == PR.SUCCESS);
    }

    public static void TestSSLOptions() throws Exception {
        PRFDProxy fd = PR.NewTCPSocket();
        assert (fd != null);
        SSLFDProxy ssl_fd = SSL.ImportFD(null, (PRFDProxy)fd);
        assert (ssl_fd != null);
        assert (SSL.OptionSet((SSLFDProxy)ssl_fd, (int)8, (int)0) == SSL.SECSuccess);
        assert (SSL.OptionGet((SSLFDProxy)ssl_fd, (int)8) == SSL.SECSuccess);
        assert (SSL.OptionSet((SSLFDProxy)ssl_fd, (int)8, (int)1) == SSL.SECSuccess);
        assert (SSL.OptionGet((SSLFDProxy)ssl_fd, (int)8) == 1);
        assert (SSL.OptionSet((SSLFDProxy)ssl_fd, (int)799999, (int)0) != SSL.SECSuccess);
        try {
            SSL.OptionGet((SSLFDProxy)ssl_fd, (int)79999999);
            assert (false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        assert (PR.Close((SSLFDProxy)ssl_fd) == PR.SUCCESS);
    }

    public static void TestSSLCipherPref() throws Exception {
        PRFDProxy fd = PR.NewTCPSocket();
        assert (fd != null);
        SSLFDProxy ssl_fd = SSL.ImportFD(null, (PRFDProxy)fd);
        assert (ssl_fd != null);
        int cipher2 = SSLCipher.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384.getID();
        assert (SSL.CipherPrefSet((SSLFDProxy)ssl_fd, (int)cipher2, (boolean)false) == SSL.SECSuccess);
        assert (!SSL.CipherPrefGet((SSLFDProxy)ssl_fd, (int)cipher2));
        assert (SSL.CipherPrefSet((SSLFDProxy)ssl_fd, (int)cipher2, (boolean)true) == SSL.SECSuccess);
        assert (SSL.CipherPrefGet((SSLFDProxy)ssl_fd, (int)cipher2));
        assert (SSL.CipherPrefSet((SSLFDProxy)ssl_fd, (int)0x999999, (boolean)false) == SSL.SECFailure);
        try {
            SSL.CipherPrefGet((SSLFDProxy)ssl_fd, (int)0x999999);
            assert (false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        assert (PR.Close((SSLFDProxy)ssl_fd) == PR.SUCCESS);
    }

    public static void TestSSLSetURL() throws Exception {
        PRFDProxy fd = PR.NewTCPSocket();
        assert (fd != null);
        SSLFDProxy ssl_fd = SSL.ImportFD(null, (PRFDProxy)fd);
        assert (ssl_fd != null);
        assert (SSL.SetURL((SSLFDProxy)ssl_fd, (String)"https://google.com") == SSL.SECSuccess);
        assert (PR.Close((SSLFDProxy)ssl_fd) == PR.SUCCESS);
    }

    public static void TestSSLSecurityStatus() throws Exception {
        PRFDProxy fd = PR.NewTCPSocket();
        assert (fd != null);
        SSLFDProxy ssl_fd = SSL.ImportFD(null, (PRFDProxy)fd);
        assert (ssl_fd != null);
        SecurityStatusResult r = SSL.SecurityStatus((SSLFDProxy)ssl_fd);
        assert (r != null);
        assert (r.on == 0);
        System.out.println(r.toString());
        assert (PR.Close((SSLFDProxy)ssl_fd) == PR.SUCCESS);
    }

    public static void TestSSLGetChannelInfo() throws Exception {
        PRFDProxy fd = PR.NewTCPSocket();
        assert (fd != null);
        SSLFDProxy ssl_fd = SSL.ImportFD(null, (PRFDProxy)fd);
        assert (ssl_fd != null);
        SSLChannelInfo r = SSL.GetChannelInfo((SSLFDProxy)ssl_fd);
        assert (r != null);
        assert (r.getProtocolVersion() == null);
        System.out.println(r.toString());
        assert (PR.Close((SSLFDProxy)ssl_fd) == PR.SUCCESS);
    }

    public static void TestSSLGetPreliminaryChannelInfo() throws Exception {
        PRFDProxy fd = PR.NewTCPSocket();
        assert (fd != null);
        SSLFDProxy ssl_fd = SSL.ImportFD(null, (PRFDProxy)fd);
        assert (ssl_fd != null);
        SSLPreliminaryChannelInfo r = SSL.GetPreliminaryChannelInfo((SSLFDProxy)ssl_fd);
        assert (r != null);
        assert (!r.haveProtocolVersion());
        assert (!r.haveCipherSuite());
        assert (!r.haveZeroRttCipherSuite());
        assert (!r.havePeerAuth());
        System.out.println(r.toString());
        assert (PR.Close((SSLFDProxy)ssl_fd) == PR.SUCCESS);
    }

    public static void TestSSLResetHandshake() throws Exception {
        PRFDProxy fd = PR.NewTCPSocket();
        assert (fd != null);
        SSLFDProxy ssl_fd = SSL.ImportFD(null, (PRFDProxy)fd);
        assert (SSL.ResetHandshake((SSLFDProxy)ssl_fd, (boolean)false) == SSL.SECSuccess);
        assert (PR.Close((SSLFDProxy)ssl_fd) == PR.SUCCESS);
    }

    public static void main(String[] args) throws Exception {
        System.loadLibrary("jss");
        if (args.length != 1) {
            System.out.println("Usage: TestRawSSL /path/to/nssdb");
            System.exit(1);
        }
        System.out.println("Calling TestSSLImportFD()...");
        TestRawSSL.TestSSLImportFD();
        System.out.println("Calling TestSSLOptions()...");
        TestRawSSL.TestSSLOptions();
        System.out.println("Calling TestSSLSetURL()...");
        TestRawSSL.TestSSLSetURL();
        System.out.println("Calling TestSSLCipherPref()...");
        TestRawSSL.TestSSLCipherPref();
        System.out.println("Calling TestSSLSecurityStatus()...");
        TestRawSSL.TestSSLSecurityStatus();
        System.out.println("Calling TestSSLGetChannelInfo()...");
        TestRawSSL.TestSSLGetChannelInfo();
        System.out.println("Calling TestSSLGetPreliminaryChannelInfo()...");
        TestRawSSL.TestSSLGetPreliminaryChannelInfo();
        System.out.println("Calling TestSSLResetHandshake()...");
        TestRawSSL.TestSSLResetHandshake();
    }
}

