/* SPDX-License-Identifier: GPL-2.0 */
#if !defined(_TRACE_TDX_H) || defined(TRACE_HEADER_MULTI_READ)
#define _TRACE_TDX_H

#include <linux/tracepoint.h>

#include <uapi/asm/vmx.h>

#undef TRACE_SYSTEM
#define TRACE_SYSTEM tdx

#ifdef CONFIG_INTEL_TDX_GUEST

TRACE_EVENT(tdx_virtualization_exception,
	    TP_PROTO(u64 rip, u32 exit_reason, u64 exit_qual,
		     u64 gpa, u32 instr_len, u32 instr_info,
		     u64 cx, u64 ax, u64 dx),
	    TP_ARGS(rip, exit_reason, exit_qual, gpa, instr_len,
		    instr_info, cx, ax, dx),
	    TP_STRUCT__entry(
			     __field(u64, rip)
			     __field(u64, exit_qual)
			     __field(u64, gpa)
			     __field(u32, exit_reason)
			     __field(u32, instr_len)
			     __field(u32, instr_info)
			     __field(u64, cx)
			     __field(u64, ax)
			     __field(u64, dx)
			     ),
	    TP_fast_assign(
			   __entry->rip = rip;
			   __entry->exit_qual = exit_qual;
			   __entry->gpa = gpa;
			   __entry->exit_reason = exit_reason;
			   __entry->instr_len = instr_len;
			   __entry->instr_info = instr_info;
			   __entry->cx = cx;
			   __entry->ax = ax;
			   __entry->dx = dx;
			   ),
	    TP_printk("reason %s rip 0x%016llx len %u info 0x%08x qual 0x%016llx gpa 0x%016llx cx %llx ax %llx dx %llx",
		      __print_symbolic(__entry->exit_reason, VMX_EXIT_REASONS),
		      __entry->rip, __entry->instr_len, __entry->instr_info,
		      __entry->exit_qual, __entry->gpa,
		      __entry->cx, __entry->ax, __entry->dx
		      )
	    );

#endif // CONFIG_INTEL_TDX_GUEST

#ifdef CONFIG_TDX_FUZZ

TRACE_EVENT(tdx_fuzz,

	TP_PROTO(u64 rip, unsigned bits, u64 oldval, u64 newval, int loc),

	TP_ARGS(rip, bits, oldval, newval, loc),

	TP_STRUCT__entry(
		__field(u64, rip)
		__field(unsigned, bits)
		__field(u64, oldval)
		__field(u64, newval)
		__field(int, loc)
	),

	TP_fast_assign(
		__entry->rip = rip;
		__entry->bits = bits;
		__entry->oldval = oldval;
		__entry->newval = newval;
		__entry->loc = loc;
	),

	TP_printk("rip %pF bits %u oldval %llx newval %llx loc %s",
		(void *)__entry->rip,
		__entry->bits,
		__entry->oldval,
		__entry->newval,
		__print_symbolic(__entry->loc,
				   { TDX_FUZZ_MSR_READ, "msr_read" },
				   { TDX_FUZZ_MMIO_READ, "mmio_read" },
				   { TDX_FUZZ_MSR_READ_ERR, "msr_read_err" },
				   { TDX_FUZZ_MSR_WRITE_ERR, "msr_write_err" },
				   { TDX_FUZZ_PORT_IN, "port_in" },
				   { TDX_FUZZ_PORT_IN_ERR, "port_in_err" },
				   { TDX_FUZZ_CPUID1, "cpuid1" },
				   { TDX_FUZZ_CPUID2, "cpuid2" },
				   { TDX_FUZZ_CPUID3, "cpuid3" },
				   { TDX_FUZZ_CPUID4, "cpuid4" })
	)
);

#endif

#undef TRACE_INCLUDE_PATH
#define TRACE_INCLUDE_PATH asm/trace/
#undef TRACE_INCLUDE_FILE
#define TRACE_INCLUDE_FILE tdx
#endif /* _TRACE_TDX_H */

/* This part must be outside protection */
#include <trace/define_trace.h>
