; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -global-isel -march=amdgcn -mcpu=tahiti -denormal-fp-math=ieee -verify-machineinstrs < %s | FileCheck -check-prefixes=GCN,GCN-IEEE,GFX6-IEEE %s
; RUN: llc -global-isel -march=amdgcn -mcpu=tahiti -denormal-fp-math=preserve-sign -verify-machineinstrs < %s | FileCheck -check-prefixes=GCN,GCN-FLUSH,GFX6-FLUSH %s

; RUN: llc -global-isel -march=amdgcn -mcpu=fiji -denormal-fp-math=ieee -verify-machineinstrs < %s | FileCheck -check-prefixes=GCN,GCN-IEEE,GFX89-IEEE %s
; RUN: llc -global-isel -march=amdgcn -mcpu=fiji -denormal-fp-math=preserve-sign -verify-machineinstrs < %s | FileCheck -check-prefixes=GCN,GCN-FLUSH,GFX89-FLUSH %s

; RUN: llc -global-isel -march=amdgcn -mcpu=gfx900 -denormal-fp-math=ieee -verify-machineinstrs < %s | FileCheck -check-prefixes=GCN,GCN-IEEE,GFX89-IEEE %s
; RUN: llc -global-isel -march=amdgcn -mcpu=gfx900 -denormal-fp-math=preserve-sign -verify-machineinstrs < %s | FileCheck -check-prefixes=GCN,GCN-FLUSH,GFX89-FLUSH %s

; RUN: llc -global-isel -march=amdgcn -mcpu=gfx1010 -denormal-fp-math=ieee -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX10,GFX10-IEEE %s
; RUN: llc -global-isel -march=amdgcn -mcpu=gfx1010 -denormal-fp-math=preserve-sign -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX10,GFX10-FLUSH %s

; RUN: llc -global-isel -march=amdgcn -mcpu=gfx1100 -denormal-fp-math=ieee -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX11,GFX11-IEEE %s
; RUN: llc -global-isel -march=amdgcn -mcpu=gfx1100 -denormal-fp-math=preserve-sign -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX11,GFX11-FLUSH %s

define float @v_fdiv_f32(float %a, float %b) {
; GFX6-IEEE-LABEL: v_fdiv_f32:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-IEEE-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-IEEE-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX6-IEEE-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-FLUSH-LABEL: v_fdiv_f32:
; GFX6-FLUSH:       ; %bb.0:
; GFX6-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX89-IEEE-LABEL: v_fdiv_f32:
; GFX89-IEEE:       ; %bb.0:
; GFX89-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX89-IEEE-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX89-IEEE-NEXT:    v_div_scale_f32 v3, vcc, v0, v1, v0
; GFX89-IEEE-NEXT:    v_rcp_f32_e32 v4, v2
; GFX89-IEEE-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX89-IEEE-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX89-IEEE-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX89-IEEE-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX89-IEEE-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX89-IEEE-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX89-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX89-IEEE-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX89-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX89-FLUSH-LABEL: v_fdiv_f32:
; GFX89-FLUSH:       ; %bb.0:
; GFX89-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX89-FLUSH-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX89-FLUSH-NEXT:    v_div_scale_f32 v3, vcc, v0, v1, v0
; GFX89-FLUSH-NEXT:    v_rcp_f32_e32 v4, v2
; GFX89-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX89-FLUSH-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX89-FLUSH-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX89-FLUSH-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX89-FLUSH-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX89-FLUSH-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX89-FLUSH-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX89-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX89-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX89-FLUSH-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX89-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-IEEE-LABEL: v_fdiv_f32:
; GFX10-IEEE:       ; %bb.0:
; GFX10-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-IEEE-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-IEEE-NEXT:    v_div_scale_f32 v2, s4, v1, v1, v0
; GFX10-IEEE-NEXT:    v_div_scale_f32 v5, vcc_lo, v0, v1, v0
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v3, v2
; GFX10-IEEE-NEXT:    v_fma_f32 v4, -v2, v3, 1.0
; GFX10-IEEE-NEXT:    v_fmac_f32_e32 v3, v4, v3
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v4, v5, v3
; GFX10-IEEE-NEXT:    v_fma_f32 v6, -v2, v4, v5
; GFX10-IEEE-NEXT:    v_fmac_f32_e32 v4, v6, v3
; GFX10-IEEE-NEXT:    v_fma_f32 v2, -v2, v4, v5
; GFX10-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v3, v4
; GFX10-IEEE-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX10-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-FLUSH-LABEL: v_fdiv_f32:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-FLUSH-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-FLUSH-NEXT:    v_div_scale_f32 v2, s4, v1, v1, v0
; GFX10-FLUSH-NEXT:    v_div_scale_f32 v4, vcc_lo, v0, v1, v0
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v3, v2
; GFX10-FLUSH-NEXT:    s_denorm_mode 3
; GFX10-FLUSH-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX10-FLUSH-NEXT:    v_fmac_f32_e32 v3, v5, v3
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX10-FLUSH-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX10-FLUSH-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX10-FLUSH-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX10-FLUSH-NEXT:    s_denorm_mode 0
; GFX10-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX10-FLUSH-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX10-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-IEEE-LABEL: v_fdiv_f32:
; GFX11-IEEE:       ; %bb.0:
; GFX11-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-IEEE-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-IEEE-NEXT:    v_div_scale_f32 v2, null, v1, v1, v0
; GFX11-IEEE-NEXT:    v_div_scale_f32 v5, vcc_lo, v0, v1, v0
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-IEEE-NEXT:    v_rcp_f32_e32 v3, v2
; GFX11-IEEE-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-IEEE-NEXT:    v_fma_f32 v4, -v2, v3, 1.0
; GFX11-IEEE-NEXT:    v_fmac_f32_e32 v3, v4, v3
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-IEEE-NEXT:    v_mul_f32_e32 v4, v5, v3
; GFX11-IEEE-NEXT:    v_fma_f32 v6, -v2, v4, v5
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-IEEE-NEXT:    v_fmac_f32_e32 v4, v6, v3
; GFX11-IEEE-NEXT:    v_fma_f32 v2, -v2, v4, v5
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v3, v4
; GFX11-IEEE-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX11-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FLUSH-LABEL: v_fdiv_f32:
; GFX11-FLUSH:       ; %bb.0:
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FLUSH-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-FLUSH-NEXT:    v_div_scale_f32 v2, null, v1, v1, v0
; GFX11-FLUSH-NEXT:    v_div_scale_f32 v4, vcc_lo, v0, v1, v0
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_rcp_f32_e32 v3, v2
; GFX11-FLUSH-NEXT:    s_denorm_mode 3
; GFX11-FLUSH-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-FLUSH-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX11-FLUSH-NEXT:    v_fmac_f32_e32 v3, v5, v3
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX11-FLUSH-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX11-FLUSH-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX11-FLUSH-NEXT:    s_denorm_mode 0
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX11-FLUSH-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX11-FLUSH-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv float %a, %b
  ret float %fdiv
}

define float @v_fdiv_f32_afn(float %a, float %b) {
; GCN-LABEL: v_fdiv_f32_afn:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_rcp_f32_e32 v1, v1
; GCN-NEXT:    v_mul_f32_e32 v0, v0, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_afn:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_rcp_f32_e32 v1, v1
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_afn:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_rcp_f32_e32 v1, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv afn float %a, %b
  ret float %fdiv
}

define float @v_fdiv_f32_ulp25(float %a, float %b) {
; GFX6-IEEE-LABEL: v_fdiv_f32_ulp25:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-IEEE-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-IEEE-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX6-IEEE-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-FLUSH-LABEL: v_fdiv_f32_ulp25:
; GCN-FLUSH:       ; %bb.0:
; GCN-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-FLUSH-NEXT:    v_mov_b32_e32 v2, 0x6f800000
; GCN-FLUSH-NEXT:    v_mov_b32_e32 v3, 0x2f800000
; GCN-FLUSH-NEXT:    v_cmp_gt_f32_e64 vcc, |v1|, v2
; GCN-FLUSH-NEXT:    v_cndmask_b32_e32 v2, 1.0, v3, vcc
; GCN-FLUSH-NEXT:    v_mul_f32_e32 v1, v1, v2
; GCN-FLUSH-NEXT:    v_rcp_f32_e32 v1, v1
; GCN-FLUSH-NEXT:    v_mul_f32_e32 v0, v0, v1
; GCN-FLUSH-NEXT:    v_mul_f32_e32 v0, v2, v0
; GCN-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX89-IEEE-LABEL: v_fdiv_f32_ulp25:
; GFX89-IEEE:       ; %bb.0:
; GFX89-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX89-IEEE-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX89-IEEE-NEXT:    v_div_scale_f32 v3, vcc, v0, v1, v0
; GFX89-IEEE-NEXT:    v_rcp_f32_e32 v4, v2
; GFX89-IEEE-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX89-IEEE-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX89-IEEE-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX89-IEEE-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX89-IEEE-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX89-IEEE-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX89-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX89-IEEE-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX89-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-IEEE-LABEL: v_fdiv_f32_ulp25:
; GFX10-IEEE:       ; %bb.0:
; GFX10-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-IEEE-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-IEEE-NEXT:    v_div_scale_f32 v2, s4, v1, v1, v0
; GFX10-IEEE-NEXT:    v_div_scale_f32 v5, vcc_lo, v0, v1, v0
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v3, v2
; GFX10-IEEE-NEXT:    v_fma_f32 v4, -v2, v3, 1.0
; GFX10-IEEE-NEXT:    v_fmac_f32_e32 v3, v4, v3
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v4, v5, v3
; GFX10-IEEE-NEXT:    v_fma_f32 v6, -v2, v4, v5
; GFX10-IEEE-NEXT:    v_fmac_f32_e32 v4, v6, v3
; GFX10-IEEE-NEXT:    v_fma_f32 v2, -v2, v4, v5
; GFX10-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v3, v4
; GFX10-IEEE-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX10-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-FLUSH-LABEL: v_fdiv_f32_ulp25:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-FLUSH-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-FLUSH-NEXT:    v_cmp_lt_f32_e64 s4, 0x6f800000, |v1|
; GFX10-FLUSH-NEXT:    v_cndmask_b32_e64 v2, 1.0, 0x2f800000, s4
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v1, v1, v2
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v1, v1
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v0, v2, v0
; GFX10-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-IEEE-LABEL: v_fdiv_f32_ulp25:
; GFX11-IEEE:       ; %bb.0:
; GFX11-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-IEEE-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-IEEE-NEXT:    v_div_scale_f32 v2, null, v1, v1, v0
; GFX11-IEEE-NEXT:    v_div_scale_f32 v5, vcc_lo, v0, v1, v0
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-IEEE-NEXT:    v_rcp_f32_e32 v3, v2
; GFX11-IEEE-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-IEEE-NEXT:    v_fma_f32 v4, -v2, v3, 1.0
; GFX11-IEEE-NEXT:    v_fmac_f32_e32 v3, v4, v3
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-IEEE-NEXT:    v_mul_f32_e32 v4, v5, v3
; GFX11-IEEE-NEXT:    v_fma_f32 v6, -v2, v4, v5
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-IEEE-NEXT:    v_fmac_f32_e32 v4, v6, v3
; GFX11-IEEE-NEXT:    v_fma_f32 v2, -v2, v4, v5
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v3, v4
; GFX11-IEEE-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX11-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FLUSH-LABEL: v_fdiv_f32_ulp25:
; GFX11-FLUSH:       ; %bb.0:
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FLUSH-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-FLUSH-NEXT:    v_cmp_lt_f32_e64 s0, 0x6f800000, |v1|
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_cndmask_b32_e64 v2, 1.0, 0x2f800000, s0
; GFX11-FLUSH-NEXT:    v_mul_f32_e32 v1, v1, v2
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_rcp_f32_e32 v1, v1
; GFX11-FLUSH-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-FLUSH-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX11-FLUSH-NEXT:    v_mul_f32_e32 v0, v2, v0
; GFX11-FLUSH-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv float %a, %b, !fpmath !0
  ret float %fdiv
}

define float @v_rcp_f32(float %x) {
; GFX6-IEEE-LABEL: v_rcp_f32:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-IEEE-NEXT:    v_div_scale_f32 v1, s[4:5], v0, v0, 1.0
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v2, v1
; GFX6-IEEE-NEXT:    v_div_scale_f32 v3, vcc, 1.0, v0, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v4, -v1, v2, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v2, v4, v2, v2
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v4, v3, v2
; GFX6-IEEE-NEXT:    v_fma_f32 v5, -v1, v4, v3
; GFX6-IEEE-NEXT:    v_fma_f32 v4, v5, v2, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v1, -v1, v4, v3
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v1, v1, v2, v4
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v1, v0, 1.0
; GFX6-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-FLUSH-LABEL: v_rcp_f32:
; GFX6-FLUSH:       ; %bb.0:
; GFX6-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v1, s[4:5], v0, v0, 1.0
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v2, v1
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v3, vcc, 1.0, v0, 1.0
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v4, -v1, v2, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, v4, v2, v2
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v4, v3, v2
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, -v1, v4, v3
; GFX6-FLUSH-NEXT:    v_fma_f32 v4, v5, v2, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v1, -v1, v4, v3
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v1, v1, v2, v4
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v0, v1, v0, 1.0
; GFX6-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX89-IEEE-LABEL: v_rcp_f32:
; GFX89-IEEE:       ; %bb.0:
; GFX89-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX89-IEEE-NEXT:    v_div_scale_f32 v1, s[4:5], v0, v0, 1.0
; GFX89-IEEE-NEXT:    v_div_scale_f32 v2, vcc, 1.0, v0, 1.0
; GFX89-IEEE-NEXT:    v_rcp_f32_e32 v3, v1
; GFX89-IEEE-NEXT:    v_fma_f32 v4, -v1, v3, 1.0
; GFX89-IEEE-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX89-IEEE-NEXT:    v_mul_f32_e32 v4, v2, v3
; GFX89-IEEE-NEXT:    v_fma_f32 v5, -v1, v4, v2
; GFX89-IEEE-NEXT:    v_fma_f32 v4, v5, v3, v4
; GFX89-IEEE-NEXT:    v_fma_f32 v1, -v1, v4, v2
; GFX89-IEEE-NEXT:    v_div_fmas_f32 v1, v1, v3, v4
; GFX89-IEEE-NEXT:    v_div_fixup_f32 v0, v1, v0, 1.0
; GFX89-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX89-FLUSH-LABEL: v_rcp_f32:
; GFX89-FLUSH:       ; %bb.0:
; GFX89-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX89-FLUSH-NEXT:    v_div_scale_f32 v1, s[4:5], v0, v0, 1.0
; GFX89-FLUSH-NEXT:    v_div_scale_f32 v2, vcc, 1.0, v0, 1.0
; GFX89-FLUSH-NEXT:    v_rcp_f32_e32 v3, v1
; GFX89-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX89-FLUSH-NEXT:    v_fma_f32 v4, -v1, v3, 1.0
; GFX89-FLUSH-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX89-FLUSH-NEXT:    v_mul_f32_e32 v4, v2, v3
; GFX89-FLUSH-NEXT:    v_fma_f32 v5, -v1, v4, v2
; GFX89-FLUSH-NEXT:    v_fma_f32 v4, v5, v3, v4
; GFX89-FLUSH-NEXT:    v_fma_f32 v1, -v1, v4, v2
; GFX89-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX89-FLUSH-NEXT:    v_div_fmas_f32 v1, v1, v3, v4
; GFX89-FLUSH-NEXT:    v_div_fixup_f32 v0, v1, v0, 1.0
; GFX89-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-IEEE-LABEL: v_rcp_f32:
; GFX10-IEEE:       ; %bb.0:
; GFX10-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-IEEE-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-IEEE-NEXT:    v_div_scale_f32 v1, s4, v0, v0, 1.0
; GFX10-IEEE-NEXT:    v_div_scale_f32 v4, vcc_lo, 1.0, v0, 1.0
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v2, v1
; GFX10-IEEE-NEXT:    v_fma_f32 v3, -v1, v2, 1.0
; GFX10-IEEE-NEXT:    v_fmac_f32_e32 v2, v3, v2
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v3, v4, v2
; GFX10-IEEE-NEXT:    v_fma_f32 v5, -v1, v3, v4
; GFX10-IEEE-NEXT:    v_fmac_f32_e32 v3, v5, v2
; GFX10-IEEE-NEXT:    v_fma_f32 v1, -v1, v3, v4
; GFX10-IEEE-NEXT:    v_div_fmas_f32 v1, v1, v2, v3
; GFX10-IEEE-NEXT:    v_div_fixup_f32 v0, v1, v0, 1.0
; GFX10-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-FLUSH-LABEL: v_rcp_f32:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-FLUSH-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-FLUSH-NEXT:    v_div_scale_f32 v1, s4, v0, v0, 1.0
; GFX10-FLUSH-NEXT:    v_div_scale_f32 v3, vcc_lo, 1.0, v0, 1.0
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v2, v1
; GFX10-FLUSH-NEXT:    s_denorm_mode 3
; GFX10-FLUSH-NEXT:    v_fma_f32 v4, -v1, v2, 1.0
; GFX10-FLUSH-NEXT:    v_fmac_f32_e32 v2, v4, v2
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v4, v3, v2
; GFX10-FLUSH-NEXT:    v_fma_f32 v5, -v1, v4, v3
; GFX10-FLUSH-NEXT:    v_fmac_f32_e32 v4, v5, v2
; GFX10-FLUSH-NEXT:    v_fma_f32 v1, -v1, v4, v3
; GFX10-FLUSH-NEXT:    s_denorm_mode 0
; GFX10-FLUSH-NEXT:    v_div_fmas_f32 v1, v1, v2, v4
; GFX10-FLUSH-NEXT:    v_div_fixup_f32 v0, v1, v0, 1.0
; GFX10-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-IEEE-LABEL: v_rcp_f32:
; GFX11-IEEE:       ; %bb.0:
; GFX11-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-IEEE-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-IEEE-NEXT:    v_div_scale_f32 v1, null, v0, v0, 1.0
; GFX11-IEEE-NEXT:    v_div_scale_f32 v4, vcc_lo, 1.0, v0, 1.0
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-IEEE-NEXT:    v_rcp_f32_e32 v2, v1
; GFX11-IEEE-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-IEEE-NEXT:    v_fma_f32 v3, -v1, v2, 1.0
; GFX11-IEEE-NEXT:    v_fmac_f32_e32 v2, v3, v2
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-IEEE-NEXT:    v_mul_f32_e32 v3, v4, v2
; GFX11-IEEE-NEXT:    v_fma_f32 v5, -v1, v3, v4
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-IEEE-NEXT:    v_fmac_f32_e32 v3, v5, v2
; GFX11-IEEE-NEXT:    v_fma_f32 v1, -v1, v3, v4
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-IEEE-NEXT:    v_div_fmas_f32 v1, v1, v2, v3
; GFX11-IEEE-NEXT:    v_div_fixup_f32 v0, v1, v0, 1.0
; GFX11-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FLUSH-LABEL: v_rcp_f32:
; GFX11-FLUSH:       ; %bb.0:
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FLUSH-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-FLUSH-NEXT:    v_div_scale_f32 v1, null, v0, v0, 1.0
; GFX11-FLUSH-NEXT:    v_div_scale_f32 v3, vcc_lo, 1.0, v0, 1.0
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_rcp_f32_e32 v2, v1
; GFX11-FLUSH-NEXT:    s_denorm_mode 3
; GFX11-FLUSH-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-FLUSH-NEXT:    v_fma_f32 v4, -v1, v2, 1.0
; GFX11-FLUSH-NEXT:    v_fmac_f32_e32 v2, v4, v2
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_mul_f32_e32 v4, v3, v2
; GFX11-FLUSH-NEXT:    v_fma_f32 v5, -v1, v4, v3
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_fmac_f32_e32 v4, v5, v2
; GFX11-FLUSH-NEXT:    v_fma_f32 v1, -v1, v4, v3
; GFX11-FLUSH-NEXT:    s_denorm_mode 0
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_div_fmas_f32 v1, v1, v2, v4
; GFX11-FLUSH-NEXT:    v_div_fixup_f32 v0, v1, v0, 1.0
; GFX11-FLUSH-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv float 1.0, %x
  ret float %fdiv
}

define float @v_rcp_f32_arcp(float %x) {
; GFX6-IEEE-LABEL: v_rcp_f32_arcp:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-IEEE-NEXT:    v_div_scale_f32 v1, s[4:5], v0, v0, 1.0
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v2, v1
; GFX6-IEEE-NEXT:    v_div_scale_f32 v3, vcc, 1.0, v0, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v4, -v1, v2, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v2, v4, v2, v2
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v4, v3, v2
; GFX6-IEEE-NEXT:    v_fma_f32 v5, -v1, v4, v3
; GFX6-IEEE-NEXT:    v_fma_f32 v4, v5, v2, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v1, -v1, v4, v3
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v1, v1, v2, v4
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v1, v0, 1.0
; GFX6-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-FLUSH-LABEL: v_rcp_f32_arcp:
; GFX6-FLUSH:       ; %bb.0:
; GFX6-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v1, s[4:5], v0, v0, 1.0
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v2, v1
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v3, vcc, 1.0, v0, 1.0
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v4, -v1, v2, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, v4, v2, v2
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v4, v3, v2
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, -v1, v4, v3
; GFX6-FLUSH-NEXT:    v_fma_f32 v4, v5, v2, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v1, -v1, v4, v3
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v1, v1, v2, v4
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v0, v1, v0, 1.0
; GFX6-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX89-IEEE-LABEL: v_rcp_f32_arcp:
; GFX89-IEEE:       ; %bb.0:
; GFX89-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX89-IEEE-NEXT:    v_div_scale_f32 v1, s[4:5], v0, v0, 1.0
; GFX89-IEEE-NEXT:    v_div_scale_f32 v2, vcc, 1.0, v0, 1.0
; GFX89-IEEE-NEXT:    v_rcp_f32_e32 v3, v1
; GFX89-IEEE-NEXT:    v_fma_f32 v4, -v1, v3, 1.0
; GFX89-IEEE-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX89-IEEE-NEXT:    v_mul_f32_e32 v4, v2, v3
; GFX89-IEEE-NEXT:    v_fma_f32 v5, -v1, v4, v2
; GFX89-IEEE-NEXT:    v_fma_f32 v4, v5, v3, v4
; GFX89-IEEE-NEXT:    v_fma_f32 v1, -v1, v4, v2
; GFX89-IEEE-NEXT:    v_div_fmas_f32 v1, v1, v3, v4
; GFX89-IEEE-NEXT:    v_div_fixup_f32 v0, v1, v0, 1.0
; GFX89-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX89-FLUSH-LABEL: v_rcp_f32_arcp:
; GFX89-FLUSH:       ; %bb.0:
; GFX89-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX89-FLUSH-NEXT:    v_div_scale_f32 v1, s[4:5], v0, v0, 1.0
; GFX89-FLUSH-NEXT:    v_div_scale_f32 v2, vcc, 1.0, v0, 1.0
; GFX89-FLUSH-NEXT:    v_rcp_f32_e32 v3, v1
; GFX89-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX89-FLUSH-NEXT:    v_fma_f32 v4, -v1, v3, 1.0
; GFX89-FLUSH-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX89-FLUSH-NEXT:    v_mul_f32_e32 v4, v2, v3
; GFX89-FLUSH-NEXT:    v_fma_f32 v5, -v1, v4, v2
; GFX89-FLUSH-NEXT:    v_fma_f32 v4, v5, v3, v4
; GFX89-FLUSH-NEXT:    v_fma_f32 v1, -v1, v4, v2
; GFX89-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX89-FLUSH-NEXT:    v_div_fmas_f32 v1, v1, v3, v4
; GFX89-FLUSH-NEXT:    v_div_fixup_f32 v0, v1, v0, 1.0
; GFX89-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-IEEE-LABEL: v_rcp_f32_arcp:
; GFX10-IEEE:       ; %bb.0:
; GFX10-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-IEEE-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-IEEE-NEXT:    v_div_scale_f32 v1, s4, v0, v0, 1.0
; GFX10-IEEE-NEXT:    v_div_scale_f32 v4, vcc_lo, 1.0, v0, 1.0
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v2, v1
; GFX10-IEEE-NEXT:    v_fma_f32 v3, -v1, v2, 1.0
; GFX10-IEEE-NEXT:    v_fmac_f32_e32 v2, v3, v2
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v3, v4, v2
; GFX10-IEEE-NEXT:    v_fma_f32 v5, -v1, v3, v4
; GFX10-IEEE-NEXT:    v_fmac_f32_e32 v3, v5, v2
; GFX10-IEEE-NEXT:    v_fma_f32 v1, -v1, v3, v4
; GFX10-IEEE-NEXT:    v_div_fmas_f32 v1, v1, v2, v3
; GFX10-IEEE-NEXT:    v_div_fixup_f32 v0, v1, v0, 1.0
; GFX10-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-FLUSH-LABEL: v_rcp_f32_arcp:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-FLUSH-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-FLUSH-NEXT:    v_div_scale_f32 v1, s4, v0, v0, 1.0
; GFX10-FLUSH-NEXT:    v_div_scale_f32 v3, vcc_lo, 1.0, v0, 1.0
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v2, v1
; GFX10-FLUSH-NEXT:    s_denorm_mode 3
; GFX10-FLUSH-NEXT:    v_fma_f32 v4, -v1, v2, 1.0
; GFX10-FLUSH-NEXT:    v_fmac_f32_e32 v2, v4, v2
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v4, v3, v2
; GFX10-FLUSH-NEXT:    v_fma_f32 v5, -v1, v4, v3
; GFX10-FLUSH-NEXT:    v_fmac_f32_e32 v4, v5, v2
; GFX10-FLUSH-NEXT:    v_fma_f32 v1, -v1, v4, v3
; GFX10-FLUSH-NEXT:    s_denorm_mode 0
; GFX10-FLUSH-NEXT:    v_div_fmas_f32 v1, v1, v2, v4
; GFX10-FLUSH-NEXT:    v_div_fixup_f32 v0, v1, v0, 1.0
; GFX10-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-IEEE-LABEL: v_rcp_f32_arcp:
; GFX11-IEEE:       ; %bb.0:
; GFX11-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-IEEE-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-IEEE-NEXT:    v_div_scale_f32 v1, null, v0, v0, 1.0
; GFX11-IEEE-NEXT:    v_div_scale_f32 v4, vcc_lo, 1.0, v0, 1.0
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-IEEE-NEXT:    v_rcp_f32_e32 v2, v1
; GFX11-IEEE-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-IEEE-NEXT:    v_fma_f32 v3, -v1, v2, 1.0
; GFX11-IEEE-NEXT:    v_fmac_f32_e32 v2, v3, v2
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-IEEE-NEXT:    v_mul_f32_e32 v3, v4, v2
; GFX11-IEEE-NEXT:    v_fma_f32 v5, -v1, v3, v4
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-IEEE-NEXT:    v_fmac_f32_e32 v3, v5, v2
; GFX11-IEEE-NEXT:    v_fma_f32 v1, -v1, v3, v4
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-IEEE-NEXT:    v_div_fmas_f32 v1, v1, v2, v3
; GFX11-IEEE-NEXT:    v_div_fixup_f32 v0, v1, v0, 1.0
; GFX11-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FLUSH-LABEL: v_rcp_f32_arcp:
; GFX11-FLUSH:       ; %bb.0:
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FLUSH-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-FLUSH-NEXT:    v_div_scale_f32 v1, null, v0, v0, 1.0
; GFX11-FLUSH-NEXT:    v_div_scale_f32 v3, vcc_lo, 1.0, v0, 1.0
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_rcp_f32_e32 v2, v1
; GFX11-FLUSH-NEXT:    s_denorm_mode 3
; GFX11-FLUSH-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-FLUSH-NEXT:    v_fma_f32 v4, -v1, v2, 1.0
; GFX11-FLUSH-NEXT:    v_fmac_f32_e32 v2, v4, v2
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_mul_f32_e32 v4, v3, v2
; GFX11-FLUSH-NEXT:    v_fma_f32 v5, -v1, v4, v3
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_fmac_f32_e32 v4, v5, v2
; GFX11-FLUSH-NEXT:    v_fma_f32 v1, -v1, v4, v3
; GFX11-FLUSH-NEXT:    s_denorm_mode 0
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_div_fmas_f32 v1, v1, v2, v4
; GFX11-FLUSH-NEXT:    v_div_fixup_f32 v0, v1, v0, 1.0
; GFX11-FLUSH-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv arcp float 1.0, %x
  ret float %fdiv
}

define float @v_rcp_f32_arcp_afn(float %x) {
; GCN-LABEL: v_rcp_f32_arcp_afn:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_rcp_f32_e32 v0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_rcp_f32_arcp_afn:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_rcp_f32_e32 v0, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_rcp_f32_arcp_afn:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_rcp_f32_e32 v0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv arcp afn float 1.0, %x
  ret float %fdiv
}

define float @v_rcp_f32_ulp25(float %x) {
; GCN-IEEE-LABEL: v_rcp_f32_ulp25:
; GCN-IEEE:       ; %bb.0:
; GCN-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-IEEE-NEXT:    v_mov_b32_e32 v1, 0x6f800000
; GCN-IEEE-NEXT:    v_mov_b32_e32 v2, 0x2f800000
; GCN-IEEE-NEXT:    v_cmp_gt_f32_e64 vcc, |v0|, v1
; GCN-IEEE-NEXT:    v_cndmask_b32_e32 v1, 1.0, v2, vcc
; GCN-IEEE-NEXT:    v_mul_f32_e32 v0, v0, v1
; GCN-IEEE-NEXT:    v_rcp_f32_e32 v0, v0
; GCN-IEEE-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GCN-IEEE-NEXT:    v_mul_f32_e32 v0, v1, v0
; GCN-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-FLUSH-LABEL: v_rcp_f32_ulp25:
; GCN-FLUSH:       ; %bb.0:
; GCN-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-FLUSH-NEXT:    v_rcp_f32_e32 v0, v0
; GCN-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-IEEE-LABEL: v_rcp_f32_ulp25:
; GFX10-IEEE:       ; %bb.0:
; GFX10-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-IEEE-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-IEEE-NEXT:    v_cmp_lt_f32_e64 s4, 0x6f800000, |v0|
; GFX10-IEEE-NEXT:    v_cndmask_b32_e64 v1, 1.0, 0x2f800000, s4
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v0, v0
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v0, v1, v0
; GFX10-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-FLUSH-LABEL: v_rcp_f32_ulp25:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-FLUSH-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v0, v0
; GFX10-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-IEEE-LABEL: v_rcp_f32_ulp25:
; GFX11-IEEE:       ; %bb.0:
; GFX11-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-IEEE-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-IEEE-NEXT:    v_cmp_lt_f32_e64 s0, 0x6f800000, |v0|
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-IEEE-NEXT:    v_cndmask_b32_e64 v1, 1.0, 0x2f800000, s0
; GFX11-IEEE-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-IEEE-NEXT:    v_rcp_f32_e32 v0, v0
; GFX11-IEEE-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-IEEE-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX11-IEEE-NEXT:    v_mul_f32_e32 v0, v1, v0
; GFX11-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FLUSH-LABEL: v_rcp_f32_ulp25:
; GFX11-FLUSH:       ; %bb.0:
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FLUSH-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-FLUSH-NEXT:    v_rcp_f32_e32 v0, v0
; GFX11-FLUSH-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv float 1.0, %x, !fpmath !0
  ret float %fdiv
}

define float @v_fdiv_f32_afn_ulp25(float %a, float %b) {
; GCN-LABEL: v_fdiv_f32_afn_ulp25:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_rcp_f32_e32 v1, v1
; GCN-NEXT:    v_mul_f32_e32 v0, v0, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f32_afn_ulp25:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_rcp_f32_e32 v1, v1
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f32_afn_ulp25:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_rcp_f32_e32 v1, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv afn float %a, %b, !fpmath !0
  ret float %fdiv
}

define float @v_fdiv_f32_arcp_ulp25(float %a, float %b) {
; GFX6-IEEE-LABEL: v_fdiv_f32_arcp_ulp25:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-IEEE-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-IEEE-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX6-IEEE-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-FLUSH-LABEL: v_fdiv_f32_arcp_ulp25:
; GCN-FLUSH:       ; %bb.0:
; GCN-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-FLUSH-NEXT:    v_mov_b32_e32 v2, 0x6f800000
; GCN-FLUSH-NEXT:    v_mov_b32_e32 v3, 0x2f800000
; GCN-FLUSH-NEXT:    v_cmp_gt_f32_e64 vcc, |v1|, v2
; GCN-FLUSH-NEXT:    v_cndmask_b32_e32 v2, 1.0, v3, vcc
; GCN-FLUSH-NEXT:    v_mul_f32_e32 v1, v1, v2
; GCN-FLUSH-NEXT:    v_rcp_f32_e32 v1, v1
; GCN-FLUSH-NEXT:    v_mul_f32_e32 v0, v0, v1
; GCN-FLUSH-NEXT:    v_mul_f32_e32 v0, v2, v0
; GCN-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX89-IEEE-LABEL: v_fdiv_f32_arcp_ulp25:
; GFX89-IEEE:       ; %bb.0:
; GFX89-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX89-IEEE-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX89-IEEE-NEXT:    v_div_scale_f32 v3, vcc, v0, v1, v0
; GFX89-IEEE-NEXT:    v_rcp_f32_e32 v4, v2
; GFX89-IEEE-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX89-IEEE-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX89-IEEE-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX89-IEEE-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX89-IEEE-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX89-IEEE-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX89-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX89-IEEE-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX89-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-IEEE-LABEL: v_fdiv_f32_arcp_ulp25:
; GFX10-IEEE:       ; %bb.0:
; GFX10-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-IEEE-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-IEEE-NEXT:    v_div_scale_f32 v2, s4, v1, v1, v0
; GFX10-IEEE-NEXT:    v_div_scale_f32 v5, vcc_lo, v0, v1, v0
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v3, v2
; GFX10-IEEE-NEXT:    v_fma_f32 v4, -v2, v3, 1.0
; GFX10-IEEE-NEXT:    v_fmac_f32_e32 v3, v4, v3
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v4, v5, v3
; GFX10-IEEE-NEXT:    v_fma_f32 v6, -v2, v4, v5
; GFX10-IEEE-NEXT:    v_fmac_f32_e32 v4, v6, v3
; GFX10-IEEE-NEXT:    v_fma_f32 v2, -v2, v4, v5
; GFX10-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v3, v4
; GFX10-IEEE-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX10-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-FLUSH-LABEL: v_fdiv_f32_arcp_ulp25:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-FLUSH-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-FLUSH-NEXT:    v_cmp_lt_f32_e64 s4, 0x6f800000, |v1|
; GFX10-FLUSH-NEXT:    v_cndmask_b32_e64 v2, 1.0, 0x2f800000, s4
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v1, v1, v2
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v1, v1
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v0, v2, v0
; GFX10-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-IEEE-LABEL: v_fdiv_f32_arcp_ulp25:
; GFX11-IEEE:       ; %bb.0:
; GFX11-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-IEEE-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-IEEE-NEXT:    v_div_scale_f32 v2, null, v1, v1, v0
; GFX11-IEEE-NEXT:    v_div_scale_f32 v5, vcc_lo, v0, v1, v0
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-IEEE-NEXT:    v_rcp_f32_e32 v3, v2
; GFX11-IEEE-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-IEEE-NEXT:    v_fma_f32 v4, -v2, v3, 1.0
; GFX11-IEEE-NEXT:    v_fmac_f32_e32 v3, v4, v3
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-IEEE-NEXT:    v_mul_f32_e32 v4, v5, v3
; GFX11-IEEE-NEXT:    v_fma_f32 v6, -v2, v4, v5
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-IEEE-NEXT:    v_fmac_f32_e32 v4, v6, v3
; GFX11-IEEE-NEXT:    v_fma_f32 v2, -v2, v4, v5
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v3, v4
; GFX11-IEEE-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX11-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FLUSH-LABEL: v_fdiv_f32_arcp_ulp25:
; GFX11-FLUSH:       ; %bb.0:
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FLUSH-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-FLUSH-NEXT:    v_cmp_lt_f32_e64 s0, 0x6f800000, |v1|
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_cndmask_b32_e64 v2, 1.0, 0x2f800000, s0
; GFX11-FLUSH-NEXT:    v_mul_f32_e32 v1, v1, v2
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_rcp_f32_e32 v1, v1
; GFX11-FLUSH-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-FLUSH-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX11-FLUSH-NEXT:    v_mul_f32_e32 v0, v2, v0
; GFX11-FLUSH-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv arcp float %a, %b, !fpmath !0
  ret float %fdiv
}

define <2 x float> @v_fdiv_v2f32(<2 x float> %a, <2 x float> %b) {
; GFX6-IEEE-LABEL: v_fdiv_v2f32:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-IEEE-NEXT:    v_div_scale_f32 v4, s[4:5], v2, v2, v0
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v5, v4
; GFX6-IEEE-NEXT:    v_div_scale_f32 v6, vcc, v0, v2, v0
; GFX6-IEEE-NEXT:    v_fma_f32 v7, -v4, v5, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v5, v7, v5, v5
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v7, v6, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v8, -v4, v7, v6
; GFX6-IEEE-NEXT:    v_fma_f32 v7, v8, v5, v7
; GFX6-IEEE-NEXT:    v_fma_f32 v4, -v4, v7, v6
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v4, v4, v5, v7
; GFX6-IEEE-NEXT:    v_div_scale_f32 v5, s[4:5], v3, v3, v1
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v6, v5
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v4, v2, v0
; GFX6-IEEE-NEXT:    v_div_scale_f32 v2, vcc, v1, v3, v1
; GFX6-IEEE-NEXT:    v_fma_f32 v4, -v5, v6, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v4, v4, v6, v6
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v6, v2, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v7, -v5, v6, v2
; GFX6-IEEE-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX6-IEEE-NEXT:    v_fma_f32 v2, -v5, v6, v2
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v4, v6
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v1, v2, v3, v1
; GFX6-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-FLUSH-LABEL: v_fdiv_v2f32:
; GFX6-FLUSH:       ; %bb.0:
; GFX6-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v4, s[4:5], v2, v2, v0
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v5, v4
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v6, vcc, v0, v2, v0
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v7, -v4, v5, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, v7, v5, v5
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v7, v6, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v8, -v4, v7, v6
; GFX6-FLUSH-NEXT:    v_fma_f32 v7, v8, v5, v7
; GFX6-FLUSH-NEXT:    v_fma_f32 v4, -v4, v7, v6
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v4, v4, v5, v7
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v5, s[4:5], v3, v3, v1
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v6, v5
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v0, v4, v2, v0
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v2, vcc, v1, v3, v1
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v4, -v5, v6, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v4, v4, v6, v6
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v6, v2, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v7, -v5, v6, v2
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, -v5, v6, v2
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v4, v6
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v1, v2, v3, v1
; GFX6-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX89-IEEE-LABEL: v_fdiv_v2f32:
; GFX89-IEEE:       ; %bb.0:
; GFX89-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX89-IEEE-NEXT:    v_div_scale_f32 v4, s[4:5], v2, v2, v0
; GFX89-IEEE-NEXT:    v_div_scale_f32 v5, s[4:5], v3, v3, v1
; GFX89-IEEE-NEXT:    v_div_scale_f32 v6, vcc, v0, v2, v0
; GFX89-IEEE-NEXT:    v_div_scale_f32 v7, s[4:5], v1, v3, v1
; GFX89-IEEE-NEXT:    v_rcp_f32_e32 v8, v4
; GFX89-IEEE-NEXT:    v_rcp_f32_e32 v9, v5
; GFX89-IEEE-NEXT:    v_fma_f32 v10, -v4, v8, 1.0
; GFX89-IEEE-NEXT:    v_fma_f32 v8, v10, v8, v8
; GFX89-IEEE-NEXT:    v_fma_f32 v11, -v5, v9, 1.0
; GFX89-IEEE-NEXT:    v_fma_f32 v9, v11, v9, v9
; GFX89-IEEE-NEXT:    v_mul_f32_e32 v10, v6, v8
; GFX89-IEEE-NEXT:    v_mul_f32_e32 v11, v7, v9
; GFX89-IEEE-NEXT:    v_fma_f32 v12, -v4, v10, v6
; GFX89-IEEE-NEXT:    v_fma_f32 v13, -v5, v11, v7
; GFX89-IEEE-NEXT:    v_fma_f32 v10, v12, v8, v10
; GFX89-IEEE-NEXT:    v_fma_f32 v11, v13, v9, v11
; GFX89-IEEE-NEXT:    v_fma_f32 v4, -v4, v10, v6
; GFX89-IEEE-NEXT:    v_fma_f32 v5, -v5, v11, v7
; GFX89-IEEE-NEXT:    v_div_fmas_f32 v4, v4, v8, v10
; GFX89-IEEE-NEXT:    s_mov_b64 vcc, s[4:5]
; GFX89-IEEE-NEXT:    v_div_fmas_f32 v5, v5, v9, v11
; GFX89-IEEE-NEXT:    v_div_fixup_f32 v0, v4, v2, v0
; GFX89-IEEE-NEXT:    v_div_fixup_f32 v1, v5, v3, v1
; GFX89-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX89-FLUSH-LABEL: v_fdiv_v2f32:
; GFX89-FLUSH:       ; %bb.0:
; GFX89-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX89-FLUSH-NEXT:    v_div_scale_f32 v4, s[4:5], v2, v2, v0
; GFX89-FLUSH-NEXT:    v_div_scale_f32 v5, vcc, v0, v2, v0
; GFX89-FLUSH-NEXT:    v_rcp_f32_e32 v6, v4
; GFX89-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX89-FLUSH-NEXT:    v_fma_f32 v7, -v4, v6, 1.0
; GFX89-FLUSH-NEXT:    v_fma_f32 v6, v7, v6, v6
; GFX89-FLUSH-NEXT:    v_mul_f32_e32 v7, v5, v6
; GFX89-FLUSH-NEXT:    v_fma_f32 v8, -v4, v7, v5
; GFX89-FLUSH-NEXT:    v_fma_f32 v7, v8, v6, v7
; GFX89-FLUSH-NEXT:    v_fma_f32 v4, -v4, v7, v5
; GFX89-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX89-FLUSH-NEXT:    v_div_scale_f32 v5, s[4:5], v3, v3, v1
; GFX89-FLUSH-NEXT:    v_div_fmas_f32 v4, v4, v6, v7
; GFX89-FLUSH-NEXT:    v_div_scale_f32 v6, vcc, v1, v3, v1
; GFX89-FLUSH-NEXT:    v_rcp_f32_e32 v7, v5
; GFX89-FLUSH-NEXT:    v_div_fixup_f32 v0, v4, v2, v0
; GFX89-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX89-FLUSH-NEXT:    v_fma_f32 v2, -v5, v7, 1.0
; GFX89-FLUSH-NEXT:    v_fma_f32 v2, v2, v7, v7
; GFX89-FLUSH-NEXT:    v_mul_f32_e32 v4, v6, v2
; GFX89-FLUSH-NEXT:    v_fma_f32 v7, -v5, v4, v6
; GFX89-FLUSH-NEXT:    v_fma_f32 v4, v7, v2, v4
; GFX89-FLUSH-NEXT:    v_fma_f32 v5, -v5, v4, v6
; GFX89-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX89-FLUSH-NEXT:    v_div_fmas_f32 v2, v5, v2, v4
; GFX89-FLUSH-NEXT:    v_div_fixup_f32 v1, v2, v3, v1
; GFX89-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-IEEE-LABEL: v_fdiv_v2f32:
; GFX10-IEEE:       ; %bb.0:
; GFX10-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-IEEE-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-IEEE-NEXT:    v_div_scale_f32 v4, s4, v2, v2, v0
; GFX10-IEEE-NEXT:    v_div_scale_f32 v5, s4, v3, v3, v1
; GFX10-IEEE-NEXT:    v_div_scale_f32 v10, vcc_lo, v0, v2, v0
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v6, v4
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v7, v5
; GFX10-IEEE-NEXT:    v_fma_f32 v8, -v4, v6, 1.0
; GFX10-IEEE-NEXT:    v_fma_f32 v9, -v5, v7, 1.0
; GFX10-IEEE-NEXT:    v_fmac_f32_e32 v6, v8, v6
; GFX10-IEEE-NEXT:    v_div_scale_f32 v8, s4, v1, v3, v1
; GFX10-IEEE-NEXT:    v_fmac_f32_e32 v7, v9, v7
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v9, v10, v6
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v11, v8, v7
; GFX10-IEEE-NEXT:    v_fma_f32 v12, -v4, v9, v10
; GFX10-IEEE-NEXT:    v_fma_f32 v13, -v5, v11, v8
; GFX10-IEEE-NEXT:    v_fmac_f32_e32 v9, v12, v6
; GFX10-IEEE-NEXT:    v_fmac_f32_e32 v11, v13, v7
; GFX10-IEEE-NEXT:    v_fma_f32 v4, -v4, v9, v10
; GFX10-IEEE-NEXT:    v_fma_f32 v5, -v5, v11, v8
; GFX10-IEEE-NEXT:    v_div_fmas_f32 v4, v4, v6, v9
; GFX10-IEEE-NEXT:    s_mov_b32 vcc_lo, s4
; GFX10-IEEE-NEXT:    v_div_fmas_f32 v5, v5, v7, v11
; GFX10-IEEE-NEXT:    v_div_fixup_f32 v0, v4, v2, v0
; GFX10-IEEE-NEXT:    v_div_fixup_f32 v1, v5, v3, v1
; GFX10-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-FLUSH-LABEL: v_fdiv_v2f32:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-FLUSH-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-FLUSH-NEXT:    v_div_scale_f32 v4, s4, v2, v2, v0
; GFX10-FLUSH-NEXT:    v_div_scale_f32 v6, vcc_lo, v0, v2, v0
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v5, v4
; GFX10-FLUSH-NEXT:    s_denorm_mode 3
; GFX10-FLUSH-NEXT:    v_fma_f32 v7, -v4, v5, 1.0
; GFX10-FLUSH-NEXT:    v_fmac_f32_e32 v5, v7, v5
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v7, v6, v5
; GFX10-FLUSH-NEXT:    v_fma_f32 v8, -v4, v7, v6
; GFX10-FLUSH-NEXT:    v_fmac_f32_e32 v7, v8, v5
; GFX10-FLUSH-NEXT:    v_fma_f32 v4, -v4, v7, v6
; GFX10-FLUSH-NEXT:    s_denorm_mode 0
; GFX10-FLUSH-NEXT:    v_div_scale_f32 v6, s4, v3, v3, v1
; GFX10-FLUSH-NEXT:    v_div_fmas_f32 v4, v4, v5, v7
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v5, v6
; GFX10-FLUSH-NEXT:    v_div_fixup_f32 v0, v4, v2, v0
; GFX10-FLUSH-NEXT:    v_div_scale_f32 v2, vcc_lo, v1, v3, v1
; GFX10-FLUSH-NEXT:    s_denorm_mode 3
; GFX10-FLUSH-NEXT:    v_fma_f32 v4, -v6, v5, 1.0
; GFX10-FLUSH-NEXT:    v_fmac_f32_e32 v5, v4, v5
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v4, v2, v5
; GFX10-FLUSH-NEXT:    v_fma_f32 v7, -v6, v4, v2
; GFX10-FLUSH-NEXT:    v_fmac_f32_e32 v4, v7, v5
; GFX10-FLUSH-NEXT:    v_fma_f32 v2, -v6, v4, v2
; GFX10-FLUSH-NEXT:    s_denorm_mode 0
; GFX10-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v5, v4
; GFX10-FLUSH-NEXT:    v_div_fixup_f32 v1, v2, v3, v1
; GFX10-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-IEEE-LABEL: v_fdiv_v2f32:
; GFX11-IEEE:       ; %bb.0:
; GFX11-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-IEEE-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-IEEE-NEXT:    v_div_scale_f32 v4, null, v2, v2, v0
; GFX11-IEEE-NEXT:    v_div_scale_f32 v5, null, v3, v3, v1
; GFX11-IEEE-NEXT:    v_div_scale_f32 v10, vcc_lo, v0, v2, v0
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-IEEE-NEXT:    v_rcp_f32_e32 v6, v4
; GFX11-IEEE-NEXT:    v_rcp_f32_e32 v7, v5
; GFX11-IEEE-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-IEEE-NEXT:    v_fma_f32 v8, -v4, v6, 1.0
; GFX11-IEEE-NEXT:    v_fma_f32 v9, -v5, v7, 1.0
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-IEEE-NEXT:    v_dual_fmac_f32 v6, v8, v6 :: v_dual_fmac_f32 v7, v9, v7
; GFX11-IEEE-NEXT:    v_div_scale_f32 v8, s0, v1, v3, v1
; GFX11-IEEE-NEXT:    v_mul_f32_e32 v9, v10, v6
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-IEEE-NEXT:    v_mul_f32_e32 v11, v8, v7
; GFX11-IEEE-NEXT:    v_fma_f32 v12, -v4, v9, v10
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-IEEE-NEXT:    v_fma_f32 v13, -v5, v11, v8
; GFX11-IEEE-NEXT:    v_fmac_f32_e32 v9, v12, v6
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-IEEE-NEXT:    v_fmac_f32_e32 v11, v13, v7
; GFX11-IEEE-NEXT:    v_fma_f32 v4, -v4, v9, v10
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-IEEE-NEXT:    v_fma_f32 v5, -v5, v11, v8
; GFX11-IEEE-NEXT:    v_div_fmas_f32 v4, v4, v6, v9
; GFX11-IEEE-NEXT:    s_mov_b32 vcc_lo, s0
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-IEEE-NEXT:    v_div_fmas_f32 v5, v5, v7, v11
; GFX11-IEEE-NEXT:    v_div_fixup_f32 v0, v4, v2, v0
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-IEEE-NEXT:    v_div_fixup_f32 v1, v5, v3, v1
; GFX11-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FLUSH-LABEL: v_fdiv_v2f32:
; GFX11-FLUSH:       ; %bb.0:
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FLUSH-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-FLUSH-NEXT:    v_div_scale_f32 v4, null, v2, v2, v0
; GFX11-FLUSH-NEXT:    v_div_scale_f32 v6, vcc_lo, v0, v2, v0
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_rcp_f32_e32 v5, v4
; GFX11-FLUSH-NEXT:    s_denorm_mode 3
; GFX11-FLUSH-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-FLUSH-NEXT:    v_fma_f32 v7, -v4, v5, 1.0
; GFX11-FLUSH-NEXT:    v_fmac_f32_e32 v5, v7, v5
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_mul_f32_e32 v7, v6, v5
; GFX11-FLUSH-NEXT:    v_fma_f32 v8, -v4, v7, v6
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_fmac_f32_e32 v7, v8, v5
; GFX11-FLUSH-NEXT:    v_fma_f32 v4, -v4, v7, v6
; GFX11-FLUSH-NEXT:    s_denorm_mode 0
; GFX11-FLUSH-NEXT:    v_div_scale_f32 v6, null, v3, v3, v1
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FLUSH-NEXT:    v_div_fmas_f32 v4, v4, v5, v7
; GFX11-FLUSH-NEXT:    v_rcp_f32_e32 v5, v6
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_4) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_div_fixup_f32 v0, v4, v2, v0
; GFX11-FLUSH-NEXT:    v_div_scale_f32 v2, vcc_lo, v1, v3, v1
; GFX11-FLUSH-NEXT:    s_denorm_mode 3
; GFX11-FLUSH-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-FLUSH-NEXT:    v_fma_f32 v4, -v6, v5, 1.0
; GFX11-FLUSH-NEXT:    v_fmac_f32_e32 v5, v4, v5
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_mul_f32_e32 v4, v2, v5
; GFX11-FLUSH-NEXT:    v_fma_f32 v7, -v6, v4, v2
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_fmac_f32_e32 v4, v7, v5
; GFX11-FLUSH-NEXT:    v_fma_f32 v2, -v6, v4, v2
; GFX11-FLUSH-NEXT:    s_denorm_mode 0
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v5, v4
; GFX11-FLUSH-NEXT:    v_div_fixup_f32 v1, v2, v3, v1
; GFX11-FLUSH-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv <2 x float> %a, %b
  ret <2 x float> %fdiv
}

define <2 x float> @v_fdiv_v2f32_afn(<2 x float> %a, <2 x float> %b) {
; GCN-LABEL: v_fdiv_v2f32_afn:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_rcp_f32_e32 v2, v2
; GCN-NEXT:    v_rcp_f32_e32 v3, v3
; GCN-NEXT:    v_mul_f32_e32 v0, v0, v2
; GCN-NEXT:    v_mul_f32_e32 v1, v1, v3
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_v2f32_afn:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_rcp_f32_e32 v2, v2
; GFX10-NEXT:    v_rcp_f32_e32 v3, v3
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX10-NEXT:    v_mul_f32_e32 v1, v1, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_v2f32_afn:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_rcp_f32_e32 v2, v2
; GFX11-NEXT:    v_rcp_f32_e32 v3, v3
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_dual_mul_f32 v0, v0, v2 :: v_dual_mul_f32 v1, v1, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv afn <2 x float> %a, %b
  ret <2 x float> %fdiv
}

define <2 x float> @v_fdiv_v2f32_ulp25(<2 x float> %a, <2 x float> %b) {
; GFX6-IEEE-LABEL: v_fdiv_v2f32_ulp25:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-IEEE-NEXT:    v_div_scale_f32 v4, s[4:5], v2, v2, v0
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v5, v4
; GFX6-IEEE-NEXT:    v_div_scale_f32 v6, vcc, v0, v2, v0
; GFX6-IEEE-NEXT:    v_fma_f32 v7, -v4, v5, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v5, v7, v5, v5
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v7, v6, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v8, -v4, v7, v6
; GFX6-IEEE-NEXT:    v_fma_f32 v7, v8, v5, v7
; GFX6-IEEE-NEXT:    v_fma_f32 v4, -v4, v7, v6
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v4, v4, v5, v7
; GFX6-IEEE-NEXT:    v_div_scale_f32 v5, s[4:5], v3, v3, v1
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v6, v5
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v4, v2, v0
; GFX6-IEEE-NEXT:    v_div_scale_f32 v2, vcc, v1, v3, v1
; GFX6-IEEE-NEXT:    v_fma_f32 v4, -v5, v6, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v4, v4, v6, v6
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v6, v2, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v7, -v5, v6, v2
; GFX6-IEEE-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX6-IEEE-NEXT:    v_fma_f32 v2, -v5, v6, v2
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v4, v6
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v1, v2, v3, v1
; GFX6-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-FLUSH-LABEL: v_fdiv_v2f32_ulp25:
; GCN-FLUSH:       ; %bb.0:
; GCN-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-FLUSH-NEXT:    s_mov_b32 s4, 0x6f800000
; GCN-FLUSH-NEXT:    v_mov_b32_e32 v4, 0x2f800000
; GCN-FLUSH-NEXT:    v_cmp_gt_f32_e64 vcc, |v2|, s4
; GCN-FLUSH-NEXT:    v_cndmask_b32_e32 v5, 1.0, v4, vcc
; GCN-FLUSH-NEXT:    v_cmp_gt_f32_e64 vcc, |v3|, s4
; GCN-FLUSH-NEXT:    v_cndmask_b32_e32 v4, 1.0, v4, vcc
; GCN-FLUSH-NEXT:    v_mul_f32_e32 v2, v2, v5
; GCN-FLUSH-NEXT:    v_mul_f32_e32 v3, v3, v4
; GCN-FLUSH-NEXT:    v_rcp_f32_e32 v2, v2
; GCN-FLUSH-NEXT:    v_rcp_f32_e32 v3, v3
; GCN-FLUSH-NEXT:    v_mul_f32_e32 v0, v0, v2
; GCN-FLUSH-NEXT:    v_mul_f32_e32 v1, v1, v3
; GCN-FLUSH-NEXT:    v_mul_f32_e32 v0, v5, v0
; GCN-FLUSH-NEXT:    v_mul_f32_e32 v1, v4, v1
; GCN-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX89-IEEE-LABEL: v_fdiv_v2f32_ulp25:
; GFX89-IEEE:       ; %bb.0:
; GFX89-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX89-IEEE-NEXT:    v_div_scale_f32 v4, s[4:5], v2, v2, v0
; GFX89-IEEE-NEXT:    v_div_scale_f32 v5, s[4:5], v3, v3, v1
; GFX89-IEEE-NEXT:    v_div_scale_f32 v6, vcc, v0, v2, v0
; GFX89-IEEE-NEXT:    v_div_scale_f32 v7, s[4:5], v1, v3, v1
; GFX89-IEEE-NEXT:    v_rcp_f32_e32 v8, v4
; GFX89-IEEE-NEXT:    v_rcp_f32_e32 v9, v5
; GFX89-IEEE-NEXT:    v_fma_f32 v10, -v4, v8, 1.0
; GFX89-IEEE-NEXT:    v_fma_f32 v8, v10, v8, v8
; GFX89-IEEE-NEXT:    v_fma_f32 v11, -v5, v9, 1.0
; GFX89-IEEE-NEXT:    v_fma_f32 v9, v11, v9, v9
; GFX89-IEEE-NEXT:    v_mul_f32_e32 v10, v6, v8
; GFX89-IEEE-NEXT:    v_mul_f32_e32 v11, v7, v9
; GFX89-IEEE-NEXT:    v_fma_f32 v12, -v4, v10, v6
; GFX89-IEEE-NEXT:    v_fma_f32 v13, -v5, v11, v7
; GFX89-IEEE-NEXT:    v_fma_f32 v10, v12, v8, v10
; GFX89-IEEE-NEXT:    v_fma_f32 v11, v13, v9, v11
; GFX89-IEEE-NEXT:    v_fma_f32 v4, -v4, v10, v6
; GFX89-IEEE-NEXT:    v_fma_f32 v5, -v5, v11, v7
; GFX89-IEEE-NEXT:    v_div_fmas_f32 v4, v4, v8, v10
; GFX89-IEEE-NEXT:    s_mov_b64 vcc, s[4:5]
; GFX89-IEEE-NEXT:    v_div_fmas_f32 v5, v5, v9, v11
; GFX89-IEEE-NEXT:    v_div_fixup_f32 v0, v4, v2, v0
; GFX89-IEEE-NEXT:    v_div_fixup_f32 v1, v5, v3, v1
; GFX89-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-IEEE-LABEL: v_fdiv_v2f32_ulp25:
; GFX10-IEEE:       ; %bb.0:
; GFX10-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-IEEE-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-IEEE-NEXT:    v_div_scale_f32 v4, s4, v2, v2, v0
; GFX10-IEEE-NEXT:    v_div_scale_f32 v5, s4, v3, v3, v1
; GFX10-IEEE-NEXT:    v_div_scale_f32 v10, vcc_lo, v0, v2, v0
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v6, v4
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v7, v5
; GFX10-IEEE-NEXT:    v_fma_f32 v8, -v4, v6, 1.0
; GFX10-IEEE-NEXT:    v_fma_f32 v9, -v5, v7, 1.0
; GFX10-IEEE-NEXT:    v_fmac_f32_e32 v6, v8, v6
; GFX10-IEEE-NEXT:    v_div_scale_f32 v8, s4, v1, v3, v1
; GFX10-IEEE-NEXT:    v_fmac_f32_e32 v7, v9, v7
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v9, v10, v6
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v11, v8, v7
; GFX10-IEEE-NEXT:    v_fma_f32 v12, -v4, v9, v10
; GFX10-IEEE-NEXT:    v_fma_f32 v13, -v5, v11, v8
; GFX10-IEEE-NEXT:    v_fmac_f32_e32 v9, v12, v6
; GFX10-IEEE-NEXT:    v_fmac_f32_e32 v11, v13, v7
; GFX10-IEEE-NEXT:    v_fma_f32 v4, -v4, v9, v10
; GFX10-IEEE-NEXT:    v_fma_f32 v5, -v5, v11, v8
; GFX10-IEEE-NEXT:    v_div_fmas_f32 v4, v4, v6, v9
; GFX10-IEEE-NEXT:    s_mov_b32 vcc_lo, s4
; GFX10-IEEE-NEXT:    v_div_fmas_f32 v5, v5, v7, v11
; GFX10-IEEE-NEXT:    v_div_fixup_f32 v0, v4, v2, v0
; GFX10-IEEE-NEXT:    v_div_fixup_f32 v1, v5, v3, v1
; GFX10-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-FLUSH-LABEL: v_fdiv_v2f32_ulp25:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-FLUSH-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-FLUSH-NEXT:    v_cmp_lt_f32_e64 s4, 0x6f800000, |v2|
; GFX10-FLUSH-NEXT:    v_cndmask_b32_e64 v4, 1.0, 0x2f800000, s4
; GFX10-FLUSH-NEXT:    v_cmp_lt_f32_e64 s4, 0x6f800000, |v3|
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v2, v2, v4
; GFX10-FLUSH-NEXT:    v_cndmask_b32_e64 v5, 1.0, 0x2f800000, s4
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v2, v2
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v3, v3, v5
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v3, v3
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v0, v4, v0
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v1, v1, v3
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v1, v5, v1
; GFX10-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-IEEE-LABEL: v_fdiv_v2f32_ulp25:
; GFX11-IEEE:       ; %bb.0:
; GFX11-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-IEEE-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-IEEE-NEXT:    v_div_scale_f32 v4, null, v2, v2, v0
; GFX11-IEEE-NEXT:    v_div_scale_f32 v5, null, v3, v3, v1
; GFX11-IEEE-NEXT:    v_div_scale_f32 v10, vcc_lo, v0, v2, v0
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-IEEE-NEXT:    v_rcp_f32_e32 v6, v4
; GFX11-IEEE-NEXT:    v_rcp_f32_e32 v7, v5
; GFX11-IEEE-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-IEEE-NEXT:    v_fma_f32 v8, -v4, v6, 1.0
; GFX11-IEEE-NEXT:    v_fma_f32 v9, -v5, v7, 1.0
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-IEEE-NEXT:    v_dual_fmac_f32 v6, v8, v6 :: v_dual_fmac_f32 v7, v9, v7
; GFX11-IEEE-NEXT:    v_div_scale_f32 v8, s0, v1, v3, v1
; GFX11-IEEE-NEXT:    v_mul_f32_e32 v9, v10, v6
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-IEEE-NEXT:    v_mul_f32_e32 v11, v8, v7
; GFX11-IEEE-NEXT:    v_fma_f32 v12, -v4, v9, v10
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-IEEE-NEXT:    v_fma_f32 v13, -v5, v11, v8
; GFX11-IEEE-NEXT:    v_fmac_f32_e32 v9, v12, v6
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-IEEE-NEXT:    v_fmac_f32_e32 v11, v13, v7
; GFX11-IEEE-NEXT:    v_fma_f32 v4, -v4, v9, v10
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-IEEE-NEXT:    v_fma_f32 v5, -v5, v11, v8
; GFX11-IEEE-NEXT:    v_div_fmas_f32 v4, v4, v6, v9
; GFX11-IEEE-NEXT:    s_mov_b32 vcc_lo, s0
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-IEEE-NEXT:    v_div_fmas_f32 v5, v5, v7, v11
; GFX11-IEEE-NEXT:    v_div_fixup_f32 v0, v4, v2, v0
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-IEEE-NEXT:    v_div_fixup_f32 v1, v5, v3, v1
; GFX11-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FLUSH-LABEL: v_fdiv_v2f32_ulp25:
; GFX11-FLUSH:       ; %bb.0:
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FLUSH-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-FLUSH-NEXT:    v_cmp_lt_f32_e64 s0, 0x6f800000, |v2|
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_cndmask_b32_e64 v4, 1.0, 0x2f800000, s0
; GFX11-FLUSH-NEXT:    v_cmp_lt_f32_e64 s0, 0x6f800000, |v3|
; GFX11-FLUSH-NEXT:    v_cndmask_b32_e64 v5, 1.0, 0x2f800000, s0
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_dual_mul_f32 v2, v2, v4 :: v_dual_mul_f32 v3, v3, v5
; GFX11-FLUSH-NEXT:    v_rcp_f32_e32 v2, v2
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_rcp_f32_e32 v3, v3
; GFX11-FLUSH-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-FLUSH-NEXT:    v_dual_mul_f32 v0, v0, v2 :: v_dual_mul_f32 v1, v1, v3
; GFX11-FLUSH-NEXT:    v_dual_mul_f32 v0, v4, v0 :: v_dual_mul_f32 v1, v5, v1
; GFX11-FLUSH-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv <2 x float> %a, %b, !fpmath !0
  ret <2 x float> %fdiv
}

define <2 x float> @v_rcp_v2f32(<2 x float> %x) {
; GFX6-IEEE-LABEL: v_rcp_v2f32:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-IEEE-NEXT:    v_div_scale_f32 v2, s[4:5], v0, v0, 1.0
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-IEEE-NEXT:    v_div_scale_f32 v4, vcc, 1.0, v0, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-IEEE-NEXT:    v_div_scale_f32 v3, s[4:5], v1, v1, 1.0
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v4, v3
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v2, v0, 1.0
; GFX6-IEEE-NEXT:    v_div_scale_f32 v2, vcc, 1.0, v1, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v5, -v3, v4, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v5, v2, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v3, v5, v2
; GFX6-IEEE-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v2, -v3, v5, v2
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v1, v2, v1, 1.0
; GFX6-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-FLUSH-LABEL: v_rcp_v2f32:
; GFX6-FLUSH:       ; %bb.0:
; GFX6-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v2, s[4:5], v0, v0, 1.0
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v4, vcc, 1.0, v0, 1.0
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v3, s[4:5], v1, v1, 1.0
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v4, v3
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v0, v2, v0, 1.0
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v2, vcc, 1.0, v1, 1.0
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, -v3, v4, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v5, v2, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v3, v5, v2
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, -v3, v5, v2
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v1, v2, v1, 1.0
; GFX6-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX89-IEEE-LABEL: v_rcp_v2f32:
; GFX89-IEEE:       ; %bb.0:
; GFX89-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX89-IEEE-NEXT:    v_div_scale_f32 v2, s[4:5], v0, v0, 1.0
; GFX89-IEEE-NEXT:    v_div_scale_f32 v3, s[4:5], v1, v1, 1.0
; GFX89-IEEE-NEXT:    v_div_scale_f32 v4, vcc, 1.0, v0, 1.0
; GFX89-IEEE-NEXT:    v_div_scale_f32 v5, s[4:5], 1.0, v1, 1.0
; GFX89-IEEE-NEXT:    v_rcp_f32_e32 v6, v2
; GFX89-IEEE-NEXT:    v_rcp_f32_e32 v7, v3
; GFX89-IEEE-NEXT:    v_fma_f32 v8, -v2, v6, 1.0
; GFX89-IEEE-NEXT:    v_fma_f32 v6, v8, v6, v6
; GFX89-IEEE-NEXT:    v_fma_f32 v9, -v3, v7, 1.0
; GFX89-IEEE-NEXT:    v_fma_f32 v7, v9, v7, v7
; GFX89-IEEE-NEXT:    v_mul_f32_e32 v8, v4, v6
; GFX89-IEEE-NEXT:    v_mul_f32_e32 v9, v5, v7
; GFX89-IEEE-NEXT:    v_fma_f32 v10, -v2, v8, v4
; GFX89-IEEE-NEXT:    v_fma_f32 v11, -v3, v9, v5
; GFX89-IEEE-NEXT:    v_fma_f32 v8, v10, v6, v8
; GFX89-IEEE-NEXT:    v_fma_f32 v9, v11, v7, v9
; GFX89-IEEE-NEXT:    v_fma_f32 v2, -v2, v8, v4
; GFX89-IEEE-NEXT:    v_fma_f32 v3, -v3, v9, v5
; GFX89-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v6, v8
; GFX89-IEEE-NEXT:    s_mov_b64 vcc, s[4:5]
; GFX89-IEEE-NEXT:    v_div_fmas_f32 v3, v3, v7, v9
; GFX89-IEEE-NEXT:    v_div_fixup_f32 v0, v2, v0, 1.0
; GFX89-IEEE-NEXT:    v_div_fixup_f32 v1, v3, v1, 1.0
; GFX89-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX89-FLUSH-LABEL: v_rcp_v2f32:
; GFX89-FLUSH:       ; %bb.0:
; GFX89-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX89-FLUSH-NEXT:    v_div_scale_f32 v2, s[4:5], v0, v0, 1.0
; GFX89-FLUSH-NEXT:    v_div_scale_f32 v3, vcc, 1.0, v0, 1.0
; GFX89-FLUSH-NEXT:    v_rcp_f32_e32 v4, v2
; GFX89-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX89-FLUSH-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX89-FLUSH-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX89-FLUSH-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX89-FLUSH-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX89-FLUSH-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX89-FLUSH-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX89-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX89-FLUSH-NEXT:    v_div_scale_f32 v3, s[4:5], v1, v1, 1.0
; GFX89-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX89-FLUSH-NEXT:    v_div_scale_f32 v4, vcc, 1.0, v1, 1.0
; GFX89-FLUSH-NEXT:    v_rcp_f32_e32 v5, v3
; GFX89-FLUSH-NEXT:    v_div_fixup_f32 v0, v2, v0, 1.0
; GFX89-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX89-FLUSH-NEXT:    v_fma_f32 v2, -v3, v5, 1.0
; GFX89-FLUSH-NEXT:    v_fma_f32 v2, v2, v5, v5
; GFX89-FLUSH-NEXT:    v_mul_f32_e32 v5, v4, v2
; GFX89-FLUSH-NEXT:    v_fma_f32 v6, -v3, v5, v4
; GFX89-FLUSH-NEXT:    v_fma_f32 v5, v6, v2, v5
; GFX89-FLUSH-NEXT:    v_fma_f32 v3, -v3, v5, v4
; GFX89-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX89-FLUSH-NEXT:    v_div_fmas_f32 v2, v3, v2, v5
; GFX89-FLUSH-NEXT:    v_div_fixup_f32 v1, v2, v1, 1.0
; GFX89-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-IEEE-LABEL: v_rcp_v2f32:
; GFX10-IEEE:       ; %bb.0:
; GFX10-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-IEEE-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-IEEE-NEXT:    v_div_scale_f32 v2, s4, v0, v0, 1.0
; GFX10-IEEE-NEXT:    v_div_scale_f32 v3, s4, v1, v1, 1.0
; GFX10-IEEE-NEXT:    v_div_scale_f32 v8, vcc_lo, 1.0, v0, 1.0
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v4, v2
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v5, v3
; GFX10-IEEE-NEXT:    v_fma_f32 v6, -v2, v4, 1.0
; GFX10-IEEE-NEXT:    v_fma_f32 v7, -v3, v5, 1.0
; GFX10-IEEE-NEXT:    v_fmac_f32_e32 v4, v6, v4
; GFX10-IEEE-NEXT:    v_div_scale_f32 v6, s4, 1.0, v1, 1.0
; GFX10-IEEE-NEXT:    v_fmac_f32_e32 v5, v7, v5
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v7, v8, v4
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v9, v6, v5
; GFX10-IEEE-NEXT:    v_fma_f32 v10, -v2, v7, v8
; GFX10-IEEE-NEXT:    v_fma_f32 v11, -v3, v9, v6
; GFX10-IEEE-NEXT:    v_fmac_f32_e32 v7, v10, v4
; GFX10-IEEE-NEXT:    v_fmac_f32_e32 v9, v11, v5
; GFX10-IEEE-NEXT:    v_fma_f32 v2, -v2, v7, v8
; GFX10-IEEE-NEXT:    v_fma_f32 v3, -v3, v9, v6
; GFX10-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v4, v7
; GFX10-IEEE-NEXT:    s_mov_b32 vcc_lo, s4
; GFX10-IEEE-NEXT:    v_div_fmas_f32 v3, v3, v5, v9
; GFX10-IEEE-NEXT:    v_div_fixup_f32 v0, v2, v0, 1.0
; GFX10-IEEE-NEXT:    v_div_fixup_f32 v1, v3, v1, 1.0
; GFX10-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-FLUSH-LABEL: v_rcp_v2f32:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-FLUSH-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-FLUSH-NEXT:    v_div_scale_f32 v2, s4, v0, v0, 1.0
; GFX10-FLUSH-NEXT:    v_div_scale_f32 v4, vcc_lo, 1.0, v0, 1.0
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v3, v2
; GFX10-FLUSH-NEXT:    s_denorm_mode 3
; GFX10-FLUSH-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX10-FLUSH-NEXT:    v_fmac_f32_e32 v3, v5, v3
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX10-FLUSH-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX10-FLUSH-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX10-FLUSH-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX10-FLUSH-NEXT:    s_denorm_mode 0
; GFX10-FLUSH-NEXT:    v_div_scale_f32 v4, s4, v1, v1, 1.0
; GFX10-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v3, v4
; GFX10-FLUSH-NEXT:    v_div_fixup_f32 v0, v2, v0, 1.0
; GFX10-FLUSH-NEXT:    v_div_scale_f32 v2, vcc_lo, 1.0, v1, 1.0
; GFX10-FLUSH-NEXT:    s_denorm_mode 3
; GFX10-FLUSH-NEXT:    v_fma_f32 v5, -v4, v3, 1.0
; GFX10-FLUSH-NEXT:    v_fmac_f32_e32 v3, v5, v3
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v5, v2, v3
; GFX10-FLUSH-NEXT:    v_fma_f32 v6, -v4, v5, v2
; GFX10-FLUSH-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX10-FLUSH-NEXT:    v_fma_f32 v2, -v4, v5, v2
; GFX10-FLUSH-NEXT:    s_denorm_mode 0
; GFX10-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX10-FLUSH-NEXT:    v_div_fixup_f32 v1, v2, v1, 1.0
; GFX10-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-IEEE-LABEL: v_rcp_v2f32:
; GFX11-IEEE:       ; %bb.0:
; GFX11-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-IEEE-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-IEEE-NEXT:    v_div_scale_f32 v2, null, v0, v0, 1.0
; GFX11-IEEE-NEXT:    v_div_scale_f32 v3, null, v1, v1, 1.0
; GFX11-IEEE-NEXT:    v_div_scale_f32 v8, vcc_lo, 1.0, v0, 1.0
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-IEEE-NEXT:    v_rcp_f32_e32 v4, v2
; GFX11-IEEE-NEXT:    v_rcp_f32_e32 v5, v3
; GFX11-IEEE-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-IEEE-NEXT:    v_fma_f32 v6, -v2, v4, 1.0
; GFX11-IEEE-NEXT:    v_fma_f32 v7, -v3, v5, 1.0
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-IEEE-NEXT:    v_dual_fmac_f32 v4, v6, v4 :: v_dual_fmac_f32 v5, v7, v5
; GFX11-IEEE-NEXT:    v_div_scale_f32 v6, s0, 1.0, v1, 1.0
; GFX11-IEEE-NEXT:    v_mul_f32_e32 v7, v8, v4
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-IEEE-NEXT:    v_mul_f32_e32 v9, v6, v5
; GFX11-IEEE-NEXT:    v_fma_f32 v10, -v2, v7, v8
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-IEEE-NEXT:    v_fma_f32 v11, -v3, v9, v6
; GFX11-IEEE-NEXT:    v_fmac_f32_e32 v7, v10, v4
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-IEEE-NEXT:    v_fmac_f32_e32 v9, v11, v5
; GFX11-IEEE-NEXT:    v_fma_f32 v2, -v2, v7, v8
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-IEEE-NEXT:    v_fma_f32 v3, -v3, v9, v6
; GFX11-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v4, v7
; GFX11-IEEE-NEXT:    s_mov_b32 vcc_lo, s0
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-IEEE-NEXT:    v_div_fmas_f32 v3, v3, v5, v9
; GFX11-IEEE-NEXT:    v_div_fixup_f32 v0, v2, v0, 1.0
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-IEEE-NEXT:    v_div_fixup_f32 v1, v3, v1, 1.0
; GFX11-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FLUSH-LABEL: v_rcp_v2f32:
; GFX11-FLUSH:       ; %bb.0:
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FLUSH-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-FLUSH-NEXT:    v_div_scale_f32 v2, null, v0, v0, 1.0
; GFX11-FLUSH-NEXT:    v_div_scale_f32 v4, vcc_lo, 1.0, v0, 1.0
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_rcp_f32_e32 v3, v2
; GFX11-FLUSH-NEXT:    s_denorm_mode 3
; GFX11-FLUSH-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-FLUSH-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX11-FLUSH-NEXT:    v_fmac_f32_e32 v3, v5, v3
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX11-FLUSH-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX11-FLUSH-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX11-FLUSH-NEXT:    s_denorm_mode 0
; GFX11-FLUSH-NEXT:    v_div_scale_f32 v4, null, v1, v1, 1.0
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX11-FLUSH-NEXT:    v_rcp_f32_e32 v3, v4
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_4) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_div_fixup_f32 v0, v2, v0, 1.0
; GFX11-FLUSH-NEXT:    v_div_scale_f32 v2, vcc_lo, 1.0, v1, 1.0
; GFX11-FLUSH-NEXT:    s_denorm_mode 3
; GFX11-FLUSH-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-FLUSH-NEXT:    v_fma_f32 v5, -v4, v3, 1.0
; GFX11-FLUSH-NEXT:    v_fmac_f32_e32 v3, v5, v3
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_mul_f32_e32 v5, v2, v3
; GFX11-FLUSH-NEXT:    v_fma_f32 v6, -v4, v5, v2
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX11-FLUSH-NEXT:    v_fma_f32 v2, -v4, v5, v2
; GFX11-FLUSH-NEXT:    s_denorm_mode 0
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX11-FLUSH-NEXT:    v_div_fixup_f32 v1, v2, v1, 1.0
; GFX11-FLUSH-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv <2 x float> <float 1.0, float 1.0>, %x
  ret <2 x float> %fdiv
}

define <2 x float> @v_rcp_v2f32_arcp(<2 x float> %x) {
; GFX6-IEEE-LABEL: v_rcp_v2f32_arcp:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-IEEE-NEXT:    v_div_scale_f32 v2, s[4:5], v0, v0, 1.0
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-IEEE-NEXT:    v_div_scale_f32 v4, vcc, 1.0, v0, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-IEEE-NEXT:    v_div_scale_f32 v3, s[4:5], v1, v1, 1.0
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v4, v3
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v2, v0, 1.0
; GFX6-IEEE-NEXT:    v_div_scale_f32 v2, vcc, 1.0, v1, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v5, -v3, v4, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v5, v2, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v3, v5, v2
; GFX6-IEEE-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v2, -v3, v5, v2
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v1, v2, v1, 1.0
; GFX6-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-FLUSH-LABEL: v_rcp_v2f32_arcp:
; GFX6-FLUSH:       ; %bb.0:
; GFX6-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v2, s[4:5], v0, v0, 1.0
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v4, vcc, 1.0, v0, 1.0
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v3, s[4:5], v1, v1, 1.0
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v4, v3
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v0, v2, v0, 1.0
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v2, vcc, 1.0, v1, 1.0
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, -v3, v4, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v5, v2, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v3, v5, v2
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, -v3, v5, v2
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v1, v2, v1, 1.0
; GFX6-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX89-IEEE-LABEL: v_rcp_v2f32_arcp:
; GFX89-IEEE:       ; %bb.0:
; GFX89-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX89-IEEE-NEXT:    v_div_scale_f32 v2, s[4:5], v0, v0, 1.0
; GFX89-IEEE-NEXT:    v_div_scale_f32 v3, s[4:5], v1, v1, 1.0
; GFX89-IEEE-NEXT:    v_div_scale_f32 v4, vcc, 1.0, v0, 1.0
; GFX89-IEEE-NEXT:    v_div_scale_f32 v5, s[4:5], 1.0, v1, 1.0
; GFX89-IEEE-NEXT:    v_rcp_f32_e32 v6, v2
; GFX89-IEEE-NEXT:    v_rcp_f32_e32 v7, v3
; GFX89-IEEE-NEXT:    v_fma_f32 v8, -v2, v6, 1.0
; GFX89-IEEE-NEXT:    v_fma_f32 v6, v8, v6, v6
; GFX89-IEEE-NEXT:    v_fma_f32 v9, -v3, v7, 1.0
; GFX89-IEEE-NEXT:    v_fma_f32 v7, v9, v7, v7
; GFX89-IEEE-NEXT:    v_mul_f32_e32 v8, v4, v6
; GFX89-IEEE-NEXT:    v_mul_f32_e32 v9, v5, v7
; GFX89-IEEE-NEXT:    v_fma_f32 v10, -v2, v8, v4
; GFX89-IEEE-NEXT:    v_fma_f32 v11, -v3, v9, v5
; GFX89-IEEE-NEXT:    v_fma_f32 v8, v10, v6, v8
; GFX89-IEEE-NEXT:    v_fma_f32 v9, v11, v7, v9
; GFX89-IEEE-NEXT:    v_fma_f32 v2, -v2, v8, v4
; GFX89-IEEE-NEXT:    v_fma_f32 v3, -v3, v9, v5
; GFX89-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v6, v8
; GFX89-IEEE-NEXT:    s_mov_b64 vcc, s[4:5]
; GFX89-IEEE-NEXT:    v_div_fmas_f32 v3, v3, v7, v9
; GFX89-IEEE-NEXT:    v_div_fixup_f32 v0, v2, v0, 1.0
; GFX89-IEEE-NEXT:    v_div_fixup_f32 v1, v3, v1, 1.0
; GFX89-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX89-FLUSH-LABEL: v_rcp_v2f32_arcp:
; GFX89-FLUSH:       ; %bb.0:
; GFX89-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX89-FLUSH-NEXT:    v_div_scale_f32 v2, s[4:5], v0, v0, 1.0
; GFX89-FLUSH-NEXT:    v_div_scale_f32 v3, vcc, 1.0, v0, 1.0
; GFX89-FLUSH-NEXT:    v_rcp_f32_e32 v4, v2
; GFX89-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX89-FLUSH-NEXT:    v_fma_f32 v5, -v2, v4, 1.0
; GFX89-FLUSH-NEXT:    v_fma_f32 v4, v5, v4, v4
; GFX89-FLUSH-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX89-FLUSH-NEXT:    v_fma_f32 v6, -v2, v5, v3
; GFX89-FLUSH-NEXT:    v_fma_f32 v5, v6, v4, v5
; GFX89-FLUSH-NEXT:    v_fma_f32 v2, -v2, v5, v3
; GFX89-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX89-FLUSH-NEXT:    v_div_scale_f32 v3, s[4:5], v1, v1, 1.0
; GFX89-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v4, v5
; GFX89-FLUSH-NEXT:    v_div_scale_f32 v4, vcc, 1.0, v1, 1.0
; GFX89-FLUSH-NEXT:    v_rcp_f32_e32 v5, v3
; GFX89-FLUSH-NEXT:    v_div_fixup_f32 v0, v2, v0, 1.0
; GFX89-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX89-FLUSH-NEXT:    v_fma_f32 v2, -v3, v5, 1.0
; GFX89-FLUSH-NEXT:    v_fma_f32 v2, v2, v5, v5
; GFX89-FLUSH-NEXT:    v_mul_f32_e32 v5, v4, v2
; GFX89-FLUSH-NEXT:    v_fma_f32 v6, -v3, v5, v4
; GFX89-FLUSH-NEXT:    v_fma_f32 v5, v6, v2, v5
; GFX89-FLUSH-NEXT:    v_fma_f32 v3, -v3, v5, v4
; GFX89-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX89-FLUSH-NEXT:    v_div_fmas_f32 v2, v3, v2, v5
; GFX89-FLUSH-NEXT:    v_div_fixup_f32 v1, v2, v1, 1.0
; GFX89-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-IEEE-LABEL: v_rcp_v2f32_arcp:
; GFX10-IEEE:       ; %bb.0:
; GFX10-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-IEEE-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-IEEE-NEXT:    v_div_scale_f32 v2, s4, v0, v0, 1.0
; GFX10-IEEE-NEXT:    v_div_scale_f32 v3, s4, v1, v1, 1.0
; GFX10-IEEE-NEXT:    v_div_scale_f32 v8, vcc_lo, 1.0, v0, 1.0
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v4, v2
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v5, v3
; GFX10-IEEE-NEXT:    v_fma_f32 v6, -v2, v4, 1.0
; GFX10-IEEE-NEXT:    v_fma_f32 v7, -v3, v5, 1.0
; GFX10-IEEE-NEXT:    v_fmac_f32_e32 v4, v6, v4
; GFX10-IEEE-NEXT:    v_div_scale_f32 v6, s4, 1.0, v1, 1.0
; GFX10-IEEE-NEXT:    v_fmac_f32_e32 v5, v7, v5
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v7, v8, v4
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v9, v6, v5
; GFX10-IEEE-NEXT:    v_fma_f32 v10, -v2, v7, v8
; GFX10-IEEE-NEXT:    v_fma_f32 v11, -v3, v9, v6
; GFX10-IEEE-NEXT:    v_fmac_f32_e32 v7, v10, v4
; GFX10-IEEE-NEXT:    v_fmac_f32_e32 v9, v11, v5
; GFX10-IEEE-NEXT:    v_fma_f32 v2, -v2, v7, v8
; GFX10-IEEE-NEXT:    v_fma_f32 v3, -v3, v9, v6
; GFX10-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v4, v7
; GFX10-IEEE-NEXT:    s_mov_b32 vcc_lo, s4
; GFX10-IEEE-NEXT:    v_div_fmas_f32 v3, v3, v5, v9
; GFX10-IEEE-NEXT:    v_div_fixup_f32 v0, v2, v0, 1.0
; GFX10-IEEE-NEXT:    v_div_fixup_f32 v1, v3, v1, 1.0
; GFX10-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-FLUSH-LABEL: v_rcp_v2f32_arcp:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-FLUSH-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-FLUSH-NEXT:    v_div_scale_f32 v2, s4, v0, v0, 1.0
; GFX10-FLUSH-NEXT:    v_div_scale_f32 v4, vcc_lo, 1.0, v0, 1.0
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v3, v2
; GFX10-FLUSH-NEXT:    s_denorm_mode 3
; GFX10-FLUSH-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX10-FLUSH-NEXT:    v_fmac_f32_e32 v3, v5, v3
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX10-FLUSH-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX10-FLUSH-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX10-FLUSH-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX10-FLUSH-NEXT:    s_denorm_mode 0
; GFX10-FLUSH-NEXT:    v_div_scale_f32 v4, s4, v1, v1, 1.0
; GFX10-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v3, v4
; GFX10-FLUSH-NEXT:    v_div_fixup_f32 v0, v2, v0, 1.0
; GFX10-FLUSH-NEXT:    v_div_scale_f32 v2, vcc_lo, 1.0, v1, 1.0
; GFX10-FLUSH-NEXT:    s_denorm_mode 3
; GFX10-FLUSH-NEXT:    v_fma_f32 v5, -v4, v3, 1.0
; GFX10-FLUSH-NEXT:    v_fmac_f32_e32 v3, v5, v3
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v5, v2, v3
; GFX10-FLUSH-NEXT:    v_fma_f32 v6, -v4, v5, v2
; GFX10-FLUSH-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX10-FLUSH-NEXT:    v_fma_f32 v2, -v4, v5, v2
; GFX10-FLUSH-NEXT:    s_denorm_mode 0
; GFX10-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX10-FLUSH-NEXT:    v_div_fixup_f32 v1, v2, v1, 1.0
; GFX10-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-IEEE-LABEL: v_rcp_v2f32_arcp:
; GFX11-IEEE:       ; %bb.0:
; GFX11-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-IEEE-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-IEEE-NEXT:    v_div_scale_f32 v2, null, v0, v0, 1.0
; GFX11-IEEE-NEXT:    v_div_scale_f32 v3, null, v1, v1, 1.0
; GFX11-IEEE-NEXT:    v_div_scale_f32 v8, vcc_lo, 1.0, v0, 1.0
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-IEEE-NEXT:    v_rcp_f32_e32 v4, v2
; GFX11-IEEE-NEXT:    v_rcp_f32_e32 v5, v3
; GFX11-IEEE-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-IEEE-NEXT:    v_fma_f32 v6, -v2, v4, 1.0
; GFX11-IEEE-NEXT:    v_fma_f32 v7, -v3, v5, 1.0
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-IEEE-NEXT:    v_dual_fmac_f32 v4, v6, v4 :: v_dual_fmac_f32 v5, v7, v5
; GFX11-IEEE-NEXT:    v_div_scale_f32 v6, s0, 1.0, v1, 1.0
; GFX11-IEEE-NEXT:    v_mul_f32_e32 v7, v8, v4
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-IEEE-NEXT:    v_mul_f32_e32 v9, v6, v5
; GFX11-IEEE-NEXT:    v_fma_f32 v10, -v2, v7, v8
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-IEEE-NEXT:    v_fma_f32 v11, -v3, v9, v6
; GFX11-IEEE-NEXT:    v_fmac_f32_e32 v7, v10, v4
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-IEEE-NEXT:    v_fmac_f32_e32 v9, v11, v5
; GFX11-IEEE-NEXT:    v_fma_f32 v2, -v2, v7, v8
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-IEEE-NEXT:    v_fma_f32 v3, -v3, v9, v6
; GFX11-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v4, v7
; GFX11-IEEE-NEXT:    s_mov_b32 vcc_lo, s0
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-IEEE-NEXT:    v_div_fmas_f32 v3, v3, v5, v9
; GFX11-IEEE-NEXT:    v_div_fixup_f32 v0, v2, v0, 1.0
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-IEEE-NEXT:    v_div_fixup_f32 v1, v3, v1, 1.0
; GFX11-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FLUSH-LABEL: v_rcp_v2f32_arcp:
; GFX11-FLUSH:       ; %bb.0:
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FLUSH-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-FLUSH-NEXT:    v_div_scale_f32 v2, null, v0, v0, 1.0
; GFX11-FLUSH-NEXT:    v_div_scale_f32 v4, vcc_lo, 1.0, v0, 1.0
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_rcp_f32_e32 v3, v2
; GFX11-FLUSH-NEXT:    s_denorm_mode 3
; GFX11-FLUSH-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-FLUSH-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX11-FLUSH-NEXT:    v_fmac_f32_e32 v3, v5, v3
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX11-FLUSH-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX11-FLUSH-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX11-FLUSH-NEXT:    s_denorm_mode 0
; GFX11-FLUSH-NEXT:    v_div_scale_f32 v4, null, v1, v1, 1.0
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX11-FLUSH-NEXT:    v_rcp_f32_e32 v3, v4
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_4) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_div_fixup_f32 v0, v2, v0, 1.0
; GFX11-FLUSH-NEXT:    v_div_scale_f32 v2, vcc_lo, 1.0, v1, 1.0
; GFX11-FLUSH-NEXT:    s_denorm_mode 3
; GFX11-FLUSH-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-FLUSH-NEXT:    v_fma_f32 v5, -v4, v3, 1.0
; GFX11-FLUSH-NEXT:    v_fmac_f32_e32 v3, v5, v3
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_mul_f32_e32 v5, v2, v3
; GFX11-FLUSH-NEXT:    v_fma_f32 v6, -v4, v5, v2
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_fmac_f32_e32 v5, v6, v3
; GFX11-FLUSH-NEXT:    v_fma_f32 v2, -v4, v5, v2
; GFX11-FLUSH-NEXT:    s_denorm_mode 0
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX11-FLUSH-NEXT:    v_div_fixup_f32 v1, v2, v1, 1.0
; GFX11-FLUSH-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv arcp <2 x float> <float 1.0, float 1.0>, %x
  ret <2 x float> %fdiv
}

define <2 x float> @v_rcp_v2f32_arcp_afn(<2 x float> %x) {
; GCN-LABEL: v_rcp_v2f32_arcp_afn:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_rcp_f32_e32 v0, v0
; GCN-NEXT:    v_rcp_f32_e32 v1, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_rcp_v2f32_arcp_afn:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_rcp_f32_e32 v0, v0
; GFX10-NEXT:    v_rcp_f32_e32 v1, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_rcp_v2f32_arcp_afn:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_rcp_f32_e32 v0, v0
; GFX11-NEXT:    v_rcp_f32_e32 v1, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv arcp afn <2 x float> <float 1.0, float 1.0>, %x
  ret <2 x float> %fdiv
}

define <2 x float> @v_rcp_v2f32_ulp25(<2 x float> %x) {
; GCN-IEEE-LABEL: v_rcp_v2f32_ulp25:
; GCN-IEEE:       ; %bb.0:
; GCN-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-IEEE-NEXT:    s_mov_b32 s4, 0x6f800000
; GCN-IEEE-NEXT:    v_mov_b32_e32 v2, 0x2f800000
; GCN-IEEE-NEXT:    v_cmp_gt_f32_e64 vcc, |v0|, s4
; GCN-IEEE-NEXT:    v_cndmask_b32_e32 v3, 1.0, v2, vcc
; GCN-IEEE-NEXT:    v_cmp_gt_f32_e64 vcc, |v1|, s4
; GCN-IEEE-NEXT:    v_cndmask_b32_e32 v2, 1.0, v2, vcc
; GCN-IEEE-NEXT:    v_mul_f32_e32 v0, v0, v3
; GCN-IEEE-NEXT:    v_mul_f32_e32 v1, v1, v2
; GCN-IEEE-NEXT:    v_rcp_f32_e32 v0, v0
; GCN-IEEE-NEXT:    v_rcp_f32_e32 v1, v1
; GCN-IEEE-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GCN-IEEE-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GCN-IEEE-NEXT:    v_mul_f32_e32 v0, v3, v0
; GCN-IEEE-NEXT:    v_mul_f32_e32 v1, v2, v1
; GCN-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-FLUSH-LABEL: v_rcp_v2f32_ulp25:
; GCN-FLUSH:       ; %bb.0:
; GCN-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-FLUSH-NEXT:    v_rcp_f32_e32 v0, v0
; GCN-FLUSH-NEXT:    v_rcp_f32_e32 v1, v1
; GCN-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-IEEE-LABEL: v_rcp_v2f32_ulp25:
; GFX10-IEEE:       ; %bb.0:
; GFX10-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-IEEE-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-IEEE-NEXT:    v_cmp_lt_f32_e64 s4, 0x6f800000, |v0|
; GFX10-IEEE-NEXT:    v_cndmask_b32_e64 v2, 1.0, 0x2f800000, s4
; GFX10-IEEE-NEXT:    v_cmp_lt_f32_e64 s4, 0x6f800000, |v1|
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX10-IEEE-NEXT:    v_cndmask_b32_e64 v3, 1.0, 0x2f800000, s4
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v0, v0
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v1, v1, v3
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v1, v1
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v0, v2, v0
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v1, v3, v1
; GFX10-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-FLUSH-LABEL: v_rcp_v2f32_ulp25:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-FLUSH-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v0, v0
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v1, v1
; GFX10-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-IEEE-LABEL: v_rcp_v2f32_ulp25:
; GFX11-IEEE:       ; %bb.0:
; GFX11-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-IEEE-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-IEEE-NEXT:    v_cmp_lt_f32_e64 s0, 0x6f800000, |v0|
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-IEEE-NEXT:    v_cndmask_b32_e64 v2, 1.0, 0x2f800000, s0
; GFX11-IEEE-NEXT:    v_cmp_lt_f32_e64 s0, 0x6f800000, |v1|
; GFX11-IEEE-NEXT:    v_cndmask_b32_e64 v3, 1.0, 0x2f800000, s0
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-IEEE-NEXT:    v_dual_mul_f32 v0, v0, v2 :: v_dual_mul_f32 v1, v1, v3
; GFX11-IEEE-NEXT:    v_rcp_f32_e32 v0, v0
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-IEEE-NEXT:    v_rcp_f32_e32 v1, v1
; GFX11-IEEE-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-IEEE-NEXT:    v_dual_mul_f32 v0, 1.0, v0 :: v_dual_mul_f32 v1, 1.0, v1
; GFX11-IEEE-NEXT:    v_dual_mul_f32 v0, v2, v0 :: v_dual_mul_f32 v1, v3, v1
; GFX11-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FLUSH-LABEL: v_rcp_v2f32_ulp25:
; GFX11-FLUSH:       ; %bb.0:
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FLUSH-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-FLUSH-NEXT:    v_rcp_f32_e32 v0, v0
; GFX11-FLUSH-NEXT:    v_rcp_f32_e32 v1, v1
; GFX11-FLUSH-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv <2 x float> <float 1.0, float 1.0>, %x, !fpmath !0
  ret <2 x float> %fdiv
}

define <2 x float> @v_fdiv_v2f32_afn_ulp25(<2 x float> %a, <2 x float> %b) {
; GCN-LABEL: v_fdiv_v2f32_afn_ulp25:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_rcp_f32_e32 v2, v2
; GCN-NEXT:    v_rcp_f32_e32 v3, v3
; GCN-NEXT:    v_mul_f32_e32 v0, v0, v2
; GCN-NEXT:    v_mul_f32_e32 v1, v1, v3
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_v2f32_afn_ulp25:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_rcp_f32_e32 v2, v2
; GFX10-NEXT:    v_rcp_f32_e32 v3, v3
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX10-NEXT:    v_mul_f32_e32 v1, v1, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_v2f32_afn_ulp25:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_rcp_f32_e32 v2, v2
; GFX11-NEXT:    v_rcp_f32_e32 v3, v3
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_dual_mul_f32 v0, v0, v2 :: v_dual_mul_f32 v1, v1, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv afn <2 x float> %a, %b, !fpmath !0
  ret <2 x float> %fdiv
}

define <2 x float> @v_fdiv_v2f32_arcp_ulp25(<2 x float> %a, <2 x float> %b) {
; GFX6-IEEE-LABEL: v_fdiv_v2f32_arcp_ulp25:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-IEEE-NEXT:    v_div_scale_f32 v4, s[4:5], v2, v2, v0
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v5, v4
; GFX6-IEEE-NEXT:    v_div_scale_f32 v6, vcc, v0, v2, v0
; GFX6-IEEE-NEXT:    v_fma_f32 v7, -v4, v5, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v5, v7, v5, v5
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v7, v6, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v8, -v4, v7, v6
; GFX6-IEEE-NEXT:    v_fma_f32 v7, v8, v5, v7
; GFX6-IEEE-NEXT:    v_fma_f32 v4, -v4, v7, v6
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v4, v4, v5, v7
; GFX6-IEEE-NEXT:    v_div_scale_f32 v5, s[4:5], v3, v3, v1
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v6, v5
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v4, v2, v0
; GFX6-IEEE-NEXT:    v_div_scale_f32 v2, vcc, v1, v3, v1
; GFX6-IEEE-NEXT:    v_fma_f32 v4, -v5, v6, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v4, v4, v6, v6
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v6, v2, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v7, -v5, v6, v2
; GFX6-IEEE-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX6-IEEE-NEXT:    v_fma_f32 v2, -v5, v6, v2
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v4, v6
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v1, v2, v3, v1
; GFX6-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-FLUSH-LABEL: v_fdiv_v2f32_arcp_ulp25:
; GCN-FLUSH:       ; %bb.0:
; GCN-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-FLUSH-NEXT:    s_mov_b32 s4, 0x6f800000
; GCN-FLUSH-NEXT:    v_mov_b32_e32 v4, 0x2f800000
; GCN-FLUSH-NEXT:    v_cmp_gt_f32_e64 vcc, |v2|, s4
; GCN-FLUSH-NEXT:    v_cndmask_b32_e32 v5, 1.0, v4, vcc
; GCN-FLUSH-NEXT:    v_cmp_gt_f32_e64 vcc, |v3|, s4
; GCN-FLUSH-NEXT:    v_cndmask_b32_e32 v4, 1.0, v4, vcc
; GCN-FLUSH-NEXT:    v_mul_f32_e32 v2, v2, v5
; GCN-FLUSH-NEXT:    v_mul_f32_e32 v3, v3, v4
; GCN-FLUSH-NEXT:    v_rcp_f32_e32 v2, v2
; GCN-FLUSH-NEXT:    v_rcp_f32_e32 v3, v3
; GCN-FLUSH-NEXT:    v_mul_f32_e32 v0, v0, v2
; GCN-FLUSH-NEXT:    v_mul_f32_e32 v1, v1, v3
; GCN-FLUSH-NEXT:    v_mul_f32_e32 v0, v5, v0
; GCN-FLUSH-NEXT:    v_mul_f32_e32 v1, v4, v1
; GCN-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX89-IEEE-LABEL: v_fdiv_v2f32_arcp_ulp25:
; GFX89-IEEE:       ; %bb.0:
; GFX89-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX89-IEEE-NEXT:    v_div_scale_f32 v4, s[4:5], v2, v2, v0
; GFX89-IEEE-NEXT:    v_div_scale_f32 v5, s[4:5], v3, v3, v1
; GFX89-IEEE-NEXT:    v_div_scale_f32 v6, vcc, v0, v2, v0
; GFX89-IEEE-NEXT:    v_div_scale_f32 v7, s[4:5], v1, v3, v1
; GFX89-IEEE-NEXT:    v_rcp_f32_e32 v8, v4
; GFX89-IEEE-NEXT:    v_rcp_f32_e32 v9, v5
; GFX89-IEEE-NEXT:    v_fma_f32 v10, -v4, v8, 1.0
; GFX89-IEEE-NEXT:    v_fma_f32 v8, v10, v8, v8
; GFX89-IEEE-NEXT:    v_fma_f32 v11, -v5, v9, 1.0
; GFX89-IEEE-NEXT:    v_fma_f32 v9, v11, v9, v9
; GFX89-IEEE-NEXT:    v_mul_f32_e32 v10, v6, v8
; GFX89-IEEE-NEXT:    v_mul_f32_e32 v11, v7, v9
; GFX89-IEEE-NEXT:    v_fma_f32 v12, -v4, v10, v6
; GFX89-IEEE-NEXT:    v_fma_f32 v13, -v5, v11, v7
; GFX89-IEEE-NEXT:    v_fma_f32 v10, v12, v8, v10
; GFX89-IEEE-NEXT:    v_fma_f32 v11, v13, v9, v11
; GFX89-IEEE-NEXT:    v_fma_f32 v4, -v4, v10, v6
; GFX89-IEEE-NEXT:    v_fma_f32 v5, -v5, v11, v7
; GFX89-IEEE-NEXT:    v_div_fmas_f32 v4, v4, v8, v10
; GFX89-IEEE-NEXT:    s_mov_b64 vcc, s[4:5]
; GFX89-IEEE-NEXT:    v_div_fmas_f32 v5, v5, v9, v11
; GFX89-IEEE-NEXT:    v_div_fixup_f32 v0, v4, v2, v0
; GFX89-IEEE-NEXT:    v_div_fixup_f32 v1, v5, v3, v1
; GFX89-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-IEEE-LABEL: v_fdiv_v2f32_arcp_ulp25:
; GFX10-IEEE:       ; %bb.0:
; GFX10-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-IEEE-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-IEEE-NEXT:    v_div_scale_f32 v4, s4, v2, v2, v0
; GFX10-IEEE-NEXT:    v_div_scale_f32 v5, s4, v3, v3, v1
; GFX10-IEEE-NEXT:    v_div_scale_f32 v10, vcc_lo, v0, v2, v0
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v6, v4
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v7, v5
; GFX10-IEEE-NEXT:    v_fma_f32 v8, -v4, v6, 1.0
; GFX10-IEEE-NEXT:    v_fma_f32 v9, -v5, v7, 1.0
; GFX10-IEEE-NEXT:    v_fmac_f32_e32 v6, v8, v6
; GFX10-IEEE-NEXT:    v_div_scale_f32 v8, s4, v1, v3, v1
; GFX10-IEEE-NEXT:    v_fmac_f32_e32 v7, v9, v7
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v9, v10, v6
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v11, v8, v7
; GFX10-IEEE-NEXT:    v_fma_f32 v12, -v4, v9, v10
; GFX10-IEEE-NEXT:    v_fma_f32 v13, -v5, v11, v8
; GFX10-IEEE-NEXT:    v_fmac_f32_e32 v9, v12, v6
; GFX10-IEEE-NEXT:    v_fmac_f32_e32 v11, v13, v7
; GFX10-IEEE-NEXT:    v_fma_f32 v4, -v4, v9, v10
; GFX10-IEEE-NEXT:    v_fma_f32 v5, -v5, v11, v8
; GFX10-IEEE-NEXT:    v_div_fmas_f32 v4, v4, v6, v9
; GFX10-IEEE-NEXT:    s_mov_b32 vcc_lo, s4
; GFX10-IEEE-NEXT:    v_div_fmas_f32 v5, v5, v7, v11
; GFX10-IEEE-NEXT:    v_div_fixup_f32 v0, v4, v2, v0
; GFX10-IEEE-NEXT:    v_div_fixup_f32 v1, v5, v3, v1
; GFX10-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-FLUSH-LABEL: v_fdiv_v2f32_arcp_ulp25:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-FLUSH-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-FLUSH-NEXT:    v_cmp_lt_f32_e64 s4, 0x6f800000, |v2|
; GFX10-FLUSH-NEXT:    v_cndmask_b32_e64 v4, 1.0, 0x2f800000, s4
; GFX10-FLUSH-NEXT:    v_cmp_lt_f32_e64 s4, 0x6f800000, |v3|
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v2, v2, v4
; GFX10-FLUSH-NEXT:    v_cndmask_b32_e64 v5, 1.0, 0x2f800000, s4
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v2, v2
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v3, v3, v5
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v3, v3
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v0, v4, v0
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v1, v1, v3
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v1, v5, v1
; GFX10-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-IEEE-LABEL: v_fdiv_v2f32_arcp_ulp25:
; GFX11-IEEE:       ; %bb.0:
; GFX11-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-IEEE-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-IEEE-NEXT:    v_div_scale_f32 v4, null, v2, v2, v0
; GFX11-IEEE-NEXT:    v_div_scale_f32 v5, null, v3, v3, v1
; GFX11-IEEE-NEXT:    v_div_scale_f32 v10, vcc_lo, v0, v2, v0
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-IEEE-NEXT:    v_rcp_f32_e32 v6, v4
; GFX11-IEEE-NEXT:    v_rcp_f32_e32 v7, v5
; GFX11-IEEE-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-IEEE-NEXT:    v_fma_f32 v8, -v4, v6, 1.0
; GFX11-IEEE-NEXT:    v_fma_f32 v9, -v5, v7, 1.0
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-IEEE-NEXT:    v_dual_fmac_f32 v6, v8, v6 :: v_dual_fmac_f32 v7, v9, v7
; GFX11-IEEE-NEXT:    v_div_scale_f32 v8, s0, v1, v3, v1
; GFX11-IEEE-NEXT:    v_mul_f32_e32 v9, v10, v6
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-IEEE-NEXT:    v_mul_f32_e32 v11, v8, v7
; GFX11-IEEE-NEXT:    v_fma_f32 v12, -v4, v9, v10
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-IEEE-NEXT:    v_fma_f32 v13, -v5, v11, v8
; GFX11-IEEE-NEXT:    v_fmac_f32_e32 v9, v12, v6
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-IEEE-NEXT:    v_fmac_f32_e32 v11, v13, v7
; GFX11-IEEE-NEXT:    v_fma_f32 v4, -v4, v9, v10
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-IEEE-NEXT:    v_fma_f32 v5, -v5, v11, v8
; GFX11-IEEE-NEXT:    v_div_fmas_f32 v4, v4, v6, v9
; GFX11-IEEE-NEXT:    s_mov_b32 vcc_lo, s0
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-IEEE-NEXT:    v_div_fmas_f32 v5, v5, v7, v11
; GFX11-IEEE-NEXT:    v_div_fixup_f32 v0, v4, v2, v0
; GFX11-IEEE-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-IEEE-NEXT:    v_div_fixup_f32 v1, v5, v3, v1
; GFX11-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FLUSH-LABEL: v_fdiv_v2f32_arcp_ulp25:
; GFX11-FLUSH:       ; %bb.0:
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FLUSH-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-FLUSH-NEXT:    v_cmp_lt_f32_e64 s0, 0x6f800000, |v2|
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_cndmask_b32_e64 v4, 1.0, 0x2f800000, s0
; GFX11-FLUSH-NEXT:    v_cmp_lt_f32_e64 s0, 0x6f800000, |v3|
; GFX11-FLUSH-NEXT:    v_cndmask_b32_e64 v5, 1.0, 0x2f800000, s0
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_dual_mul_f32 v2, v2, v4 :: v_dual_mul_f32 v3, v3, v5
; GFX11-FLUSH-NEXT:    v_rcp_f32_e32 v2, v2
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_rcp_f32_e32 v3, v3
; GFX11-FLUSH-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-FLUSH-NEXT:    v_dual_mul_f32 v0, v0, v2 :: v_dual_mul_f32 v1, v1, v3
; GFX11-FLUSH-NEXT:    v_dual_mul_f32 v0, v4, v0 :: v_dual_mul_f32 v1, v5, v1
; GFX11-FLUSH-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv arcp <2 x float> %a, %b, !fpmath !0
  ret <2 x float> %fdiv
}

define <2 x float> @v_fdiv_v2f32_arcp_afn_ulp25(<2 x float> %a, <2 x float> %b) {
; GCN-LABEL: v_fdiv_v2f32_arcp_afn_ulp25:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_rcp_f32_e32 v2, v2
; GCN-NEXT:    v_rcp_f32_e32 v3, v3
; GCN-NEXT:    v_mul_f32_e32 v0, v0, v2
; GCN-NEXT:    v_mul_f32_e32 v1, v1, v3
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_v2f32_arcp_afn_ulp25:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_rcp_f32_e32 v2, v2
; GFX10-NEXT:    v_rcp_f32_e32 v3, v3
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX10-NEXT:    v_mul_f32_e32 v1, v1, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_v2f32_arcp_afn_ulp25:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_rcp_f32_e32 v2, v2
; GFX11-NEXT:    v_rcp_f32_e32 v3, v3
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_dual_mul_f32 v0, v0, v2 :: v_dual_mul_f32 v1, v1, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv afn arcp <2 x float> %a, %b, !fpmath !0
  ret <2 x float> %fdiv
}

!0 = !{float 2.500000e+00}
