; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -march=amdgcn -mcpu=verde -verify-machineinstrs < %s | FileCheck -check-prefixes=VERDE %s
; RUN: llc -march=amdgcn -mcpu=gfx900 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX6789 %s
; RUN: llc -march=amdgcn -mcpu=gfx1010 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX10 %s

define amdgpu_ps <4 x float> @sample_cd_1d(<8 x i32> inreg %rsrc, <4 x i32> inreg %samp, float %dsdh, float %dsdv, float %s) {
; VERDE-LABEL: sample_cd_1d:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_sample_cd v[0:3], v[0:2], s[0:7], s[8:11] dmask:0xf
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: sample_cd_1d:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_sample_cd v[0:3], v[0:2], s[0:7], s[8:11] dmask:0xf
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: sample_cd_1d:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    image_sample_cd v[0:3], v[0:2], s[0:7], s[8:11] dmask:0xf dim:SQ_RSRC_IMG_1D
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    ; return to shader part epilog
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.sample.cd.1d.v4f32.f32.f32(i32 15, float %dsdh, float %dsdv, float %s, <8 x i32> %rsrc, <4 x i32> %samp, i1 0, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @sample_cd_2d(<8 x i32> inreg %rsrc, <4 x i32> inreg %samp, float %dsdh, float %dtdh, float %dsdv, float %dtdv, float %s, float %t) {
; VERDE-LABEL: sample_cd_2d:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_sample_cd v[0:3], v[0:5], s[0:7], s[8:11] dmask:0xf
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: sample_cd_2d:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_sample_cd v[0:3], v[0:5], s[0:7], s[8:11] dmask:0xf
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: sample_cd_2d:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    image_sample_cd v[0:3], v[0:5], s[0:7], s[8:11] dmask:0xf dim:SQ_RSRC_IMG_2D
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    ; return to shader part epilog
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.sample.cd.2d.v4f32.f32.f32(i32 15, float %dsdh, float %dtdh, float %dsdv, float %dtdv, float %s, float %t, <8 x i32> %rsrc, <4 x i32> %samp, i1 0, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @sample_c_cd_1d(<8 x i32> inreg %rsrc, <4 x i32> inreg %samp, float %zcompare, float %dsdh, float %dsdv, float %s) {
; VERDE-LABEL: sample_c_cd_1d:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_sample_c_cd v[0:3], v[0:3], s[0:7], s[8:11] dmask:0xf
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: sample_c_cd_1d:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_sample_c_cd v[0:3], v[0:3], s[0:7], s[8:11] dmask:0xf
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: sample_c_cd_1d:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    image_sample_c_cd v[0:3], v[0:3], s[0:7], s[8:11] dmask:0xf dim:SQ_RSRC_IMG_1D
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    ; return to shader part epilog
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.sample.c.cd.1d.v4f32.f32.f32(i32 15, float %zcompare, float %dsdh, float %dsdv, float %s, <8 x i32> %rsrc, <4 x i32> %samp, i1 0, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @sample_c_cd_2d(<8 x i32> inreg %rsrc, <4 x i32> inreg %samp, float %zcompare, float %dsdh, float %dtdh, float %dsdv, float %dtdv, float %s, float %t) {
; VERDE-LABEL: sample_c_cd_2d:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_sample_c_cd v[0:3], v[0:6], s[0:7], s[8:11] dmask:0xf
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: sample_c_cd_2d:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_sample_c_cd v[0:3], v[0:6], s[0:7], s[8:11] dmask:0xf
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: sample_c_cd_2d:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    image_sample_c_cd v[0:3], v[0:6], s[0:7], s[8:11] dmask:0xf dim:SQ_RSRC_IMG_2D
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    ; return to shader part epilog
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.sample.c.cd.2d.v4f32.f32.f32(i32 15, float %zcompare, float %dsdh, float %dtdh, float %dsdv, float %dtdv, float %s, float %t, <8 x i32> %rsrc, <4 x i32> %samp, i1 0, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @sample_cd_cl_1d(<8 x i32> inreg %rsrc, <4 x i32> inreg %samp, float %dsdh, float %dsdv, float %s, float %clamp) {
; VERDE-LABEL: sample_cd_cl_1d:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_sample_cd_cl v[0:3], v[0:3], s[0:7], s[8:11] dmask:0xf
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: sample_cd_cl_1d:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_sample_cd_cl v[0:3], v[0:3], s[0:7], s[8:11] dmask:0xf
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: sample_cd_cl_1d:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    image_sample_cd_cl v[0:3], v[0:3], s[0:7], s[8:11] dmask:0xf dim:SQ_RSRC_IMG_1D
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    ; return to shader part epilog
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.sample.cd.cl.1d.v4f32.f32.f32(i32 15, float %dsdh, float %dsdv, float %s, float %clamp, <8 x i32> %rsrc, <4 x i32> %samp, i1 0, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @sample_cd_cl_2d(<8 x i32> inreg %rsrc, <4 x i32> inreg %samp, float %dsdh, float %dtdh, float %dsdv, float %dtdv, float %s, float %t, float %clamp) {
; VERDE-LABEL: sample_cd_cl_2d:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_sample_cd_cl v[0:3], v[0:6], s[0:7], s[8:11] dmask:0xf
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: sample_cd_cl_2d:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_sample_cd_cl v[0:3], v[0:6], s[0:7], s[8:11] dmask:0xf
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: sample_cd_cl_2d:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    image_sample_cd_cl v[0:3], v[0:6], s[0:7], s[8:11] dmask:0xf dim:SQ_RSRC_IMG_2D
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    ; return to shader part epilog
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.sample.cd.cl.2d.v4f32.f32.f32(i32 15, float %dsdh, float %dtdh, float %dsdv, float %dtdv, float %s, float %t, float %clamp, <8 x i32> %rsrc, <4 x i32> %samp, i1 0, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @sample_c_cd_cl_1d(<8 x i32> inreg %rsrc, <4 x i32> inreg %samp, float %zcompare, float %dsdh, float %dsdv, float %s, float %clamp) {
; VERDE-LABEL: sample_c_cd_cl_1d:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_sample_c_cd_cl v[0:3], v[0:4], s[0:7], s[8:11] dmask:0xf
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: sample_c_cd_cl_1d:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_sample_c_cd_cl v[0:3], v[0:4], s[0:7], s[8:11] dmask:0xf
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: sample_c_cd_cl_1d:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    image_sample_c_cd_cl v[0:3], v[0:4], s[0:7], s[8:11] dmask:0xf dim:SQ_RSRC_IMG_1D
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    ; return to shader part epilog
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.sample.c.cd.cl.1d.v4f32.f32.f32(i32 15, float %zcompare, float %dsdh, float %dsdv, float %s, float %clamp, <8 x i32> %rsrc, <4 x i32> %samp, i1 0, i32 0, i32 0)
  ret <4 x float> %v
}

declare <4 x float> @llvm.amdgcn.image.sample.cd.1d.v4f32.f32.f32(i32, float, float, float, <8 x i32>, <4 x i32>, i1, i32, i32) #1
declare <4 x float> @llvm.amdgcn.image.sample.cd.2d.v4f32.f32.f32(i32, float, float, float, float, float, float, <8 x i32>, <4 x i32>, i1, i32, i32) #1
declare <4 x float> @llvm.amdgcn.image.sample.c.cd.1d.v4f32.f32.f32(i32, float, float, float, float, <8 x i32>, <4 x i32>, i1, i32, i32) #1
declare <4 x float> @llvm.amdgcn.image.sample.c.cd.2d.v4f32.f32.f32(i32, float, float, float, float, float, float, float, <8 x i32>, <4 x i32>, i1, i32, i32) #1
declare <4 x float> @llvm.amdgcn.image.sample.cd.cl.1d.v4f32.f32.f32(i32, float, float, float, float, <8 x i32>, <4 x i32>, i1, i32, i32) #1
declare <4 x float> @llvm.amdgcn.image.sample.cd.cl.2d.v4f32.f32.f32(i32, float, float, float, float, float, float, float, <8 x i32>, <4 x i32>, i1, i32, i32) #1
declare <4 x float> @llvm.amdgcn.image.sample.c.cd.cl.1d.v4f32.f32.f32(i32, float, float, float, float, float, <8 x i32>, <4 x i32>, i1, i32, i32) #1
declare <4 x float> @llvm.amdgcn.image.sample.c.cd.cl.2d.v4f32.f32.f32(i32, float, float, float, float, float, float, float, float, <8 x i32>, <4 x i32>, i1, i32, i32) #1

attributes #0 = { nounwind }
attributes #1 = { nounwind readonly }
attributes #2 = { nounwind readnone }
