; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=powerpc64-unknown-linux-gnu -mcpu=pwr8 -verify-machineinstrs | FileCheck %s

@CVal = external local_unnamed_addr global i8, align 1
@SVal = external local_unnamed_addr global i16, align 2
@IVal = external local_unnamed_addr global i32, align 4
@LVal = external local_unnamed_addr global i64, align 8
@USVal = external local_unnamed_addr global i16, align 2
@arr = external local_unnamed_addr global ptr, align 8
@arri = external local_unnamed_addr global ptr, align 8

; Test the same constant can be used by different stores.

%struct.S = type { i64, i8, i16, i32 }

define void @foo(ptr %p) {
; CHECK-LABEL: foo:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li 4, 0
; CHECK-NEXT:    stb 4, 8(3)
; CHECK-NEXT:    std 4, 0(3)
; CHECK-NEXT:    sth 4, 10(3)
; CHECK-NEXT:    stw 4, 12(3)
; CHECK-NEXT:    blr
  store i64 0, ptr %p, align 8
  %c = getelementptr %struct.S, ptr %p, i64 0, i32 1
  store i8 0, ptr %c, align 8
  %s = getelementptr %struct.S, ptr %p, i64 0, i32 2
  store i16 0, ptr %s, align 2
  %i = getelementptr %struct.S, ptr %p, i64 0, i32 3
  store i32 0, ptr %i, align 4
  ret void

}

define void @bar(ptr %p) {
; CHECK-LABEL: bar:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li 4, 2
; CHECK-NEXT:    stw 4, 12(3)
; CHECK-NEXT:    sth 4, 10(3)
; CHECK-NEXT:    std 4, 0(3)
; CHECK-NEXT:    stb 4, 8(3)
; CHECK-NEXT:    blr
  %i = getelementptr %struct.S, ptr %p, i64 0, i32 3
  store i32 2, ptr %i, align 4
  %s = getelementptr %struct.S, ptr %p, i64 0, i32 2
  store i16 2, ptr %s, align 2
  %c = getelementptr %struct.S, ptr %p, i64 0, i32 1
  store i8 2, ptr %c, align 8
  store i64 2, ptr %p, align 8
  ret void

}

; Function Attrs: norecurse nounwind
define void @setSmallNeg() {
; CHECK-LABEL: setSmallNeg:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis 3, 2, .LC0@toc@ha
; CHECK-NEXT:    addis 4, 2, .LC1@toc@ha
; CHECK-NEXT:    addis 5, 2, .LC2@toc@ha
; CHECK-NEXT:    addis 6, 2, .LC3@toc@ha
; CHECK-NEXT:    li 7, -7
; CHECK-NEXT:    ld 3, .LC0@toc@l(3)
; CHECK-NEXT:    ld 4, .LC1@toc@l(4)
; CHECK-NEXT:    ld 5, .LC2@toc@l(5)
; CHECK-NEXT:    ld 6, .LC3@toc@l(6)
; CHECK-NEXT:    stb 7, 0(3)
; CHECK-NEXT:    sth 7, 0(4)
; CHECK-NEXT:    std 7, 0(6)
; CHECK-NEXT:    stw 7, 0(5)
; CHECK-NEXT:    blr
entry:
  store i8 -7, ptr @CVal, align 1
  store i16 -7, ptr @SVal, align 2
  store i32 -7, ptr @IVal, align 4
  store i64 -7, ptr @LVal, align 8
  ret void
}

; Function Attrs: norecurse nounwind
define void @setSmallPos() {
; CHECK-LABEL: setSmallPos:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis 3, 2, .LC0@toc@ha
; CHECK-NEXT:    addis 4, 2, .LC1@toc@ha
; CHECK-NEXT:    addis 5, 2, .LC2@toc@ha
; CHECK-NEXT:    addis 6, 2, .LC3@toc@ha
; CHECK-NEXT:    li 7, 8
; CHECK-NEXT:    ld 3, .LC0@toc@l(3)
; CHECK-NEXT:    ld 4, .LC1@toc@l(4)
; CHECK-NEXT:    ld 5, .LC2@toc@l(5)
; CHECK-NEXT:    ld 6, .LC3@toc@l(6)
; CHECK-NEXT:    stb 7, 0(3)
; CHECK-NEXT:    sth 7, 0(4)
; CHECK-NEXT:    std 7, 0(6)
; CHECK-NEXT:    stw 7, 0(5)
; CHECK-NEXT:    blr
entry:
  store i8 8, ptr @CVal, align 1
  store i16 8, ptr @SVal, align 2
  store i32 8, ptr @IVal, align 4
  store i64 8, ptr @LVal, align 8
  ret void
}

; Function Attrs: norecurse nounwind
define void @setMaxNeg() {
; CHECK-LABEL: setMaxNeg:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis 3, 2, .LC1@toc@ha
; CHECK-NEXT:    addis 4, 2, .LC2@toc@ha
; CHECK-NEXT:    addis 5, 2, .LC3@toc@ha
; CHECK-NEXT:    li 6, -32768
; CHECK-NEXT:    ld 3, .LC1@toc@l(3)
; CHECK-NEXT:    ld 4, .LC2@toc@l(4)
; CHECK-NEXT:    ld 5, .LC3@toc@l(5)
; CHECK-NEXT:    sth 6, 0(3)
; CHECK-NEXT:    stw 6, 0(4)
; CHECK-NEXT:    std 6, 0(5)
; CHECK-NEXT:    blr
entry:
  store i16 -32768, ptr @SVal, align 2
  store i32 -32768, ptr @IVal, align 4
  store i64 -32768, ptr @LVal, align 8
  ret void
}

; Function Attrs: norecurse nounwind
define void @setMaxPos() {
; CHECK-LABEL: setMaxPos:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis 3, 2, .LC1@toc@ha
; CHECK-NEXT:    addis 4, 2, .LC2@toc@ha
; CHECK-NEXT:    addis 5, 2, .LC3@toc@ha
; CHECK-NEXT:    li 6, 32767
; CHECK-NEXT:    ld 3, .LC1@toc@l(3)
; CHECK-NEXT:    ld 4, .LC2@toc@l(4)
; CHECK-NEXT:    ld 5, .LC3@toc@l(5)
; CHECK-NEXT:    sth 6, 0(3)
; CHECK-NEXT:    stw 6, 0(4)
; CHECK-NEXT:    std 6, 0(5)
; CHECK-NEXT:    blr
entry:
  store i16 32767, ptr @SVal, align 2
  store i32 32767, ptr @IVal, align 4
  store i64 32767, ptr @LVal, align 8
  ret void
}

; Function Attrs: norecurse nounwind
define void @setExcessiveNeg() {
; CHECK-LABEL: setExcessiveNeg:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis 3, 2, .LC2@toc@ha
; CHECK-NEXT:    addis 4, 2, .LC3@toc@ha
; CHECK-NEXT:    lis 5, -1
; CHECK-NEXT:    ld 3, .LC2@toc@l(3)
; CHECK-NEXT:    ld 4, .LC3@toc@l(4)
; CHECK-NEXT:    ori 5, 5, 32767
; CHECK-NEXT:    stw 5, 0(3)
; CHECK-NEXT:    std 5, 0(4)
; CHECK-NEXT:    blr
entry:
  store i32 -32769, ptr @IVal, align 4
  store i64 -32769, ptr @LVal, align 8
  ret void
}

; Function Attrs: norecurse nounwind
define void @setExcessivePos() {
; CHECK-LABEL: setExcessivePos:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis 3, 2, .LC4@toc@ha
; CHECK-NEXT:    addis 4, 2, .LC2@toc@ha
; CHECK-NEXT:    addis 5, 2, .LC3@toc@ha
; CHECK-NEXT:    li 6, 0
; CHECK-NEXT:    ld 3, .LC4@toc@l(3)
; CHECK-NEXT:    ld 4, .LC2@toc@l(4)
; CHECK-NEXT:    ld 5, .LC3@toc@l(5)
; CHECK-NEXT:    ori 6, 6, 32768
; CHECK-NEXT:    sth 6, 0(3)
; CHECK-NEXT:    stw 6, 0(4)
; CHECK-NEXT:    std 6, 0(5)
; CHECK-NEXT:    blr
entry:
  store i16 -32768, ptr @USVal, align 2
  store i32 32768, ptr @IVal, align 4
  store i64 32768, ptr @LVal, align 8
  ret void
}

define void @SetArr(i32 signext %Len) {
; CHECK-LABEL: SetArr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpwi 3, 0
; CHECK-NEXT:    blelr 0
; CHECK-NEXT:  # %bb.1: # %for.body.lr.ph
; CHECK-NEXT:    addis 4, 2, .LC5@toc@ha
; CHECK-NEXT:    addis 5, 2, .LC6@toc@ha
; CHECK-NEXT:    clrldi 6, 3, 32
; CHECK-NEXT:    ld 4, .LC5@toc@l(4)
; CHECK-NEXT:    ld 5, .LC6@toc@l(5)
; CHECK-NEXT:    ld 4, 0(4)
; CHECK-NEXT:    ld 5, 0(5)
; CHECK-NEXT:    mtctr 6
; CHECK-NEXT:    addi 3, 4, -8
; CHECK-NEXT:    addi 4, 5, -4
; CHECK-NEXT:    li 5, -7
; CHECK-NEXT:    .p2align 4
; CHECK-NEXT:  .LBB8_2: # %for.body
; CHECK-NEXT:    #
; CHECK-NEXT:    stdu 5, 8(3)
; CHECK-NEXT:    stwu 5, 4(4)
; CHECK-NEXT:    bdnz .LBB8_2
; CHECK-NEXT:  # %bb.3: # %for.cond.cleanup
; CHECK-NEXT:    blr
entry:
  %cmp7 = icmp sgt i32 %Len, 0
  br i1 %cmp7, label %for.body.lr.ph, label %for.cond.cleanup

for.body.lr.ph:                                   ; preds = %entry
  %0 = load ptr, ptr @arr, align 8
  %1 = load ptr, ptr @arri, align 8
  %wide.trip.count = zext i32 %Len to i64
  br label %for.body

for.cond.cleanup:                                 ; preds = %for.body, %entry
  ret void

for.body:                                         ; preds = %for.body, %for.body.lr.ph
  %indvars.iv = phi i64 [ 0, %for.body.lr.ph ], [ %indvars.iv.next, %for.body ]
  %arrayidx = getelementptr inbounds i64, ptr %0, i64 %indvars.iv
  store i64 -7, ptr %arrayidx, align 8
  %arrayidx2 = getelementptr inbounds i32, ptr %1, i64 %indvars.iv
  store i32 -7, ptr %arrayidx2, align 4
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 1
  %exitcond = icmp eq i64 %indvars.iv.next, %wide.trip.count
  br i1 %exitcond, label %for.cond.cleanup, label %for.body
}

define void @setSameValDiffSizeCI() {
; CHECK-LABEL: setSameValDiffSizeCI:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis 3, 2, .LC2@toc@ha
; CHECK-NEXT:    addis 4, 2, .LC0@toc@ha
; CHECK-NEXT:    li 5, 255
; CHECK-NEXT:    ld 3, .LC2@toc@l(3)
; CHECK-NEXT:    ld 4, .LC0@toc@l(4)
; CHECK-NEXT:    stw 5, 0(3)
; CHECK-NEXT:    stb 5, 0(4)
; CHECK-NEXT:    blr
entry:
  store i32 255, ptr @IVal, align 4
  store i8 -1, ptr @CVal, align 1
  ret void
}

define void @setSameValDiffSizeSI() {
; CHECK-LABEL: setSameValDiffSizeSI:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis 3, 2, .LC2@toc@ha
; CHECK-NEXT:    addis 4, 2, .LC1@toc@ha
; CHECK-NEXT:    li 5, 0
; CHECK-NEXT:    ld 3, .LC2@toc@l(3)
; CHECK-NEXT:    ld 4, .LC1@toc@l(4)
; CHECK-NEXT:    ori 5, 5, 65535
; CHECK-NEXT:    stw 5, 0(3)
; CHECK-NEXT:    sth 5, 0(4)
; CHECK-NEXT:    blr
entry:
  store i32 65535, ptr @IVal, align 4
  store i16 -1, ptr @SVal, align 2
  ret void
}
