# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -march=aarch64 -mcpu=exynos-m3 -resource-pressure=false < %s | FileCheck %s -check-prefixes=ALL,M3
# RUN: llvm-mca -march=aarch64 -mcpu=exynos-m4 -resource-pressure=false < %s | FileCheck %s -check-prefixes=ALL,M4
# RUN: llvm-mca -march=aarch64 -mcpu=exynos-m5 -resource-pressure=false < %s | FileCheck %s -check-prefixes=ALL,M5

fsqrt	d30, d30
fmov	d31, #1.00000000
fdiv	d30, d31, d30

# Newton series for 1 / sqrt().
frsqrte	d1, d0
fmul	d2, d1, d1
frsqrts	d2, d0, d2
fmul	d1, d1, d2
fmul	d2, d1, d1
frsqrts	d2, d0, d2
fmul	d1, d1, d2
fmul	d2, d1, d1
frsqrts	d0, d0, d2
fmul	d0, d1, d0

# ALL:      Iterations:        100
# ALL-NEXT: Instructions:      1300

# M3-NEXT:  Total Cycles:      3703
# M4-NEXT:  Total Cycles:      3303
# M5-NEXT:  Total Cycles:      3303

# ALL-NEXT: Total uOps:        1300

# ALL:      Dispatch Width:    6

# M3-NEXT:  uOps Per Cycle:    0.35
# M3-NEXT:  IPC:               0.35
# M3-NEXT:  Block RThroughput: 26.0

# M4-NEXT:  uOps Per Cycle:    0.39
# M4-NEXT:  IPC:               0.39
# M4-NEXT:  Block RThroughput: 3.0

# M5-NEXT:  uOps Per Cycle:    0.39
# M5-NEXT:  IPC:               0.39
# M5-NEXT:  Block RThroughput: 3.0

# ALL:      Instruction Info:
# ALL-NEXT: [1]: #uOps
# ALL-NEXT: [2]: Latency
# ALL-NEXT: [3]: RThroughput
# ALL-NEXT: [4]: MayLoad
# ALL-NEXT: [5]: MayStore
# ALL-NEXT: [6]: HasSideEffects (U)

# ALL:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:

# M3-NEXT:   1      25    26.00                       fsqrt	d30, d30
# M4-NEXT:   1      12    2.25                        fsqrt	d30, d30
# M5-NEXT:   1      12    2.25                        fsqrt	d30, d30

# ALL-NEXT:  1      1     0.33                        fmov	d31, #1.00000000

# M3-NEXT:   1      12    3.25                        fdiv	d30, d31, d30
# M3-NEXT:   1      4     0.50                        frsqrte	d1, d0

# M4-NEXT:   1      12    2.25                        fdiv	d30, d31, d30
# M4-NEXT:   1      3     0.50                        frsqrte	d1, d0

# M5-NEXT:   1      12    2.25                        fdiv	d30, d31, d30
# M5-NEXT:   1      3     0.50                        frsqrte	d1, d0

# ALL-NEXT:  1      3     0.33                        fmul	d2, d1, d1
# ALL-NEXT:  1      4     0.33                        frsqrts	d2, d0, d2
# ALL-NEXT:  1      3     0.33                        fmul	d1, d1, d2
# ALL-NEXT:  1      3     0.33                        fmul	d2, d1, d1
# ALL-NEXT:  1      4     0.33                        frsqrts	d2, d0, d2
# ALL-NEXT:  1      3     0.33                        fmul	d1, d1, d2
# ALL-NEXT:  1      3     0.33                        fmul	d2, d1, d1
# ALL-NEXT:  1      4     0.33                        frsqrts	d0, d0, d2
# ALL-NEXT:  1      3     0.33                        fmul	d0, d1, d0
