/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"reflect"
)


// PulpAnsibleApiV3CollectionsAllAPIService PulpAnsibleApiV3CollectionsAllAPI service
type PulpAnsibleApiV3CollectionsAllAPIService service

type PulpAnsibleApiV3CollectionsAllAPIPulpAnsibleGalaxyApiV3CollectionsAllListRequest struct {
	ctx context.Context
	ApiService *PulpAnsibleApiV3CollectionsAllAPIService
	path string
	deprecated *bool
	name *string
	namespace *string
	ordering *[]string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	fields *[]string
	excludeFields *[]string
}

func (r PulpAnsibleApiV3CollectionsAllAPIPulpAnsibleGalaxyApiV3CollectionsAllListRequest) Deprecated(deprecated bool) PulpAnsibleApiV3CollectionsAllAPIPulpAnsibleGalaxyApiV3CollectionsAllListRequest {
	r.deprecated = &deprecated
	return r
}

func (r PulpAnsibleApiV3CollectionsAllAPIPulpAnsibleGalaxyApiV3CollectionsAllListRequest) Name(name string) PulpAnsibleApiV3CollectionsAllAPIPulpAnsibleGalaxyApiV3CollectionsAllListRequest {
	r.name = &name
	return r
}

func (r PulpAnsibleApiV3CollectionsAllAPIPulpAnsibleGalaxyApiV3CollectionsAllListRequest) Namespace(namespace string) PulpAnsibleApiV3CollectionsAllAPIPulpAnsibleGalaxyApiV3CollectionsAllListRequest {
	r.namespace = &namespace
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;namespace&#x60; - Namespace * &#x60;-namespace&#x60; - Namespace (descending) * &#x60;name&#x60; - Name * &#x60;-name&#x60; - Name (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r PulpAnsibleApiV3CollectionsAllAPIPulpAnsibleGalaxyApiV3CollectionsAllListRequest) Ordering(ordering []string) PulpAnsibleApiV3CollectionsAllAPIPulpAnsibleGalaxyApiV3CollectionsAllListRequest {
	r.ordering = &ordering
	return r
}

// Multiple values may be separated by commas.
func (r PulpAnsibleApiV3CollectionsAllAPIPulpAnsibleGalaxyApiV3CollectionsAllListRequest) PulpHrefIn(pulpHrefIn []string) PulpAnsibleApiV3CollectionsAllAPIPulpAnsibleGalaxyApiV3CollectionsAllListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r PulpAnsibleApiV3CollectionsAllAPIPulpAnsibleGalaxyApiV3CollectionsAllListRequest) PulpIdIn(pulpIdIn []string) PulpAnsibleApiV3CollectionsAllAPIPulpAnsibleGalaxyApiV3CollectionsAllListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// A list of fields to include in the response.
func (r PulpAnsibleApiV3CollectionsAllAPIPulpAnsibleGalaxyApiV3CollectionsAllListRequest) Fields(fields []string) PulpAnsibleApiV3CollectionsAllAPIPulpAnsibleGalaxyApiV3CollectionsAllListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r PulpAnsibleApiV3CollectionsAllAPIPulpAnsibleGalaxyApiV3CollectionsAllListRequest) ExcludeFields(excludeFields []string) PulpAnsibleApiV3CollectionsAllAPIPulpAnsibleGalaxyApiV3CollectionsAllListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r PulpAnsibleApiV3CollectionsAllAPIPulpAnsibleGalaxyApiV3CollectionsAllListRequest) Execute() ([]CollectionResponse, *http.Response, error) {
	return r.ApiService.PulpAnsibleGalaxyApiV3CollectionsAllListExecute(r)
}

/*
PulpAnsibleGalaxyApiV3CollectionsAllList Method for PulpAnsibleGalaxyApiV3CollectionsAllList

Legacy v3 endpoint.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param path
 @return PulpAnsibleApiV3CollectionsAllAPIPulpAnsibleGalaxyApiV3CollectionsAllListRequest

Deprecated
*/
func (a *PulpAnsibleApiV3CollectionsAllAPIService) PulpAnsibleGalaxyApiV3CollectionsAllList(ctx context.Context, path string) PulpAnsibleApiV3CollectionsAllAPIPulpAnsibleGalaxyApiV3CollectionsAllListRequest {
	return PulpAnsibleApiV3CollectionsAllAPIPulpAnsibleGalaxyApiV3CollectionsAllListRequest{
		ApiService: a,
		ctx: ctx,
		path: path,
	}
}

// Execute executes the request
//  @return []CollectionResponse
// Deprecated
func (a *PulpAnsibleApiV3CollectionsAllAPIService) PulpAnsibleGalaxyApiV3CollectionsAllListExecute(r PulpAnsibleApiV3CollectionsAllAPIPulpAnsibleGalaxyApiV3CollectionsAllListRequest) ([]CollectionResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  []CollectionResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PulpAnsibleApiV3CollectionsAllAPIService.PulpAnsibleGalaxyApiV3CollectionsAllList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp_ansible/galaxy/{path}/api/v3/collections/all/"
	localVarPath = strings.Replace(localVarPath, "{"+"path"+"}", parameterValueToString(r.path, "path"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.deprecated != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "deprecated", r.deprecated, "")
	}
	if r.name != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name", r.name, "")
	}
	if r.namespace != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "namespace", r.namespace, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
