/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
)

// checks if the ContentSummaryResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &ContentSummaryResponse{}

// ContentSummaryResponse Serializer for the RepositoryVersion content summary
type ContentSummaryResponse struct {
	Added map[string]map[string]interface{} `json:"added"`
	Removed map[string]map[string]interface{} `json:"removed"`
	Present map[string]map[string]interface{} `json:"present"`
	AdditionalProperties map[string]interface{}
}

type _ContentSummaryResponse ContentSummaryResponse

// NewContentSummaryResponse instantiates a new ContentSummaryResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewContentSummaryResponse(added map[string]map[string]interface{}, removed map[string]map[string]interface{}, present map[string]map[string]interface{}) *ContentSummaryResponse {
	this := ContentSummaryResponse{}
	this.Added = added
	this.Removed = removed
	this.Present = present
	return &this
}

// NewContentSummaryResponseWithDefaults instantiates a new ContentSummaryResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewContentSummaryResponseWithDefaults() *ContentSummaryResponse {
	this := ContentSummaryResponse{}
	return &this
}

// GetAdded returns the Added field value
func (o *ContentSummaryResponse) GetAdded() map[string]map[string]interface{} {
	if o == nil {
		var ret map[string]map[string]interface{}
		return ret
	}

	return o.Added
}

// GetAddedOk returns a tuple with the Added field value
// and a boolean to check if the value has been set.
func (o *ContentSummaryResponse) GetAddedOk() (map[string]map[string]interface{}, bool) {
	if o == nil {
		return map[string]map[string]interface{}{}, false
	}
	return o.Added, true
}

// SetAdded sets field value
func (o *ContentSummaryResponse) SetAdded(v map[string]map[string]interface{}) {
	o.Added = v
}

// GetRemoved returns the Removed field value
func (o *ContentSummaryResponse) GetRemoved() map[string]map[string]interface{} {
	if o == nil {
		var ret map[string]map[string]interface{}
		return ret
	}

	return o.Removed
}

// GetRemovedOk returns a tuple with the Removed field value
// and a boolean to check if the value has been set.
func (o *ContentSummaryResponse) GetRemovedOk() (map[string]map[string]interface{}, bool) {
	if o == nil {
		return map[string]map[string]interface{}{}, false
	}
	return o.Removed, true
}

// SetRemoved sets field value
func (o *ContentSummaryResponse) SetRemoved(v map[string]map[string]interface{}) {
	o.Removed = v
}

// GetPresent returns the Present field value
func (o *ContentSummaryResponse) GetPresent() map[string]map[string]interface{} {
	if o == nil {
		var ret map[string]map[string]interface{}
		return ret
	}

	return o.Present
}

// GetPresentOk returns a tuple with the Present field value
// and a boolean to check if the value has been set.
func (o *ContentSummaryResponse) GetPresentOk() (map[string]map[string]interface{}, bool) {
	if o == nil {
		return map[string]map[string]interface{}{}, false
	}
	return o.Present, true
}

// SetPresent sets field value
func (o *ContentSummaryResponse) SetPresent(v map[string]map[string]interface{}) {
	o.Present = v
}

func (o ContentSummaryResponse) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o ContentSummaryResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["added"] = o.Added
	toSerialize["removed"] = o.Removed
	toSerialize["present"] = o.Present

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *ContentSummaryResponse) UnmarshalJSON(bytes []byte) (err error) {
	varContentSummaryResponse := _ContentSummaryResponse{}

	if err = json.Unmarshal(bytes, &varContentSummaryResponse); err == nil {
		*o = ContentSummaryResponse(varContentSummaryResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "added")
		delete(additionalProperties, "removed")
		delete(additionalProperties, "present")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableContentSummaryResponse struct {
	value *ContentSummaryResponse
	isSet bool
}

func (v NullableContentSummaryResponse) Get() *ContentSummaryResponse {
	return v.value
}

func (v *NullableContentSummaryResponse) Set(val *ContentSummaryResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableContentSummaryResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableContentSummaryResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableContentSummaryResponse(val *ContentSummaryResponse) *NullableContentSummaryResponse {
	return &NullableContentSummaryResponse{value: val, isSet: true}
}

func (v NullableContentSummaryResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableContentSummaryResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


