/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
	"os"
)

// checks if the PythonPythonPackageContent type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &PythonPythonPackageContent{}

// PythonPythonPackageContent A Serializer for PythonPackageContent.
type PythonPythonPackageContent struct {
	// A URI of a repository the new content unit should be associated with.
	Repository *string `json:"repository,omitempty"`
	// Artifact file representing the physical content
	Artifact *string `json:"artifact,omitempty"`
	// Path where the artifact is located relative to distributions base_path
	RelativePath string `json:"relative_path"`
	// An uploaded file that may be turned into the artifact of the content unit.
	File **os.File `json:"file,omitempty"`
	// An uncommitted upload that may be turned into the artifact of the content unit.
	Upload *string `json:"upload,omitempty"`
	// The SHA256 digest of this package.
	Sha256 *string `json:"sha256,omitempty"`
	// A one-line summary of what the package does.
	Summary *string `json:"summary,omitempty"`
	// A longer description of the package that can run to several paragraphs.
	Description *string `json:"description,omitempty"`
	// A string stating the markup syntax (if any) used in the distribution’s description, so that tools can intelligently render the description.
	DescriptionContentType *string `json:"description_content_type,omitempty"`
	// Additional keywords to be used to assist searching for the package in a larger catalog.
	Keywords *string `json:"keywords,omitempty"`
	// The URL for the package's home page.
	HomePage *string `json:"home_page,omitempty"`
	// Legacy field denoting the URL from which this package can be downloaded.
	DownloadUrl *string `json:"download_url,omitempty"`
	// Text containing the author's name. Contact information can also be added, separated with newlines.
	Author *string `json:"author,omitempty"`
	// The author's e-mail address. 
	AuthorEmail *string `json:"author_email,omitempty"`
	// The maintainer's name at a minimum; additional contact information may be provided.
	Maintainer *string `json:"maintainer,omitempty"`
	// The maintainer's e-mail address.
	MaintainerEmail *string `json:"maintainer_email,omitempty"`
	// Text indicating the license covering the distribution
	License *string `json:"license,omitempty"`
	// The Python version(s) that the distribution is guaranteed to be compatible with.
	RequiresPython *string `json:"requires_python,omitempty"`
	// A browsable URL for the project and a label for it, separated by a comma.
	ProjectUrl *string `json:"project_url,omitempty"`
	// A dictionary of labels and URLs for the project.
	ProjectUrls map[string]interface{} `json:"project_urls,omitempty"`
	// A comma-separated list of platform specifications, summarizing the operating systems supported by the package.
	Platform *string `json:"platform,omitempty"`
	// Field to specify the OS and CPU for which the binary package was compiled. 
	SupportedPlatform *string `json:"supported_platform,omitempty"`
	// A JSON list containing names of some other distutils project required by this distribution.
	RequiresDist map[string]interface{} `json:"requires_dist,omitempty"`
	// A JSON list containing names of a Distutils project which is contained within this distribution.
	ProvidesDist map[string]interface{} `json:"provides_dist,omitempty"`
	// A JSON list containing names of a distutils project's distribution which this distribution renders obsolete, meaning that the two projects should not be installed at the same time.
	ObsoletesDist map[string]interface{} `json:"obsoletes_dist,omitempty"`
	// A JSON list containing some dependency in the system that the distribution is to be used.
	RequiresExternal map[string]interface{} `json:"requires_external,omitempty"`
	// A JSON list containing classification values for a Python package.
	Classifiers map[string]interface{} `json:"classifiers,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _PythonPythonPackageContent PythonPythonPackageContent

// NewPythonPythonPackageContent instantiates a new PythonPythonPackageContent object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewPythonPythonPackageContent(relativePath string) *PythonPythonPackageContent {
	this := PythonPythonPackageContent{}
	this.RelativePath = relativePath
	var sha256 string = ""
	this.Sha256 = &sha256
	return &this
}

// NewPythonPythonPackageContentWithDefaults instantiates a new PythonPythonPackageContent object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewPythonPythonPackageContentWithDefaults() *PythonPythonPackageContent {
	this := PythonPythonPackageContent{}
	var sha256 string = ""
	this.Sha256 = &sha256
	return &this
}

// GetRepository returns the Repository field value if set, zero value otherwise.
func (o *PythonPythonPackageContent) GetRepository() string {
	if o == nil || IsNil(o.Repository) {
		var ret string
		return ret
	}
	return *o.Repository
}

// GetRepositoryOk returns a tuple with the Repository field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContent) GetRepositoryOk() (*string, bool) {
	if o == nil || IsNil(o.Repository) {
		return nil, false
	}
	return o.Repository, true
}

// HasRepository returns a boolean if a field has been set.
func (o *PythonPythonPackageContent) HasRepository() bool {
	if o != nil && !IsNil(o.Repository) {
		return true
	}

	return false
}

// SetRepository gets a reference to the given string and assigns it to the Repository field.
func (o *PythonPythonPackageContent) SetRepository(v string) {
	o.Repository = &v
}

// GetArtifact returns the Artifact field value if set, zero value otherwise.
func (o *PythonPythonPackageContent) GetArtifact() string {
	if o == nil || IsNil(o.Artifact) {
		var ret string
		return ret
	}
	return *o.Artifact
}

// GetArtifactOk returns a tuple with the Artifact field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContent) GetArtifactOk() (*string, bool) {
	if o == nil || IsNil(o.Artifact) {
		return nil, false
	}
	return o.Artifact, true
}

// HasArtifact returns a boolean if a field has been set.
func (o *PythonPythonPackageContent) HasArtifact() bool {
	if o != nil && !IsNil(o.Artifact) {
		return true
	}

	return false
}

// SetArtifact gets a reference to the given string and assigns it to the Artifact field.
func (o *PythonPythonPackageContent) SetArtifact(v string) {
	o.Artifact = &v
}

// GetRelativePath returns the RelativePath field value
func (o *PythonPythonPackageContent) GetRelativePath() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.RelativePath
}

// GetRelativePathOk returns a tuple with the RelativePath field value
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContent) GetRelativePathOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.RelativePath, true
}

// SetRelativePath sets field value
func (o *PythonPythonPackageContent) SetRelativePath(v string) {
	o.RelativePath = v
}

// GetFile returns the File field value if set, zero value otherwise.
func (o *PythonPythonPackageContent) GetFile() *os.File {
	if o == nil || IsNil(o.File) {
		var ret *os.File
		return ret
	}
	return *o.File
}

// GetFileOk returns a tuple with the File field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContent) GetFileOk() (**os.File, bool) {
	if o == nil || IsNil(o.File) {
		return nil, false
	}
	return o.File, true
}

// HasFile returns a boolean if a field has been set.
func (o *PythonPythonPackageContent) HasFile() bool {
	if o != nil && !IsNil(o.File) {
		return true
	}

	return false
}

// SetFile gets a reference to the given *os.File and assigns it to the File field.
func (o *PythonPythonPackageContent) SetFile(v *os.File) {
	o.File = &v
}

// GetUpload returns the Upload field value if set, zero value otherwise.
func (o *PythonPythonPackageContent) GetUpload() string {
	if o == nil || IsNil(o.Upload) {
		var ret string
		return ret
	}
	return *o.Upload
}

// GetUploadOk returns a tuple with the Upload field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContent) GetUploadOk() (*string, bool) {
	if o == nil || IsNil(o.Upload) {
		return nil, false
	}
	return o.Upload, true
}

// HasUpload returns a boolean if a field has been set.
func (o *PythonPythonPackageContent) HasUpload() bool {
	if o != nil && !IsNil(o.Upload) {
		return true
	}

	return false
}

// SetUpload gets a reference to the given string and assigns it to the Upload field.
func (o *PythonPythonPackageContent) SetUpload(v string) {
	o.Upload = &v
}

// GetSha256 returns the Sha256 field value if set, zero value otherwise.
func (o *PythonPythonPackageContent) GetSha256() string {
	if o == nil || IsNil(o.Sha256) {
		var ret string
		return ret
	}
	return *o.Sha256
}

// GetSha256Ok returns a tuple with the Sha256 field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContent) GetSha256Ok() (*string, bool) {
	if o == nil || IsNil(o.Sha256) {
		return nil, false
	}
	return o.Sha256, true
}

// HasSha256 returns a boolean if a field has been set.
func (o *PythonPythonPackageContent) HasSha256() bool {
	if o != nil && !IsNil(o.Sha256) {
		return true
	}

	return false
}

// SetSha256 gets a reference to the given string and assigns it to the Sha256 field.
func (o *PythonPythonPackageContent) SetSha256(v string) {
	o.Sha256 = &v
}

// GetSummary returns the Summary field value if set, zero value otherwise.
func (o *PythonPythonPackageContent) GetSummary() string {
	if o == nil || IsNil(o.Summary) {
		var ret string
		return ret
	}
	return *o.Summary
}

// GetSummaryOk returns a tuple with the Summary field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContent) GetSummaryOk() (*string, bool) {
	if o == nil || IsNil(o.Summary) {
		return nil, false
	}
	return o.Summary, true
}

// HasSummary returns a boolean if a field has been set.
func (o *PythonPythonPackageContent) HasSummary() bool {
	if o != nil && !IsNil(o.Summary) {
		return true
	}

	return false
}

// SetSummary gets a reference to the given string and assigns it to the Summary field.
func (o *PythonPythonPackageContent) SetSummary(v string) {
	o.Summary = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *PythonPythonPackageContent) GetDescription() string {
	if o == nil || IsNil(o.Description) {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContent) GetDescriptionOk() (*string, bool) {
	if o == nil || IsNil(o.Description) {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *PythonPythonPackageContent) HasDescription() bool {
	if o != nil && !IsNil(o.Description) {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *PythonPythonPackageContent) SetDescription(v string) {
	o.Description = &v
}

// GetDescriptionContentType returns the DescriptionContentType field value if set, zero value otherwise.
func (o *PythonPythonPackageContent) GetDescriptionContentType() string {
	if o == nil || IsNil(o.DescriptionContentType) {
		var ret string
		return ret
	}
	return *o.DescriptionContentType
}

// GetDescriptionContentTypeOk returns a tuple with the DescriptionContentType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContent) GetDescriptionContentTypeOk() (*string, bool) {
	if o == nil || IsNil(o.DescriptionContentType) {
		return nil, false
	}
	return o.DescriptionContentType, true
}

// HasDescriptionContentType returns a boolean if a field has been set.
func (o *PythonPythonPackageContent) HasDescriptionContentType() bool {
	if o != nil && !IsNil(o.DescriptionContentType) {
		return true
	}

	return false
}

// SetDescriptionContentType gets a reference to the given string and assigns it to the DescriptionContentType field.
func (o *PythonPythonPackageContent) SetDescriptionContentType(v string) {
	o.DescriptionContentType = &v
}

// GetKeywords returns the Keywords field value if set, zero value otherwise.
func (o *PythonPythonPackageContent) GetKeywords() string {
	if o == nil || IsNil(o.Keywords) {
		var ret string
		return ret
	}
	return *o.Keywords
}

// GetKeywordsOk returns a tuple with the Keywords field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContent) GetKeywordsOk() (*string, bool) {
	if o == nil || IsNil(o.Keywords) {
		return nil, false
	}
	return o.Keywords, true
}

// HasKeywords returns a boolean if a field has been set.
func (o *PythonPythonPackageContent) HasKeywords() bool {
	if o != nil && !IsNil(o.Keywords) {
		return true
	}

	return false
}

// SetKeywords gets a reference to the given string and assigns it to the Keywords field.
func (o *PythonPythonPackageContent) SetKeywords(v string) {
	o.Keywords = &v
}

// GetHomePage returns the HomePage field value if set, zero value otherwise.
func (o *PythonPythonPackageContent) GetHomePage() string {
	if o == nil || IsNil(o.HomePage) {
		var ret string
		return ret
	}
	return *o.HomePage
}

// GetHomePageOk returns a tuple with the HomePage field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContent) GetHomePageOk() (*string, bool) {
	if o == nil || IsNil(o.HomePage) {
		return nil, false
	}
	return o.HomePage, true
}

// HasHomePage returns a boolean if a field has been set.
func (o *PythonPythonPackageContent) HasHomePage() bool {
	if o != nil && !IsNil(o.HomePage) {
		return true
	}

	return false
}

// SetHomePage gets a reference to the given string and assigns it to the HomePage field.
func (o *PythonPythonPackageContent) SetHomePage(v string) {
	o.HomePage = &v
}

// GetDownloadUrl returns the DownloadUrl field value if set, zero value otherwise.
func (o *PythonPythonPackageContent) GetDownloadUrl() string {
	if o == nil || IsNil(o.DownloadUrl) {
		var ret string
		return ret
	}
	return *o.DownloadUrl
}

// GetDownloadUrlOk returns a tuple with the DownloadUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContent) GetDownloadUrlOk() (*string, bool) {
	if o == nil || IsNil(o.DownloadUrl) {
		return nil, false
	}
	return o.DownloadUrl, true
}

// HasDownloadUrl returns a boolean if a field has been set.
func (o *PythonPythonPackageContent) HasDownloadUrl() bool {
	if o != nil && !IsNil(o.DownloadUrl) {
		return true
	}

	return false
}

// SetDownloadUrl gets a reference to the given string and assigns it to the DownloadUrl field.
func (o *PythonPythonPackageContent) SetDownloadUrl(v string) {
	o.DownloadUrl = &v
}

// GetAuthor returns the Author field value if set, zero value otherwise.
func (o *PythonPythonPackageContent) GetAuthor() string {
	if o == nil || IsNil(o.Author) {
		var ret string
		return ret
	}
	return *o.Author
}

// GetAuthorOk returns a tuple with the Author field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContent) GetAuthorOk() (*string, bool) {
	if o == nil || IsNil(o.Author) {
		return nil, false
	}
	return o.Author, true
}

// HasAuthor returns a boolean if a field has been set.
func (o *PythonPythonPackageContent) HasAuthor() bool {
	if o != nil && !IsNil(o.Author) {
		return true
	}

	return false
}

// SetAuthor gets a reference to the given string and assigns it to the Author field.
func (o *PythonPythonPackageContent) SetAuthor(v string) {
	o.Author = &v
}

// GetAuthorEmail returns the AuthorEmail field value if set, zero value otherwise.
func (o *PythonPythonPackageContent) GetAuthorEmail() string {
	if o == nil || IsNil(o.AuthorEmail) {
		var ret string
		return ret
	}
	return *o.AuthorEmail
}

// GetAuthorEmailOk returns a tuple with the AuthorEmail field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContent) GetAuthorEmailOk() (*string, bool) {
	if o == nil || IsNil(o.AuthorEmail) {
		return nil, false
	}
	return o.AuthorEmail, true
}

// HasAuthorEmail returns a boolean if a field has been set.
func (o *PythonPythonPackageContent) HasAuthorEmail() bool {
	if o != nil && !IsNil(o.AuthorEmail) {
		return true
	}

	return false
}

// SetAuthorEmail gets a reference to the given string and assigns it to the AuthorEmail field.
func (o *PythonPythonPackageContent) SetAuthorEmail(v string) {
	o.AuthorEmail = &v
}

// GetMaintainer returns the Maintainer field value if set, zero value otherwise.
func (o *PythonPythonPackageContent) GetMaintainer() string {
	if o == nil || IsNil(o.Maintainer) {
		var ret string
		return ret
	}
	return *o.Maintainer
}

// GetMaintainerOk returns a tuple with the Maintainer field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContent) GetMaintainerOk() (*string, bool) {
	if o == nil || IsNil(o.Maintainer) {
		return nil, false
	}
	return o.Maintainer, true
}

// HasMaintainer returns a boolean if a field has been set.
func (o *PythonPythonPackageContent) HasMaintainer() bool {
	if o != nil && !IsNil(o.Maintainer) {
		return true
	}

	return false
}

// SetMaintainer gets a reference to the given string and assigns it to the Maintainer field.
func (o *PythonPythonPackageContent) SetMaintainer(v string) {
	o.Maintainer = &v
}

// GetMaintainerEmail returns the MaintainerEmail field value if set, zero value otherwise.
func (o *PythonPythonPackageContent) GetMaintainerEmail() string {
	if o == nil || IsNil(o.MaintainerEmail) {
		var ret string
		return ret
	}
	return *o.MaintainerEmail
}

// GetMaintainerEmailOk returns a tuple with the MaintainerEmail field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContent) GetMaintainerEmailOk() (*string, bool) {
	if o == nil || IsNil(o.MaintainerEmail) {
		return nil, false
	}
	return o.MaintainerEmail, true
}

// HasMaintainerEmail returns a boolean if a field has been set.
func (o *PythonPythonPackageContent) HasMaintainerEmail() bool {
	if o != nil && !IsNil(o.MaintainerEmail) {
		return true
	}

	return false
}

// SetMaintainerEmail gets a reference to the given string and assigns it to the MaintainerEmail field.
func (o *PythonPythonPackageContent) SetMaintainerEmail(v string) {
	o.MaintainerEmail = &v
}

// GetLicense returns the License field value if set, zero value otherwise.
func (o *PythonPythonPackageContent) GetLicense() string {
	if o == nil || IsNil(o.License) {
		var ret string
		return ret
	}
	return *o.License
}

// GetLicenseOk returns a tuple with the License field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContent) GetLicenseOk() (*string, bool) {
	if o == nil || IsNil(o.License) {
		return nil, false
	}
	return o.License, true
}

// HasLicense returns a boolean if a field has been set.
func (o *PythonPythonPackageContent) HasLicense() bool {
	if o != nil && !IsNil(o.License) {
		return true
	}

	return false
}

// SetLicense gets a reference to the given string and assigns it to the License field.
func (o *PythonPythonPackageContent) SetLicense(v string) {
	o.License = &v
}

// GetRequiresPython returns the RequiresPython field value if set, zero value otherwise.
func (o *PythonPythonPackageContent) GetRequiresPython() string {
	if o == nil || IsNil(o.RequiresPython) {
		var ret string
		return ret
	}
	return *o.RequiresPython
}

// GetRequiresPythonOk returns a tuple with the RequiresPython field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContent) GetRequiresPythonOk() (*string, bool) {
	if o == nil || IsNil(o.RequiresPython) {
		return nil, false
	}
	return o.RequiresPython, true
}

// HasRequiresPython returns a boolean if a field has been set.
func (o *PythonPythonPackageContent) HasRequiresPython() bool {
	if o != nil && !IsNil(o.RequiresPython) {
		return true
	}

	return false
}

// SetRequiresPython gets a reference to the given string and assigns it to the RequiresPython field.
func (o *PythonPythonPackageContent) SetRequiresPython(v string) {
	o.RequiresPython = &v
}

// GetProjectUrl returns the ProjectUrl field value if set, zero value otherwise.
func (o *PythonPythonPackageContent) GetProjectUrl() string {
	if o == nil || IsNil(o.ProjectUrl) {
		var ret string
		return ret
	}
	return *o.ProjectUrl
}

// GetProjectUrlOk returns a tuple with the ProjectUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContent) GetProjectUrlOk() (*string, bool) {
	if o == nil || IsNil(o.ProjectUrl) {
		return nil, false
	}
	return o.ProjectUrl, true
}

// HasProjectUrl returns a boolean if a field has been set.
func (o *PythonPythonPackageContent) HasProjectUrl() bool {
	if o != nil && !IsNil(o.ProjectUrl) {
		return true
	}

	return false
}

// SetProjectUrl gets a reference to the given string and assigns it to the ProjectUrl field.
func (o *PythonPythonPackageContent) SetProjectUrl(v string) {
	o.ProjectUrl = &v
}

// GetProjectUrls returns the ProjectUrls field value if set, zero value otherwise.
func (o *PythonPythonPackageContent) GetProjectUrls() map[string]interface{} {
	if o == nil || IsNil(o.ProjectUrls) {
		var ret map[string]interface{}
		return ret
	}
	return o.ProjectUrls
}

// GetProjectUrlsOk returns a tuple with the ProjectUrls field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContent) GetProjectUrlsOk() (map[string]interface{}, bool) {
	if o == nil || IsNil(o.ProjectUrls) {
		return map[string]interface{}{}, false
	}
	return o.ProjectUrls, true
}

// HasProjectUrls returns a boolean if a field has been set.
func (o *PythonPythonPackageContent) HasProjectUrls() bool {
	if o != nil && !IsNil(o.ProjectUrls) {
		return true
	}

	return false
}

// SetProjectUrls gets a reference to the given map[string]interface{} and assigns it to the ProjectUrls field.
func (o *PythonPythonPackageContent) SetProjectUrls(v map[string]interface{}) {
	o.ProjectUrls = v
}

// GetPlatform returns the Platform field value if set, zero value otherwise.
func (o *PythonPythonPackageContent) GetPlatform() string {
	if o == nil || IsNil(o.Platform) {
		var ret string
		return ret
	}
	return *o.Platform
}

// GetPlatformOk returns a tuple with the Platform field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContent) GetPlatformOk() (*string, bool) {
	if o == nil || IsNil(o.Platform) {
		return nil, false
	}
	return o.Platform, true
}

// HasPlatform returns a boolean if a field has been set.
func (o *PythonPythonPackageContent) HasPlatform() bool {
	if o != nil && !IsNil(o.Platform) {
		return true
	}

	return false
}

// SetPlatform gets a reference to the given string and assigns it to the Platform field.
func (o *PythonPythonPackageContent) SetPlatform(v string) {
	o.Platform = &v
}

// GetSupportedPlatform returns the SupportedPlatform field value if set, zero value otherwise.
func (o *PythonPythonPackageContent) GetSupportedPlatform() string {
	if o == nil || IsNil(o.SupportedPlatform) {
		var ret string
		return ret
	}
	return *o.SupportedPlatform
}

// GetSupportedPlatformOk returns a tuple with the SupportedPlatform field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContent) GetSupportedPlatformOk() (*string, bool) {
	if o == nil || IsNil(o.SupportedPlatform) {
		return nil, false
	}
	return o.SupportedPlatform, true
}

// HasSupportedPlatform returns a boolean if a field has been set.
func (o *PythonPythonPackageContent) HasSupportedPlatform() bool {
	if o != nil && !IsNil(o.SupportedPlatform) {
		return true
	}

	return false
}

// SetSupportedPlatform gets a reference to the given string and assigns it to the SupportedPlatform field.
func (o *PythonPythonPackageContent) SetSupportedPlatform(v string) {
	o.SupportedPlatform = &v
}

// GetRequiresDist returns the RequiresDist field value if set, zero value otherwise.
func (o *PythonPythonPackageContent) GetRequiresDist() map[string]interface{} {
	if o == nil || IsNil(o.RequiresDist) {
		var ret map[string]interface{}
		return ret
	}
	return o.RequiresDist
}

// GetRequiresDistOk returns a tuple with the RequiresDist field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContent) GetRequiresDistOk() (map[string]interface{}, bool) {
	if o == nil || IsNil(o.RequiresDist) {
		return map[string]interface{}{}, false
	}
	return o.RequiresDist, true
}

// HasRequiresDist returns a boolean if a field has been set.
func (o *PythonPythonPackageContent) HasRequiresDist() bool {
	if o != nil && !IsNil(o.RequiresDist) {
		return true
	}

	return false
}

// SetRequiresDist gets a reference to the given map[string]interface{} and assigns it to the RequiresDist field.
func (o *PythonPythonPackageContent) SetRequiresDist(v map[string]interface{}) {
	o.RequiresDist = v
}

// GetProvidesDist returns the ProvidesDist field value if set, zero value otherwise.
func (o *PythonPythonPackageContent) GetProvidesDist() map[string]interface{} {
	if o == nil || IsNil(o.ProvidesDist) {
		var ret map[string]interface{}
		return ret
	}
	return o.ProvidesDist
}

// GetProvidesDistOk returns a tuple with the ProvidesDist field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContent) GetProvidesDistOk() (map[string]interface{}, bool) {
	if o == nil || IsNil(o.ProvidesDist) {
		return map[string]interface{}{}, false
	}
	return o.ProvidesDist, true
}

// HasProvidesDist returns a boolean if a field has been set.
func (o *PythonPythonPackageContent) HasProvidesDist() bool {
	if o != nil && !IsNil(o.ProvidesDist) {
		return true
	}

	return false
}

// SetProvidesDist gets a reference to the given map[string]interface{} and assigns it to the ProvidesDist field.
func (o *PythonPythonPackageContent) SetProvidesDist(v map[string]interface{}) {
	o.ProvidesDist = v
}

// GetObsoletesDist returns the ObsoletesDist field value if set, zero value otherwise.
func (o *PythonPythonPackageContent) GetObsoletesDist() map[string]interface{} {
	if o == nil || IsNil(o.ObsoletesDist) {
		var ret map[string]interface{}
		return ret
	}
	return o.ObsoletesDist
}

// GetObsoletesDistOk returns a tuple with the ObsoletesDist field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContent) GetObsoletesDistOk() (map[string]interface{}, bool) {
	if o == nil || IsNil(o.ObsoletesDist) {
		return map[string]interface{}{}, false
	}
	return o.ObsoletesDist, true
}

// HasObsoletesDist returns a boolean if a field has been set.
func (o *PythonPythonPackageContent) HasObsoletesDist() bool {
	if o != nil && !IsNil(o.ObsoletesDist) {
		return true
	}

	return false
}

// SetObsoletesDist gets a reference to the given map[string]interface{} and assigns it to the ObsoletesDist field.
func (o *PythonPythonPackageContent) SetObsoletesDist(v map[string]interface{}) {
	o.ObsoletesDist = v
}

// GetRequiresExternal returns the RequiresExternal field value if set, zero value otherwise.
func (o *PythonPythonPackageContent) GetRequiresExternal() map[string]interface{} {
	if o == nil || IsNil(o.RequiresExternal) {
		var ret map[string]interface{}
		return ret
	}
	return o.RequiresExternal
}

// GetRequiresExternalOk returns a tuple with the RequiresExternal field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContent) GetRequiresExternalOk() (map[string]interface{}, bool) {
	if o == nil || IsNil(o.RequiresExternal) {
		return map[string]interface{}{}, false
	}
	return o.RequiresExternal, true
}

// HasRequiresExternal returns a boolean if a field has been set.
func (o *PythonPythonPackageContent) HasRequiresExternal() bool {
	if o != nil && !IsNil(o.RequiresExternal) {
		return true
	}

	return false
}

// SetRequiresExternal gets a reference to the given map[string]interface{} and assigns it to the RequiresExternal field.
func (o *PythonPythonPackageContent) SetRequiresExternal(v map[string]interface{}) {
	o.RequiresExternal = v
}

// GetClassifiers returns the Classifiers field value if set, zero value otherwise.
func (o *PythonPythonPackageContent) GetClassifiers() map[string]interface{} {
	if o == nil || IsNil(o.Classifiers) {
		var ret map[string]interface{}
		return ret
	}
	return o.Classifiers
}

// GetClassifiersOk returns a tuple with the Classifiers field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContent) GetClassifiersOk() (map[string]interface{}, bool) {
	if o == nil || IsNil(o.Classifiers) {
		return map[string]interface{}{}, false
	}
	return o.Classifiers, true
}

// HasClassifiers returns a boolean if a field has been set.
func (o *PythonPythonPackageContent) HasClassifiers() bool {
	if o != nil && !IsNil(o.Classifiers) {
		return true
	}

	return false
}

// SetClassifiers gets a reference to the given map[string]interface{} and assigns it to the Classifiers field.
func (o *PythonPythonPackageContent) SetClassifiers(v map[string]interface{}) {
	o.Classifiers = v
}

func (o PythonPythonPackageContent) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o PythonPythonPackageContent) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.Repository) {
		toSerialize["repository"] = o.Repository
	}
	if !IsNil(o.Artifact) {
		toSerialize["artifact"] = o.Artifact
	}
	toSerialize["relative_path"] = o.RelativePath
	if !IsNil(o.File) {
		toSerialize["file"] = o.File
	}
	if !IsNil(o.Upload) {
		toSerialize["upload"] = o.Upload
	}
	if !IsNil(o.Sha256) {
		toSerialize["sha256"] = o.Sha256
	}
	if !IsNil(o.Summary) {
		toSerialize["summary"] = o.Summary
	}
	if !IsNil(o.Description) {
		toSerialize["description"] = o.Description
	}
	if !IsNil(o.DescriptionContentType) {
		toSerialize["description_content_type"] = o.DescriptionContentType
	}
	if !IsNil(o.Keywords) {
		toSerialize["keywords"] = o.Keywords
	}
	if !IsNil(o.HomePage) {
		toSerialize["home_page"] = o.HomePage
	}
	if !IsNil(o.DownloadUrl) {
		toSerialize["download_url"] = o.DownloadUrl
	}
	if !IsNil(o.Author) {
		toSerialize["author"] = o.Author
	}
	if !IsNil(o.AuthorEmail) {
		toSerialize["author_email"] = o.AuthorEmail
	}
	if !IsNil(o.Maintainer) {
		toSerialize["maintainer"] = o.Maintainer
	}
	if !IsNil(o.MaintainerEmail) {
		toSerialize["maintainer_email"] = o.MaintainerEmail
	}
	if !IsNil(o.License) {
		toSerialize["license"] = o.License
	}
	if !IsNil(o.RequiresPython) {
		toSerialize["requires_python"] = o.RequiresPython
	}
	if !IsNil(o.ProjectUrl) {
		toSerialize["project_url"] = o.ProjectUrl
	}
	if !IsNil(o.ProjectUrls) {
		toSerialize["project_urls"] = o.ProjectUrls
	}
	if !IsNil(o.Platform) {
		toSerialize["platform"] = o.Platform
	}
	if !IsNil(o.SupportedPlatform) {
		toSerialize["supported_platform"] = o.SupportedPlatform
	}
	if !IsNil(o.RequiresDist) {
		toSerialize["requires_dist"] = o.RequiresDist
	}
	if !IsNil(o.ProvidesDist) {
		toSerialize["provides_dist"] = o.ProvidesDist
	}
	if !IsNil(o.ObsoletesDist) {
		toSerialize["obsoletes_dist"] = o.ObsoletesDist
	}
	if !IsNil(o.RequiresExternal) {
		toSerialize["requires_external"] = o.RequiresExternal
	}
	if !IsNil(o.Classifiers) {
		toSerialize["classifiers"] = o.Classifiers
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *PythonPythonPackageContent) UnmarshalJSON(bytes []byte) (err error) {
	varPythonPythonPackageContent := _PythonPythonPackageContent{}

	if err = json.Unmarshal(bytes, &varPythonPythonPackageContent); err == nil {
		*o = PythonPythonPackageContent(varPythonPythonPackageContent)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "repository")
		delete(additionalProperties, "artifact")
		delete(additionalProperties, "relative_path")
		delete(additionalProperties, "file")
		delete(additionalProperties, "upload")
		delete(additionalProperties, "sha256")
		delete(additionalProperties, "summary")
		delete(additionalProperties, "description")
		delete(additionalProperties, "description_content_type")
		delete(additionalProperties, "keywords")
		delete(additionalProperties, "home_page")
		delete(additionalProperties, "download_url")
		delete(additionalProperties, "author")
		delete(additionalProperties, "author_email")
		delete(additionalProperties, "maintainer")
		delete(additionalProperties, "maintainer_email")
		delete(additionalProperties, "license")
		delete(additionalProperties, "requires_python")
		delete(additionalProperties, "project_url")
		delete(additionalProperties, "project_urls")
		delete(additionalProperties, "platform")
		delete(additionalProperties, "supported_platform")
		delete(additionalProperties, "requires_dist")
		delete(additionalProperties, "provides_dist")
		delete(additionalProperties, "obsoletes_dist")
		delete(additionalProperties, "requires_external")
		delete(additionalProperties, "classifiers")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullablePythonPythonPackageContent struct {
	value *PythonPythonPackageContent
	isSet bool
}

func (v NullablePythonPythonPackageContent) Get() *PythonPythonPackageContent {
	return v.value
}

func (v *NullablePythonPythonPackageContent) Set(val *PythonPythonPackageContent) {
	v.value = val
	v.isSet = true
}

func (v NullablePythonPythonPackageContent) IsSet() bool {
	return v.isSet
}

func (v *NullablePythonPythonPackageContent) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullablePythonPythonPackageContent(val *PythonPythonPackageContent) *NullablePythonPythonPackageContent {
	return &NullablePythonPythonPackageContent{value: val, isSet: true}
}

func (v NullablePythonPythonPackageContent) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullablePythonPythonPackageContent) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


