/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"reflect"
)


// UpstreamPulpsAPIService UpstreamPulpsAPI service
type UpstreamPulpsAPIService service

type UpstreamPulpsAPIUpstreamPulpsCreateRequest struct {
	ctx context.Context
	ApiService *UpstreamPulpsAPIService
	upstreamPulp *UpstreamPulp
}

func (r UpstreamPulpsAPIUpstreamPulpsCreateRequest) UpstreamPulp(upstreamPulp UpstreamPulp) UpstreamPulpsAPIUpstreamPulpsCreateRequest {
	r.upstreamPulp = &upstreamPulp
	return r
}

func (r UpstreamPulpsAPIUpstreamPulpsCreateRequest) Execute() (*UpstreamPulpResponse, *http.Response, error) {
	return r.ApiService.UpstreamPulpsCreateExecute(r)
}

/*
UpstreamPulpsCreate Create an upstream pulp

API for configuring an upstream Pulp to replicate. This API is provided as a tech preview.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return UpstreamPulpsAPIUpstreamPulpsCreateRequest
*/
func (a *UpstreamPulpsAPIService) UpstreamPulpsCreate(ctx context.Context) UpstreamPulpsAPIUpstreamPulpsCreateRequest {
	return UpstreamPulpsAPIUpstreamPulpsCreateRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return UpstreamPulpResponse
func (a *UpstreamPulpsAPIService) UpstreamPulpsCreateExecute(r UpstreamPulpsAPIUpstreamPulpsCreateRequest) (*UpstreamPulpResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *UpstreamPulpResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "UpstreamPulpsAPIService.UpstreamPulpsCreate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/upstream-pulps/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.upstreamPulp == nil {
		return localVarReturnValue, nil, reportError("upstreamPulp is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.upstreamPulp
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type UpstreamPulpsAPIUpstreamPulpsDeleteRequest struct {
	ctx context.Context
	ApiService *UpstreamPulpsAPIService
	upstreamPulpHref string
}

func (r UpstreamPulpsAPIUpstreamPulpsDeleteRequest) Execute() (*http.Response, error) {
	return r.ApiService.UpstreamPulpsDeleteExecute(r)
}

/*
UpstreamPulpsDelete Delete an upstream pulp

API for configuring an upstream Pulp to replicate. This API is provided as a tech preview.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param upstreamPulpHref
 @return UpstreamPulpsAPIUpstreamPulpsDeleteRequest
*/
func (a *UpstreamPulpsAPIService) UpstreamPulpsDelete(ctx context.Context, upstreamPulpHref string) UpstreamPulpsAPIUpstreamPulpsDeleteRequest {
	return UpstreamPulpsAPIUpstreamPulpsDeleteRequest{
		ApiService: a,
		ctx: ctx,
		upstreamPulpHref: upstreamPulpHref,
	}
}

// Execute executes the request
func (a *UpstreamPulpsAPIService) UpstreamPulpsDeleteExecute(r UpstreamPulpsAPIUpstreamPulpsDeleteRequest) (*http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "UpstreamPulpsAPIService.UpstreamPulpsDelete")
	if err != nil {
		return nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{upstream_pulp_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"upstream_pulp_href"+"}", parameterValueToString(r.upstreamPulpHref, "upstreamPulpHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type UpstreamPulpsAPIUpstreamPulpsListRequest struct {
	ctx context.Context
	ApiService *UpstreamPulpsAPIService
	limit *int32
	offset *int32
	fields *[]string
	excludeFields *[]string
}

// Number of results to return per page.
func (r UpstreamPulpsAPIUpstreamPulpsListRequest) Limit(limit int32) UpstreamPulpsAPIUpstreamPulpsListRequest {
	r.limit = &limit
	return r
}

// The initial index from which to return the results.
func (r UpstreamPulpsAPIUpstreamPulpsListRequest) Offset(offset int32) UpstreamPulpsAPIUpstreamPulpsListRequest {
	r.offset = &offset
	return r
}

// A list of fields to include in the response.
func (r UpstreamPulpsAPIUpstreamPulpsListRequest) Fields(fields []string) UpstreamPulpsAPIUpstreamPulpsListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r UpstreamPulpsAPIUpstreamPulpsListRequest) ExcludeFields(excludeFields []string) UpstreamPulpsAPIUpstreamPulpsListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r UpstreamPulpsAPIUpstreamPulpsListRequest) Execute() (*PaginatedUpstreamPulpResponseList, *http.Response, error) {
	return r.ApiService.UpstreamPulpsListExecute(r)
}

/*
UpstreamPulpsList List upstream pulps

API for configuring an upstream Pulp to replicate. This API is provided as a tech preview.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return UpstreamPulpsAPIUpstreamPulpsListRequest
*/
func (a *UpstreamPulpsAPIService) UpstreamPulpsList(ctx context.Context) UpstreamPulpsAPIUpstreamPulpsListRequest {
	return UpstreamPulpsAPIUpstreamPulpsListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginatedUpstreamPulpResponseList
func (a *UpstreamPulpsAPIService) UpstreamPulpsListExecute(r UpstreamPulpsAPIUpstreamPulpsListRequest) (*PaginatedUpstreamPulpResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedUpstreamPulpResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "UpstreamPulpsAPIService.UpstreamPulpsList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/upstream-pulps/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type UpstreamPulpsAPIUpstreamPulpsPartialUpdateRequest struct {
	ctx context.Context
	ApiService *UpstreamPulpsAPIService
	upstreamPulpHref string
	patchedUpstreamPulp *PatchedUpstreamPulp
}

func (r UpstreamPulpsAPIUpstreamPulpsPartialUpdateRequest) PatchedUpstreamPulp(patchedUpstreamPulp PatchedUpstreamPulp) UpstreamPulpsAPIUpstreamPulpsPartialUpdateRequest {
	r.patchedUpstreamPulp = &patchedUpstreamPulp
	return r
}

func (r UpstreamPulpsAPIUpstreamPulpsPartialUpdateRequest) Execute() (*UpstreamPulpResponse, *http.Response, error) {
	return r.ApiService.UpstreamPulpsPartialUpdateExecute(r)
}

/*
UpstreamPulpsPartialUpdate Update an upstream pulp

API for configuring an upstream Pulp to replicate. This API is provided as a tech preview.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param upstreamPulpHref
 @return UpstreamPulpsAPIUpstreamPulpsPartialUpdateRequest
*/
func (a *UpstreamPulpsAPIService) UpstreamPulpsPartialUpdate(ctx context.Context, upstreamPulpHref string) UpstreamPulpsAPIUpstreamPulpsPartialUpdateRequest {
	return UpstreamPulpsAPIUpstreamPulpsPartialUpdateRequest{
		ApiService: a,
		ctx: ctx,
		upstreamPulpHref: upstreamPulpHref,
	}
}

// Execute executes the request
//  @return UpstreamPulpResponse
func (a *UpstreamPulpsAPIService) UpstreamPulpsPartialUpdateExecute(r UpstreamPulpsAPIUpstreamPulpsPartialUpdateRequest) (*UpstreamPulpResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPatch
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *UpstreamPulpResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "UpstreamPulpsAPIService.UpstreamPulpsPartialUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{upstream_pulp_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"upstream_pulp_href"+"}", parameterValueToString(r.upstreamPulpHref, "upstreamPulpHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.patchedUpstreamPulp == nil {
		return localVarReturnValue, nil, reportError("patchedUpstreamPulp is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.patchedUpstreamPulp
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type UpstreamPulpsAPIUpstreamPulpsReadRequest struct {
	ctx context.Context
	ApiService *UpstreamPulpsAPIService
	upstreamPulpHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r UpstreamPulpsAPIUpstreamPulpsReadRequest) Fields(fields []string) UpstreamPulpsAPIUpstreamPulpsReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r UpstreamPulpsAPIUpstreamPulpsReadRequest) ExcludeFields(excludeFields []string) UpstreamPulpsAPIUpstreamPulpsReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r UpstreamPulpsAPIUpstreamPulpsReadRequest) Execute() (*UpstreamPulpResponse, *http.Response, error) {
	return r.ApiService.UpstreamPulpsReadExecute(r)
}

/*
UpstreamPulpsRead Inspect an upstream pulp

API for configuring an upstream Pulp to replicate. This API is provided as a tech preview.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param upstreamPulpHref
 @return UpstreamPulpsAPIUpstreamPulpsReadRequest
*/
func (a *UpstreamPulpsAPIService) UpstreamPulpsRead(ctx context.Context, upstreamPulpHref string) UpstreamPulpsAPIUpstreamPulpsReadRequest {
	return UpstreamPulpsAPIUpstreamPulpsReadRequest{
		ApiService: a,
		ctx: ctx,
		upstreamPulpHref: upstreamPulpHref,
	}
}

// Execute executes the request
//  @return UpstreamPulpResponse
func (a *UpstreamPulpsAPIService) UpstreamPulpsReadExecute(r UpstreamPulpsAPIUpstreamPulpsReadRequest) (*UpstreamPulpResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *UpstreamPulpResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "UpstreamPulpsAPIService.UpstreamPulpsRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{upstream_pulp_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"upstream_pulp_href"+"}", parameterValueToString(r.upstreamPulpHref, "upstreamPulpHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type UpstreamPulpsAPIUpstreamPulpsReplicateRequest struct {
	ctx context.Context
	ApiService *UpstreamPulpsAPIService
	upstreamPulpHref string
}

func (r UpstreamPulpsAPIUpstreamPulpsReplicateRequest) Execute() (*TaskGroupOperationResponse, *http.Response, error) {
	return r.ApiService.UpstreamPulpsReplicateExecute(r)
}

/*
UpstreamPulpsReplicate Replicate

Trigger an asynchronous repository replication task group. This API is provided as a tech preview.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param upstreamPulpHref
 @return UpstreamPulpsAPIUpstreamPulpsReplicateRequest
*/
func (a *UpstreamPulpsAPIService) UpstreamPulpsReplicate(ctx context.Context, upstreamPulpHref string) UpstreamPulpsAPIUpstreamPulpsReplicateRequest {
	return UpstreamPulpsAPIUpstreamPulpsReplicateRequest{
		ApiService: a,
		ctx: ctx,
		upstreamPulpHref: upstreamPulpHref,
	}
}

// Execute executes the request
//  @return TaskGroupOperationResponse
func (a *UpstreamPulpsAPIService) UpstreamPulpsReplicateExecute(r UpstreamPulpsAPIUpstreamPulpsReplicateRequest) (*TaskGroupOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *TaskGroupOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "UpstreamPulpsAPIService.UpstreamPulpsReplicate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{upstream_pulp_href}replicate/"
	localVarPath = strings.Replace(localVarPath, "{"+"upstream_pulp_href"+"}", parameterValueToString(r.upstreamPulpHref, "upstreamPulpHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type UpstreamPulpsAPIUpstreamPulpsUpdateRequest struct {
	ctx context.Context
	ApiService *UpstreamPulpsAPIService
	upstreamPulpHref string
	upstreamPulp *UpstreamPulp
}

func (r UpstreamPulpsAPIUpstreamPulpsUpdateRequest) UpstreamPulp(upstreamPulp UpstreamPulp) UpstreamPulpsAPIUpstreamPulpsUpdateRequest {
	r.upstreamPulp = &upstreamPulp
	return r
}

func (r UpstreamPulpsAPIUpstreamPulpsUpdateRequest) Execute() (*UpstreamPulpResponse, *http.Response, error) {
	return r.ApiService.UpstreamPulpsUpdateExecute(r)
}

/*
UpstreamPulpsUpdate Update an upstream pulp

API for configuring an upstream Pulp to replicate. This API is provided as a tech preview.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param upstreamPulpHref
 @return UpstreamPulpsAPIUpstreamPulpsUpdateRequest
*/
func (a *UpstreamPulpsAPIService) UpstreamPulpsUpdate(ctx context.Context, upstreamPulpHref string) UpstreamPulpsAPIUpstreamPulpsUpdateRequest {
	return UpstreamPulpsAPIUpstreamPulpsUpdateRequest{
		ApiService: a,
		ctx: ctx,
		upstreamPulpHref: upstreamPulpHref,
	}
}

// Execute executes the request
//  @return UpstreamPulpResponse
func (a *UpstreamPulpsAPIService) UpstreamPulpsUpdateExecute(r UpstreamPulpsAPIUpstreamPulpsUpdateRequest) (*UpstreamPulpResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPut
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *UpstreamPulpResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "UpstreamPulpsAPIService.UpstreamPulpsUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{upstream_pulp_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"upstream_pulp_href"+"}", parameterValueToString(r.upstreamPulpHref, "upstreamPulpHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.upstreamPulp == nil {
		return localVarReturnValue, nil, reportError("upstreamPulp is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.upstreamPulp
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
