"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.foldMap = exports.reduce = exports.Filterable = exports.Compactable = exports.getFunctorWithIndex = exports.flap = exports.Functor = exports.getFilterableWithIndex = exports.getDifferenceMagma = exports.getIntersectionSemigroup = exports.getUnionMonoid = exports.getUnionSemigroup = exports.URI = exports.separate = exports.partitionMap = exports.partition = exports.mapWithIndex = exports.map = exports.filterMap = exports.filter = exports.compact = exports.filterWithIndex = exports.filterMapWithIndex = exports.partitionWithIndex = exports.partitionMapWithIndex = exports.fromFoldable = exports.singleton = exports.getMonoid = exports.getEq = exports.empty = exports.isSubmap = exports.lookup = exports.lookupWithKey = exports.pop = exports.modifyAt = exports.updateAt = exports.deleteAt = exports.upsertAt = exports.toUnfoldable = exports.toReadonlyArray = exports.collect = exports.values = exports.keys = exports.elem = exports.member = exports.isEmpty = exports.size = exports.getShow = exports.toMap = exports.fromMap = void 0;
exports.readonlyMap = exports.insertAt = exports.difference = exports.intersection = exports.union = exports.getWitherable = exports.getTraversableWithIndex = exports.getTraversable = exports.getFoldableWithIndex = exports.reduceRightWithIndex = exports.foldMapWithIndex = exports.reduceWithIndex = exports.getFoldable = exports.reduceRight = void 0;
var Eq_1 = require("./Eq");
var function_1 = require("./function");
var Functor_1 = require("./Functor");
var _ = __importStar(require("./internal"));
var O = __importStar(require("./Option"));
var Separated_1 = require("./Separated");
var Witherable_1 = require("./Witherable");
// -------------------------------------------------------------------------------------
// interop
// -------------------------------------------------------------------------------------
/**
 * @category interop
 * @since 2.5.0
 */
var fromMap = function (m) { return new Map(m); };
exports.fromMap = fromMap;
/**
 * @category interop
 * @since 2.5.0
 */
function toMap(m) {
    return new Map(m);
}
exports.toMap = toMap;
/**
 * @category instances
 * @since 2.5.0
 */
function getShow(SK, SA) {
    return {
        show: function (m) {
            var entries = [];
            m.forEach(function (a, k) {
                entries.push("[" + SK.show(k) + ", " + SA.show(a) + "]");
            });
            return "new Map([" + entries.sort().join(', ') + "])";
        }
    };
}
exports.getShow = getShow;
/**
 * Calculate the number of key/value pairs in a map
 *
 * @since 2.5.0
 */
var size = function (m) { return m.size; };
exports.size = size;
/**
 * Test whether or not a map is empty
 *
 * @since 2.5.0
 */
var isEmpty = function (m) { return m.size === 0; };
exports.isEmpty = isEmpty;
function member(E) {
    var lookupE = lookup(E);
    return function (k, m) {
        if (m === undefined) {
            var memberE_1 = member(E);
            return function (m) { return memberE_1(k, m); };
        }
        return _.isSome(lookupE(k, m));
    };
}
exports.member = member;
function elem(E) {
    return function (a, m) {
        if (m === undefined) {
            var elemE_1 = elem(E);
            return function (m) { return elemE_1(a, m); };
        }
        var values = m.values();
        var e;
        // tslint:disable-next-line: strict-boolean-expressions
        while (!(e = values.next()).done) {
            var v = e.value;
            if (E.equals(a, v)) {
                return true;
            }
        }
        return false;
    };
}
exports.elem = elem;
/**
 * Get a sorted `ReadonlyArray` of the keys contained in a `ReadonlyMap`.
 *
 * @since 2.5.0
 */
var keys = function (O) { return function (m) {
    return Array.from(m.keys()).sort(O.compare);
}; };
exports.keys = keys;
/**
 * Get a sorted `ReadonlyArray` of the values contained in a `ReadonlyMap`.
 *
 * @since 2.5.0
 */
var values = function (O) { return function (m) {
    return Array.from(m.values()).sort(O.compare);
}; };
exports.values = values;
/**
 * @since 2.5.0
 */
function collect(O) {
    var keysO = exports.keys(O);
    return function (f) { return function (m) {
        var out = [];
        var ks = keysO(m);
        for (var _i = 0, ks_1 = ks; _i < ks_1.length; _i++) {
            var key = ks_1[_i];
            out.push(f(key, m.get(key)));
        }
        return out;
    }; };
}
exports.collect = collect;
/**
 * Get a sorted `ReadonlyArray` of the key/value pairs contained in a `ReadonlyMap`.
 *
 * @since 2.5.0
 */
var toReadonlyArray = function (O) {
    return collect(O)(function (k, a) { return [k, a]; });
};
exports.toReadonlyArray = toReadonlyArray;
function toUnfoldable(ord, U) {
    var toReadonlyArrayO = exports.toReadonlyArray(ord);
    return function (d) {
        var kas = toReadonlyArrayO(d);
        var len = kas.length;
        return U.unfold(0, function (b) { return (b < len ? _.some([kas[b], b + 1]) : _.none); });
    };
}
exports.toUnfoldable = toUnfoldable;
/**
 * Insert or replace a key/value pair in a `ReadonlyMap`.
 *
 * @category combinators
 * @since 2.10.0
 */
var upsertAt = function (E) {
    var lookupWithKeyE = lookupWithKey(E);
    return function (k, a) {
        var lookupWithKeyEk = lookupWithKeyE(k);
        return function (m) {
            var found = lookupWithKeyEk(m);
            if (_.isNone(found)) {
                var out = new Map(m);
                out.set(k, a);
                return out;
            }
            else if (found.value[1] !== a) {
                var out = new Map(m);
                out.set(found.value[0], a);
                return out;
            }
            return m;
        };
    };
};
exports.upsertAt = upsertAt;
/**
 * Delete a key and value from a map
 *
 * @category combinators
 * @since 2.5.0
 */
var deleteAt = function (E) {
    var lookupWithKeyE = lookupWithKey(E);
    return function (k) { return function (m) {
        var found = lookupWithKeyE(k, m);
        if (_.isSome(found)) {
            var r = new Map(m);
            r.delete(found.value[0]);
            return r;
        }
        return m;
    }; };
};
exports.deleteAt = deleteAt;
/**
 * @since 2.5.0
 */
var updateAt = function (E) {
    var modifyAtE = exports.modifyAt(E);
    return function (k, a) { return modifyAtE(k, function () { return a; }); };
};
exports.updateAt = updateAt;
/**
 * @since 2.5.0
 */
var modifyAt = function (E) {
    var lookupWithKeyE = lookupWithKey(E);
    return function (k, f) { return function (m) {
        var found = lookupWithKeyE(k, m);
        if (_.isNone(found)) {
            return _.none;
        }
        var _a = found.value, fk = _a[0], fv = _a[1];
        var next = f(fv);
        if (next === fv) {
            return _.some(m);
        }
        var r = new Map(m);
        r.set(fk, next);
        return _.some(r);
    }; };
};
exports.modifyAt = modifyAt;
/**
 * Delete a key and value from a map, returning the value as well as the subsequent map
 *
 * @since 2.5.0
 */
function pop(E) {
    var lookupE = lookup(E);
    var deleteAtE = exports.deleteAt(E);
    return function (k) {
        var deleteAtEk = deleteAtE(k);
        return function (m) {
            return function_1.pipe(lookupE(k, m), O.map(function (a) { return [a, deleteAtEk(m)]; }));
        };
    };
}
exports.pop = pop;
function lookupWithKey(E) {
    return function (k, m) {
        if (m === undefined) {
            var lookupWithKeyE_1 = lookupWithKey(E);
            return function (m) { return lookupWithKeyE_1(k, m); };
        }
        var entries = m.entries();
        var e;
        // tslint:disable-next-line: strict-boolean-expressions
        while (!(e = entries.next()).done) {
            var _a = e.value, ka = _a[0], a = _a[1];
            if (E.equals(ka, k)) {
                return _.some([ka, a]);
            }
        }
        return _.none;
    };
}
exports.lookupWithKey = lookupWithKey;
function lookup(E) {
    var lookupWithKeyE = lookupWithKey(E);
    return function (k, m) {
        if (m === undefined) {
            var lookupE_1 = lookup(E);
            return function (m) { return lookupE_1(k, m); };
        }
        return function_1.pipe(lookupWithKeyE(k, m), O.map(function (_a) {
            var _ = _a[0], a = _a[1];
            return a;
        }));
    };
}
exports.lookup = lookup;
function isSubmap(SK, SA) {
    var lookupWithKeyS = lookupWithKey(SK);
    return function (me, that) {
        if (that === undefined) {
            var isSubmapSKSA_1 = isSubmap(SK, SA);
            return function (that) { return isSubmapSKSA_1(that, me); };
        }
        var entries = me.entries();
        var e;
        // tslint:disable-next-line: strict-boolean-expressions
        while (!(e = entries.next()).done) {
            var _a = e.value, k = _a[0], a = _a[1];
            var d2OptA = lookupWithKeyS(k, that);
            if (_.isNone(d2OptA) || !SK.equals(k, d2OptA.value[0]) || !SA.equals(a, d2OptA.value[1])) {
                return false;
            }
        }
        return true;
    };
}
exports.isSubmap = isSubmap;
/**
 * @since 2.5.0
 */
exports.empty = 
// the type annotation here is intended (otherwise it doesn't type-check)
new Map();
/**
 * @category instances
 * @since 2.5.0
 */
function getEq(SK, SA) {
    var isSubmapSKSA = isSubmap(SK, SA);
    return Eq_1.fromEquals(function (x, y) { return isSubmapSKSA(x, y) && isSubmapSKSA(y, x); });
}
exports.getEq = getEq;
/**
 * Gets `Monoid` instance for Maps given `Semigroup` instance for their values
 *
 * @category instances
 * @since 2.5.0
 */
function getMonoid(SK, SA) {
    var lookupWithKeyS = lookupWithKey(SK);
    return {
        concat: function (mx, my) {
            if (exports.isEmpty(mx)) {
                return my;
            }
            if (exports.isEmpty(my)) {
                return mx;
            }
            var r = new Map(mx);
            var entries = my.entries();
            var e;
            // tslint:disable-next-line: strict-boolean-expressions
            while (!(e = entries.next()).done) {
                var _a = e.value, k = _a[0], a = _a[1];
                var mxOptA = lookupWithKeyS(k, mx);
                if (_.isSome(mxOptA)) {
                    r.set(mxOptA.value[0], SA.concat(mxOptA.value[1], a));
                }
                else {
                    r.set(k, a);
                }
            }
            return r;
        },
        empty: exports.empty
    };
}
exports.getMonoid = getMonoid;
/**
 * Create a map with one key/value pair
 *
 * @category constructors
 * @since 2.5.0
 */
var singleton = function (k, a) { return new Map([[k, a]]); };
exports.singleton = singleton;
function fromFoldable(E, M, F) {
    return function (fka) {
        var lookupWithKeyE = lookupWithKey(E);
        return F.reduce(fka, new Map(), function (b, _a) {
            var k = _a[0], a = _a[1];
            var bOpt = lookupWithKeyE(k, b);
            if (_.isSome(bOpt)) {
                b.set(bOpt.value[0], M.concat(bOpt.value[1], a));
            }
            else {
                b.set(k, a);
            }
            return b;
        });
    };
}
exports.fromFoldable = fromFoldable;
var _mapWithIndex = function (fa, f) {
    var m = new Map();
    var entries = fa.entries();
    var e;
    // tslint:disable-next-line: strict-boolean-expressions
    while (!(e = entries.next()).done) {
        var _a = e.value, key = _a[0], a = _a[1];
        m.set(key, f(key, a));
    }
    return m;
};
/**
 * @category combinators
 * @since 2.10.0
 */
var partitionMapWithIndex = function (f) { return function (fa) {
    var left = new Map();
    var right = new Map();
    var entries = fa.entries();
    var e;
    // tslint:disable-next-line: strict-boolean-expressions
    while (!(e = entries.next()).done) {
        var _a = e.value, k = _a[0], a = _a[1];
        var ei = f(k, a);
        if (_.isLeft(ei)) {
            left.set(k, ei.left);
        }
        else {
            right.set(k, ei.right);
        }
    }
    return Separated_1.separated(left, right);
}; };
exports.partitionMapWithIndex = partitionMapWithIndex;
function partitionWithIndex(predicateWithIndex) {
    return function (m) {
        var left = new Map();
        var right = new Map();
        var entries = m.entries();
        var e;
        // tslint:disable-next-line: strict-boolean-expressions
        while (!(e = entries.next()).done) {
            var _a = e.value, k = _a[0], a = _a[1];
            if (predicateWithIndex(k, a)) {
                right.set(k, a);
            }
            else {
                left.set(k, a);
            }
        }
        return Separated_1.separated(left, right);
    };
}
exports.partitionWithIndex = partitionWithIndex;
/**
 * @category combinators
 * @since 2.10.0
 */
var filterMapWithIndex = function (f) { return function (fa) {
    var m = new Map();
    var entries = fa.entries();
    var e;
    // tslint:disable-next-line: strict-boolean-expressions
    while (!(e = entries.next()).done) {
        var _a = e.value, k = _a[0], a = _a[1];
        var o = f(k, a);
        if (_.isSome(o)) {
            m.set(k, o.value);
        }
    }
    return m;
}; };
exports.filterMapWithIndex = filterMapWithIndex;
function filterWithIndex(predicateWithIndex) {
    return function (m) {
        var out = new Map();
        var entries = m.entries();
        var e;
        // tslint:disable-next-line: strict-boolean-expressions
        while (!(e = entries.next()).done) {
            var _a = e.value, k = _a[0], a = _a[1];
            if (predicateWithIndex(k, a)) {
                out.set(k, a);
            }
        }
        return out;
    };
}
exports.filterWithIndex = filterWithIndex;
// -------------------------------------------------------------------------------------
// non-pipeables
// -------------------------------------------------------------------------------------
var _map = function (fa, f) { return _mapWithIndex(fa, function (_, a) { return f(a); }); };
var _filter = function (fa, p) {
    return _filterWithIndex(fa, function (_, a) { return p(a); });
};
var _filterMap = function (fa, f) { return _filterMapWithIndex(fa, function (_, a) { return f(a); }); };
var _partition = function (fa, predicate) {
    return _partitionWithIndex(fa, function (_, a) { return predicate(a); });
};
var _partitionMap = function (fa, f) { return _partitionMapWithIndex(fa, function (_, a) { return f(a); }); };
var _filterWithIndex = function (fa, p) { return function_1.pipe(fa, filterWithIndex(p)); };
var _filterMapWithIndex = function (fa, f) {
    return function_1.pipe(fa, exports.filterMapWithIndex(f));
};
var _partitionWithIndex = function (fa, p) { return function_1.pipe(fa, partitionWithIndex(p)); };
var _partitionMapWithIndex = function (fa, f) {
    return function_1.pipe(fa, exports.partitionMapWithIndex(f));
};
// -------------------------------------------------------------------------------------
// type class members
// -------------------------------------------------------------------------------------
/**
 * @category Compactable
 * @since 2.5.0
 */
var compact = function (fa) {
    var m = new Map();
    var entries = fa.entries();
    var e;
    // tslint:disable-next-line: strict-boolean-expressions
    while (!(e = entries.next()).done) {
        var _a = e.value, k = _a[0], oa = _a[1];
        if (_.isSome(oa)) {
            m.set(k, oa.value);
        }
    }
    return m;
};
exports.compact = compact;
/**
 * @category Filterable
 * @since 2.5.0
 */
var filter = function (predicate) { return function (fa) { return _filter(fa, predicate); }; };
exports.filter = filter;
/**
 * @category Filterable
 * @since 2.5.0
 */
var filterMap = function (f) { return function (fa) { return _filterMap(fa, f); }; };
exports.filterMap = filterMap;
/**
 * `map` can be used to turn functions `(a: A) => B` into functions `(fa: F<A>) => F<B>` whose argument and return types
 * use the type constructor `F` to represent some computational context.
 *
 * @category Functor
 * @since 2.5.0
 */
var map = function (f) { return function (fa) { return _map(fa, f); }; };
exports.map = map;
/**
 * @category FunctorWithIndex
 * @since 2.7.1
 */
var mapWithIndex = function (f) { return function (fa) { return _mapWithIndex(fa, f); }; };
exports.mapWithIndex = mapWithIndex;
/**
 * @category Filterable
 * @since 2.5.0
 */
var partition = function (predicate) { return function (fa) { return _partition(fa, predicate); }; };
exports.partition = partition;
/**
 * @category Filterable
 * @since 2.5.0
 */
var partitionMap = function (f) { return function (fa) { return _partitionMap(fa, f); }; };
exports.partitionMap = partitionMap;
/**
 * @category Compactable
 * @since 2.5.0
 */
var separate = function (fa) {
    var left = new Map();
    var right = new Map();
    var entries = fa.entries();
    var e;
    // tslint:disable-next-line: strict-boolean-expressions
    while (!(e = entries.next()).done) {
        var _a = e.value, k = _a[0], ei = _a[1];
        if (_.isLeft(ei)) {
            left.set(k, ei.left);
        }
        else {
            right.set(k, ei.right);
        }
    }
    return Separated_1.separated(left, right);
};
exports.separate = separate;
// -------------------------------------------------------------------------------------
// instances
// -------------------------------------------------------------------------------------
/**
 * @category instances
 * @since 2.5.0
 */
exports.URI = 'ReadonlyMap';
/**
 * @category instances
 * @since 2.11.0
 */
var getUnionSemigroup = function (E, S) {
    var unionES = exports.union(E, S);
    return {
        concat: function (first, second) { return unionES(second)(first); }
    };
};
exports.getUnionSemigroup = getUnionSemigroup;
/**
 * @category instances
 * @since 2.11.0
 */
var getUnionMonoid = function (E, S) { return ({
    concat: exports.getUnionSemigroup(E, S).concat,
    empty: exports.empty
}); };
exports.getUnionMonoid = getUnionMonoid;
/**
 * @category instances
 * @since 2.11.0
 */
var getIntersectionSemigroup = function (E, S) {
    var intersectionES = exports.intersection(E, S);
    return {
        concat: function (first, second) { return intersectionES(second)(first); }
    };
};
exports.getIntersectionSemigroup = getIntersectionSemigroup;
/**
 * @category instances
 * @since 2.11.0
 */
var getDifferenceMagma = function (E) { return function () {
    var differenceE = exports.difference(E);
    return {
        concat: function (first, second) { return differenceE(second)(first); }
    };
}; };
exports.getDifferenceMagma = getDifferenceMagma;
/**
 * @category instances
 * @since 2.5.0
 */
function getFilterableWithIndex() {
    return {
        URI: exports.URI,
        _E: undefined,
        map: _map,
        mapWithIndex: _mapWithIndex,
        compact: exports.compact,
        separate: exports.separate,
        filter: _filter,
        filterMap: _filterMap,
        partition: _partition,
        partitionMap: _partitionMap,
        partitionMapWithIndex: _partitionMapWithIndex,
        partitionWithIndex: _partitionWithIndex,
        filterMapWithIndex: _filterMapWithIndex,
        filterWithIndex: _filterWithIndex
    };
}
exports.getFilterableWithIndex = getFilterableWithIndex;
/**
 * @category instances
 * @since 2.7.0
 */
exports.Functor = {
    URI: exports.URI,
    map: _map
};
/**
 * Derivable from `Functor`.
 *
 * @category combinators
 * @since 2.10.0
 */
exports.flap = 
/*#_PURE_*/
Functor_1.flap(exports.Functor);
/**
 * @category instances
 * @since 2.10.0
 */
var getFunctorWithIndex = function () { return ({
    URI: exports.URI,
    _E: undefined,
    map: _map,
    mapWithIndex: _mapWithIndex
}); };
exports.getFunctorWithIndex = getFunctorWithIndex;
/**
 * @category instances
 * @since 2.7.0
 */
exports.Compactable = {
    URI: exports.URI,
    compact: exports.compact,
    separate: exports.separate
};
/**
 * @category instances
 * @since 2.7.0
 */
exports.Filterable = {
    URI: exports.URI,
    map: _map,
    compact: exports.compact,
    separate: exports.separate,
    filter: _filter,
    filterMap: _filterMap,
    partition: _partition,
    partitionMap: _partitionMap
};
/**
 * @since 2.11.0
 */
var reduce = function (O) {
    var reduceWithIndexO = exports.reduceWithIndex(O);
    return function (b, f) { return reduceWithIndexO(b, function (_, b, a) { return f(b, a); }); };
};
exports.reduce = reduce;
/**
 * @since 2.11.0
 */
var foldMap = function (O) {
    var foldMapWithIndexO = exports.foldMapWithIndex(O);
    return function (M) {
        var foldMapWithIndexOM = foldMapWithIndexO(M);
        return function (f) { return foldMapWithIndexOM(function (_, a) { return f(a); }); };
    };
};
exports.foldMap = foldMap;
/**
 * @since 2.11.0
 */
var reduceRight = function (O) {
    var reduceRightWithIndexO = exports.reduceRightWithIndex(O);
    return function (b, f) { return reduceRightWithIndexO(b, function (_, b, a) { return f(b, a); }); };
};
exports.reduceRight = reduceRight;
/**
 * @category instances
 * @since 2.10.0
 */
var getFoldable = function (O) {
    var reduceO = exports.reduce(O);
    var foldMapO = exports.foldMap(O);
    var reduceRightO = exports.reduceRight(O);
    return {
        URI: exports.URI,
        _E: undefined,
        reduce: function (fa, b, f) { return function_1.pipe(fa, reduceO(b, f)); },
        foldMap: function (M) {
            var foldMapOM = foldMapO(M);
            return function (fa, f) { return function_1.pipe(fa, foldMapOM(f)); };
        },
        reduceRight: function (fa, b, f) { return function_1.pipe(fa, reduceRightO(b, f)); }
    };
};
exports.getFoldable = getFoldable;
/**
 * @since 2.11.0
 */
var reduceWithIndex = function (O) {
    var keysO = exports.keys(O);
    return function (b, f) { return function (m) {
        var out = b;
        for (var _i = 0, _a = keysO(m); _i < _a.length; _i++) {
            var k = _a[_i];
            out = f(k, out, m.get(k));
        }
        return out;
    }; };
};
exports.reduceWithIndex = reduceWithIndex;
/**
 * @since 2.11.0
 */
var foldMapWithIndex = function (O) {
    var keysO = exports.keys(O);
    return function (M) { return function (f) { return function (m) {
        var out = M.empty;
        for (var _i = 0, _a = keysO(m); _i < _a.length; _i++) {
            var k = _a[_i];
            out = M.concat(out, f(k, m.get(k)));
        }
        return out;
    }; }; };
};
exports.foldMapWithIndex = foldMapWithIndex;
/**
 * @since 2.11.0
 */
var reduceRightWithIndex = function (O) {
    var keysO = exports.keys(O);
    return function (b, f) { return function (m) {
        var out = b;
        var ks = keysO(m);
        var len = ks.length;
        for (var i = len - 1; i >= 0; i--) {
            var k = ks[i];
            out = f(k, m.get(k), out);
        }
        return out;
    }; };
};
exports.reduceRightWithIndex = reduceRightWithIndex;
/**
 * @category instances
 * @since 2.10.0
 */
var getFoldableWithIndex = function (O) {
    var F = exports.getFoldable(O);
    var reduceWithIndexO = exports.reduceWithIndex(O);
    var foldMapWithIndexO = exports.foldMapWithIndex(O);
    var reduceRightWithIndexO = exports.reduceRightWithIndex(O);
    return {
        URI: exports.URI,
        _E: undefined,
        reduce: F.reduce,
        foldMap: F.foldMap,
        reduceRight: F.reduceRight,
        reduceWithIndex: function (fa, b, f) { return function_1.pipe(fa, reduceWithIndexO(b, f)); },
        foldMapWithIndex: function (M) {
            var foldMapWithIndexOM = foldMapWithIndexO(M);
            return function (fa, f) { return function_1.pipe(fa, foldMapWithIndexOM(f)); };
        },
        reduceRightWithIndex: function (fa, b, f) { return function_1.pipe(fa, reduceRightWithIndexO(b, f)); }
    };
};
exports.getFoldableWithIndex = getFoldableWithIndex;
/**
 * @category instances
 * @since 2.10.0
 */
var getTraversable = function (O) {
    var TWI = exports.getTraversableWithIndex(O);
    var F = exports.getFoldable(O);
    return {
        URI: exports.URI,
        _E: undefined,
        map: _map,
        reduce: F.reduce,
        foldMap: F.foldMap,
        reduceRight: F.reduceRight,
        traverse: TWI.traverse,
        sequence: TWI.sequence
    };
};
exports.getTraversable = getTraversable;
/**
 * @category instances
 * @since 2.10.0
 */
var getTraversableWithIndex = function (O) {
    var FWI = exports.getFoldableWithIndex(O);
    var keysO = exports.keys(O);
    var traverseWithIndex = function (F) {
        return function (ta, f) {
            var fm = F.of(new Map());
            var ks = keysO(ta);
            var len = ks.length;
            var _loop_1 = function (i) {
                var key = ks[i];
                var a = ta.get(key);
                fm = F.ap(F.map(fm, function (m) { return function (b) { return m.set(key, b); }; }), f(key, a));
            };
            for (var i = 0; i < len; i++) {
                _loop_1(i);
            }
            return fm;
        };
    };
    var traverse = function (F) {
        var traverseWithIndexF = traverseWithIndex(F);
        return function (ta, f) { return traverseWithIndexF(ta, function (_, a) { return f(a); }); };
    };
    var sequence = function (F) {
        var traverseWithIndexF = traverseWithIndex(F);
        return function (ta) { return traverseWithIndexF(ta, function_1.SK); };
    };
    return {
        URI: exports.URI,
        _E: undefined,
        map: _map,
        mapWithIndex: _mapWithIndex,
        reduce: FWI.reduce,
        foldMap: FWI.foldMap,
        reduceRight: FWI.reduceRight,
        reduceWithIndex: FWI.reduceWithIndex,
        foldMapWithIndex: FWI.foldMapWithIndex,
        reduceRightWithIndex: FWI.reduceRightWithIndex,
        traverse: traverse,
        sequence: sequence,
        traverseWithIndex: traverseWithIndex
    };
};
exports.getTraversableWithIndex = getTraversableWithIndex;
/**
 * @category instances
 * @since 2.5.0
 */
function getWitherable(O) {
    var TWI = exports.getTraversableWithIndex(O);
    return {
        URI: exports.URI,
        _E: undefined,
        map: _map,
        compact: exports.compact,
        separate: exports.separate,
        filter: _filter,
        filterMap: _filterMap,
        partition: _partition,
        partitionMap: _partitionMap,
        reduce: TWI.reduce,
        foldMap: TWI.foldMap,
        reduceRight: TWI.reduceRight,
        traverse: TWI.traverse,
        sequence: TWI.sequence,
        mapWithIndex: _mapWithIndex,
        reduceWithIndex: TWI.reduceWithIndex,
        foldMapWithIndex: TWI.foldMapWithIndex,
        reduceRightWithIndex: TWI.reduceRightWithIndex,
        traverseWithIndex: TWI.traverseWithIndex,
        wilt: Witherable_1.wiltDefault(TWI, exports.Compactable),
        wither: Witherable_1.witherDefault(TWI, exports.Compactable)
    };
}
exports.getWitherable = getWitherable;
// -------------------------------------------------------------------------------------
// utils
// -------------------------------------------------------------------------------------
/**
 * @since 2.11.0
 */
var union = function (E, M) {
    var lookupE = lookup(E);
    return function (second) { return function (first) {
        if (exports.isEmpty(first)) {
            return second;
        }
        if (exports.isEmpty(second)) {
            return first;
        }
        var out = new Map();
        var firstEntries = first.entries();
        var e;
        while (!(e = firstEntries.next()).done) {
            var _a = e.value, k = _a[0], a = _a[1];
            var oka = lookupE(k)(second);
            if (_.isSome(oka)) {
                out.set(k, M.concat(a, oka.value));
            }
            else {
                out.set(k, a);
            }
        }
        var secondEntries = second.entries();
        while (!(e = secondEntries.next()).done) {
            var _b = e.value, k = _b[0], a = _b[1];
            var oka = lookupE(k)(out);
            if (_.isNone(oka)) {
                out.set(k, a);
            }
        }
        return out;
    }; };
};
exports.union = union;
/**
 * @since 2.11.0
 */
var intersection = function (E, M) {
    var lookupE = lookup(E);
    return function (second) { return function (first) {
        if (exports.isEmpty(first) || exports.isEmpty(second)) {
            return exports.empty;
        }
        var out = new Map();
        var entries = first.entries();
        var e;
        while (!(e = entries.next()).done) {
            var _a = e.value, k = _a[0], a = _a[1];
            var oka = lookupE(k)(second);
            if (_.isSome(oka)) {
                out.set(k, M.concat(a, oka.value));
            }
        }
        return out;
    }; };
};
exports.intersection = intersection;
/**
 * @since 2.11.0
 */
var difference = function (E) {
    var memberE = member(E);
    return function (second) { return function (first) {
        if (exports.isEmpty(first)) {
            return second;
        }
        if (exports.isEmpty(second)) {
            return first;
        }
        var out = new Map();
        var firstEntries = first.entries();
        var e;
        while (!(e = firstEntries.next()).done) {
            var _a = e.value, k = _a[0], a = _a[1];
            if (!memberE(k)(second)) {
                out.set(k, a);
            }
        }
        var secondEntries = second.entries();
        while (!(e = secondEntries.next()).done) {
            var _b = e.value, k = _b[0], a = _b[1];
            if (!memberE(k)(first)) {
                out.set(k, a);
            }
        }
        return out;
    }; };
};
exports.difference = difference;
// -------------------------------------------------------------------------------------
// deprecated
// -------------------------------------------------------------------------------------
/**
 * Use [`upsertAt`](#upsertat) instead.
 *
 * @category combinators
 * @since 2.5.0
 * @deprecated
 */
exports.insertAt = exports.upsertAt;
/**
 * Use small, specific instances instead.
 *
 * @category instances
 * @since 2.5.0
 * @deprecated
 */
exports.readonlyMap = {
    URI: exports.URI,
    map: _map,
    compact: exports.compact,
    separate: exports.separate,
    filter: _filter,
    filterMap: _filterMap,
    partition: _partition,
    partitionMap: _partitionMap
};
