/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.authentication;

import com.netscape.certsrv.authentication.AuthCredentials;
import com.netscape.certsrv.authentication.EInvalidCredentials;
import com.netscape.certsrv.authentication.EMissingCredential;
import com.netscape.certsrv.authentication.ISSLClientCertProvider;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.certsrv.usrgrp.Certificates;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import org.dogtagpki.server.authentication.AuthManager;
import org.dogtagpki.server.authentication.AuthManagerConfig;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authentication.AuthenticationConfig;
import org.mozilla.jss.netscape.security.x509.BasicConstraintsExtension;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLclientCertAuthentication
extends AuthManager {
    public static Logger logger = LoggerFactory.getLogger(SSLclientCertAuthentication.class);
    public static final String TOKEN_USERDN = "user";
    public static final String TOKEN_USER_DN = "userdn";
    public static final String TOKEN_USERID = "userid";
    public static final String TOKEN_UID = "uid";
    public static final String CRED_CERT = "sslClientCert";
    protected String[] mRequiredCreds = new String[]{"sslClientCert"};

    @Override
    public void init(AuthenticationConfig authenticationConfig, String name, String implName, AuthManagerConfig config) throws EBaseException {
        this.authenticationConfig = authenticationConfig;
        this.mName = name;
        this.mImplName = implName;
        this.mConfig = config;
    }

    @Override
    public boolean isSSLClientRequired() {
        return true;
    }

    @Override
    public AuthToken authenticate(AuthCredentials authCred) throws EMissingCredential, EInvalidCredentials, EBaseException {
        logger.debug("SSLclientCertAuthentication: start");
        logger.debug("authenticator instance name is " + this.getName());
        SessionContext context = SessionContext.getExistingContext();
        ISSLClientCertProvider provider = (ISSLClientCertProvider)context.get((Object)"sslClientCertProvider");
        if (provider == null) {
            logger.error("SSLclientCertAuthentication: No SSL Client Cert Provider Found");
            throw new EInvalidCredentials(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]));
        }
        logger.debug("SSLclientCertAuthentication: got provider");
        logger.debug("SSLclientCertAuthentication: retrieving client certificate");
        X509Certificate[] allCerts = provider.getClientCertificateChain();
        if (allCerts == null) {
            logger.error("SSLclientCertAuthentication: No SSL Client Certs Found");
            throw new EInvalidCredentials(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]));
        }
        logger.debug("SSLclientCertAuthentication: got certificates");
        AuthToken authToken = new AuthToken(this);
        X509Certificate[] x509Certs = allCerts;
        X509CertImpl[] ci = new X509CertImpl[x509Certs.length];
        X509CertImpl clientCert = null;
        try {
            for (int i = 0; i < x509Certs.length; ++i) {
                ci[i] = new X509CertImpl(x509Certs[i].getEncoded());
                clientCert = ci[i];
                byte[] extBytes = clientCert.getExtensionValue("2.5.29.19");
                if (extBytes == null) {
                    logger.debug("SSLclientCertAuthentication: authenticate: found leaf cert");
                    break;
                }
                logger.debug("SSLclientCertAuthentication: authenticate: found cert having BasicConstraints ext");
                try {
                    BasicConstraintsExtension bce = new BasicConstraintsExtension(Boolean.valueOf(true), (Object)extBytes);
                    if (bce == null || ((Boolean)bce.get("is_ca")).booleanValue()) continue;
                    logger.debug("SSLclientCertAuthentication: authenticate: found CA cert in chain");
                    break;
                }
                catch (Exception e) {
                    logger.error("SSLclientCertAuthentication: authenticate: exception: " + e.getMessage(), (Throwable)e);
                    throw new EInvalidCredentials(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]), e);
                }
            }
            if (clientCert == null) {
                logger.error("SSLclientCertAuthentication: authenticate: client cert not found");
                throw new EInvalidCredentials(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]));
            }
        }
        catch (CertificateException e) {
            logger.error("SSLclientCertAuthentication: " + e.getMessage(), (Throwable)e);
            throw new EInvalidCredentials(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]), (Exception)e);
        }
        boolean checkRevocation = true;
        try {
            checkRevocation = this.mConfig.getBoolean("checkRevocation", true);
        }
        catch (EBaseException extBytes) {
            // empty catch block
        }
        if (checkRevocation && this.engine.isRevoked((X509Certificate[])ci)) {
            logger.error("SSLclientCertAuthentication: certificate revoked");
            throw new EInvalidCredentials(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]));
        }
        Certificates certs = new Certificates((X509Certificate[])ci);
        Principal p_dn = clientCert.getSubjectDN();
        authToken.set(TOKEN_USERDN, p_dn.getName());
        authToken.set(TOKEN_USER_DN, p_dn.getName());
        String uid = this.getUidFromDN(p_dn.getName());
        if (uid != null) {
            authToken.set(TOKEN_UID, uid);
            authToken.set(TOKEN_USERID, uid);
        }
        authToken.set(CRED_CERT, certs);
        logger.debug("SSLclientCertAuthentication: authenticated ");
        return authToken;
    }

    String getUidFromDN(String userdn) {
        StringTokenizer st = new StringTokenizer(userdn, ",");
        while (st.hasMoreTokens()) {
            String n;
            String t = st.nextToken();
            int i = t.indexOf("=");
            if (i == -1 || !(n = t.substring(0, i)).equalsIgnoreCase(TOKEN_UID)) continue;
            String v = t.substring(i + 1);
            logger.debug("SSLclientCertAuthentication: getUidFromDN(): uid found:" + v);
            return v;
        }
        return null;
    }

    @Override
    public String[] getRequiredCreds() {
        return this.mRequiredCreds;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void init(ConfigStore config) throws EProfileException {
    }

    @Override
    public String getName(Locale locale) {
        return CMS.getUserMessage(locale, "CMS_AUTHENTICATION_SSL_CLIENT_NAME", new String[0]);
    }

    @Override
    public String getText(Locale locale) {
        return CMS.getUserMessage(locale, "CMS_AUTHENTICATION_SSL_CLIENT_TEXT", new String[0]);
    }

    @Override
    public Enumeration<String> getValueNames() {
        return null;
    }

    @Override
    public boolean isValueWriteable(String name) {
        return false;
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        return null;
    }

    @Override
    public void populate(AuthToken token, Request request) throws EProfileException {
        request.setExtData("authenticatedName", token.getInString(TOKEN_USERDN));
        request.setExtData("authenticatedName", token.getInString("userDN"));
    }
}

