/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.logging;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.base.Subsystem;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.certsrv.logging.AuditEvent;
import com.netscape.certsrv.logging.ELogException;
import com.netscape.certsrv.logging.ILogger;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.LogEventListener;
import com.netscape.certsrv.logging.LogSource;
import com.netscape.certsrv.logging.SignedAuditEvent;
import com.netscape.cms.logging.LogEntry;
import com.netscape.cms.logging.LogQueue;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.logging.LoggerConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.ServletException;
import netscape.ldap.client.JDAPAVA;
import netscape.ldap.client.JDAPFilter;
import netscape.ldap.client.JDAPFilterAnd;
import netscape.ldap.client.JDAPFilterEqualityMatch;
import netscape.ldap.client.JDAPFilterNot;
import netscape.ldap.client.JDAPFilterOr;
import netscape.ldap.client.JDAPFilterPresent;
import netscape.ldap.client.JDAPFilterSubString;
import org.apache.commons.lang3.StringUtils;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.NotInitializedException;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.ObjectNotFoundException;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.pkcs11.PK11PrivKey;
import org.mozilla.jss.util.Base64OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogFile
extends LogEventListener
implements IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(LogFile.class);
    private static final String LOG_SIGNED_AUDIT_EXCEPTION = "LOG_SIGNED_AUDIT_EXCEPTION_1";
    protected ConfigStore mConfig;
    static final String DATE_PATTERN = "yyyyMMddHHmmss";
    protected SimpleDateFormat mLogFileDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    protected File mFile = null;
    protected String mFileName = null;
    protected BufferedWriter mLogWriter = null;
    protected String mDatePattern = "dd/MMM/yyyy:HH:mm:ss z";
    protected SimpleDateFormat mLogDateFormat = new SimpleDateFormat(this.mDatePattern);
    protected Date mDate = new Date();
    protected int mBytesWritten = 0;
    protected int mBufferSize = 512;
    protected int mFlushInterval = 5;
    protected int mBytesUnflushed = 0;
    private Thread mFlushThread = null;
    protected Set<String> mandatoryEvents = new LinkedHashSet<String>();
    protected Set<String> selectedEvents = new LinkedHashSet<String>();
    protected Map<String, JDAPFilter> filters = new HashMap<String, JDAPFilter>();
    protected String mType = null;
    protected boolean mOn = false;
    protected boolean mRegister = false;
    protected boolean mTrace = false;
    protected boolean mLogSigning = false;
    private String mSAuditCertNickName = "";
    static final String CRYPTO_PROVIDER = "Mozilla-JSS";
    protected long mLevel = 1L;
    private static boolean mInSignedAuditLogFailureMode = false;
    private PrivateKey mSigningKey = null;
    private Signature mSignature = null;
    private static final byte LINE_SEP_BYTE = 10;

    @Override
    public void init(Subsystem owner, LoggerConfig config) throws EBaseException {
        this.mConfig = config;
        try {
            this.mOn = config.getEnable();
        }
        catch (EBaseException e) {
            throw new ELogException(CMS.getUserMessage("CMS_BASE_GET_PROPERTY_FAILED", config.getName() + ".enable"));
        }
        try {
            this.mLogSigning = config.getLogSigning();
        }
        catch (EBaseException e) {
            throw new ELogException(CMS.getUserMessage("CMS_BASE_GET_PROPERTY_FAILED", config.getName() + ".logSigning"));
        }
        if (this.mOn && this.mLogSigning) {
            try {
                this.mSAuditCertNickName = config.getSignedAuditCertNickname();
                logger.debug("LogFile: audit log signing enabled. signedAuditCertNickname: " + this.mSAuditCertNickName);
            }
            catch (EBaseException e) {
                throw new ELogException(CMS.getUserMessage("CMS_BASE_GET_PROPERTY_FAILED", config.getName() + ".signedAuditCertNickname"));
            }
            if (this.mSAuditCertNickName == null || this.mSAuditCertNickName.trim().equals("")) {
                throw new ELogException(CMS.getUserMessage("CMS_BASE_GET_PROPERTY_FAILED", config.getName() + ".signedAuditCertNickname"));
            }
        }
        String mandatoryEventsList = config.getMandatoryEvents();
        for (String event : StringUtils.split((String)mandatoryEventsList, (String)", ")) {
            this.mandatoryEvents.add(event);
        }
        String selectedEventsList = config.getSelectedEvents();
        for (String event : StringUtils.split((String)selectedEventsList, (String)", ")) {
            this.selectedEvents.add(event);
        }
        logger.debug("Event filters:");
        ConfigStore filterStore = config.getFilters();
        Enumeration<String> e = filterStore.getPropertyNames();
        while (e.hasMoreElements()) {
            String eventType = e.nextElement();
            String strFilter = filterStore.get(eventType);
            logger.debug("- " + eventType + ": " + strFilter);
            JDAPFilter filter = JDAPFilter.getFilter((String)strFilter);
            this.filters.put(eventType, filter);
        }
        try {
            this.init(config);
        }
        catch (IOException e2) {
            throw new ELogException("Unable to initialize LogFile: " + e2.getMessage(), (Exception)e2);
        }
        if (this.mOn && this.mLogSigning) {
            Auditor auditor = this.engine.getAuditor();
            try {
                logger.debug("LogFile: setting up log signing");
                this.setupSigning();
                auditor.log(CMS.getLogMessage("LOGGING_SIGNED_AUDIT_AUDIT_LOG_STARTUP_2", "$System$", "Success"));
            }
            catch (EBaseException e2) {
                logger.error("Unable to set up log signing: " + e2.getMessage(), (Throwable)e2);
                auditor.log(CMS.getLogMessage("LOGGING_SIGNED_AUDIT_AUDIT_LOG_STARTUP_2", "$System$", "Failure"));
                throw e2;
            }
        }
    }

    public void selectEvent(String event) {
        this.selectedEvents.add(event);
    }

    public void deselectEvent(String event) {
        this.selectedEvents.remove(event);
    }

    public void replaceEvents(String events) {
        this.selectedEvents.clear();
        for (String event : StringUtils.split((String)events, (String)", ")) {
            this.selectEvent(event);
        }
    }

    public static String base64Encode(byte[] bytes) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try (Base64OutputStream b64 = new Base64OutputStream(new PrintStream(new FilterOutputStream(output)));){
            b64.write(bytes);
            b64.flush();
            String string = output.toString("8859_1");
            return string;
        }
    }

    private synchronized void shutdownCMS() {
        if (!mInSignedAuditLogFailureMode) {
            mInSignedAuditLogFailureMode = true;
            logger.error("LogFile: Disabling subsystem due to signed logging failure");
            this.engine.disableSubsystem();
        }
    }

    public void init(LoggerConfig config) throws IOException, EBaseException {
        EngineConfig cs = this.engine.getConfig();
        String fileName = null;
        Object defaultFileName = null;
        Object signedAuditDefaultFileName = "";
        this.mConfig = config;
        this.mTrace = config.getTrace();
        this.mType = config.getType();
        this.mRegister = config.getRegister();
        if (this.mOn) {
            if (this.mRegister) {
                LogQueue.getInstance().addLogEventListener(this);
            }
        } else if (this.mRegister) {
            LogQueue.getInstance().removeLogEventListener(this);
            this.shutdown();
        }
        this.mLevel = config.getLevel();
        try {
            String subsystem = cs.getType().toLowerCase();
            String instID = cs.getInstanceID();
            signedAuditDefaultFileName = subsystem + "_" + instID + "_audit";
        }
        catch (Exception e2) {
            String message = CMS.getUserMessage("CMS_BASE_GET_PROPERTY_FAILED", config.getName() + ".fileName");
            logger.error("LogFile: " + message + ": " + e2.getMessage(), (Throwable)e2);
            throw new ELogException(message, e2);
        }
        if (this.mType.equals("signedAudit")) {
            defaultFileName = "logs/signedAudit/" + (String)signedAuditDefaultFileName;
        } else if (this.mType.equals("system")) {
            defaultFileName = "logs/system";
        } else if (this.mType.equals("transaction")) {
            defaultFileName = "logs/transactions";
        } else {
            String message = CMS.getUserMessage("CMS_LOG_INVALID_LOG_TYPE", config.getName(), this.mType);
            logger.error("LogFile: " + message);
            throw new ELogException(message);
        }
        try {
            fileName = config.getFilename((String)defaultFileName);
        }
        catch (EBaseException e) {
            String message = CMS.getUserMessage("CMS_BASE_GET_PROPERTY_FAILED", config.getName() + ".fileName");
            logger.error("LogFile: " + message + ": " + e.getMessage(), (Throwable)e);
            throw new ELogException(message, (Exception)((Object)e));
        }
        if (this.mOn) {
            this.init(fileName, config.getBufferSize(), config.getFlushInterval());
        }
    }

    public void init(String fileName, int bufferSize, int flushInterval) throws IOException, ELogException {
        if (fileName == null) {
            throw new ELogException(CMS.getUserMessage("CMS_LOG_INVALID_FILE_NAME", "null"));
        }
        logger.debug("LogFile: Creating " + this.getClass().getSimpleName() + "(" + fileName + ")");
        this.mFileName = fileName;
        if (!Utils.isNT()) {
            Utils.exec((String)("touch " + this.mFileName));
            Utils.exec((String)("chmod 00640 " + this.mFileName));
        }
        this.mFile = new File(this.mFileName);
        this.mBufferSize = bufferSize;
        this.setFlushInterval(flushInterval);
        this.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupSigning() throws EBaseException {
        try {
            String sigAlgorithm;
            Provider[] providers = Security.getProviders();
            int ps = providers.length;
            for (int i = 0; i < ps; ++i) {
                logger.debug("LogFile: provider " + i + "= " + providers[i].getName());
            }
            CryptoManager cm = CryptoManager.getInstance();
            X509Certificate cert = cm.findCertByNickname(this.mSAuditCertNickName);
            if (cert != null) {
                logger.debug("LogFile: setupSignig(): found cert:" + this.mSAuditCertNickName);
            } else {
                logger.warn("LogFile: setupSignig(): cert not found:" + this.mSAuditCertNickName);
            }
            this.mSigningKey = cm.findPrivKeyByCert(cert);
            if (this.mSigningKey.getAlgorithm().equalsIgnoreCase("RSA")) {
                sigAlgorithm = "SHA-256/RSA";
            } else if (this.mSigningKey.getAlgorithm().equalsIgnoreCase("EC")) {
                sigAlgorithm = "SHA-256/EC";
            } else {
                throw new NoSuchAlgorithmException("Unknown private key type");
            }
            CryptoToken savedToken = cm.getThreadToken();
            try {
                CryptoToken keyToken = ((PK11PrivKey)this.mSigningKey).getOwningToken();
                cm.setThreadToken(keyToken);
                this.mSignature = Signature.getInstance(sigAlgorithm, CRYPTO_PROVIDER);
            }
            finally {
                cm.setThreadToken(savedToken);
            }
            this.mSignature.initSign(this.mSigningKey);
            String entry = LogFile.getLastSignature(this.mFile);
            if (entry != null) {
                this.mSignature.update(entry.getBytes("UTF-8"));
                this.mSignature.update((byte)10);
            }
            this.pushSignature();
        }
        catch (NotInitializedException nie) {
            this.setupSigningFailure("BASE_CRYPTOMANAGER_UNINITIALIZED", (Exception)((Object)nie));
        }
        catch (ObjectNotFoundException onfe) {
            this.setupSigningFailure("LOG_SIGNING_CERT_NOT_FOUND", (Exception)((Object)onfe));
        }
        catch (TokenException te) {
            this.setupSigningFailure("BASE_TOKEN_ERROR_0", (Exception)((Object)te));
        }
        catch (NoSuchAlgorithmException nsae) {
            this.setupSigningFailure("LOG_NO_SUCH_ALGORITHM_0", nsae);
        }
        catch (NoSuchProviderException nspe) {
            this.setupSigningFailure("BASE_PROVIDER_NOT_SUPPORTED", nspe);
        }
        catch (InvalidKeyException ike) {
            this.setupSigningFailure("BASE_INVALID_KEY", ike);
        }
        catch (SignatureException se) {
            this.setupSigningFailure("LOG_SIGNING_OP_FAILED", se);
        }
        catch (UnsupportedEncodingException uee) {
            this.setupSigningFailure("LOG_UNEXPECTED_EXCEPTION", uee);
        }
        catch (IOException ioe) {
            this.setupSigningFailure("LOG_UNEXPECTED_EXCEPTION", ioe);
        }
        catch (Exception e) {
            this.setupSigningFailure("LOG_UNEXPECTED_EXCEPTION", e);
        }
    }

    private void setupSigningFailure(String logMessageCode, Exception e) throws EBaseException {
        try {
            System.err.println(CMS.getLogMessage(logMessageCode, new Object[0]));
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        e.printStackTrace();
        this.shutdownCMS();
        throw new EBaseException(e.toString());
    }

    @Override
    public void startup() throws EBaseException {
    }

    public String getType() {
        return this.mType;
    }

    public String getOn() {
        return String.valueOf(this.mOn);
    }

    public long getLevel() {
        return this.mLevel;
    }

    public String getName() {
        return this.mFileName;
    }

    private void pushSignature() throws IOException, ELogException, SignatureException, InvalidKeyException {
        byte[] sigBytes = null;
        if (this.mSignature == null) {
            return;
        }
        Auditor auditor = this.engine.getAuditor();
        sigBytes = this.mSignature.sign();
        this.mSignature.initSign(this.mSigningKey);
        Object[] o = new Object[]{null};
        String auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_AUDIT_LOG_SIGNING_3", "$System$", "Success", LogFile.base64Encode(sigBytes));
        LogEvent ev = auditor.create(6, auditMessage, o, false);
        this.doLog(ev, true);
    }

    private static String getLastSignature(File f) throws IOException {
        try (BufferedReader r = new BufferedReader(new FileReader(f));){
            String lastSig = null;
            String curLine = null;
            while ((curLine = r.readLine()) != null) {
                if (curLine.indexOf("AUDIT_LOG_SIGNING") == -1) continue;
                lastSig = curLine;
            }
            String string = lastSig;
            return string;
        }
    }

    protected synchronized void open() throws IOException {
        try {
            RandomAccessFile out = new RandomAccessFile(this.mFile, "rw");
            out.seek(out.length());
            this.mBytesWritten = (int)out.length();
            if (!Utils.isNT()) {
                try {
                    Utils.exec((String)("chmod 00640 " + this.mFile.getCanonicalPath()));
                }
                catch (IOException e) {
                    String message = "Unable to change file permissions on " + this.mFile + ": " + e.getMessage();
                    logger.warn(message, (Throwable)e);
                }
            }
            this.mLogWriter = new BufferedWriter(new FileWriter(out.getFD()), this.mBufferSize);
            if (this.mLogSigning && this.mSignature != null) {
                this.pushSignature();
            }
        }
        catch (ELogException e) {
            String message = CMS.getUserMessage("CMS_LOG_ILLEGALARGUMENT", this.mFileName);
            logger.warn("LogFile: " + message + ": " + e.getMessage(), (Throwable)e);
            System.err.println(message);
        }
        catch (IllegalArgumentException iae) {
            String message = CMS.getUserMessage("CMS_LOG_ILLEGALARGUMENT", this.mFileName);
            logger.warn("LogFile: " + message + ": " + iae.getMessage(), (Throwable)iae);
            System.err.println(message);
        }
        catch (GeneralSecurityException gse) {
            String message = CMS.getUserMessage("CMS_LOG_OPEN_FAILED", this.mFileName, gse.getMessage());
            logger.error("LogFile: " + message, (Throwable)gse);
            System.err.println(message);
            gse.printStackTrace();
            this.shutdownCMS();
        }
        this.mBytesUnflushed = 0;
    }

    @Override
    public synchronized void flush() {
        block4: {
            try {
                if (this.mLogSigning) {
                    this.pushSignature();
                }
                if (this.mLogWriter != null) {
                    this.mLogWriter.flush();
                }
            }
            catch (Exception e) {
                String message = CMS.getUserMessage("CMS_LOG_FLUSH_LOG_FAILED", this.mFileName, e.getMessage());
                logger.error("LogFile: " + message, (Throwable)e);
                System.err.println(message);
                if (!this.mLogSigning) break block4;
                e.printStackTrace();
                this.shutdownCMS();
            }
        }
        this.mBytesUnflushed = 0;
    }

    protected synchronized void close() {
        try {
            this.flush();
            if (this.mLogWriter != null) {
                this.mLogWriter.close();
            }
        }
        catch (IOException e) {
            System.err.println(CMS.getUserMessage("CMS_LOG_CLOSE_FAILED", this.mFileName, e.toString()));
        }
        this.mLogWriter = null;
    }

    @Override
    public synchronized void shutdown() {
        logger.info("Destroying LogFile(" + this.mFileName + ")");
        Auditor auditor = this.engine.getAuditor();
        String auditMessage = null;
        this.setFlushInterval(0);
        auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_AUDIT_LOG_SHUTDOWN_2", "$System$", "Success");
        auditor.log(auditMessage);
        this.close();
    }

    public synchronized void setFlushInterval(int flushInterval) {
        this.mFlushInterval = flushInterval * 1000;
        if (this.mFlushThread == null && this.mFlushInterval > 0) {
            this.mFlushThread = new FlushThread();
            this.mFlushThread.setDaemon(true);
            this.mFlushThread.start();
        } else if (this.mFlushThread != null && this.mFlushInterval == 0) {
            this.mFlushThread.interrupt();
        }
        this.notify();
    }

    protected synchronized void doLog(LogEvent event) throws ELogException {
        this.doLog(event, false);
    }

    private synchronized void doLog(LogEvent event, boolean noFlush) throws ELogException {
        String entry;
        block18: {
            entry = this.logEvt2String(event);
            if (this.mLogWriter == null) {
                String[] params = new String[]{this.mFileName, entry};
                String message = CMS.getUserMessage("CMS_LOG_LOGFILE_CLOSED", params);
                logger.error("LogFile: " + message);
                System.err.println(message);
                if (this.mLogSigning) {
                    this.shutdownCMS();
                }
                throw new ELogException(message);
            }
            try {
                this.mLogWriter.write(entry, 0, entry.length());
                if (this.mLogSigning) {
                    if (this.mSignature != null) {
                        this.mSignature.update(entry.getBytes("UTF-8"));
                    } else {
                        logger.warn("LogFile: missing audit log signature");
                    }
                }
                if (this.mTrace) {
                    CharArrayWriter cw = new CharArrayWriter(200);
                    PrintWriter pw = new PrintWriter(cw);
                    Exception e = new Exception();
                    e.printStackTrace(pw);
                    char[] c = cw.toCharArray();
                    cw.close();
                    pw.close();
                    CharArrayReader cr = new CharArrayReader(c);
                    LineNumberReader lr = new LineNumberReader(cr);
                    String text = null;
                    String method = null;
                    String fileAndLine = null;
                    if (lr.ready()) {
                        text = lr.readLine();
                        while ((text = lr.readLine()).indexOf("logging") != -1) {
                        }
                        int p = text.indexOf("(");
                        fileAndLine = text.substring(p);
                        String classandmethod = text.substring(0, p);
                        int q = classandmethod.lastIndexOf(".");
                        method = classandmethod.substring(q + 1);
                        this.mLogWriter.write(fileAndLine, 0, fileAndLine.length());
                        this.mLogWriter.write(" ", 0, " ".length());
                        this.mLogWriter.write(method, 0, method.length());
                    }
                }
                this.mLogWriter.newLine();
                if (this.mLogSigning) {
                    if (this.mSignature != null) {
                        this.mSignature.update((byte)10);
                    } else {
                        logger.warn("LogFile: missing audit log signature");
                    }
                }
            }
            catch (IOException e) {
                String message = CMS.getUserMessage("CMS_LOG_WRITE_FAILED", this.mFileName, entry, e.getMessage());
                logger.error("LogFile: " + message);
                System.err.println(message);
                if (this.mLogSigning) {
                    e.printStackTrace();
                    this.shutdownCMS();
                }
            }
            catch (IllegalStateException e) {
                String message = CMS.getLogMessage(LOG_SIGNED_AUDIT_EXCEPTION, e.getMessage());
                logger.error("LogFile: " + message, (Throwable)e);
                System.err.println(Thread.currentThread().getName() + ": " + message);
            }
            catch (GeneralSecurityException gse) {
                String message = CMS.getLogMessage(LOG_SIGNED_AUDIT_EXCEPTION, gse.getMessage());
                logger.error("LogFile: " + message, (Throwable)gse);
                System.err.println(Thread.currentThread().getName() + ": " + message);
            }
            catch (Exception ee) {
                String message = CMS.getLogMessage(LOG_SIGNED_AUDIT_EXCEPTION, ee.getMessage());
                logger.error("LogFile: " + message, (Throwable)ee);
                System.err.println(Thread.currentThread().getName() + ": " + message);
                if (!this.mLogSigning) break block18;
                ee.printStackTrace();
                this.shutdownCMS();
            }
        }
        int nBytes = entry.length() + 1;
        this.mBytesWritten += nBytes;
        this.mBytesUnflushed += nBytes;
        if (this.mBufferSize > 0 && this.mBytesUnflushed > this.mBufferSize && !noFlush) {
            this.flush();
        }
    }

    @Override
    public void log(LogEvent ev) throws ELogException {
        if (!this.mOn || this.mLevel > (long)ev.getLevel()) {
            return;
        }
        if (ev instanceof AuditEvent && !this.mType.equals("transaction")) {
            return;
        }
        if (ev instanceof SignedAuditEvent && !this.mType.equals("signedAudit")) {
            return;
        }
        String type = ev.getEventType();
        if (type == null) {
            this.doLog(ev);
            return;
        }
        if (this.selectedEvents.isEmpty()) {
            this.filter((SignedAuditEvent)ev);
            return;
        }
        if (this.mandatoryEvents.contains(type) || this.selectedEvents.contains(type)) {
            this.filter((SignedAuditEvent)ev);
            return;
        }
        logger.debug("LogFile: event type not selected: " + type);
    }

    public void filter(SignedAuditEvent ev) throws ELogException {
        String type = ev.getEventType();
        JDAPFilter filter = this.filters.get(type);
        if (filter == null) {
            this.doLog(ev);
            return;
        }
        try {
            boolean result = this.eval(ev, filter);
            if (!result) {
                return;
            }
        }
        catch (Exception e) {
            throw new ELogException(e.getMessage(), e);
        }
        this.doLog(ev);
    }

    public boolean eval(SignedAuditEvent event, JDAPFilter filter) {
        if (filter instanceof JDAPFilterPresent) {
            return this.eval(event, (JDAPFilterPresent)filter);
        }
        if (filter instanceof JDAPFilterEqualityMatch) {
            return this.eval(event, (JDAPFilterEqualityMatch)filter);
        }
        if (filter instanceof JDAPFilterSubString) {
            return this.eval(event, (JDAPFilterSubString)filter);
        }
        if (filter instanceof JDAPFilterAnd) {
            return this.eval(event, (JDAPFilterAnd)filter);
        }
        if (filter instanceof JDAPFilterOr) {
            return this.eval(event, (JDAPFilterOr)filter);
        }
        if (filter instanceof JDAPFilterNot) {
            return this.eval(event, (JDAPFilterNot)filter);
        }
        return false;
    }

    public boolean eval(SignedAuditEvent event, JDAPFilterPresent filter) {
        String name = filter.getType();
        Object attr = event.getAttribute(name);
        return attr != null;
    }

    public boolean eval(SignedAuditEvent event, JDAPFilterEqualityMatch filter) {
        JDAPAVA ava = filter.getAVA();
        String name = ava.getType();
        String value = ava.getValue();
        Object attr = event.getAttribute(name);
        if (attr == null) {
            return false;
        }
        if (!(attr instanceof String)) {
            return false;
        }
        String stringAttr = (String)attr;
        return value.equalsIgnoreCase(stringAttr);
    }

    public boolean eval(SignedAuditEvent event, JDAPFilterSubString filter) {
        String name = filter.getType();
        Object attr = event.getAttribute(name);
        if (attr == null) {
            return false;
        }
        if (!(attr instanceof String)) {
            return false;
        }
        String stringAttr = ((String)attr).toLowerCase();
        String initialSubstring = filter.getInitialSubstring();
        if (initialSubstring != null) {
            if (!stringAttr.startsWith(initialSubstring.toLowerCase())) {
                return false;
            }
            stringAttr = stringAttr.substring(initialSubstring.length());
        }
        for (String anySubstring : filter.getAnySubstrings()) {
            int p = stringAttr.indexOf(anySubstring.toLowerCase());
            if (p < 0) {
                return false;
            }
            stringAttr = stringAttr.substring(p + anySubstring.length());
        }
        String finalSubstring = filter.getFinalSubstring();
        return finalSubstring == null || stringAttr.endsWith(finalSubstring.toLowerCase());
    }

    public boolean eval(SignedAuditEvent event, JDAPFilterAnd filter) {
        for (JDAPFilter f : filter.getFilters()) {
            if (this.eval(event, f)) continue;
            return false;
        }
        return true;
    }

    public boolean eval(SignedAuditEvent event, JDAPFilterOr filter) {
        for (JDAPFilter f : filter.getFilters()) {
            if (!this.eval(event, f)) continue;
            return true;
        }
        return false;
    }

    public boolean eval(SignedAuditEvent event, JDAPFilterNot filter) {
        JDAPFilter f = filter.getFilter();
        return !this.eval(event, f);
    }

    public String logEvt2String(LogEvent ev) {
        String entry = null;
        this.mDate.setTime(ev.getTimeStamp());
        entry = ev.getMultiline() ? this.engine.getPID() + "." + Thread.currentThread().getName() + " - [" + this.mLogDateFormat.format(this.mDate) + "] [" + ev.getSource().value() + "] [" + Integer.toString(ev.getLevel()) + "] " + this.prepareMultiline(ev.toString()) : this.engine.getPID() + "." + Thread.currentThread().getName() + " - [" + this.mLogDateFormat.format(this.mDate) + "] [" + ev.getSource().value() + "] [" + Integer.toString(ev.getLevel()) + "] " + ev.toString();
        return entry;
    }

    private String prepareMultiline(String original) {
        int i;
        int last = 0;
        while ((i = ((String)original).indexOf("\n", last)) != -1) {
            last = i + 1;
            original = ((String)original).substring(0, i + 1) + " " + ((String)original).substring(i + 1);
        }
        return original;
    }

    public Vector<LogEntry> readEntry(int maxLine, int lowLevel, LogSource source, String fName) {
        Vector<LogEntry> mEntries = new Vector<LogEntry>();
        String fileName = this.mFileName;
        int lineNo = 0;
        int line = 0;
        Object firstLine = null;
        String nextLine = null;
        String entry = null;
        LogEntry logEntry = null;
        LogEntry preLogEntry = null;
        if (fName != null) {
            fileName = fName;
        }
        try {
            BufferedReader fBuffer = new BufferedReader(new FileReader(fileName));
            do {
                try {
                    nextLine = fBuffer.readLine();
                    if (nextLine != null) {
                        if (nextLine.length() == 0 || nextLine.charAt(0) == ' ') {
                            entry = null;
                            firstLine = nextLine.length() > 1 ? (String)firstLine + "\n" + nextLine.substring(1) : firstLine + "\n";
                        } else {
                            entry = firstLine;
                            firstLine = nextLine;
                        }
                        if (entry != null) {
                            try {
                                logEntry = new LogEntry(entry);
                                if (preLogEntry != null && Integer.parseInt(preLogEntry.getLevel()) >= lowLevel && (Integer.parseInt(preLogEntry.getSource()) == source.value() || source == ILogger.S_ALL)) {
                                    mEntries.addElement(preLogEntry);
                                    if (maxLine == -1) {
                                        ++line;
                                    } else if (line < maxLine) {
                                        ++line;
                                    } else {
                                        mEntries.removeElementAt(0);
                                    }
                                }
                                preLogEntry = logEntry;
                            }
                            catch (ParseException e) {
                                if (preLogEntry != null) {
                                    preLogEntry.appendDetail(entry);
                                } else {
                                    firstLine = (String)firstLine + "\n" + nextLine;
                                }
                                entry = null;
                                logEntry = null;
                            }
                        }
                    }
                    ++lineNo;
                }
                catch (IOException e) {
                    logger.warn(CMS.getLogMessage("LOGGING_READ_ERROR", fileName, Integer.toString(lineNo)), (Throwable)e);
                }
            } while (nextLine != null);
            if (firstLine != null) {
                if (logEntry != null) {
                    preLogEntry = logEntry;
                }
                entry = firstLine;
                try {
                    logEntry = new LogEntry(entry);
                    if (preLogEntry != null && Integer.parseInt(preLogEntry.getLevel()) >= lowLevel && (Integer.parseInt(preLogEntry.getSource()) == source.value() || source == ILogger.S_ALL)) {
                        mEntries.addElement(preLogEntry);
                        if (maxLine == -1) {
                            ++line;
                        } else if (line < maxLine) {
                            ++line;
                        } else {
                            mEntries.removeElementAt(0);
                        }
                    }
                    preLogEntry = logEntry;
                }
                catch (ParseException e) {
                    preLogEntry.appendDetail(entry);
                }
                if (preLogEntry != null && Integer.parseInt(preLogEntry.getLevel()) >= lowLevel && (Integer.parseInt(preLogEntry.getSource()) == source.value() || source == ILogger.S_ALL)) {
                    mEntries.addElement(preLogEntry);
                    if (maxLine == -1) {
                        ++line;
                    } else if (line < maxLine) {
                        ++line;
                    } else {
                        mEntries.removeElementAt(0);
                    }
                }
            }
            try {
                fBuffer.close();
            }
            catch (IOException e) {
                logger.warn("logging:" + fileName + " failed to close for reading", (Throwable)e);
            }
        }
        catch (FileNotFoundException e) {
            logger.warn(CMS.getLogMessage("LOGGING_FILE_NOT_FOUND", fileName), (Throwable)e);
        }
        return mEntries;
    }

    @Override
    public ConfigStore getConfigStore() {
        return this.mConfig;
    }

    @Override
    public synchronized NameValuePairs retrieveLogContent(Hashtable<String, String> req) throws ServletException, IOException, EBaseException {
        NameValuePairs params = new NameValuePairs();
        String fName = null;
        int maxLine = -1;
        int level = -1;
        LogSource source = null;
        Vector<LogEntry> entries = null;
        String tmp = req.get("maxentry");
        if (tmp != null) {
            maxLine = Integer.parseInt(tmp);
        }
        if ((tmp = req.get("level")) != null) {
            level = Integer.parseInt(tmp);
        }
        if ((tmp = req.get("source")) != null) {
            source = LogSource.valueOf((int)Integer.parseInt(tmp));
        }
        if (!(tmp = req.get("logname")).equals("current")) {
            fName = tmp;
        } else {
            this.flush();
        }
        try {
            entries = this.readEntry(maxLine, level, source, fName);
            for (int i = 0; i < entries.size(); ++i) {
                params.put((Object)(Integer.toString(i) + entries.elementAt(i).getEntry()), (Object)"");
            }
        }
        catch (Exception e) {
            logger.warn("System log parse error: " + e.getMessage(), (Throwable)e);
        }
        return params;
    }

    @Override
    public synchronized NameValuePairs retrieveLogList(Hashtable<String, String> req) throws ServletException, IOException, EBaseException {
        return null;
    }

    @Override
    public String getImplName() {
        return "LogFile";
    }

    @Override
    public String getDescription() {
        return "LogFile";
    }

    @Override
    public Vector<String> getDefaultParams() {
        Vector<String> v = new Vector<String>();
        v.addElement("type=");
        v.addElement("enable=");
        v.addElement("level=");
        v.addElement("fileName=");
        v.addElement("bufferSize=");
        v.addElement("flushInterval=");
        v.addElement("logSigning=");
        v.addElement("signedAuditCertNickname=");
        v.addElement("mandatory.events=");
        v.addElement("events=");
        return v;
    }

    @Override
    public Vector<String> getInstanceParams() {
        Vector<String> v = new Vector<String>();
        try {
            if (this.mType == null) {
                v.addElement("type=");
            } else {
                v.addElement("type=" + this.mConfig.getString("type"));
            }
            v.addElement("enable=" + String.valueOf(this.mOn));
            if (this.mLevel == 0L) {
                v.addElement("level=Debug");
            } else if (this.mLevel == 1L) {
                v.addElement("level=Information");
            } else if (this.mLevel == 2L) {
                v.addElement("level=Warning");
            } else if (this.mLevel == 3L) {
                v.addElement("level=Failure");
            } else if (this.mLevel == 4L) {
                v.addElement("level=Misconfiguration");
            } else if (this.mLevel == 5L) {
                v.addElement("level=Catastrophe");
            } else if (this.mLevel == 6L) {
                v.addElement("level=Security");
            }
            if (this.mFileName == null) {
                v.addElement("fileName=");
            } else {
                v.addElement("fileName=" + this.mFileName);
            }
            v.addElement("bufferSize=" + this.mBufferSize);
            v.addElement("flushInterval=" + this.mFlushInterval / 1000);
            if (this.mType != null && this.mType.equals("signedAudit")) {
                v.addElement("logSigning=" + String.valueOf(this.mLogSigning));
                if (this.mSAuditCertNickName == null) {
                    v.addElement("signedAuditCertNickname=");
                } else {
                    v.addElement("signedAuditCertNickname=" + this.mSAuditCertNickName);
                }
                v.addElement("mandatory.events=" + StringUtils.join(this.mandatoryEvents, (String)","));
                v.addElement("events=" + StringUtils.join(this.selectedEvents, (String)","));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return v;
    }

    public String[] getExtendedPluginInfo() {
        if (this.mType.equals("signedAudit")) {
            String[] params = new String[]{"type;choice(transaction,signedAudit,system);The log event type this instance is listening to", "enable;boolean;Turn on the listener", "level;choice(Debug,Information,Warning,Failure,Misconfiguration,Catastrophe,Security);Only log message with level higher than this filter will be written by this listener", "fileName;string;The name of the file the log is written to", "bufferSize;integer;The size of the buffer to receive log messages in kilobytes(KB)", "flushInterval;integer;The maximum time in seconds before the buffer is flushed to the file", "HELP_TOKEN;configuration-logrules-logfile", "HELP_TEXT;Write the log messages to a file", "logSigning;boolean;Enable audit logs to be signed", "signedAuditCertNickname;string;The nickname of the certificate to be used to sign audit logs", "mandatory.events;string;A comma-separated list of strings used to specify mandatory signed audit log events", "events;string;A comma-separated list of strings used to specify selected signed audit log events"};
            return params;
        }
        String[] params = new String[]{"type;choice(transaction,signedAudit,system);The log event type this instance is listening to", "enable;boolean;Turn on the listener", "level;choice(Debug,Information,Warning,Failure,Misconfiguration,Catastrophe,Security);Only log message with level higher than this filter will be written by this listener", "fileName;string;The name of the file the log is written to", "bufferSize;integer;The size of the buffer to receive log messages in kilobytes(KB)", "flushInterval;integer;The maximum time in seconds before the buffer is flushed to the file", "HELP_TOKEN;configuration-logrules-logfile", "HELP_TEXT;Write the log messages to a file"};
        return params;
    }

    final class FlushThread
    extends Thread {
        public FlushThread() {
            super.setName(LogFile.this.mFileName + ".flush-" + (Thread.activeCount() + 1));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (LogFile.this.mFlushInterval > 0) {
                LogFile logFile = LogFile.this;
                synchronized (logFile) {
                    try {
                        LogFile.this.wait(LogFile.this.mFlushInterval);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (LogFile.this.mFlushInterval == 0) break;
                if (LogFile.this.mBytesUnflushed <= 0) continue;
                LogFile.this.flush();
            }
            LogFile.this.mFlushThread = null;
        }
    }
}

