/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.authentication;

import com.netscape.certsrv.authentication.AuthCredentials;
import com.netscape.certsrv.authentication.AuthMgrPlugin;
import com.netscape.certsrv.authentication.EAuthException;
import com.netscape.certsrv.authentication.EAuthMgrNotFound;
import com.netscape.certsrv.authentication.EAuthMgrPluginNotFound;
import com.netscape.certsrv.authentication.EInvalidCredentials;
import com.netscape.certsrv.authentication.EMissingCredential;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.Subsystem;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.authentication.CertUserDBAuthentication;
import com.netscape.cmscore.authentication.PasswdUserDBAuthentication;
import com.netscape.cmscore.base.ConfigStore;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.dogtagpki.server.authentication.AuthManager;
import org.dogtagpki.server.authentication.AuthManagerConfig;
import org.dogtagpki.server.authentication.AuthManagerProxy;
import org.dogtagpki.server.authentication.AuthManagersConfig;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authentication.AuthenticationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthSubsystem
extends Subsystem {
    public static Logger logger = LoggerFactory.getLogger(AuthSubsystem.class);
    public static final String ID = "auths";
    public static final String PROP_CLASS = "class";
    public static final String PROP_IMPL = "impl";
    public static final String PROP_PLUGIN = "pluginName";
    public static final String PASSWDUSERDB_PLUGIN_ID = "passwdUserDBAuthPlugin";
    public static final String CERTUSERDB_PLUGIN_ID = "certUserDBAuthPlugin";
    public static final String NULL_PLUGIN_ID = "nullAuthPlugin";
    public static final String PASSWDUSERDB_AUTHMGR_ID = "passwdUserDBAuthMgr";
    public static final String CERTUSERDB_AUTHMGR_ID = "certUserDBAuthMgr";
    public static final String NULL_AUTHMGR_ID = "nullAuthMgr";
    public Hashtable<String, AuthMgrPlugin> mAuthMgrPlugins = new Hashtable();
    public Hashtable<String, AuthManagerProxy> mAuthMgrInsts = new Hashtable();
    private String mId = "auths";
    protected AuthenticationConfig mConfig;

    public void loadAuthManagerPlugins() throws EBaseException {
        logger.info("AuthSubsystem: Loading auth manager plugin passwdUserDBAuthPlugin");
        AuthMgrPlugin plugin = new AuthMgrPlugin(PASSWDUSERDB_PLUGIN_ID, PasswdUserDBAuthentication.class.getName());
        plugin.setVisible(false);
        this.mAuthMgrPlugins.put(PASSWDUSERDB_PLUGIN_ID, plugin);
        logger.info("AuthSubsystem: Loading auth manager plugin certUserDBAuthPlugin");
        plugin = new AuthMgrPlugin(CERTUSERDB_PLUGIN_ID, CertUserDBAuthentication.class.getName());
        plugin.setVisible(false);
        this.mAuthMgrPlugins.put(CERTUSERDB_PLUGIN_ID, plugin);
        ConfigStore c = this.mConfig.getSubStore(PROP_IMPL, ConfigStore.class);
        Enumeration<String> pluginIDs = c.getSubStoreNames().elements();
        while (pluginIDs.hasMoreElements()) {
            String pluginID = pluginIDs.nextElement();
            logger.info("AuthSubsystem: Loading auth manager plugin " + pluginID);
            String pluginPath = c.getString(pluginID + ".class");
            plugin = new AuthMgrPlugin(pluginID, pluginPath);
            this.mAuthMgrPlugins.put(pluginID, plugin);
        }
    }

    public void loadAuthManagerInstances() throws EBaseException {
        logger.info("AuthSubsystem: Loading auth manager instance passwdUserDBAuthMgr");
        PasswdUserDBAuthentication passwdUserDBAuth = new PasswdUserDBAuthentication();
        passwdUserDBAuth.setCMSEngine(this.engine);
        passwdUserDBAuth.init(this.mConfig, PASSWDUSERDB_AUTHMGR_ID, PASSWDUSERDB_PLUGIN_ID, null);
        this.mAuthMgrInsts.put(PASSWDUSERDB_AUTHMGR_ID, new AuthManagerProxy(true, passwdUserDBAuth));
        logger.info("AuthSubsystem: Loading auth manager instance certUserDBAuthMgr");
        CertUserDBAuthentication certUserDBAuth = new CertUserDBAuthentication();
        certUserDBAuth.setCMSEngine(this.engine);
        certUserDBAuth.init(this.mConfig, CERTUSERDB_AUTHMGR_ID, CERTUSERDB_PLUGIN_ID, null);
        this.mAuthMgrInsts.put(CERTUSERDB_AUTHMGR_ID, new AuthManagerProxy(true, certUserDBAuth));
        AuthManagersConfig instancesConfig = this.mConfig.getAuthManagersConfig();
        Enumeration<String> instNames = instancesConfig.getSubStoreNames().elements();
        while (instNames.hasMoreElements()) {
            String message;
            String instName = instNames.nextElement();
            logger.info("AuthSubsystem: Loading auth manager instance " + instName);
            AuthManagerConfig authMgrConfig = instancesConfig.getAuthManagerConfig(instName);
            String implName = authMgrConfig.getString(PROP_PLUGIN);
            AuthMgrPlugin plugin = this.mAuthMgrPlugins.get(implName);
            if (plugin == null) {
                logger.error("AuthSubsystem: " + CMS.getLogMessage("CMSCORE_AUTH_CANT_FIND_PLUGIN", implName));
                throw new EAuthMgrPluginNotFound(CMS.getUserMessage("CMS_AUTHENTICATION_AUTHMGR_NOT_FOUND", implName));
            }
            String className = plugin.getClassPath();
            boolean enabled = false;
            AuthManager authMgrInst = null;
            try {
                authMgrInst = (AuthManager)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                authMgrInst.setCMSEngine(this.engine);
                authMgrInst.init(this.mConfig, instName, implName, authMgrConfig);
                enabled = true;
            }
            catch (ClassNotFoundException e) {
                logger.error("AuthSubsystem: " + CMS.getLogMessage("CMSCORE_AUTH_AUTHSUB_ERROR", e.toString()));
                throw new EAuthException(CMS.getUserMessage("CMS_ACL_CLASS_LOAD_FAIL", className), (Exception)e);
            }
            catch (IllegalAccessException e) {
                logger.error("AuthSubsystem: " + CMS.getLogMessage("CMSCORE_AUTH_AUTHSUB_ERROR", e.toString()));
                throw new EAuthException(CMS.getUserMessage("CMS_ACL_CLASS_LOAD_FAIL", className), (Exception)e);
            }
            catch (InstantiationException e) {
                logger.error("AuthSubsystem: " + CMS.getLogMessage("CMSCORE_AUTH_AUTHSUB_ERROR", e.toString()));
                throw new EAuthException(CMS.getUserMessage("CMS_ACL_CLASS_LOAD_FAIL", className), (Exception)e);
            }
            catch (EBaseException e) {
                message = CMS.getLogMessage("CMSCORE_AUTH_AUTH_INIT_ERROR", instName, e.toString());
                logger.warn("AuthSubsystem: " + message, (Throwable)e);
            }
            catch (Throwable e) {
                message = CMS.getLogMessage("CMSCORE_AUTH_AUTH_INIT_ERROR", instName, e.toString());
                logger.warn("AuthSubsystem: " + message, e);
            }
            this.mAuthMgrInsts.put(instName, new AuthManagerProxy(enabled, authMgrInst));
        }
    }

    @Override
    public void init(ConfigStore config) throws Exception {
        EngineConfig engineConfig = this.engine.getConfig();
        try {
            this.mConfig = engineConfig.getAuthenticationConfig();
            this.loadAuthManagerPlugins();
            this.loadAuthManagerInstances();
        }
        catch (EBaseException e) {
            logger.error("Unable to initialize AuthSubsystem: " + e.getMessage(), (Throwable)e);
            if (this.engine.isPreOpMode()) {
                logger.warn("AuthSubsystem.init(): Swallow exception in pre-op mode");
                return;
            }
            throw e;
        }
    }

    public AuthToken authenticate(AuthCredentials authCred, String authMgrInstName) throws EMissingCredential, EInvalidCredentials, EAuthMgrNotFound, EBaseException {
        AuthManagerProxy proxy = this.mAuthMgrInsts.get(authMgrInstName);
        if (proxy == null) {
            throw new EAuthMgrNotFound(CMS.getUserMessage("CMS_AUTHENTICATION_AUTHMGR_NOT_FOUND", authMgrInstName));
        }
        if (!proxy.isEnable()) {
            throw new EAuthMgrNotFound(CMS.getUserMessage("CMS_AUTHENTICATION_AUTHMGR_NOT_FOUND", authMgrInstName));
        }
        AuthManager authMgrInst = proxy.getAuthManager();
        if (authMgrInst == null) {
            throw new EAuthMgrNotFound(CMS.getUserMessage("CMS_AUTHENTICATION_AUTHMGR_NOT_FOUND", authMgrInstName));
        }
        return authMgrInst.authenticate(authCred);
    }

    public String[] getRequiredCreds(String authMgrInstName) throws EAuthMgrNotFound {
        AuthManager authMgrInst = this.get(authMgrInstName);
        if (authMgrInst == null) {
            throw new EAuthMgrNotFound(CMS.getUserMessage("CMS_AUTHENTICATION_AUTHMGR_NOT_FOUND", authMgrInstName));
        }
        return authMgrInst.getRequiredCreds();
    }

    public String[] getConfigParams(String implName) throws EAuthMgrPluginNotFound, EBaseException {
        AuthMgrPlugin plugin = this.mAuthMgrPlugins.get(implName);
        if (plugin == null) {
            logger.error("AuthSubsystem: " + CMS.getLogMessage("CMSCORE_AUTH_PLUGIN_NOT_FOUND", implName));
            throw new EAuthMgrPluginNotFound(CMS.getUserMessage("CMS_AUTHENTICATION_AUTHMGR_NOT_FOUND", implName));
        }
        AuthManager authMgrInst = null;
        String className = plugin.getClassPath();
        try {
            authMgrInst = (AuthManager)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return authMgrInst.getConfigParams();
        }
        catch (Exception e) {
            logger.error("AuthSubsystem: " + CMS.getLogMessage("CMSCORE_AUTH_INSTANCE_NOT_CREATED", e.toString()), (Throwable)e);
            throw new EAuthException(CMS.getUserMessage("CMS_ACL_CLASS_LOAD_FAIL", className), e);
        }
    }

    public void add(String name, AuthManager authMgrInst) {
        this.mAuthMgrInsts.put(name, new AuthManagerProxy(true, authMgrInst));
    }

    public void delete(String name) {
        this.mAuthMgrInsts.remove(name);
    }

    public AuthManager get(String name) {
        AuthManagerProxy proxy = this.mAuthMgrInsts.get(name);
        if (proxy == null) {
            return null;
        }
        return proxy.getAuthManager();
    }

    public Enumeration<AuthManager> getAuthManagers() {
        Vector<AuthManager> inst = new Vector<AuthManager>();
        Enumeration<String> e = this.mAuthMgrInsts.keys();
        while (e.hasMoreElements()) {
            AuthManager p = this.get(e.nextElement());
            if (p == null) continue;
            inst.addElement(p);
        }
        return inst.elements();
    }

    public Enumeration<AuthMgrPlugin> getAuthManagerPlugins() {
        return this.mAuthMgrPlugins.elements();
    }

    public AuthMgrPlugin getAuthManagerPluginImpl(String name) {
        return this.mAuthMgrPlugins.get(name);
    }

    public AuthManager getAuthManagerPlugin(String name) {
        AuthMgrPlugin plugin = this.mAuthMgrPlugins.get(name);
        String classpath = plugin.getClassPath();
        AuthManager authMgrInst = null;
        try {
            authMgrInst = (AuthManager)Class.forName(classpath).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return authMgrInst;
        }
        catch (Exception e) {
            logger.warn("AuthSubsystem: " + CMS.getLogMessage("CMSCORE_AUTH_INSTANCE_NOT_CREATED", e.toString()), (Throwable)e);
            return null;
        }
    }

    @Override
    public String getId() {
        return this.mId;
    }

    @Override
    public void setId(String id) throws EBaseException {
        this.mId = id;
    }

    @Override
    public void startup() throws EBaseException {
    }

    @Override
    public void shutdown() {
        for (AuthManagerProxy proxy : this.mAuthMgrInsts.values()) {
            AuthManager mgr = proxy.getAuthManager();
            logger.info("AuthSubsystem: " + CMS.getLogMessage("CMSCORE_AUTH_INSTANCE_SHUTDOWN", mgr.getName()));
            mgr.shutdown();
        }
        this.mAuthMgrPlugins.clear();
        this.mAuthMgrInsts.clear();
    }

    public Hashtable<String, AuthMgrPlugin> getPlugins() {
        return this.mAuthMgrPlugins;
    }

    public Hashtable<String, AuthManagerProxy> getInstances() {
        return this.mAuthMgrInsts;
    }

    @Override
    public AuthenticationConfig getConfigStore() {
        return this.mConfig;
    }

    public AuthManager getAuthManager(String name) {
        return this.get(name);
    }
}

