/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.logging;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cmscore.base.ConfigStorage;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.base.SimpleProperties;

public class LoggerConfig
extends ConfigStore {
    public static final String TYPE = "type";
    public static final String REGISTER = "register";
    public static final String ENABLE = "enable";
    public static final String TRACE = "trace";
    public static final String LOG_SIGNING = "logSigning";
    public static final String CERT_NICKNAME = "signedAuditCertNickname";
    public static final String SELECTED_EVENTS = "events";
    public static final String MANDATORY_EVENTS = "mandatory.events";
    public static final String FILTERS = "filters";
    public static final String LEVEL = "level";
    public static final String FILE_NAME = "fileName";
    public static final String LAST_HASH_FILE_NAME = "lastHashFileName";
    public static final String BUFFER_SIZE = "bufferSize";
    public static final String FLUSH_INTERVAL = "flushInterval";
    public static final int DEFAULT_BUFFER_SIZE = 512;
    public static final int DEFAULT_FLUSH_INTERVAL = 5;

    public LoggerConfig() {
    }

    public LoggerConfig(ConfigStorage storage) {
        super(storage);
    }

    public LoggerConfig(String name, SimpleProperties source) {
        super(name, source);
    }

    public boolean getEnable() throws EBaseException {
        return this.getBoolean(ENABLE, true);
    }

    public boolean getLogSigning() throws EBaseException {
        return this.getBoolean(LOG_SIGNING, false);
    }

    public String getSignedAuditCertNickname() throws EBaseException {
        return this.getString(CERT_NICKNAME);
    }

    public String getMandatoryEvents() throws EBaseException {
        return this.getString(MANDATORY_EVENTS, "");
    }

    public String getSelectedEvents() throws EBaseException {
        return this.getString(SELECTED_EVENTS, "");
    }

    public ConfigStore getFilters() throws EBaseException {
        return this.getSubStore(FILTERS);
    }

    public boolean getTrace() throws EBaseException {
        return this.getBoolean(TRACE, false);
    }

    public String getType() throws EBaseException {
        return this.getString(TYPE, "system");
    }

    public boolean getRegister() throws EBaseException {
        return this.getBoolean(REGISTER, true);
    }

    public int getLevel() throws EBaseException {
        return this.getInteger(LEVEL, 3);
    }

    public String getFilename(String defaultFilename) throws EBaseException {
        return this.getString(FILE_NAME, defaultFilename);
    }

    public int getBufferSize() throws EBaseException {
        return this.getInteger(BUFFER_SIZE, 512);
    }

    public int getFlushInterval() throws EBaseException {
        return this.getInteger(FLUSH_INTERVAL, 5);
    }
}

