/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.est;

import com.netscape.certsrv.authority.AuthorityClient;
import com.netscape.certsrv.base.BadRequestException;
import com.netscape.certsrv.base.PKIException;
import com.netscape.certsrv.ca.AuthorityID;
import com.netscape.certsrv.ca.CACertClient;
import com.netscape.certsrv.ca.CAClient;
import com.netscape.certsrv.cert.CertData;
import com.netscape.certsrv.cert.CertEnrollmentRequest;
import com.netscape.certsrv.cert.CertRequestInfo;
import com.netscape.certsrv.cert.CertRequestInfos;
import com.netscape.certsrv.cert.CertReviewResponse;
import com.netscape.certsrv.client.ClientConfig;
import com.netscape.certsrv.client.PKIClient;
import com.netscape.certsrv.client.SubsystemClient;
import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.certsrv.profile.ProfileAttribute;
import com.netscape.certsrv.profile.ProfileInput;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.request.RequestStatus;
import java.io.File;
import java.io.FileReader;
import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.Properties;
import javax.ws.rs.core.Response;
import org.dogtagpki.est.ESTBackend;
import org.mozilla.jss.netscape.security.pkcs.PKCS10;
import org.mozilla.jss.netscape.security.pkcs.PKCS7;
import org.mozilla.jss.netscape.security.util.Cert;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.CertificateChain;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DogtagRABackend
extends ESTBackend {
    public static Logger logger = LoggerFactory.getLogger(DogtagRABackend.class);
    private ClientConfig clientConfig = new ClientConfig();
    private String profile;

    @Override
    public void start() throws Throwable {
        String username;
        logger.info("Initializing Dogtag RA backend");
        String url = this.config.getParameter("url");
        logger.info("- URL: " + url);
        this.clientConfig.setServerURL(url);
        String nickname = this.config.getParameter("nickname");
        if (nickname != null) {
            logger.info("- nickname: " + nickname);
            this.clientConfig.setCertNickname(nickname);
        }
        if ((username = this.config.getParameter("username")) != null) {
            logger.info("- username: " + username);
            this.clientConfig.setUsername(username);
        }
        String password = null;
        String passwordFilename = this.config.getParameter("passwordFile");
        if (passwordFilename != null) {
            File passwordFile = new File(passwordFilename);
            logger.info("Loading password file " + passwordFilename);
            Properties props = new Properties();
            try (FileReader reader = new FileReader(passwordFile);){
                props.load(reader);
            }
            password = props.getProperty("password");
            if (password == null) {
                throw new RuntimeException("DogtagRABackend: 'password' property not present in file " + passwordFilename);
            }
        } else {
            password = this.config.getParameter("password");
        }
        if (password != null) {
            this.clientConfig.setPassword(password);
        }
        this.profile = this.config.getParameter("profile");
        if (this.profile == null) {
            throw new RuntimeException("DogtagRABackend: 'password' property missing");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CertificateChain cacerts(Optional<String> label) throws PKIException {
        try (PKIClient pkiClient = new PKIClient(this.clientConfig);){
            AuthorityClient authorityClient = new AuthorityClient(pkiClient, "ca");
            String authorityID = label.orElse("host-authority");
            String pkcs7pem = authorityClient.getChainPEM(authorityID);
            logger.debug("Cert chain:\n" + pkcs7pem);
            PKCS7 pkcs7 = new PKCS7(pkcs7pem);
            X509Certificate[] certs = pkcs7.getCertificates();
            if (certs == null || certs.length == 0) {
                CertificateChain certificateChain = null;
                return certificateChain;
            }
            CertificateChain certificateChain = new CertificateChain(certs);
            return certificateChain;
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new PKIException("Internal error in /cacerts: " + e, e);
        }
    }

    @Override
    public X509CertImpl simpleenroll(Optional<String> label, PKCS10 csr, Object authzData) throws PKIException {
        return this.issueCertificate(label, csr);
    }

    @Override
    public X509CertImpl simplereenroll(Optional<String> label, PKCS10 csr, Object authzData) throws PKIException {
        return this.simpleenroll(label, csr, authzData);
    }

    private X509CertImpl issueCertificate(Optional<String> label, PKCS10 pkcs10) throws PKIException {
        X509CertImpl x509CertImpl;
        logger.info("Issuing certificate");
        AuthorityID aid = null;
        if (label.isPresent()) {
            try {
                aid = new AuthorityID(label.get());
            }
            catch (Throwable e) {
                throw new BadRequestException("Bad AuthorityID: " + label.get(), e);
            }
        }
        PKIClient pkiClient = new PKIClient(this.clientConfig);
        try {
            CAClient caClient = new CAClient(pkiClient);
            caClient.login();
            CACertClient certClient = new CACertClient((SubsystemClient)caClient);
            CertEnrollmentRequest certEnrollmentRequest = certClient.getEnrollmentTemplate(this.profile);
            for (ProfileInput input : certEnrollmentRequest.getInputs()) {
                ProfileAttribute csrAttr;
                ProfileAttribute typeAttr = input.getAttribute("cert_request_type");
                if (typeAttr != null) {
                    typeAttr.setValue("pkcs10");
                }
                if ((csrAttr = input.getAttribute("cert_request")) == null) continue;
                csrAttr.setValue(Utils.base64encodeSingleLine((byte[])pkcs10.toByteArray()));
            }
            logger.info("Request:\n" + certEnrollmentRequest);
            CertRequestInfos infos = certClient.enrollRequest(certEnrollmentRequest, aid, null);
            logger.info("Responses:");
            CertRequestInfo info = (CertRequestInfo)infos.getEntries().iterator().next();
            RequestId requestId = info.getRequestID();
            if (requestId == null) {
                requestId = info.getRequestId();
            }
            logger.info("- Request ID: " + requestId.toHexString());
            logger.info("  Type: " + info.getRequestType());
            logger.info("  Request Status: " + info.getRequestStatus());
            logger.info("  Operation Result: " + info.getOperationResult());
            String error = info.getErrorMessage();
            if (error != null) {
                throw new PKIException("Unable to generate certificate: " + error);
            }
            CertId id = null;
            if (info.getRequestStatus() == RequestStatus.COMPLETE) {
                id = info.getCertId();
            } else {
                CertReviewResponse reviewInfo = certClient.reviewRequest(requestId);
                certClient.approveRequest(requestId, reviewInfo);
                info = certClient.getRequest(requestId);
                id = info.getCertId();
            }
            logger.info("Serial number: " + id.toHexString());
            CertData certData = certClient.getCert(id);
            String certPem = certData.getEncoded();
            x509CertImpl = Cert.mapCert((String)certPem);
        }
        catch (Throwable throwable) {
            try {
                try {
                    pkiClient.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (PKIException e) {
                if (e.getCode() == Response.Status.UNAUTHORIZED.getStatusCode() || e.getCode() == Response.Status.FORBIDDEN.getStatusCode()) {
                    throw new PKIException("EST backend failed to authenticate to the CA subsystem, or is not authorized to issue the certificate", (Throwable)e);
                }
                throw e;
            }
            catch (Throwable e) {
                throw new PKIException("Internal error in /cacerts: " + e, e);
            }
        }
        pkiClient.close();
        return x509CertImpl;
    }
}

