/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps.processor;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.event.TokenPinResetEvent;
import com.netscape.certsrv.tps.token.TokenStatus;
import com.netscape.cmscore.logging.Auditor;
import java.io.IOException;
import org.dogtagpki.server.tps.TPSEngine;
import org.dogtagpki.server.tps.TPSEngineConfig;
import org.dogtagpki.server.tps.TPSSession;
import org.dogtagpki.server.tps.TPSSubsystem;
import org.dogtagpki.server.tps.TPSTokenPolicy;
import org.dogtagpki.server.tps.processor.AppletInfo;
import org.dogtagpki.server.tps.processor.TPSProcessor;
import org.dogtagpki.tps.main.TPSException;
import org.dogtagpki.tps.msg.BeginOpMsg;
import org.dogtagpki.tps.msg.EndOpMsg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TPSPinResetProcessor
extends TPSProcessor {
    public static Logger logger = LoggerFactory.getLogger(TPSPinResetProcessor.class);

    public TPSPinResetProcessor(TPSSession session) {
        super(session);
    }

    @Override
    public void process(BeginOpMsg beginMsg) throws TPSException, IOException {
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        String configName = "op.pinReset.testNoBeginMsg";
        boolean testPinResetNoBeginMsg = false;
        try {
            testPinResetNoBeginMsg = configStore.getBoolean(configName, false);
        }
        catch (EBaseException e) {
            testPinResetNoBeginMsg = false;
        }
        if (beginMsg == null || testPinResetNoBeginMsg) {
            throw new TPSException("TPSPinResetProcessor.process: invalid input data, no beginMsg provided.", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_RESET_PIN_PDU);
        }
        this.setBeginMessage(beginMsg);
        this.setCurrentTokenOperation("pinReset");
        this.checkIsExternalReg();
        this.resetPin();
    }

    /*
     * Unable to fully structure code
     */
    private void resetPin() throws TPSException, IOException {
        block27: {
            method = "TPSPinResetProcessor.resetPin(): ";
            TPSPinResetProcessor.logger.debug(method + ": entering...");
            logMsg = null;
            engine = TPSEngine.getInstance();
            tps = (TPSSubsystem)engine.getSubsystem("tps");
            appletInfo = null;
            tokenRecord = null;
            erAttrs = null;
            this.statusUpdate(10, "PROGRESS_START_PIN_RESET");
            try {
                appletInfo = this.getAppletInfo();
                this.auditOpRequest("pinReset", appletInfo, "success", null);
            }
            catch (TPSException e) {
                logMsg = e.toString();
                this.auditOpRequest("pinReset", appletInfo, "failure", (String)logMsg);
                tps.tdb.tdbActivity("pin_reset", tokenRecord, this.session.getIpAddress(), (String)logMsg, "failure");
                throw e;
            }
            appletInfo.setAid(this.getCardManagerAID());
            TPSPinResetProcessor.logger.debug(method + " token cuid: " + appletInfo.getCUIDhexStringPlain());
            tokenRecord = this.isTokenRecordPresent(appletInfo);
            if (tokenRecord == null) {
                logMsg = method + "Token does not exist!";
                this.auditPinResetFailure(this.session.getIpAddress(), this.userid, appletInfo, (String)logMsg);
                tps.tdb.tdbActivity("pin_reset", tokenRecord, this.session.getIpAddress(), (String)logMsg, "failure");
                TPSPinResetProcessor.logger.error((String)logMsg);
                throw new TPSException((String)logMsg + EndOpMsg.TPSStatus.STATUS_ERROR_UNKNOWN_TOKEN);
            }
            this.fillTokenRecord(tokenRecord, appletInfo);
            this.session.setTokenRecord(tokenRecord);
            cuid = appletInfo.getCUIDhexStringPlain();
            tokenType = null;
            tokenPolicy = new TPSTokenPolicy(tps, cuid);
            if (!this.isExternalReg) break block27;
            TPSPinResetProcessor.logger.debug(method + " isExternalReg: ON");
            configStore = engine.getConfig();
            configName = "externalReg.authId";
            try {
                authId = configStore.getString(configName);
            }
            catch (EBaseException e) {
                TPSPinResetProcessor.logger.debug(method + " Internal Error obtaining mandatory config values. Error: " + e);
                logMsg = "TPS error getting config values from config store." + e.toString();
                tps.tdb.tdbActivity("pin_reset", tokenRecord, this.session.getIpAddress(), (String)logMsg, "failure");
                throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
            }
            userAuth = null;
            try {
                TPSPinResetProcessor.logger.debug(method + " isExternalReg: calling requestUserId");
                userAuth = this.getAuthentication(authId);
                this.processAuthentication("pinReset", userAuth, cuid, tokenRecord);
                this.auditAuthSuccess(this.userid, this.currentTokenOperation, appletInfo, authId);
            }
            catch (Exception e) {
                this.auditAuthFailure(this.userid, this.currentTokenOperation, appletInfo, userAuth != null ? userAuth.getID() : null);
                TPSPinResetProcessor.logger.debug(method + ": authentication exception thrown: " + e);
                logMsg = "ExternalReg authentication failed, status = STATUS_ERROR_LOGIN";
                tps.tdb.tdbActivity("pin_reset", tokenRecord, this.session.getIpAddress(), (String)logMsg, "failure");
                throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_LOGIN);
            }
            try {
                erAttrs = this.processExternalRegAttrs(authId);
            }
            catch (Exception ee) {
                logMsg = "after processExternalRegAttrs: " + ee.toString();
                tps.tdb.tdbActivity("pin_reset", tokenRecord, this.session.getIpAddress(), (String)logMsg, "failure");
                throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
            }
            TPSPinResetProcessor.logger.debug(method + " checking if record registrationtype matches currentTokenOperation.");
            if (erAttrs.getRegistrationType() == null || erAttrs.getRegistrationType().length() <= 0) ** GOTO lbl74
            if (erAttrs.getRegistrationType().equalsIgnoreCase(this.currentTokenOperation)) {
                TPSPinResetProcessor.logger.debug(method + " --> registrationtype matches currentTokenOperation");
            } else {
                TPSPinResetProcessor.logger.debug(method + " Error: registrationType " + erAttrs.getRegistrationType() + " does not match currentTokenOperation " + this.currentTokenOperation);
                logMsg = "Improper Use of CRI, Enrollment CRI used for PIN Reset";
                tps.tdb.tdbActivity("pin_reset", tokenRecord, this.session.getIpAddress(), (String)logMsg, "failure");
                throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_LOGIN);
lbl74:
                // 1 sources

                TPSPinResetProcessor.logger.debug(method + " --> registrationtype attribute disabled or not found, continuing.");
            }
            if (erAttrs.getTokenCUID() == null) ** GOTO lbl87
            TPSPinResetProcessor.logger.debug(method + " checking if token cuid matches record cuid");
            TPSPinResetProcessor.logger.debug(method + " erAttrs.getTokenCUID()=" + erAttrs.getTokenCUID());
            TPSPinResetProcessor.logger.debug(method + " tokenRecord.getId()=" + tokenRecord.getId());
            if (tokenRecord.getId().equalsIgnoreCase(erAttrs.getTokenCUID())) {
                logMsg = "isExternalReg: token CUID matches record";
                TPSPinResetProcessor.logger.debug(method + (String)logMsg);
            } else {
                logMsg = "isExternalReg: token CUID not matching record:" + tokenRecord.getId() + " : " + erAttrs.getTokenCUID();
                TPSPinResetProcessor.logger.error(method + (String)logMsg);
                tps.tdb.tdbActivity("pin_reset", tokenRecord, this.session.getIpAddress(), (String)logMsg, "failure");
                throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_NOT_TOKEN_OWNER);
lbl87:
                // 1 sources

                TPSPinResetProcessor.logger.debug(method + " no need to check if token cuid matches record");
            }
            this.session.setExternalRegAttrs(erAttrs);
            this.setExternalRegSelectedTokenType(erAttrs);
            TPSPinResetProcessor.logger.debug(method + " isExternalReg: about to process keySet resolver");
            try {
                resolverInstName = this.getKeySetResolverInstanceName();
                if (resolverInstName.equals("none") || this.selectedKeySet != null) ** GOTO lbl123
                mappingParams = this.createFilterMappingParams(resolverInstName, appletInfo.getCUIDhexStringPlain(), appletInfo.getMSNString(), appletInfo.getMajorVersion(), appletInfo.getMinorVersion());
                subsystem = (TPSSubsystem)engine.getSubsystem("tps");
                resolverInst = subsystem.getMappingResolverManager().getResolverInstance(resolverInstName);
                keySet = resolverInst.getResolvedMapping(mappingParams, "keySet");
                this.setSelectedKeySet(keySet);
                TPSPinResetProcessor.logger.debug(method + " resolved keySet: " + keySet);
            }
            catch (TPSException e) {
                logMsg = e.toString();
                this.auditPinResetFailure(this.session.getIpAddress(), this.userid, appletInfo, (String)logMsg);
                tps.tdb.tdbActivity("pin_reset", tokenRecord, this.session.getIpAddress(), (String)logMsg, "failure");
                throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
            }
        }
        TPSPinResetProcessor.logger.debug(method + " isExternalReg: OFF");
        try {
            resolverInstName = this.getResolverInstanceName();
            if (!resolverInstName.equals("none") && this.selectedTokenType == null) {
                mappingParams = this.createFilterMappingParams(resolverInstName, appletInfo.getCUIDhexStringPlain(), appletInfo.getMSNString(), appletInfo.getMajorVersion(), appletInfo.getMinorVersion());
                subsystem = (TPSSubsystem)engine.getSubsystem("tps");
                resolverInst = subsystem.getMappingResolverManager().getResolverInstance(resolverInstName);
                tokenType = resolverInst.getResolvedMapping(mappingParams);
                this.setSelectedTokenType(tokenType);
                TPSPinResetProcessor.logger.debug(method + " resolved tokenType: " + tokenType);
            }
        }
        catch (TPSException e) {
            logMsg = e.toString();
            this.auditPinResetFailure(this.session.getIpAddress(), this.userid, appletInfo, (String)logMsg);
            tps.tdb.tdbActivity("pin_reset", tokenRecord, this.session.getIpAddress(), (String)logMsg, "failure");
            throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
lbl123:
        // 3 sources

        this.statusUpdate(15, "PROGRESS_PIN_RESET_RESOLVE_PROFILE");
        this.checkProfileStateOK();
        if (!this.isExternalReg) {
            this.checkAndAuthenticateUser(appletInfo, tokenType);
        }
        status = tokenRecord.getTokenStatus();
        TPSPinResetProcessor.logger.debug(method + ": Token status: " + status);
        this.checkInvalidTokenStatus(tokenRecord, "pin_reset");
        if (!status.equals((Object)TokenStatus.ACTIVE)) {
            logMsg = method + "Can not reset the pin of a non active token.";
            this.auditPinResetFailure(this.session.getIpAddress(), this.userid, appletInfo, (String)logMsg);
            throw new TPSException(method + " Attempt to reset pin of token not currently active!", EndOpMsg.TPSStatus.STATUS_ERROR_NOT_PIN_RESETABLE);
        }
        pinResetAllowed = tokenPolicy.isAllowedPinReset();
        TPSPinResetProcessor.logger.debug(method + ": PinResetPolicy: Pin Reset Allowed:  " + pinResetAllowed);
        logMsg = method + " PinReset Policy forbids pin reset operation.";
        if (!pinResetAllowed) {
            this.auditPinResetFailure(this.session.getIpAddress(), this.userid, appletInfo, (String)logMsg);
            throw new TPSException(method + " Attempt to reset pin when token policy disallows it.!", EndOpMsg.TPSStatus.STATUS_ERROR_NOT_PIN_RESETABLE);
        }
        this.checkAndUpgradeApplet(appletInfo);
        appletInfo = this.getAppletInfo();
        channel = this.checkAndUpgradeSymKeys(appletInfo, tokenRecord);
        channel.externalAuthenticate();
        this.checkAndHandlePinReset(channel);
        this.auditPinResetSuccess(this.session.getIpAddress(), this.userid, appletInfo, channel.getKeyInfoData().toHexStringPlain());
        this.statusUpdate(100, "PROGRESS_PIN_RESET_COMPLETE");
        logMsg = "update token during pin reset";
        configStore = engine.getConfig();
        configName = "op.pinReset.testUpdateDBFailure";
        testUpdateDBFailure = false;
        try {
            testUpdateDBFailure = configStore.getBoolean(configName, false);
        }
        catch (EBaseException e) {
            testUpdateDBFailure = false;
        }
        try {
            if (testUpdateDBFailure) {
                throw new Exception("Test failure to update DB for Pin Reset!");
            }
            tps.tdb.tdbUpdateTokenEntry(tokenRecord);
            tps.tdb.tdbActivity("pin_reset", tokenRecord, this.session.getIpAddress(), (String)logMsg, "success");
            TPSPinResetProcessor.logger.debug(method + ": token record updated!");
        }
        catch (Exception e) {
            logMsg = (String)logMsg + ":" + e.toString();
            tps.tdb.tdbActivity("pin_reset", tokenRecord, this.session.getIpAddress(), (String)logMsg, "failure");
            throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_UPDATE_TOKENDB_FAILED);
        }
        if (tokenPolicy.isAllowedResetPinResetToNo()) {
            tokenPolicy.setAllowedPinReset(false);
            tokenPolicy.updatePolicySet();
            TPSPinResetProcessor.logger.debug("{}: Updating pin reset policy to NO.", (Object)method);
        }
        TPSPinResetProcessor.logger.debug("{}: Token Pin successfully reset!", (Object)method);
    }

    protected void auditPinResetSuccess(String ip, String subjectID, AppletInfo aInfo, String keyVersion) {
        TPSEngine engine = TPSEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        TokenPinResetEvent event = TokenPinResetEvent.success((String)ip, (String)subjectID, (String)(aInfo != null ? aInfo.getCUIDhexStringPlain() : null), (String)this.getSelectedTokenType(), (String)(aInfo != null ? aInfo.getFinalAppletVersion() : null), (String)keyVersion);
        auditor.log((LogEvent)event);
    }

    protected void auditPinResetFailure(String ip, String subjectID, AppletInfo aInfo, String info) {
        TPSEngine engine = TPSEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        TokenPinResetEvent event = TokenPinResetEvent.failure((String)ip, (String)subjectID, (String)(aInfo != null ? aInfo.getCUIDhexStringPlain() : null), (String)this.getSelectedTokenType(), (String)(aInfo != null ? aInfo.getFinalAppletVersion() : null), (String)info);
        auditor.log((LogEvent)event);
    }

    public static void main(String[] args) {
    }
}

